/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.ui;

import java.awt.Dimension;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.ui.CommonPasswordPanel;
import org.netbeans.modules.payara.common.ui.ComponentFieldListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PayaraPassword
extends CommonPasswordPanel {
    private static final Logger LOGGER = PayaraLogger.get(PayaraPassword.class);
    private final String passwordVerifyLabelText = NbBundle.getMessage(PayaraPassword.class, (String)"PayaraPassword.passwordVerifyLabel");
    private JLabel messageLabel;
    private JPasswordField password;
    private JLabel passwordLabel;
    private JPasswordField passwordVerify;
    private JLabel passwordVerifyLabel;
    private JLabel userLabel;
    private JTextField userText;

    public static String setPassword(PayaraInstance instance) {
        String title = NbBundle.getMessage(PayaraPassword.class, (String)"PayaraPassword.title");
        String message = NbBundle.getMessage(PayaraPassword.class, (String)"PayaraPassword.message", (Object)instance.getDisplayName());
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(null, title, 2, -1, null, null);
        PayaraPassword panel = new PayaraPassword(notifyDescriptor, instance, message);
        Object button = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (button == NotifyDescriptor.CANCEL_OPTION) {
            return null;
        }
        String password = panel.getPassword();
        instance.setAdminPassword(password);
        try {
            PayaraInstance.writeInstanceToFile(instance);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Could not store Payara server attributes", ex);
        }
        return password;
    }

    public PayaraPassword(NotifyDescriptor descriptor, PayaraInstance instance, String message) {
        super(descriptor, instance, message);
        this.initComponents();
        this.initFileds(this.passwordValid());
        this.password.getDocument().addDocumentListener(this.initPasswordValidateListener());
        this.passwordVerify.getDocument().addDocumentListener(this.initPasswordValidateListener());
    }

    String getPassword() {
        return new String(this.password.getPassword());
    }

    final boolean passwordValid() {
        char[] password2;
        char[] password1 = this.password.getPassword();
        if (password1.length == (password2 = this.passwordVerify.getPassword()).length) {
            boolean valid = true;
            for (int i = 0; valid && i < password1.length; ++i) {
                valid = password1[i] == password2[i];
            }
            return valid;
        }
        return false;
    }

    private DocumentListener initPasswordValidateListener() {
        return new ComponentFieldListener(){

            @Override
            void processEvent() {
                PayaraPassword.this.valid = PayaraPassword.this.passwordValid();
                PayaraPassword.this.setDescriptorButtons(PayaraPassword.this.descriptor, PayaraPassword.this.valid);
            }
        };
    }

    public void clear() {
        this.password.setText("");
        this.passwordVerify.setText("");
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordVerifyLabel = new JLabel();
        this.userText = new JTextField();
        this.password = new JPasswordField();
        this.passwordVerify = new JPasswordField();
        this.setMaximumSize(new Dimension(500, 200));
        this.setMinimumSize(new Dimension(500, 150));
        this.setPreferredSize(new Dimension(500, 150));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.message);
        this.messageLabel.setPreferredSize(new Dimension(15, 15));
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)this.userLabelText);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)this.passwordLabelText);
        Mnemonics.setLocalizedText((JLabel)this.passwordVerifyLabel, (String)this.passwordVerifyLabelText);
        this.userText.setEditable(false);
        this.userText.setText(this.instance.getAdminUser());
        this.password.setText(this.instance.getAdminPassword());
        this.passwordVerify.setText(this.instance.getAdminPassword());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.userLabel, -1, 150, Short.MAX_VALUE).addComponent(this.passwordLabel, -1, -1, Short.MAX_VALUE).addComponent(this.passwordVerifyLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userText, -1, 314, Short.MAX_VALUE).addComponent(this.password).addComponent(this.passwordVerify)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.userLabel).addComponent(this.userText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.passwordLabel).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.passwordVerifyLabel).addComponent(this.passwordVerify, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

