/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.payara.common.PortCollection;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.common.wizards.AddServerLocationVisualPanel;
import org.netbeans.modules.payara.common.wizards.ServerWizardIterator;
import org.netbeans.modules.payara.spi.Utils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AddServerLocationPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddServerLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private AtomicBoolean isValidating = new AtomicBoolean();
    private static Pattern ILLEGAL_WINDOWS_CHARS = Pattern.compile("<|>|\\\"");

    public AddServerLocationPanel(ServerWizardIterator wizardIterator) {
        this.wizardIterator = wizardIterator;
        this.wizard = null;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    private void fireChangeEvent(ChangeEvent ev) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerLocationVisualPanel(this.wizardIterator);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        FileObject fo = FileUtil.getConfigFile((String)"Services/JavaHelp/org-netbeans-modules-usersguide-helpset.xml");
        if (null != fo) {
            return new HelpCtx("registering_app_server_hk2_location");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean isValid() {
        block28: {
            block27: {
                block30: {
                    block26: {
                        block25: {
                            block29: {
                                block24: {
                                    block22: {
                                        block23: {
                                            block21: {
                                                block20: {
                                                    if (!this.isValidating.compareAndSet(false, true)) break block28;
                                                    this.wizardIterator.setHttpPort(-1);
                                                    panel = (AddServerLocationVisualPanel)this.getComponent();
                                                    downloadState = panel.getDownloadState();
                                                    if (downloadState != AddServerLocationVisualPanel.DownloadState.DOWNLOADING) break block20;
                                                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)panel.getStatusText());
                                                    var3_3 = false;
                                                    this.isValidating.set(false);
                                                    return var3_3;
                                                }
                                                locationStr = panel.getHk2HomeLocation();
                                                v0 = locationStr = locationStr != null ? locationStr.trim() : null;
                                                if (locationStr != null && locationStr.length() != 0) break block21;
                                                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_BlankInstallDir"));
                                                var4_5 = false;
                                                this.isValidating.set(false);
                                                return var4_5;
                                            }
                                            installDir = new File(locationStr).getAbsoluteFile();
                                            payaraDir = this.getPayaraRoot(installDir);
                                            domainDir = this.getDefaultDomain(payaraDir);
                                            message = new StringBuilder();
                                            if (this.wizardIterator.downloadableValues.isEmpty()) {
                                                message.append(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_UnableToConnectPayaraMavenRepo")).append(" ");
                                                panel.updateMessageText(message.toString());
                                            }
                                            if (installDir.exists()) break block22;
                                            if (AddServerLocationPanel.isLegalFolder(installDir)) break block23;
                                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirInvalid", (Object)locationStr));
                                            var8_10 = false;
                                            this.isValidating.set(false);
                                            return var8_10;
                                        }
                                        if (AddServerLocationPanel.canCreate(installDir)) {
                                            if (downloadState == AddServerLocationVisualPanel.DownloadState.AVAILABLE) {
                                                message.append(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_NewInstallDirCanBeUsed", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                                                panel.updateMessageText(message.toString());
                                                this.wizard.putProperty("WizardPanel_errorMessage", (Object)panel.getStatusText());
                                                var8_11 = false;
                                                return var8_11;
                                            }
                                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirDoesNotExist", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                                            var8_12 = false;
                                            return var8_12;
                                        }
                                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_CannotCreate", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                                        var8_13 = false;
                                        return var8_13;
                                    }
                                    candidate = this.wizardIterator.isValidInstall(installDir, payaraDir, this.wizard);
                                    if (null != candidate) break block24;
                                    errMsg = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallationInvalid", (Object)FileUtil.normalizeFile((File)installDir).getPath());
                                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)errMsg);
                                    var10_19 = false;
                                    this.isValidating.set(false);
                                    return var10_19;
                                }
                                if (AddServerLocationPanel.isRegisterableDomain(domainDir)) break block29;
                                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_DefaultDomainInvalid", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                                ** GOTO lbl109
                            }
                            Util.readServerConfiguration(domainDir, this.wizardIterator);
                            if (installDir.equals(payaraDir)) {
                                installDir = payaraDir.getParentFile();
                            }
                            this.wizardIterator.setInstallRoot(installDir.getAbsolutePath());
                            this.wizardIterator.setPayaraRoot(payaraDir.getAbsolutePath());
                            uri = this.wizardIterator.formatUri("localhost", this.wizardIterator.getAdminPort(), this.wizardIterator.getTargetValue(), domainDir.getParentFile().getAbsolutePath(), domainDir.getName());
                            if (-1 != this.wizardIterator.getHttpPort()) break block25;
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainDir.getName()));
                            var10_20 = false;
                            this.isValidating.set(false);
                            return var10_20;
                        }
                        if (-1 != this.wizardIterator.getAdminPort()) break block26;
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainDir.getName()));
                        var10_21 = false;
                        this.isValidating.set(false);
                        return var10_21;
                    }
                    if (!this.wizardIterator.hasServer(uri)) break block30;
                    this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_DefaultDomainExists", (Object)AddServerLocationPanel.getSanitizedPath(installDir), (Object)"domain1"));
                    this.wizardIterator.setHttpPort(-1);
                    ** GOTO lbl109
                }
                statusText = panel.getStatusText();
                if (statusText == null || statusText.length() <= 0) break block27;
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)statusText);
                var11_23 = false;
                this.isValidating.set(false);
                return var11_23;
            }
            try {
                try {
                    this.wizard.putProperty("WizardPanel_errorMessage", null);
                    this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_NextForSpecial", (Object)candidate));
                }
                catch (UnsupportedClassVersionError error) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidJDKVersion"));
                }
lbl109:
                // 4 sources

                if (installDir.equals(payaraDir)) {
                    installDir = payaraDir.getParentFile();
                }
                this.wizardIterator.setInstallRoot(installDir.getAbsolutePath());
                this.wizardIterator.setPayaraRoot(payaraDir.getAbsolutePath());
                this.wizardIterator.setDomainLocation(domainDir.getAbsolutePath());
                var8_16 = true;
                this.isValidating.set(false);
                return var8_16;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return false;
    }

    private static String getSanitizedPath(File dir) {
        return FileUtil.normalizeFile((File)dir).getPath();
    }

    private static boolean isLegalFolder(File installDir) {
        return AddServerLocationPanel.getCanonicalFile(installDir) != null && (!Utilities.isWindows() || !ILLEGAL_WINDOWS_CHARS.matcher(installDir.getPath()).find());
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            return null;
        }
    }

    static boolean canCreate(File dir) {
        if (dir.exists()) {
            return false;
        }
        while (dir != null && !dir.exists()) {
            dir = dir.getParentFile();
        }
        return dir != null ? dir.canRead() && Utils.canWrite(dir) : false;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
    }

    public boolean isFinishPanel() {
        return false;
    }

    static boolean isRegisterableDomain(File domainDir, PortCollection portCollection) {
        File testFile = new File(domainDir, "logs");
        if (!testFile.exists()) {
            testFile = domainDir;
        }
        return Utils.canWrite(testFile) && Util.readServerConfiguration(domainDir, portCollection);
    }

    static boolean isRegisterableDomain(File domainDir) {
        return AddServerLocationPanel.isRegisterableDomain(domainDir, null);
    }

    private File getPayaraRoot(File installDir) {
        File glassfishDir = new File(installDir, "glassfish");
        if (!glassfishDir.exists()) {
            glassfishDir = installDir;
        }
        return glassfishDir;
    }

    private File getDefaultDomain(File payaraDir) {
        File domainsDir;
        File[] candidates;
        File retVal = new File(payaraDir, "domains" + File.separator + "domain1");
        if (!AddServerLocationPanel.isRegisterableDomain(retVal) && null != (candidates = (domainsDir = new File(payaraDir, "domains")).listFiles()) && candidates.length > 0) {
            for (File c : candidates) {
                if (!AddServerLocationPanel.isRegisterableDomain(c)) continue;
                retVal = c;
                break;
            }
        }
        return retVal;
    }
}

