/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.spi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class Utils {
    public static final String VERSIONED_JAR_SUFFIX_MATCHER = "(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final int PORT_CHECK_TIMEOUT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File f) {
        if (Utilities.isWindows()) {
            boolean retVal = true;
            File tmp = null;
            if (!f.exists()) {
                retVal = false;
            } else if (f.isDirectory()) {
                try {
                    tmp = File.createTempFile("foo", ".tmp", f);
                }
                catch (IOException ex) {
                    retVal = false;
                }
                finally {
                    if (null != tmp) {
                        tmp.delete();
                    }
                }
            } else {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(f, true);
                }
                catch (FileNotFoundException ex) {
                    retVal = false;
                }
                finally {
                    if (null != fos) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            Logger.getLogger(Utils.class.getName()).log(Level.FINEST, null, ioe);
                        }
                    }
                }
            }
            return retVal;
        }
        return f.canWrite();
    }

    public static File getFileFromPattern(String jarNamePattern, File modulesDir) {
        assert (jarNamePattern != null) : "jarNamePattern should not be null";
        if (null == jarNamePattern) {
            Logger.getLogger("payara").log(Level.INFO, "caller passed invalid jarNamePattern", new NullPointerException("jarNamePattern"));
            return null;
        }
        assert (modulesDir != null) : "modulesDir  should not be null";
        if (null == modulesDir) {
            Logger.getLogger("payara").log(Level.INFO, "caller passed invalid param", new NullPointerException("modulesDir"));
            return null;
        }
        int subindex = jarNamePattern.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = jarNamePattern.substring(0, subindex);
            jarNamePattern = jarNamePattern.substring(subindex + 1);
            modulesDir = new File(modulesDir, subdir);
        }
        if (modulesDir.canRead() && modulesDir.isDirectory()) {
            String expressPattern = jarNamePattern.replace("(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar", ".jar");
            File candidate = new File(modulesDir, expressPattern);
            if (!"".equals(expressPattern) && candidate.exists()) {
                return candidate;
            }
            File[] candidates = modulesDir.listFiles(new VersionFilter(jarNamePattern));
            if (candidates != null && candidates.length > 0) {
                return candidates[0];
            }
        }
        return null;
    }

    public static String sanitizeName(String name) {
        if (null == name || name.matches("[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;#:]*")) {
            return name;
        }
        return "_" + name.replaceAll("[^\\p{L}\\p{N}\\-_./;#:]", "_");
    }

    public static final String escapePath(String path) {
        return path.replace("\\", "\\\\").replace("$", "\\$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalPortOccupied(int port) {
        ServerSocket ss = null;
        boolean retVal = true;
        try {
            ss = new ServerSocket(port);
            retVal = false;
        }
        catch (IOException iOException) {
        }
        finally {
            if (null != ss) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return retVal;
    }

    public static String getHttpListenerProtocol(String hostname, String port) {
        String retVal = "http";
        try {
            retVal = Utils.getHttpListenerProtocol(hostname, Integer.parseInt(port));
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger("payara").log(Level.INFO, "returning http due to exception", nfe);
        }
        return retVal;
    }

    public static String getHttpListenerProtocol(String hostname, int port) {
        String retVal = "http";
        try {
            if (Utils.isSecurePort(hostname, port)) {
                retVal = "https";
            }
        }
        catch (ConnectException ex) {
            Logger.getLogger("payara").log(Level.INFO, null, ex);
        }
        catch (SocketException ex) {
            Logger.getLogger("payara").log(Level.FINE, null, ex);
        }
        catch (SocketTimeoutException ex) {
            Logger.getLogger("payara").log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger("payara").log(Level.INFO, null, ex);
        }
        return retVal;
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return Utils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block3: {
            socket = new Socket();
            try {
                Logger.getLogger("payara-socket-connect-diagnostic").log(Level.FINE, "Using socket.connect", new Exception());
                socket.connect(new InetSocketAddress(hostname, port), 2000);
                socket.setSoTimeout(2000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block3;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        InputStream is = socket.getInputStream();
        String testQuery = "GET / HTTP/1.0";
        PrintWriter pw = new PrintWriter(socket.getOutputStream());
        pw.println(testQuery);
        pw.println();
        pw.flush();
        byte[] respArr = new byte[1024];
        boolean isSecure = true;
        while (is.read(respArr) != -1) {
            String resp = new String(respArr);
            if (Utils.checkHelper(resp)) continue;
            isSecure = false;
            break;
        }
        socket.close();
        return isSecure;
    }

    private static boolean checkHelper(String respText) {
        boolean isSecure = true;
        if (respText.startsWith("http/1.") || respText.startsWith("HTTP/1.")) {
            isSecure = false;
        } else if (respText.contains("<html")) {
            isSecure = false;
        } else if (respText.contains("</html")) {
            isSecure = false;
        } else if (respText.contains("connection: ")) {
            isSecure = false;
        }
        return isSecure;
    }

    public static void doCopy(FileObject from, FileObject toParent) throws IOException {
        if (null != from) {
            if (from.isFolder()) {
                FileObject copy = FileUtil.createFolder((FileObject)toParent, (String)from.getNameExt());
                FileObject[] kids = from.getChildren();
                for (int i = 0; i < kids.length; ++i) {
                    Utils.doCopy(kids[i], copy);
                }
            } else {
                assert (from.isData());
                FileObject target = toParent.getFileObject(from.getName(), from.getExt());
                if (null == target) {
                    FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
                }
            }
        }
    }

    public static boolean useGlassFishPrefix(String serverInstanceID) {
        if (null == serverInstanceID) {
            return true;
        }
        if (serverInstanceID.contains("deployer:pfv3ee6wc")) {
            return true;
        }
        return !serverInstanceID.contains("deployer:pfv3ee6");
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String namePattern) {
            this.pattern = Pattern.compile(namePattern);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }
}

