/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dists;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.dists.Bundle;
import org.netbeans.modules.gradle.dists.api.GradleDistProject;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class DistributionSourcesImpl
implements Sources {
    public static final String DISTRIBUTION_SOURCES = "distribution";
    private final Project proj;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl;
    private SourceGroup[] cache;
    private Set<String> dists;

    public DistributionSourcesImpl(Project proj) {
        this.proj = proj;
        this.pcl = evt -> {
            if (NbGradleProject.get((Project)proj).isUnloadable()) {
                return;
            }
            if ("ProjectInfo".equals(evt.getPropertyName()) || "resources".equals(evt.getPropertyName())) {
                this.checkChanges(true);
            }
        };
    }

    public SourceGroup[] getSourceGroups(String type) {
        if (DISTRIBUTION_SOURCES.equals(type)) {
            if (this.cache == null) {
                ArrayList<SourceGroup> ret = new ArrayList<SourceGroup>(2);
                GradleDistProject gdp = GradleDistProject.get(this.proj);
                if (gdp != null) {
                    this.dists = gdp.getAvailableDistributions();
                    for (String distribution : this.dists) {
                        FileObject rootFO = FileUtil.toFileObject((File)gdp.getDistributionSource(distribution));
                        if (rootFO == null) continue;
                        String displayName = "main".equals(distribution) ? Bundle.MAIN_DIST(distribution) : Bundle.OTHER_DIST(distribution);
                        String sgName = "main".equals(distribution) ? "01main" : "02" + distribution;
                        SourceGroup grp = GenericSources.group((Project)this.proj, (FileObject)rootFO, (String)sgName, (String)displayName, null, null);
                        ret.add(grp);
                    }
                }
                this.cache = ret.toArray(new SourceGroup[0]);
            }
            return this.cache;
        }
        return new SourceGroup[0];
    }

    private void checkChanges(boolean fireChanges) {
        boolean changed;
        boolean bl = changed = this.dists == null;
        if (GradleDistProject.get(this.proj) != null) {
            Set<String> newDists = GradleDistProject.get(this.proj).getAvailableDistributions();
            if (this.dists != null) {
                HashSet<String> enteringGroups = new HashSet<String>(newDists);
                HashSet<String> leavingGroups = new HashSet<String>(this.dists);
                HashSet<String> remainingGroups = new HashSet<String>(newDists);
                remainingGroups.retainAll(this.dists);
                enteringGroups.removeAll(remainingGroups);
                leavingGroups.removeAll(remainingGroups);
                changed = !leavingGroups.isEmpty() || !enteringGroups.isEmpty();
            }
            this.dists = newDists;
            if (changed) {
                this.cache = null;
            }
        }
        if (changed && fireChanges) {
            this.cs.fireChange();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.cs.hasListeners()) {
            NbGradleProject.addPropertyChangeListener((Project)this.proj, (PropertyChangeListener)this.pcl);
        }
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
        if (!this.cs.hasListeners()) {
            NbGradleProject.removePropertyChangeListener((Project)this.proj, (PropertyChangeListener)this.pcl);
        }
    }
}

