/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.DateDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

@ImportStatic(value={TemporalConstants.class})
public abstract class TemporalBalanceDateDurationRelativeNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callDateAddNode;
    @Node.Child
    private JSFunctionCallNode callDateUntilNode;

    protected TemporalBalanceDateDurationRelativeNode() {
    }

    public abstract DateDurationRecord execute(double var1, double var3, double var5, double var7, TemporalUtil.Unit var9, TemporalUtil.Unit var10, JSTemporalPlainDateObject var11, CalendarMethodsRecord var12);

    @Specialization
    protected DateDurationRecord balanceDurationRelative(double years, double months, double weeks, double days, TemporalUtil.Unit largestUnit, TemporalUtil.Unit smallestUnit, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile unitIsYear, @Cached InlinedBranchProfile unitIsMonth, @Cached InlinedBranchProfile unitIsWeek, @Cached InlinedConditionProfile unitIsDay, @Cached(value="create(getLanguage().getJSContext(), LARGEST_UNIT)") CreateDataPropertyNode createLargestUnitProperty) {
        boolean allZero = years == 0.0 && months == 0.0 && weeks == 0.0 && days == 0.0;
        if (unitIsDay.profile((Node)this, largestUnit != TemporalUtil.Unit.YEAR && largestUnit != TemporalUtil.Unit.MONTH && largestUnit != TemporalUtil.Unit.WEEK || allZero)) {
            return new DateDurationRecord(years, months, weeks, days);
        }
        if (plainRelativeTo == null) {
            errorBranch.enter((Node)this);
            throw TemporalErrors.createRangeErrorRelativeToNotUndefined();
        }
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSObject untilOptions = JSOrdinary.createWithNullPrototype(ctx);
        createLargestUnitProperty.executeVoid((Object)untilOptions, largestUnit.toTruffleString());
        switch (largestUnit) {
            case YEAR: {
                unitIsYear.enter((Node)this);
                return this.getUnitYear(years, months, weeks, days, smallestUnit, plainRelativeTo, calendarRec, untilOptions, this, errorBranch, ctx, realm);
            }
            case MONTH: {
                unitIsMonth.enter((Node)this);
                return this.getUnitMonth(years, months, weeks, days, smallestUnit, plainRelativeTo, calendarRec, untilOptions, this, errorBranch, ctx, realm);
            }
            case WEEK: {
                unitIsWeek.enter((Node)this);
                return this.getUnitWeek(years, months, weeks, days, plainRelativeTo, calendarRec, untilOptions, this, errorBranch, ctx, realm);
            }
        }
        throw Errors.shouldNotReachHereUnexpectedValue((Object)largestUnit);
    }

    private DateDurationRecord getUnitYear(double years, double months, double weeks, double days, TemporalUtil.Unit smallestUnit, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, JSObject untilOptions, Node node, InlinedBranchProfile errorBranch, JSContext ctx, JSRealm realm) {
        if (smallestUnit == TemporalUtil.Unit.WEEK) {
            assert (days == 0.0) : days;
            JSTemporalDurationObject yearsMonthsDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, yearsMonthsDuration, node, errorBranch);
            JSTemporalDurationObject untilResult = this.calendarDateUntil(calendarRec, plainRelativeTo, later, untilOptions);
            return new DateDurationRecord(untilResult.getYears(), untilResult.getMonths(), weeks, days);
        }
        JSTemporalDurationObject yearsMonthsWeeksDaysDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, yearsMonthsWeeksDaysDuration, node, errorBranch);
        JSTemporalDurationObject untilResult = this.calendarDateUntil(calendarRec, plainRelativeTo, later, untilOptions);
        return new DateDurationRecord(untilResult.getYears(), untilResult.getMonths(), untilResult.getWeeks(), untilResult.getDays());
    }

    private DateDurationRecord getUnitMonth(double years, double months, double weeks, double days, TemporalUtil.Unit smallestUnit, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, JSObject untilOptions, Node node, InlinedBranchProfile errorBranch, JSContext ctx, JSRealm realm) {
        assert (years == 0.0) : years;
        if (smallestUnit == TemporalUtil.Unit.WEEK) {
            assert (days == 0.0) : days;
            return new DateDurationRecord(years, months, weeks, days);
        }
        JSTemporalDurationObject monthsWeeksDaysDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, monthsWeeksDaysDuration, node, errorBranch);
        JSTemporalDurationObject untilResult = this.calendarDateUntil(calendarRec, plainRelativeTo, later, untilOptions);
        return new DateDurationRecord(years, untilResult.getMonths(), untilResult.getWeeks(), untilResult.getDays());
    }

    private DateDurationRecord getUnitWeek(double years, double months, double weeks, double days, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, JSObject untilOptions, Node node, InlinedBranchProfile errorBranch, JSContext ctx, JSRealm realm) {
        assert (years == 0.0) : years;
        assert (months == 0.0) : months;
        JSTemporalDurationObject weeksDaysDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, weeksDaysDuration, node, errorBranch);
        JSTemporalDurationObject untilResult = this.calendarDateUntil(calendarRec, plainRelativeTo, later, untilOptions);
        return new DateDurationRecord(years, months, untilResult.getWeeks(), untilResult.getDays());
    }

    protected JSTemporalPlainDateObject calendarDateAdd(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject plainDate, JSTemporalDurationObject duration, Node node, InlinedBranchProfile errorBranch) {
        if (this.callDateAddNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callDateAddNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        Object addedDate = this.callDateAddNode.executeCall(JSArguments.create((Object)calendarRec.receiver(), calendarRec.dateAdd(), new Object[]{plainDate, duration}));
        return TemporalUtil.requireTemporalDate(addedDate, node, errorBranch);
    }

    protected JSTemporalDurationObject calendarDateUntil(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject one, JSTemporalPlainDateObject two, JSDynamicObject options) {
        if (this.callDateUntilNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callDateUntilNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        Object addedDate = this.callDateUntilNode.executeCall(JSArguments.create((Object)calendarRec.receiver(), calendarRec.dateUntil(), new Object[]{one, two, options}));
        return TemporalUtil.requireTemporalDuration(addedDate);
    }
}

