/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.lang.model.element.Modifier;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellEvent;
import org.netbeans.modules.jshell.env.ShellListener;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.env.ShellStatus;
import org.netbeans.modules.jshell.support.Bundle;
import org.netbeans.modules.jshell.support.PersistentSnippets;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.jshell.support.SnippetFileSystem;
import org.netbeans.modules.jshell.support.SnippetStorage;
import org.netbeans.modules.jshell.support.SnippetsFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Lookup;

public class PersistentSnippetsSupport {
    private static final PersistentSnippets EMPTY = new PersistentSnippets(){

        @Override
        public Collection<FileObject> getSavedClasses(String s) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public FileObject savedClassFolder(String name) {
            return null;
        }

        @Override
        public FileObject saveClass(String name, String description, InputStream contents) {
            return null;
        }

        @Override
        public String getDescription(FileObject saved) {
            return null;
        }

        @Override
        public void setDescription(FileObject saved, String desc) {
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public Collection<FileObject> startupSnippets(String action) {
            return Collections.emptyList();
        }
    };
    private final Lookup lookup;
    private final Project prj;
    private PersistentSnippets delegate;
    private static final Map<Project, Reference<PersistentSnippets>> cache = new WeakHashMap<Project, Reference<PersistentSnippets>>();
    private static StartupSnippetsTracker tracker;
    private static final String RUN_METHOD = "run";
    private static final PersistentSnippets GLOBAL;

    public PersistentSnippetsSupport(Lookup lookup, Project prj, PersistentSnippets delegate) {
        this.lookup = lookup;
        this.prj = prj;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        Class<PersistentSnippetsSupport> clazz = PersistentSnippetsSupport.class;
        synchronized (PersistentSnippetsSupport.class) {
            if (tracker != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            tracker = new StartupSnippetsTracker();
            // ** MonitorExit[var0] (shouldn't be in output)
            ShellRegistry.get().addShellListener(tracker);
            Collection<JShellEnvironment> envs = ShellRegistry.get().openedShells(null);
            for (JShellEnvironment e : envs) {
                ShellStatus st = e.getStatus();
                switch (st) {
                    case INIT: 
                    case STARTING: {
                        e.addShellListener(tracker);
                        break;
                    }
                    case READY: 
                    case EXECUTE: {
                        PersistentSnippetsSupport.runStartupSnippets(e);
                    }
                }
            }
            return;
        }
    }

    private static void runStartupSnippets(JShellEnvironment env) {
        if (env == null || env.isClosed()) {
            return;
        }
        Lookup lkp = env.getLookup();
        PersistentSnippets supp = PersistentSnippetsSupport.create(lkp);
        if (supp == null) {
            return;
        }
        Collection<FileObject> snips = supp.startupSnippets(env.getMode());
        ShellSession s = env.getSession();
        if (s == null) {
            return;
        }
        for (FileObject sn : snips) {
            try {
                PersistentSnippetsSupport.runScript(sn, s, true);
            }
            catch (IOException ex) {
                s.reportErrorMessage(ex);
                break;
            }
        }
    }

    private static Project findProject(Lookup context) {
        FileObject f;
        Project prj = (Project)context.lookup(Project.class);
        if (prj == null && (f = (FileObject)context.lookup(FileObject.class)) != null) {
            File cache = Places.getCacheDirectory();
            FileObject cacheFO = FileUtil.toFileObject((File)cache);
            prj = FileOwnerQuery.getOwner((FileObject)f);
            if (cacheFO != null && prj != null && FileUtil.isParentOf((FileObject)prj.getProjectDirectory(), (FileObject)cacheFO)) {
                prj = null;
            }
        }
        return prj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregister(Project prj) {
        Map<Project, Reference<PersistentSnippets>> map = cache;
        synchronized (map) {
            cache.remove(prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentSnippets create(Lookup context) {
        PersistentSnippetsSupport.initialize();
        Project prj = PersistentSnippetsSupport.findProject(context);
        if (prj == null) {
            return GLOBAL;
        }
        PersistentSnippets snips = null;
        Map<Project, Reference<PersistentSnippets>> map = cache;
        synchronized (map) {
            Reference<PersistentSnippets> refS = cache.get(prj);
            if (refS != null) {
                snips = refS.get();
            }
            if (snips != null) {
                return snips;
            }
        }
        SnippetStorage storage = (SnippetStorage)prj.getLookup().lookup(SnippetStorage.class);
        if (storage == null) {
            return GLOBAL;
        }
        FileObject projectStorageDir = storage.getStorageFolder(false);
        if (projectStorageDir == null) {
            return GLOBAL;
        }
        try {
            SnippetFileSystem snipFS = new SnippetFileSystem(projectStorageDir, FileUtil.getConfigRoot(), storage.resourcePrefix(), "jshell-snippets");
            ProjectSnippetsFolder fld = new ProjectSnippetsFolder(snipFS.getRoot(), snipFS, storage, prj);
            snips = fld;
        }
        catch (IOException ex) {
            return GLOBAL;
        }
        if (snips == null) {
            return GLOBAL;
        }
        Map<Project, Reference<PersistentSnippets>> map2 = cache;
        synchronized (map2) {
            PersistentSnippets existing;
            Reference<PersistentSnippets> ref = cache.get(prj);
            if (ref != null && (existing = ref.get()) != null) {
                return existing;
            }
            cache.put(prj, new WeakReference<PersistentSnippets>(snips));
        }
        return snips;
    }

    public static void runScript(FileObject scriptFile, ShellSession session, boolean shared) throws IOException {
        JavaSource src = JavaSource.forFileObject((FileObject)scriptFile);
        if (src == null) {
            throw new IOException(Bundle.ERR_NoSourceFile(scriptFile.getPath()));
        }
        final StringBuilder sb = new StringBuilder();
        src.runUserActionTask((Task)new Task<CompilationController>(){
            CharSequence snapText;
            CompilationController ctrl;
            SourcePositions spos;

            private int printHeaderWithoutModifiers(int start, ModifiersTree mods) {
                int modsEnd = (int)this.spos.getEndPosition(this.ctrl.getCompilationUnit(), mods);
                int modsStart = (int)this.spos.getStartPosition(this.ctrl.getCompilationUnit(), mods);
                sb.append(this.snapText.subSequence(start, modsStart));
                for (AnnotationTree annotationTree : mods.getAnnotations()) {
                    int atStart = (int)this.spos.getStartPosition(this.ctrl.getCompilationUnit(), annotationTree);
                    int atEnd = (int)this.spos.getEndPosition(this.ctrl.getCompilationUnit(), annotationTree);
                    if (atStart == -1 || atEnd == -1) continue;
                    sb.append(this.snapText.subSequence(atStart, atEnd)).append("\n");
                }
                sb.append(" ");
                return modsEnd;
            }

            public void run(CompilationController ctrl) throws Exception {
                this.ctrl = ctrl;
                ctrl.toPhase(JavaSource.Phase.PARSED);
                List<? extends Tree> classes = ctrl.getCompilationUnit().getTypeDecls();
                if (classes.isEmpty()) {
                    return;
                }
                CompilationUnitTree cut = ctrl.getCompilationUnit();
                if (classes.size() > 1) {
                    throw new IOException(Bundle.ERR_UnexpectedFielContent());
                }
                for (ImportTree importTree : ctrl.getCompilationUnit().getImports()) {
                    sb.append(importTree).append("\n");
                }
                ClassTree ct = (ClassTree)classes.get(0);
                this.snapText = ctrl.getSnapshot().getText();
                this.spos = ctrl.getTrees().getSourcePositions();
                block6: for (Tree tree : ct.getMembers()) {
                    int start = (int)this.spos.getStartPosition(cut, tree);
                    int end = (int)this.spos.getEndPosition(cut, tree);
                    if (start == -1 || end == -1) continue;
                    switch (tree.getKind()) {
                        case METHOD: {
                            MethodTree mt = (MethodTree)tree;
                            if (mt.getName().contentEquals(PersistentSnippetsSupport.RUN_METHOD) && mt.getParameters().isEmpty()) {
                                BlockTree bt = mt.getBody();
                                if (bt == null || bt.getStatements().isEmpty()) continue block6;
                                Tree first = bt.getStatements().get(0);
                                Tree last = bt.getStatements().get(bt.getStatements().size() - 1);
                                start = (int)this.spos.getStartPosition(cut, first);
                                end = (int)this.spos.getEndPosition(cut, last);
                                break;
                            }
                            if (!mt.getModifiers().getFlags().contains((Object)Modifier.STATIC)) break;
                            start = this.printHeaderWithoutModifiers(start, ((MethodTree)tree).getModifiers());
                            break;
                        }
                        case CLASS: 
                        case INTERFACE: 
                        case ENUM: {
                            start = this.printHeaderWithoutModifiers(start, ((ClassTree)tree).getModifiers());
                            break;
                        }
                        case VARIABLE: {
                            start = this.printHeaderWithoutModifiers(start, ((VariableTree)tree).getModifiers());
                        }
                    }
                    sb.append(this.snapText.subSequence(start, end));
                    sb.append("\n");
                }
            }
        }, true);
        String execCommands = sb.toString();
        session.clearInputAndEvaluateExternal(execCommands, scriptFile.getName());
    }

    static {
        GLOBAL = new SnippetsFolder(FileUtil.getConfigRoot().getFileObject("jshell-snippets"));
    }

    private static class StartupSnippetsTracker
    implements ShellListener {
        private StartupSnippetsTracker() {
        }

        @Override
        public void shellCreated(ShellEvent ev) {
            ev.getEnvironment().addShellListener(this);
        }

        @Override
        public void shellStarted(ShellEvent ev) {
            PersistentSnippetsSupport.runStartupSnippets(ev.getEnvironment());
        }

        @Override
        public void shellStatusChanged(ShellEvent ev) {
        }

        @Override
        public void shellShutdown(ShellEvent ev) {
        }

        @Override
        public void shellSettingsChanged(ShellEvent ev) {
        }
    }

    static final class ProjectSnippetsFolder
    extends SnippetsFolder
    implements PropertyChangeListener {
        final SnippetStorage projectStorage;
        final Project project;

        public ProjectSnippetsFolder(FileObject parentFolder, Callable<FileObject> creator, SnippetStorage projectStorage, Project project) {
            super(parentFolder, creator);
            this.projectStorage = projectStorage;
            this.project = project;
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public Collection<FileObject> startupSnippets(String runAction) {
            String fld = this.projectStorage.startupSnippets(runAction);
            if (fld == null) {
                return GLOBAL.startupSnippets(runAction);
            }
            return this.getSavedClasses(fld);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"openProjects".equals(evt.getPropertyName())) {
                return;
            }
            if (!OpenProjects.getDefault().isProjectOpen(this.project)) {
                PersistentSnippetsSupport.unregister(this.project);
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

