/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import java.io.InvalidObjectException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.source.Source;
import org.openide.util.Exceptions;

public final class DebuggerSupport {
    public static final String DEBUGGER_SUPPORT_CLASS_JDK = "jdk.nashorn.internal.runtime.DebuggerSupport";
    public static final String DEBUGGER_SUPPORT_CLASS = "jdk.nashorn.internal.runtime.DebuggerSupport";
    private static final String DEBUGGER_SUPPORT_VALUE_DESC_CLASS_JDK = "jdk.nashorn.internal.runtime.DebuggerSupport$DebuggerValueDesc";
    private static final String CONTEXT_CLASS_JDK = "jdk.nashorn.internal.runtime.Context";
    public static final String DEBUGGER_SUPPORT_CLASS_EXT = "org.openjdk.nashorn.internal.runtime.DebuggerSupport";
    private static final String DEBUGGER_SUPPORT_VALUE_DESC_CLASS_EXT = "org.openjdk.nashorn.internal.runtime.DebuggerSupport$DebuggerValueDesc";
    private static final String CONTEXT_CLASS_EXT = "org.openjdk.nashorn.internal.runtime.Context";
    private static final String METHOD_VALUE_INFO = "valueInfo";
    private static final String SIGNAT_VALUE_INFO_JDK = "(Ljava/lang/String;Ljava/lang/Object;Z)Ljdk/nashorn/internal/runtime/DebuggerSupport$DebuggerValueDesc;";
    private static final String SIGNAT_VALUE_INFO_EXT = "(Ljava/lang/String;Ljava/lang/Object;Z)Lorg/openjdk/nashorn/internal/runtime/DebuggerSupport$DebuggerValueDesc;";
    private static final String METHOD_VALUE_INFOS = "valueInfos";
    private static final String SIGNAT_VALUE_INFOS_JDK = "(Ljava/lang/Object;Z)[Ljdk/nashorn/internal/runtime/DebuggerSupport$DebuggerValueDesc;";
    private static final String SIGNAT_VALUE_INFOS_EXT = "(Ljava/lang/Object;Z)[Lorg/openjdk/nashorn/internal/runtime/DebuggerSupport$DebuggerValueDesc;";
    private static final String METHOD_EVAL = "eval";
    private static final String SIGNAT_EVAL_JDK = "(Ljdk/nashorn/internal/runtime/ScriptObject;Ljava/lang/Object;Ljava/lang/String;Z)Ljava/lang/Object;";
    private static final String SIGNAT_EVAL_EXT = "(Lorg/openjdk/nashorn/internal/runtime/ScriptObject;Ljava/lang/Object;Ljava/lang/String;Z)Ljava/lang/Object;";
    private static final String METHOD_FROM_CLASS = "fromClass";
    private static final String SIGNAT_FROM_CLASS_JDK = "(Ljava/lang/Class;)Ljdk/nashorn/internal/runtime/Context;";
    private static final String SIGNAT_FROM_CLASS_EXT = "(Ljava/lang/Class;)Lorg/openjdk/nashorn/internal/runtime/Context;";
    private static final String METHOD_CONTEXT_EVAL = "eval";
    private static final String SIGNAT_CONTEXT_EVAL_JDK = "(Ljdk/nashorn/internal/runtime/ScriptObject;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String SIGNAT_CONTEXT_EVAL_OLD_JDK = "(Ljdk/nashorn/internal/runtime/ScriptObject;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;";
    private static final String SIGNAT_CONTEXT_EVAL_EXT = "(Lorg/openjdk/nashorn/internal/runtime/ScriptObject;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String SIGNAT_CONTEXT_EVAL_OLD_EXT = "(Lorg/openjdk/nashorn/internal/runtime/ScriptObject;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;";
    private static final String METHOD_VALUE_AS_STRING = "valueAsString";
    private static final String SIGNAT_VALUE_AS_STRING = "(Ljava/lang/Object;)Ljava/lang/String;";
    private static final String METHOD_SOURCE_INFO = "getSourceInfo";
    private static final String SIGNAT_SOURCE_INFO_JDK = "(Ljava/lang/Class;)Ljdk/nashorn/internal/runtime/DebuggerSupport$SourceInfo;";
    private static final String SIGNAT_SOURCE_INFO_EXT = "(Ljava/lang/Class;)Lorg/openjdk/nashorn/internal/runtime/DebuggerSupport$SourceInfo;";
    private static final String FIELD_DESC_VALUE_AS_STRING = "valueAsString";
    private static final String FIELD_DESC_KEY = "key";
    private static final String FIELD_DESC_EXPANDABLE = "expandable";
    private static final String FIELD_DESC_VALUE_AS_OBJECT = "valueAsObject";
    private static final List<Reference<JPDADebugger>> hasOldEval = new CopyOnWriteArrayList<Reference<JPDADebugger>>();

    private DebuggerSupport() {
    }

    static Variable getValueInfoDesc(JPDADebugger debugger, String name, Variable value, boolean all) {
        List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
        if (supportClasses.isEmpty()) {
            return null;
        }
        JPDAClassType supportClass = supportClasses.get(0);
        Variable[] args = new Variable[3];
        try {
            args[0] = debugger.createMirrorVar((Object)name);
            args[1] = value;
            args[2] = debugger.createMirrorVar((Object)all, true);
            return supportClass.invokeMethod(METHOD_VALUE_INFO, DebuggerSupport.isLegacyNashorn(supportClass) ? SIGNAT_VALUE_INFO_JDK : SIGNAT_VALUE_INFO_EXT, args);
        }
        catch (InvalidObjectException | InvalidExpressionException iex) {
            return null;
        }
        catch (NoSuchMethodException nsmex) {
            Exceptions.printStackTrace((Throwable)nsmex);
            return null;
        }
    }

    private static String removeQuotes(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    static String getDescriptionValue(Variable descVar) {
        Field valueAsStringField = ((ObjectVariable)descVar).getField("valueAsString");
        return DebuggerSupport.removeQuotes(valueAsStringField.getValue());
    }

    static Variable getDescriptionValueObject(Variable descVar) {
        return ((ObjectVariable)descVar).getField(FIELD_DESC_VALUE_AS_OBJECT);
    }

    static String getDescriptionKey(Variable descVar) {
        Field keyField = ((ObjectVariable)descVar).getField(FIELD_DESC_KEY);
        return DebuggerSupport.removeQuotes(keyField.getValue());
    }

    static boolean isDescriptionExpandable(Variable descVar) {
        Field expandableField = ((ObjectVariable)descVar).getField(FIELD_DESC_EXPANDABLE);
        return "true".equals(expandableField.getValue());
    }

    static Variable[] getValueInfos(JPDADebugger debugger, Variable scope, boolean all) {
        List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
        if (supportClasses.isEmpty()) {
            return null;
        }
        JPDAClassType supportClass = supportClasses.get(0);
        Variable[] args = new Variable[2];
        try {
            args[0] = scope;
            args[1] = debugger.createMirrorVar((Object)all, true);
            ObjectVariable infosVar = (ObjectVariable)supportClass.invokeMethod(METHOD_VALUE_INFOS, DebuggerSupport.isLegacyNashorn(supportClass) ? SIGNAT_VALUE_INFOS_JDK : SIGNAT_VALUE_INFOS_EXT, args);
            return infosVar.getFields(0, Integer.MAX_VALUE);
        }
        catch (InvalidObjectException ioex) {
            return null;
        }
        catch (NoSuchMethodException nsmex) {
            Exceptions.printStackTrace((Throwable)nsmex);
            return null;
        }
        catch (InvalidExpressionException iex) {
            return null;
        }
    }

    public static boolean hasSourceInfo(JPDADebugger debugger) {
        List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
        if (supportClasses.isEmpty()) {
            return false;
        }
        JPDAClassType supportClass = supportClasses.get(0);
        try {
            ReferenceType supportType = (ReferenceType)supportClass.getClass().getMethod("getType", new Class[0]).invoke((Object)supportClass, new Object[0]);
            Method getSourceInfoMethod = ((ClassType)supportType).concreteMethodByName(METHOD_SOURCE_INFO, DebuggerSupport.isLegacyNashorn(supportClass) ? SIGNAT_SOURCE_INFO_JDK : SIGNAT_SOURCE_INFO_EXT);
            return getSourceInfoMethod != null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        catch (ClassNotPreparedException | VMDisconnectedException ex) {
            return false;
        }
    }

    public static Variable getSourceInfo(JPDADebugger debugger, JPDAClassType classType) {
        List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
        if (supportClasses.isEmpty()) {
            return null;
        }
        JPDAClassType supportClass = supportClasses.get(0);
        try {
            Variable sourceInfo = supportClass.invokeMethod(METHOD_SOURCE_INFO, DebuggerSupport.isLegacyNashorn(supportClass) ? SIGNAT_SOURCE_INFO_JDK : SIGNAT_SOURCE_INFO_EXT, new Variable[]{classType.classObject()});
            return sourceInfo;
        }
        catch (NoSuchMethodException | InvalidExpressionException ex) {
            return null;
        }
    }

    public static Variable evaluate(JPDADebugger debugger, CallStackFrame frame, String expression) throws InvalidExpressionException {
        return DebuggerSupport.evaluate(debugger, frame, expression, null);
    }

    public static Variable evaluate(JPDADebugger debugger, CallStackFrame frame, String expression, ObjectVariable contextVar) throws InvalidExpressionException {
        try {
            return DebuggerSupport.doEvaluate(debugger, frame, expression, contextVar);
        }
        catch (InvalidExpressionException ieex) {
            String name;
            Throwable targetException = ieex.getTargetException();
            if (targetException == null) {
                throw ieex;
            }
            try {
                name = (String)targetException.getClass().getMethod("getOriginalLocalizedMessage", new Class[0]).invoke((Object)targetException, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                name = targetException.getLocalizedMessage();
            }
            throw new InvalidExpressionException(name, targetException, ieex.hasApplicationTarget());
        }
    }

    private static Variable doEvaluate(JPDADebugger debugger, CallStackFrame frame, String expression, ObjectVariable contextVar) throws InvalidExpressionException {
        List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
        if (supportClasses.isEmpty()) {
            return null;
        }
        JPDAClassType supportClass = supportClasses.get(0);
        LocalVariable scope = null;
        ObjectVariable thisVar = null;
        try {
            for (LocalVariable lv : frame.getLocalVariables()) {
                String name;
                switch (name = lv.getName()) {
                    case ":scope": {
                        scope = lv;
                        break;
                    }
                    case ":this": {
                        thisVar = (ObjectVariable)lv;
                    }
                }
                if (!name.equals(expression)) continue;
                return lv;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        if (contextVar == null) {
            contextVar = thisVar;
        }
        if (scope == null || contextVar == null) {
            throw new InvalidExpressionException("Missing scope");
        }
        Source source = Source.getSource(frame);
        JPDAClassType sourceClassType = source.getClassType();
        boolean legacyNashorn = DebuggerSupport.isLegacyNashorn(supportClass);
        List contextClassesByName = debugger.getClassesByName(legacyNashorn ? CONTEXT_CLASS_JDK : CONTEXT_CLASS_EXT);
        JPDAClassType contextClass = (JPDAClassType)contextClassesByName.get(0);
        Variable contextObj = null;
        try {
            contextObj = contextClass.invokeMethod(METHOD_FROM_CLASS, legacyNashorn ? SIGNAT_FROM_CLASS_JDK : SIGNAT_FROM_CLASS_EXT, new Variable[]{sourceClassType.classObject()});
        }
        catch (NoSuchMethodException nsmex) {
            Exceptions.printStackTrace((Throwable)nsmex);
        }
        if (contextObj != null) {
            boolean oldEval = DebuggerSupport.isOldEval(debugger);
            if (!oldEval) {
                try {
                    Variable[] args = new Variable[4];
                    try {
                        args[0] = scope;
                        args[1] = debugger.createMirrorVar((Object)expression);
                        args[2] = contextVar;
                        args[3] = null;
                    }
                    catch (InvalidObjectException ioex) {
                        Exceptions.printStackTrace((Throwable)ioex);
                        throw new InvalidExpressionException((Throwable)ioex);
                    }
                    return ((ObjectVariable)contextObj).invokeMethod("eval", legacyNashorn ? SIGNAT_CONTEXT_EVAL_JDK : SIGNAT_CONTEXT_EVAL_EXT, args);
                }
                catch (NoSuchMethodException nsmex) {
                    oldEval = true;
                    DebuggerSupport.setOldEval(debugger);
                }
            }
            if (oldEval) {
                try {
                    Variable[] args = new Variable[5];
                    try {
                        args[0] = scope;
                        args[1] = debugger.createMirrorVar((Object)expression);
                        args[2] = contextVar;
                        args[3] = null;
                        args[4] = debugger.createMirrorVar((Object)false, true);
                    }
                    catch (InvalidObjectException ioex) {
                        Exceptions.printStackTrace((Throwable)ioex);
                        throw new InvalidExpressionException((Throwable)ioex);
                    }
                    return ((ObjectVariable)contextObj).invokeMethod("eval", legacyNashorn ? SIGNAT_CONTEXT_EVAL_OLD_JDK : SIGNAT_CONTEXT_EVAL_OLD_EXT, args);
                }
                catch (NoSuchMethodException nsmex) {
                    Exceptions.printStackTrace((Throwable)nsmex);
                }
            }
        }
        Variable[] args = new Variable[4];
        try {
            args[0] = scope;
            args[1] = contextVar;
            args[2] = debugger.createMirrorVar((Object)expression);
            args[3] = debugger.createMirrorVar((Object)false, true);
            return supportClass.invokeMethod("eval", legacyNashorn ? SIGNAT_EVAL_JDK : SIGNAT_EVAL_EXT, args);
        }
        catch (InvalidObjectException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
            throw new InvalidExpressionException((Throwable)ioex);
        }
        catch (NoSuchMethodException nsmex) {
            Exceptions.printStackTrace((Throwable)nsmex);
            return null;
        }
    }

    private static boolean isOldEval(JPDADebugger debugger) {
        for (Reference<JPDADebugger> dbgRef : hasOldEval) {
            JPDADebugger dbg = dbgRef.get();
            if (dbg == null) {
                hasOldEval.remove(dbgRef);
                continue;
            }
            if (dbg != debugger) continue;
            return true;
        }
        return false;
    }

    private static void setOldEval(JPDADebugger debugger) {
        hasOldEval.add(new WeakReference<JPDADebugger>(debugger));
    }

    public static List<JPDAClassType> getSupportDebuggerClasses(JPDADebugger debugger) {
        List supportClasses = debugger.getClassesByName("jdk.nashorn.internal.runtime.DebuggerSupport");
        if (supportClasses.isEmpty()) {
            supportClasses = debugger.getClassesByName(DEBUGGER_SUPPORT_CLASS_EXT);
        }
        return supportClasses;
    }

    public static boolean isLegacyNashorn(JPDAClassType classType) {
        return classType.getName().startsWith("jdk.nashorn.internal.");
    }

    public static String getVarValue(JPDADebugger debugger, Variable var) {
        String str;
        block12: {
            if (var instanceof ObjectVariable) {
                JPDAClassType ct;
                ObjectVariable ov = (ObjectVariable)var;
                List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
                if (supportClasses.isEmpty() || (ct = ov.getClassType()) != null && String.class.getCanonicalName().equals(ct.getName())) {
                    try {
                        return ov.getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        break block12;
                    }
                }
                JPDAClassType supportClass = supportClasses.get(0);
                Variable[] args = new Variable[1];
                try {
                    args[0] = var;
                    var = supportClass.invokeMethod("valueAsString", SIGNAT_VALUE_AS_STRING, args);
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    try {
                        return ov.getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                    }
                }
                catch (InvalidExpressionException ex) {
                    try {
                        return ov.getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((str = var.getValue()).length() > 2 && str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static Variable getVarStringValueAsVar(JPDADebugger debugger, ObjectVariable ov) {
        List<JPDAClassType> supportClasses = DebuggerSupport.getSupportDebuggerClasses(debugger);
        if (supportClasses.isEmpty()) {
            return ov;
        }
        JPDAClassType supportClass = supportClasses.get(0);
        Variable[] args = new Variable[1];
        try {
            args[0] = ov;
            Variable strVar = supportClass.invokeMethod("valueAsString", SIGNAT_VALUE_AS_STRING, args);
            if (String.class.getName().equals(strVar.getType())) {
                return DebuggerSupport.adjustQuotes(debugger, (ObjectVariable)strVar);
            }
            return strVar;
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return ov;
        }
        catch (InvalidExpressionException iex) {
            return ov;
        }
    }

    private static Variable adjustQuotes(JPDADebugger debugger, ObjectVariable strVar) {
        String str = strVar.getValue();
        if ((str = str.substring(1, str.length() - 1)).length() > 2 && str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
            try {
                return debugger.createMirrorVar((Object)str);
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
        return strVar;
    }
}

