/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.ui.api;

import java.io.File;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.common.ui.api.Bundle;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;

public final class ExternalExecutableValidator {
    private ExternalExecutableValidator() {
    }

    public static boolean isValidCommand(@NullAllowed String command) {
        return ExternalExecutableValidator.validateCommand(command, null) == null;
    }

    public static String validateCommand(@NullAllowed String command, @NullAllowed String executableName) {
        String executable = null;
        if (command != null) {
            executable = (String)ExternalExecutable.parseCommand(command).first();
        }
        if (executableName == null) {
            return ExternalExecutableValidator.validateFile(executable, false);
        }
        return ExternalExecutableValidator.validateFile(executableName, executable, false);
    }

    @CheckForNull
    private static String validateFile(String filePath, boolean writable) {
        return ExternalExecutableValidator.validateFile(Bundle.ExternalExecutableValidator_validateFile_file(), filePath, writable);
    }

    @CheckForNull
    private static String validateFile(String source, String filePath, boolean writable) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return Bundle.ExternalExecutableValidator_validateFile_missing(source);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return Bundle.ExternalExecutableValidator_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.ExternalExecutableValidator_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.ExternalExecutableValidator_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.ExternalExecutableValidator_validateFile_notWritable(source);
        }
        return null;
    }
}

