/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.samples;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javafx2.samples.JavaFXSampleProjectGenerator;
import org.netbeans.modules.javafx2.samples.PanelConfigureProject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class JavaFXSampleProjectIterator
implements TemplateWizard.Iterator {
    private static final Logger LOG = Logger.getLogger(JavaFXSampleProjectIterator.class.getName());
    private static final long serialVersionUID = 4L;
    int currentIndex;
    PanelConfigureProject basicPanel;
    private transient WizardDescriptor wiz;

    static Object create() {
        return new JavaFXSampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.basicPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        String name = templateWizard.getTemplate().getNodeDelegate().getDisplayName();
        if (name != null) {
            name = name.replace(" ", "");
        }
        templateWizard.putProperty("name", (Object)name);
        this.basicPanel = new PanelConfigureProject(templateWizard.getTemplate().getNodeDelegate().getDisplayName());
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.basicPanel = null;
        this.currentIndex = -1;
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        FileObject docToOpen;
        File projectLocation = (File)this.wiz.getProperty("projdir");
        if (projectLocation == null) {
            this.warnIssue204880("Wizard property projdir is null.");
            throw new IOException();
        }
        String name = (String)this.wiz.getProperty("name");
        if (name == null) {
            this.warnIssue204880("Wizard property name is null.");
            throw new IOException();
        }
        String platformName = (String)this.wiz.getProperty("java.platform.name");
        if (platformName == null) {
            this.warnIssue204880("Wizard property java.platform.name is null.");
            throw new IOException();
        }
        FileObject templateFO = templateWizard.getTemplate().getPrimaryFile();
        FileObject prjLoc = JavaFXSampleProjectGenerator.createProjectFromTemplate(templateFO, projectLocation, name, platformName);
        HashSet<DataObject> set = new HashSet<DataObject>();
        set.add(DataObject.find((FileObject)prjLoc));
        Object openFile = templateFO.getAttribute("defaultFileToOpen");
        if (openFile instanceof String) {
            FileObject openFO = prjLoc.getFileObject((String)openFile);
            set.add(DataObject.find((FileObject)openFO));
        }
        if ((docToOpen = FileUtil.getConfigFile((String)("org-netbeans-modules-javafx2-samples/OpenAfterCreated/" + templateFO.getName() + ".url"))) != null) {
            docToOpen = FileUtil.copyFile((FileObject)docToOpen, (FileObject)prjLoc, (String)"readme");
            set.add(DataObject.find((FileObject)docToOpen));
        }
        return set;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = new String[]{NbBundle.getMessage(PanelConfigureProject.class, (String)"LBL_NWP1_ProjectTitleName")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", this.currentIndex);
    }

    private void warnIssue204880(String msg) {
        LOG.log(Level.SEVERE, msg + " (issue 204880).");
        NullPointerException npe = new NullPointerException(msg + " (issue 204880).");
        npe.printStackTrace();
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JavaFXSampleProjectIterator.class, (String)"WARN_Issue204880"), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }
}

