/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.CreateIPSecConnectionTunnelDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateIPSecConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="cpeId")
    private final String cpeId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="drgId")
    private final String drgId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="cpeLocalIdentifier")
    private final String cpeLocalIdentifier;
    @JsonProperty(value="cpeLocalIdentifierType")
    private final CpeLocalIdentifierType cpeLocalIdentifierType;
    @JsonProperty(value="staticRoutes")
    private final List<String> staticRoutes;
    @JsonProperty(value="tunnelConfiguration")
    private final List<CreateIPSecConnectionTunnelDetails> tunnelConfiguration;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "cpeId", "definedTags", "displayName", "drgId", "freeformTags", "cpeLocalIdentifier", "cpeLocalIdentifierType", "staticRoutes", "tunnelConfiguration"})
    public CreateIPSecConnectionDetails(String compartmentId, String cpeId, Map<String, Map<String, Object>> definedTags, String displayName, String drgId, Map<String, String> freeformTags, String cpeLocalIdentifier, CpeLocalIdentifierType cpeLocalIdentifierType, List<String> staticRoutes, List<CreateIPSecConnectionTunnelDetails> tunnelConfiguration) {
        this.compartmentId = compartmentId;
        this.cpeId = cpeId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.drgId = drgId;
        this.freeformTags = freeformTags;
        this.cpeLocalIdentifier = cpeLocalIdentifier;
        this.cpeLocalIdentifierType = cpeLocalIdentifierType;
        this.staticRoutes = staticRoutes;
        this.tunnelConfiguration = tunnelConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDrgId() {
        return this.drgId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getCpeLocalIdentifier() {
        return this.cpeLocalIdentifier;
    }

    public CpeLocalIdentifierType getCpeLocalIdentifierType() {
        return this.cpeLocalIdentifierType;
    }

    public List<String> getStaticRoutes() {
        return this.staticRoutes;
    }

    public List<CreateIPSecConnectionTunnelDetails> getTunnelConfiguration() {
        return this.tunnelConfiguration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateIPSecConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", cpeId=").append(String.valueOf(this.cpeId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", drgId=").append(String.valueOf(this.drgId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", cpeLocalIdentifier=").append(String.valueOf(this.cpeLocalIdentifier));
        sb.append(", cpeLocalIdentifierType=").append(String.valueOf((Object)this.cpeLocalIdentifierType));
        sb.append(", staticRoutes=").append(String.valueOf(this.staticRoutes));
        sb.append(", tunnelConfiguration=").append(String.valueOf(this.tunnelConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIPSecConnectionDetails)) {
            return false;
        }
        CreateIPSecConnectionDetails other = (CreateIPSecConnectionDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.cpeId, other.cpeId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.drgId, other.drgId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.cpeLocalIdentifier, other.cpeLocalIdentifier) && Objects.equals((Object)this.cpeLocalIdentifierType, (Object)other.cpeLocalIdentifierType) && Objects.equals(this.staticRoutes, other.staticRoutes) && Objects.equals(this.tunnelConfiguration, other.tunnelConfiguration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.cpeId == null ? 43 : this.cpeId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.cpeLocalIdentifier == null ? 43 : this.cpeLocalIdentifier.hashCode());
        result = result * 59 + (this.cpeLocalIdentifierType == null ? 43 : this.cpeLocalIdentifierType.hashCode());
        result = result * 59 + (this.staticRoutes == null ? 43 : this.staticRoutes.hashCode());
        result = result * 59 + (this.tunnelConfiguration == null ? 43 : this.tunnelConfiguration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CpeLocalIdentifierType implements BmcEnum
    {
        IpAddress("IP_ADDRESS"),
        Hostname("HOSTNAME");

        private final String value;
        private static Map<String, CpeLocalIdentifierType> map;

        private CpeLocalIdentifierType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CpeLocalIdentifierType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CpeLocalIdentifierType: " + key);
        }

        static {
            map = new HashMap<String, CpeLocalIdentifierType>();
            for (CpeLocalIdentifierType v : CpeLocalIdentifierType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="cpeId")
        private String cpeId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="drgId")
        private String drgId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="cpeLocalIdentifier")
        private String cpeLocalIdentifier;
        @JsonProperty(value="cpeLocalIdentifierType")
        private CpeLocalIdentifierType cpeLocalIdentifierType;
        @JsonProperty(value="staticRoutes")
        private List<String> staticRoutes;
        @JsonProperty(value="tunnelConfiguration")
        private List<CreateIPSecConnectionTunnelDetails> tunnelConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            this.__explicitlySet__.add("cpeId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            this.__explicitlySet__.add("drgId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder cpeLocalIdentifier(String cpeLocalIdentifier) {
            this.cpeLocalIdentifier = cpeLocalIdentifier;
            this.__explicitlySet__.add("cpeLocalIdentifier");
            return this;
        }

        public Builder cpeLocalIdentifierType(CpeLocalIdentifierType cpeLocalIdentifierType) {
            this.cpeLocalIdentifierType = cpeLocalIdentifierType;
            this.__explicitlySet__.add("cpeLocalIdentifierType");
            return this;
        }

        public Builder staticRoutes(List<String> staticRoutes) {
            this.staticRoutes = staticRoutes;
            this.__explicitlySet__.add("staticRoutes");
            return this;
        }

        public Builder tunnelConfiguration(List<CreateIPSecConnectionTunnelDetails> tunnelConfiguration) {
            this.tunnelConfiguration = tunnelConfiguration;
            this.__explicitlySet__.add("tunnelConfiguration");
            return this;
        }

        public CreateIPSecConnectionDetails build() {
            CreateIPSecConnectionDetails model = new CreateIPSecConnectionDetails(this.compartmentId, this.cpeId, this.definedTags, this.displayName, this.drgId, this.freeformTags, this.cpeLocalIdentifier, this.cpeLocalIdentifierType, this.staticRoutes, this.tunnelConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateIPSecConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("cpeId")) {
                this.cpeId(model.getCpeId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("drgId")) {
                this.drgId(model.getDrgId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("cpeLocalIdentifier")) {
                this.cpeLocalIdentifier(model.getCpeLocalIdentifier());
            }
            if (model.wasPropertyExplicitlySet("cpeLocalIdentifierType")) {
                this.cpeLocalIdentifierType(model.getCpeLocalIdentifierType());
            }
            if (model.wasPropertyExplicitlySet("staticRoutes")) {
                this.staticRoutes(model.getStaticRoutes());
            }
            if (model.wasPropertyExplicitlySet("tunnelConfiguration")) {
                this.tunnelConfiguration(model.getTunnelConfiguration());
            }
            return this;
        }
    }
}

