/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShapeNumaNodesPerSocketPlatformOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="allowedValues")
    private final List<AllowedValues> allowedValues;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;

    @Deprecated
    @ConstructorProperties(value={"allowedValues", "defaultValue"})
    public ShapeNumaNodesPerSocketPlatformOptions(List<AllowedValues> allowedValues, String defaultValue) {
        this.allowedValues = allowedValues;
        this.defaultValue = defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<AllowedValues> getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShapeNumaNodesPerSocketPlatformOptions(");
        sb.append("super=").append(super.toString());
        sb.append("allowedValues=").append(String.valueOf(this.allowedValues));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeNumaNodesPerSocketPlatformOptions)) {
            return false;
        }
        ShapeNumaNodesPerSocketPlatformOptions other = (ShapeNumaNodesPerSocketPlatformOptions)((Object)o);
        return Objects.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.defaultValue, other.defaultValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowedValues == null ? 43 : this.allowedValues.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AllowedValues implements BmcEnum
    {
        Nps0("NPS0"),
        Nps1("NPS1"),
        Nps2("NPS2"),
        Nps4("NPS4"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AllowedValues> map;

        private AllowedValues(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AllowedValues create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AllowedValues', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AllowedValues.class);
            map = new HashMap<String, AllowedValues>();
            for (AllowedValues v : AllowedValues.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="allowedValues")
        private List<AllowedValues> allowedValues;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder allowedValues(List<AllowedValues> allowedValues) {
            this.allowedValues = allowedValues;
            this.__explicitlySet__.add("allowedValues");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public ShapeNumaNodesPerSocketPlatformOptions build() {
            ShapeNumaNodesPerSocketPlatformOptions model = new ShapeNumaNodesPerSocketPlatformOptions(this.allowedValues, this.defaultValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShapeNumaNodesPerSocketPlatformOptions model) {
            if (model.wasPropertyExplicitlySet("allowedValues")) {
                this.allowedValues(model.getAllowedValues());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            return this;
        }
    }
}

