/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAppCatalogListingResourceVersionRequest
extends BmcRequest<Void> {
    private String listingId;
    private String resourceVersion;

    public String getListingId() {
        return this.listingId;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public Builder toBuilder() {
        return new Builder().listingId(this.listingId).resourceVersion(this.resourceVersion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",listingId=").append(String.valueOf(this.listingId));
        sb.append(",resourceVersion=").append(String.valueOf(this.resourceVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAppCatalogListingResourceVersionRequest)) {
            return false;
        }
        GetAppCatalogListingResourceVersionRequest other = (GetAppCatalogListingResourceVersionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.resourceVersion, other.resourceVersion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.resourceVersion == null ? 43 : this.resourceVersion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAppCatalogListingResourceVersionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String listingId = null;
        private String resourceVersion = null;

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAppCatalogListingResourceVersionRequest o) {
            this.listingId(o.getListingId());
            this.resourceVersion(o.getResourceVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAppCatalogListingResourceVersionRequest build() {
            GetAppCatalogListingResourceVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAppCatalogListingResourceVersionRequest buildWithoutInvocationCallback() {
            GetAppCatalogListingResourceVersionRequest request = new GetAppCatalogListingResourceVersionRequest();
            request.listingId = this.listingId;
            request.resourceVersion = this.resourceVersion;
            return request;
        }
    }
}

