/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVolumeBackupRequest
extends BmcRequest<Void> {
    private String volumeBackupId;

    public String getVolumeBackupId() {
        return this.volumeBackupId;
    }

    public Builder toBuilder() {
        return new Builder().volumeBackupId(this.volumeBackupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeBackupId=").append(String.valueOf(this.volumeBackupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVolumeBackupRequest)) {
            return false;
        }
        GetVolumeBackupRequest other = (GetVolumeBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeBackupId, other.volumeBackupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeBackupId == null ? 43 : this.volumeBackupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVolumeBackupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeBackupId = null;

        public Builder volumeBackupId(String volumeBackupId) {
            this.volumeBackupId = volumeBackupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeBackupRequest o) {
            this.volumeBackupId(o.getVolumeBackupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeBackupRequest build() {
            GetVolumeBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVolumeBackupRequest buildWithoutInvocationCallback() {
            GetVolumeBackupRequest request = new GetVolumeBackupRequest();
            request.volumeBackupId = this.volumeBackupId;
            return request;
        }
    }
}

