/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashSet<E>
extends AbstractSet<E> {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient E[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;

    public IdentityHashSet() {
        this.init(32);
    }

    public IdentityHashSet(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(this.capacity(expectedMaxSize));
    }

    public IdentityHashSet(Collection<? extends E> toAdd) {
        this((int)((double)(1 + toAdd.size()) * 1.1));
        this.addAll(toAdd);
    }

    public IdentityHashSet(E[] toAdd) {
        this((int)((double)(1 + toAdd.length) * 1.1));
        this.addAll(toAdd);
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = (3 * expectedMaxSize + 1) / 2;
        if (minCapacity > 0x40000000 || minCapacity < 0) {
            result = 0x40000000;
        } else {
            for (result = 4; result < minCapacity; result <<= 1) {
            }
        }
        return result;
    }

    private void init(int initCapacity) {
        this.threshold = initCapacity * 2 / 3;
        this.table = new Object[initCapacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        E[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashSet.hash(o, len);
        E item;
        while ((item = tab[i]) != o) {
            if (item == null) {
                return false;
            }
            i = IdentityHashSet.nextElementIndex(i, len);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Set m;
        if (c == this) {
            return true;
        }
        if (c instanceof IdentityHashSet) {
            IdentityHashSet m2 = (IdentityHashSet)c;
            if (m2.size() > this.size) {
                return false;
            }
            E[] tab = m2.table;
            for (int i = 0; i < tab.length; ++i) {
                E o = tab[i];
                if (o == null || this.contains(o)) continue;
                return false;
            }
            return true;
        }
        if (c instanceof Set && (m = (Set)c).size() > this.size) {
            return false;
        }
        return super.containsAll(c);
    }

    @Override
    public boolean add(E o) {
        E item;
        E[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashSet.hash(o, len);
        while ((item = tab[i]) != null) {
            if (item == o) {
                return false;
            }
            i = IdentityHashSet.nextElementIndex(i, len);
        }
        ++this.modCount;
        tab[i] = o;
        if (++this.size >= this.threshold) {
            this.resize(len);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int n = c.size();
        if (n == 0) {
            return false;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        boolean changed = false;
        for (E item : c) {
            changed |= this.add(item);
        }
        return changed;
    }

    public boolean addAll(E[] c) {
        int n = c.length;
        if (n == 0) {
            return false;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        boolean changed = false;
        for (E item : c) {
            changed |= this.add(item);
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        E[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashSet.hash(o, len);
        while (true) {
            E item;
            if ((item = tab[i]) == o) {
                ++this.modCount;
                --this.size;
                tab[i] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = IdentityHashSet.nextElementIndex(i, len);
        }
    }

    private void closeDeletion(int d) {
        E item;
        E[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashSet.nextElementIndex(d, len);
        while ((item = tab[i]) != null) {
            int r = IdentityHashSet.hash(item, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = item;
                tab[i] = null;
                d = i;
            }
            i = IdentityHashSet.nextElementIndex(i, len);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        if (c == this) {
            this.clear();
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (c instanceof IdentityHashSet) {
            IdentityHashSet m = (IdentityHashSet)c;
            boolean changed = false;
            E[] tab = m.table;
            for (int i = 0; i < tab.length; ++i) {
                E o = tab[i];
                if (o == null) continue;
                changed |= this.remove(o);
            }
            return changed;
        }
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        ++this.modCount;
        E[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new IdentityHashSetIterator();
    }

    protected Object clone() {
        try {
            IdentityHashSet t = (IdentityHashSet)super.clone();
            t.table = (Object[])this.table.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IdentityHashSet) {
            IdentityHashSet m = (IdentityHashSet)other;
            if (m.size() != this.size) {
                return false;
            }
            E[] tab = m.table;
            for (int i = 0; i < tab.length; ++i) {
                E o = tab[i];
                if (o == null || this.contains(o)) continue;
                return false;
            }
            return true;
        }
        if (other instanceof Set) {
            Set m = (Set)other;
            if (m.size() != this.size) {
                return false;
            }
            return this.containsAll(m);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E item : this) {
            h += item.hashCode();
        }
        return h;
    }

    private void resize(int newCapacity) {
        int newLength = newCapacity;
        E[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.threshold == 0x3FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x3FFFFFFF;
            return;
        }
        if (oldLength >= newLength) {
            return;
        }
        Object[] newTable = new Object[newLength];
        this.threshold = newLength * 2 / 3;
        for (int j = 0; j < oldLength; ++j) {
            E element = oldTable[j];
            if (element == null) continue;
            oldTable[j] = null;
            int i = IdentityHashSet.hash(element, newLength);
            while (newTable[i] != null) {
                i = IdentityHashSet.nextElementIndex(i, newLength);
            }
            newTable[i] = element;
        }
        this.table = newTable;
    }

    private static int hash(Object x, int length) {
        int h = System.identityHashCode(x);
        return (h << 1) - (h << 8) & length - 1;
    }

    private static int nextElementIndex(int i, int len) {
        return i < len ? i + 1 : 0;
    }

    private class IdentityHashSetIterator
    implements Iterator<E> {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        E[] traversalTable;

        private IdentityHashSetIterator() {
            this.index = IdentityHashSet.this.size != 0 ? 0 : IdentityHashSet.this.table.length;
            this.expectedModCount = IdentityHashSet.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashSet.this.table;
        }

        @Override
        public boolean hasNext() {
            E[] tab = this.traversalTable;
            if (!this.indexValid) {
                int i;
                for (i = this.index; i < tab.length && tab[i] == null; ++i) {
                }
                this.index = i;
                this.indexValid = true;
            }
            return this.index < tab.length;
        }

        protected int nextIndex() {
            if (IdentityHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index++;
            return this.lastReturnedIndex;
        }

        @Override
        public E next() {
            this.nextIndex();
            return this.traversalTable[this.lastReturnedIndex];
        }

        @Override
        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashSet.this.modCount;
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            --IdentityHashSet.this.size;
            this.index = deletedSlot;
            this.indexValid = false;
            E[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object element = tab[d];
            tab[d] = null;
            if (tab != IdentityHashSet.this.table) {
                IdentityHashSet.this.remove(element);
                this.expectedModCount = IdentityHashSet.this.modCount;
                return;
            }
            int i = IdentityHashSet.nextElementIndex(d, len);
            while ((item = tab[i]) != null) {
                int r = IdentityHashSet.hash(item, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == IdentityHashSet.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = item;
                    tab[i] = null;
                    d = i;
                }
                i = IdentityHashSet.nextElementIndex(i, len);
            }
        }
    }
}

