/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.actions;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public abstract class MultipleRepositoryAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(MultipleRepositoryAction.class.getName());

    protected MultipleRepositoryAction() {
        this(null);
    }

    protected MultipleRepositoryAction(String iconResource) {
        super(iconResource);
    }

    @Override
    protected final void performContextAction(final Node[] nodes) {
        Utils.postParallel((Runnable)new Runnable(){
            final /* synthetic */ MultipleRepositoryAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                VCSContext context = this.this$0.getCurrentContext(nodes);
                this.this$0.performAction(context);
            }
        }, (int)0);
    }

    public final void performAction(VCSContext context) {
        Set<File> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            LOG.log(Level.FINE, "No repository in the current context: {0}", context.getRootFiles());
            return;
        }
        for (File repository : repositories) {
            GitUtils.logRemoteRepositoryAccess(repository);
            RequestProcessor.Task runningTask = this.performAction(repository, GitUtils.filterForRepository(context, repository), context);
            if (runningTask == null) continue;
            runningTask.waitFinished();
        }
    }

    protected abstract RequestProcessor.Task performAction(File var1, File[] var2, VCSContext var3);
}

