/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.text.MessageFormat;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.git.ui.push.Bundle;
import org.netbeans.modules.git.ui.push.PushBranchesStep;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.NbBundle;

public abstract class PushMapping
extends ItemSelector.Item {
    private final String label;
    private final String tooltip;
    private static final String BRANCH_MAPPING_LABEL = "{0} -> {1} [{2}]";
    private static final String BRANCH_DELETE_MAPPING_LABEL = "{0} [{1}]";
    private static final String BRANCH_MAPPING_LABEL_UPTODATE = "{0} -> {1}";
    private final String localName;
    private final String remoteName;
    private static final String COLOR_NEW = GitUtils.getColorString(AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor());
    private static final String COLOR_MODIFIED = GitUtils.getColorString(AnnotationColorProvider.getInstance().MODIFIED_FILE.getActualColor());
    private static final String COLOR_REMOVED = GitUtils.getColorString(AnnotationColorProvider.getInstance().REMOVED_FILE.getActualColor());
    private static final String COLOR_CONFLICT = GitUtils.getColorString(AnnotationColorProvider.getInstance().CONFLICT_FILE.getActualColor());

    protected PushMapping(String localName, String localId, String remoteName, boolean conflict, boolean preselected, boolean updateNeeded) {
        super(preselected, localName == null || conflict);
        this.localName = localName;
        String string = this.remoteName = remoteName == null ? localName : remoteName;
        if (localName == null) {
            this.label = MessageFormat.format(BRANCH_DELETE_MAPPING_LABEL, remoteName, "<font color=\"" + COLOR_REMOVED + "\">R</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{remoteName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.deleted.description")});
        } else if (remoteName == null) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, localName, "<font color=\"" + COLOR_NEW + "\">A</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{localName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.added.description")});
        } else if (conflict) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, remoteName, "<font color=\"" + COLOR_CONFLICT + "\">C</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.conflict.description", (Object[])new Object[]{remoteName});
        } else if (updateNeeded) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, remoteName, "<font color=\"" + COLOR_MODIFIED + "\">U</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{remoteName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.updated.description")});
        } else {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL_UPTODATE, localName, remoteName);
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.uptodate.description", (Object)remoteName);
        }
    }

    public abstract String getRefSpec();

    String getInfoMessage() {
        return null;
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getTooltipText() {
        return this.tooltip;
    }

    public final String getLocalName() {
        return this.localName;
    }

    @Override
    public int compareTo(ItemSelector.Item t) {
        if (t == null) {
            return 1;
        }
        if (t instanceof PushMapping) {
            PushMapping other = (PushMapping)t;
            if (this.isDestructive() && other.isDestructive()) {
                return this.remoteName.compareTo(other.remoteName);
            }
            if (this.isDestructive() && !other.isDestructive()) {
                return 1;
            }
            if (!this.isDestructive() && other.isDestructive()) {
                return -1;
            }
            return this.localName.compareTo(other.localName);
        }
        return 0;
    }

    String getRemoteName() {
        return this.remoteName;
    }

    abstract boolean isCreateBranchMapping();

    public static final class PushTagMapping
    extends PushMapping {
        private final GitTag tag;
        private final boolean isUpdate;
        private final String remoteTagName;

        public PushTagMapping(String remoteName) {
            super(null, null, remoteName, false, false, remoteName != null);
            this.tag = null;
            this.isUpdate = remoteName != null;
            this.remoteTagName = remoteName;
        }

        public PushTagMapping(GitTag tag, String remoteName) {
            super("tags/" + tag.getTagName(), tag.getTaggedObjectId(), remoteName, false, false, remoteName != null);
            this.tag = tag;
            this.isUpdate = remoteName != null;
            this.remoteTagName = remoteName;
        }

        @Override
        public String getRefSpec() {
            if (this.isDestructive() && !this.isUpdate) {
                return GitUtils.getPushDeletedTagRefSpec(this.remoteTagName);
            }
            return GitUtils.getPushTagRefSpec(this.tag.getTagName(), this.isUpdate);
        }

        @Override
        String getInfoMessage() {
            if (this.isDestructive() && !this.isUpdate) {
                return Bundle.MSG_PushMapping_toBeDeletedTag(this.remoteTagName);
            }
            return super.getInfoMessage();
        }

        @Override
        boolean isCreateBranchMapping() {
            return false;
        }
    }

    public static final class PushBranchMapping
    extends PushMapping {
        private final GitBranch localBranch;
        private final String remoteBranchName;
        private final String remoteBranchId;

        public PushBranchMapping(String remoteBranchName, String remoteBranchId, boolean preselected) {
            this(remoteBranchName, remoteBranchId, preselected, false);
        }

        public PushBranchMapping(String remoteBranchName, String remoteBranchId, boolean preselected, boolean updateNeeded) {
            super(null, null, remoteBranchName, false, preselected, updateNeeded);
            this.localBranch = null;
            this.remoteBranchName = remoteBranchName;
            this.remoteBranchId = remoteBranchId;
        }

        public PushBranchMapping(String remoteBranchName, String remoteBranchId, GitBranch localBranch, boolean conflict, boolean preselected) {
            this(remoteBranchName, remoteBranchId, localBranch, conflict, preselected, false);
        }

        public PushBranchMapping(String remoteBranchName, String remoteBranchId, GitBranch localBranch, boolean conflict, boolean preselected, boolean updateNeeded) {
            super(localBranch.getName(), localBranch.getId(), remoteBranchName, conflict, preselected, updateNeeded);
            this.localBranch = localBranch;
            this.remoteBranchName = remoteBranchName;
            this.remoteBranchId = remoteBranchId;
        }

        public String getRemoteRepositoryBranchName() {
            return this.remoteBranchName == null ? this.localBranch.getName() : this.remoteBranchName;
        }

        public String getRemoteRepositoryBranchHeadId() {
            return this.remoteBranchId;
        }

        public String getLocalRepositoryBranchHeadId() {
            return this.localBranch == null ? null : this.localBranch.getId();
        }

        @Override
        public String getRefSpec() {
            if (this.isDestructive() && this.getLocalName() == null) {
                return GitUtils.getPushDeletedRefSpec(this.remoteBranchName);
            }
            return GitUtils.getPushRefSpec(this.localBranch.getName(), this.remoteBranchName == null ? this.localBranch.getName() : this.remoteBranchName, this.isDestructive());
        }

        @Override
        String getInfoMessage() {
            if (this.isDestructive() && this.getLocalName() == null) {
                return Bundle.MSG_PushMapping_toBeDeletedBranch(this.remoteBranchName);
            }
            if (this.isDestructive()) {
                return Bundle.MSG_PushMapping_toBeForcepushedBranch(this.remoteBranchName);
            }
            return super.getInfoMessage();
        }

        @Override
        boolean isCreateBranchMapping() {
            return this.localBranch != null && this.remoteBranchName == null;
        }
    }
}

