/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.breakpoints;

import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.netbeans.lib.chrome_devtools_protocol.debugger.BreakpointResolved;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.Paused;
import org.netbeans.lib.chrome_devtools_protocol.debugger.RemoveBreakpointRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointByUrlRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointByUrlResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointsActiveRequest;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.javascript.cdtdebug.breakpoints.Bundle;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class BreakpointsHandler
implements CDTDebugger.Listener {
    private final RequestProcessor RP = new RequestProcessor(BreakpointsHandler.class.getName(), 1);
    private final CDTDebugger dbg;
    private final List<JSLineBreakpoint> trackedBreakpoints = new CopyOnWriteArrayList<JSLineBreakpoint>();
    private final Map<JSLineBreakpoint, String[]> submittedBreakpoints = new HashMap<JSLineBreakpoint, String[]>();
    private final Map<String, JSLineBreakpoint> breakpointsById = new HashMap<String, JSLineBreakpoint>();
    private final List<ActiveBreakpointListener> abListeners = new CopyOnWriteArrayList<ActiveBreakpointListener>();
    private volatile JSLineBreakpoint activeBreakpoint;
    private final List<BreakpointsActiveListener> acListeners = new CopyOnWriteArrayList<BreakpointsActiveListener>();
    private volatile boolean areBreakpointsActive = true;
    private final PropertyChangeListener bpChangeListener = evt -> {
        switch (evt.getPropertyName()) {
            case "enabled": 
            case "condition": {
                JSLineBreakpoint source = (JSLineBreakpoint)evt.getSource();
                this.RP.submit(() -> {
                    this.unsubmitBreakpoint(source);
                    this.submitBreakpoint(source);
                });
            }
        }
    };
    private final Consumer<BreakpointResolved> resolvedHandler = br -> {
        JSLineBreakpoint b;
        Map<JSLineBreakpoint, String[]> map = this.submittedBreakpoints;
        synchronized (map) {
            b = this.breakpointsById.get(br.getBreakpointId());
        }
        if (b != null) {
            JSBreakpointStatus.setValid((JSLineBreakpoint)b, (String)Bundle.MSG_BRKP_Resolved());
        }
    };
    private final Consumer<Paused> pausedHandler = p -> {
        for (String id : p.getHitBreakpoints()) {
            JSLineBreakpoint b;
            Map<JSLineBreakpoint, String[]> map = this.submittedBreakpoints;
            synchronized (map) {
                b = this.breakpointsById.get(id);
            }
            if (b == null) continue;
            this.setActiveBreakpoint(b);
        }
    };

    public BreakpointsHandler(CDTDebugger dbg) {
        this.dbg = dbg;
        dbg.addListener(this);
        dbg.getConnection().getDebugger().onBreakpointResolved(this.resolvedHandler);
        dbg.getConnection().getDebugger().onPaused(this.pausedHandler);
    }

    public void add(JSLineBreakpoint lb) {
        this.trackedBreakpoints.add(lb);
        lb.addPropertyChangeListener(this.bpChangeListener);
        this.RP.submit(() -> this.submitBreakpoint(lb));
    }

    public void remove(JSLineBreakpoint lb) {
        this.trackedBreakpoints.remove(lb);
        lb.removePropertyChangeListener(this.bpChangeListener);
        JSBreakpointStatus.resetValidity((JSLineBreakpoint)lb);
        this.RP.submit(() -> this.unsubmitBreakpoint(lb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitBreakpoint(JSLineBreakpoint lb) {
        try {
            Map<JSLineBreakpoint, String[]> map = this.submittedBreakpoints;
            synchronized (map) {
                JSBreakpointStatus.setInvalid((JSLineBreakpoint)lb, (String)Bundle.MSG_BRKP_Unresolved());
                String[] ids = (String[])this.createSetRequestArguments(lb).stream().map(req -> this.dbg.getConnection().getDebugger().setBreakpointByUrl(req)).map(cs -> cs.toCompletableFuture()).map(cs -> (SetBreakpointByUrlResponse)cs.join()).map(sbbur -> {
                    if (!sbbur.getLocations().isEmpty()) {
                        JSBreakpointStatus.setValid((JSLineBreakpoint)lb, (String)Bundle.MSG_BRKP_Resolved());
                    }
                    return sbbur.getBreakpointId();
                }).collect(Collectors.toList()).toArray(String[]::new);
                this.submittedBreakpoints.put(lb, ids);
                for (String id : ids) {
                    this.breakpointsById.put(id, lb);
                }
            }
        }
        catch (RuntimeException ex) {
            JSBreakpointStatus.setInvalid((JSLineBreakpoint)lb, (String)"Failed to submit breakpoint");
            throw ex;
        }
        if (!this.trackedBreakpoints.contains(lb)) {
            this.unsubmitBreakpoint(lb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubmitBreakpoint(JSLineBreakpoint lb) {
        Map<JSLineBreakpoint, String[]> map = this.submittedBreakpoints;
        synchronized (map) {
            String[] ids = this.submittedBreakpoints.remove(lb);
            if (ids != null) {
                Arrays.stream(ids).map(id -> {
                    this.breakpointsById.remove(id);
                    return id;
                }).map(RemoveBreakpointRequest::new).map(req -> this.dbg.getConnection().getDebugger().removeBreakpoint(req)).map(cs -> cs.toCompletableFuture()).forEach(cf -> cf.join());
            }
        }
    }

    private List<SetBreakpointByUrlRequest> createSetRequestArguments(JSLineBreakpoint b) {
        if (!b.isEnabled()) {
            return Collections.emptyList();
        }
        FileObject fo = b.getFileObject();
        ScriptsHandler scriptsHandler = this.dbg.getScriptsHandler();
        ArrayList<String> serverPath = new ArrayList<String>();
        ArrayList<Integer> lineNumber = new ArrayList<Integer>();
        ArrayList<Integer> columnNumber = new ArrayList<Integer>();
        if (fo != null) {
            SourceMapsTranslator.Location loc;
            SourceMapsTranslator.Location cl;
            SourceMapsTranslator smt = scriptsHandler.getSourceMapsTranslator();
            if (smt != null && (cl = smt.getCompiledLocation(loc = new SourceMapsTranslator.Location(fo, b.getLineNumber() - 1, 0))) != loc) {
                serverPath.add(scriptsHandler.getServerPath(cl.getFile()));
                lineNumber.add(cl.getLine());
                columnNumber.add(cl.getColumn());
            }
            serverPath.add(scriptsHandler.getServerPath(fo));
            lineNumber.add(b.getLineNumber() - 1);
            columnNumber.add(0);
        } else {
            URL url = b.getURL();
            serverPath.add(b.getURL().toString());
            lineNumber.add(b.getLineNumber() - 1);
            columnNumber.add(0);
        }
        String condition = b.isConditional() ? b.getCondition() : null;
        ArrayList<SetBreakpointByUrlRequest> args = new ArrayList<SetBreakpointByUrlRequest>();
        for (int i = 0; i < serverPath.size(); ++i) {
            if (serverPath.get(i) == null) continue;
            SetBreakpointByUrlRequest newBreakPoint = new SetBreakpointByUrlRequest();
            newBreakPoint.setUrl((String)serverPath.get(i));
            newBreakPoint.setLineNumber(((Integer)lineNumber.get(i)).intValue());
            newBreakPoint.setColumnNumber((Integer)columnNumber.get(i));
            newBreakPoint.setCondition(condition);
            args.add(newBreakPoint);
        }
        return args;
    }

    @Override
    public void notifySuspended(boolean suspended) {
        if (!suspended) {
            this.setActiveBreakpoint(null);
        }
    }

    @Override
    public void notifyCurrentFrame(CallFrame cf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinished() {
        Map<JSLineBreakpoint, String[]> map = this.submittedBreakpoints;
        synchronized (map) {
            this.submittedBreakpoints.clear();
            this.breakpointsById.clear();
        }
        for (JSLineBreakpoint lb : this.trackedBreakpoints) {
            lb.removePropertyChangeListener(this.bpChangeListener);
            JSBreakpointStatus.resetValidity((JSLineBreakpoint)lb);
        }
        this.setActiveBreakpoint(null);
    }

    public JSLineBreakpoint getActiveBreakpoint() {
        return this.activeBreakpoint;
    }

    private void setActiveBreakpoint(JSLineBreakpoint activeBreakpoint) {
        this.activeBreakpoint = activeBreakpoint;
        JSBreakpointStatus.setActive((JSLineBreakpoint)activeBreakpoint);
        for (ActiveBreakpointListener abl : this.abListeners) {
            abl.notifyActiveBreakpoint(activeBreakpoint);
        }
    }

    public void addActiveBreakpointListener(ActiveBreakpointListener abl) {
        this.abListeners.add(abl);
    }

    public void removeActiveBreakpointListener(ActiveBreakpointListener abl) {
        this.abListeners.remove(abl);
    }

    boolean areBreakpointsActive() {
        return this.areBreakpointsActive;
    }

    void setBreakpointsActive(boolean active) {
        SetBreakpointsActiveRequest req = new SetBreakpointsActiveRequest();
        req.setActive(active);
        this.dbg.getConnection().getDebugger().setBreakpointsActive(req).handle((sbar, thr) -> {
            this.areBreakpointsActive = active;
            for (BreakpointsActiveListener acl : this.acListeners) {
                acl.breakpointsActivated(active);
            }
            return null;
        });
    }

    void addBreakpointsActiveListener(BreakpointsActiveListener abl) {
        this.acListeners.add(abl);
    }

    void removeBreakpointsActiveListener(BreakpointsActiveListener abl) {
        this.acListeners.remove(abl);
    }

    public static interface ActiveBreakpointListener {
        public void notifyActiveBreakpoint(JSLineBreakpoint var1);
    }

    static interface BreakpointsActiveListener {
        public void breakpointsActivated(boolean var1);
    }
}

