/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.AbstractKmsManagementClientBuilder;
import com.oracle.bmc.keymanagement.KmsManagementAsyncClient;
import jakarta.annotation.Nonnull;

public class KmsManagementAsyncClientBuilder
extends AbstractKmsManagementClientBuilder<KmsManagementAsyncClientBuilder, KmsManagementAsyncClient> {
    public KmsManagementAsyncClientBuilder(Service service) {
        super(service);
    }

    public KmsManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        String cryptoEndpoint = this.getEndpoint();
        KmsManagementAsyncClientBuilder copy = (KmsManagementAsyncClientBuilder)KmsManagementAsyncClient.builder().copyFrom(this).endpoint(cryptoEndpoint);
        return new KmsManagementAsyncClient(copy, authenticationDetailsProvider);
    }
}

