/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class NameAndPackagePanel
extends JPanel {
    private static RequestProcessor WORKER = new RequestProcessor(NameAndPackagePanel.class.getName(), 1, false, false);
    static final String IS_VALID = "NameAndPackagePanel.isValidData";
    private volatile ErrorListener errorListener;
    private final JavaSource testingJavaSource;
    private final ElementHandle<TypeElement> baseclass;
    private static final AtomicLong documentVersion = new AtomicLong();
    private JLabel classNameLabel;
    private JTextField classNameTextField;
    private JLabel packageNameLabel;
    private JTextField packageNameTextField;

    public NameAndPackagePanel(FileObject targetSourceRoot, ElementHandle<TypeElement> baseclass, String className, String packageName) {
        this.initComponents();
        this.classNameTextField.setText(className);
        this.packageNameTextField.setText(packageName);
        this.testingJavaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)targetSourceRoot), (FileObject[])new FileObject[0]);
        this.baseclass = baseclass;
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameAndPackagePanel.this.checkValid();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameAndPackagePanel.this.checkValid();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.classNameTextField.getDocument().addDocumentListener(l);
        this.packageNameTextField.getDocument().addDocumentListener(l);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public String getClassName() {
        return this.classNameTextField.getText();
    }

    public String getPackageName() {
        return this.packageNameTextField.getText();
    }

    void checkValid() {
        assert (this.errorListener != null);
        final long currentVersion = documentVersion.incrementAndGet();
        final String className = this.getClassName();
        final String packageName = this.getPackageName();
        if (!this.isValidTypeIdentifier(className)) {
            this.errorListener.setErrorMessage(Bundle.ERR_TypeNameNotValid());
        } else if (!this.isValidPackageName(packageName)) {
            this.errorListener.setErrorMessage(Bundle.ERR_PackageNameNotValid());
        } else {
            WORKER.post(new Runnable(){
                final /* synthetic */ NameAndPackagePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.testingJavaSource.runUserActionTask((Task)new Task<CompilationController>(){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(CompilationController parameter) throws Exception {
                                String[] error;
                                block2: {
                                    TypeMirror baseclassType;
                                    Types types;
                                    TypeElement element;
                                    block4: {
                                        TypeMirror typeMirror;
                                        TypeElement jlObject;
                                        block5: {
                                            TypeElement baseclass;
                                            block3: {
                                                if (documentVersion.get() > currentVersion) {
                                                    return;
                                                }
                                                element = parameter.getElements().getTypeElement(packageName + "." + className);
                                                error = new String[]{null};
                                                if (element == null) break block2;
                                                baseclass = (TypeElement)this.this$1.this$0.baseclass.resolve((CompilationInfo)parameter);
                                                types = parameter.getTypes();
                                                baseclassType = types.erasure(baseclass.asType());
                                                if (!element.equals(baseclass)) break block3;
                                                error[0] = Bundle.ERR_SameClass();
                                                break block2;
                                            }
                                            if (baseclass.getKind() != ElementKind.CLASS) break block4;
                                            jlObject = parameter.getElements().getTypeElement("java.lang.Object");
                                            typeMirror = types.erasure(element.getSuperclass());
                                            if (!types.isSameType(typeMirror, baseclassType)) break block5;
                                            error[0] = Bundle.ERR_AlreadyExtends();
                                            break block2;
                                        }
                                        if (jlObject == null || types.isSameType(typeMirror, jlObject.asType())) break block2;
                                        error[0] = Bundle.ERR_ExtendsOther();
                                        break block2;
                                    }
                                    for (TypeMirror typeMirror : element.getInterfaces()) {
                                        TypeMirror typeMirror2 = types.erasure(typeMirror);
                                        if (!types.isSameType(typeMirror2, baseclassType)) continue;
                                        error[0] = Bundle.ERR_AlreadyImplements();
                                    }
                                }
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        if (documentVersion.get() > currentVersion) {
                                            return;
                                        }
                                        this.this$2.this$1.this$0.errorListener.setErrorMessage(error[0]);
                                    }
                                });
                            }
                        }, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidTypeIdentifier(String ident) {
        return ident != null && !"".equals(ident) && Utilities.isJavaIdentifier((String)ident);
    }

    private void initComponents() {
        this.classNameLabel = new JLabel();
        this.classNameTextField = new JTextField();
        this.packageNameLabel = new JLabel();
        this.packageNameTextField = new JTextField();
        this.classNameLabel.setLabelFor(this.classNameTextField);
        this.classNameLabel.setText(NbBundle.getMessage(NameAndPackagePanel.class, (String)"LBL_ClassName"));
        this.packageNameLabel.setLabelFor(this.packageNameTextField);
        this.packageNameLabel.setText(NbBundle.getMessage(NameAndPackagePanel.class, (String)"LBL_PackageName"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.packageNameLabel).addComponent(this.classNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameTextField).addComponent(this.packageNameTextField, -1, 272, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classNameLabel).addComponent(this.classNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageNameLabel).addComponent(this.packageNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static interface ErrorListener {
        public void setErrorMessage(String var1);
    }
}

