/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nashorn.execution;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.nashorn.execution.NashornPlatform;
import org.netbeans.modules.nashorn.execution.options.Settings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;

public class JSExecutor {
    private static final String NASHORN_SHELL = "jdk.nashorn.tools.Shell";
    private static final String JS_SHELL = "com.oracle.truffle.js.shell.JSLauncher";

    public static void run(JavaPlatform javaPlatform, FileObject js, boolean debug) throws IOException, UnsupportedOperationException {
        LifecycleManager.getDefault().saveAll();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("platform", javaPlatform);
        ClassPath path = JSExecutor.getClassPath(js);
        Preferences p = Settings.getPreferences();
        boolean preferNashorn = NashornPlatform.isNashornSupported(javaPlatform);
        if (p.get("nashornIsPreferred", null) != null) {
            preferNashorn = p.getBoolean("nashornIsPreferred", false);
        } else if (NashornPlatform.isGraalJsSupported(javaPlatform) && NashornPlatform.isGraalJSPreferred(javaPlatform)) {
            preferNashorn = false;
        }
        if (preferNashorn) {
            try {
                javaPlatform.getBootstrapLibraries().getClassLoader(true).loadClass(NASHORN_SHELL);
                properties.put("classname", NASHORN_SHELL);
            }
            catch (ClassNotFoundException ex) {
                properties.put("classname", JS_SHELL);
            }
        } else {
            properties.put("classname", JS_SHELL);
        }
        properties.put("execute.classpath", path);
        properties.put("work.dir", js.getParent());
        properties.put("application.args", JSExecutor.getApplicationArgs(js));
        if (debug) {
            JavaRunner.execute((String)"debug", properties);
        } else {
            JavaRunner.execute((String)"run", properties);
        }
    }

    private static ClassPath getClassPath(FileObject js) {
        ClassPath cp = ClassPath.getClassPath((FileObject)js, (String)"classpath/execute");
        if (cp == null) {
            cp = ClassPath.EMPTY;
        }
        ClassPath engine = JSExecutor.findGraalJsClassPath();
        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, engine});
    }

    private static List<String> getApplicationArgs(FileObject js) {
        String options = Settings.getPreferences().get("nashornEngineOptions", null);
        String arguments = Settings.getPreferences().get("nashornScriptArguments", null);
        if (options == null && arguments == null) {
            return Collections.singletonList(js.getNameExt());
        }
        LinkedList<String> args = new LinkedList<String>();
        if (options != null && !(options = options.trim()).isEmpty()) {
            args.add(options);
        }
        args.add(js.getNameExt());
        if (arguments != null && !(arguments = arguments.trim()).isEmpty()) {
            args.add("--");
            args.add(arguments);
        }
        return args;
    }

    static ClassPath findGraalJsClassPath() {
        Library graalJsLib = LibraryManager.getDefault().getLibrary("graaljs");
        ArrayList<URL> urls = graalJsLib.getContent("classpath");
        ClassPath nbInstCp = ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[0]));
        urls = new ArrayList<URL>();
        for (ClassPath.Entry e : nbInstCp.entries()) {
            assert (e.isValid()) : "Invalid entry: " + e;
            try {
                JarFileSystem jfs = (JarFileSystem)e.getRoot().getFileSystem();
                urls.add(new URL("jar:" + jfs.getJarFile().toURI().toURL() + "!/"));
            }
            catch (MalformedURLException | FileStateInvalidException ignore) {
                throw new AssertionError((Object)ignore);
            }
        }
        return ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[0]));
    }
}

