/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TableListNode
extends BaseNode
implements SchemaNameProvider {
    private static final String NAME = "Tables";
    private static final String SYSTEM_NAME = "SystemTables";
    private static final String ICONBASE = "org/netbeans/modules/db/resources/folder.gif";
    private static final String FOLDER = "TableList";
    private static final String SYSTEM_FOLDER = "SystemTableList";
    private MetadataElementHandle<Schema> schemaHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final Type type;

    public static TableListNode create(NodeDataLookup dataLookup, NodeProvider provider, Type type) {
        TableListNode node = new TableListNode(dataLookup, provider, type);
        node.setup();
        return node;
    }

    private TableListNode(NodeDataLookup lookup, NodeProvider provider, Type type) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, Type.SYSTEM == type ? SYSTEM_FOLDER : FOLDER, provider);
        this.type = type;
    }

    @Override
    protected void initialize() {
        this.schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    public String getName() {
        switch (this.type.ordinal()) {
            case 0: {
                return SYSTEM_NAME;
            }
        }
        return NAME;
    }

    public String getDisplayName() {
        switch (this.type.ordinal()) {
            case 0: {
                return NbBundle.getMessage(TableListNode.class, (String)"SystemTableListNode_DISPLAYNAME");
            }
        }
        return NbBundle.getMessage(TableListNode.class, (String)"TableListNode_DISPLAYNAME");
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        switch (this.type.ordinal()) {
            case 0: {
                return NbBundle.getMessage(TableListNode.class, (String)"ND_SystemTableList");
            }
        }
        return NbBundle.getMessage(TableListNode.class, (String)"ND_TableList");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TableListNode.class);
    }

    @Override
    public String getSchemaName() {
        return TableListNode.getSchemaName(this.connection, this.schemaHandle);
    }

    @Override
    public String getCatalogName() {
        return TableListNode.getCatalogName(this.connection, this.schemaHandle);
    }

    public static String getSchemaName(DatabaseConnection connection, final MetadataElementHandle<Schema> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Schema schema = (Schema)handle.resolve(metaData);
                    if (schema != null) {
                        array[0] = schema.getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(TableListNode.class, connection, e, true);
        }
        return array[0];
    }

    public static String getCatalogName(DatabaseConnection connection, final MetadataElementHandle<Schema> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Schema schema = (Schema)handle.resolve(metaData);
                    if (schema != null) {
                        array[0] = schema.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(TableListNode.class, connection, e, true);
        }
        return array[0];
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        SYSTEM,
        STANDARD,
        ALL;

    }
}

