/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.BaseExecutionDescriptor;
import org.netbeans.api.extexecution.base.BaseExecutionService;
import org.netbeans.api.extexecution.base.ParametrizedRunnable;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.extexecution.print.LineProcessors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.extexecution.InputOutputManager;
import org.netbeans.modules.extexecution.RerunAction;
import org.netbeans.modules.extexecution.StopAction;
import org.netbeans.modules.extexecution.input.BaseInputProcessor;
import org.netbeans.modules.extexecution.input.DelegatingInputProcessor;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class ExecutionService {
    private static final Logger LOGGER = Logger.getLogger(ExecutionService.class.getName());
    private final Callable<Process> processCreator;
    private final ExecutionDescriptor descriptor;
    private final String originalDisplayName;

    private ExecutionService(Callable<Process> processCreator, String displayName, ExecutionDescriptor descriptor) {
        this.processCreator = processCreator;
        this.originalDisplayName = displayName;
        this.descriptor = descriptor;
    }

    @NonNull
    public static ExecutionService newService(@NonNull Callable<Process> processCreator, @NonNull ExecutionDescriptor descriptor, @NonNull String displayName) {
        return new ExecutionService(processCreator, displayName, descriptor);
    }

    @NonNull
    public Future<Integer> run() {
        return this.run(null);
    }

    private Future<Integer> run(InputOutput required) {
        final InputOutputManager.InputOutputData ioData = this.getInputOutput(required);
        String displayName = ioData.getDisplayName();
        ProgressCancellable cancellable = this.descriptor.isControllable() ? new ProgressCancellable() : null;
        final ProgressHandle handle = this.createProgressHandle(ioData.getInputOutput(), displayName, cancellable);
        InputOutput io = ioData.getInputOutput();
        final OutputWriter out = io.getOut();
        final OutputWriter err = io.getErr();
        final Reader in = io.getIn();
        class ExecutedHolder {
            private boolean executed = false;

            ExecutedHolder() {
            }
        }
        final ExecutedHolder executed = new ExecutedHolder();
        BaseExecutionDescriptor realDescriptor = new BaseExecutionDescriptor();
        realDescriptor = realDescriptor.charset(this.descriptor.getCharset());
        realDescriptor = realDescriptor.inReaderFactory(new BaseExecutionDescriptor.ReaderFactory(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            public Reader newReader() {
                return in;
            }
        });
        realDescriptor = realDescriptor.preExecution(new Runnable(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                executed.executed = true;
                Runnable orig = this.this$0.descriptor.getPreExecution();
                if (orig != null) {
                    orig.run();
                }
            }
        });
        realDescriptor = realDescriptor.postExecution((ParametrizedRunnable)new ParametrizedRunnable<Integer>(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            public void run(Integer exitCode) {
                this.this$0.cleanup(handle, ioData, ioData.getInputOutput() != this.this$0.descriptor.getInputOutput(), this.this$0.descriptor.isFrontWindowOnError() && exitCode != null && exitCode != 0);
                Consumer<? super Integer> orig = this.this$0.descriptor.getPostExecution();
                if (orig != null) {
                    orig.accept(exitCode);
                }
            }
        });
        realDescriptor = realDescriptor.outProcessorFactory(new BaseExecutionDescriptor.InputProcessorFactory(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            public InputProcessor newInputProcessor() {
                return this.this$0.createOutProcessor(out);
            }
        });
        realDescriptor = realDescriptor.errProcessorFactory(new BaseExecutionDescriptor.InputProcessorFactory(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            public InputProcessor newInputProcessor() {
                return this.this$0.createErrProcessor(err);
            }
        });
        BaseExecutionService service = BaseExecutionService.newService(this.processCreator, (BaseExecutionDescriptor)realDescriptor);
        final Future delegate = service.run();
        final Future<Integer> current = new Future<Integer>(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean ret = delegate.cancel(mayInterruptIfRunning);
                if (executed.executed) return ret;
                this.this$0.cleanup(handle, ioData, false);
                Class<InputOutputManager> clazz = InputOutputManager.class;
                synchronized (InputOutputManager.class) {
                    if (ioData.getInputOutput() == this.this$0.descriptor.getInputOutput()) return ret;
                    InputOutputManager.addInputOutput(ioData);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ret;
                }
            }

            @Override
            public boolean isCancelled() {
                return delegate.isCancelled();
            }

            @Override
            public boolean isDone() {
                return delegate.isDone();
            }

            @Override
            public Integer get() throws InterruptedException, ExecutionException {
                return (Integer)delegate.get();
            }

            @Override
            public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (Integer)delegate.get(timeout, unit);
            }
        };
        final StopAction workingStopAction = ioData.getStopAction();
        final RerunAction workingRerunAction = ioData.getRerunAction();
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractAction abstractAction;
                if (workingStopAction != null) {
                    abstractAction = workingStopAction;
                    synchronized (abstractAction) {
                        workingStopAction.setTask(current);
                        workingStopAction.setEnabled(true);
                    }
                }
                if (workingRerunAction != null) {
                    abstractAction = workingRerunAction;
                    synchronized (abstractAction) {
                        workingRerunAction.setExecutionService(this.this$0);
                        workingRerunAction.setRerunCondition(this.this$0.descriptor.getRerunCondition());
                        workingRerunAction.setRerunCallback(this.this$0.descriptor.getRerunCallback());
                        workingRerunAction.setEnabled(false);
                    }
                }
            }
        });
        if (cancellable != null) {
            cancellable.setTask(current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputOutputManager.InputOutputData getInputOutput(InputOutput required) {
        InputOutputManager.InputOutputData result = null;
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            InputOutput io = this.descriptor.getInputOutput();
            if (io != null) {
                result = new InputOutputManager.InputOutputData(io, this.originalDisplayName, null, null, null);
            }
            if (result == null) {
                result = InputOutputManager.getInputOutput(required);
            }
            if (result == null) {
                result = InputOutputManager.getInputOutput(this.originalDisplayName, this.descriptor.isControllable(), this.descriptor.getOptionsPath());
            }
            if (result == null) {
                result = InputOutputManager.createInputOutput(this.originalDisplayName, this.descriptor.isControllable(), this.descriptor.getOptionsPath());
            }
            this.configureInputOutput(result.getInputOutput());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private void configureInputOutput(InputOutput inputOutput) {
        if (inputOutput == InputOutput.NULL) {
            return;
        }
        if (this.descriptor.getInputOutput() == null || !this.descriptor.noReset()) {
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException exc) {
                LOGGER.log(Level.INFO, null, exc);
            }
            inputOutput.setErrSeparated(false);
        }
        if (this.descriptor.isFrontWindow()) {
            inputOutput.select();
        }
        inputOutput.setInputVisible(this.descriptor.isInputVisible());
    }

    private ProgressHandle createProgressHandle(InputOutput inputOutput, String displayName, Cancellable cancellable) {
        if (!this.descriptor.showProgress() && !this.descriptor.showSuspended()) {
            return null;
        }
        ProgressHandle handle = ProgressHandle.createHandle((String)displayName, (Cancellable)cancellable, (Action)new ProgressAction(inputOutput));
        handle.setInitialDelay(0);
        handle.start();
        handle.switchToIndeterminate();
        if (this.descriptor.showSuspended()) {
            handle.suspend(NbBundle.getMessage(ExecutionService.class, (String)"Running"));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(ProgressHandle progressHandle, InputOutputManager.InputOutputData inputOutputData, boolean managed, boolean show) {
        this.cleanup(progressHandle, inputOutputData, show);
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            if (managed) {
                InputOutputManager.addInputOutput(inputOutputData);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void cleanup(final ProgressHandle progressHandle, final InputOutputManager.InputOutputData inputOutputData, final boolean show) {
        Runnable ui = new Runnable(){
            final /* synthetic */ ExecutionService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (show) {
                    inputOutputData.getInputOutput().select();
                }
                if (inputOutputData.getStopAction() != null) {
                    inputOutputData.getStopAction().setEnabled(false);
                }
                if (inputOutputData.getRerunAction() != null) {
                    inputOutputData.getRerunAction().setEnabled(true);
                }
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
        };
        Mutex.EVENT.readAccess(ui);
    }

    private InputProcessor createOutProcessor(OutputWriter writer) {
        ExecutionDescriptor.LineConvertorFactory convertorFactory = this.descriptor.getOutConvertorFactory();
        InputProcessor outProcessor = null;
        outProcessor = this.descriptor.isOutLineBased() ? InputProcessors.bridge((LineProcessor)LineProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, true)) : org.netbeans.api.extexecution.print.InputProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, true);
        ExecutionDescriptor.InputProcessorFactory descriptorOutFactory = this.descriptor.getOutProcessorFactory();
        if (descriptorOutFactory != null) {
            outProcessor = new BaseInputProcessor(descriptorOutFactory.newInputProcessor(new DelegatingInputProcessor(outProcessor)));
        } else {
            ExecutionDescriptor.InputProcessorFactory2 descriptorOutFactory2 = this.descriptor.getOutProcessorFactory2();
            if (descriptorOutFactory2 != null) {
                outProcessor = descriptorOutFactory2.newInputProcessor(outProcessor);
            }
        }
        return outProcessor;
    }

    private InputProcessor createErrProcessor(OutputWriter writer) {
        ExecutionDescriptor.LineConvertorFactory convertorFactory = this.descriptor.getErrConvertorFactory();
        InputProcessor errProcessor = null;
        errProcessor = this.descriptor.isErrLineBased() ? InputProcessors.bridge((LineProcessor)LineProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, false)) : org.netbeans.api.extexecution.print.InputProcessors.printing(writer, convertorFactory != null ? convertorFactory.newLineConvertor() : null, false);
        ExecutionDescriptor.InputProcessorFactory descriptorErrFactory = this.descriptor.getErrProcessorFactory();
        if (descriptorErrFactory != null) {
            errProcessor = new BaseInputProcessor(descriptorErrFactory.newInputProcessor(new DelegatingInputProcessor(errProcessor)));
        } else {
            ExecutionDescriptor.InputProcessorFactory2 descriptorErrFactory2 = this.descriptor.getErrProcessorFactory2();
            if (descriptorErrFactory2 != null) {
                errProcessor = descriptorErrFactory2.newInputProcessor(errProcessor);
            }
        }
        return errProcessor;
    }

    static {
        RerunAction.Accessor.setDefault(new RerunAction.Accessor(){

            @Override
            public Future<Integer> run(ExecutionService service, InputOutput required) {
                return service.run(required);
            }
        });
    }

    private static class ProgressCancellable
    implements Cancellable {
        private Future<Integer> task;

        public synchronized void setTask(Future<Integer> task) {
            this.task = task;
        }

        public synchronized boolean cancel() {
            if (this.task != null) {
                this.task.cancel(true);
            }
            return true;
        }
    }

    private static class ProgressAction
    extends AbstractAction {
        private final InputOutput io;

        public ProgressAction(InputOutput io) {
            this.io = io;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.io.select();
        }
    }
}

