/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.CodegenUtils;
import org.netbeans.modules.php.editor.codegen.ComboBoxModelElement;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.SelectedPropertyMethodsCreator;
import org.netbeans.modules.php.editor.codegen.SinglePropertyMethodCreator;
import org.netbeans.modules.php.editor.codegen.ui.ConstructorPanel;
import org.netbeans.modules.php.editor.codegen.ui.MethodPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CGSGenerator
implements CodeGenerator {
    static final String START_OF_GETTER = "get";
    static final String START_OF_SETTER = "set";
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String UNDERSCORED_METHOD_NAME = "${UNDERSCORED_METHOD_NAME}";
    static final String ACCESS_MODIFIER = "${MODIFIER}";
    static final String ACCESSOR = "${ACCESSOR}";
    static final String PROPERTY = "${PROPERTY}";
    static final String PARAM_NAME = "${PARAM_NAME}";
    static final String UP_FIRST_LETTER_PROPERTY = "${UpFirstLetterProperty}";
    static final String UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE = "${UpFirstLetterPropertyWithoutUnderscore}";
    static final String ASSIGNMENT_TEMPLATE = NEW_LINE + "${ACCESSOR}${PROPERTY} = $${PARAM_NAME};";
    private static final String CURSOR = "${cursor}";
    private static final String PROPERTY_WITHOUT_UNDERSCORE = "${PropertyWithoutUnderscore}";
    private static final String PARAMS = "${PARAMS}";
    private static final String ASSIGNMENTS = "${ASSIGNMENT}";
    private static final String CONSTRUCTOR_TEMPLATE = "${MODIFIER}function __construct(${PARAMS}) {${ASSIGNMENT}${cursor}" + NEW_LINE + "}" + NEW_LINE;
    private final GenType genType;
    private final CGSInfo cgsInfo;
    private static final String GETTER_SETTER_PROJECT_PROPERTY = "getter.setter.method.name.generation";
    private static final String FLUENT_SETTER_PROJECT_PROPERTY = "fluent.setter.project.property";
    private static final String PUBLIC_MODIFIER_PROJECT_PROPERTY = "public.modifier.project.property";

    private CGSGenerator(CGSInfo cgsInfo, GenType type) {
        this.genType = type;
        this.cgsInfo = cgsInfo;
    }

    public void invoke() {
        JTextComponent component = this.cgsInfo.getComponent();
        FileObject fo = NbEditorUtilities.getFileObject((Document)component.getDocument());
        Preferences preferences = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            preferences = ProjectUtils.getPreferences((Project)project, CGSGenerator.class, (boolean)true);
            try {
                this.cgsInfo.setHowToGenerate(GenWay.valueOf(preferences.get(GETTER_SETTER_PROJECT_PROPERTY, GenWay.AS_JAVA.name())));
            }
            catch (IllegalArgumentException ex) {
                this.cgsInfo.setHowToGenerate(GenWay.AS_JAVA);
            }
            this.cgsInfo.setFluentSetter(preferences.getBoolean(FLUENT_SETTER_PROJECT_PROPERTY, false));
            this.cgsInfo.setPublicModifier(preferences.getBoolean(PUBLIC_MODIFIER_PROJECT_PROPERTY, true));
        }
        DialogDescriptor desc = new DialogDescriptor((Object)this.genType.createPanel(this.cgsInfo), this.genType.getDialogTitle());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.setVisible(true);
        dialog.dispose();
        if (desc.getValue() == DialogDescriptor.OK_OPTION) {
            CodeTemplateManager manager = CodeTemplateManager.get((Document)component.getDocument());
            CodeTemplate template = manager.createTemporary(this.genType.getTemplateText(this.cgsInfo));
            template.insert(component);
            if (preferences != null) {
                preferences.put(GETTER_SETTER_PROJECT_PROPERTY, this.cgsInfo.getHowToGenerate().name());
                preferences.putBoolean(FLUENT_SETTER_PROJECT_PROPERTY, this.cgsInfo.isFluentSetter());
                preferences.putBoolean(PUBLIC_MODIFIER_PROJECT_PROPERTY, this.cgsInfo.isPublicModifier());
            }
        }
    }

    public String getDisplayName() {
        return this.genType.getDisplayName();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GenType {
        CONSTRUCTOR(Panel.CONSTRUCTOR, Visibility.INVISIBLE, Visibility.VISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_CONSTRUCTOR");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    if (way.equals((Object)GenWay.WITH_UNDERSCORE)) continue;
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getConstructorExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_CONSTRUCTOR");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_CONSTRUCTOR");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo) {
                StringBuilder params = new StringBuilder();
                StringBuilder assignments = new StringBuilder();
                for (Property property : cgsInfo.getProperties()) {
                    String paramName;
                    String name = property.getName();
                    String string = paramName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CodegenUtils.withoutUnderscore(name) : name;
                    if (!property.isSelected()) continue;
                    params.append(", ");
                    String type = property.getType();
                    if (type != null && !type.isEmpty()) {
                        params.append(property.getTypeForTemplate());
                    }
                    params.append("$").append(paramName);
                    assignments.append(ASSIGNMENT_TEMPLATE.replace(CGSGenerator.PROPERTY, name).replace(CGSGenerator.PARAM_NAME, paramName).replace(CGSGenerator.ACCESSOR, property.getAccessor()));
                }
                if (params.length() == 0) {
                    params.append(", ");
                }
                String accessModifier = cgsInfo.isPublicModifier() ? "public " : "";
                return CONSTRUCTOR_TEMPLATE.replace(CGSGenerator.ACCESS_MODIFIER, accessModifier).replace(CGSGenerator.PARAMS, params.toString().substring(2)).replace(CGSGenerator.ASSIGNMENTS, assignments);
            }
        }
        ,
        GETTER(Panel.CONSTRUCTOR, Visibility.INVISIBLE, Visibility.VISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getGetterExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo) {
                return new SelectedPropertyMethodsCreator().create(cgsInfo.getPossibleGetters(), new SinglePropertyMethodCreator.SingleGetterCreator(cgsInfo));
            }
        }
        ,
        SETTER(Panel.CONSTRUCTOR, Visibility.VISIBLE, Visibility.VISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_SETTERS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getSetterExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_SETTER");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_SETTERS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo) {
                return new SelectedPropertyMethodsCreator().create(cgsInfo.getPossibleSetters(), new SinglePropertyMethodCreator.SingleSetterCreator(cgsInfo));
            }
        }
        ,
        GETTER_AND_SETTER(Panel.CONSTRUCTOR, Visibility.VISIBLE, Visibility.VISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS_AND_SETTERS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getGetterExample(propertyName) + ", " + way.getSetterExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER_AND_SETTER");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS_AND_SETTERS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo) {
                StringBuilder gettersAndSetters = new StringBuilder();
                gettersAndSetters.append(new SelectedPropertyMethodsCreator().create(cgsInfo.getPossibleGetters(), new SinglePropertyMethodCreator.SingleGetterCreator(cgsInfo)));
                gettersAndSetters.append(new SelectedPropertyMethodsCreator().create(cgsInfo.getPossibleSetters(), new SinglePropertyMethodCreator.SingleSetterCreator(cgsInfo)));
                return gettersAndSetters.toString();
            }
        }
        ,
        METHODS(Panel.METHOD, Visibility.INVISIBLE, Visibility.INVISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_METHODS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                return new DefaultComboBoxModel();
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_METHOD");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_METHODS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo) {
                return new SelectedPropertyMethodsCreator().create(cgsInfo.getPossibleMethods(), new SinglePropertyMethodCreator.InheritedMethodCreator(cgsInfo));
            }
        };

        private final Panel panel;
        private final Visibility fluentSetter;
        private final Visibility publicModifier;

        public abstract String getPanelTitle();

        public abstract ComboBoxModel getModel(String var1);

        public abstract String getDisplayName();

        public abstract String getDialogTitle();

        public abstract String getTemplateText(CGSInfo var1);

        private GenType(Panel panel, Visibility fluentSetter, Visibility publicModifier) {
            this.panel = panel;
            this.fluentSetter = fluentSetter;
            this.publicModifier = publicModifier;
        }

        public JPanel createPanel(CGSInfo cgsInfo) {
            return this.panel.createPanel(this, cgsInfo);
        }

        public boolean isFluentSetterVisible() {
            return this.fluentSetter.isVisible();
        }

        public boolean isPublicModifierVisible() {
            return this.publicModifier.isVisible();
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum Panel {
            CONSTRUCTOR{

                @Override
                JPanel createPanel(GenType genType, CGSInfo cgsInfo) {
                    return new ConstructorPanel(genType, cgsInfo);
                }
            }
            ,
            METHOD{

                @Override
                JPanel createPanel(GenType genType, CGSInfo cgsInfo) {
                    return new MethodPanel(cgsInfo);
                }
            };


            abstract JPanel createPanel(GenType var1, CGSInfo var2);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum Visibility {
            VISIBLE{

                @Override
                boolean isVisible() {
                    return true;
                }
            }
            ,
            INVISIBLE{

                @Override
                boolean isVisible() {
                    return false;
                }
            };


            abstract boolean isVisible();
        }
    }

    public static enum GenWay {
        AS_JAVA(NbBundle.getMessage(CGSGenerator.class, (String)"JAVA_STYLE"), "__construct($${PROPERTY})", "get${UpFirstLetterProperty}", "set${UpFirstLetterProperty}"),
        WITH_UNDERSCORE(NbBundle.getMessage(CGSGenerator.class, (String)"ADD_UNDERSCORE"), "__construct($${PROPERTY})", "get_${UNDERSCORED_METHOD_NAME}", "set_${UNDERSCORED_METHOD_NAME}"),
        WITHOUT_UNDERSCORE(NbBundle.getMessage(CGSGenerator.class, (String)"REMOVE_UNDERSCORE"), "__construct($${PropertyWithoutUnderscore})", "get${UpFirstLetterPropertyWithoutUnderscore}", "set${UpFirstLetterPropertyWithoutUnderscore}");

        private final String constructorTemplate;
        private final String getterTemplate;
        private final String setterTemplate;
        private final String simpleDescription;

        private GenWay(String simpleDescription, String constructorTemplate, String getterTemplate, String setterTemplate) {
            this.constructorTemplate = constructorTemplate;
            this.getterTemplate = getterTemplate;
            this.setterTemplate = setterTemplate;
            this.simpleDescription = simpleDescription;
        }

        public String getConstructorTemplate() {
            return this.constructorTemplate;
        }

        public String getGetterTemplate() {
            return this.getterTemplate;
        }

        public String getSetterTemplate() {
            return this.setterTemplate;
        }

        public String getSimpleDescription() {
            return this.simpleDescription;
        }

        public String getConstructorExample(String property) {
            return this.createExample(this.getConstructorTemplate(), property);
        }

        public String getGetterExample(String property) {
            return this.createExample(this.getGetterTemplate(), property);
        }

        public String getSetterExample(String property) {
            return this.createExample(this.getSetterTemplate(), property);
        }

        private String createExample(String template, String property) {
            String example = template;
            if (template.contains(CGSGenerator.PROPERTY)) {
                example = example.replace(CGSGenerator.PROPERTY, property);
            }
            if (template.contains(CGSGenerator.UNDERSCORED_METHOD_NAME)) {
                example = example.replace(CGSGenerator.UNDERSCORED_METHOD_NAME, property);
            }
            if (template.contains(CGSGenerator.UP_FIRST_LETTER_PROPERTY)) {
                example = example.replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, CodegenUtils.upFirstLetter(property));
            }
            if (template.contains(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE)) {
                example = example.replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, CodegenUtils.upFirstLetterWithoutUnderscore(property));
            }
            if (template.contains(CGSGenerator.PROPERTY_WITHOUT_UNDERSCORE)) {
                example = example.replace(CGSGenerator.PROPERTY_WITHOUT_UNDERSCORE, CodegenUtils.withoutUnderscore(property));
            }
            return example;
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            JTextComponent textComp = (JTextComponent)context.lookup(JTextComponent.class);
            ArrayList<CGSGenerator> ret = new ArrayList<CGSGenerator>();
            CGSInfo info = CGSInfo.getCGSInfo(textComp);
            if (info.getClassName() != null) {
                if (!info.hasConstructor()) {
                    ret.add(new CGSGenerator(info, GenType.CONSTRUCTOR));
                }
                if (info.getPossibleGetters().size() > 0) {
                    ret.add(new CGSGenerator(info, GenType.GETTER));
                }
                if (info.getPossibleSetters().size() > 0) {
                    ret.add(new CGSGenerator(info, GenType.SETTER));
                }
                if (info.getPossibleGettersSetters().size() > 0) {
                    ret.add(new CGSGenerator(info, GenType.GETTER_AND_SETTER));
                }
                if (info.getPossibleMethods().size() > 0) {
                    ret.add(new CGSGenerator(info, GenType.METHODS));
                }
            }
            return ret;
        }
    }
}

