/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.EnumElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.EnumDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.openide.util.Parameters;

public final class EnumElementImpl
extends TypeElementImpl
implements EnumElement {
    public static final String IDX_FIELD = "enum";
    private final Collection<QualifiedName> usedTraits;
    private final QualifiedName backingType;

    private EnumElementImpl(QualifiedName qualifiedName, int offset, QualifiedName backingType, Set<QualifiedName> ifaceNames, Collection<QualifiedName> fqSuperInterfaces, int flags, Collection<QualifiedName> usedTraits, String fileUrl, ElementQuery elementQuery, boolean isDeprecated) {
        super(qualifiedName, offset, ifaceNames, fqSuperInterfaces, flags, fileUrl, elementQuery, isDeprecated);
        this.backingType = backingType;
        this.usedTraits = usedTraits;
    }

    public static Set<EnumElement> fromSignature(IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return EnumElementImpl.fromSignature((NameKind)NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<EnumElement> fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<EnumElement> retval = values.length > 0 ? new HashSet<EnumElement>() : Collections.emptySet();
        for (String val : values) {
            EnumElement enumElement = EnumElementImpl.fromSignature(query, indexScopeQuery, Signature.get(val));
            if (enumElement == null) continue;
            retval.add(enumElement);
        }
        return retval;
    }

    @CheckForNull
    private static EnumElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, Signature enumSignature) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        EnumSignatureParser signParser = new EnumSignatureParser(enumSignature);
        EnumElementImpl retval = null;
        if (EnumElementImpl.matchesQuery(query, signParser)) {
            retval = new EnumElementImpl(signParser.getQualifiedName(), signParser.getOffset(), QualifiedName.create(signParser.getBackingType()), signParser.getSuperInterfaces(), signParser.getFQSuperInterfaces(), signParser.getFlags(), signParser.getUsedTraits(), signParser.getFileUrl(), indexScopeQuery, signParser.isDeprecated());
        }
        return retval;
    }

    public static EnumElement fromNode(NamespaceElement namespace, EnumDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        EnumDeclarationInfo info = EnumDeclarationInfo.create(node);
        QualifiedName fullyQualifiedName = namespace != null ? namespace.getFullyQualifiedName() : QualifiedName.createForDefaultNamespaceName();
        return new EnumElementImpl(fullyQualifiedName.append(info.getName()), info.getRange().getStart(), info.getBackingType(), info.getInterfaceNames(), Collections.emptySet(), 0, info.getUsedTraits(), fileQuery.getURL().toExternalForm(), fileQuery, VariousUtils.isDeprecatedFromPHPDoc(fileQuery.getResult().getProgram(), node));
    }

    public static EnumElement fromFrameworks(PhpClass clz, ElementQuery elementQuery) {
        Parameters.notNull((CharSequence)"clz", (Object)clz);
        Parameters.notNull((CharSequence)"elementQuery", (Object)elementQuery);
        String fullyQualifiedName = clz.getFullyQualifiedName();
        EnumElementImpl retval = new EnumElementImpl(QualifiedName.create(fullyQualifiedName == null ? clz.getName() : fullyQualifiedName), clz.getOffset(), null, Collections.emptySet(), Collections.emptySet(), 0, Collections.emptySet(), null, elementQuery, false);
        retval.setFileObject(clz.getFile());
        return retval;
    }

    private static boolean matchesQuery(NameKind query, EnumSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(EnumElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return KIND;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        QualifiedName namespaceName = this.getNamespaceName();
        sb.append(namespaceName.toString()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getBackingTypeName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        StringBuilder ifaceSb = new StringBuilder();
        for (QualifiedName ifaceName : this.getSuperInterfaces()) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append((Object)PhpElementImpl.Separator.COMMA);
            }
            ifaceSb.append(ifaceName.toString());
        }
        sb.append((CharSequence)ifaceSb);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        if (!this.usedTraits.isEmpty()) {
            StringBuilder traitSb = new StringBuilder();
            for (QualifiedName usedTrait : this.usedTraits) {
                if (traitSb.length() > 0) {
                    traitSb.append((Object)PhpElementImpl.Separator.COMMA);
                }
                traitSb.append(usedTrait.toString());
            }
            sb.append((CharSequence)traitSb);
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        this.checkClassSignature(sb);
        return sb.toString();
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
                this.printAsSuperTypes(retval);
                break;
            }
            case SuperTypes: {
                this.printAsSuperTypes(retval);
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return retval.toString();
    }

    private void printAsSuperTypes(StringBuilder sb) {
        Set<QualifiedName> superIfaces = this.getSuperInterfaces();
        if (!superIfaces.isEmpty()) {
            sb.append(" implements ");
        }
        StringBuilder ifacesBuffer = new StringBuilder();
        for (QualifiedName qualifiedName : superIfaces) {
            if (ifacesBuffer.length() > 0) {
                ifacesBuffer.append(", ");
            }
            ifacesBuffer.append(qualifiedName.getName());
        }
        sb.append((CharSequence)ifacesBuffer);
    }

    private void checkClassSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            EnumSignatureParser parser = new EnumSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            assert (this.getSuperInterfaces().size() == parser.getSuperInterfaces().size());
            assert (this.getBackingTypeName().equals(parser.getBackingType()));
        }
    }

    @Override
    public Collection<QualifiedName> getUsedTraits() {
        return Collections.unmodifiableCollection(this.usedTraits);
    }

    @Override
    @CheckForNull
    public QualifiedName getBackingType() {
        return this.backingType;
    }

    @NonNull
    private String getBackingTypeName() {
        return this.backingType == null ? "" : this.backingType.toString();
    }

    private static class EnumSignatureParser {
        private final Signature signature;

        EnumSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.getNamespaceName(), this.getName());
        }

        public Set<QualifiedName> getSuperInterfaces() {
            int index;
            Set<QualifiedName> ifaces = Collections.emptySet();
            String separatedIfaces = this.getInterfaces();
            if (separatedIfaces.length() > 0 && (index = separatedIfaces.indexOf(PhpElementImpl.Separator.PIPE.toString())) > 0) {
                String[] ifaceNames;
                String field = separatedIfaces.substring(0, index);
                ifaces = new HashSet<QualifiedName>();
                for (String ifName : ifaceNames = field.split(PhpElementImpl.Separator.COMMA.toString())) {
                    ifaces.add(QualifiedName.create(ifName));
                }
            }
            return ifaces;
        }

        public Collection<QualifiedName> getFQSuperInterfaces() {
            Collection<QualifiedName> retval = Collections.emptySet();
            String separatedIfaces = this.getInterfaces();
            int index = separatedIfaces.indexOf(PhpElementImpl.Separator.PIPE.toString());
            if (index > 0) {
                String fqInterfaces = separatedIfaces.substring(index + 1);
                String[] fqInterfaceNames = fqInterfaces.split(PhpElementImpl.Separator.COMMA.toString());
                retval = new ArrayList();
                for (String interfaceName : fqInterfaceNames) {
                    retval.add(QualifiedName.create(interfaceName));
                }
            }
            return retval;
        }

        @NonNull
        String getName() {
            return this.signature.string(SigElement.NAME.getIndex());
        }

        int getOffset() {
            return this.signature.integer(SigElement.OFFSET.getIndex());
        }

        @NonNull
        String getNamespaceName() {
            return this.signature.string(SigElement.NAMESPACE_NAME.getIndex());
        }

        @NonNull
        String getBackingType() {
            return this.signature.string(SigElement.BACKING_TYPE.getIndex());
        }

        @NonNull
        String getInterfaces() {
            return this.signature.string(SigElement.INTERFACES.getIndex());
        }

        int getFlags() {
            return this.signature.integer(SigElement.MODIFIERS.getIndex());
        }

        @NonNull
        String getTraits() {
            return this.signature.string(SigElement.USED_TRAITS.getIndex());
        }

        int getDeprecated() {
            return this.signature.integer(SigElement.DEPRECATED.getIndex());
        }

        public Collection<QualifiedName> getUsedTraits() {
            String[] traitNames;
            HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
            String traits = this.getTraits();
            for (String trait : traitNames = traits.split(PhpElementImpl.Separator.COMMA.toString())) {
                retval.add(QualifiedName.create(trait));
            }
            return retval;
        }

        boolean isDeprecated() {
            return this.getDeprecated() == 1;
        }

        @NonNull
        String getFileUrl() {
            return this.signature.string(SigElement.FILENAME_URL.getIndex());
        }
    }

    private static enum SigElement {
        NAME_LOWERCASE(0),
        NAME(1),
        OFFSET(2),
        NAMESPACE_NAME(3),
        BACKING_TYPE(4),
        INTERFACES(5),
        MODIFIERS(6),
        USED_TRAITS(7),
        DEPRECATED(8),
        FILENAME_URL(9);

        private final int index;

        private SigElement(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

