/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public class CodeCompletionPanel
extends JPanel {
    private static final long serialVersionUID = -24730122182427272L;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();
    static final String PHP_AUTO_COMPLETION_FULL = "phpAutoCompletionFull";
    static final String PHP_AUTO_COMPLETION_VARIABLES = "phpAutoCompletionVariables";
    static final String PHP_AUTO_COMPLETION_TYPES = "phpAutoCompletionTypes";
    static final String PHP_AUTO_COMPLETION_NAMESPACES = "phpAutoCompletionNamespaces";
    static final String PHP_CODE_COMPLETION_STATIC_METHODS = "phpCodeCompletionStaticMethods";
    static final String PHP_CODE_COMPLETION_NON_STATIC_METHODS = "phpCodeCompletionNonStaticMethods";
    static final String PHP_CODE_COMPLETION_VARIABLES_SCOPE = "phpCodeCompletionVariablesScope";
    static final String PHP_CODE_COMPLETION_TYPE = "phpCodeCompletionType";
    static final String PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING = "phpCodeCompletionSmartParametersPreFilling";
    static final String PHP_CODE_COMPLETION_FIRST_CLASS_CALLABLE = "phpCodeCompletionFirstClassCallable";
    static final String PHP_AUTO_COMPLETION_SMART_QUOTES = "phpCodeCompletionSmartQuotes";
    static final String PHP_AUTO_STRING_CONCATINATION = "phpCodeCompletionStringAutoConcatination";
    static final String PHP_AUTO_COMPLETION_USE_LOWERCASE_TRUE_FALSE_NULL = "phpAutoCompletionUseLowercaseTrueFalseNull";
    static final String PHP_AUTO_COMPLETION_COMMENT_ASTERISK = "phpAutoCompletionCommentAsterisk";
    static final String PHP_AUTO_IMPORT = "phpAutoImport";
    static final String PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE = "phpAutoImportGlobalNSImportType";
    static final String PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION = "phpAutoImportGlobalNSImportFunction";
    static final String PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST = "phpAutoImportGlobalNSImportConst";
    static final String PHP_AUTO_IMPORT_FILE_SCOPE = "phpAutoImportFileScope";
    static final String PHP_AUTO_IMPORT_NAMESPACE_SCOPE = "phpAutoImportNamespaceScope";
    static final boolean PHP_AUTO_COMPLETION_FULL_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_VARIABLES_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_TYPES_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_NAMESPACES_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_STATIC_METHODS_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_NON_STATIC_METHODS_DEFAULT = false;
    static final boolean PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_FIRST_CLASS_CALLABLE_DEFAULT = false;
    static final boolean PHP_AUTO_COMPLETION_SMART_QUOTES_DEFAULT = true;
    static final boolean PHP_AUTO_STRING_CONCATINATION_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_USE_LOWERCASE_TRUE_FALSE_NULL_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_COMMENT_ASTERISK_DEFAULT = true;
    static final boolean PHP_AUTO_IMPORT_DEFAULT = false;
    static final boolean PHP_AUTO_IMPORT_FILE_SCOPE_DEFAULT = false;
    static final boolean PHP_AUTO_IMPORT_NAMESPACE_SCOPE_DEFAULT = true;
    static final String PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE_DEFAULT = GlobalNamespaceAutoImportType.DO_NOT_IMPORT.name();
    static final String PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION_DEFAULT = GlobalNamespaceAutoImportType.DO_NOT_IMPORT.name();
    static final String PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST_DEFAULT = GlobalNamespaceAutoImportType.DO_NOT_IMPORT.name();
    private final Preferences preferences;
    private final ItemListener defaultCheckBoxListener = new DefaultCheckBoxListener();
    private final ItemListener defaultRadioButtonListener = new DefaultRadioButtonListener();
    private JRadioButton allVariablesRadioButton;
    private ButtonGroup autoCompletionButtonGroup;
    private JCheckBox autoCompletionCommentAsteriskCheckBox;
    private JLabel autoCompletionCommentAsteriskLabel;
    private JRadioButton autoCompletionCustomizeRadioButton;
    private JRadioButton autoCompletionFullRadioButton;
    private JCheckBox autoCompletionNamespacesCheckBox;
    private JCheckBox autoCompletionSmartQuotesCheckBox;
    private JLabel autoCompletionSmartQuotesLabel;
    private JCheckBox autoCompletionTypesCheckBox;
    private JCheckBox autoCompletionVariablesCheckBox;
    private JCheckBox autoImportCheckBox;
    private JCheckBox autoImportFileScopeCheckBox;
    private JLabel autoImportForScopeLabel;
    private ButtonGroup autoImportGlobalNSConstbuttonGroup;
    private ButtonGroup autoImportGlobalNSFunctionbuttonGroup;
    private ButtonGroup autoImportGlobalNSTypebuttonGroup;
    private JRadioButton autoImportGlobalNamespaceConstDoNotImportRadioButton;
    private JRadioButton autoImportGlobalNamespaceConstImportRadioButton;
    private JLabel autoImportGlobalNamespaceConstLabel;
    private JRadioButton autoImportGlobalNamespaceFunctionDoNotImportRadioButton;
    private JRadioButton autoImportGlobalNamespaceFunctionImportRadioButton;
    private JLabel autoImportGlobalNamespaceFunctionLabel;
    private JLabel autoImportGlobalNamespaceLabel;
    private JRadioButton autoImportGlobalNamespaceTypeDoNotImportRadioButton;
    private JRadioButton autoImportGlobalNamespaceTypeImportRadioButton;
    private JLabel autoImportGlobalNamespaceTypeLabel;
    private JLabel autoImportInfoLabel;
    private JCheckBox autoImportNamesapceScopeCheckBox;
    private JCheckBox autoStringConcatenationCheckBox;
    private JCheckBox codeCompletionFirstClassCallableCheckBox;
    private JCheckBox codeCompletionNonStaticMethodsCheckBox;
    private JCheckBox codeCompletionSmartParametersPreFillingCheckBox;
    private JCheckBox codeCompletionStaticMethodsCheckBox;
    private ButtonGroup codeCompletionTypeButtonGroup;
    private JLabel codeCompletionTypeLabel;
    private ButtonGroup codeCompletionVariablesScopeButtonGroup;
    private JLabel codeCompletionVariablesScopeLabel;
    private JRadioButton currentFileVariablesRadioButton;
    private JLabel enableAutocompletionLabel;
    private JLabel fullyQualifiedInfoLabel;
    private JRadioButton fullyQualifiedRadioButton;
    private JLabel methodCodeCompletionLabel;
    private JLabel smartInfoLabel;
    private JRadioButton smartRadioButton;
    private JCheckBox trueFalseNullCheckBox;
    private JLabel unqualifiedInfoLabel;
    private JRadioButton unqualifiedRadioButton;
    private JLabel useLowercaseLabel;

    public CodeCompletionPanel(Preferences preferences) {
        assert (preferences != null);
        this.preferences = preferences;
        this.initComponents();
        this.initAutoCompletion();
        this.initCodeCompletionForMethods();
        this.initCodeCompletionForVariables();
        this.initCodeCompletionType();
        this.initGlobalNamespaceAutoImportType();
        this.id2Saved.put(PHP_AUTO_COMPLETION_FULL, this.autoCompletionFullRadioButton.isSelected());
        this.id2Saved.put(PHP_AUTO_COMPLETION_VARIABLES, this.autoCompletionVariablesCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_COMPLETION_TYPES, this.autoCompletionTypesCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_COMPLETION_NAMESPACES, this.autoCompletionNamespacesCheckBox.isSelected());
        this.id2Saved.put(PHP_CODE_COMPLETION_STATIC_METHODS, this.codeCompletionStaticMethodsCheckBox.isSelected());
        this.id2Saved.put(PHP_CODE_COMPLETION_NON_STATIC_METHODS, this.codeCompletionNonStaticMethodsCheckBox.isSelected());
        VariablesScope variablesScope = VariablesScope.resolve(preferences.get(PHP_CODE_COMPLETION_VARIABLES_SCOPE, null));
        this.id2Saved.put(PHP_CODE_COMPLETION_VARIABLES_SCOPE, variablesScope == null ? null : variablesScope.name());
        CodeCompletionType type = CodeCompletionType.resolve(preferences.get(PHP_CODE_COMPLETION_TYPE, null));
        this.id2Saved.put(PHP_CODE_COMPLETION_TYPE, type == null ? null : type.name());
        this.id2Saved.put(PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING, this.codeCompletionSmartParametersPreFillingCheckBox.isSelected());
        this.id2Saved.put(PHP_CODE_COMPLETION_FIRST_CLASS_CALLABLE, this.codeCompletionFirstClassCallableCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_COMPLETION_SMART_QUOTES, this.autoCompletionSmartQuotesCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_STRING_CONCATINATION, this.autoStringConcatenationCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_COMPLETION_USE_LOWERCASE_TRUE_FALSE_NULL, this.trueFalseNullCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_COMPLETION_COMMENT_ASTERISK, this.autoCompletionCommentAsteriskCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_IMPORT, this.autoImportCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_IMPORT_FILE_SCOPE, this.autoImportFileScopeCheckBox.isSelected());
        this.id2Saved.put(PHP_AUTO_IMPORT_NAMESPACE_SCOPE, this.autoImportNamesapceScopeCheckBox.isSelected());
        GlobalNamespaceAutoImportType typeType = GlobalNamespaceAutoImportType.resolve(preferences.get(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE, PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE_DEFAULT));
        this.id2Saved.put(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE, typeType == null ? null : typeType.name());
        GlobalNamespaceAutoImportType functionType = GlobalNamespaceAutoImportType.resolve(preferences.get(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION, PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION_DEFAULT));
        this.id2Saved.put(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION, functionType == null ? null : functionType.name());
        GlobalNamespaceAutoImportType constType = GlobalNamespaceAutoImportType.resolve(preferences.get(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST, PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST_DEFAULT));
        this.id2Saved.put(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST, constType == null ? null : constType.name());
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCustomizer(preferences);
            }
        };
    }

    private void initAutoCompletion() {
        this.autoCompletionFullRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CodeCompletionPanel.this.setAutoCompletionState(false);
                }
            }
        });
        this.autoCompletionCustomizeRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CodeCompletionPanel.this.setAutoCompletionState(true);
                }
            }
        });
        boolean autoCompletionFull = this.preferences.getBoolean(PHP_AUTO_COMPLETION_FULL, true);
        if (autoCompletionFull) {
            this.autoCompletionFullRadioButton.setSelected(true);
        } else {
            this.autoCompletionCustomizeRadioButton.setSelected(true);
        }
        this.autoCompletionFullRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.autoCompletionCustomizeRadioButton.addItemListener(this.defaultRadioButtonListener);
        boolean autoCompletionVariables = this.preferences.getBoolean(PHP_AUTO_COMPLETION_VARIABLES, true);
        this.autoCompletionVariablesCheckBox.setSelected(autoCompletionVariables);
        this.autoCompletionVariablesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoCompletionTypes = this.preferences.getBoolean(PHP_AUTO_COMPLETION_TYPES, true);
        this.autoCompletionTypesCheckBox.setSelected(autoCompletionTypes);
        this.autoCompletionTypesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoCompletionNamespaces = this.preferences.getBoolean(PHP_AUTO_COMPLETION_NAMESPACES, true);
        this.autoCompletionNamespacesCheckBox.setSelected(autoCompletionNamespaces);
        this.autoCompletionNamespacesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionSmartQuotes = this.preferences.getBoolean(PHP_AUTO_COMPLETION_SMART_QUOTES, true);
        this.autoCompletionSmartQuotesCheckBox.setSelected(codeCompletionSmartQuotes);
        this.autoCompletionSmartQuotesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionStringAutoConcatination = this.preferences.getBoolean(PHP_AUTO_STRING_CONCATINATION, true);
        this.autoStringConcatenationCheckBox.setSelected(codeCompletionStringAutoConcatination);
        this.autoStringConcatenationCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionUseLowercaseTrueFalseNull = this.preferences.getBoolean(PHP_AUTO_COMPLETION_USE_LOWERCASE_TRUE_FALSE_NULL, true);
        this.trueFalseNullCheckBox.setSelected(codeCompletionUseLowercaseTrueFalseNull);
        this.trueFalseNullCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionCommentAsterisk = this.preferences.getBoolean(PHP_AUTO_COMPLETION_COMMENT_ASTERISK, true);
        this.autoCompletionCommentAsteriskCheckBox.setSelected(codeCompletionCommentAsterisk);
        this.autoCompletionCommentAsteriskCheckBox.addItemListener(this.defaultCheckBoxListener);
    }

    private void initCodeCompletionForMethods() {
        boolean codeCompletionStaticMethods = this.preferences.getBoolean(PHP_CODE_COMPLETION_STATIC_METHODS, true);
        this.codeCompletionStaticMethodsCheckBox.setSelected(codeCompletionStaticMethods);
        this.codeCompletionStaticMethodsCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionNonStaticMethods = this.preferences.getBoolean(PHP_CODE_COMPLETION_NON_STATIC_METHODS, false);
        this.codeCompletionNonStaticMethodsCheckBox.setSelected(codeCompletionNonStaticMethods);
        this.codeCompletionNonStaticMethodsCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionSmartParametersPreFilling = this.preferences.getBoolean(PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING, true);
        this.codeCompletionSmartParametersPreFillingCheckBox.setSelected(codeCompletionSmartParametersPreFilling);
        this.codeCompletionSmartParametersPreFillingCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionFirstClassCallable = this.preferences.getBoolean(PHP_CODE_COMPLETION_FIRST_CLASS_CALLABLE, false);
        this.codeCompletionFirstClassCallableCheckBox.setSelected(codeCompletionFirstClassCallable);
        this.codeCompletionFirstClassCallableCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoImport = this.preferences.getBoolean(PHP_AUTO_IMPORT, false);
        this.autoImportCheckBox.setSelected(autoImport);
        this.autoImportCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoImportFileScope = this.preferences.getBoolean(PHP_AUTO_IMPORT_FILE_SCOPE, false);
        this.autoImportFileScopeCheckBox.setSelected(autoImportFileScope);
        this.autoImportFileScopeCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoImportNamespaceScope = this.preferences.getBoolean(PHP_AUTO_IMPORT_NAMESPACE_SCOPE, true);
        this.autoImportNamesapceScopeCheckBox.setSelected(autoImportNamespaceScope);
        this.autoImportNamesapceScopeCheckBox.addItemListener(this.defaultCheckBoxListener);
    }

    private void initCodeCompletionForVariables() {
        VariablesScope variablesScope = VariablesScope.resolve(this.preferences.get(PHP_CODE_COMPLETION_VARIABLES_SCOPE, null));
        switch (variablesScope.ordinal()) {
            case 0: {
                this.allVariablesRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.currentFileVariablesRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variables scope: " + String.valueOf((Object)variablesScope));
            }
        }
        this.allVariablesRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.currentFileVariablesRadioButton.addItemListener(this.defaultRadioButtonListener);
    }

    private void initCodeCompletionType() {
        CodeCompletionType type = CodeCompletionType.resolve(this.preferences.get(PHP_CODE_COMPLETION_TYPE, null));
        switch (type.ordinal()) {
            case 0: {
                this.smartRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.fullyQualifiedRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.unqualifiedRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown code completion type: " + String.valueOf((Object)type));
            }
        }
        this.smartRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.fullyQualifiedRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.unqualifiedRadioButton.addItemListener(this.defaultRadioButtonListener);
    }

    private void initGlobalNamespaceAutoImportType() {
        GlobalNamespaceAutoImportType typeType = GlobalNamespaceAutoImportType.resolve(this.preferences.get(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE, GlobalNamespaceAutoImportType.IMPORT.name()));
        this.initAutoImportButton(typeType, this.autoImportGlobalNamespaceTypeImportRadioButton, this.autoImportGlobalNamespaceTypeDoNotImportRadioButton);
        GlobalNamespaceAutoImportType functionType = GlobalNamespaceAutoImportType.resolve(this.preferences.get(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION, GlobalNamespaceAutoImportType.DO_NOT_IMPORT.name()));
        this.initAutoImportButton(functionType, this.autoImportGlobalNamespaceFunctionImportRadioButton, this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton);
        GlobalNamespaceAutoImportType constType = GlobalNamespaceAutoImportType.resolve(this.preferences.get(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST, GlobalNamespaceAutoImportType.DO_NOT_IMPORT.name()));
        this.initAutoImportButton(constType, this.autoImportGlobalNamespaceConstImportRadioButton, this.autoImportGlobalNamespaceConstDoNotImportRadioButton);
    }

    private void initAutoImportButton(GlobalNamespaceAutoImportType type, JRadioButton importButton, JRadioButton doNotImportButton) {
        switch (type.ordinal()) {
            case 0: {
                importButton.setSelected(true);
                break;
            }
            case 1: {
                doNotImportButton.setSelected(true);
                break;
            }
            default: {
                assert (false) : "Unknown Import Type: " + String.valueOf((Object)type);
                break;
            }
        }
        importButton.addItemListener(this.defaultRadioButtonListener);
        doNotImportButton.addItemListener(this.defaultRadioButtonListener);
    }

    void validateData() {
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_FULL, this.autoCompletionFullRadioButton.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_VARIABLES, this.autoCompletionVariablesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_TYPES, this.autoCompletionTypesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_NAMESPACES, this.autoCompletionNamespacesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_STATIC_METHODS, this.codeCompletionStaticMethodsCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_NON_STATIC_METHODS, this.codeCompletionNonStaticMethodsCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING, this.codeCompletionSmartParametersPreFillingCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_FIRST_CLASS_CALLABLE, this.codeCompletionFirstClassCallableCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_SMART_QUOTES, this.autoCompletionSmartQuotesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_STRING_CONCATINATION, this.autoStringConcatenationCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_USE_LOWERCASE_TRUE_FALSE_NULL, this.trueFalseNullCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_COMMENT_ASTERISK, this.autoCompletionCommentAsteriskCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_IMPORT, this.autoImportCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_IMPORT_FILE_SCOPE, this.autoImportFileScopeCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_IMPORT_NAMESPACE_SCOPE, this.autoImportNamesapceScopeCheckBox.isSelected());
        VariablesScope variablesScope = null;
        if (this.allVariablesRadioButton.isSelected()) {
            variablesScope = VariablesScope.ALL;
        } else if (this.currentFileVariablesRadioButton.isSelected()) {
            variablesScope = VariablesScope.CURRENT_FILE;
        }
        assert (variablesScope != null);
        this.preferences.put(PHP_CODE_COMPLETION_VARIABLES_SCOPE, variablesScope.name());
        CodeCompletionType type = null;
        if (this.smartRadioButton.isSelected()) {
            type = CodeCompletionType.SMART;
        } else if (this.fullyQualifiedRadioButton.isSelected()) {
            type = CodeCompletionType.FULLY_QUALIFIED;
        } else if (this.unqualifiedRadioButton.isSelected()) {
            type = CodeCompletionType.UNQUALIFIED;
        }
        assert (type != null);
        this.preferences.put(PHP_CODE_COMPLETION_TYPE, type.name());
        GlobalNamespaceAutoImportType typeType = null;
        if (this.autoImportGlobalNamespaceTypeImportRadioButton.isSelected()) {
            typeType = GlobalNamespaceAutoImportType.IMPORT;
        } else if (this.autoImportGlobalNamespaceTypeDoNotImportRadioButton.isSelected()) {
            typeType = GlobalNamespaceAutoImportType.DO_NOT_IMPORT;
        }
        assert (typeType != null);
        this.preferences.put(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_TYPE, typeType.name());
        GlobalNamespaceAutoImportType functionType = null;
        if (this.autoImportGlobalNamespaceFunctionImportRadioButton.isSelected()) {
            functionType = GlobalNamespaceAutoImportType.IMPORT;
        } else if (this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton.isSelected()) {
            functionType = GlobalNamespaceAutoImportType.DO_NOT_IMPORT;
        }
        assert (functionType != null);
        this.preferences.put(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_FUNCTION, functionType.name());
        GlobalNamespaceAutoImportType constType = null;
        if (this.autoImportGlobalNamespaceConstImportRadioButton.isSelected()) {
            constType = GlobalNamespaceAutoImportType.IMPORT;
        } else if (this.autoImportGlobalNamespaceConstDoNotImportRadioButton.isSelected()) {
            constType = GlobalNamespaceAutoImportType.DO_NOT_IMPORT;
        }
        assert (constType != null);
        this.preferences.put(PHP_AUTO_IMPORT_GLOBAL_NS_IMPORT_CONST, constType.name());
    }

    void setAutoCompletionState(boolean enabled) {
        this.autoCompletionVariablesCheckBox.setEnabled(enabled);
        this.autoCompletionTypesCheckBox.setEnabled(enabled);
        this.autoCompletionNamespacesCheckBox.setEnabled(enabled);
    }

    private void initComponents() {
        this.codeCompletionTypeButtonGroup = new ButtonGroup();
        this.codeCompletionVariablesScopeButtonGroup = new ButtonGroup();
        this.autoCompletionButtonGroup = new ButtonGroup();
        this.autoImportGlobalNSTypebuttonGroup = new ButtonGroup();
        this.autoImportGlobalNSFunctionbuttonGroup = new ButtonGroup();
        this.autoImportGlobalNSConstbuttonGroup = new ButtonGroup();
        this.enableAutocompletionLabel = new JLabel();
        this.autoCompletionFullRadioButton = new JRadioButton();
        this.autoCompletionCustomizeRadioButton = new JRadioButton();
        this.autoCompletionVariablesCheckBox = new JCheckBox();
        this.autoCompletionTypesCheckBox = new JCheckBox();
        this.autoCompletionNamespacesCheckBox = new JCheckBox();
        this.methodCodeCompletionLabel = new JLabel();
        this.codeCompletionStaticMethodsCheckBox = new JCheckBox();
        this.codeCompletionNonStaticMethodsCheckBox = new JCheckBox();
        this.codeCompletionVariablesScopeLabel = new JLabel();
        this.allVariablesRadioButton = new JRadioButton();
        this.currentFileVariablesRadioButton = new JRadioButton();
        this.codeCompletionTypeLabel = new JLabel();
        this.smartRadioButton = new JRadioButton();
        this.smartInfoLabel = new JLabel();
        this.fullyQualifiedRadioButton = new JRadioButton();
        this.fullyQualifiedInfoLabel = new JLabel();
        this.unqualifiedRadioButton = new JRadioButton();
        this.unqualifiedInfoLabel = new JLabel();
        this.autoImportInfoLabel = new JLabel();
        this.codeCompletionSmartParametersPreFillingCheckBox = new JCheckBox();
        this.codeCompletionFirstClassCallableCheckBox = new JCheckBox();
        this.autoCompletionSmartQuotesLabel = new JLabel();
        this.autoCompletionSmartQuotesCheckBox = new JCheckBox();
        this.autoStringConcatenationCheckBox = new JCheckBox();
        this.useLowercaseLabel = new JLabel();
        this.trueFalseNullCheckBox = new JCheckBox();
        this.autoCompletionCommentAsteriskLabel = new JLabel();
        this.autoCompletionCommentAsteriskCheckBox = new JCheckBox();
        this.autoImportGlobalNamespaceLabel = new JLabel();
        this.autoImportGlobalNamespaceTypeLabel = new JLabel();
        this.autoImportGlobalNamespaceTypeImportRadioButton = new JRadioButton();
        this.autoImportGlobalNamespaceTypeDoNotImportRadioButton = new JRadioButton();
        this.autoImportGlobalNamespaceFunctionLabel = new JLabel();
        this.autoImportGlobalNamespaceFunctionImportRadioButton = new JRadioButton();
        this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton = new JRadioButton();
        this.autoImportGlobalNamespaceConstLabel = new JLabel();
        this.autoImportGlobalNamespaceConstImportRadioButton = new JRadioButton();
        this.autoImportGlobalNamespaceConstDoNotImportRadioButton = new JRadioButton();
        this.autoImportForScopeLabel = new JLabel();
        this.autoImportFileScopeCheckBox = new JCheckBox();
        this.autoImportNamesapceScopeCheckBox = new JCheckBox();
        this.autoImportCheckBox = new JCheckBox();
        this.enableAutocompletionLabel.setLabelFor(this.autoCompletionFullRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.enableAutocompletionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.text"));
        this.autoCompletionButtonGroup.add(this.autoCompletionFullRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionFullRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.text"));
        this.autoCompletionButtonGroup.add(this.autoCompletionCustomizeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionCustomizeRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionVariablesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionTypesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionNamespacesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.text"));
        this.methodCodeCompletionLabel.setLabelFor(this.codeCompletionStaticMethodsCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.methodCodeCompletionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.text"));
        this.codeCompletionStaticMethodsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionStaticMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionNonStaticMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.text"));
        this.codeCompletionVariablesScopeLabel.setLabelFor(this.allVariablesRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.codeCompletionVariablesScopeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.text"));
        this.codeCompletionVariablesScopeButtonGroup.add(this.allVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.allVariablesRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.text"));
        this.codeCompletionVariablesScopeButtonGroup.add(this.currentFileVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.currentFileVariablesRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.text"));
        this.codeCompletionTypeLabel.setLabelFor(this.smartRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.codeCompletionTypeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.smartRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.smartRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.text"));
        this.smartInfoLabel.setLabelFor(this.smartRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.smartInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartInfoLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.fullyQualifiedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.fullyQualifiedRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.text"));
        this.fullyQualifiedInfoLabel.setLabelFor(this.fullyQualifiedRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.fullyQualifiedInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.unqualifiedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.unqualifiedRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.text"));
        this.unqualifiedInfoLabel.setLabelFor(this.unqualifiedRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.unqualifiedInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.autoImportInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportInfoLabel.text"));
        this.codeCompletionSmartParametersPreFillingCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionSmartParametersPreFillingCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionSmartParametersPreFillingCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionFirstClassCallableCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionFirstClassCallableCheckBox.text"));
        this.autoCompletionSmartQuotesLabel.setLabelFor(this.autoCompletionSmartQuotesCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionSmartQuotesLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionSmartQuotesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionSmartQuotesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionSmartQuotesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoStringConcatenationCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoStringConcatenationCheckBox.text"));
        this.useLowercaseLabel.setLabelFor(this.trueFalseNullCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.useLowercaseLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.useLowercaseLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.trueFalseNullCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.trueFalseNullCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionCommentAsteriskLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCommentAsteriskLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionCommentAsteriskCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCommentAsteriskCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.autoImportGlobalNamespaceLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceLabel.text"));
        this.autoImportGlobalNamespaceTypeLabel.setLabelFor(this.autoImportGlobalNamespaceTypeImportRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.autoImportGlobalNamespaceTypeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceTypeLabel.text"));
        this.autoImportGlobalNSTypebuttonGroup.add(this.autoImportGlobalNamespaceTypeImportRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportGlobalNamespaceTypeImportRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceTypeImportRadioButton.text"));
        this.autoImportGlobalNSTypebuttonGroup.add(this.autoImportGlobalNamespaceTypeDoNotImportRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportGlobalNamespaceTypeDoNotImportRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceTypeDoNotImportRadioButton.text"));
        this.autoImportGlobalNamespaceFunctionLabel.setLabelFor(this.autoImportGlobalNamespaceFunctionImportRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.autoImportGlobalNamespaceFunctionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceFunctionLabel.text"));
        this.autoImportGlobalNSFunctionbuttonGroup.add(this.autoImportGlobalNamespaceFunctionImportRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportGlobalNamespaceFunctionImportRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceFunctionImportRadioButton.text"));
        this.autoImportGlobalNSFunctionbuttonGroup.add(this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceFunctionDoNotImportRadioButton.text"));
        this.autoImportGlobalNamespaceConstLabel.setLabelFor(this.autoImportGlobalNamespaceConstImportRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.autoImportGlobalNamespaceConstLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceConstLabel.text"));
        this.autoImportGlobalNSConstbuttonGroup.add(this.autoImportGlobalNamespaceConstImportRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportGlobalNamespaceConstImportRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceConstImportRadioButton.text"));
        this.autoImportGlobalNSConstbuttonGroup.add(this.autoImportGlobalNamespaceConstDoNotImportRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportGlobalNamespaceConstDoNotImportRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportGlobalNamespaceConstDoNotImportRadioButton.text"));
        this.autoImportForScopeLabel.setLabelFor(this.autoImportFileScopeCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.autoImportForScopeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportForScopeLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportFileScopeCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportFileScopeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportNamesapceScopeCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportNamesapceScopeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoImportCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoImportCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.autoImportInfoLabel, -2, -1, -2)).addComponent(this.autoImportCheckBox).addComponent(this.autoImportForScopeLabel).addComponent(this.autoImportGlobalNamespaceLabel).addComponent(this.autoCompletionCustomizeRadioButton).addComponent(this.autoCompletionFullRadioButton).addComponent(this.methodCodeCompletionLabel).addComponent(this.codeCompletionNonStaticMethodsCheckBox).addComponent(this.codeCompletionStaticMethodsCheckBox).addComponent(this.enableAutocompletionLabel).addComponent(this.currentFileVariablesRadioButton).addComponent(this.allVariablesRadioButton).addComponent(this.codeCompletionVariablesScopeLabel).addComponent(this.codeCompletionSmartParametersPreFillingCheckBox).addComponent(this.autoCompletionSmartQuotesLabel).addComponent(this.autoCompletionSmartQuotesCheckBox).addComponent(this.autoStringConcatenationCheckBox).addComponent(this.codeCompletionFirstClassCallableCheckBox).addComponent(this.codeCompletionTypeLabel).addComponent(this.smartRadioButton).addComponent(this.fullyQualifiedRadioButton).addComponent(this.unqualifiedRadioButton).addComponent(this.useLowercaseLabel).addComponent(this.trueFalseNullCheckBox).addComponent(this.autoCompletionCommentAsteriskLabel).addComponent(this.autoCompletionCommentAsteriskCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoCompletionTypesCheckBox).addComponent(this.autoCompletionVariablesCheckBox).addComponent(this.autoCompletionNamespacesCheckBox).addComponent(this.smartInfoLabel).addComponent(this.fullyQualifiedInfoLabel).addComponent(this.unqualifiedInfoLabel))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoImportGlobalNamespaceTypeLabel).addComponent(this.autoImportGlobalNamespaceFunctionLabel).addComponent(this.autoImportGlobalNamespaceConstLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoImportGlobalNamespaceFunctionImportRadioButton).addComponent(this.autoImportGlobalNamespaceTypeImportRadioButton).addComponent(this.autoImportGlobalNamespaceConstImportRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoImportGlobalNamespaceConstDoNotImportRadioButton).addComponent(this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton).addComponent(this.autoImportGlobalNamespaceTypeDoNotImportRadioButton))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoImportNamesapceScopeCheckBox).addComponent(this.autoImportFileScopeCheckBox)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enableAutocompletionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionFullRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionCustomizeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionVariablesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionTypesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionNamespacesCheckBox).addGap(18, 18, 18).addComponent(this.methodCodeCompletionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCompletionStaticMethodsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCompletionNonStaticMethodsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCompletionSmartParametersPreFillingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCompletionFirstClassCallableCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.codeCompletionVariablesScopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allVariablesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentFileVariablesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.codeCompletionTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smartRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smartInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullyQualifiedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullyQualifiedInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unqualifiedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unqualifiedInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoImportCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoImportInfoLabel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoImportForScopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoImportFileScopeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoImportNamesapceScopeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoImportGlobalNamespaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoImportGlobalNamespaceTypeLabel).addComponent(this.autoImportGlobalNamespaceTypeImportRadioButton).addComponent(this.autoImportGlobalNamespaceTypeDoNotImportRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoImportGlobalNamespaceFunctionLabel).addComponent(this.autoImportGlobalNamespaceFunctionImportRadioButton).addComponent(this.autoImportGlobalNamespaceFunctionDoNotImportRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoImportGlobalNamespaceConstDoNotImportRadioButton).addComponent(this.autoImportGlobalNamespaceConstImportRadioButton).addComponent(this.autoImportGlobalNamespaceConstLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoCompletionSmartQuotesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionSmartQuotesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoStringConcatenationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useLowercaseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trueFalseNullCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoCompletionCommentAsteriskLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionCommentAsteriskCheckBox).addContainerGap(44, Short.MAX_VALUE)));
        this.enableAutocompletionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.AccessibleContext.accessibleName"));
        this.enableAutocompletionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.AccessibleContext.accessibleDescription"));
        this.autoCompletionFullRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.AccessibleContext.accessibleName"));
        this.autoCompletionFullRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.AccessibleContext.accessibleDescription"));
        this.autoCompletionCustomizeRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.AccessibleContext.accessibleName"));
        this.autoCompletionCustomizeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.AccessibleContext.accessibleDescription"));
        this.autoCompletionVariablesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionVariablesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.AccessibleContext.accessibleDescription"));
        this.autoCompletionTypesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionTypesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.AccessibleContext.accessibleDescription"));
        this.autoCompletionNamespacesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionNamespacesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.AccessibleContext.accessibleDescription"));
        this.methodCodeCompletionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.AccessibleContext.accessibleName"));
        this.methodCodeCompletionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.AccessibleContext.accessibleDescription"));
        this.codeCompletionStaticMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.AccessibleContext.accessibleName"));
        this.codeCompletionStaticMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.AccessibleContext.accessibleDescription"));
        this.codeCompletionNonStaticMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.AccessibleContext.accessibleName"));
        this.codeCompletionNonStaticMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.AccessibleContext.accessibleDescription"));
        this.codeCompletionVariablesScopeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.AccessibleContext.accessibleName"));
        this.codeCompletionVariablesScopeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.AccessibleContext.accessibleDescription"));
        this.allVariablesRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.AccessibleContext.accessibleName"));
        this.allVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.AccessibleContext.accessibleDescription"));
        this.currentFileVariablesRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.AccessibleContext.accessibleName"));
        this.currentFileVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.AccessibleContext.accessibleDescription"));
        this.codeCompletionTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.AccessibleContext.accessibleName"));
        this.codeCompletionTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.AccessibleContext.accessibleDescription"));
        this.smartRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.AccessibleContext.accessibleName"));
        this.smartRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.AccessibleContext.accessibleDescription"));
        this.smartInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartInfoLabel.AccessibleContext.accessibleDescription"));
        this.fullyQualifiedRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.AccessibleContext.accessibleName"));
        this.fullyQualifiedRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.AccessibleContext.accessibleDescription"));
        this.fullyQualifiedInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.AccessibleContext.accessibleName"));
        this.fullyQualifiedInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.AccessibleContext.accessibleDescription"));
        this.unqualifiedRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.AccessibleContext.accessibleName"));
        this.unqualifiedRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.AccessibleContext.accessibleDescription"));
        this.unqualifiedInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedInfoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.AccessibleContext.accessibleDescription"));
    }

    String getSavedValue(String key) {
        return this.id2Saved.get(key).toString();
    }

    private final class DefaultCheckBoxListener
    implements ItemListener {
        private DefaultCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CodeCompletionPanel.this.validateData();
        }
    }

    private final class DefaultRadioButtonListener
    implements ItemListener {
        private DefaultRadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CodeCompletionPanel.this.validateData();
            }
        }
    }

    public static enum VariablesScope {
        ALL,
        CURRENT_FILE;


        public static VariablesScope resolve(String value) {
            if (value != null) {
                try {
                    return VariablesScope.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return ALL;
        }
    }

    public static enum CodeCompletionType {
        SMART,
        FULLY_QUALIFIED,
        UNQUALIFIED;


        public static CodeCompletionType resolve(String value) {
            if (value != null) {
                try {
                    return CodeCompletionType.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return SMART;
        }
    }

    public static enum GlobalNamespaceAutoImportType {
        IMPORT,
        DO_NOT_IMPORT;


        public static GlobalNamespaceAutoImportType resolve(String value) {
            if (value != null) {
                try {
                    return GlobalNamespaceAutoImportType.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return IMPORT;
        }
    }

    public static final class CustomCustomizerImpl
    extends PreferencesCustomizer.CustomCustomizer {
        public String getSavedValue(PreferencesCustomizer customCustomizer, String key) {
            if (customCustomizer instanceof CodeCompletionPreferencesCustomizer) {
                return ((CodeCompletionPanel)customCustomizer.getComponent()).getSavedValue(key);
            }
            return null;
        }
    }

    static final class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;
        private CodeCompletionPanel component;

        private CodeCompletionPreferencesCustomizer(Preferences preferences) {
            this.preferences = preferences;
        }

        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.modules.php.editor.options.CodeCompletionPanel");
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = new CodeCompletionPanel(this.preferences);
            }
            return this.component;
        }
    }
}

