/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FunctionDeclaration
extends Statement
implements Attributed {
    private final boolean isReference;
    private final Identifier name;
    private final ArrayList<FormalParameter> formalParameters = new ArrayList();
    @NullAllowed
    private final Expression returnType;
    private final Block body;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    private FunctionDeclaration(int start, int end, Identifier functionName, FormalParameter[] formalParameters, Expression returnType, Block body, boolean isReference, List<Attribute> attributes) {
        super(start, end);
        this.isReference = isReference;
        this.name = functionName;
        this.formalParameters.addAll(Arrays.asList(formalParameters));
        this.returnType = returnType;
        this.body = body;
        this.attributes.addAll(attributes);
    }

    private FunctionDeclaration(int start, int end, Identifier functionName, List<FormalParameter> formalParameters, Expression returnType, Block body, boolean isReference, List<Attribute> attributes) {
        this(start, end, functionName, formalParameters.toArray(new FormalParameter[0]), returnType, body, isReference, attributes);
    }

    public FunctionDeclaration(int start, int end, Identifier functionName, List<FormalParameter> formalParameters, Expression returnType, Block body, boolean isReference) {
        this(start, end, functionName, formalParameters, returnType, body, isReference, Collections.emptyList());
    }

    public static FunctionDeclaration create(FunctionDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new FunctionDeclaration(start, declaration.getEndOffset(), declaration.getFunctionName(), declaration.getFormalParameters(), declaration.getReturnType(), declaration.getBody(), declaration.isReference(), attributes);
    }

    public Block getBody() {
        return this.body;
    }

    public List<FormalParameter> getFormalParameters() {
        return Collections.unmodifiableList(this.formalParameters);
    }

    public Identifier getFunctionName() {
        return this.name;
    }

    @CheckForNull
    public Expression getReturnType() {
        return this.returnType;
    }

    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (FormalParameter formalParameter : this.getFormalParameters()) {
            sb.append(formalParameter).append(",");
        }
        return sbAttributes.toString() + "function " + (this.isReference() ? "&" : "") + String.valueOf(this.getFunctionName()) + "(" + sb.toString() + ")" + (String)(this.getReturnType() != null ? ": " + String.valueOf(this.getReturnType()) : "") + String.valueOf(this.getBody());
    }
}

