/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class UnaryOperation
extends Expression {
    private Expression expression;
    private Operator operator;

    public UnaryOperation(int start, int end, Expression expr, Operator operator) {
        super(start, end);
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        this.expression = expr;
        this.operator = operator;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return String.valueOf((Object)this.getOperator()) + String.valueOf(this.getExpression());
    }

    public static enum Operator {
        PLUS("+"),
        MINUS("-"),
        NOT("!"),
        TILDA("~");

        private final String operatorSign;

        private Operator(String operatorSign) {
            this.operatorSign = operatorSign;
        }

        public String toString() {
            return this.operatorSign;
        }
    }
}

