/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.java.mx.project.Bundle;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

final class SuiteEnvEdit
implements Editable {
    private static final String HINT_CONTENT = "# Uncomment # and specify primary JDK path or even extra JDK paths\n# JAVA_HOME=path\n# EXTRA_JAVA_HOMES=path1:path2:path3\n";
    private final SuiteProject suite;

    SuiteEnvEdit(SuiteProject suite) {
        this.suite = suite;
    }

    public void edit() {
        SuiteEnvEdit.open(this.suite.getSuitePy(), null);
        boolean globalOpened = SuiteEnvEdit.open(this.suite.getGlobalEnv(), null);
        boolean localOpened = SuiteEnvEdit.open(this.suite.getSuiteEnv(), null);
        if (globalOpened || localOpened) {
            return;
        }
        SuiteEnvEdit.open(this.suite.getGlobalEnv(), HINT_CONTENT);
    }

    private static boolean open(FileObject fo, String generate) {
        Openable o;
        if (fo == null) {
            return false;
        }
        if (!fo.isValid() && generate != null) {
            try (OutputStream os = fo.getOutputStream();){
                os.write(generate.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)ex, (String)Bundle.MSG_CannotGenerate(fo)));
                return false;
            }
            fo = fo.getParent().getFileObject(fo.getNameExt());
        }
        if ((o = (Openable)fo.getLookup().lookup(Openable.class)) != null) {
            o.open();
            return true;
        }
        Editable e = (Editable)fo.getLookup().lookup(Editable.class);
        if (e != null) {
            e.edit();
            return true;
        }
        return false;
    }
}

