/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.tools.GroovyClass;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.netbeans.modules.groovy.editor.compiler.ClassNodeCache;
import org.netbeans.modules.groovy.editor.compiler.CompilationUnit;
import org.netbeans.modules.groovy.editor.compiler.NbClassNodeResolver;
import org.netbeans.modules.groovy.editor.compiler.PerfData;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Exceptions;

public class PerfStatCompilationUnit
extends CompilationUnit {
    private static final Logger PERFLOG;
    final long parsingStartTime;
    final PerfData perfData;
    int lastPhaseSeen = 0;
    SortedMap<Integer, Long> phaseStartTime = new TreeMap<Integer, Long>();
    static final Method doPhaseOperation;
    static final Field resolverVisitor;
    static Map<String, Object> astTransformLambdaMap;

    public PerfStatCompilationUnit(PerfData perfData, GroovyParser parser, CompilerConfiguration configuration, CodeSource security, @NonNull GroovyClassLoader loader, @NonNull GroovyClassLoader transformationLoader, @NonNull ClasspathInfo cpInfo, @NonNull ClassNodeCache classNodeCache, boolean isIndexing, Snapshot snapshot) {
        super(parser, configuration, security, loader, transformationLoader, cpInfo, classNodeCache, isIndexing, snapshot);
        this.parsingStartTime = System.currentTimeMillis();
        this.perfData = perfData;
        if (this.classLoader instanceof ClassNodeCache.ParsingClassLoader) {
            ((ClassNodeCache.ParsingClassLoader)this.classLoader).setPerfData(perfData);
        }
        this.overrideClassNodeResolver();
    }

    private void overrideClassNodeResolver() {
        if (!PERFLOG.isLoggable(Level.FINER) || resolverVisitor == null) {
            return;
        }
        this.classNodeResolver = new NbClassNodeResolver(){

            @Override
            protected AsmReferenceResolver createReferencesResolver(org.codehaus.groovy.control.CompilationUnit unit) {
                return new AsmReferenceResolver(this, PerfStatCompilationUnit.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ClassNode resolveClassNullable(String className) {
                        long t = System.currentTimeMillis();
                        try {
                            ClassNode c;
                            ClassNode classNode = c = super.resolveClassNullable(className);
                            return classNode;
                        }
                        finally {
                            long t2 = System.currentTimeMillis();
                            PerfStatCompilationUnit.this.perfData.addVisitorTime(PerfStatCompilationUnit.this.phase, "AsmReferenceResolver", t2 - t);
                        }
                    }
                };
            }
        };
        try {
            resolverVisitor.set((Object)this, this.createResolve());
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    public void gotoPhase(int phase) throws CompilationFailedException {
        super.gotoPhase(phase);
        this.recordPhaseStart(phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runSourceVisitor(String visitorName, Consumer<SourceUnit> callback) {
        long t = System.currentTimeMillis();
        try {
            super.runSourceVisitor(visitorName, callback);
        }
        finally {
            long t2 = System.currentTimeMillis();
            this.perfData.addVisitorTime(this.phase, visitorName, t2 - t);
        }
    }

    protected CompilationUnit.ISourceUnitOperation createResolve() {
        return source -> {
            int phase = this.getPhase();
            this.recordPhaseStart(phase);
            for (ClassNode classNode : source.getAST().getClasses()) {
                long t = System.currentTimeMillis();
                VariableScopeVisitor visitor = new VariableScopeVisitor(source);
                visitor.visitClass(classNode);
                long t2 = System.currentTimeMillis();
                long d = t2 - t;
                this.perfData.addVisitorTime(phase, visitor.getClass().getName(), d);
                this.resolveVisitor.setClassNodeResolver(this.classNodeResolver);
                this.resolveVisitor.startResolving(classNode, source);
                long t3 = System.currentTimeMillis();
                d = t3 - t2;
                this.perfData.addVisitorTime(phase, this.resolveVisitor.getClass().getName(), d);
            }
        };
    }

    protected void recordPhaseStart(int phase) {
        if (phase > this.lastPhaseSeen) {
            long l = System.currentTimeMillis();
            this.phaseStartTime.put(phase, l);
            for (int i = phase - 1; i > this.lastPhaseSeen; ++i) {
                this.phaseStartTime.putIfAbsent(i, l);
            }
            this.lastPhaseSeen = phase;
        }
    }

    void logAndCollectPhaseStats() {
        long end = System.currentTimeMillis();
        int lastPhase = 0;
        for (int i = 1; i < 9; ++i) {
            Long phaseStart = (Long)this.phaseStartTime.get(i);
            Long phaseEnd = (Long)this.phaseStartTime.get(i + 1);
            if (phaseStart == null) {
                if (lastPhase > 0) continue;
                phaseStart = this.parsingStartTime;
            }
            if (phaseStart != null) {
                lastPhase = i;
            }
            if (phaseEnd == null || phaseStart == null) continue;
            long diff = phaseEnd - phaseStart;
            this.perfData.addParserPhase(i, diff);
        }
        if (lastPhase > 0) {
            Long lastStart = (Long)this.phaseStartTime.get(lastPhase);
            long diff = end - lastStart;
            this.perfData.addParserPhase(lastPhase, diff);
        }
    }

    static boolean shouldCollect() {
        return PERFLOG.isLoggable(Level.FINER) && resolverVisitor != null;
    }

    public void addNewPhaseOperation(CompilationUnit.ISourceUnitOperation op, int phase) {
        super.addNewPhaseOperation((CompilationUnit.ISourceUnitOperation)(PerfStatCompilationUnit.shouldCollect() ? new TimingOp(op, phase) : op), phase);
    }

    public void addFirstPhaseOperation(CompilationUnit.IPrimaryClassNodeOperation op, int phase) {
        super.addFirstPhaseOperation((CompilationUnit.IPrimaryClassNodeOperation)(PerfStatCompilationUnit.shouldCollect() ? new TimingOp(op, phase) : op), phase);
    }

    public void addPhaseOperation(CompilationUnit.IPrimaryClassNodeOperation op, int phase) {
        super.addPhaseOperation((CompilationUnit.IPrimaryClassNodeOperation)(PerfStatCompilationUnit.shouldCollect() ? new TimingOp(op, phase) : op), phase);
    }

    public void addPhaseOperation(CompilationUnit.ISourceUnitOperation op, int phase) {
        super.addPhaseOperation((CompilationUnit.ISourceUnitOperation)(PerfStatCompilationUnit.shouldCollect() ? new TimingOp(op, phase) : op), phase);
    }

    public void addPhaseOperation(CompilationUnit.IGroovyClassOperation op) {
        super.addPhaseOperation((CompilationUnit.IGroovyClassOperation)(PerfStatCompilationUnit.shouldCollect() ? new TimingOp(op, this.phase) : op));
    }

    public void compile(int throughPhase) throws CompilationFailedException {
        String path = "";
        if (this.mainSnapshot.getSource().getFileObject() != null) {
            path = this.mainSnapshot.getSource().getFileObject().getPath();
        }
        PERFLOG.log(Level.FINER, "Parsing: {0}", path);
        PERFLOG.log(Level.FINER, "Time from CU create up to now: {0}", System.currentTimeMillis() - this.parsingStartTime);
        try {
            super.compile(throughPhase);
        }
        finally {
            if (PERFLOG.isLoggable(Level.FINER)) {
                PERFLOG.log(Level.FINER, "End Parsing: {0}", path);
                this.logAndCollectPhaseStats();
            }
        }
    }

    static {
        Field f;
        Method m;
        block2: {
            PERFLOG = PerfData.LOG;
            m = null;
            f = null;
            try {
                Class<Object> c = Class.forName("org.codehaus.groovy.control.CompilationUnit$PhaseOperation");
                m = c.getDeclaredMethod("doPhaseOperation", org.codehaus.groovy.control.CompilationUnit.class);
                m.setAccessible(true);
                c = org.codehaus.groovy.control.CompilationUnit.class;
                f = c.getDeclaredField("resolve");
                f.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                if (!PERFLOG.isLoggable(Level.FINER)) break block2;
                PERFLOG.log(Level.WARNING, "Unable to patch Groovy compiler for timimg. Use JDK 11.", ex);
            }
        }
        doPhaseOperation = m;
        resolverVisitor = f;
        astTransformLambdaMap = new HashMap<String, Object>();
    }

    class TimingOp
    implements CompilationUnit.ISourceUnitOperation,
    CompilationUnit.IPrimaryClassNodeOperation,
    CompilationUnit.IGroovyClassOperation {
        private final Object delegate;
        private final String key;
        private final int phase;

        public TimingOp(Object delegate, int phase) {
            this.delegate = delegate;
            this.phase = phase;
            String cn = delegate.getClass().getName();
            if (cn.contains("$$Lambda")) {
                String k;
                Object ref;
                StackTraceElement invokedFrom = null;
                for (StackTraceElement ele : new Throwable().getStackTrace()) {
                    boolean myClass = ele.getClassName().startsWith("org.netbeans.modules.groovy.editor.");
                    if (myClass) continue;
                    invokedFrom = ele;
                    break;
                }
                if (cn.contains("ASTTransformationVisitor$$Lambda$") && (ref = astTransformLambdaMap.computeIfAbsent(k = invokedFrom.getMethodName() + ":" + invokedFrom.getLineNumber(), x -> {
                    try {
                        Field f = delegate.getClass().getDeclaredField("arg$1");
                        f.setAccessible(true);
                        return f;
                    }
                    catch (ReflectiveOperationException ex) {
                        return "NONE";
                    }
                })) instanceof Field) {
                    Object o = null;
                    try {
                        o = ((Field)ref).get(delegate);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                    if (o != null) {
                        this.key = o.getClass().getName();
                        return;
                    }
                }
                this.key = invokedFrom != null ? invokedFrom.toString() : cn;
            } else {
                this.key = cn;
            }
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            throw new UnsupportedOperationException("Should not be called.");
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            throw new UnsupportedOperationException("Should not be called.");
        }

        private <T extends Throwable> void sneakyThrow(Throwable exception) throws T {
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doPhaseOperation(org.codehaus.groovy.control.CompilationUnit unit) throws CompilationFailedException {
            long t = System.currentTimeMillis();
            PerfStatCompilationUnit.this.recordPhaseStart(this.phase);
            try {
                try {
                    doPhaseOperation.invoke(this.delegate, unit);
                }
                catch (InvocationTargetException ex) {
                    this.sneakyThrow(ex.getTargetException());
                }
                catch (ReflectiveOperationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            finally {
                long t2 = System.currentTimeMillis();
                PerfStatCompilationUnit.this.perfData.addVisitorTime(PerfStatCompilationUnit.this.getPhase(), this.key, t2 - t);
            }
        }

        public boolean needSortedInput() {
            if (this.delegate instanceof CompilationUnit.IPrimaryClassNodeOperation) {
                return ((CompilationUnit.IPrimaryClassNodeOperation)this.delegate).needSortedInput();
            }
            throw new UnsupportedOperationException("Should not be called.");
        }

        public void call(GroovyClass groovyClass) throws CompilationFailedException {
            throw new UnsupportedOperationException("Should not be called.");
        }
    }
}

