/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.commit.ConflictResolvedAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class ResolveConflictsAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/resources/icons/conflict-resolve.png";

    public ResolveConflictsAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "ResolveConflicts";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return this.isCacheReady() && Subversion.getInstance().getStatusCache().containsFiles(this.getCachedContext(nodes), 16448, true);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = cache.listFiles(ctx, 16448);
        ResolveConflictsAction.resolveConflicts(files);
    }

    static void resolveConflicts(final File[] files) {
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                final Map treeConflicts = ResolveConflictsAction.getTreeConflicts(files);
                final Map propertyConflicts = ResolveConflictsAction.getPropertyConflicts(files);
                final List filteredFiles = ResolveConflictsAction.removeFolders(files, treeConflicts.keySet());
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (filteredFiles.isEmpty() && treeConflicts.isEmpty() && propertyConflicts.isEmpty()) {
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        } else {
                            this.this$0.resolveTreeConflicts(treeConflicts);
                            this.this$0.resolvePropertyConflicts(propertyConflicts, filteredFiles);
                            for (File file : filteredFiles) {
                                ResolveConflictsExecutor executor = new ResolveConflictsExecutor(file);
                                executor.exec();
                            }
                        }
                    }
                });
            }

            private void resolveTreeConflicts(Map<File, ISVNStatus> treeConflicts) {
                for (Map.Entry<File, ISVNStatus> e : treeConflicts.entrySet()) {
                    File file = e.getKey();
                    ISVNStatus status = e.getValue();
                    if (!this.acceptLocalChanges(status)) continue;
                    try {
                        ConflictResolvedAction.perform(file);
                    }
                    catch (SVNClientException ex) {
                        Logger.getLogger(ResolveConflictsAction.class.getName()).log(Level.INFO, null, ex);
                    }
                }
            }

            private boolean acceptLocalChanges(ISVNStatus status) {
                File file = status.getFile();
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolveTreeConflict.message", (Object)file.getName()), NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolveTreeConflict.title"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION);
                return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
            }

            private void resolvePropertyConflicts(Map<File, ISVNStatus> propertyConflicts, List<File> filesToResolve) {
                for (Map.Entry<File, ISVNStatus> e : propertyConflicts.entrySet()) {
                    File file = e.getKey();
                    ISVNStatus status = e.getValue();
                    if (this.acceptPropertyLocalChanges(status)) {
                        if (filesToResolve.contains(file)) continue;
                        try {
                            ConflictResolvedAction.perform(file);
                        }
                        catch (SVNClientException ex) {
                            Logger.getLogger(ResolveConflictsAction.class.getName()).log(Level.INFO, null, ex);
                        }
                        continue;
                    }
                    filesToResolve.remove(file);
                }
            }

            private boolean acceptPropertyLocalChanges(ISVNStatus status) {
                File file = status.getFile();
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolvePropertyConflict.message", (Object)file.getName()), NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolvePropertyConflict.title"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION);
                return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
            }
        });
    }

    private static List<File> removeFolders(File[] files, Set<File> treeConflicts) {
        LinkedList<File> filteredFiles = new LinkedList<File>();
        for (File file : files) {
            if (treeConflicts.contains(file) || !file.isFile()) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    private static Map<File, ISVNStatus> getTreeConflicts(File[] files) {
        HashMap<File, ISVNStatus> treeConflicts = new HashMap<File, ISVNStatus>(files.length);
        if (files.length > 0) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false);
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                for (File file : files) {
                    ISVNStatus status;
                    if ((cache.getStatus(file).getStatus() & 0x4000) == 0 || !(status = SvnUtils.getSingleStatus(client, file)).hasTreeConflict()) continue;
                    treeConflicts.put(file, status);
                }
            }
            catch (SVNClientException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
        }
        return treeConflicts;
    }

    private static Map<File, ISVNStatus> getPropertyConflicts(File[] files) {
        HashMap<File, ISVNStatus> propertyConflicts = new HashMap<File, ISVNStatus>(files.length);
        if (files.length > 0) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false);
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                for (File file : files) {
                    ISVNStatus status;
                    if ((cache.getStatus(file).getStatus() & 0x40) == 0 || (status = SvnUtils.getSingleStatus(client, file)).getPropStatus() != SVNStatusKind.CONFLICTED) continue;
                    propertyConflicts.put(file, status);
                }
            }
            catch (SVNClientException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
        }
        return propertyConflicts;
    }

    @Override
    public boolean asynchronous() {
        return false;
    }
}

