/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.PanelProgressSupport;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.PreviewPanel;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ImportPreviewStep
extends AbstractStep {
    private PreviewPanel previewPanel;
    private Context context;
    private CommitTable table;
    private PanelProgressSupport support;
    private String importMessage;
    private static final String PANEL_PREFIX = "import";

    public ImportPreviewStep(Context context) {
        this.context = context;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(ImportPreviewStep.class);
    }

    @Override
    protected JComponent createComponent() {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel();
            Map<String, Integer> sortingStatus = SvnModuleConfig.getDefault().getSortingStatus(PANEL_PREFIX);
            if (sortingStatus == null) {
                sortingStatus = Collections.singletonMap("path", 1);
            }
            this.table = new CommitTable(this.previewPanel.tableLabel, CommitTable.IMPORT_COLUMNS, sortingStatus);
            JComponent component = this.table.getComponent();
            this.previewPanel.tablePanel.setLayout(new BorderLayout());
            this.previewPanel.tablePanel.add((Component)component, "Center");
        }
        return this.previewPanel;
    }

    @Override
    protected void validateBeforeNext() {
        this.validateUserInput();
    }

    public void validateUserInput() {
        Collection<CommitOptions> commitOptions = this.table.getCommitFiles().values();
        if (this.table != null && commitOptions.size() > 0) {
            for (CommitOptions option : commitOptions) {
                if (option == CommitOptions.EXCLUDE) continue;
                this.valid();
                return;
            }
            this.invalid(null);
        } else {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportPreviewStep.class, (String)"CTL_Import_NothingToImport"), true));
        }
    }

    public void setup(final String repositoryPath, final String rootLocalPath, final SVNUrl repository, String importMessage, final boolean startCommitWhenFinished) {
        this.importMessage = importMessage;
        this.support = new PanelProgressSupport(this, startCommitWhenFinished ? null : this.previewPanel.progressPanel){
            final /* synthetic */ ImportPreviewStep this$0;
            {
                this.this$0 = this$0;
                super(panel);
            }

            @Override
            protected void perform() {
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                final File[] files = cache.listFiles(this.this$0.context, 88532);
                if (files.length == 0 || this.isCanceled()) {
                    return;
                }
                if (repositoryPath != null) {
                    this.this$0.table.setRootFile(repositoryPath, rootLocalPath);
                }
                final ArrayList nodesList = new ArrayList(files.length);
                SvnUtils.runWithInfoCache(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        for (File file : files) {
                            SvnFileNode node = new SvnFileNode(file);
                            node.initializeProperties();
                            nodesList.add(node);
                            if (!this.this$1.isCanceled()) continue;
                            return;
                        }
                    }
                });
                final SvnFileNode[] nodes = nodesList.toArray(new SvnFileNode[files.length]);
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.table.setNodes(nodes);
                        this.this$1.this$0.table.getTableModel().addTableModelListener(new TableModelListener(){

                            @Override
                            public void tableChanged(TableModelEvent e) {
                                this$1.this$0.validateUserInput();
                            }
                        });
                        this.this$1.this$0.validateUserInput();
                        if (startCommitWhenFinished) {
                            this.this$1.this$0.startCommitTask(repository);
                        }
                    }
                });
            }
        };
        this.support.start(Subversion.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ImportPreviewStep.class, (String)"BK1009"));
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        return this.table.getCommitFiles();
    }

    public void storeTableSorter() {
        SvnModuleConfig.getDefault().setSortingStatus(PANEL_PREFIX, this.table.getSortingState());
    }

    public void startCommitTask(SVNUrl repository) {
        SvnProgressSupport commitTask = new SvnProgressSupport(){

            @Override
            public void perform() {
                CommitAction.performCommit(ImportPreviewStep.this.importMessage, ImportPreviewStep.this.getCommitFiles(), ImportPreviewStep.this.context, this, true);
            }
        };
        commitTask.start(Subversion.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ImportPreviewStep.class, (String)"LBL_Import_Progress"));
    }
}

