/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.ui.models.breakpoints;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfoManager;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.modules.javascript2.debug.ui.models.ViewModelSupport;
import org.netbeans.modules.javascript2.debug.ui.models.breakpoints.Bundle;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public class BreakpointNodeModel
implements ExtendedNodeModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint.gif";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit.gif";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint.gif";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit.gif";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint.gif";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit.gif";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint.gif";
    public static final String DEACTIVATED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint_stroke.png";
    public static final String DEACTIVATED_DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint_stroke.png";
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public BreakpointNodeModel() {
        JSBreakpointsInfoManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModelEvent.NodeChanged nch = new ModelEvent.NodeChanged((Object)BreakpointNodeModel.this, null);
                for (ModelListener ml : BreakpointNodeModel.this.listeners) {
                    ml.modelChanged((ModelEvent)nch);
                }
            }
        });
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof JSLineBreakpoint) {
            JSLineBreakpoint breakpoint = (JSLineBreakpoint)node;
            String fileName = JSUtils.getFileName(breakpoint);
            int lineNumber = breakpoint.getLineNumber();
            if (breakpoint.isActive()) {
                return ViewModelSupport.toHTML(Bundle.LBL_LineBreakpoint_on(fileName + ":" + lineNumber), true, false, null);
            }
            return Bundle.LBL_LineBreakpoint_on(fileName + ":" + lineNumber);
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (!(node instanceof JSLineBreakpoint)) {
            throw new UnknownTypeException(node);
        }
        JSLineBreakpoint b = (JSLineBreakpoint)node;
        boolean disabled = !b.isEnabled();
        boolean invalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        boolean active = JSBreakpointsInfoManager.getDefault().areBreakpointsActivated();
        String iconBase = disabled ? (active ? DISABLED_LINE_BREAKPOINT : DEACTIVATED_DISABLED_LINE_BREAKPOINT) : (b.isActive() ? CURRENT_LINE_BREAKPOINT : (active ? LINE_BREAKPOINT : DEACTIVATED_LINE_BREAKPOINT));
        if (invalid && !disabled) {
            int dot = iconBase.lastIndexOf(46);
            iconBase = iconBase.substring(0, dot) + "_broken" + iconBase.substring(dot);
        }
        return iconBase;
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not to be called, replaced with getIconBaseWithExtension().");
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (!(node instanceof JSLineBreakpoint)) {
            throw new UnknownTypeException(node);
        }
        JSLineBreakpoint b = (JSLineBreakpoint)node;
        String appendMsg = null;
        Breakpoint.VALIDITY validity = b.getValidity();
        boolean valid = validity == Breakpoint.VALIDITY.VALID;
        boolean invalid = validity == Breakpoint.VALIDITY.INVALID;
        String message = b.getValidityMessage();
        if (valid) {
            appendMsg = Bundle.CTL_APPEND_BP_Valid();
        }
        if (invalid) {
            appendMsg = message != null ? Bundle.CTL_APPEND_BP_Invalid_with_reason(message) : Bundle.CTL_APPEND_BP_Invalid();
        }
        String description = JSUtils.getLine(b).getDisplayName();
        if (appendMsg != null) {
            description = description + " " + appendMsg;
        }
        return description;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }
}

