/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.attach;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.javascript.cdtdebug.CDTDebuggerSessionProvider;
import org.netbeans.modules.javascript.cdtdebug.api.Connector;
import org.netbeans.modules.javascript.cdtdebug.ui.attach.Bundle;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AttachCustomizer
extends JPanel {
    private static final Logger LOG = Logger.getLogger(ConnectController.class.getName());
    private final ConnectController controller;
    private final ConnectProperties cproperties = new ConnectProperties();
    private final ValidityDocumentListener validityDocumentListener = new ValidityDocumentListener();
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JButton localSourcesButton;
    private JCheckBox localSourcesCheckBox;
    private JLabel localSourcesLabel;
    private JTextField localSourcesTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel serverPathLabel;
    private JTextField serverPathTextField;

    public AttachCustomizer() {
        this.controller = new ConnectController();
        this.initComponents();
        this.controller.init();
        this.portTextField.getDocument().addDocumentListener(this.validityDocumentListener);
        this.localSourcesTextField.getDocument().addDocumentListener(this.validityDocumentListener);
        this.serverPathTextField.getDocument().addDocumentListener(this.validityDocumentListener);
        this.localSourcesCheckBoxActionPerformed(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttachCustomizer.this.checkValid();
            }
        });
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.localSourcesLabel = new JLabel();
        this.localSourcesCheckBox = new JCheckBox();
        this.localSourcesTextField = new JTextField();
        this.serverPathLabel = new JLabel();
        this.serverPathTextField = new JTextField();
        this.localSourcesButton = new JButton();
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(AttachCustomizer.class, (String)"AttachCustomizer.hostLabel.text"));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(AttachCustomizer.class, (String)"AttachCustomizer.portLabel.text"));
        this.localSourcesLabel.setLabelFor(this.localSourcesTextField);
        Mnemonics.setLocalizedText((JLabel)this.localSourcesLabel, (String)NbBundle.getMessage(AttachCustomizer.class, (String)"AttachCustomizer.localSourcesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.localSourcesCheckBox, (String)NbBundle.getMessage(AttachCustomizer.class, (String)"AttachCustomizer.localSourcesCheckBox.text"));
        this.localSourcesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachCustomizer.this.localSourcesCheckBoxActionPerformed(evt);
            }
        });
        this.serverPathLabel.setLabelFor(this.serverPathTextField);
        Mnemonics.setLocalizedText((JLabel)this.serverPathLabel, (String)NbBundle.getMessage(AttachCustomizer.class, (String)"AttachCustomizer.serverPathLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.localSourcesButton, (String)NbBundle.getMessage(AttachCustomizer.class, (String)"AttachCustomizer.localSourcesButton.text"));
        this.localSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachCustomizer.this.localSourcesButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serverPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverPathTextField)).addGroup(layout.createSequentialGroup().addComponent(this.localSourcesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localSourcesTextField, -1, 223, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.localSourcesButton)))).addGroup(layout.createSequentialGroup().addComponent(this.localSourcesCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.portLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portTextField).addComponent(this.hostTextField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localSourcesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localSourcesLabel).addComponent(this.localSourcesTextField, -2, -1, -2).addComponent(this.localSourcesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverPathLabel).addComponent(this.serverPathTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void localSourcesCheckBoxActionPerformed(ActionEvent evt) {
        boolean areSources = this.localSourcesCheckBox.isSelected();
        this.localSourcesLabel.setEnabled(areSources);
        this.localSourcesTextField.setEnabled(areSources);
        this.localSourcesButton.setEnabled(areSources);
        this.serverPathLabel.setEnabled(areSources);
        this.serverPathTextField.setEnabled(areSources);
        this.checkValid();
    }

    private void localSourcesButtonActionPerformed(ActionEvent evt) {
        FileChooserBuilder fchb = new FileChooserBuilder(AttachCustomizer.class);
        fchb.setDirectoriesOnly(true);
        File dir = fchb.showOpenDialog();
        if (dir != null) {
            this.localSourcesTextField.setText(dir.getAbsolutePath());
        }
    }

    private void checkValid() {
        int port;
        assert (SwingUtilities.isEventDispatchThread()) : "Called outside of AWT.";
        if (this.portTextField.getText().isEmpty()) {
            this.controller.setInformationMessage(Bundle.MSG_NoPort());
            this.controller.setValid(false);
            return;
        }
        try {
            port = Integer.parseInt(this.portTextField.getText());
        }
        catch (NumberFormatException nfex) {
            this.controller.setErrorMessage(Bundle.MSG_InvalidPort(this.portTextField.getText()));
            this.controller.setValid(false);
            return;
        }
        String localDir = this.localSourcesTextField.getText();
        if (this.localSourcesCheckBox.isSelected()) {
            File localFile = new File(localDir);
            if (!localFile.exists()) {
                this.controller.setInformationMessage(Bundle.MSG_LocalPathNotExists());
                this.controller.setValid(false);
                return;
            }
            if (!localFile.isDirectory()) {
                this.controller.setErrorMessage(Bundle.MSG_LocalPathNotDir());
                this.controller.setValid(false);
                return;
            }
            if (this.serverPathTextField.getText().isEmpty()) {
                this.controller.setInformationMessage(Bundle.MSG_ServerPathIsEmpty());
                this.controller.setValid(false);
                return;
            }
        }
        this.cproperties.host = this.hostTextField.getText();
        this.cproperties.port = port;
        this.cproperties.hasSources = this.localSourcesCheckBox.isSelected();
        this.cproperties.localPath = localDir;
        this.cproperties.serverPath = this.serverPathTextField.getText();
        this.controller.setInformationMessage(null);
        this.controller.setErrorMessage(null);
        this.controller.setValid(true);
    }

    Controller getController() {
        return this.controller;
    }

    private static final class ConnectProperties {
        String host;
        int port;
        boolean hasSources;
        String localPath;
        String serverPath;

        private ConnectProperties() {
        }
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AttachCustomizer.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AttachCustomizer.this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AttachCustomizer.this.checkValid();
        }
    }

    public class ConnectController
    implements PersistentController {
        private static final String CDT_ATTACH_PROPERTIES = "cdt_attach_settings";
        private static final String PROP_HOST = "host";
        private static final String PROP_PORT = "port";
        private static final String PROP_HAS_SOURCES = "hasSources";
        private static final String PROP_LOCAL_PATH = "localPath";
        private static final String PROP_SERVER_PATH = "serverPath";
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean valid = true;

        public String getDisplayName() {
            return CDTDebuggerSessionProvider.getSessionName((String)AttachCustomizer.this.cproperties.host, (int)AttachCustomizer.this.cproperties.port);
        }

        public boolean load(Properties props) {
            assert (!SwingUtilities.isEventDispatchThread());
            final Properties attachProps = props.getProperties(CDT_ATTACH_PROPERTIES);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){
                    final /* synthetic */ ConnectController this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.AttachCustomizer.this.hostTextField.setText(attachProps.getString(ConnectController.PROP_HOST, "localhost"));
                        this.this$1.AttachCustomizer.this.portTextField.setText(Integer.toString(attachProps.getInt(ConnectController.PROP_PORT, 9229)));
                        this.this$1.AttachCustomizer.this.localSourcesCheckBox.setSelected(attachProps.getBoolean(ConnectController.PROP_HAS_SOURCES, false));
                        String localPath = attachProps.getString(ConnectController.PROP_LOCAL_PATH, "");
                        this.this$1.AttachCustomizer.this.localSourcesTextField.setText(localPath);
                        String serverPath = attachProps.getString(ConnectController.PROP_SERVER_PATH, "");
                        this.this$1.AttachCustomizer.this.serverPathTextField.setText(serverPath);
                        this.this$1.AttachCustomizer.this.localSourcesCheckBoxActionPerformed(null);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }

        public void save(Properties props) {
            Properties attachProps = props.getProperties(CDT_ATTACH_PROPERTIES);
            if (SwingUtilities.isEventDispatchThread()) {
                this.saveToProps(attachProps);
                this.saveToProps(Properties.getDefault().getProperties(CDT_ATTACH_PROPERTIES));
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        this.saveToProps(attachProps);
                        this.saveToProps(Properties.getDefault().getProperties(CDT_ATTACH_PROPERTIES));
                    });
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private void saveToProps(Properties attachProps) {
            attachProps.setString(PROP_HOST, AttachCustomizer.this.hostTextField.getText());
            try {
                attachProps.setInt(PROP_PORT, Integer.parseInt(AttachCustomizer.this.portTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            attachProps.setBoolean(PROP_HAS_SOURCES, AttachCustomizer.this.localSourcesCheckBox.isSelected());
            attachProps.setString(PROP_LOCAL_PATH, AttachCustomizer.this.localSourcesTextField.getText());
            attachProps.setString(PROP_SERVER_PATH, AttachCustomizer.this.serverPathTextField.getText());
        }

        public boolean ok() {
            Connector.Properties cp = !AttachCustomizer.this.cproperties.hasSources ? new Connector.Properties(AttachCustomizer.this.cproperties.host, AttachCustomizer.this.cproperties.port) : new Connector.Properties(AttachCustomizer.this.cproperties.host, AttachCustomizer.this.cproperties.port, null, Collections.singletonList(AttachCustomizer.this.cproperties.localPath), Collections.singletonList(AttachCustomizer.this.cproperties.serverPath), (Collection)Collections.EMPTY_SET);
            try {
                Connector.connect((Connector.Properties)cp, null);
            }
            catch (IOException ioex) {
                LOG.log(Level.INFO, "Failed to connect", ioex);
                String message = ioex.getLocalizedMessage();
                if (message == null) {
                    message = ioex.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                return false;
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
            this.firePropertyChange("valid", !valid, valid);
        }

        void setErrorMessage(String msg) {
            this.firePropertyChange("errorNotification", null, msg);
        }

        void setInformationMessage(String msg) {
            this.firePropertyChange("infoNotification", null, msg);
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void init() {
            RequestProcessor.getDefault().execute(() -> this.load(Properties.getDefault()));
        }
    }
}

