/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.VersioningQuery;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.commons.FileToRepoMappingStorage;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.commons.Util;
import org.netbeans.modules.bugtracking.team.TeamRepositories;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelectorBuilder;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.netbeans.modules.team.spi.TeamProject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class BugtrackingOwnerSupport {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.bridge.BugtrackingOwnerSupport");
    private static BugtrackingOwnerSupport instance;

    protected BugtrackingOwnerSupport() {
    }

    public static BugtrackingOwnerSupport getInstance() {
        if (instance == null && (instance = (BugtrackingOwnerSupport)Lookup.getDefault().lookup(BugtrackingOwnerSupport.class)) == null) {
            instance = new BugtrackingOwnerSupport();
        }
        return instance;
    }

    public RepositoryImpl getRepository(FileObject ... files) {
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            return null;
        }
        RepositoryImpl chosenRepo = null;
        for (FileObject fo : files) {
            RepositoryImpl repo = this.getRepository(fo);
            if (repo == null) continue;
            if (chosenRepo == null) {
                chosenRepo = repo;
                continue;
            }
            if (repo == chosenRepo) continue;
            return null;
        }
        return chosenRepo;
    }

    public RepositoryImpl getRepository(FileObject fileObject) {
        return this.getRepository(fileObject, false);
    }

    public RepositoryImpl getRepository(FileObject fileObject, boolean askIfUnknown) {
        if (fileObject == null) {
            if (askIfUnknown) {
                return this.askUserToSpecifyRepository(null);
            }
            return null;
        }
        try {
            RepositoryImpl repo = BugtrackingOwnerSupport.getRepositoryIntern(fileObject, askIfUnknown);
            if (repo != null) {
                return repo;
            }
        }
        catch (IOException ex) {
            return null;
        }
        File context = Util.getLargerContext((FileObject)fileObject);
        if (context != null) {
            return this.getRepositoryForContext(context, askIfUnknown);
        }
        return this.askUserToSpecifyRepository(null);
    }

    public RepositoryImpl getRepository(File file, boolean askIfUnknown) {
        if (file == null) {
            if (askIfUnknown) {
                return this.askUserToSpecifyRepository(null);
            }
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            LOG.log(Level.WARNING, " did not find a FileObject for file {0}", new Object[]{file});
        } else {
            try {
                RepositoryImpl repo = BugtrackingOwnerSupport.getRepositoryIntern(fileObject, askIfUnknown);
                if (repo != null) {
                    return repo;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, " communication with Team Server failed while loading information about bugtracking repository", ex);
                return null;
            }
        }
        File context = Util.getLargerContext((File)file, (FileObject)fileObject);
        if (context == null) {
            context = file;
        }
        return this.getRepositoryForContext(context, askIfUnknown);
    }

    public void setFirmAssociations(FileObject[] files, RepositoryImpl repository) {
        if (files == null) {
            throw new IllegalArgumentException("files is null");
        }
        if (files.length == 0) {
            return;
        }
        FileToRepoMappingStorage.getInstance().setFirmAssociation(Util.getLargerContext((FileObject)files[0]), repository.getUrl());
    }

    public void setFirmAssociations(File[] files, RepositoryImpl repository) {
        if (files == null) {
            throw new IllegalArgumentException("files is null");
        }
        if (files.length == 0) {
            return;
        }
        FileToRepoMappingStorage.getInstance().setFirmAssociation(Util.getLargerContext((File)files[0]), repository.getUrl());
    }

    public void setFirmAssociation(FileObject file, RepositoryImpl repository) {
        FileToRepoMappingStorage.getInstance().setFirmAssociation(Util.getLargerContext((FileObject)file), repository.getUrl());
    }

    public void setFirmAssociation(File file, RepositoryImpl repository) {
        FileToRepoMappingStorage.getInstance().setFirmAssociation(Util.getLargerContext((File)file), repository.getUrl());
    }

    public void setLooseAssociation(ContextType contextType, RepositoryImpl repository) {
        File context = null;
        switch (contextType.ordinal()) {
            case 0: {
                FileObject fo = BugtrackingOwnerSupport.getMainProjectDirectory();
                if (fo == null) break;
                context = Util.getLargerContext((FileObject)fo);
                break;
            }
            case 1: {
                context = BugtrackingOwnerSupport.getLargerContext();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (context != null) {
            FileToRepoMappingStorage.getInstance().setLooseAssociation(context, repository.getUrl());
        }
    }

    public final Collection<String> getAllAssociatedUrls() {
        return FileToRepoMappingStorage.getInstance().getAllFirmlyAssociatedUrls();
    }

    protected RepositoryImpl getRepositoryForContext(File context, boolean askIfUnknown) {
        String repoUrl = FileToRepoMappingStorage.getInstance().getFirmlyAssociatedRepository(context);
        if (repoUrl != null) {
            LOG.log(Level.FINER, " found stored repository [{0}] for directory {1}", new Object[]{repoUrl, context});
            return this.getRepositoryByUrl(repoUrl);
        }
        String suggestedRepositoryUrl = FileToRepoMappingStorage.getInstance().getLooselyAssociatedRepository(context);
        RepositoryImpl suggestedRepository = this.getRepositoryByUrl(suggestedRepositoryUrl);
        if (!askIfUnknown) {
            return suggestedRepository;
        }
        RepositoryImpl repo = this.askUserToSpecifyRepository(suggestedRepository);
        if (repo != null) {
            return repo;
        }
        return null;
    }

    private static File getLargerContext() {
        File largerContext;
        FileObject openFile = BugtrackingOwnerSupport.getOpenFileObj();
        if (openFile != null && (largerContext = Util.getLargerContext((FileObject)openFile)) != null) {
            return largerContext;
        }
        return BugtrackingOwnerSupport.getContextFromProjects();
    }

    private static File getContextFromProjects() {
        FileObject fo = BugtrackingOwnerSupport.getMainProjectDirectory();
        if (fo != null) {
            return FileUtil.toFile((FileObject)fo);
        }
        FileObject[] fos = BugtrackingOwnerSupport.getOpenProjectsDirectories();
        if (fos != null && fos.length == 1) {
            return Util.getLargerContext((FileObject)fos[0]);
        }
        return null;
    }

    private static FileObject getOpenFileObj() {
        TopComponent activatedTopComponent = TopComponent.getRegistry().getActivated();
        if (activatedTopComponent == null) {
            return null;
        }
        DataObject dataObj = (DataObject)activatedTopComponent.getLookup().lookup(DataObject.class);
        if (dataObj == null || !dataObj.isValid()) {
            return null;
        }
        return dataObj.getPrimaryFile();
    }

    private static RepositoryImpl getRepositoryIntern(FileObject fileObject, boolean askIfUnknown) throws IOException {
        String url = VersioningQuery.getRemoteLocation((URI)fileObject.toURI());
        if (url != null) {
            File file;
            RepositoryImpl repository = null;
            if (NBBugzillaUtils.isNbRepository((String)url) && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
                OwnerInfo ownerInfo = TeamAccessorUtils.getOwnerInfo((File)file);
                if (ownerInfo != null) {
                    repository = TeamRepositories.getInstance().getRepository(url, ownerInfo.getOwner());
                }
                if (repository == null) {
                    repository = BugtrackingUtil.findNBRepository();
                }
            }
            if (repository != null) {
                return repository;
            }
            try {
                repository = APIAccessor.IMPL.getImpl(BugtrackingOwnerSupport.getRepository(url, askIfUnknown));
                if (repository != null) {
                    return repository;
                }
            }
            catch (IOException ex) {
                if ("Not Found".equals(ex.getMessage())) {
                    BugtrackingManager.LOG.log(Level.INFO, "Team project corresponding to URL {0} does not exist.", url);
                } else {
                    BugtrackingManager.LOG.throwing(BugtrackingOwnerSupport.class.getName(), "getRepository(String)", ex);
                }
                throw ex;
            }
        }
        return null;
    }

    private RepositoryImpl askUserToSpecifyRepository(RepositoryImpl suggestedRepo) {
        Collection<RepositoryImpl> repos = RepositoryRegistry.getInstance().getKnownRepositories(true);
        DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
        RepositorySelectorBuilder selectorBuilder = new RepositorySelectorBuilder();
        selectorBuilder.setDisplayFormForExistingRepositories(true);
        selectorBuilder.setExistingRepositories(repos.toArray(new RepositoryImpl[0]));
        selectorBuilder.setBugtrackingConnectors(connectors);
        selectorBuilder.setPreselectedRepository(suggestedRepo);
        selectorBuilder.setLabelAboveComboBox();
        String dialogTitle = NbBundle.getMessage(BugtrackingOwnerSupport.class, (String)"LBL_BugtrackerSelectorTitle");
        DialogDescriptor dialogDescriptor = selectorBuilder.createDialogDescriptor(dialogTitle);
        Object selectedOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        RepositoryImpl repository = selectorBuilder.getSelectedRepository();
        if (selectedOption == NotifyDescriptor.OK_OPTION) {
            repository.applyChanges();
            return repository;
        }
        repository.cancelChanges();
        return null;
    }

    private static FileObject getMainProjectDirectory() {
        ProjectServices projectServices = BugtrackingManager.getInstance().getProjectServices();
        return projectServices != null ? projectServices.getMainProjectDirectory() : null;
    }

    private static FileObject[] getOpenProjectsDirectories() {
        ProjectServices projectServices = BugtrackingManager.getInstance().getProjectServices();
        return projectServices != null ? projectServices.getOpenProjectsDirectories() : null;
    }

    private RepositoryImpl getRepositoryByUrl(String requestedUrl) {
        Collection<RepositoryImpl> repositories = RepositoryRegistry.getInstance().getRepositories();
        for (RepositoryImpl repository : repositories) {
            String url = repository.getUrl();
            if (url != null) {
                String repositoryUrl = FileToRepoMappingStorage.cutTrailingSlashes((String)url);
                if (!repositoryUrl.equals(requestedUrl)) continue;
                return repository;
            }
            BugtrackingManager.LOG.log(Level.WARNING, "NULL url in repository [{0},{1},{2}]", new Object[]{repository.getConnectorId(), repository.getId(), repository.getDisplayName()});
        }
        return null;
    }

    private static Repository getRepository(String repositoryUrl, boolean askIfUnknown) throws IOException {
        TeamProject project = TeamAccessorUtils.getTeamProjectForRepository((String)repositoryUrl, (boolean)askIfUnknown);
        RepositoryImpl repoImpl = project != null ? TeamRepositories.getInstance().getRepository(project.getHost(), project.getName()) : null;
        return repoImpl != null ? repoImpl.getRepository() : null;
    }

    public static enum ContextType {
        MAIN_PROJECT_ONLY,
        SELECTED_FILE_AND_ALL_PROJECTS;

    }
}

