/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.process;

import edu.stanford.nlp.international.process.ConfigParser;
import edu.stanford.nlp.international.process.Dataset;
import edu.stanford.nlp.international.process.Mapper;
import edu.stanford.nlp.international.process.StringMap;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataset
implements Dataset {
    protected final List<String> outputFileList;
    protected Mapper posMapper = null;
    protected Mapper lexMapper = null;
    protected Dataset.Encoding encoding = Dataset.Encoding.UTF8;
    protected final List<File> pathsToData;
    protected final List<File> pathsToMappings;
    protected FileFilter splitFilter = null;
    protected boolean addDeterminer = false;
    protected boolean removeDashTags = false;
    protected boolean addRoot = false;
    protected boolean removeEscapeTokens = false;
    protected String lexMapOptions = "";
    protected int maxLen = Integer.MAX_VALUE;
    protected String morphDelim = null;
    protected TreeVisitor customTreeVisitor = null;
    protected String outFileName;
    protected String flatFileName;
    protected boolean makeFlatFile = false;
    protected final Pattern fileNameNormalizer = Pattern.compile("\\s+");
    protected Treebank treebank;
    protected final Set<String> configuredOptions;
    protected final Set<String> requiredOptions;
    protected final StringBuilder toStringBuffer;
    protected String treeFileExtension = "tree";
    protected StringMap options;

    public AbstractDataset() {
        this.outputFileList = new ArrayList<String>();
        this.pathsToData = new ArrayList<File>();
        this.pathsToMappings = new ArrayList<File>();
        this.toStringBuffer = new StringBuilder();
        this.configuredOptions = new HashSet<String>();
        this.requiredOptions = new HashSet<String>();
        this.requiredOptions.add("NAME");
        this.requiredOptions.add("PATH");
        this.requiredOptions.add("OUTPUT_ENCODING");
    }

    @Override
    public abstract void build();

    private Mapper loadMapper(String className) {
        Mapper m = null;
        try {
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(className);
            m = (Mapper)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.printf("%s: Mapper type %s does not exist\n", this.getClass().getName(), className);
        }
        catch (InstantiationException e) {
            System.err.printf("%s: Unable to instantiate mapper type %s\n", this.getClass().getName(), className);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.printf("%s: Unable to access mapper type %s\n", this.getClass().getName(), className);
        }
        return m;
    }

    @Override
    public boolean setOptions(StringMap opts) {
        this.options = opts;
        for (String param : opts) {
            String value = opts.get(param);
            if (value == null) {
                System.err.printf("%s: Read parameter with null value (%s)\n", this.getClass().getName(), param);
                continue;
            }
            this.configuredOptions.add(param);
            Matcher pathMatcher = ConfigParser.matchPath.matcher(param);
            Matcher mapMatcher = ConfigParser.matchMapping.matcher(param);
            if (pathMatcher.lookingAt()) {
                this.pathsToData.add(new File(value));
                this.configuredOptions.add("PATH");
                continue;
            }
            if (mapMatcher.lookingAt()) {
                this.pathsToMappings.add(new File(value));
                this.configuredOptions.add("MAPPING");
                continue;
            }
            if (param.equals("OUTPUT_ENCODING")) {
                this.encoding = Dataset.Encoding.valueOf(value);
                continue;
            }
            if (param.equals("NAME")) {
                Matcher inThisFilename = this.fileNameNormalizer.matcher(value.trim());
                this.outFileName = inThisFilename.replaceAll("-");
                this.toStringBuffer.append(String.format("Dataset Name: %s\n", value.trim()));
                continue;
            }
            if (param.equals("USEDET")) {
                this.addDeterminer = Boolean.parseBoolean(value);
                continue;
            }
            if (param.equals("SPLIT")) {
                StringMap sm = this.buildSplitMap(new File(value));
                this.splitFilter = new SplitFilter(sm);
                continue;
            }
            if (param.equals("FLAT") && Boolean.parseBoolean(value)) {
                this.makeFlatFile = true;
                continue;
            }
            if (param.equals("FILEEXT")) {
                this.treeFileExtension = value;
                continue;
            }
            if (param.equals("LEXMAPPER")) {
                this.lexMapper = this.loadMapper(value);
                continue;
            }
            if (param.equals("NODASHTAGS")) {
                this.removeDashTags = Boolean.parseBoolean(value);
                continue;
            }
            if (param.equals("ADDROOT")) {
                this.addRoot = Boolean.parseBoolean(value);
                continue;
            }
            if (param.equals("UNESCAPE")) {
                this.removeEscapeTokens = true;
                continue;
            }
            if (param.equals("LEXOPTS")) {
                this.lexMapOptions = value;
                continue;
            }
            if (param.equals("POSMAPPER")) {
                this.posMapper = this.loadMapper(value);
                continue;
            }
            if (param.equals("MAXLEN")) {
                this.maxLen = Integer.parseInt(value);
                continue;
            }
            if (param.equals("MORPH")) {
                this.morphDelim = value;
                continue;
            }
            if (!param.equals("TVISITOR")) continue;
            this.customTreeVisitor = this.loadTreeVistor(value);
        }
        if (!this.configuredOptions.containsAll(this.requiredOptions)) {
            return false;
        }
        this.outFileName = this.encoding == Dataset.Encoding.UTF8 ? this.outFileName + ".utf8" : this.outFileName + ".bw";
        if (this.makeFlatFile) {
            this.flatFileName = this.outFileName + ".flat.txt";
        }
        this.outFileName = this.outFileName + ".txt";
        return true;
    }

    private TreeVisitor loadTreeVistor(String value) {
        try {
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(value);
            return (TreeVisitor)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected StringMap buildSplitMap(File path) {
        StringMap sm = new StringMap();
        int lineNum = 0;
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(path));
            while (reader.ready()) {
                String line = reader.readLine();
                lineNum = reader.getLineNumber();
                sm.put(line.trim(), "t");
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.printf("%s: Could not open split file %s\n", this.getClass().getName(), path.getPath());
        }
        catch (IOException e) {
            System.err.printf("%s: Error reading split file %s (line %d)\n", this.getClass().getName(), path.getPath(), lineNum);
        }
        return sm;
    }

    @Override
    public List<String> getFilenames() {
        return Collections.unmodifiableList(this.outputFileList);
    }

    public String toString() {
        return this.toStringBuffer.toString();
    }

    protected class SplitFilter
    implements FileFilter {
        private final StringMap filterMap;

        public SplitFilter(StringMap sm) {
            this.filterMap = sm;
        }

        public boolean accept(File f) {
            return this.filterMap.contains(f.getName());
        }
    }
}

