/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.IdentityHashSet;
import edu.stanford.nlp.util.Interner;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Relation
implements Serializable {
    private static final long serialVersionUID = -1564793674551362909L;
    private String symbol;
    private static HeadFinder headFinder;
    private static final Pattern parentOfLastChild;
    private static final Pattern lastChildOfParent;
    static final Relation ROOT;
    static final Relation EQUALS;
    private static final Relation PATTERN_SPLITTER;
    static final Relation DOMINATES;
    static final Relation DOMINATED_BY;
    static final Relation PARENT_OF;
    static final Relation CHILD_OF;
    static final Relation PRECEDES;
    static final Relation IMMEDIATELY_PRECEDES;
    static final Relation FOLLOWS;
    static final Relation IMMEDIATELY_FOLLOWS;
    static final Relation HAS_LEFTMOST_DESCENDENT;
    static final Relation HAS_RIGHTMOST_DESCENDENT;
    static final Relation LEFTMOST_DESCENDENT_OF;
    static final Relation RIGHTMOST_DESCENDENT_OF;
    static final Relation SISTER_OF;
    static final Relation LEFT_SISTER_OF;
    static final Relation RIGHT_SISTER_OF;
    static final Relation IMMEDIATE_LEFT_SISTER_OF;
    static final Relation IMMEDIATE_RIGHT_SISTER_OF;
    static final Relation ONLY_CHILD_OF;
    static final Relation HAS_ONLY_CHILD;
    static final Relation UNARY_PATH_ANCESTOR_OF;
    static final Relation UNARY_PATH_DESCENDENT_OF;
    private static final Relation[] SIMPLE_RELATIONS;
    private static final Map<String, Relation> SIMPLE_RELATIONS_MAP;

    static void setHeadFinder(HeadFinder hf) {
        headFinder = hf;
    }

    abstract boolean satisfies(Tree var1, Tree var2, Tree var3);

    abstract Iterator<Tree> searchNodeIterator(Tree var1, Tree var2);

    static Relation getRelation(String s) throws ParseException {
        Relation r;
        if (SIMPLE_RELATIONS_MAP.containsKey(s)) {
            return SIMPLE_RELATIONS_MAP.get(s);
        }
        if (s.equals("<,")) {
            return Relation.getRelation("<", "1");
        }
        if (parentOfLastChild.matcher(s).matches()) {
            return Relation.getRelation("<", "-1");
        }
        if (s.equals(">,")) {
            return Relation.getRelation(">", "1");
        }
        if (lastChildOfParent.matcher(s).matches()) {
            return Relation.getRelation(">", "-1");
        }
        if (s.equals(">>#")) {
            r = new Heads(headFinder);
        } else if (s.equals("<<#")) {
            r = new HeadedBy(headFinder);
        } else if (s.equals(">#")) {
            r = new ImmediatelyHeads(headFinder);
        } else if (s.equals("<#")) {
            r = new ImmediatelyHeadedBy(headFinder);
        } else {
            throw new ParseException("Unrecognized simple relation " + s);
        }
        return Interner.globalIntern(r);
    }

    static Relation getRelation(String s, String arg) throws ParseException {
        Relation r;
        if (arg == null) {
            return Relation.getRelation(s);
        }
        if (s.equals("<")) {
            r = new HasIthChild(Integer.parseInt(arg));
        } else if (s.equals(">")) {
            r = new IthChildOf(Integer.parseInt(arg));
        } else if (s.equals("<+")) {
            r = new UnbrokenCategoryDominates(arg);
        } else if (s.equals(">+")) {
            r = new UnbrokenCategoryIsDominatedBy(arg);
        } else if (s.equals(".+")) {
            r = new UnbrokenCategoryPrecedes(arg);
        } else if (s.equals(",+")) {
            r = new UnbrokenCategoryFollows(arg);
        } else {
            throw new ParseException("Unrecognized compound relation " + s + ' ' + arg);
        }
        return Interner.globalIntern(r);
    }

    private Relation(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    private boolean testRelation(Tree t, Tree root) {
        HashSet<Tree> sat = new HashSet<Tree>();
        boolean error = false;
        Iterator<Tree> iter = this.searchNodeIterator(t, root);
        while (iter.hasNext()) {
            Tree satTree = iter.next();
            if (!this.satisfies(t, satTree, root)) {
                System.err.println("Subtree " + satTree.value() + " does not satisfy rel " + this + " with subtree " + t.value());
                error = true;
            }
            sat.add(satTree);
        }
        Set<Tree> unSat = root.subTrees();
        unSat.removeAll(sat);
        for (Tree unSatTree : unSat) {
            if (!this.satisfies(t, unSatTree, root)) continue;
            System.err.println("Subtree " + unSatTree.value() + " satisfies rel " + this + " with subtree " + t.value());
            error = true;
        }
        if (error) {
            System.err.println("SatisfyingNodes:");
            System.err.println(sat);
        }
        return error;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("usage: Relation treebank numberRanges");
            return;
        }
        NumberRangesFileFilter testFilt = new NumberRangesFileFilter(args[1], true);
        PennTreeReaderFactory trf = new PennTreeReaderFactory(new NPTmpRetainingTreeNormalizer());
        DiskTreebank testTreebank = new DiskTreebank(trf);
        testTreebank.loadPath(new File(args[0]), (FileFilter)testFilt);
        ModCollinsHeadFinder hf = new ModCollinsHeadFinder();
        ArrayList<Relation> relations = new ArrayList<Relation>();
        relations.addAll(Arrays.asList(SIMPLE_RELATIONS));
        relations.add(new HasIthChild(2));
        relations.add(new HasIthChild(-1));
        relations.add(new IthChildOf(1));
        relations.add(new IthChildOf(-2));
        relations.add(new HeadedBy(hf));
        relations.add(new Heads(hf));
        relations.add(new ImmediatelyHeadedBy(hf));
        relations.add(new ImmediatelyHeads(hf));
        relations.add(new UnbrokenCategoryDominates("NP"));
        relations.add(new UnbrokenCategoryDominates("VP"));
        relations.add(new UnbrokenCategoryIsDominatedBy("NP"));
        relations.add(new UnbrokenCategoryIsDominatedBy("VP"));
        int trees = 0;
        int subtrees = 0;
        for (Tree root : testTreebank) {
            for (Tree tree : root.subTrees()) {
                boolean error = false;
                for (Relation relation : relations) {
                    error = error || relation.testRelation(tree, root);
                }
                if (error) {
                    System.err.println("Tree: ");
                    root.pennPrint(System.err);
                    System.err.println();
                    System.err.println("SubTree: ");
                    tree.pennPrint(System.err);
                    System.err.println();
                    System.exit(0);
                }
                ++subtrees;
            }
            ++trees;
        }
        System.out.println("Tested all relations on " + subtrees + " subtrees in " + trees + " trees with no errors.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation relation = (Relation)o;
        return this.symbol.equals(relation.symbol);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    static {
        parentOfLastChild = Pattern.compile("(<-|<`)");
        lastChildOfParent = Pattern.compile("(>-|>`)");
        ROOT = new Relation("Root"){
            private static final long serialVersionUID = -8311913236233762612L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return t1 == t2;
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t;
                    }
                };
            }
        };
        EQUALS = new Relation("=="){
            private static final long serialVersionUID = 164629344977943816L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return t1 == t2;
            }

            @Override
            Iterator<Tree> searchNodeIterator(Tree t, Tree root) {
                return Collections.singletonList(t).iterator();
            }
        };
        PATTERN_SPLITTER = new Relation(":"){
            private static final long serialVersionUID = 3409941930361386114L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return true;
            }

            @Override
            Iterator<Tree> searchNodeIterator(Tree t, Tree root) {
                return root.iterator();
            }
        };
        DOMINATES = new Relation("<<"){
            private static final long serialVersionUID = -2580199434621268260L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return t1 != t2 && t1.dominates(t2);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){
                    Stack<Tree> searchStack;

                    public void initialize() {
                        this.searchStack = new Stack();
                        for (int i = t.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(t.getChild(i));
                        }
                        if (!this.searchStack.isEmpty()) {
                            this.advance();
                        }
                    }

                    void advance() {
                        if (this.searchStack.isEmpty()) {
                            this.next = null;
                        } else {
                            this.next = this.searchStack.pop();
                            for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                                this.searchStack.push(this.next.getChild(i));
                            }
                        }
                    }
                };
            }
        };
        DOMINATED_BY = new Relation(">>"){
            private static final long serialVersionUID = 6140614010121387690L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return DOMINATES.satisfies(t2, t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t.parent(root);
                    }

                    public void advance() {
                        this.next = this.next.parent(root);
                    }
                };
            }
        };
        PARENT_OF = new Relation("<"){
            private static final long serialVersionUID = 9140193735607580808L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                Tree[] kids = t1.children();
                int n = kids.length;
                for (int i = 0; i < n; ++i) {
                    if (kids[i] != t2) continue;
                    return true;
                }
                return false;
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){
                    int nextNum;

                    public void advance() {
                        if (this.nextNum < t.numChildren()) {
                            this.next = t.getChild(this.nextNum);
                            ++this.nextNum;
                        } else {
                            this.next = null;
                        }
                    }
                };
            }
        };
        CHILD_OF = new Relation(">"){
            private static final long serialVersionUID = 8919710375433372537L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return PARENT_OF.satisfies(t2, t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t.parent(root);
                    }
                };
            }
        };
        PRECEDES = new Relation(".."){
            private static final long serialVersionUID = -9065012389549976867L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return Trees.rightEdge(t1, root) <= Trees.leftEdge(t2, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){
                    Stack<Tree> searchStack;

                    public void initialize() {
                        this.searchStack = new Stack();
                        Tree current = t;
                        for (Tree parent = t.parent(root); parent != null; parent = parent.parent(root)) {
                            int i = parent.numChildren() - 1;
                            while (parent.getChild(i) != current) {
                                this.searchStack.push(parent.getChild(i));
                                --i;
                            }
                            current = parent;
                        }
                        this.advance();
                    }

                    void advance() {
                        if (this.searchStack.isEmpty()) {
                            this.next = null;
                        } else {
                            this.next = this.searchStack.pop();
                            for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                                this.searchStack.push(this.next.getChild(i));
                            }
                        }
                    }
                };
            }
        };
        IMMEDIATELY_PRECEDES = new Relation("."){
            private static final long serialVersionUID = 3390147676937292768L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return Trees.leftEdge(t2, root) == Trees.rightEdge(t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        Tree current;
                        Tree parent = t;
                        do {
                            current = parent;
                            if ((parent = parent.parent(root)) != null) continue;
                            this.next = null;
                            return;
                        } while (parent.lastChild() == current);
                        int n = parent.numChildren();
                        for (int i = 1; i < n; ++i) {
                            if (parent.getChild(i - 1) != current) continue;
                            this.next = parent.getChild(i);
                            return;
                        }
                    }

                    public void advance() {
                        this.next = this.next.isLeaf() ? null : this.next.firstChild();
                    }
                };
            }
        };
        FOLLOWS = new Relation(",,"){
            private static final long serialVersionUID = -5948063114149496983L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return Trees.rightEdge(t2, root) <= Trees.leftEdge(t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){
                    Stack<Tree> searchStack;

                    public void initialize() {
                        this.searchStack = new Stack();
                        Tree current = t;
                        for (Tree parent = t.parent(root); parent != null; parent = parent.parent(root)) {
                            int i = 0;
                            while (parent.getChild(i) != current) {
                                this.searchStack.push(parent.getChild(i));
                                ++i;
                            }
                            current = parent;
                        }
                        this.advance();
                    }

                    void advance() {
                        if (this.searchStack.isEmpty()) {
                            this.next = null;
                        } else {
                            this.next = this.searchStack.pop();
                            for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                                this.searchStack.push(this.next.getChild(i));
                            }
                        }
                    }
                };
            }
        };
        IMMEDIATELY_FOLLOWS = new Relation(","){
            private static final long serialVersionUID = -2895075562891296830L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return Trees.leftEdge(t1, root) == Trees.rightEdge(t2, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        Tree current;
                        Tree parent = t;
                        do {
                            current = parent;
                            if ((parent = parent.parent(root)) != null) continue;
                            this.next = null;
                            return;
                        } while (parent.firstChild() == current);
                        int n = parent.numChildren() - 1;
                        for (int i = 0; i < n; ++i) {
                            if (parent.getChild(i + 1) != current) continue;
                            this.next = parent.getChild(i);
                            return;
                        }
                    }

                    public void advance() {
                        this.next = this.next.isLeaf() ? null : this.next.lastChild();
                    }
                };
            }
        };
        HAS_LEFTMOST_DESCENDENT = new Relation("<<,"){
            private static final long serialVersionUID = -7352081789429366726L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t1.isLeaf()) {
                    return false;
                }
                return t1.children()[0] == t2 || this.satisfies(t1.children()[0], t2, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t;
                        this.advance();
                    }

                    public void advance() {
                        this.next = this.next.isLeaf() ? null : this.next.firstChild();
                    }
                };
            }
        };
        HAS_RIGHTMOST_DESCENDENT = new Relation("<<-"){
            private static final long serialVersionUID = -1405509785337859888L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t1.isLeaf()) {
                    return false;
                }
                Tree lastKid = t1.children()[t1.children().length - 1];
                return lastKid == t2 || this.satisfies(lastKid, t2, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t;
                        this.advance();
                    }

                    public void advance() {
                        this.next = this.next.isLeaf() ? null : this.next.lastChild();
                    }
                };
            }
        };
        LEFTMOST_DESCENDENT_OF = new Relation(">>,"){
            private static final long serialVersionUID = 3103412865783190437L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return HAS_LEFTMOST_DESCENDENT.satisfies(t2, t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t;
                        this.advance();
                    }

                    public void advance() {
                        Tree last = this.next;
                        this.next = this.next.parent(root);
                        if (this.next != null && this.next.firstChild() != last) {
                            this.next = null;
                        }
                    }
                };
            }
        };
        RIGHTMOST_DESCENDENT_OF = new Relation(">>-"){
            private static final long serialVersionUID = -2000255467314675477L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return HAS_RIGHTMOST_DESCENDENT.satisfies(t2, t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        this.next = t;
                        this.advance();
                    }

                    public void advance() {
                        Tree last = this.next;
                        this.next = this.next.parent(root);
                        if (this.next != null && this.next.lastChild() != last) {
                            this.next = null;
                        }
                    }
                };
            }
        };
        SISTER_OF = new Relation("$"){
            private static final long serialVersionUID = -3776688096782419004L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t1 == t2 || t1 == root) {
                    return false;
                }
                Tree parent = t1.parent(root);
                return PARENT_OF.satisfies(parent, t2, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){
                    Tree parent;
                    int nextNum;

                    void initialize() {
                        this.parent = t.parent(root);
                        if (this.parent != null) {
                            this.nextNum = 0;
                            this.advance();
                        }
                    }

                    public void advance() {
                        if (this.nextNum < this.parent.numChildren()) {
                            this.next = this.parent.getChild(this.nextNum++);
                            if (this.next == t) {
                                this.advance();
                            }
                        } else {
                            this.next = null;
                        }
                    }
                };
            }
        };
        LEFT_SISTER_OF = new Relation("$++"){
            private static final long serialVersionUID = -4516161080140406862L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t1 == t2 || t1 == root) {
                    return false;
                }
                Tree parent = t1.parent(root);
                Tree[] kids = parent.children();
                for (int i = kids.length - 1; i > 0; --i) {
                    if (kids[i] == t1) {
                        return false;
                    }
                    if (kids[i] != t2) continue;
                    return true;
                }
                return false;
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){
                    Tree parent;
                    int nextNum;

                    void initialize() {
                        this.parent = t.parent(root);
                        if (this.parent != null) {
                            this.nextNum = this.parent.numChildren() - 1;
                            this.advance();
                        }
                    }

                    public void advance() {
                        this.next = this.parent.getChild(this.nextNum--);
                        if (this.next == t) {
                            this.next = null;
                        }
                    }
                };
            }
        };
        RIGHT_SISTER_OF = new Relation("$--"){
            private static final long serialVersionUID = -5880626025192328694L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return LEFT_SISTER_OF.satisfies(t2, t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){
                    Tree parent;
                    int nextNum;

                    void initialize() {
                        this.parent = t.parent(root);
                        if (this.parent != null) {
                            this.nextNum = 0;
                            this.advance();
                        }
                    }

                    public void advance() {
                        this.next = this.parent.getChild(this.nextNum++);
                        if (this.next == t) {
                            this.next = null;
                        }
                    }
                };
            }
        };
        IMMEDIATE_LEFT_SISTER_OF = new Relation("$+"){
            private static final long serialVersionUID = 7745237994722126917L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t1 == t2 || t1 == root) {
                    return false;
                }
                Tree[] sisters = t1.parent(root).children();
                for (int i = sisters.length - 1; i > 0; --i) {
                    if (sisters[i] == t1) {
                        return false;
                    }
                    if (sisters[i] != t2) continue;
                    return sisters[i - 1] == t1;
                }
                return false;
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        if (t != root) {
                            Tree parent = t.parent(root);
                            int i = 0;
                            while (parent.getChild(i) != t) {
                                ++i;
                            }
                            if (i + 1 < parent.numChildren()) {
                                this.next = parent.getChild(i + 1);
                            }
                        }
                    }
                };
            }
        };
        IMMEDIATE_RIGHT_SISTER_OF = new Relation("$-"){
            private static final long serialVersionUID = -6555264189937531019L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return IMMEDIATE_LEFT_SISTER_OF.satisfies(t2, t1, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        if (t != root) {
                            Tree parent = t.parent(root);
                            int i = 0;
                            while (parent.getChild(i) != t) {
                                ++i;
                            }
                            if (i > 0) {
                                this.next = parent.getChild(i - 1);
                            }
                        }
                    }
                };
            }
        };
        ONLY_CHILD_OF = new Relation(">:"){
            private static final long serialVersionUID = 1719812660770087879L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return t2.children().length == 1 && t2.firstChild() == t1;
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        if (t != root) {
                            this.next = t.parent(root);
                            if (this.next.numChildren() != 1) {
                                this.next = null;
                            }
                        }
                    }
                };
            }
        };
        HAS_ONLY_CHILD = new Relation("<:"){
            private static final long serialVersionUID = -8776487500849294279L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                return t1.children().length == 1 && t1.firstChild() == t2;
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){

                    void initialize() {
                        if (!t.isLeaf() && t.numChildren() == 1) {
                            this.next = t.firstChild();
                        }
                    }
                };
            }
        };
        UNARY_PATH_ANCESTOR_OF = new Relation("<<:"){
            private static final long serialVersionUID = -742912038636163403L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t1.isLeaf() || t1.children().length > 1) {
                    return false;
                }
                Tree onlyDtr = t1.children()[0];
                if (onlyDtr == t2) {
                    return true;
                }
                return this.satisfies(onlyDtr, t2, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
                return new SearchNodeIterator(){
                    Stack<Tree> searchStack;

                    public void initialize() {
                        this.searchStack = new Stack();
                        if (!t.isLeaf() && t.children().length == 1) {
                            this.searchStack.push(t.getChild(0));
                        }
                        if (!this.searchStack.isEmpty()) {
                            this.advance();
                        }
                    }

                    void advance() {
                        if (this.searchStack.isEmpty()) {
                            this.next = null;
                        } else {
                            this.next = this.searchStack.pop();
                            if (!this.next.isLeaf() && this.next.children().length == 1) {
                                this.searchStack.push(this.next.getChild(0));
                            }
                        }
                    }
                };
            }
        };
        UNARY_PATH_DESCENDENT_OF = new Relation(">>:"){
            private static final long serialVersionUID = 4364021807752979404L;

            @Override
            boolean satisfies(Tree t1, Tree t2, Tree root) {
                if (t2.isLeaf() || t2.children().length > 1) {
                    return false;
                }
                Tree onlyDtr = t2.children()[0];
                if (onlyDtr == t1) {
                    return true;
                }
                return this.satisfies(t1, onlyDtr, root);
            }

            @Override
            Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
                return new SearchNodeIterator(){
                    Stack<Tree> searchStack;

                    public void initialize() {
                        this.searchStack = new Stack();
                        Tree parent = t.parent(root);
                        if (parent != null && !parent.isLeaf() && parent.children().length == 1) {
                            this.searchStack.push(parent);
                        }
                        if (!this.searchStack.isEmpty()) {
                            this.advance();
                        }
                    }

                    void advance() {
                        if (this.searchStack.isEmpty()) {
                            this.next = null;
                        } else {
                            this.next = this.searchStack.pop();
                            Tree parent = this.next.parent(root);
                            if (parent != null && !parent.isLeaf() && parent.children().length == 1) {
                                this.searchStack.push(parent);
                            }
                        }
                    }
                };
            }
        };
        SIMPLE_RELATIONS = new Relation[]{DOMINATES, DOMINATED_BY, PARENT_OF, CHILD_OF, PRECEDES, IMMEDIATELY_PRECEDES, FOLLOWS, IMMEDIATELY_FOLLOWS, HAS_LEFTMOST_DESCENDENT, HAS_RIGHTMOST_DESCENDENT, LEFTMOST_DESCENDENT_OF, RIGHTMOST_DESCENDENT_OF, SISTER_OF, LEFT_SISTER_OF, RIGHT_SISTER_OF, IMMEDIATE_LEFT_SISTER_OF, IMMEDIATE_RIGHT_SISTER_OF, ONLY_CHILD_OF, HAS_ONLY_CHILD, EQUALS, PATTERN_SPLITTER, UNARY_PATH_ANCESTOR_OF, UNARY_PATH_DESCENDENT_OF};
        SIMPLE_RELATIONS_MAP = new HashMap<String, Relation>();
        for (Relation r : SIMPLE_RELATIONS) {
            SIMPLE_RELATIONS_MAP.put(r.symbol, r);
        }
        SIMPLE_RELATIONS_MAP.put("<<`", HAS_RIGHTMOST_DESCENDENT);
        SIMPLE_RELATIONS_MAP.put("<<,", HAS_LEFTMOST_DESCENDENT);
        SIMPLE_RELATIONS_MAP.put(">>`", RIGHTMOST_DESCENDENT_OF);
        SIMPLE_RELATIONS_MAP.put(">>,", LEFTMOST_DESCENDENT_OF);
        SIMPLE_RELATIONS_MAP.put("$..", LEFT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$,,", RIGHT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$.", IMMEDIATE_LEFT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$,", IMMEDIATE_RIGHT_SISTER_OF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnbrokenCategoryFollows
    extends Relation {
        private static final long serialVersionUID = -7890430001297866437L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryFollows(String arg) {
            super(",+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = TregexPattern.currentBasicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return true;
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
            return new SearchNodeIterator(){
                IdentityHashSet<Tree> nodesToSearch;
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.nodesToSearch = new IdentityHashSet();
                    this.searchStack = new Stack();
                    this.initializeHelper(this.searchStack, t, root);
                    this.advance();
                }

                private void initializeHelper(Stack<Tree> stack, Tree node, Tree root2) {
                    Tree parent;
                    if (node == root2) {
                        return;
                    }
                    int i = parent.indexOf(node);
                    for (parent = node.parent(root2); i == 0 && parent != root2; parent = parent.parent(root2)) {
                        node = parent;
                        i = parent.indexOf(node);
                    }
                    Tree precedingNode = i > 0 ? parent.children()[i - 1] : null;
                    while (precedingNode != null) {
                        if (!this.nodesToSearch.contains(precedingNode)) {
                            stack.add(precedingNode);
                            this.nodesToSearch.add(precedingNode);
                        }
                        if (UnbrokenCategoryFollows.this.pathMatchesNode(precedingNode)) {
                            this.initializeHelper(stack, precedingNode, root2);
                        }
                        if (!precedingNode.isLeaf()) {
                            precedingNode = precedingNode.children()[0];
                            continue;
                        }
                        precedingNode = null;
                    }
                }

                @Override
                void advance() {
                    this.next = this.searchStack.isEmpty() ? null : this.searchStack.pop();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnbrokenCategoryPrecedes
    extends Relation {
        private static final long serialVersionUID = 6866888667804306111L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryPrecedes(String arg) {
            super(".+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = TregexPattern.currentBasicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return true;
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
            return new SearchNodeIterator(){
                private IdentityHashSet<Tree> nodesToSearch;
                private Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.nodesToSearch = new IdentityHashSet();
                    this.searchStack = new Stack();
                    this.initializeHelper(this.searchStack, t, root);
                    this.advance();
                }

                private void initializeHelper(Stack<Tree> stack, Tree node, Tree root2) {
                    Tree parent;
                    if (node == root2) {
                        return;
                    }
                    int i = parent.indexOf(node);
                    for (parent = node.parent(root2); i == parent.children().length - 1 && parent != root2; parent = parent.parent(root2)) {
                        node = parent;
                        i = parent.indexOf(node);
                    }
                    Tree followingNode = i + 1 < parent.children().length ? parent.children()[i + 1] : null;
                    while (followingNode != null) {
                        if (!this.nodesToSearch.contains(followingNode)) {
                            stack.add(followingNode);
                            this.nodesToSearch.add(followingNode);
                        }
                        if (UnbrokenCategoryPrecedes.this.pathMatchesNode(followingNode)) {
                            this.initializeHelper(stack, followingNode, root2);
                        }
                        if (!followingNode.isLeaf()) {
                            followingNode = followingNode.children()[0];
                            continue;
                        }
                        followingNode = null;
                    }
                }

                @Override
                void advance() {
                    this.next = this.searchStack.isEmpty() ? null : this.searchStack.pop();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnbrokenCategoryIsDominatedBy
    extends Relation {
        private static final long serialVersionUID = 2867922828235355129L;
        private UnbrokenCategoryDominates unbrokenCategoryDominates;

        UnbrokenCategoryIsDominatedBy(String arg) {
            super(">+(" + arg + ')');
            this.unbrokenCategoryDominates = Interner.globalIntern(new UnbrokenCategoryDominates(arg));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.unbrokenCategoryDominates.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    this.next = t.parent(root);
                }

                public void advance() {
                    this.next = UnbrokenCategoryIsDominatedBy.this.unbrokenCategoryDominates.pathMatchesNode(this.next) ? this.next.parent(root) : null;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnbrokenCategoryIsDominatedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnbrokenCategoryIsDominatedBy unbrokenCategoryIsDominatedBy = (UnbrokenCategoryIsDominatedBy)o;
            return this.unbrokenCategoryDominates.equals(unbrokenCategoryIsDominatedBy.unbrokenCategoryDominates);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + this.unbrokenCategoryDominates.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnbrokenCategoryDominates
    extends Relation {
        private static final long serialVersionUID = -4174923168221859262L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryDominates(String arg) {
            super("<+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = TregexPattern.currentBasicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            for (Tree kid : t1.children()) {
                if (kid == t2) {
                    return true;
                }
                if (!this.pathMatchesNode(kid) || !this.satisfies(kid, t2, root)) continue;
                return true;
            }
            return false;
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                public void initialize() {
                    this.searchStack = new Stack();
                    for (int i = t.numChildren() - 1; i >= 0; --i) {
                        this.searchStack.push(t.getChild(i));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        if (UnbrokenCategoryDominates.this.pathMatchesNode(this.next)) {
                            for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                                this.searchStack.push(this.next.getChild(i));
                            }
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnbrokenCategoryDominates)) {
                return false;
            }
            UnbrokenCategoryDominates unbrokenCategoryDominates = (UnbrokenCategoryDominates)o;
            if (this.negatedPattern != unbrokenCategoryDominates.negatedPattern) {
                return false;
            }
            return this.pattern.equals(unbrokenCategoryDominates.pattern);
        }

        @Override
        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 29 * result + (this.negatedPattern ? 1 : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasIthChild
    extends Relation {
        private static final long serialVersionUID = 3546853729291582806L;
        private final IthChildOf ithChildOf;

        HasIthChild(int i) {
            super('<' + String.valueOf(i));
            this.ithChildOf = Interner.globalIntern(new IthChildOf(i));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.ithChildOf.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    int childNum = HasIthChild.this.ithChildOf.childNum;
                    if (t.numChildren() >= Math.abs(childNum)) {
                        this.next = childNum > 0 ? t.getChild(childNum - 1) : t.getChild(t.numChildren() + childNum);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HasIthChild)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HasIthChild hasIthChild = (HasIthChild)o;
            return !(this.ithChildOf != null ? !this.ithChildOf.equals(hasIthChild.ithChildOf) : hasIthChild.ithChildOf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.ithChildOf != null ? this.ithChildOf.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IthChildOf
    extends Relation {
        private static final long serialVersionUID = -1463126827537879633L;
        private int childNum;

        IthChildOf(int i) {
            super('>' + String.valueOf(i));
            if (i == 0) {
                throw new IllegalArgumentException("Error -- no such thing as zeroth child!");
            }
            this.childNum = i;
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            Tree[] kids = t2.children();
            if (kids.length < Math.abs(this.childNum)) {
                return false;
            }
            if (this.childNum > 0 && kids[this.childNum - 1] == t1) {
                return true;
            }
            return this.childNum < 0 && kids[kids.length + this.childNum] == t1;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    if (t != root) {
                        this.next = t.parent(root);
                        if (IthChildOf.this.childNum > 0 && (this.next.numChildren() < IthChildOf.this.childNum || this.next.getChild(IthChildOf.this.childNum - 1) != t) || IthChildOf.this.childNum < 0 && (this.next.numChildren() < -IthChildOf.this.childNum || this.next.getChild(this.next.numChildren() + IthChildOf.this.childNum) != t)) {
                            this.next = null;
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IthChildOf)) {
                return false;
            }
            IthChildOf ithChildOf = (IthChildOf)o;
            return this.childNum == ithChildOf.childNum;
        }

        @Override
        public int hashCode() {
            return this.childNum;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmediatelyHeadedBy
    extends Relation {
        private static final long serialVersionUID = 5910075663419780905L;
        private ImmediatelyHeads immediatelyHeads;

        ImmediatelyHeadedBy(HeadFinder hf) {
            super("<#");
            this.immediatelyHeads = Interner.globalIntern(new ImmediatelyHeads(hf));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.immediatelyHeads.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    if (!t.isLeaf()) {
                        this.next = ImmediatelyHeadedBy.this.immediatelyHeads.hf.determineHead(t);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmediatelyHeadedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImmediatelyHeadedBy immediatelyHeadedBy = (ImmediatelyHeadedBy)o;
            return !(this.immediatelyHeads != null ? !this.immediatelyHeads.equals(immediatelyHeadedBy.immediatelyHeads) : immediatelyHeadedBy.immediatelyHeads != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.immediatelyHeads != null ? this.immediatelyHeads.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmediatelyHeads
    extends Relation {
        private static final long serialVersionUID = 2085410152913894987L;
        private HeadFinder hf;

        ImmediatelyHeads(HeadFinder hf) {
            super(">#");
            this.hf = hf;
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.hf.determineHead(t2) == t1;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    if (t != root) {
                        this.next = t.parent(root);
                        if (ImmediatelyHeads.this.hf.determineHead(this.next) != t) {
                            this.next = null;
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmediatelyHeads)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImmediatelyHeads immediatelyHeads = (ImmediatelyHeads)o;
            return this.hf.equals(immediatelyHeads.hf);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + this.hf.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeadedBy
    extends Relation {
        private static final long serialVersionUID = 2825997185749055693L;
        private Heads heads;

        HeadedBy(HeadFinder hf) {
            super("<<#");
            this.heads = Interner.globalIntern(new Heads(hf));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.heads.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    this.next = t;
                    this.advance();
                }

                public void advance() {
                    this.next = this.next.isLeaf() ? null : ((HeadedBy)HeadedBy.this).heads.hf.determineHead(this.next);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeadedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HeadedBy headedBy = (HeadedBy)o;
            return !(this.heads != null ? !this.heads.equals(headedBy.heads) : headedBy.heads != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.heads != null ? this.heads.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Heads
    extends Relation {
        private static final long serialVersionUID = 4681433462932265831L;
        HeadFinder hf;

        Heads(HeadFinder hf) {
            super(">>#");
            this.hf = hf;
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t2.isLeaf()) {
                return false;
            }
            if (t2.isPreTerminal()) {
                return t2.firstChild() == t1;
            }
            Tree head = this.hf.determineHead(t2);
            if (head == t1) {
                return true;
            }
            return this.satisfies(t1, head, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final Tree root) {
            return new SearchNodeIterator(){

                void initialize() {
                    this.next = t;
                    this.advance();
                }

                public void advance() {
                    Tree last = this.next;
                    this.next = this.next.parent(root);
                    if (this.next != null && Heads.this.hf.determineHead(this.next) != last) {
                        this.next = null;
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Heads)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Heads heads = (Heads)o;
            return !(this.hf != null ? !this.hf.equals(heads.hf) : heads.hf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.hf != null ? this.hf.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SearchNodeIterator
    implements Iterator<Tree> {
        Tree next = null;

        public SearchNodeIterator() {
            this.initialize();
        }

        void initialize() {
            this.advance();
        }

        void advance() {
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Tree next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Tree ret = this.next;
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SearchNodeIterator does not support remove().");
        }
    }
}

