/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RangeBucket
extends MultiBucketBase
implements ToCopyableBuilder<Builder, RangeBucket> {
    @Nullable
    private final Double from;
    @Nullable
    private final String fromAsString;
    @Nullable
    private final String key;
    @Nullable
    private final Double to;
    @Nullable
    private final String toAsString;
    public static final JsonpDeserializer<RangeBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeBucket::setupRangeBucketDeserializer);

    private RangeBucket(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.fromAsString = builder.fromAsString;
        this.key = builder.key;
        this.to = builder.to;
        this.toAsString = builder.toAsString;
    }

    public static RangeBucket of(Function<Builder, ObjectBuilder<RangeBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double from() {
        return this.from;
    }

    @Nullable
    public final String fromAsString() {
        return this.fromAsString;
    }

    @Nullable
    public final String key() {
        return this.key;
    }

    @Nullable
    public final Double to() {
        return this.to;
    }

    @Nullable
    public final String toAsString() {
        return this.toAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.doubleValue());
        }
        if (this.fromAsString != null) {
            generator.writeKey("from_as_string");
            generator.write(this.fromAsString);
        }
        if (this.key != null) {
            generator.writeKey("key");
            generator.write(this.key);
        }
        if (this.to != null) {
            generator.writeKey("to");
            generator.write(this.to.doubleValue());
        }
        if (this.toAsString != null) {
            generator.writeKey("to_as_string");
            generator.write(this.toAsString);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRangeBucketDeserializer(ObjectDeserializer<Builder> op) {
        RangeBucket.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::from, JsonpDeserializer.doubleDeserializer(), "from");
        op.add(Builder::fromAsString, JsonpDeserializer.stringDeserializer(), "from_as_string");
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
        op.add(Builder::to, JsonpDeserializer.doubleDeserializer(), "to");
        op.add(Builder::toAsString, JsonpDeserializer.stringDeserializer(), "to_as_string");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.from);
        result = 31 * result + Objects.hashCode(this.fromAsString);
        result = 31 * result + Objects.hashCode(this.key);
        result = 31 * result + Objects.hashCode(this.to);
        result = 31 * result + Objects.hashCode(this.toAsString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeBucket other = (RangeBucket)o;
        return Objects.equals(this.from, other.from) && Objects.equals(this.fromAsString, other.fromAsString) && Objects.equals(this.key, other.key) && Objects.equals(this.to, other.to) && Objects.equals(this.toAsString, other.toAsString);
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RangeBucket> {
        @Nullable
        private Double from;
        @Nullable
        private String fromAsString;
        @Nullable
        private String key;
        @Nullable
        private Double to;
        @Nullable
        private String toAsString;

        public Builder() {
        }

        private Builder(RangeBucket o) {
            super(o);
            this.from = o.from;
            this.fromAsString = o.fromAsString;
            this.key = o.key;
            this.to = o.to;
            this.toAsString = o.toAsString;
        }

        private Builder(Builder o) {
            super(o);
            this.from = o.from;
            this.fromAsString = o.fromAsString;
            this.key = o.key;
            this.to = o.to;
            this.toAsString = o.toAsString;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder from(@Nullable Double value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public final Builder fromAsString(@Nullable String value) {
            this.fromAsString = value;
            return this;
        }

        @Nonnull
        public final Builder key(@Nullable String value) {
            this.key = value;
            return this;
        }

        @Nonnull
        public final Builder to(@Nullable Double value) {
            this.to = value;
            return this;
        }

        @Nonnull
        public final Builder toAsString(@Nullable String value) {
            this.toAsString = value;
            return this;
        }

        @Override
        @Nonnull
        public RangeBucket build() {
            this._checkSingleUse();
            return new RangeBucket(this);
        }
    }
}

