/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SourceFilter
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SourceFilter> {
    @Nonnull
    private final List<String> excludes;
    @Nonnull
    private final List<String> includes;
    public static final JsonpDeserializer<SourceFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceFilter::setupSourceFilterDeserializer);

    private SourceFilter(Builder builder) {
        this.excludes = ApiTypeHelper.unmodifiable(builder.excludes);
        this.includes = ApiTypeHelper.unmodifiable(builder.includes);
    }

    public static SourceFilter of(Function<Builder, ObjectBuilder<SourceFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> excludes() {
        return this.excludes;
    }

    @Nonnull
    public final List<String> includes() {
        return this.includes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.excludes)) {
            generator.writeKey("excludes");
            generator.writeStartArray();
            for (String item0 : this.excludes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.includes)) {
            generator.writeKey("includes");
            generator.writeStartArray();
            for (String item0 : this.includes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSourceFilterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::excludes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "excludes", "exclude");
        op.add(Builder::includes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "includes", "include");
        op.shortcutProperty("includes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.excludes);
        result = 31 * result + Objects.hashCode(this.includes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceFilter other = (SourceFilter)o;
        return Objects.equals(this.excludes, other.excludes) && Objects.equals(this.includes, other.includes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SourceFilter> {
        @Nullable
        private List<String> excludes;
        @Nullable
        private List<String> includes;

        public Builder() {
        }

        private Builder(SourceFilter o) {
            this.excludes = Builder._listCopy(o.excludes);
            this.includes = Builder._listCopy(o.includes);
        }

        private Builder(Builder o) {
            this.excludes = Builder._listCopy(o.excludes);
            this.includes = Builder._listCopy(o.includes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder excludes(List<String> list) {
            this.excludes = Builder._listAddAll(this.excludes, list);
            return this;
        }

        @Nonnull
        public final Builder excludes(String value, String ... values) {
            this.excludes = Builder._listAdd(this.excludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder includes(List<String> list) {
            this.includes = Builder._listAddAll(this.includes, list);
            return this;
        }

        @Nonnull
        public final Builder includes(String value, String ... values) {
            this.includes = Builder._listAdd(this.includes, value, values);
            return this;
        }

        @Override
        @Nonnull
        public SourceFilter build() {
            this._checkSingleUse();
            return new SourceFilter(this);
        }
    }
}

