/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.servlets;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.pool.ConnectionPoolType;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.props.PooledConnectionFactoryPropertySource;
import org.ldaptive.props.PropertySource;
import org.ldaptive.props.SearchRequestPropertySource;
import org.ldaptive.servlets.ServletSearchExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServletSearchExecutor
implements ServletSearchExecutor {
    private static final String POOL_TYPE = "poolType";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PooledConnectionFactory connectionFactory;
    private SearchExecutor searchExecutor;

    @Override
    public void initialize(ServletConfig config) {
        this.searchExecutor = new SearchExecutor();
        SearchRequestPropertySource srSource = new SearchRequestPropertySource((SearchRequest)this.searchExecutor, AbstractServletSearchExecutor.createProperties(config));
        srSource.initialize();
        this.logger.debug("searchExecutor = {}", (Object)this.searchExecutor);
        this.connectionFactory = new PooledConnectionFactory();
        PooledConnectionFactoryPropertySource cfPropSource = new PooledConnectionFactoryPropertySource(this.connectionFactory, AbstractServletSearchExecutor.createProperties(config));
        cfPropSource.setPoolType(ConnectionPoolType.valueOf(config.getInitParameter(POOL_TYPE)));
        cfPropSource.initialize();
        this.logger.debug("connectionFactory = {}", (Object)this.connectionFactory);
    }

    protected static Properties createProperties(ServletConfig config) {
        Properties p = new Properties();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.contains(".")) {
                p.setProperty(name, config.getInitParameter(name));
                continue;
            }
            p.setProperty(PropertySource.PropertyDomain.LDAP.value() + name, config.getInitParameter(name));
        }
        return p;
    }

    @Override
    public void search(HttpServletRequest request, HttpServletResponse response) throws LdapException, IOException {
        String queryString = request.getParameter("query");
        if (queryString == null || queryString.isEmpty()) {
            this.logger.info("Ignoring empty query");
        } else {
            SearchResult result = this.searchExecutor.search((ConnectionFactory)this.connectionFactory, queryString, request.getParameterValues("attrs")).getResult();
            this.writeResponse(result, response);
        }
    }

    protected abstract void writeResponse(SearchResult var1, HttpServletResponse var2) throws IOException;

    @Override
    public void close() {
        this.connectionFactory.getConnectionPool().close();
    }
}

