/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.AbstractAnonymizer;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public class StringAnonymizer
extends AbstractAnonymizer<String> {
    private Map<Integer, String> latestStringMap;

    public StringAnonymizer() {
        this.latestStringMap = new HashMap<Integer, String>();
        this.caseSensitive = false;
    }

    public StringAnonymizer(Map<Integer, String> latestStringMap) {
        this.latestStringMap = latestStringMap == null ? new HashMap<Integer, String>() : latestStringMap;
        this.caseSensitive = false;
    }

    @Override
    public Attribute anonymize(Map<Value, Value> valueMap, Set<Value> valueSet, Attribute attribute) {
        AttributeType attributeType = attribute.getAttributeType();
        DefaultAttribute result = new DefaultAttribute(attributeType);
        for (Value value : attribute) {
            if (!value.isHumanReadable()) continue;
            Value anonymized = valueMap.get(value);
            if (anonymized != null) {
                try {
                    result.add(anonymized);
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                continue;
            }
            String strValue = value.getString();
            String newValue = this.computeNewValue(strValue);
            try {
                result.add(newValue);
                Value anonValue = new Value(attribute.getAttributeType(), newValue);
                valueMap.put(value, anonValue);
                valueSet.add(anonValue);
            }
            catch (LdapInvalidAttributeValueException e) {
                throw new RuntimeException(I18n.err(I18n.ERR_13436_ERROR_ANONYMIZING_VALUE, strValue));
            }
        }
        return result;
    }

    @Override
    public Map<Integer, String> getLatestStringMap() {
        return this.latestStringMap;
    }

    @Override
    public void setLatestStringMap(Map<Integer, String> latestStringMap) {
        this.latestStringMap = latestStringMap;
    }
}

