/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class DisplayedInferencesPreferencePanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = 8356095374634408957L;
    public static final String LABEL = "Displayed Inferences";
    private ReasonerPreferences preferences;
    private EnumMap<ReasonerPreferences.OptionalInferenceTask, JCheckBox> enabledMap = new EnumMap(ReasonerPreferences.OptionalInferenceTask.class);

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel layoutPanel = new PreferencesLayoutPanel();
        this.add((Component)layoutPanel, "North");
        this.preferences = this.getOWLModelManager().getReasonerPreferences();
        this.buildClassFrameSectionPreferences(layoutPanel);
        layoutPanel.addSeparator();
        this.buildObjectPropertyFrameSectionPreferences(layoutPanel);
        layoutPanel.addSeparator();
        this.buildDataPropertyFrameSectionPreferences(layoutPanel);
        layoutPanel.addSeparator();
        this.buildIndividualFrameSectionPreferences(layoutPanel);
    }

    public void applyChanges() {
        for (Map.Entry<ReasonerPreferences.OptionalInferenceTask, JCheckBox> entry : this.enabledMap.entrySet()) {
            ReasonerPreferences.OptionalInferenceTask task = entry.getKey();
            JCheckBox enabledBox = entry.getValue();
            this.preferences.setEnabled(task, enabledBox.isSelected());
        }
        this.preferences.save();
    }

    public void dispose() throws Exception {
        this.enabledMap = null;
    }

    private void buildClassFrameSectionPreferences(PreferencesLayoutPanel layoutPanel) {
        layoutPanel.addGroup("Class inferences");
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_CLASS_UNSATISFIABILITY, "Satisfiability"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_CLASSES, "Equivalent Classes"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SUPER_CLASSES, "Superclasses"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERED_CLASS_MEMBERS, "Class Instances"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_DISJOINT_CLASSES, "Disjoint Classes"));
    }

    private void buildObjectPropertyFrameSectionPreferences(PreferencesLayoutPanel layoutPanel) {
        layoutPanel.addGroup("Object property inferences");
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_OBJECT_PROPERTY_UNSATISFIABILITY, "Satisfiability"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_OBJECT_PROPERTY_DOMAINS, "Domains"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_OBJECT_PROPERTY_RANGES, "Ranges"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_OBJECT_PROPERTIES, "Equivalent Properties"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SUPER_OBJECT_PROPERTIES, "Super Properties"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_INVERSE_PROPERTIES, "Inverse properties"));
    }

    private void buildDataPropertyFrameSectionPreferences(PreferencesLayoutPanel layoutPanel) {
        layoutPanel.addGroup("Data property inferences");
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_DATATYPE_PROPERTY_DOMAINS, "Domains"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_DATATYPE_PROPERTIES, "Equivalent Properties"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SUPER_DATATYPE_PROPERTIES, "Super Properties"));
    }

    private void buildIndividualFrameSectionPreferences(PreferencesLayoutPanel layoutPanel) {
        layoutPanel.addGroup("Individual inferences");
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_TYPES, "Types"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_OBJECT_PROPERTY_ASSERTIONS, "Object Property Assertions"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_DATA_PROPERTY_ASSERTIONS, "Data Property Assertions"));
        layoutPanel.addGroupComponent((JComponent)this.getCheckBox(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SAMEAS_INDIVIDUAL_ASSERTIONS, "Same Individuals"));
    }

    private JCheckBox getCheckBox(ReasonerPreferences.OptionalInferenceTask task, String description) {
        JCheckBox enabledBox = this.enabledMap.get((Object)task);
        if (enabledBox == null) {
            description = "<html><body>" + (String)description + " <span style='color: gray;'>(" + this.timeToString(this.preferences.getTimeInTask(task)) + " total/" + this.timeToString(this.preferences.getAverageTimeInTask(task)) + " average)</span>";
            enabledBox = new JCheckBox((String)description);
            enabledBox.setSelected(this.preferences.isEnabled(task));
            this.enabledMap.put(task, enabledBox);
        }
        return enabledBox;
    }

    private String timeToString(int milliseconds) {
        StringBuilder sb = new StringBuilder();
        int seconds = milliseconds / 1000 % 60;
        int minutes = milliseconds / 60000;
        if (minutes != 0) {
            sb.append(minutes);
            sb.append(" min ");
        }
        if (seconds != 0) {
            sb.append(seconds);
            sb.append(" sec");
        }
        if (minutes == 0 && seconds == 0) {
            sb.append(milliseconds);
            sb.append(" ms");
        }
        return sb.toString();
    }
}

