/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gdm-session-worker-glue.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringIntFunc)
       (void *data1,
        const gchar *arg_service_name,
        gint arg_status,
        void *data2);
  _GDbusCodegenMarshalVoid_StringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_language,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_name,
        const gchar *arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_details,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_pid_of_caller,
        gint arg_uid_of_caller,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.Worker
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusWorker
 * @title: GdmDBusWorker
 * @short_description: Generated C code for the org.gnome.DisplayManager.Worker D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link> D-Bus interface in C.
 */

enum
{
  GDM_DBUS__WORKER_SESSION_EXITED,
  GDM_DBUS__WORKER_SAVED_LANGUAGE_NAME_READ,
  GDM_DBUS__WORKER_SAVED_SESSION_NAME_READ,
  GDM_DBUS__WORKER_SAVED_SESSION_TYPE_READ,
  GDM_DBUS__WORKER_USERNAME_CHANGED,
  GDM_DBUS__WORKER_REAUTHENTICATED,
  GDM_DBUS__WORKER_CANCEL_PENDING_QUERY,
};

static unsigned GDM_DBUS__WORKER_SIGNALS[7] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.Worker ---- */

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_authenticate =
{
  {
    -1,
    (gchar *) "Authenticate",
    NULL,
    NULL,
    NULL
  },
  "handle-authenticate",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_authorize =
{
  {
    -1,
    (gchar *) "Authorize",
    NULL,
    NULL,
    NULL
  },
  "handle-authorize",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_establish_credentials =
{
  {
    -1,
    (gchar *) "EstablishCredentials",
    NULL,
    NULL,
    NULL
  },
  "handle-establish-credentials",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_open_OUT_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_open_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_open_OUT_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_open =
{
  {
    -1,
    (gchar *) "Open",
    NULL,
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_open_OUT_ARG_pointers,
    NULL
  },
  "handle-open",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_set_language_name_IN_ARG_language =
{
  {
    -1,
    (gchar *) "language",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_set_language_name_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_set_language_name_IN_ARG_language.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_set_language_name =
{
  {
    -1,
    (gchar *) "SetLanguageName",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_set_language_name_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-language-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_set_session_name_IN_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_set_session_name_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_set_session_name_IN_ARG_session_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_set_session_name =
{
  {
    -1,
    (gchar *) "SetSessionName",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_set_session_name_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-session-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_set_session_display_mode_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_set_session_display_mode_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_set_session_display_mode_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_set_session_display_mode =
{
  {
    -1,
    (gchar *) "SetSessionDisplayMode",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_set_session_display_mode_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-session-display-mode",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_set_environment_variable_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_set_environment_variable_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_set_environment_variable_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_set_environment_variable_IN_ARG_name.parent_struct,
  &_gdm_dbus_worker_method_info_set_environment_variable_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_set_environment_variable =
{
  {
    -1,
    (gchar *) "SetEnvironmentVariable",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_set_environment_variable_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-environment-variable",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_start_program_IN_ARG_command =
{
  {
    -1,
    (gchar *) "command",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_start_program_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_start_program_IN_ARG_command.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_start_program_OUT_ARG_child_pid =
{
  {
    -1,
    (gchar *) "child_pid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_start_program_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_start_program_OUT_ARG_child_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_start_program =
{
  {
    -1,
    (gchar *) "StartProgram",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_start_program_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_start_program_OUT_ARG_pointers,
    NULL
  },
  "handle-start-program",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_initialize_IN_ARG_details =
{
  {
    -1,
    (gchar *) "details",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_initialize_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_initialize_IN_ARG_details.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_initialize =
{
  {
    -1,
    (gchar *) "Initialize",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_initialize_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-initialize",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_start_reauthentication_IN_ARG_pid_of_caller =
{
  {
    -1,
    (gchar *) "pid_of_caller",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_start_reauthentication_IN_ARG_uid_of_caller =
{
  {
    -1,
    (gchar *) "uid_of_caller",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_start_reauthentication_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_start_reauthentication_IN_ARG_pid_of_caller.parent_struct,
  &_gdm_dbus_worker_method_info_start_reauthentication_IN_ARG_uid_of_caller.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_method_info_start_reauthentication_OUT_ARG_address =
{
  {
    -1,
    (gchar *) "address",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_method_info_start_reauthentication_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_method_info_start_reauthentication_OUT_ARG_address.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_method_info_start_reauthentication =
{
  {
    -1,
    (gchar *) "StartReauthentication",
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_start_reauthentication_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_dbus_worker_method_info_start_reauthentication_OUT_ARG_pointers,
    NULL
  },
  "handle-start-reauthentication",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_worker_method_info_pointers[] =
{
  &_gdm_dbus_worker_method_info_authenticate.parent_struct,
  &_gdm_dbus_worker_method_info_authorize.parent_struct,
  &_gdm_dbus_worker_method_info_establish_credentials.parent_struct,
  &_gdm_dbus_worker_method_info_open.parent_struct,
  &_gdm_dbus_worker_method_info_set_language_name.parent_struct,
  &_gdm_dbus_worker_method_info_set_session_name.parent_struct,
  &_gdm_dbus_worker_method_info_set_session_display_mode.parent_struct,
  &_gdm_dbus_worker_method_info_set_environment_variable.parent_struct,
  &_gdm_dbus_worker_method_info_start_program.parent_struct,
  &_gdm_dbus_worker_method_info_initialize.parent_struct,
  &_gdm_dbus_worker_method_info_start_reauthentication.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_session_exited_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_session_exited_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_signal_info_session_exited_ARG_pointers[] =
{
  &_gdm_dbus_worker_signal_info_session_exited_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_signal_info_session_exited_ARG_status.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_session_exited =
{
  {
    -1,
    (gchar *) "SessionExited",
    (GDBusArgInfo **) &_gdm_dbus_worker_signal_info_session_exited_ARG_pointers,
    NULL
  },
  "session-exited"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_saved_language_name_read_ARG_language_name =
{
  {
    -1,
    (gchar *) "language_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_signal_info_saved_language_name_read_ARG_pointers[] =
{
  &_gdm_dbus_worker_signal_info_saved_language_name_read_ARG_language_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_saved_language_name_read =
{
  {
    -1,
    (gchar *) "SavedLanguageNameRead",
    (GDBusArgInfo **) &_gdm_dbus_worker_signal_info_saved_language_name_read_ARG_pointers,
    NULL
  },
  "saved-language-name-read"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_saved_session_name_read_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_signal_info_saved_session_name_read_ARG_pointers[] =
{
  &_gdm_dbus_worker_signal_info_saved_session_name_read_ARG_session_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_saved_session_name_read =
{
  {
    -1,
    (gchar *) "SavedSessionNameRead",
    (GDBusArgInfo **) &_gdm_dbus_worker_signal_info_saved_session_name_read_ARG_pointers,
    NULL
  },
  "saved-session-name-read"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_saved_session_type_read_ARG_session_type =
{
  {
    -1,
    (gchar *) "session_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_signal_info_saved_session_type_read_ARG_pointers[] =
{
  &_gdm_dbus_worker_signal_info_saved_session_type_read_ARG_session_type.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_saved_session_type_read =
{
  {
    -1,
    (gchar *) "SavedSessionTypeRead",
    (GDBusArgInfo **) &_gdm_dbus_worker_signal_info_saved_session_type_read_ARG_pointers,
    NULL
  },
  "saved-session-type-read"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_username_changed_ARG_new_username =
{
  {
    -1,
    (gchar *) "new_username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_signal_info_username_changed_ARG_pointers[] =
{
  &_gdm_dbus_worker_signal_info_username_changed_ARG_new_username.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_username_changed =
{
  {
    -1,
    (gchar *) "UsernameChanged",
    (GDBusArgInfo **) &_gdm_dbus_worker_signal_info_username_changed_ARG_pointers,
    NULL
  },
  "username-changed"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_reauthenticated_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_signal_info_reauthenticated_ARG_pid_of_caller =
{
  {
    -1,
    (gchar *) "pid_of_caller",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_signal_info_reauthenticated_ARG_pointers[] =
{
  &_gdm_dbus_worker_signal_info_reauthenticated_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_signal_info_reauthenticated_ARG_pid_of_caller.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_reauthenticated =
{
  {
    -1,
    (gchar *) "Reauthenticated",
    (GDBusArgInfo **) &_gdm_dbus_worker_signal_info_reauthenticated_ARG_pointers,
    NULL
  },
  "reauthenticated"
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_worker_signal_info_cancel_pending_query =
{
  {
    -1,
    (gchar *) "CancelPendingQuery",
    NULL,
    NULL
  },
  "cancel-pending-query"
};

static const GDBusSignalInfo * const _gdm_dbus_worker_signal_info_pointers[] =
{
  &_gdm_dbus_worker_signal_info_session_exited.parent_struct,
  &_gdm_dbus_worker_signal_info_saved_language_name_read.parent_struct,
  &_gdm_dbus_worker_signal_info_saved_session_name_read.parent_struct,
  &_gdm_dbus_worker_signal_info_saved_session_type_read.parent_struct,
  &_gdm_dbus_worker_signal_info_username_changed.parent_struct,
  &_gdm_dbus_worker_signal_info_reauthenticated.parent_struct,
  &_gdm_dbus_worker_signal_info_cancel_pending_query.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_worker_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.Worker",
    (GDBusMethodInfo **) &_gdm_dbus_worker_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_dbus_worker_signal_info_pointers,
    NULL,
    NULL
  },
  "worker",
};


/**
 * gdm_dbus_worker_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_worker_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_worker_interface_info.parent_struct;
}

/**
 * gdm_dbus_worker_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusWorker interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_worker_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_worker_signal_marshal_session_exited (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_signal_marshal_saved_language_name_read (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_signal_marshal_saved_session_name_read (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_signal_marshal_saved_session_type_read (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_signal_marshal_username_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_signal_marshal_reauthenticated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_signal_marshal_cancel_pending_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_authenticate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_authorize (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_establish_credentials (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_open (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_set_language_name (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_set_session_name (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_set_session_display_mode (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_set_environment_variable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_start_program (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_initialize (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_method_marshal_start_reauthentication (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusWorker:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link>.
 */

/**
 * GdmDBusWorkerIface:
 * @parent_iface: The parent interface.
 * @handle_authenticate: Handler for the #GdmDBusWorker::handle-authenticate signal.
 * @handle_authorize: Handler for the #GdmDBusWorker::handle-authorize signal.
 * @handle_establish_credentials: Handler for the #GdmDBusWorker::handle-establish-credentials signal.
 * @handle_initialize: Handler for the #GdmDBusWorker::handle-initialize signal.
 * @handle_open: Handler for the #GdmDBusWorker::handle-open signal.
 * @handle_set_environment_variable: Handler for the #GdmDBusWorker::handle-set-environment-variable signal.
 * @handle_set_language_name: Handler for the #GdmDBusWorker::handle-set-language-name signal.
 * @handle_set_session_display_mode: Handler for the #GdmDBusWorker::handle-set-session-display-mode signal.
 * @handle_set_session_name: Handler for the #GdmDBusWorker::handle-set-session-name signal.
 * @handle_start_program: Handler for the #GdmDBusWorker::handle-start-program signal.
 * @handle_start_reauthentication: Handler for the #GdmDBusWorker::handle-start-reauthentication signal.
 * @cancel_pending_query: Handler for the #GdmDBusWorker::cancel-pending-query signal.
 * @reauthenticated: Handler for the #GdmDBusWorker::reauthenticated signal.
 * @saved_language_name_read: Handler for the #GdmDBusWorker::saved-language-name-read signal.
 * @saved_session_name_read: Handler for the #GdmDBusWorker::saved-session-name-read signal.
 * @saved_session_type_read: Handler for the #GdmDBusWorker::saved-session-type-read signal.
 * @session_exited: Handler for the #GdmDBusWorker::session-exited signal.
 * @username_changed: Handler for the #GdmDBusWorker::username-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link>.
 */

typedef GdmDBusWorkerIface GdmDBusWorkerInterface;
G_DEFINE_INTERFACE (GdmDBusWorker, gdm_dbus_worker, G_TYPE_OBJECT)

static void
gdm_dbus_worker_default_init (GdmDBusWorkerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusWorker::handle-authenticate:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authenticate">Authenticate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_authenticate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-authenticate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_authenticate),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_authenticate,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmDBusWorker::handle-authorize:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authorize">Authorize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_authorize() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-authorize",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_authorize),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_authorize,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmDBusWorker::handle-establish-credentials:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.EstablishCredentials">EstablishCredentials()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_establish_credentials() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-establish-credentials",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_establish_credentials),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_establish_credentials,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmDBusWorker::handle-open:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Open">Open()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_open() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_open),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_open,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmDBusWorker::handle-set-language-name:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_language: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetLanguageName">SetLanguageName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_set_language_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-language-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_set_language_name),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_set_language_name,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusWorker::handle-set-session-name:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionName">SetSessionName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_set_session_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-session-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_set_session_name),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_set_session_name,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusWorker::handle-set-session-display-mode:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionDisplayMode">SetSessionDisplayMode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_set_session_display_mode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-session-display-mode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_set_session_display_mode),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_set_session_display_mode,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusWorker::handle-set-environment-variable:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetEnvironmentVariable">SetEnvironmentVariable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_set_environment_variable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-environment-variable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_set_environment_variable),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_set_environment_variable,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusWorker::handle-start-program:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_command: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartProgram">StartProgram()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_start_program() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-program",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_start_program),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_start_program,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusWorker::handle-initialize:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_details: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Initialize">Initialize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_initialize() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-initialize",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_initialize),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_initialize,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GdmDBusWorker::handle-start-reauthentication:
   * @object: A #GdmDBusWorker.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid_of_caller: Argument passed by remote caller.
   * @arg_uid_of_caller: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartReauthentication">StartReauthentication()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_complete_start_reauthentication() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-reauthentication",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerIface, handle_start_reauthentication),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_method_marshal_start_reauthentication,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmDBusWorker::session-exited:
   * @object: A #GdmDBusWorker.
   * @arg_service_name: Argument.
   * @arg_status: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SessionExited">"SessionExited"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SESSION_EXITED] =
    g_signal_new ("session-exited",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, session_exited),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_session_exited,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_INT);

  /**
   * GdmDBusWorker::saved-language-name-read:
   * @object: A #GdmDBusWorker.
   * @arg_language_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SavedLanguageNameRead">"SavedLanguageNameRead"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SAVED_LANGUAGE_NAME_READ] =
    g_signal_new ("saved-language-name-read",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, saved_language_name_read),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_saved_language_name_read,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusWorker::saved-session-name-read:
   * @object: A #GdmDBusWorker.
   * @arg_session_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SavedSessionNameRead">"SavedSessionNameRead"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SAVED_SESSION_NAME_READ] =
    g_signal_new ("saved-session-name-read",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, saved_session_name_read),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_saved_session_name_read,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusWorker::saved-session-type-read:
   * @object: A #GdmDBusWorker.
   * @arg_session_type: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SavedSessionTypeRead">"SavedSessionTypeRead"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SAVED_SESSION_TYPE_READ] =
    g_signal_new ("saved-session-type-read",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, saved_session_type_read),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_saved_session_type_read,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusWorker::username-changed:
   * @object: A #GdmDBusWorker.
   * @arg_new_username: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.UsernameChanged">"UsernameChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_USERNAME_CHANGED] =
    g_signal_new ("username-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, username_changed),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_username_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusWorker::reauthenticated:
   * @object: A #GdmDBusWorker.
   * @arg_service_name: Argument.
   * @arg_pid_of_caller: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.Reauthenticated">"Reauthenticated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_REAUTHENTICATED] =
    g_signal_new ("reauthenticated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, reauthenticated),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_reauthenticated,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_INT);

  /**
   * GdmDBusWorker::cancel-pending-query:
   * @object: A #GdmDBusWorker.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.CancelPendingQuery">"CancelPendingQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_CANCEL_PENDING_QUERY] =
    g_signal_new ("cancel-pending-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusWorkerIface, cancel_pending_query),
      NULL,
      NULL,
      gdm_dbus_worker_signal_marshal_cancel_pending_query,
      G_TYPE_NONE,
      0);

}

/**
 * gdm_dbus_worker_emit_session_exited:
 * @object: A #GdmDBusWorker.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_status: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SessionExited">"SessionExited"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_session_exited (
    GdmDBusWorker *object,
    const gchar *arg_service_name,
    gint arg_status)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SESSION_EXITED], 0, arg_service_name, arg_status);
}

/**
 * gdm_dbus_worker_emit_saved_language_name_read:
 * @object: A #GdmDBusWorker.
 * @arg_language_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SavedLanguageNameRead">"SavedLanguageNameRead"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_saved_language_name_read (
    GdmDBusWorker *object,
    const gchar *arg_language_name)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SAVED_LANGUAGE_NAME_READ], 0, arg_language_name);
}

/**
 * gdm_dbus_worker_emit_saved_session_name_read:
 * @object: A #GdmDBusWorker.
 * @arg_session_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SavedSessionNameRead">"SavedSessionNameRead"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_saved_session_name_read (
    GdmDBusWorker *object,
    const gchar *arg_session_name)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SAVED_SESSION_NAME_READ], 0, arg_session_name);
}

/**
 * gdm_dbus_worker_emit_saved_session_type_read:
 * @object: A #GdmDBusWorker.
 * @arg_session_type: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.SavedSessionTypeRead">"SavedSessionTypeRead"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_saved_session_type_read (
    GdmDBusWorker *object,
    const gchar *arg_session_type)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_SAVED_SESSION_TYPE_READ], 0, arg_session_type);
}

/**
 * gdm_dbus_worker_emit_username_changed:
 * @object: A #GdmDBusWorker.
 * @arg_new_username: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.UsernameChanged">"UsernameChanged"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_username_changed (
    GdmDBusWorker *object,
    const gchar *arg_new_username)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_USERNAME_CHANGED], 0, arg_new_username);
}

/**
 * gdm_dbus_worker_emit_reauthenticated:
 * @object: A #GdmDBusWorker.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_pid_of_caller: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.Reauthenticated">"Reauthenticated"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_reauthenticated (
    GdmDBusWorker *object,
    const gchar *arg_service_name,
    gint arg_pid_of_caller)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_REAUTHENTICATED], 0, arg_service_name, arg_pid_of_caller);
}

/**
 * gdm_dbus_worker_emit_cancel_pending_query:
 * @object: A #GdmDBusWorker.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Worker.CancelPendingQuery">"CancelPendingQuery"</link> D-Bus signal.
 */
void
gdm_dbus_worker_emit_cancel_pending_query (
    GdmDBusWorker *object)
{
  g_signal_emit (object, GDM_DBUS__WORKER_SIGNALS[GDM_DBUS__WORKER_CANCEL_PENDING_QUERY], 0);
}

/**
 * gdm_dbus_worker_call_authenticate:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authenticate">Authenticate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_authenticate_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_authenticate_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_authenticate (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Authenticate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_authenticate_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_authenticate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_authenticate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_authenticate_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_authenticate_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authenticate">Authenticate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_authenticate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_authenticate_sync (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Authenticate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_authorize:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authorize">Authorize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_authorize_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_authorize_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_authorize (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Authorize",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_authorize_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_authorize().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_authorize().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_authorize_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_authorize_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authorize">Authorize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_authorize() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_authorize_sync (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Authorize",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_establish_credentials:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.EstablishCredentials">EstablishCredentials()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_establish_credentials_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_establish_credentials_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_establish_credentials (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EstablishCredentials",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_establish_credentials_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_establish_credentials().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_establish_credentials().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_establish_credentials_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_establish_credentials_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.EstablishCredentials">EstablishCredentials()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_establish_credentials() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_establish_credentials_sync (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EstablishCredentials",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_open:
 * @proxy: A #GdmDBusWorkerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Open">Open()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_open_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_open_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_open (
    GdmDBusWorker *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_open_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @out_session_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_open().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_open_finish (
    GdmDBusWorker *proxy,
    gchar ** out_session_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_session_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_open_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @out_session_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Open">Open()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_open() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_open_sync (
    GdmDBusWorker *proxy,
    gchar ** out_session_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_session_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_language_name:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_language: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetLanguageName">SetLanguageName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_set_language_name_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_set_language_name_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_set_language_name (
    GdmDBusWorker *proxy,
    const gchar *arg_language,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLanguageName",
    g_variant_new ("(s)",
                   arg_language),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_set_language_name_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_set_language_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_set_language_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_language_name_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_language_name_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_language: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetLanguageName">SetLanguageName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_set_language_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_language_name_sync (
    GdmDBusWorker *proxy,
    const gchar *arg_language,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLanguageName",
    g_variant_new ("(s)",
                   arg_language),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_session_name:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionName">SetSessionName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_set_session_name_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_set_session_name_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_set_session_name (
    GdmDBusWorker *proxy,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSessionName",
    g_variant_new ("(s)",
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_set_session_name_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_set_session_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_set_session_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_session_name_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_session_name_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionName">SetSessionName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_set_session_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_session_name_sync (
    GdmDBusWorker *proxy,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSessionName",
    g_variant_new ("(s)",
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_session_display_mode:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionDisplayMode">SetSessionDisplayMode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_set_session_display_mode_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_set_session_display_mode_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_set_session_display_mode (
    GdmDBusWorker *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSessionDisplayMode",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_set_session_display_mode_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_set_session_display_mode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_set_session_display_mode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_session_display_mode_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_session_display_mode_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionDisplayMode">SetSessionDisplayMode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_set_session_display_mode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_session_display_mode_sync (
    GdmDBusWorker *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSessionDisplayMode",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_environment_variable:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetEnvironmentVariable">SetEnvironmentVariable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_set_environment_variable_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_set_environment_variable_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_set_environment_variable (
    GdmDBusWorker *proxy,
    const gchar *arg_name,
    const gchar *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEnvironmentVariable",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_set_environment_variable_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_set_environment_variable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_set_environment_variable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_environment_variable_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_set_environment_variable_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetEnvironmentVariable">SetEnvironmentVariable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_set_environment_variable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_set_environment_variable_sync (
    GdmDBusWorker *proxy,
    const gchar *arg_name,
    const gchar *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEnvironmentVariable",
    g_variant_new ("(ss)",
                   arg_name,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_start_program:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_command: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartProgram">StartProgram()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_start_program_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_start_program_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_start_program (
    GdmDBusWorker *proxy,
    const gchar *arg_command,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartProgram",
    g_variant_new ("(s)",
                   arg_command),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_start_program_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @out_child_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_start_program().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_start_program().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_start_program_finish (
    GdmDBusWorker *proxy,
    gint* out_child_pid,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_child_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_start_program_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_command: Argument to pass with the method invocation.
 * @out_child_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartProgram">StartProgram()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_start_program() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_start_program_sync (
    GdmDBusWorker *proxy,
    const gchar *arg_command,
    gint* out_child_pid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartProgram",
    g_variant_new ("(s)",
                   arg_command),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_child_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_initialize:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_details: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Initialize">Initialize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_initialize_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_initialize_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_initialize (
    GdmDBusWorker *proxy,
    GVariant *arg_details,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Initialize",
    g_variant_new ("(@a{sv})",
                   arg_details),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_initialize_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_initialize().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_initialize().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_initialize_finish (
    GdmDBusWorker *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_initialize_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_details: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Initialize">Initialize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_initialize() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_initialize_sync (
    GdmDBusWorker *proxy,
    GVariant *arg_details,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Initialize",
    g_variant_new ("(@a{sv})",
                   arg_details),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_start_reauthentication:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_pid_of_caller: Argument to pass with the method invocation.
 * @arg_uid_of_caller: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartReauthentication">StartReauthentication()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_call_start_reauthentication_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_call_start_reauthentication_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_call_start_reauthentication (
    GdmDBusWorker *proxy,
    gint arg_pid_of_caller,
    gint arg_uid_of_caller,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartReauthentication",
    g_variant_new ("(ii)",
                   arg_pid_of_caller,
                   arg_uid_of_caller),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_call_start_reauthentication_finish:
 * @proxy: A #GdmDBusWorkerProxy.
 * @out_address: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_call_start_reauthentication().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_call_start_reauthentication().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_start_reauthentication_finish (
    GdmDBusWorker *proxy,
    gchar ** out_address,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_address);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_call_start_reauthentication_sync:
 * @proxy: A #GdmDBusWorkerProxy.
 * @arg_pid_of_caller: Argument to pass with the method invocation.
 * @arg_uid_of_caller: Argument to pass with the method invocation.
 * @out_address: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartReauthentication">StartReauthentication()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_call_start_reauthentication() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_call_start_reauthentication_sync (
    GdmDBusWorker *proxy,
    gint arg_pid_of_caller,
    gint arg_uid_of_caller,
    gchar ** out_address,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartReauthentication",
    g_variant_new ("(ii)",
                   arg_pid_of_caller,
                   arg_uid_of_caller),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_address);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_complete_authenticate:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authenticate">Authenticate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_authenticate (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_authorize:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Authorize">Authorize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_authorize (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_establish_credentials:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.EstablishCredentials">EstablishCredentials()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_establish_credentials (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_open:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Open">Open()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_open (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   session_id));
}

/**
 * gdm_dbus_worker_complete_set_language_name:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetLanguageName">SetLanguageName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_set_language_name (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_set_session_name:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionName">SetSessionName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_set_session_name (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_set_session_display_mode:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetSessionDisplayMode">SetSessionDisplayMode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_set_session_display_mode (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_set_environment_variable:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.SetEnvironmentVariable">SetEnvironmentVariable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_set_environment_variable (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_start_program:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @child_pid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartProgram">StartProgram()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_start_program (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint child_pid)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   child_pid));
}

/**
 * gdm_dbus_worker_complete_initialize:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.Initialize">Initialize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_initialize (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_complete_start_reauthentication:
 * @object: A #GdmDBusWorker.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @address: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Worker.StartReauthentication">StartReauthentication()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_complete_start_reauthentication (
    GdmDBusWorker *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *address)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   address));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusWorkerProxy:
 *
 * The #GdmDBusWorkerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusWorkerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusWorkerProxy.
 */

struct _GdmDBusWorkerProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_worker_proxy_iface_init (GdmDBusWorkerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerProxy, gdm_dbus_worker_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusWorkerProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER, gdm_dbus_worker_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerProxy, gdm_dbus_worker_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER, gdm_dbus_worker_proxy_iface_init))

#endif
static void
gdm_dbus_worker_proxy_finalize (GObject *object)
{
  GdmDBusWorkerProxy *proxy = GDM_DBUS_WORKER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_worker_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_worker_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_worker_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_worker_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_worker_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_WORKER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_WORKER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_worker_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusWorkerProxy *proxy = GDM_DBUS_WORKER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_worker_proxy_init (GdmDBusWorkerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_worker_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_WORKER_PROXY, GdmDBusWorkerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_worker_interface_info ());
}

static void
gdm_dbus_worker_proxy_class_init (GdmDBusWorkerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_worker_proxy_finalize;
  gobject_class->get_property = gdm_dbus_worker_proxy_get_property;
  gobject_class->set_property = gdm_dbus_worker_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_worker_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_worker_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusWorkerProxyPrivate));
#endif
}

static void
gdm_dbus_worker_proxy_iface_init (GdmDBusWorkerIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_worker_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_worker_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_WORKER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Worker", NULL);
}

/**
 * gdm_dbus_worker_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_worker_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusWorkerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorker *
gdm_dbus_worker_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_WORKER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_worker_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusWorkerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorker *
gdm_dbus_worker_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_WORKER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Worker", NULL);
  if (ret != NULL)
    return GDM_DBUS_WORKER (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_worker_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_worker_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_worker_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_WORKER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Worker", NULL);
}

/**
 * gdm_dbus_worker_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_worker_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusWorkerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorker *
gdm_dbus_worker_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_WORKER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_worker_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_worker_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusWorkerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorker *
gdm_dbus_worker_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_WORKER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Worker", NULL);
  if (ret != NULL)
    return GDM_DBUS_WORKER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusWorkerSkeleton:
 *
 * The #GdmDBusWorkerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusWorkerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusWorkerSkeleton.
 */

struct _GdmDBusWorkerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_worker_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_WORKER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_WORKER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_worker_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_worker_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_worker_skeleton_vtable =
{
  _gdm_dbus_worker_skeleton_handle_method_call,
  _gdm_dbus_worker_skeleton_handle_get_property,
  _gdm_dbus_worker_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_worker_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_worker_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_worker_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_worker_skeleton_vtable;
}

static GVariant *
gdm_dbus_worker_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_worker_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_worker_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_worker_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_worker_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_worker_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_dbus_worker_on_signal_session_exited (
    GdmDBusWorker *object,
    const gchar *arg_service_name,
    gint arg_status)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(si)",
                   arg_service_name,
                   arg_status));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "SessionExited",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_worker_on_signal_saved_language_name_read (
    GdmDBusWorker *object,
    const gchar *arg_language_name)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_language_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "SavedLanguageNameRead",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_worker_on_signal_saved_session_name_read (
    GdmDBusWorker *object,
    const gchar *arg_session_name)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_session_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "SavedSessionNameRead",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_worker_on_signal_saved_session_type_read (
    GdmDBusWorker *object,
    const gchar *arg_session_type)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_session_type));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "SavedSessionTypeRead",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_worker_on_signal_username_changed (
    GdmDBusWorker *object,
    const gchar *arg_new_username)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_new_username));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "UsernameChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_worker_on_signal_reauthenticated (
    GdmDBusWorker *object,
    const gchar *arg_service_name,
    gint arg_pid_of_caller)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(si)",
                   arg_service_name,
                   arg_pid_of_caller));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "Reauthenticated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_worker_on_signal_cancel_pending_query (
    GdmDBusWorker *object)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Worker", "CancelPendingQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_dbus_worker_skeleton_iface_init (GdmDBusWorkerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerSkeleton, gdm_dbus_worker_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusWorkerSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER, gdm_dbus_worker_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerSkeleton, gdm_dbus_worker_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER, gdm_dbus_worker_skeleton_iface_init))

#endif
static void
gdm_dbus_worker_skeleton_finalize (GObject *object)
{
  GdmDBusWorkerSkeleton *skeleton = GDM_DBUS_WORKER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_worker_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_worker_skeleton_init (GdmDBusWorkerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_worker_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_WORKER_SKELETON, GdmDBusWorkerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_worker_skeleton_class_init (GdmDBusWorkerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_worker_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_worker_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_worker_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_worker_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_worker_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusWorkerSkeletonPrivate));
#endif
}

static void
gdm_dbus_worker_skeleton_iface_init (GdmDBusWorkerIface *iface)
{
  iface->session_exited = _gdm_dbus_worker_on_signal_session_exited;
  iface->saved_language_name_read = _gdm_dbus_worker_on_signal_saved_language_name_read;
  iface->saved_session_name_read = _gdm_dbus_worker_on_signal_saved_session_name_read;
  iface->saved_session_type_read = _gdm_dbus_worker_on_signal_saved_session_type_read;
  iface->username_changed = _gdm_dbus_worker_on_signal_username_changed;
  iface->reauthenticated = _gdm_dbus_worker_on_signal_reauthenticated;
  iface->cancel_pending_query = _gdm_dbus_worker_on_signal_cancel_pending_query;
}

/**
 * gdm_dbus_worker_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Worker.top_of_page">org.gnome.DisplayManager.Worker</link>.
 *
 * Returns: (transfer full) (type GdmDBusWorkerSkeleton): The skeleton object.
 */
GdmDBusWorker *
gdm_dbus_worker_skeleton_new (void)
{
  return GDM_DBUS_WORKER (g_object_new (GDM_DBUS_TYPE_WORKER_SKELETON, NULL));
}

