/* parsed class NVA16F */

#include "nvtypes.h"
#include "cla16f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nva16f_SET_OBJECT {
    uint32_t nvclass;
    uint32_t engine;
};

static inline void
__NVA16F_SET_OBJECT(uint32_t *val_out, struct nv_nva16f_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.nvclass < (1ULL << 16));
    val |= st.nvclass << 0;
    
    assert(st.engine < (1ULL << 5));
    val |= st.engine << 16;
    *val_out = val;
}

#define V_NVA16F_SET_OBJECT(val, args...) { \
    UNUSED uint32_t ENGINE_SW = NVA16F_SET_OBJECT_ENGINE_SW; \
    struct nv_nva16f_SET_OBJECT __data = args; \
    __NVA16F_SET_OBJECT(&val, __data); \
}

#define VA_NVA16F_SET_OBJECT V_NVA16F_SET_OBJECT

#define P_NVA16F_SET_OBJECT(push, args...) do { \
    UNUSED uint32_t ENGINE_SW = NVA16F_SET_OBJECT_ENGINE_SW; \
    uint32_t nvk_p_ret; \
    V_NVA16F_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nva16f_ILLEGAL {
    uint32_t handle;
};

static inline void
__NVA16F_ILLEGAL(uint32_t *val_out, struct nv_nva16f_ILLEGAL st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA16F_ILLEGAL(val, args...) { \
    struct nv_nva16f_ILLEGAL __data = { .handle = (args) }; \
    __NVA16F_ILLEGAL(&val, __data); \
}

#define VA_NVA16F_ILLEGAL V_NVA16F_ILLEGAL

#define P_NVA16F_ILLEGAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_ILLEGAL(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_ILLEGAL, nvk_p_ret); \
} while(0)

struct nv_nva16f_NOP {
    uint32_t handle;
};

static inline void
__NVA16F_NOP(uint32_t *val_out, struct nv_nva16f_NOP st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA16F_NOP(val, args...) { \
    struct nv_nva16f_NOP __data = { .handle = (args) }; \
    __NVA16F_NOP(&val, __data); \
}

#define VA_NVA16F_NOP V_NVA16F_NOP

#define P_NVA16F_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_NOP, nvk_p_ret); \
} while(0)

struct nv_nva16f_SEMAPHOREA {
    uint32_t offset_upper;
};

static inline void
__NVA16F_SEMAPHOREA(uint32_t *val_out, struct nv_nva16f_SEMAPHOREA st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA16F_SEMAPHOREA(val, args...) { \
    struct nv_nva16f_SEMAPHOREA __data = { .offset_upper = (args) }; \
    __NVA16F_SEMAPHOREA(&val, __data); \
}

#define VA_NVA16F_SEMAPHOREA V_NVA16F_SEMAPHOREA

#define P_NVA16F_SEMAPHOREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_SEMAPHOREA(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_SEMAPHOREA, nvk_p_ret); \
} while(0)

struct nv_nva16f_SEMAPHOREB {
    uint32_t offset_lower;
};

static inline void
__NVA16F_SEMAPHOREB(uint32_t *val_out, struct nv_nva16f_SEMAPHOREB st)
{
    uint32_t val = 0;
    
    assert(st.offset_lower < (1ULL << 30));
    val |= st.offset_lower << 2;
    *val_out = val;
}

#define V_NVA16F_SEMAPHOREB(val, args...) { \
    struct nv_nva16f_SEMAPHOREB __data = { .offset_lower = (args) }; \
    __NVA16F_SEMAPHOREB(&val, __data); \
}

#define VA_NVA16F_SEMAPHOREB V_NVA16F_SEMAPHOREB

#define P_NVA16F_SEMAPHOREB(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_SEMAPHOREB(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_SEMAPHOREB, nvk_p_ret); \
} while(0)

struct nv_nva16f_SEMAPHOREC {
    uint32_t payload;
};

static inline void
__NVA16F_SEMAPHOREC(uint32_t *val_out, struct nv_nva16f_SEMAPHOREC st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA16F_SEMAPHOREC(val, args...) { \
    struct nv_nva16f_SEMAPHOREC __data = { .payload = (args) }; \
    __NVA16F_SEMAPHOREC(&val, __data); \
}

#define VA_NVA16F_SEMAPHOREC V_NVA16F_SEMAPHOREC

#define P_NVA16F_SEMAPHOREC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_SEMAPHOREC(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_SEMAPHOREC, nvk_p_ret); \
} while(0)

struct nv_nva16f_SEMAPHORED {
    uint32_t operation;
    uint32_t acquire_switch;
    uint32_t release_wfi;
    uint32_t release_size;
    uint32_t reduction;
    uint32_t format;
};

static inline void
__NVA16F_SEMAPHORED(uint32_t *val_out, struct nv_nva16f_SEMAPHORED st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 0;
    
    assert(st.acquire_switch < (1ULL << 1));
    val |= st.acquire_switch << 12;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.release_size < (1ULL << 1));
    val |= st.release_size << 24;
    
    assert(st.reduction < (1ULL << 4));
    val |= st.reduction << 27;
    
    assert(st.format < (1ULL << 1));
    val |= st.format << 31;
    *val_out = val;
}

#define V_NVA16F_SEMAPHORED(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVA16F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVA16F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVA16F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVA16F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVA16F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVA16F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVA16F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVA16F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVA16F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVA16F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVA16F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVA16F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVA16F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVA16F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVA16F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVA16F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVA16F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVA16F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVA16F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVA16F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVA16F_SEMAPHORED_FORMAT_UNSIGNED; \
    struct nv_nva16f_SEMAPHORED __data = args; \
    __NVA16F_SEMAPHORED(&val, __data); \
}

#define VA_NVA16F_SEMAPHORED V_NVA16F_SEMAPHORED

#define P_NVA16F_SEMAPHORED(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVA16F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVA16F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVA16F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVA16F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVA16F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVA16F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVA16F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVA16F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVA16F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVA16F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVA16F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVA16F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVA16F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVA16F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVA16F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVA16F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVA16F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVA16F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVA16F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVA16F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVA16F_SEMAPHORED_FORMAT_UNSIGNED; \
    uint32_t nvk_p_ret; \
    V_NVA16F_SEMAPHORED(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_SEMAPHORED, nvk_p_ret); \
} while(0)

struct nv_nva16f_NON_STALL_INTERRUPT {
    uint32_t handle;
};

static inline void
__NVA16F_NON_STALL_INTERRUPT(uint32_t *val_out, struct nv_nva16f_NON_STALL_INTERRUPT st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA16F_NON_STALL_INTERRUPT(val, args...) { \
    struct nv_nva16f_NON_STALL_INTERRUPT __data = { .handle = (args) }; \
    __NVA16F_NON_STALL_INTERRUPT(&val, __data); \
}

#define VA_NVA16F_NON_STALL_INTERRUPT V_NVA16F_NON_STALL_INTERRUPT

#define P_NVA16F_NON_STALL_INTERRUPT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_NON_STALL_INTERRUPT(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_NON_STALL_INTERRUPT, nvk_p_ret); \
} while(0)

struct nv_nva16f_FB_FLUSH {
    uint32_t handle;
};

static inline void
__NVA16F_FB_FLUSH(uint32_t *val_out, struct nv_nva16f_FB_FLUSH st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA16F_FB_FLUSH(val, args...) { \
    struct nv_nva16f_FB_FLUSH __data = { .handle = (args) }; \
    __NVA16F_FB_FLUSH(&val, __data); \
}

#define VA_NVA16F_FB_FLUSH V_NVA16F_FB_FLUSH

#define P_NVA16F_FB_FLUSH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_FB_FLUSH(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_FB_FLUSH, nvk_p_ret); \
} while(0)

struct nv_nva16f_MEM_OP_A {
    uint32_t operand_low;
    uint32_t tlb_invalidate_addr;
    uint32_t tlb_invalidate_target;
};

static inline void
__NVA16F_MEM_OP_A(uint32_t *val_out, struct nv_nva16f_MEM_OP_A st)
{
    uint32_t val = 0;
    
    assert(st.operand_low < (1ULL << 30));
    val |= st.operand_low << 2;
    
    assert(st.tlb_invalidate_addr < (1ULL << 28));
    val |= st.tlb_invalidate_addr << 2;
    
    assert(st.tlb_invalidate_target < (1ULL << 2));
    val |= st.tlb_invalidate_target << 30;
    *val_out = val;
}

#define V_NVA16F_MEM_OP_A(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_VID_MEM = NVA16F_MEM_OP_A_TLB_INVALIDATE_TARGET_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT = NVA16F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT = NVA16F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT; \
    struct nv_nva16f_MEM_OP_A __data = args; \
    __NVA16F_MEM_OP_A(&val, __data); \
}

#define VA_NVA16F_MEM_OP_A V_NVA16F_MEM_OP_A

#define P_NVA16F_MEM_OP_A(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_VID_MEM = NVA16F_MEM_OP_A_TLB_INVALIDATE_TARGET_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT = NVA16F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT = NVA16F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT; \
    uint32_t nvk_p_ret; \
    V_NVA16F_MEM_OP_A(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_MEM_OP_A, nvk_p_ret); \
} while(0)

struct nv_nva16f_MEM_OP_B {
    uint32_t operand_high;
    uint32_t operation;
    uint32_t mmu_tlb_invalidate_pdb;
    uint32_t mmu_tlb_invalidate_gpc;
};

static inline void
__NVA16F_MEM_OP_B(uint32_t *val_out, struct nv_nva16f_MEM_OP_B st)
{
    uint32_t val = 0;
    
    assert(st.operand_high < (1ULL << 8));
    val |= st.operand_high << 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 27;
    
    assert(st.mmu_tlb_invalidate_pdb < (1ULL << 1));
    val |= st.mmu_tlb_invalidate_pdb << 0;
    
    assert(st.mmu_tlb_invalidate_gpc < (1ULL << 1));
    val |= st.mmu_tlb_invalidate_gpc << 1;
    *val_out = val;
}

#define V_NVA16F_MEM_OP_B(val, args...) { \
    UNUSED uint32_t OPERATION_SYSMEMBAR_FLUSH = NVA16F_MEM_OP_B_OPERATION_SYSMEMBAR_FLUSH; \
    UNUSED uint32_t OPERATION_SOFT_FLUSH = NVA16F_MEM_OP_B_OPERATION_SOFT_FLUSH; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVA16F_MEM_OP_B_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVA16F_MEM_OP_B_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVA16F_MEM_OP_B_OPERATION_L2_SYSMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_CLEAN_COMPTAGS = NVA16F_MEM_OP_B_OPERATION_L2_CLEAN_COMPTAGS; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVA16F_MEM_OP_B_OPERATION_L2_FLUSH_DIRTY; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ONE = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ALL = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_ENABLE = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_DISABLE = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_DISABLE; \
    struct nv_nva16f_MEM_OP_B __data = args; \
    __NVA16F_MEM_OP_B(&val, __data); \
}

#define VA_NVA16F_MEM_OP_B V_NVA16F_MEM_OP_B

#define P_NVA16F_MEM_OP_B(push, args...) do { \
    UNUSED uint32_t OPERATION_SYSMEMBAR_FLUSH = NVA16F_MEM_OP_B_OPERATION_SYSMEMBAR_FLUSH; \
    UNUSED uint32_t OPERATION_SOFT_FLUSH = NVA16F_MEM_OP_B_OPERATION_SOFT_FLUSH; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVA16F_MEM_OP_B_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVA16F_MEM_OP_B_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVA16F_MEM_OP_B_OPERATION_L2_SYSMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_CLEAN_COMPTAGS = NVA16F_MEM_OP_B_OPERATION_L2_CLEAN_COMPTAGS; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVA16F_MEM_OP_B_OPERATION_L2_FLUSH_DIRTY; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ONE = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ALL = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_ENABLE = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_DISABLE = NVA16F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_DISABLE; \
    uint32_t nvk_p_ret; \
    V_NVA16F_MEM_OP_B(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_MEM_OP_B, nvk_p_ret); \
} while(0)

struct nv_nva16f_SET_REFERENCE {
    uint32_t count;
};

static inline void
__NVA16F_SET_REFERENCE(uint32_t *val_out, struct nv_nva16f_SET_REFERENCE st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVA16F_SET_REFERENCE(val, args...) { \
    struct nv_nva16f_SET_REFERENCE __data = { .count = (args) }; \
    __NVA16F_SET_REFERENCE(&val, __data); \
}

#define VA_NVA16F_SET_REFERENCE V_NVA16F_SET_REFERENCE

#define P_NVA16F_SET_REFERENCE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_SET_REFERENCE(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_SET_REFERENCE, nvk_p_ret); \
} while(0)

struct nv_nva16f_WFI {
    uint32_t handle;
};

static inline void
__NVA16F_WFI(uint32_t *val_out, struct nv_nva16f_WFI st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA16F_WFI(val, args...) { \
    struct nv_nva16f_WFI __data = { .handle = (args) }; \
    __NVA16F_WFI(&val, __data); \
}

#define VA_NVA16F_WFI V_NVA16F_WFI

#define P_NVA16F_WFI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_WFI, nvk_p_ret); \
} while(0)

struct nv_nva16f_CRC_CHECK {
    uint32_t value;
};

static inline void
__NVA16F_CRC_CHECK(uint32_t *val_out, struct nv_nva16f_CRC_CHECK st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA16F_CRC_CHECK(val, args...) { \
    struct nv_nva16f_CRC_CHECK __data = { .value = (args) }; \
    __NVA16F_CRC_CHECK(&val, __data); \
}

#define VA_NVA16F_CRC_CHECK V_NVA16F_CRC_CHECK

#define P_NVA16F_CRC_CHECK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA16F_CRC_CHECK(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_CRC_CHECK, nvk_p_ret); \
} while(0)

struct nv_nva16f_YIELD {
    uint32_t op;
};

static inline void
__NVA16F_YIELD(uint32_t *val_out, struct nv_nva16f_YIELD st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    *val_out = val;
}

#define V_NVA16F_YIELD(val, args...) { \
    UNUSED uint32_t OP_NOP = NVA16F_YIELD_OP_NOP; \
    struct nv_nva16f_YIELD __data = { .op = (args) }; \
    __NVA16F_YIELD(&val, __data); \
}

#define VA_NVA16F_YIELD V_NVA16F_YIELD

#define P_NVA16F_YIELD(push, args...) do { \
    UNUSED uint32_t OP_NOP = NVA16F_YIELD_OP_NOP; \
    uint32_t nvk_p_ret; \
    V_NVA16F_YIELD(nvk_p_ret, args); \
    nv_push_val(push, NVA16F_YIELD, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVA16F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA16F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
