#line 534 "filter/decl.m4"


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmisleading-indentation"
#endif

#include "nest/bird.h"
#include "filter/filter.h"
#include "filter/f-inst.h"

/* Instruction codes to string */
static const char * const f_instruction_name_str[] = {
#line 288 "filter/f-inst.c"
 /* Code enum to string for FI_ADD */
#line 288
  [FI_ADD] = "FI_ADD",
#line 293 "filter/f-inst.c"
 /* Code enum to string for FI_SUBTRACT */
#line 293
  [FI_SUBTRACT] = "FI_SUBTRACT",
#line 298 "filter/f-inst.c"
 /* Code enum to string for FI_MULTIPLY */
#line 298
  [FI_MULTIPLY] = "FI_MULTIPLY",
#line 304 "filter/f-inst.c"
 /* Code enum to string for FI_DIVIDE */
#line 304
  [FI_DIVIDE] = "FI_DIVIDE",
#line 309 "filter/f-inst.c"
 /* Code enum to string for FI_BITOR */
#line 309
  [FI_BITOR] = "FI_BITOR",
#line 314 "filter/f-inst.c"
 /* Code enum to string for FI_BITAND */
#line 314
  [FI_BITAND] = "FI_BITAND",
#line 324 "filter/f-inst.c"
 /* Code enum to string for FI_AND */
#line 324
  [FI_AND] = "FI_AND",
#line 335 "filter/f-inst.c"
 /* Code enum to string for FI_OR */
#line 335
  [FI_OR] = "FI_OR",
#line 345 "filter/f-inst.c"
 /* Code enum to string for FI_PAIR_CONSTRUCT */
#line 345
  [FI_PAIR_CONSTRUCT] = "FI_PAIR_CONSTRUCT",
#line 385 "filter/f-inst.c"
 /* Code enum to string for FI_EC_CONSTRUCT */
#line 385
  [FI_EC_CONSTRUCT] = "FI_EC_CONSTRUCT",
#line 392 "filter/f-inst.c"
 /* Code enum to string for FI_LC_CONSTRUCT */
#line 392
  [FI_LC_CONSTRUCT] = "FI_LC_CONSTRUCT",
#line 442 "filter/f-inst.c"
 /* Code enum to string for FI_PATHMASK_CONSTRUCT */
#line 442
  [FI_PATHMASK_CONSTRUCT] = "FI_PATHMASK_CONSTRUCT",
#line 449 "filter/f-inst.c"
 /* Code enum to string for FI_NEQ */
#line 449
  [FI_NEQ] = "FI_NEQ",
#line 456 "filter/f-inst.c"
 /* Code enum to string for FI_EQ */
#line 456
  [FI_EQ] = "FI_EQ",
#line 467 "filter/f-inst.c"
 /* Code enum to string for FI_LT */
#line 467
  [FI_LT] = "FI_LT",
#line 478 "filter/f-inst.c"
 /* Code enum to string for FI_LTE */
#line 478
  [FI_LTE] = "FI_LTE",
#line 483 "filter/f-inst.c"
 /* Code enum to string for FI_NOT */
#line 483
  [FI_NOT] = "FI_NOT",
#line 492 "filter/f-inst.c"
 /* Code enum to string for FI_MATCH */
#line 492
  [FI_MATCH] = "FI_MATCH",
#line 501 "filter/f-inst.c"
 /* Code enum to string for FI_NOT_MATCH */
#line 501
  [FI_NOT_MATCH] = "FI_NOT_MATCH",
#line 506 "filter/f-inst.c"
 /* Code enum to string for FI_DEFINED */
#line 506
  [FI_DEFINED] = "FI_DEFINED",
#line 507 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__type */
#line 507
  [FI_METHOD__T_NET__type] = "FI_METHOD__T_NET__type",
#line 510 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_IP__is_v4 */
#line 510
  [FI_METHOD__T_IP__is_v4] = "FI_METHOD__T_IP__is_v4",
#line 523 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_INIT */
#line 523
  [FI_VAR_INIT] = "FI_VAR_INIT",
#line 534 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_INIT0 */
#line 534
  [FI_VAR_INIT0] = "FI_VAR_INIT0",
#line 543 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_SET */
#line 543
  [FI_VAR_SET] = "FI_VAR_SET",
#line 550 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_GET */
#line 550
  [FI_VAR_GET] = "FI_VAR_GET",
#line 563 "filter/f-inst.c"
 /* Code enum to string for FI_CONSTANT */
#line 563
  [FI_CONSTANT] = "FI_CONSTANT",
#line 564 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__empty */
#line 564
  [FI_METHOD__T_PATH__empty] = "FI_METHOD__T_PATH__empty",
#line 565 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__empty */
#line 565
  [FI_METHOD__T_CLIST__empty] = "FI_METHOD__T_CLIST__empty",
#line 566 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__empty */
#line 566
  [FI_METHOD__T_ECLIST__empty] = "FI_METHOD__T_ECLIST__empty",
#line 569 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__empty */
#line 569
  [FI_METHOD__T_LCLIST__empty] = "FI_METHOD__T_LCLIST__empty",
#line 591 "filter/f-inst.c"
 /* Code enum to string for FI_FOR_LOOP_START */
#line 591
  [FI_FOR_LOOP_START] = "FI_FOR_LOOP_START",
#line 600 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_FOR_NEXT */
#line 600
  [FI_PATH_FOR_NEXT] = "FI_PATH_FOR_NEXT",
#line 609 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FOR_NEXT */
#line 609
  [FI_CLIST_FOR_NEXT] = "FI_CLIST_FOR_NEXT",
#line 618 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FOR_NEXT */
#line 618
  [FI_ECLIST_FOR_NEXT] = "FI_ECLIST_FOR_NEXT",
#line 627 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FOR_NEXT */
#line 627
  [FI_LCLIST_FOR_NEXT] = "FI_LCLIST_FOR_NEXT",
#line 640 "filter/f-inst.c"
 /* Code enum to string for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  [FI_ROUTES_BLOCK_FOR_NEXT] = "FI_ROUTES_BLOCK_FOR_NEXT",
#line 648 "filter/f-inst.c"
 /* Code enum to string for FI_CONDITION */
#line 648
  [FI_CONDITION] = "FI_CONDITION",
#line 661 "filter/f-inst.c"
 /* Code enum to string for FI_PRINT */
#line 661
  [FI_PRINT] = "FI_PRINT",
#line 668 "filter/f-inst.c"
 /* Code enum to string for FI_FLUSH */
#line 668
  [FI_FLUSH] = "FI_FLUSH",
#line 682 "filter/f-inst.c"
 /* Code enum to string for FI_DIE */
#line 682
  [FI_DIE] = "FI_DIE",
#line 689 "filter/f-inst.c"
 /* Code enum to string for FI_CURRENT_ROUTE */
#line 689
  [FI_CURRENT_ROUTE] = "FI_CURRENT_ROUTE",
#line 740 "filter/f-inst.c"
 /* Code enum to string for FI_RTA_GET */
#line 740
  [FI_RTA_GET] = "FI_RTA_GET",
#line 897 "filter/f-inst.c"
 /* Code enum to string for FI_RTA_SET */
#line 897
  [FI_RTA_SET] = "FI_RTA_SET",
#line 934 "filter/f-inst.c"
 /* Code enum to string for FI_EA_GET */
#line 934
  [FI_EA_GET] = "FI_EA_GET",
#line 975 "filter/f-inst.c"
 /* Code enum to string for FI_EA_SET */
#line 975
  [FI_EA_SET] = "FI_EA_SET",
#line 982 "filter/f-inst.c"
 /* Code enum to string for FI_EA_UNSET */
#line 982
  [FI_EA_UNSET] = "FI_EA_UNSET",
#line 996 "filter/f-inst.c"
 /* Code enum to string for FI_DEFAULT */
#line 996
  [FI_DEFAULT] = "FI_DEFAULT",
#line 997 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__len */
#line 997
  [FI_METHOD__T_NET__len] = "FI_METHOD__T_NET__len",
#line 998 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__len */
#line 998
  [FI_METHOD__T_PATH__len] = "FI_METHOD__T_PATH__len",
#line 999 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__len */
#line 999
  [FI_METHOD__T_CLIST__len] = "FI_METHOD__T_CLIST__len",
#line 1000 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__len */
#line 1000
  [FI_METHOD__T_ECLIST__len] = "FI_METHOD__T_ECLIST__len",
#line 1002 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__len */
#line 1002
  [FI_METHOD__T_LCLIST__len] = "FI_METHOD__T_LCLIST__len",
#line 1038 "filter/f-inst.c"
 /* Code enum to string for FI_NET_SRC */
#line 1038
  [FI_NET_SRC] = "FI_NET_SRC",
#line 1075 "filter/f-inst.c"
 /* Code enum to string for FI_NET_DST */
#line 1075
  [FI_NET_DST] = "FI_NET_DST",
#line 1085 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__maxlen */
#line 1085
  [FI_METHOD__T_NET__maxlen] = "FI_METHOD__T_NET__maxlen",
#line 1095 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__asn */
#line 1095
  [FI_METHOD__T_NET__asn] = "FI_METHOD__T_NET__asn",
#line 1097 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__ip */
#line 1097
  [FI_METHOD__T_NET__ip] = "FI_METHOD__T_NET__ip",
#line 1106 "filter/f-inst.c"
 /* Code enum to string for FI_ROUTE_DISTINGUISHER */
#line 1106
  [FI_ROUTE_DISTINGUISHER] = "FI_ROUTE_DISTINGUISHER",
#line 1109 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__first */
#line 1109
  [FI_METHOD__T_PATH__first] = "FI_METHOD__T_PATH__first",
#line 1112 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__last */
#line 1112
  [FI_METHOD__T_PATH__last] = "FI_METHOD__T_PATH__last",
#line 1115 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
  [FI_METHOD__T_PATH__last_nonaggregated] = "FI_METHOD__T_PATH__last_nonaggregated",
#line 1118 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PAIR__asn */
#line 1118
  [FI_METHOD__T_PAIR__asn] = "FI_METHOD__T_PAIR__asn",
#line 1121 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PAIR__data */
#line 1121
  [FI_METHOD__T_PAIR__data] = "FI_METHOD__T_PAIR__data",
#line 1124 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__asn */
#line 1124
  [FI_METHOD__T_LC__asn] = "FI_METHOD__T_LC__asn",
#line 1127 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__data1 */
#line 1127
  [FI_METHOD__T_LC__data1] = "FI_METHOD__T_LC__data1",
#line 1130 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__data2 */
#line 1130
  [FI_METHOD__T_LC__data2] = "FI_METHOD__T_LC__data2",
#line 1133 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__min */
#line 1133
  [FI_METHOD__T_CLIST__min] = "FI_METHOD__T_CLIST__min",
#line 1136 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__max */
#line 1136
  [FI_METHOD__T_CLIST__max] = "FI_METHOD__T_CLIST__max",
#line 1139 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__min */
#line 1139
  [FI_METHOD__T_ECLIST__min] = "FI_METHOD__T_ECLIST__min",
#line 1142 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__max */
#line 1142
  [FI_METHOD__T_ECLIST__max] = "FI_METHOD__T_ECLIST__max",
#line 1145 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__min */
#line 1145
  [FI_METHOD__T_LCLIST__min] = "FI_METHOD__T_LCLIST__min",
#line 1147 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__max */
#line 1147
  [FI_METHOD__T_LCLIST__max] = "FI_METHOD__T_LCLIST__max",
#line 1173 "filter/f-inst.c"
 /* Code enum to string for FI_RETURN */
#line 1173
  [FI_RETURN] = "FI_RETURN",
#line 1233 "filter/f-inst.c"
 /* Code enum to string for FI_CALL */
#line 1233
  [FI_CALL] = "FI_CALL",
#line 1238 "filter/f-inst.c"
 /* Code enum to string for FI_DROP_RESULT */
#line 1238
  [FI_DROP_RESULT] = "FI_DROP_RESULT",
#line 1282 "filter/f-inst.c"
 /* Code enum to string for FI_SWITCH */
#line 1282
  [FI_SWITCH] = "FI_SWITCH",
#line 1291 "filter/f-inst.c"
 /* Code enum to string for FI_IP_MASK */
#line 1291
  [FI_IP_MASK] = "FI_IP_MASK",
#line 1299 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_PREPEND */
#line 1299
  [FI_PATH_PREPEND] = "FI_PATH_PREPEND",
#line 1307 "filter/f-inst.c"
 /* Code enum to string for FI_STRING_APPEND */
#line 1307
  [FI_STRING_APPEND] = "FI_STRING_APPEND",
#line 1315 "filter/f-inst.c"
 /* Code enum to string for FI_BYTESTRING_APPEND */
#line 1315
  [FI_BYTESTRING_APPEND] = "FI_BYTESTRING_APPEND",
#line 1322 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_PAIR */
#line 1322
  [FI_CLIST_ADD_PAIR] = "FI_CLIST_ADD_PAIR",
#line 1336 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_IP */
#line 1336
  [FI_CLIST_ADD_IP] = "FI_CLIST_ADD_IP",
#line 1343 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_QUAD */
#line 1343
  [FI_CLIST_ADD_QUAD] = "FI_CLIST_ADD_QUAD",
#line 1350 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_CLIST */
#line 1350
  [FI_CLIST_ADD_CLIST] = "FI_CLIST_ADD_CLIST",
#line 1357 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_ADD_EC */
#line 1357
  [FI_ECLIST_ADD_EC] = "FI_ECLIST_ADD_EC",
#line 1364 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_ADD_ECLIST */
#line 1364
  [FI_ECLIST_ADD_ECLIST] = "FI_ECLIST_ADD_ECLIST",
#line 1371 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_ADD_LC */
#line 1371
  [FI_LCLIST_ADD_LC] = "FI_LCLIST_ADD_LC",
#line 1378 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_ADD_LCLIST */
#line 1378
  [FI_LCLIST_ADD_LCLIST] = "FI_LCLIST_ADD_LCLIST",
#line 1385 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_DELETE_INT */
#line 1385
  [FI_PATH_DELETE_INT] = "FI_PATH_DELETE_INT",
#line 1397 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_DELETE_SET */
#line 1397
  [FI_PATH_DELETE_SET] = "FI_PATH_DELETE_SET",
#line 1404 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_PAIR */
#line 1404
  [FI_CLIST_DELETE_PAIR] = "FI_CLIST_DELETE_PAIR",
#line 1418 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_IP */
#line 1418
  [FI_CLIST_DELETE_IP] = "FI_CLIST_DELETE_IP",
#line 1425 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_QUAD */
#line 1425
  [FI_CLIST_DELETE_QUAD] = "FI_CLIST_DELETE_QUAD",
#line 1432 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_CLIST */
#line 1432
  [FI_CLIST_DELETE_CLIST] = "FI_CLIST_DELETE_CLIST",
#line 1443 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_SET */
#line 1443
  [FI_CLIST_DELETE_SET] = "FI_CLIST_DELETE_SET",
#line 1450 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_EC */
#line 1450
  [FI_ECLIST_DELETE_EC] = "FI_ECLIST_DELETE_EC",
#line 1457 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_ECLIST */
#line 1457
  [FI_ECLIST_DELETE_ECLIST] = "FI_ECLIST_DELETE_ECLIST",
#line 1468 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_SET */
#line 1468
  [FI_ECLIST_DELETE_SET] = "FI_ECLIST_DELETE_SET",
#line 1475 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_LC */
#line 1475
  [FI_LCLIST_DELETE_LC] = "FI_LCLIST_DELETE_LC",
#line 1482 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_LCLIST */
#line 1482
  [FI_LCLIST_DELETE_LCLIST] = "FI_LCLIST_DELETE_LCLIST",
#line 1493 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_SET */
#line 1493
  [FI_LCLIST_DELETE_SET] = "FI_LCLIST_DELETE_SET",
#line 1504 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_FILTER_SET */
#line 1504
  [FI_PATH_FILTER_SET] = "FI_PATH_FILTER_SET",
#line 1511 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FILTER_CLIST */
#line 1511
  [FI_CLIST_FILTER_CLIST] = "FI_CLIST_FILTER_CLIST",
#line 1522 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FILTER_SET */
#line 1522
  [FI_CLIST_FILTER_SET] = "FI_CLIST_FILTER_SET",
#line 1529 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FILTER_ECLIST */
#line 1529
  [FI_ECLIST_FILTER_ECLIST] = "FI_ECLIST_FILTER_ECLIST",
#line 1540 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FILTER_SET */
#line 1540
  [FI_ECLIST_FILTER_SET] = "FI_ECLIST_FILTER_SET",
#line 1547 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FILTER_LCLIST */
#line 1547
  [FI_LCLIST_FILTER_LCLIST] = "FI_LCLIST_FILTER_LCLIST",
#line 1558 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FILTER_SET */
#line 1558
  [FI_LCLIST_FILTER_SET] = "FI_LCLIST_FILTER_SET",
#line 1580 "filter/f-inst.c"
 /* Code enum to string for FI_ROA_CHECK */
#line 1580
  [FI_ROA_CHECK] = "FI_ROA_CHECK",
#line 1596 "filter/f-inst.c"
 /* Code enum to string for FI_ASPA_CHECK_EXPLICIT */
#line 1596
  [FI_ASPA_CHECK_EXPLICIT] = "FI_ASPA_CHECK_EXPLICIT",
#line 1611 "filter/f-inst.c"
 /* Code enum to string for FI_FROM_HEX */
#line 1611
  [FI_FROM_HEX] = "FI_FROM_HEX",
#line 1616 "filter/f-inst.c"
 /* Code enum to string for FI_FORMAT */
#line 1616
  [FI_FORMAT] = "FI_FORMAT",
#line 830 "filter/decl.m4"
 /* Code enum to string for FI_ASSERT */
#line 830
  [FI_ASSERT] = "FI_ASSERT",
#line 547 "filter/decl.m4"

};

const char *
f_instruction_name_(enum f_instruction_code fi)
{
  if (fi < (sizeof(f_instruction_name_str) / sizeof(f_instruction_name_str[0])))
    return f_instruction_name_str[fi];
  else
    bug("Got unknown instruction code: %d", fi);
}

static inline struct f_inst *
fi_new(enum f_instruction_code fi_code)
{
  struct f_inst *what = tmp_allocz(sizeof(struct f_inst));
  what->lineno = ifs->lino;
  what->size = 1;
  what->fi_code = fi_code;
  return what;
}

static inline struct f_inst *
fi_constant(struct f_inst *what, struct f_val val)
{
  what->fi_code = FI_CONSTANT;
  what->i_FI_CONSTANT.val = val;
  return what;
}

int
f_const_promotion_(struct f_inst *arg, btype want, int update)
{
  if (arg->fi_code != FI_CONSTANT)
    return 0;

  struct f_val *c = &arg->i_FI_CONSTANT.val;

  if ((c->type == T_IP) && ipa_is_ip4(c->val.ip) && (want == T_QUAD)) {
    if (update)
      *c = (struct f_val) {
        .type = T_QUAD,
        .val.i = ipa_to_u32(c->val.ip),
      };
    return 1;
  }

  else if ((c->type == T_SET) && (!c->val.t) && (want == T_PREFIX_SET)) {
    if (update)
      *c = f_const_empty_prefix_set;
    return 1;
  }

  return 0;
}

#define v1 whati->f1->i_FI_CONSTANT.val
#define v2 whati->f2->i_FI_CONSTANT.val
#define v3 whati->f3->i_FI_CONSTANT.val
#define vv(i) items[i]->i_FI_CONSTANT.val
#define runtime(fmt, ...) cf_error("filter preevaluation, line %d: " fmt, ifs->lino, ##__VA_ARGS__)
#define fpool cfg_mem
#define falloc(size) cfg_alloc(size)
/* Instruction constructors */
#line 288 "filter/f-inst.c"
 /* Constructor for FI_ADD */
#line 288
struct f_inst *
#line 284 "filter/f-inst.c"
NONNULL(2)
#line 285 "filter/f-inst.c"
NONNULL(3)
#line 288 "filter/f-inst.c"
f_new_inst_FI_ADD(enum f_instruction_code fi_code
#line 284 "filter/f-inst.c"
  , struct f_inst * f1
#line 285 "filter/f-inst.c"
  , struct f_inst * f2
#line 288 "filter/f-inst.c"
)
#line 288
  {
#line 288
    /* Allocate the structure */
#line 288
    struct f_inst *what = fi_new(fi_code);
#line 288
    uint constargs = 1;
#line 288

#line 288
    /* Initialize all the members */
#line 288
  #define whati (&(what->i_FI_ADD))
#line 288
  #line 284 "filter/f-inst.c"
whati->f1 = f1;
#line 284
const struct f_inst *child1 = f1;
#line 284
do {
#line 284
  what->size += child1->size;
#line 284

#line 284
  if (child1->fi_code != FI_CONSTANT)
#line 284
    constargs = 0;
#line 284

#line 284
} while (child1 = child1->next);
#line 284

#line 284 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 284
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 284
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 285 "filter/f-inst.c"
whati->f2 = f2;
#line 285
const struct f_inst *child2 = f2;
#line 285
do {
#line 285
  what->size += child2->size;
#line 285

#line 285
  if (child2->fi_code != FI_CONSTANT)
#line 285
    constargs = 0;
#line 285

#line 285
} while (child2 = child2->next);
#line 285 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 285
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 285
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 286 "filter/f-inst.c"
what->type = T_INT;

#line 288 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 288
    if (!constargs)
#line 288
      return what;
#line 288

#line 288
    /* Try to pre-calculate the result */
#line 288
    #line 283 "filter/f-inst.c"
 {
    
#line 284 "filter/f-inst.c"
 #line 284 "filter/f-inst.c"
 ;
#line 285 "filter/f-inst.c"
    
#line 285 "filter/f-inst.c"
 #line 285 "filter/f-inst.c"
 ;
#line 286 "filter/f-inst.c"
     
#line 286 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i + v2.val.i } );
  }
  
  #undef whati
#line 288 "filter/f-inst.c"
  }
#line 288

#line 288

#line 293 "filter/f-inst.c"
 /* Constructor for FI_SUBTRACT */
#line 293
struct f_inst *
#line 289 "filter/f-inst.c"
NONNULL(2)
#line 290 "filter/f-inst.c"
NONNULL(3)
#line 293 "filter/f-inst.c"
f_new_inst_FI_SUBTRACT(enum f_instruction_code fi_code
#line 289 "filter/f-inst.c"
  , struct f_inst * f1
#line 290 "filter/f-inst.c"
  , struct f_inst * f2
#line 293 "filter/f-inst.c"
)
#line 293
  {
#line 293
    /* Allocate the structure */
#line 293
    struct f_inst *what = fi_new(fi_code);
#line 293
    uint constargs = 1;
#line 293

#line 293
    /* Initialize all the members */
#line 293
  #define whati (&(what->i_FI_SUBTRACT))
#line 293
  #line 289 "filter/f-inst.c"
whati->f1 = f1;
#line 289
const struct f_inst *child1 = f1;
#line 289
do {
#line 289
  what->size += child1->size;
#line 289

#line 289
  if (child1->fi_code != FI_CONSTANT)
#line 289
    constargs = 0;
#line 289

#line 289
} while (child1 = child1->next);
#line 289

#line 289 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 289
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 289
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 290 "filter/f-inst.c"
whati->f2 = f2;
#line 290
const struct f_inst *child2 = f2;
#line 290
do {
#line 290
  what->size += child2->size;
#line 290

#line 290
  if (child2->fi_code != FI_CONSTANT)
#line 290
    constargs = 0;
#line 290

#line 290
} while (child2 = child2->next);
#line 290 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 290
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 290
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 291 "filter/f-inst.c"
what->type = T_INT;

#line 293 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 293
    if (!constargs)
#line 293
      return what;
#line 293

#line 293
    /* Try to pre-calculate the result */
#line 293
    #line 288 "filter/f-inst.c"
 {
    
#line 289 "filter/f-inst.c"
 #line 289 "filter/f-inst.c"
 ;
#line 290 "filter/f-inst.c"
    
#line 290 "filter/f-inst.c"
 #line 290 "filter/f-inst.c"
 ;
#line 291 "filter/f-inst.c"
     
#line 291 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i - v2.val.i } );
  }
  
  #undef whati
#line 293 "filter/f-inst.c"
  }
#line 293

#line 293

#line 298 "filter/f-inst.c"
 /* Constructor for FI_MULTIPLY */
#line 298
struct f_inst *
#line 294 "filter/f-inst.c"
NONNULL(2)
#line 295 "filter/f-inst.c"
NONNULL(3)
#line 298 "filter/f-inst.c"
f_new_inst_FI_MULTIPLY(enum f_instruction_code fi_code
#line 294 "filter/f-inst.c"
  , struct f_inst * f1
#line 295 "filter/f-inst.c"
  , struct f_inst * f2
#line 298 "filter/f-inst.c"
)
#line 298
  {
#line 298
    /* Allocate the structure */
#line 298
    struct f_inst *what = fi_new(fi_code);
#line 298
    uint constargs = 1;
#line 298

#line 298
    /* Initialize all the members */
#line 298
  #define whati (&(what->i_FI_MULTIPLY))
#line 298
  #line 294 "filter/f-inst.c"
whati->f1 = f1;
#line 294
const struct f_inst *child1 = f1;
#line 294
do {
#line 294
  what->size += child1->size;
#line 294

#line 294
  if (child1->fi_code != FI_CONSTANT)
#line 294
    constargs = 0;
#line 294

#line 294
} while (child1 = child1->next);
#line 294

#line 294 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 294
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 294
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 295 "filter/f-inst.c"
whati->f2 = f2;
#line 295
const struct f_inst *child2 = f2;
#line 295
do {
#line 295
  what->size += child2->size;
#line 295

#line 295
  if (child2->fi_code != FI_CONSTANT)
#line 295
    constargs = 0;
#line 295

#line 295
} while (child2 = child2->next);
#line 295 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 295
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 295
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 296 "filter/f-inst.c"
what->type = T_INT;

#line 298 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 298
    if (!constargs)
#line 298
      return what;
#line 298

#line 298
    /* Try to pre-calculate the result */
#line 298
    #line 293 "filter/f-inst.c"
 {
    
#line 294 "filter/f-inst.c"
 #line 294 "filter/f-inst.c"
 ;
#line 295 "filter/f-inst.c"
    
#line 295 "filter/f-inst.c"
 #line 295 "filter/f-inst.c"
 ;
#line 296 "filter/f-inst.c"
     
#line 296 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i * v2.val.i } );
  }
  
  #undef whati
#line 298 "filter/f-inst.c"
  }
#line 298

#line 298

#line 304 "filter/f-inst.c"
 /* Constructor for FI_DIVIDE */
#line 304
struct f_inst *
#line 299 "filter/f-inst.c"
NONNULL(2)
#line 300 "filter/f-inst.c"
NONNULL(3)
#line 304 "filter/f-inst.c"
f_new_inst_FI_DIVIDE(enum f_instruction_code fi_code
#line 299 "filter/f-inst.c"
  , struct f_inst * f1
#line 300 "filter/f-inst.c"
  , struct f_inst * f2
#line 304 "filter/f-inst.c"
)
#line 304
  {
#line 304
    /* Allocate the structure */
#line 304
    struct f_inst *what = fi_new(fi_code);
#line 304
    uint constargs = 1;
#line 304

#line 304
    /* Initialize all the members */
#line 304
  #define whati (&(what->i_FI_DIVIDE))
#line 304
  #line 299 "filter/f-inst.c"
whati->f1 = f1;
#line 299
const struct f_inst *child1 = f1;
#line 299
do {
#line 299
  what->size += child1->size;
#line 299

#line 299
  if (child1->fi_code != FI_CONSTANT)
#line 299
    constargs = 0;
#line 299

#line 299
} while (child1 = child1->next);
#line 299

#line 299 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 299
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 299
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 300 "filter/f-inst.c"
whati->f2 = f2;
#line 300
const struct f_inst *child2 = f2;
#line 300
do {
#line 300
  what->size += child2->size;
#line 300

#line 300
  if (child2->fi_code != FI_CONSTANT)
#line 300
    constargs = 0;
#line 300

#line 300
} while (child2 = child2->next);
#line 300 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 300
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 300
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 302 "filter/f-inst.c"
what->type = T_INT;

#line 304 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 304
    if (!constargs)
#line 304
      return what;
#line 304

#line 304
    /* Try to pre-calculate the result */
#line 304
    #line 298 "filter/f-inst.c"
 {
    
#line 299 "filter/f-inst.c"
 #line 299 "filter/f-inst.c"
 ;
#line 300 "filter/f-inst.c"
    
#line 300 "filter/f-inst.c"
 #line 300 "filter/f-inst.c"
 ;
#line 301 "filter/f-inst.c"
    if (v2.val.i == 0) runtime( "Mother told me not to divide by 0" );
     
#line 302 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i / v2.val.i } );
  }
  
  #undef whati
#line 304 "filter/f-inst.c"
  }
#line 304

#line 304

#line 309 "filter/f-inst.c"
 /* Constructor for FI_BITOR */
#line 309
struct f_inst *
#line 305 "filter/f-inst.c"
NONNULL(2)
#line 306 "filter/f-inst.c"
NONNULL(3)
#line 309 "filter/f-inst.c"
f_new_inst_FI_BITOR(enum f_instruction_code fi_code
#line 305 "filter/f-inst.c"
  , struct f_inst * f1
#line 306 "filter/f-inst.c"
  , struct f_inst * f2
#line 309 "filter/f-inst.c"
)
#line 309
  {
#line 309
    /* Allocate the structure */
#line 309
    struct f_inst *what = fi_new(fi_code);
#line 309
    uint constargs = 1;
#line 309

#line 309
    /* Initialize all the members */
#line 309
  #define whati (&(what->i_FI_BITOR))
#line 309
  #line 305 "filter/f-inst.c"
whati->f1 = f1;
#line 305
const struct f_inst *child1 = f1;
#line 305
do {
#line 305
  what->size += child1->size;
#line 305

#line 305
  if (child1->fi_code != FI_CONSTANT)
#line 305
    constargs = 0;
#line 305

#line 305
} while (child1 = child1->next);
#line 305

#line 305 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 305
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 305
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 306 "filter/f-inst.c"
whati->f2 = f2;
#line 306
const struct f_inst *child2 = f2;
#line 306
do {
#line 306
  what->size += child2->size;
#line 306

#line 306
  if (child2->fi_code != FI_CONSTANT)
#line 306
    constargs = 0;
#line 306

#line 306
} while (child2 = child2->next);
#line 306 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 306
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 306
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 307 "filter/f-inst.c"
what->type = T_INT;

#line 309 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 309
    if (!constargs)
#line 309
      return what;
#line 309

#line 309
    /* Try to pre-calculate the result */
#line 309
    #line 304 "filter/f-inst.c"
 {
    
#line 305 "filter/f-inst.c"
 #line 305 "filter/f-inst.c"
 ;
#line 306 "filter/f-inst.c"
    
#line 306 "filter/f-inst.c"
 #line 306 "filter/f-inst.c"
 ;
#line 307 "filter/f-inst.c"
     
#line 307 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i | v2.val.i } );
  }
  
  #undef whati
#line 309 "filter/f-inst.c"
  }
#line 309

#line 309

#line 314 "filter/f-inst.c"
 /* Constructor for FI_BITAND */
#line 314
struct f_inst *
#line 310 "filter/f-inst.c"
NONNULL(2)
#line 311 "filter/f-inst.c"
NONNULL(3)
#line 314 "filter/f-inst.c"
f_new_inst_FI_BITAND(enum f_instruction_code fi_code
#line 310 "filter/f-inst.c"
  , struct f_inst * f1
#line 311 "filter/f-inst.c"
  , struct f_inst * f2
#line 314 "filter/f-inst.c"
)
#line 314
  {
#line 314
    /* Allocate the structure */
#line 314
    struct f_inst *what = fi_new(fi_code);
#line 314
    uint constargs = 1;
#line 314

#line 314
    /* Initialize all the members */
#line 314
  #define whati (&(what->i_FI_BITAND))
#line 314
  #line 310 "filter/f-inst.c"
whati->f1 = f1;
#line 310
const struct f_inst *child1 = f1;
#line 310
do {
#line 310
  what->size += child1->size;
#line 310

#line 310
  if (child1->fi_code != FI_CONSTANT)
#line 310
    constargs = 0;
#line 310

#line 310
} while (child1 = child1->next);
#line 310

#line 310 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 310
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 310
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 311 "filter/f-inst.c"
whati->f2 = f2;
#line 311
const struct f_inst *child2 = f2;
#line 311
do {
#line 311
  what->size += child2->size;
#line 311

#line 311
  if (child2->fi_code != FI_CONSTANT)
#line 311
    constargs = 0;
#line 311

#line 311
} while (child2 = child2->next);
#line 311 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 311
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 311
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 312 "filter/f-inst.c"
what->type = T_INT;

#line 314 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 314
    if (!constargs)
#line 314
      return what;
#line 314

#line 314
    /* Try to pre-calculate the result */
#line 314
    #line 309 "filter/f-inst.c"
 {
    
#line 310 "filter/f-inst.c"
 #line 310 "filter/f-inst.c"
 ;
#line 311 "filter/f-inst.c"
    
#line 311 "filter/f-inst.c"
 #line 311 "filter/f-inst.c"
 ;
#line 312 "filter/f-inst.c"
     
#line 312 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i & v2.val.i } );
  }
  
  #undef whati
#line 314 "filter/f-inst.c"
  }
#line 314

#line 314

#line 324 "filter/f-inst.c"
 /* Constructor for FI_AND */
#line 324
struct f_inst *
#line 315 "filter/f-inst.c"
NONNULL(2)
#line 324 "filter/f-inst.c"
f_new_inst_FI_AND(enum f_instruction_code fi_code
#line 315 "filter/f-inst.c"
  , struct f_inst * f1
#line 320 "filter/f-inst.c"
  , struct f_inst * f2
#line 324 "filter/f-inst.c"
)
#line 324
  {
#line 324
    /* Allocate the structure */
#line 324
    struct f_inst *what = fi_new(fi_code);
#line 324
    uint constargs = 1;
#line 324

#line 324
    /* Initialize all the members */
#line 324
  #define whati (&(what->i_FI_AND))
#line 324
  #line 315 "filter/f-inst.c"
whati->f1 = f1;
#line 315
const struct f_inst *child1 = f1;
#line 315
do {
#line 315
  what->size += child1->size;
#line 315

#line 315
  if (child1->fi_code != FI_CONSTANT)
#line 315
    constargs = 0;
#line 315

#line 315
} while (child1 = child1->next);
#line 315

#line 315 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 315
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 315
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 316 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 316
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 316
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 317 "filter/f-inst.c"
what->type = T_BOOL;
#line 320 "filter/f-inst.c"
whati->f2 = f2;

#line 324 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 324
    if (!constargs)
#line 324
      return what;
#line 324

#line 324
    /* Try to pre-calculate the result */
#line 324
    #line 314 "filter/f-inst.c"
 {
    
#line 315 "filter/f-inst.c"
 #line 315 "filter/f-inst.c"
 ;
#line 316 "filter/f-inst.c"
    #line 316 "filter/f-inst.c"
;
     
#line 317 "filter/f-inst.c"
;

    if (v1.val.i)
      
#line 320 "filter/f-inst.c"
return whati->f2
#line 320
;
    else
      return fi_constant(what, v1);
  }
  
  #undef whati
#line 324 "filter/f-inst.c"
  }
#line 324

#line 324

#line 335 "filter/f-inst.c"
 /* Constructor for FI_OR */
#line 335
struct f_inst *
#line 325 "filter/f-inst.c"
NONNULL(2)
#line 335 "filter/f-inst.c"
f_new_inst_FI_OR(enum f_instruction_code fi_code
#line 325 "filter/f-inst.c"
  , struct f_inst * f1
#line 330 "filter/f-inst.c"
  , struct f_inst * f2
#line 335 "filter/f-inst.c"
)
#line 335
  {
#line 335
    /* Allocate the structure */
#line 335
    struct f_inst *what = fi_new(fi_code);
#line 335
    uint constargs = 1;
#line 335

#line 335
    /* Initialize all the members */
#line 335
  #define whati (&(what->i_FI_OR))
#line 335
  #line 325 "filter/f-inst.c"
whati->f1 = f1;
#line 325
const struct f_inst *child1 = f1;
#line 325
do {
#line 325
  what->size += child1->size;
#line 325

#line 325
  if (child1->fi_code != FI_CONSTANT)
#line 325
    constargs = 0;
#line 325

#line 325
} while (child1 = child1->next);
#line 325

#line 325 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 325
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 325
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 326 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 326
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 326
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 327 "filter/f-inst.c"
what->type = T_BOOL;
#line 330 "filter/f-inst.c"
whati->f2 = f2;

#line 335 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 335
    if (!constargs)
#line 335
      return what;
#line 335

#line 335
    /* Try to pre-calculate the result */
#line 335
    #line 324 "filter/f-inst.c"
 {
    
#line 325 "filter/f-inst.c"
 #line 325 "filter/f-inst.c"
 ;
#line 326 "filter/f-inst.c"
    #line 326 "filter/f-inst.c"
;
     
#line 327 "filter/f-inst.c"
;

    if (!v1.val.i)
      
#line 330 "filter/f-inst.c"
return whati->f2
#line 330
;
    else
      return fi_constant(what, v1);
  }

  
  #undef whati
#line 335 "filter/f-inst.c"
  }
#line 335

#line 335

#line 345 "filter/f-inst.c"
 /* Constructor for FI_PAIR_CONSTRUCT */
#line 345
struct f_inst *
#line 336 "filter/f-inst.c"
NONNULL(2)
#line 337 "filter/f-inst.c"
NONNULL(3)
#line 345 "filter/f-inst.c"
f_new_inst_FI_PAIR_CONSTRUCT(enum f_instruction_code fi_code
#line 336 "filter/f-inst.c"
  , struct f_inst * f1
#line 337 "filter/f-inst.c"
  , struct f_inst * f2
#line 345 "filter/f-inst.c"
)
#line 345
  {
#line 345
    /* Allocate the structure */
#line 345
    struct f_inst *what = fi_new(fi_code);
#line 345
    uint constargs = 1;
#line 345

#line 345
    /* Initialize all the members */
#line 345
  #define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
  #line 336 "filter/f-inst.c"
whati->f1 = f1;
#line 336
const struct f_inst *child1 = f1;
#line 336
do {
#line 336
  what->size += child1->size;
#line 336

#line 336
  if (child1->fi_code != FI_CONSTANT)
#line 336
    constargs = 0;
#line 336

#line 336
} while (child1 = child1->next);
#line 336

#line 336 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 336
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 336
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 337 "filter/f-inst.c"
whati->f2 = f2;
#line 337
const struct f_inst *child2 = f2;
#line 337
do {
#line 337
  what->size += child2->size;
#line 337

#line 337
  if (child2->fi_code != FI_CONSTANT)
#line 337
    constargs = 0;
#line 337

#line 337
} while (child2 = child2->next);
#line 337 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 337
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 337
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 342 "filter/f-inst.c"
what->type = T_PAIR;

#line 345 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 345
    if (!constargs)
#line 345
      return what;
#line 345

#line 345
    /* Try to pre-calculate the result */
#line 345
    #line 335 "filter/f-inst.c"
 {
    
#line 336 "filter/f-inst.c"
 #line 336 "filter/f-inst.c"
 ;
#line 337 "filter/f-inst.c"
    
#line 337 "filter/f-inst.c"
 #line 337 "filter/f-inst.c"
 ;
#line 338 "filter/f-inst.c"
    uint u1 = v1.val.i;
    uint u2 = v2.val.i;
    if ((u1 > 0xFFFF) || (u2 > 0xFFFF))
      runtime( "Can't operate with value out of bounds in pair constructor" );
     
#line 342 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = (u1 << 16) | u2 } );
  }

  
  #undef whati
#line 345 "filter/f-inst.c"
  }
#line 345

#line 345

#line 385 "filter/f-inst.c"
 /* Constructor for FI_EC_CONSTRUCT */
#line 385
struct f_inst *
#line 346 "filter/f-inst.c"
NONNULL(2)
#line 347 "filter/f-inst.c"
NONNULL(3)
#line 385 "filter/f-inst.c"
f_new_inst_FI_EC_CONSTRUCT(enum f_instruction_code fi_code
#line 346 "filter/f-inst.c"
  , struct f_inst * f1
#line 347 "filter/f-inst.c"
  , struct f_inst * f2
#line 349 "filter/f-inst.c"
  , enum ec_subtype ecs
#line 385 "filter/f-inst.c"
)
#line 385
  {
#line 385
    /* Allocate the structure */
#line 385
    struct f_inst *what = fi_new(fi_code);
#line 385
    uint constargs = 1;
#line 385

#line 385
    /* Initialize all the members */
#line 385
  #define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
  #line 346 "filter/f-inst.c"
whati->f1 = f1;
#line 346
const struct f_inst *child1 = f1;
#line 346
do {
#line 346
  what->size += child1->size;
#line 346

#line 346
  if (child1->fi_code != FI_CONSTANT)
#line 346
    constargs = 0;
#line 346

#line 346
} while (child1 = child1->next);
#line 346

#line 347 "filter/f-inst.c"
whati->f2 = f2;
#line 347
const struct f_inst *child2 = f2;
#line 347
do {
#line 347
  what->size += child2->size;
#line 347

#line 347
  if (child2->fi_code != FI_CONSTANT)
#line 347
    constargs = 0;
#line 347

#line 347
} while (child2 = child2->next);
#line 347 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 347
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 347
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 349 "filter/f-inst.c"
whati->ecs = ecs;
#line 370 "filter/f-inst.c"
what->type = T_EC;

#line 385 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 385
    if (!constargs)
#line 385
      return what;
#line 385

#line 385
    /* Try to pre-calculate the result */
#line 385
    #line 345 "filter/f-inst.c"
 {
    
#line 346 "filter/f-inst.c"
;
    
#line 347 "filter/f-inst.c"
 #line 347 "filter/f-inst.c"
 ;
#line 348 "filter/f-inst.c"

    #line 349 "filter/f-inst.c"
;

    int ipv4_used;
    u32 key, val;

    if (v1.type == T_INT) {
      ipv4_used = 0; key = v1.val.i;
    }
    else if (v1.type == T_QUAD) {
      ipv4_used = 1; key = v1.val.i;
    }
    /* IP->Quad implicit conversion */
    else if (val_is_ip4(&v1)) {
      ipv4_used = 1; key = ipa_to_u32(v1.val.ip);
    }
    else
      runtime("Argument 1 of EC constructor must be integer or IPv4 address, got 0x%02x", v1.type);

    val = v2.val.i;

    if (ecs == EC_GENERIC)
       
#line 370 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_generic(key, val) } );
    else if (ipv4_used)
      if (val <= 0xFFFF)
	 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_ip4(ecs, key, val) } );
      else
	runtime("4-byte value %u can't be used with IP-address key in extended community", val);
    else if (key < 0x10000)
       return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_as2(ecs, key, val) } );
    else
      if (val <= 0xFFFF)
	 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_as4(ecs, key, val) } );
      else
	runtime("4-byte value %u can't be used with 4-byte ASN in extended community", val);
  }

  
  #undef whati
#line 385 "filter/f-inst.c"
  }
#line 385

#line 385

#line 392 "filter/f-inst.c"
 /* Constructor for FI_LC_CONSTRUCT */
#line 392
struct f_inst *
#line 386 "filter/f-inst.c"
NONNULL(2)
#line 387 "filter/f-inst.c"
NONNULL(3)
#line 388 "filter/f-inst.c"
NONNULL(4)
#line 392 "filter/f-inst.c"
f_new_inst_FI_LC_CONSTRUCT(enum f_instruction_code fi_code
#line 386 "filter/f-inst.c"
  , struct f_inst * f1
#line 387 "filter/f-inst.c"
  , struct f_inst * f2
#line 388 "filter/f-inst.c"
  , struct f_inst * f3
#line 392 "filter/f-inst.c"
)
#line 392
  {
#line 392
    /* Allocate the structure */
#line 392
    struct f_inst *what = fi_new(fi_code);
#line 392
    uint constargs = 1;
#line 392

#line 392
    /* Initialize all the members */
#line 392
  #define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
  #line 386 "filter/f-inst.c"
whati->f1 = f1;
#line 386
const struct f_inst *child1 = f1;
#line 386
do {
#line 386
  what->size += child1->size;
#line 386

#line 386
  if (child1->fi_code != FI_CONSTANT)
#line 386
    constargs = 0;
#line 386

#line 386
} while (child1 = child1->next);
#line 386

#line 386 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 386
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 386
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 387 "filter/f-inst.c"
whati->f2 = f2;
#line 387
const struct f_inst *child2 = f2;
#line 387
do {
#line 387
  what->size += child2->size;
#line 387

#line 387
  if (child2->fi_code != FI_CONSTANT)
#line 387
    constargs = 0;
#line 387

#line 387
} while (child2 = child2->next);
#line 387 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 387
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 387
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 388 "filter/f-inst.c"
whati->f3 = f3;
#line 388
const struct f_inst *child3 = f3;
#line 388
do {
#line 388
  what->size += child3->size;
#line 388

#line 388
  if (child3->fi_code != FI_CONSTANT)
#line 388
    constargs = 0;
#line 388

#line 388
} while (child3 = child3->next);
#line 388 "filter/f-inst.c"
if (f3->type && (f3->type != (T_INT)) && !f_const_promotion(f3, (T_INT)))
#line 388
  cf_error("Argument 3 of %s must be of type %s, got type %s",
#line 388
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f3->type));
#line 389 "filter/f-inst.c"
what->type = T_LC;

#line 392 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 392
    if (!constargs)
#line 392
      return what;
#line 392

#line 392
    /* Try to pre-calculate the result */
#line 392
    #line 385 "filter/f-inst.c"
 {
    
#line 386 "filter/f-inst.c"
 #line 386 "filter/f-inst.c"
 ;
#line 387 "filter/f-inst.c"
    
#line 387 "filter/f-inst.c"
 #line 387 "filter/f-inst.c"
 ;
#line 388 "filter/f-inst.c"
    
#line 388 "filter/f-inst.c"
 #line 388 "filter/f-inst.c"
 ;
#line 389 "filter/f-inst.c"
     
#line 389 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = (lcomm) { v1.val.i, v2.val.i, v3.val.i } } );
  }

  
  #undef whati
#line 392 "filter/f-inst.c"
  }
#line 392

#line 392

#line 442 "filter/f-inst.c"
 /* Constructor for FI_PATHMASK_CONSTRUCT */
#line 442
struct f_inst *
#line 442
f_new_inst_FI_PATHMASK_CONSTRUCT(enum f_instruction_code fi_code
#line 393 "filter/f-inst.c"
  , struct f_inst * fvar
#line 442 "filter/f-inst.c"
)
#line 442
  {
#line 442
    /* Allocate the structure */
#line 442
    struct f_inst *what = fi_new(fi_code);
#line 442
    uint constargs = 1;
#line 442

#line 442
    /* Initialize all the members */
#line 442
  #define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
  #line 393 "filter/f-inst.c"
whati->varcount = 0;
#line 393
whati->fvar = fvar;
#line 393
for (const struct f_inst *child = fvar; child; child = child->next, whati->varcount++) {
#line 393
  what->size += child->size;
#line 393

#line 393
  if (child->fi_code != FI_CONSTANT)
#line 393
    constargs = 0;
#line 393

#line 393
}
#line 393

#line 393
  const struct f_inst **items = NULL;
#line 393
  if (constargs && whati->varcount) {
#line 393
    items = alloca(whati->varcount * sizeof(struct f_inst *));
#line 393
    const struct f_inst *child = fvar;
#line 393
    for (uint i=0; child; i++)
#line 393
      child = (items[i] = child)->next;
#line 393
  }
#line 393

#line 437 "filter/f-inst.c"
what->type = T_PATH_MASK;

#line 442 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 442
    if (!constargs)
#line 442
      return what;
#line 442

#line 442
    /* Try to pre-calculate the result */
#line 442
    #line 392 "filter/f-inst.c"
 {
    
#line 393 "filter/f-inst.c"

#line 393

#line 393
;

    struct f_path_mask *pm = falloc(sizeof(struct f_path_mask) + whati->varcount * sizeof(struct f_path_mask_item));
    pm->len = whati->varcount;

    for (uint i=0; i<whati->varcount; i++) {
      switch (vv(i).type) {
	case T_PATH_MASK_ITEM:
	  if (vv(i).val.pmi.kind == PM_LOOP)
	  {
	    if (i == 0)
	      runtime("Path mask iterator '+' cannot be first");

	    /* We want PM_LOOP as prefix operator */
	    pm->item[i] = pm->item[i - 1];
	    pm->item[i - 1] = vv(i).val.pmi;
	    break;
	  }

	  pm->item[i] = vv(i).val.pmi;
	  break;

	case T_INT:
	  pm->item[i] = (struct f_path_mask_item) {
	    .asn = vv(i).val.i,
	    .kind = PM_ASN,
	  };
	  break;

	case T_SET:
	  if (!path_set_type(vv(i).val.t))
	    runtime("Only integer sets allowed in path mask");

	  pm->item[i] = (struct f_path_mask_item) {
	    .set = vv(i).val.t,
	    .kind = PM_ASN_SET,
	  };
	  break;

	default:
	  runtime( "Error resolving path mask template: value not an integer" );
      }
    }

     
#line 437 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH_MASK, .val.path_mask = pm } );
  }

/* Relational operators */

  
  #undef whati
#line 442 "filter/f-inst.c"
  }
#line 442

#line 442

#line 449 "filter/f-inst.c"
 /* Constructor for FI_NEQ */
#line 449
struct f_inst *
#line 443 "filter/f-inst.c"
NONNULL(2)
#line 444 "filter/f-inst.c"
NONNULL(3)
#line 449 "filter/f-inst.c"
f_new_inst_FI_NEQ(enum f_instruction_code fi_code
#line 443 "filter/f-inst.c"
  , struct f_inst * f1
#line 444 "filter/f-inst.c"
  , struct f_inst * f2
#line 449 "filter/f-inst.c"
)
#line 449
  {
#line 449
    /* Allocate the structure */
#line 449
    struct f_inst *what = fi_new(fi_code);
#line 449
    uint constargs = 1;
#line 449

#line 449
    /* Initialize all the members */
#line 449
  #define whati (&(what->i_FI_NEQ))
#line 449
  #line 443 "filter/f-inst.c"
whati->f1 = f1;
#line 443
const struct f_inst *child1 = f1;
#line 443
do {
#line 443
  what->size += child1->size;
#line 443

#line 443
  if (child1->fi_code != FI_CONSTANT)
#line 443
    constargs = 0;
#line 443

#line 443
} while (child1 = child1->next);
#line 443

#line 444 "filter/f-inst.c"
whati->f2 = f2;
#line 444
const struct f_inst *child2 = f2;
#line 444
do {
#line 444
  what->size += child2->size;
#line 444

#line 444
  if (child2->fi_code != FI_CONSTANT)
#line 444
    constargs = 0;
#line 444

#line 444
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type))
#line 445 "filter/f-inst.c"
   (void) (f_const_promotion(f2, f1->type) || f_const_promotion(f1, f2->type));
#line 446 "filter/f-inst.c"
what->type = T_BOOL;

#line 449 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 449
    if (!constargs)
#line 449
      return what;
#line 449

#line 449
    /* Try to pre-calculate the result */
#line 449
    #line 442 "filter/f-inst.c"
 {
    
#line 443 "filter/f-inst.c"
;
    
#line 444 "filter/f-inst.c"
;
    #line 445 "filter/f-inst.c"
;
     
#line 446 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !val_same(&v1, &v2) } );
  }

  
  #undef whati
#line 449 "filter/f-inst.c"
  }
#line 449

#line 449

#line 456 "filter/f-inst.c"
 /* Constructor for FI_EQ */
#line 456
struct f_inst *
#line 450 "filter/f-inst.c"
NONNULL(2)
#line 451 "filter/f-inst.c"
NONNULL(3)
#line 456 "filter/f-inst.c"
f_new_inst_FI_EQ(enum f_instruction_code fi_code
#line 450 "filter/f-inst.c"
  , struct f_inst * f1
#line 451 "filter/f-inst.c"
  , struct f_inst * f2
#line 456 "filter/f-inst.c"
)
#line 456
  {
#line 456
    /* Allocate the structure */
#line 456
    struct f_inst *what = fi_new(fi_code);
#line 456
    uint constargs = 1;
#line 456

#line 456
    /* Initialize all the members */
#line 456
  #define whati (&(what->i_FI_EQ))
#line 456
  #line 450 "filter/f-inst.c"
whati->f1 = f1;
#line 450
const struct f_inst *child1 = f1;
#line 450
do {
#line 450
  what->size += child1->size;
#line 450

#line 450
  if (child1->fi_code != FI_CONSTANT)
#line 450
    constargs = 0;
#line 450

#line 450
} while (child1 = child1->next);
#line 450

#line 451 "filter/f-inst.c"
whati->f2 = f2;
#line 451
const struct f_inst *child2 = f2;
#line 451
do {
#line 451
  what->size += child2->size;
#line 451

#line 451
  if (child2->fi_code != FI_CONSTANT)
#line 451
    constargs = 0;
#line 451

#line 451
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type))
#line 452 "filter/f-inst.c"
   (void) (f_const_promotion(f2, f1->type) || f_const_promotion(f1, f2->type));
#line 453 "filter/f-inst.c"
what->type = T_BOOL;

#line 456 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 456
    if (!constargs)
#line 456
      return what;
#line 456

#line 456
    /* Try to pre-calculate the result */
#line 456
    #line 449 "filter/f-inst.c"
 {
    
#line 450 "filter/f-inst.c"
;
    
#line 451 "filter/f-inst.c"
;
    #line 452 "filter/f-inst.c"
;
     
#line 453 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = val_same(&v1, &v2) } );
  }

  
  #undef whati
#line 456 "filter/f-inst.c"
  }
#line 456

#line 456

#line 467 "filter/f-inst.c"
 /* Constructor for FI_LT */
#line 467
struct f_inst *
#line 457 "filter/f-inst.c"
NONNULL(2)
#line 458 "filter/f-inst.c"
NONNULL(3)
#line 467 "filter/f-inst.c"
f_new_inst_FI_LT(enum f_instruction_code fi_code
#line 457 "filter/f-inst.c"
  , struct f_inst * f1
#line 458 "filter/f-inst.c"
  , struct f_inst * f2
#line 467 "filter/f-inst.c"
)
#line 467
  {
#line 467
    /* Allocate the structure */
#line 467
    struct f_inst *what = fi_new(fi_code);
#line 467
    uint constargs = 1;
#line 467

#line 467
    /* Initialize all the members */
#line 467
  #define whati (&(what->i_FI_LT))
#line 467
  #line 457 "filter/f-inst.c"
whati->f1 = f1;
#line 457
const struct f_inst *child1 = f1;
#line 457
do {
#line 457
  what->size += child1->size;
#line 457

#line 457
  if (child1->fi_code != FI_CONSTANT)
#line 457
    constargs = 0;
#line 457

#line 457
} while (child1 = child1->next);
#line 457

#line 458 "filter/f-inst.c"
whati->f2 = f2;
#line 458
const struct f_inst *child2 = f2;
#line 458
do {
#line 458
  what->size += child2->size;
#line 458

#line 458
  if (child2->fi_code != FI_CONSTANT)
#line 458
    constargs = 0;
#line 458

#line 458
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type) &&
#line 459 "filter/f-inst.c"
   !f_const_promotion(f2, f1->type) && !f_const_promotion(f1, f2->type))
#line 459
  cf_error("Arguments 1 and 2 of %s must be of the same type", f_instruction_name(what->fi_code));
#line 464 "filter/f-inst.c"
what->type = T_BOOL;

#line 467 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 467
    if (!constargs)
#line 467
      return what;
#line 467

#line 467
    /* Try to pre-calculate the result */
#line 467
    #line 456 "filter/f-inst.c"
 {
    
#line 457 "filter/f-inst.c"
;
    
#line 458 "filter/f-inst.c"
;
    #line 459 "filter/f-inst.c"
;

    int i = val_compare(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "Can't compare values of incompatible types" );
     
#line 464 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (i == -1) } );
  }

  
  #undef whati
#line 467 "filter/f-inst.c"
  }
#line 467

#line 467

#line 478 "filter/f-inst.c"
 /* Constructor for FI_LTE */
#line 478
struct f_inst *
#line 468 "filter/f-inst.c"
NONNULL(2)
#line 469 "filter/f-inst.c"
NONNULL(3)
#line 478 "filter/f-inst.c"
f_new_inst_FI_LTE(enum f_instruction_code fi_code
#line 468 "filter/f-inst.c"
  , struct f_inst * f1
#line 469 "filter/f-inst.c"
  , struct f_inst * f2
#line 478 "filter/f-inst.c"
)
#line 478
  {
#line 478
    /* Allocate the structure */
#line 478
    struct f_inst *what = fi_new(fi_code);
#line 478
    uint constargs = 1;
#line 478

#line 478
    /* Initialize all the members */
#line 478
  #define whati (&(what->i_FI_LTE))
#line 478
  #line 468 "filter/f-inst.c"
whati->f1 = f1;
#line 468
const struct f_inst *child1 = f1;
#line 468
do {
#line 468
  what->size += child1->size;
#line 468

#line 468
  if (child1->fi_code != FI_CONSTANT)
#line 468
    constargs = 0;
#line 468

#line 468
} while (child1 = child1->next);
#line 468

#line 469 "filter/f-inst.c"
whati->f2 = f2;
#line 469
const struct f_inst *child2 = f2;
#line 469
do {
#line 469
  what->size += child2->size;
#line 469

#line 469
  if (child2->fi_code != FI_CONSTANT)
#line 469
    constargs = 0;
#line 469

#line 469
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type) &&
#line 470 "filter/f-inst.c"
   !f_const_promotion(f2, f1->type) && !f_const_promotion(f1, f2->type))
#line 470
  cf_error("Arguments 1 and 2 of %s must be of the same type", f_instruction_name(what->fi_code));
#line 475 "filter/f-inst.c"
what->type = T_BOOL;

#line 478 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 478
    if (!constargs)
#line 478
      return what;
#line 478

#line 478
    /* Try to pre-calculate the result */
#line 478
    #line 467 "filter/f-inst.c"
 {
    
#line 468 "filter/f-inst.c"
;
    
#line 469 "filter/f-inst.c"
;
    #line 470 "filter/f-inst.c"
;

    int i = val_compare(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "Can't compare values of incompatible types" );
     
#line 475 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (i != 1) } );
  }

  
  #undef whati
#line 478 "filter/f-inst.c"
  }
#line 478

#line 478

#line 483 "filter/f-inst.c"
 /* Constructor for FI_NOT */
#line 483
struct f_inst *
#line 479 "filter/f-inst.c"
NONNULL(2)
#line 483 "filter/f-inst.c"
f_new_inst_FI_NOT(enum f_instruction_code fi_code
#line 479 "filter/f-inst.c"
  , struct f_inst * f1
#line 483 "filter/f-inst.c"
)
#line 483
  {
#line 483
    /* Allocate the structure */
#line 483
    struct f_inst *what = fi_new(fi_code);
#line 483
    uint constargs = 1;
#line 483

#line 483
    /* Initialize all the members */
#line 483
  #define whati (&(what->i_FI_NOT))
#line 483
  #line 479 "filter/f-inst.c"
whati->f1 = f1;
#line 479
const struct f_inst *child1 = f1;
#line 479
do {
#line 479
  what->size += child1->size;
#line 479

#line 479
  if (child1->fi_code != FI_CONSTANT)
#line 479
    constargs = 0;
#line 479

#line 479
} while (child1 = child1->next);
#line 479

#line 479 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 479
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 479
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 480 "filter/f-inst.c"
what->type = T_BOOL;

#line 483 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 483
    if (!constargs)
#line 483
      return what;
#line 483

#line 483
    /* Try to pre-calculate the result */
#line 483
    #line 478 "filter/f-inst.c"
 {
    
#line 479 "filter/f-inst.c"
 #line 479 "filter/f-inst.c"
 ;
#line 480 "filter/f-inst.c"
     
#line 480 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !v1.val.i } );
  }

  
  #undef whati
#line 483 "filter/f-inst.c"
  }
#line 483

#line 483

#line 492 "filter/f-inst.c"
 /* Constructor for FI_MATCH */
#line 492
struct f_inst *
#line 484 "filter/f-inst.c"
NONNULL(2)
#line 485 "filter/f-inst.c"
NONNULL(3)
#line 492 "filter/f-inst.c"
f_new_inst_FI_MATCH(enum f_instruction_code fi_code
#line 484 "filter/f-inst.c"
  , struct f_inst * f1
#line 485 "filter/f-inst.c"
  , struct f_inst * f2
#line 492 "filter/f-inst.c"
)
#line 492
  {
#line 492
    /* Allocate the structure */
#line 492
    struct f_inst *what = fi_new(fi_code);
#line 492
    uint constargs = 1;
#line 492

#line 492
    /* Initialize all the members */
#line 492
  #define whati (&(what->i_FI_MATCH))
#line 492
  #line 484 "filter/f-inst.c"
whati->f1 = f1;
#line 484
const struct f_inst *child1 = f1;
#line 484
do {
#line 484
  what->size += child1->size;
#line 484

#line 484
  if (child1->fi_code != FI_CONSTANT)
#line 484
    constargs = 0;
#line 484

#line 484
} while (child1 = child1->next);
#line 484

#line 485 "filter/f-inst.c"
whati->f2 = f2;
#line 485
const struct f_inst *child2 = f2;
#line 485
do {
#line 485
  what->size += child2->size;
#line 485

#line 485
  if (child2->fi_code != FI_CONSTANT)
#line 485
    constargs = 0;
#line 485

#line 485
} while (child2 = child2->next);
#line 489 "filter/f-inst.c"
what->type = T_BOOL;

#line 492 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 492
    if (!constargs)
#line 492
      return what;
#line 492

#line 492
    /* Try to pre-calculate the result */
#line 492
    #line 483 "filter/f-inst.c"
 {
    
#line 484 "filter/f-inst.c"
;
    
#line 485 "filter/f-inst.c"
;
    int i = val_in_range(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "~ applied on unknown type pair" );
     
#line 489 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !!i } );
  }

  
  #undef whati
#line 492 "filter/f-inst.c"
  }
#line 492

#line 492

#line 501 "filter/f-inst.c"
 /* Constructor for FI_NOT_MATCH */
#line 501
struct f_inst *
#line 493 "filter/f-inst.c"
NONNULL(2)
#line 494 "filter/f-inst.c"
NONNULL(3)
#line 501 "filter/f-inst.c"
f_new_inst_FI_NOT_MATCH(enum f_instruction_code fi_code
#line 493 "filter/f-inst.c"
  , struct f_inst * f1
#line 494 "filter/f-inst.c"
  , struct f_inst * f2
#line 501 "filter/f-inst.c"
)
#line 501
  {
#line 501
    /* Allocate the structure */
#line 501
    struct f_inst *what = fi_new(fi_code);
#line 501
    uint constargs = 1;
#line 501

#line 501
    /* Initialize all the members */
#line 501
  #define whati (&(what->i_FI_NOT_MATCH))
#line 501
  #line 493 "filter/f-inst.c"
whati->f1 = f1;
#line 493
const struct f_inst *child1 = f1;
#line 493
do {
#line 493
  what->size += child1->size;
#line 493

#line 493
  if (child1->fi_code != FI_CONSTANT)
#line 493
    constargs = 0;
#line 493

#line 493
} while (child1 = child1->next);
#line 493

#line 494 "filter/f-inst.c"
whati->f2 = f2;
#line 494
const struct f_inst *child2 = f2;
#line 494
do {
#line 494
  what->size += child2->size;
#line 494

#line 494
  if (child2->fi_code != FI_CONSTANT)
#line 494
    constargs = 0;
#line 494

#line 494
} while (child2 = child2->next);
#line 498 "filter/f-inst.c"
what->type = T_BOOL;

#line 501 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 501
    if (!constargs)
#line 501
      return what;
#line 501

#line 501
    /* Try to pre-calculate the result */
#line 501
    #line 492 "filter/f-inst.c"
 {
    
#line 493 "filter/f-inst.c"
;
    
#line 494 "filter/f-inst.c"
;
    int i = val_in_range(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "!~ applied on unknown type pair" );
     
#line 498 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !i } );
  }

  
  #undef whati
#line 501 "filter/f-inst.c"
  }
#line 501

#line 501

#line 506 "filter/f-inst.c"
 /* Constructor for FI_DEFINED */
#line 506
struct f_inst *
#line 502 "filter/f-inst.c"
NONNULL(2)
#line 506 "filter/f-inst.c"
f_new_inst_FI_DEFINED(enum f_instruction_code fi_code
#line 502 "filter/f-inst.c"
  , struct f_inst * f1
#line 506 "filter/f-inst.c"
)
#line 506
  {
#line 506
    /* Allocate the structure */
#line 506
    struct f_inst *what = fi_new(fi_code);
#line 506
    uint constargs = 1;
#line 506

#line 506
    /* Initialize all the members */
#line 506
  #define whati (&(what->i_FI_DEFINED))
#line 506
  #line 502 "filter/f-inst.c"
whati->f1 = f1;
#line 502
const struct f_inst *child1 = f1;
#line 502
do {
#line 502
  what->size += child1->size;
#line 502

#line 502
  if (child1->fi_code != FI_CONSTANT)
#line 502
    constargs = 0;
#line 502

#line 502
} while (child1 = child1->next);
#line 502

#line 503 "filter/f-inst.c"
what->type = T_BOOL;

#line 506 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 506
    if (!constargs)
#line 506
      return what;
#line 506

#line 506
    /* Try to pre-calculate the result */
#line 506
    #line 501 "filter/f-inst.c"
 {
    
#line 502 "filter/f-inst.c"
;
     
#line 503 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (v1.type != T_VOID) && !val_is_undefined(v1) } );
  }

  
  #undef whati
#line 506 "filter/f-inst.c"
  }
#line 506

#line 506

#line 507 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__type */
#line 507
struct f_inst *
#line 506 "filter/f-inst.c"
NONNULL(2)
#line 507 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__type(enum f_instruction_code fi_code
#line 506 "filter/f-inst.c"
  , struct f_inst * f1
#line 507 "filter/f-inst.c"
)
#line 507
  {
#line 507
    /* Allocate the structure */
#line 507
    struct f_inst *what = fi_new(fi_code);
#line 507
    uint constargs = 1;
#line 507

#line 507
    /* Initialize all the members */
#line 507
  #define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
  #line 506 "filter/f-inst.c"
whati->f1 = f1;
#line 506
const struct f_inst *child1 = f1;
#line 506
do {
#line 506
  what->size += child1->size;
#line 506

#line 506
  if (child1->fi_code != FI_CONSTANT)
#line 506
    constargs = 0;
#line 506

#line 506
} while (child1 = child1->next);
#line 506

#line 506 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 506
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 506
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 506 "filter/f-inst.c"
what->type = T_ENUM_NET_TYPE;

#line 507 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 507
    if (!constargs)
#line 507
      return what;
#line 507

#line 507
    /* Try to pre-calculate the result */
#line 507
    #line 506 "filter/f-inst.c"
 {
#line 506
  
#line 506 "filter/f-inst.c"
 #line 506 "filter/f-inst.c"
 ;
#line 506 "filter/f-inst.c"
    
#line 506 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ENUM_NET_TYPE, .val.i = v1.val.net->type } ) 
#line 506
  #line 506 "filter/f-inst.c"
;
#line 506
};
  
  #undef whati
#line 507 "filter/f-inst.c"
  }
#line 507

#line 507

#line 510 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_IP__is_v4 */
#line 510
struct f_inst *
#line 507 "filter/f-inst.c"
NONNULL(2)
#line 510 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_IP__is_v4(enum f_instruction_code fi_code
#line 507 "filter/f-inst.c"
  , struct f_inst * f1
#line 510 "filter/f-inst.c"
)
#line 510
  {
#line 510
    /* Allocate the structure */
#line 510
    struct f_inst *what = fi_new(fi_code);
#line 510
    uint constargs = 1;
#line 510

#line 510
    /* Initialize all the members */
#line 510
  #define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
  #line 507 "filter/f-inst.c"
whati->f1 = f1;
#line 507
const struct f_inst *child1 = f1;
#line 507
do {
#line 507
  what->size += child1->size;
#line 507

#line 507
  if (child1->fi_code != FI_CONSTANT)
#line 507
    constargs = 0;
#line 507

#line 507
} while (child1 = child1->next);
#line 507

#line 507 "filter/f-inst.c"
if (f1->type && (f1->type != (T_IP)) && !f_const_promotion(f1, (T_IP)))
#line 507
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 507
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f1->type));
#line 507 "filter/f-inst.c"
what->type = T_BOOL;

#line 510 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 510
    if (!constargs)
#line 510
      return what;
#line 510

#line 510
    /* Try to pre-calculate the result */
#line 510
    #line 507 "filter/f-inst.c"
 {
#line 507
  
#line 507 "filter/f-inst.c"
 #line 507 "filter/f-inst.c"
 ;
#line 507 "filter/f-inst.c"
    
#line 507 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = ipa_is_ip4(v1.val.ip) } ) 
#line 507
  #line 507 "filter/f-inst.c"
;
#line 507
};

  /* Add initialized variable */
  
  #undef whati
#line 510 "filter/f-inst.c"
  }
#line 510

#line 510

#line 523 "filter/f-inst.c"
 /* Constructor for FI_VAR_INIT */
#line 523
struct f_inst *
#line 512 "filter/f-inst.c"
NONNULL(2)
#line 523 "filter/f-inst.c"
f_new_inst_FI_VAR_INIT(enum f_instruction_code fi_code
#line 512 "filter/f-inst.c"
  , struct f_inst * f1
#line 513 "filter/f-inst.c"
  , struct symbol * sym
#line 523 "filter/f-inst.c"
)
#line 523
  {
#line 523
    /* Allocate the structure */
#line 523
    struct f_inst *what = fi_new(fi_code);
#line 523
    
#line 523

#line 523
    /* Initialize all the members */
#line 523
  #define whati (&(what->i_FI_VAR_INIT))
#line 523
  #line 512 "filter/f-inst.c"
whati->f1 = f1;
#line 512
const struct f_inst *child1 = f1;
#line 512
do {
#line 512
  what->size += child1->size;
#line 512

#line 512
} while (child1 = child1->next);
#line 512

#line 513 "filter/f-inst.c"
whati->sym = sym;
#line 514 "filter/f-inst.c"
if (f1->type && (f1->type != (sym->class & 0xff)) && !f_const_promotion(f1, (sym->class & 0xff)))
#line 514
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 514
	   f_instruction_name(what->fi_code), f_type_name(sym->class & 0xff), f_type_name(f1->type));

#line 523 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 523
    
#line 523
      return what;
#line 523

#line 523
    /* Try to pre-calculate the result */
#line 523
      #undef whati
#line 523
  }
#line 523

#line 523

#line 534 "filter/f-inst.c"
 /* Constructor for FI_VAR_INIT0 */
#line 534
struct f_inst *
#line 534
f_new_inst_FI_VAR_INIT0(enum f_instruction_code fi_code
#line 525 "filter/f-inst.c"
  , struct symbol * sym
#line 534 "filter/f-inst.c"
)
#line 534
  {
#line 534
    /* Allocate the structure */
#line 534
    struct f_inst *what = fi_new(fi_code);
#line 534
    
#line 534

#line 534
    /* Initialize all the members */
#line 534
  #define whati (&(what->i_FI_VAR_INIT0))
#line 534
  #line 525 "filter/f-inst.c"
whati->sym = sym;

#line 534 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 534
    
#line 534
      return what;
#line 534

#line 534
    /* Try to pre-calculate the result */
#line 534
      #undef whati
#line 534
  }
#line 534

#line 534

#line 543 "filter/f-inst.c"
 /* Constructor for FI_VAR_SET */
#line 543
struct f_inst *
#line 536 "filter/f-inst.c"
NONNULL(2)
#line 543 "filter/f-inst.c"
f_new_inst_FI_VAR_SET(enum f_instruction_code fi_code
#line 536 "filter/f-inst.c"
  , struct f_inst * f1
#line 537 "filter/f-inst.c"
  , struct symbol * sym
#line 543 "filter/f-inst.c"
)
#line 543
  {
#line 543
    /* Allocate the structure */
#line 543
    struct f_inst *what = fi_new(fi_code);
#line 543
    
#line 543

#line 543
    /* Initialize all the members */
#line 543
  #define whati (&(what->i_FI_VAR_SET))
#line 543
  #line 536 "filter/f-inst.c"
whati->f1 = f1;
#line 536
const struct f_inst *child1 = f1;
#line 536
do {
#line 536
  what->size += child1->size;
#line 536

#line 536
} while (child1 = child1->next);
#line 536

#line 537 "filter/f-inst.c"
whati->sym = sym;
#line 538 "filter/f-inst.c"
if (f1->type && (f1->type != (sym->class & 0xff)) && !f_const_promotion(f1, (sym->class & 0xff)))
#line 538
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 538
	   f_instruction_name(what->fi_code), f_type_name(sym->class & 0xff), f_type_name(f1->type));

#line 543 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 543
    
#line 543
      return what;
#line 543

#line 543
    /* Try to pre-calculate the result */
#line 543
      #undef whati
#line 543
  }
#line 543

#line 543

#line 550 "filter/f-inst.c"
 /* Constructor for FI_VAR_GET */
#line 550
struct f_inst *
#line 550
f_new_inst_FI_VAR_GET(enum f_instruction_code fi_code
#line 544 "filter/f-inst.c"
  , struct symbol * sym
#line 550 "filter/f-inst.c"
)
#line 550
  {
#line 550
    /* Allocate the structure */
#line 550
    struct f_inst *what = fi_new(fi_code);
#line 550
    
#line 550

#line 550
    /* Initialize all the members */
#line 550
  #define whati (&(what->i_FI_VAR_GET))
#line 550
  #line 544 "filter/f-inst.c"
whati->sym = sym;
#line 546 "filter/f-inst.c"
what->type = sym->class & 0xff;

#line 550 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 550
    
#line 550
      return what;
#line 550

#line 550
    /* Try to pre-calculate the result */
#line 550
      #undef whati
#line 550
  }
#line 550

#line 550

#line 563 "filter/f-inst.c"
 /* Constructor for FI_CONSTANT */
#line 563
struct f_inst *
#line 563
f_new_inst_FI_CONSTANT(enum f_instruction_code fi_code
#line 551 "filter/f-inst.c"
  , struct f_val val
#line 563 "filter/f-inst.c"
)
#line 563
  {
#line 563
    /* Allocate the structure */
#line 563
    struct f_inst *what = fi_new(fi_code);
#line 563
    uint constargs = 1;
#line 563

#line 563
    /* Initialize all the members */
#line 563
  #define whati (&(what->i_FI_CONSTANT))
#line 563
  #line 551 "filter/f-inst.c"
whati->val = val;
#line 559 "filter/f-inst.c"
what->type = val.type;

#line 563 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 563
    if (!constargs)
#line 563
      return what;
#line 563

#line 563
    /* Try to pre-calculate the result */
#line 563
    #line 550 "filter/f-inst.c"
 {
    #line 557 "filter/f-inst.c"
;

     
#line 559 "filter/f-inst.c"
;
    return fi_constant(what, val);
  }

  
  #undef whati
#line 563 "filter/f-inst.c"
  }
#line 563

#line 563

#line 564 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__empty */
#line 564
struct f_inst *
#line 563 "filter/f-inst.c"
NONNULL(2)
#line 564 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__empty(enum f_instruction_code fi_code
#line 563 "filter/f-inst.c"
  , struct f_inst * f1
#line 564 "filter/f-inst.c"
)
#line 564
  {
#line 564
    /* Allocate the structure */
#line 564
    struct f_inst *what = fi_new(fi_code);
#line 564
    uint constargs = 1;
#line 564

#line 564
    /* Initialize all the members */
#line 564
  #define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
  #line 563 "filter/f-inst.c"
whati->f1 = f1;
#line 563
const struct f_inst *child1 = f1;
#line 563
do {
#line 563
  what->size += child1->size;
#line 563

#line 563
  if (child1->fi_code != FI_CONSTANT)
#line 563
    constargs = 0;
#line 563

#line 563
} while (child1 = child1->next);
#line 563

#line 563 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 563
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 563
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 563 "filter/f-inst.c"
what->type = T_PATH;

#line 564 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 564
    if (!constargs)
#line 564
      return what;
#line 564

#line 564
    /* Try to pre-calculate the result */
#line 564
    #line 563 "filter/f-inst.c"
 {
#line 563
  
#line 563 "filter/f-inst.c"
 #line 563 "filter/f-inst.c"
 ;
#line 563 "filter/f-inst.c"
    
#line 563 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad = &null_adata } ) 
#line 563
  #line 563 "filter/f-inst.c"
;
#line 563
};
  
  #undef whati
#line 564 "filter/f-inst.c"
  }
#line 564

#line 564

#line 565 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__empty */
#line 565
struct f_inst *
#line 564 "filter/f-inst.c"
NONNULL(2)
#line 565 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__empty(enum f_instruction_code fi_code
#line 564 "filter/f-inst.c"
  , struct f_inst * f1
#line 565 "filter/f-inst.c"
)
#line 565
  {
#line 565
    /* Allocate the structure */
#line 565
    struct f_inst *what = fi_new(fi_code);
#line 565
    uint constargs = 1;
#line 565

#line 565
    /* Initialize all the members */
#line 565
  #define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
  #line 564 "filter/f-inst.c"
whati->f1 = f1;
#line 564
const struct f_inst *child1 = f1;
#line 564
do {
#line 564
  what->size += child1->size;
#line 564

#line 564
  if (child1->fi_code != FI_CONSTANT)
#line 564
    constargs = 0;
#line 564

#line 564
} while (child1 = child1->next);
#line 564

#line 564 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 564
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 564
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 564 "filter/f-inst.c"
what->type = T_CLIST;

#line 565 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 565
    if (!constargs)
#line 565
      return what;
#line 565

#line 565
    /* Try to pre-calculate the result */
#line 565
    #line 564 "filter/f-inst.c"
 {
#line 564
  
#line 564 "filter/f-inst.c"
 #line 564 "filter/f-inst.c"
 ;
#line 564 "filter/f-inst.c"
    
#line 564 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad = &null_adata } ) 
#line 564
  #line 564 "filter/f-inst.c"
;
#line 564
};
  
  #undef whati
#line 565 "filter/f-inst.c"
  }
#line 565

#line 565

#line 566 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__empty */
#line 566
struct f_inst *
#line 565 "filter/f-inst.c"
NONNULL(2)
#line 566 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__empty(enum f_instruction_code fi_code
#line 565 "filter/f-inst.c"
  , struct f_inst * f1
#line 566 "filter/f-inst.c"
)
#line 566
  {
#line 566
    /* Allocate the structure */
#line 566
    struct f_inst *what = fi_new(fi_code);
#line 566
    uint constargs = 1;
#line 566

#line 566
    /* Initialize all the members */
#line 566
  #define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
  #line 565 "filter/f-inst.c"
whati->f1 = f1;
#line 565
const struct f_inst *child1 = f1;
#line 565
do {
#line 565
  what->size += child1->size;
#line 565

#line 565
  if (child1->fi_code != FI_CONSTANT)
#line 565
    constargs = 0;
#line 565

#line 565
} while (child1 = child1->next);
#line 565

#line 565 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 565
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 565
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 565 "filter/f-inst.c"
what->type = T_ECLIST;

#line 566 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 566
    if (!constargs)
#line 566
      return what;
#line 566

#line 566
    /* Try to pre-calculate the result */
#line 566
    #line 565 "filter/f-inst.c"
 {
#line 565
  
#line 565 "filter/f-inst.c"
 #line 565 "filter/f-inst.c"
 ;
#line 565 "filter/f-inst.c"
    
#line 565 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad = &null_adata } ) 
#line 565
  #line 565 "filter/f-inst.c"
;
#line 565
};
  
  #undef whati
#line 566 "filter/f-inst.c"
  }
#line 566

#line 566

#line 569 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__empty */
#line 569
struct f_inst *
#line 566 "filter/f-inst.c"
NONNULL(2)
#line 569 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__empty(enum f_instruction_code fi_code
#line 566 "filter/f-inst.c"
  , struct f_inst * f1
#line 569 "filter/f-inst.c"
)
#line 569
  {
#line 569
    /* Allocate the structure */
#line 569
    struct f_inst *what = fi_new(fi_code);
#line 569
    uint constargs = 1;
#line 569

#line 569
    /* Initialize all the members */
#line 569
  #define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
  #line 566 "filter/f-inst.c"
whati->f1 = f1;
#line 566
const struct f_inst *child1 = f1;
#line 566
do {
#line 566
  what->size += child1->size;
#line 566

#line 566
  if (child1->fi_code != FI_CONSTANT)
#line 566
    constargs = 0;
#line 566

#line 566
} while (child1 = child1->next);
#line 566

#line 566 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 566
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 566
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 566 "filter/f-inst.c"
what->type = T_LCLIST;

#line 569 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 569
    if (!constargs)
#line 569
      return what;
#line 569

#line 569
    /* Try to pre-calculate the result */
#line 569
    #line 566 "filter/f-inst.c"
 {
#line 566
  
#line 566 "filter/f-inst.c"
 #line 566 "filter/f-inst.c"
 ;
#line 566 "filter/f-inst.c"
    
#line 566 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad = &null_adata } ) 
#line 566
  #line 566 "filter/f-inst.c"
;
#line 566
};

  /* Common loop begin instruction, always created by f_for_cycle() */
  
  #undef whati
#line 569 "filter/f-inst.c"
  }
#line 569

#line 569

#line 591 "filter/f-inst.c"
 /* Constructor for FI_FOR_LOOP_START */
#line 591
struct f_inst *
#line 591
f_new_inst_FI_FOR_LOOP_START(enum f_instruction_code fi_code
#line 571 "filter/f-inst.c"
  , struct symbol * sym
#line 591 "filter/f-inst.c"
)
#line 591
  {
#line 591
    /* Allocate the structure */
#line 591
    struct f_inst *what = fi_new(fi_code);
#line 591
    
#line 591

#line 591
    /* Initialize all the members */
#line 591
  #define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
  #line 571 "filter/f-inst.c"
whati->sym = sym;
#line 587 "filter/f-inst.c"
what->type = T_VOID;

#line 591 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 591
    
#line 591
      return what;
#line 591

#line 591
    /* Try to pre-calculate the result */
#line 591
      #undef whati
#line 591
  }
#line 591

#line 591

#line 600 "filter/f-inst.c"
 /* Constructor for FI_PATH_FOR_NEXT */
#line 600
struct f_inst *
#line 593 "filter/f-inst.c"
NONNULL(2)
#line 600 "filter/f-inst.c"
f_new_inst_FI_PATH_FOR_NEXT(enum f_instruction_code fi_code
#line 593 "filter/f-inst.c"
  , struct f_inst * f1
#line 595 "filter/f-inst.c"
  , struct f_inst * f2
#line 600 "filter/f-inst.c"
)
#line 600
  {
#line 600
    /* Allocate the structure */
#line 600
    struct f_inst *what = fi_new(fi_code);
#line 600
    
#line 600

#line 600
    /* Initialize all the members */
#line 600
  #define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 600
  #line 593 "filter/f-inst.c"
whati->f1 = f1;
#line 593
const struct f_inst *child1 = f1;
#line 593
do {
#line 593
  what->size += child1->size;
#line 593

#line 593
} while (child1 = child1->next);
#line 593

#line 593 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 593
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 593
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 595 "filter/f-inst.c"
whati->f2 = f2;

#line 600 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 600
    
#line 600
      return what;
#line 600

#line 600
    /* Try to pre-calculate the result */
#line 600
      #undef whati
#line 600
  }
#line 600

#line 600

#line 609 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FOR_NEXT */
#line 609
struct f_inst *
#line 602 "filter/f-inst.c"
NONNULL(2)
#line 609 "filter/f-inst.c"
f_new_inst_FI_CLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 602 "filter/f-inst.c"
  , struct f_inst * f1
#line 604 "filter/f-inst.c"
  , struct f_inst * f2
#line 609 "filter/f-inst.c"
)
#line 609
  {
#line 609
    /* Allocate the structure */
#line 609
    struct f_inst *what = fi_new(fi_code);
#line 609
    
#line 609

#line 609
    /* Initialize all the members */
#line 609
  #define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 609
  #line 602 "filter/f-inst.c"
whati->f1 = f1;
#line 602
const struct f_inst *child1 = f1;
#line 602
do {
#line 602
  what->size += child1->size;
#line 602

#line 602
} while (child1 = child1->next);
#line 602

#line 602 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 602
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 602
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 604 "filter/f-inst.c"
whati->f2 = f2;

#line 609 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 609
    
#line 609
      return what;
#line 609

#line 609
    /* Try to pre-calculate the result */
#line 609
      #undef whati
#line 609
  }
#line 609

#line 609

#line 618 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FOR_NEXT */
#line 618
struct f_inst *
#line 611 "filter/f-inst.c"
NONNULL(2)
#line 618 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 611 "filter/f-inst.c"
  , struct f_inst * f1
#line 613 "filter/f-inst.c"
  , struct f_inst * f2
#line 618 "filter/f-inst.c"
)
#line 618
  {
#line 618
    /* Allocate the structure */
#line 618
    struct f_inst *what = fi_new(fi_code);
#line 618
    
#line 618

#line 618
    /* Initialize all the members */
#line 618
  #define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 618
  #line 611 "filter/f-inst.c"
whati->f1 = f1;
#line 611
const struct f_inst *child1 = f1;
#line 611
do {
#line 611
  what->size += child1->size;
#line 611

#line 611
} while (child1 = child1->next);
#line 611

#line 611 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 611
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 611
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 613 "filter/f-inst.c"
whati->f2 = f2;

#line 618 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 618
    
#line 618
      return what;
#line 618

#line 618
    /* Try to pre-calculate the result */
#line 618
      #undef whati
#line 618
  }
#line 618

#line 618

#line 627 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FOR_NEXT */
#line 627
struct f_inst *
#line 620 "filter/f-inst.c"
NONNULL(2)
#line 627 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 620 "filter/f-inst.c"
  , struct f_inst * f1
#line 622 "filter/f-inst.c"
  , struct f_inst * f2
#line 627 "filter/f-inst.c"
)
#line 627
  {
#line 627
    /* Allocate the structure */
#line 627
    struct f_inst *what = fi_new(fi_code);
#line 627
    
#line 627

#line 627
    /* Initialize all the members */
#line 627
  #define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 627
  #line 620 "filter/f-inst.c"
whati->f1 = f1;
#line 620
const struct f_inst *child1 = f1;
#line 620
do {
#line 620
  what->size += child1->size;
#line 620

#line 620
} while (child1 = child1->next);
#line 620

#line 620 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 620
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 620
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 622 "filter/f-inst.c"
whati->f2 = f2;

#line 627 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 627
    
#line 627
      return what;
#line 627

#line 627
    /* Try to pre-calculate the result */
#line 627
      #undef whati
#line 627
  }
#line 627

#line 627

#line 640 "filter/f-inst.c"
 /* Constructor for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
struct f_inst *
#line 629 "filter/f-inst.c"
NONNULL(2)
#line 640 "filter/f-inst.c"
f_new_inst_FI_ROUTES_BLOCK_FOR_NEXT(enum f_instruction_code fi_code
#line 629 "filter/f-inst.c"
  , struct f_inst * f1
#line 634 "filter/f-inst.c"
  , struct f_inst * f2
#line 640 "filter/f-inst.c"
)
#line 640
  {
#line 640
    /* Allocate the structure */
#line 640
    struct f_inst *what = fi_new(fi_code);
#line 640
    
#line 640

#line 640
    /* Initialize all the members */
#line 640
  #define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
  #line 629 "filter/f-inst.c"
whati->f1 = f1;
#line 629
const struct f_inst *child1 = f1;
#line 629
do {
#line 629
  what->size += child1->size;
#line 629

#line 629
} while (child1 = child1->next);
#line 629

#line 629 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTES_BLOCK)) && !f_const_promotion(f1, (T_ROUTES_BLOCK)))
#line 629
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 629
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTES_BLOCK), f_type_name(f1->type));
#line 634 "filter/f-inst.c"
whati->f2 = f2;

#line 640 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 640
    
#line 640
      return what;
#line 640

#line 640
    /* Try to pre-calculate the result */
#line 640
      #undef whati
#line 640
  }
#line 640

#line 640

#line 648 "filter/f-inst.c"
 /* Constructor for FI_CONDITION */
#line 648
struct f_inst *
#line 641 "filter/f-inst.c"
NONNULL(2)
#line 648 "filter/f-inst.c"
f_new_inst_FI_CONDITION(enum f_instruction_code fi_code
#line 641 "filter/f-inst.c"
  , struct f_inst * f1
#line 643 "filter/f-inst.c"
  , struct f_inst * f2
#line 645 "filter/f-inst.c"
  , struct f_inst * f3
#line 648 "filter/f-inst.c"
)
#line 648
  {
#line 648
    /* Allocate the structure */
#line 648
    struct f_inst *what = fi_new(fi_code);
#line 648
    uint constargs = 1;
#line 648

#line 648
    /* Initialize all the members */
#line 648
  #define whati (&(what->i_FI_CONDITION))
#line 648
  #line 641 "filter/f-inst.c"
whati->f1 = f1;
#line 641
const struct f_inst *child1 = f1;
#line 641
do {
#line 641
  what->size += child1->size;
#line 641

#line 641
  if (child1->fi_code != FI_CONSTANT)
#line 641
    constargs = 0;
#line 641

#line 641
} while (child1 = child1->next);
#line 641

#line 641 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 641
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 641
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 643 "filter/f-inst.c"
whati->f2 = f2;
#line 645 "filter/f-inst.c"
whati->f3 = f3;

#line 648 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 648
    if (!constargs)
#line 648
      return what;
#line 648

#line 648
    /* Try to pre-calculate the result */
#line 648
    #line 640 "filter/f-inst.c"
 {
    
#line 641 "filter/f-inst.c"
 #line 641 "filter/f-inst.c"
 ;
#line 642 "filter/f-inst.c"
    if (v1.val.i)
      
#line 643 "filter/f-inst.c"
return whati->f2
#line 643
;
    else
      
#line 645 "filter/f-inst.c"
return whati->f3
#line 645
;
  }

  
  #undef whati
#line 648 "filter/f-inst.c"
  }
#line 648

#line 648

#line 661 "filter/f-inst.c"
 /* Constructor for FI_PRINT */
#line 661
struct f_inst *
#line 650 "filter/f-inst.c"
NONNULL(2)
#line 661 "filter/f-inst.c"
f_new_inst_FI_PRINT(enum f_instruction_code fi_code
#line 650 "filter/f-inst.c"
  , struct f_inst * f1
#line 661 "filter/f-inst.c"
)
#line 661
  {
#line 661
    /* Allocate the structure */
#line 661
    struct f_inst *what = fi_new(fi_code);
#line 661
    
#line 661

#line 661
    /* Initialize all the members */
#line 661
  #define whati (&(what->i_FI_PRINT))
#line 661
  #line 650 "filter/f-inst.c"
whati->f1 = f1;
#line 650
const struct f_inst *child1 = f1;
#line 650
do {
#line 650
  what->size += child1->size;
#line 650

#line 650
} while (child1 = child1->next);
#line 650


#line 661 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 661
    
#line 661
      return what;
#line 661

#line 661
    /* Try to pre-calculate the result */
#line 661
      #undef whati
#line 661
  }
#line 661

#line 661

#line 668 "filter/f-inst.c"
 /* Constructor for FI_FLUSH */
#line 668
struct f_inst *
#line 668
f_new_inst_FI_FLUSH(enum f_instruction_code fi_code
#line 668
)
#line 668
  {
#line 668
    /* Allocate the structure */
#line 668
    struct f_inst *what = fi_new(fi_code);
#line 668
    
#line 668

#line 668
    /* Initialize all the members */
#line 668
  #define whati (&(what->i_FI_FLUSH))
#line 668
  
#line 668
    /* If not constant, return the instruction itself */
#line 668
    
#line 668
      return what;
#line 668

#line 668
    /* Try to pre-calculate the result */
#line 668
      #undef whati
#line 668
  }
#line 668

#line 668

#line 682 "filter/f-inst.c"
 /* Constructor for FI_DIE */
#line 682
struct f_inst *
#line 682
f_new_inst_FI_DIE(enum f_instruction_code fi_code
#line 670 "filter/f-inst.c"
  , enum filter_return fret
#line 682 "filter/f-inst.c"
)
#line 682
  {
#line 682
    /* Allocate the structure */
#line 682
    struct f_inst *what = fi_new(fi_code);
#line 682
    
#line 682

#line 682
    /* Initialize all the members */
#line 682
  #define whati (&(what->i_FI_DIE))
#line 682
  #line 670 "filter/f-inst.c"
whati->fret = fret;

#line 682 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 682
    
#line 682
      return what;
#line 682

#line 682
    /* Try to pre-calculate the result */
#line 682
      #undef whati
#line 682
  }
#line 682

#line 682

#line 689 "filter/f-inst.c"
 /* Constructor for FI_CURRENT_ROUTE */
#line 689
struct f_inst *
#line 689
f_new_inst_FI_CURRENT_ROUTE(enum f_instruction_code fi_code
#line 689
)
#line 689
  {
#line 689
    /* Allocate the structure */
#line 689
    struct f_inst *what = fi_new(fi_code);
#line 689
    
#line 689

#line 689
    /* Initialize all the members */
#line 689
  #define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
  #line 685 "filter/f-inst.c"
what->type = T_ROUTE;

#line 689 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 689
    
#line 689
      return what;
#line 689

#line 689
    /* Try to pre-calculate the result */
#line 689
      #undef whati
#line 689
  }
#line 689

#line 689

#line 740 "filter/f-inst.c"
 /* Constructor for FI_RTA_GET */
#line 740
struct f_inst *
#line 691 "filter/f-inst.c"
NONNULL(2)
#line 740 "filter/f-inst.c"
f_new_inst_FI_RTA_GET(enum f_instruction_code fi_code
#line 691 "filter/f-inst.c"
  , struct f_inst * f1
#line 692 "filter/f-inst.c"
  , struct f_static_attr sa
#line 740 "filter/f-inst.c"
)
#line 740
  {
#line 740
    /* Allocate the structure */
#line 740
    struct f_inst *what = fi_new(fi_code);
#line 740
    uint constargs = 1;
#line 740

#line 740
    /* Initialize all the members */
#line 740
  #define whati (&(what->i_FI_RTA_GET))
#line 740
  #line 691 "filter/f-inst.c"
whati->f1 = f1;
#line 691
const struct f_inst *child1 = f1;
#line 691
do {
#line 691
  what->size += child1->size;
#line 691

#line 691
  if (child1->fi_code != FI_CONSTANT)
#line 691
    constargs = 0;
#line 691

#line 691
} while (child1 = child1->next);
#line 691

#line 691 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTE)) && !f_const_promotion(f1, (T_ROUTE)))
#line 691
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 691
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTE), f_type_name(f1->type));
#line 692 "filter/f-inst.c"
whati->sa = sa;
#line 698 "filter/f-inst.c"
what->type = sa.type;

#line 740 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 740
    if (!constargs)
#line 740
      return what;
#line 740

#line 740
    /* Try to pre-calculate the result */
#line 740
    #line 689 "filter/f-inst.c"
 {
    {
      
#line 691 "filter/f-inst.c"
 #line 691 "filter/f-inst.c"
 ;
#line 692 "filter/f-inst.c"
      #line 692 "filter/f-inst.c"
;

      struct rte *rte = v1.val.rte;

      switch (sa.sa_code)
      {
      case SA_NET:	 
#line 698 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = sa.type, .val.net = rte->net } ); break;
      case SA_PROTO:	 return fi_constant(what,  (struct f_val) { .type = sa.type, .val.s = rte->src->owner->name } ); break;
      default:
	{
	  /* Next hop examination */
	  struct eattr *nhea = ea_find(rte->attrs, &ea_gen_nexthop);
	  struct nexthop_adata *nhad = nhea ? (struct nexthop_adata *) nhea->u.ptr : NULL;
	  struct nexthop *nh = (nhad && NEXTHOP_IS_REACHABLE(nhad)) ? &nhad->nh : NULL;

	  switch (sa.sa_code)
	  {
	    case SA_DEST:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = nhad ?
#line 710
		  (NEXTHOP_IS_REACHABLE(nhad) ? RTD_UNICAST : nhad->dest)
#line 710
		  : RTD_NONE } );
#line 713
	      break;
	    case SA_GW:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.ip = nh ? nh->gw : IPA_NONE } );
	      break;
	    case SA_IFNAME:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.s = (nh && nh->iface) ? nh->iface->name : "" } );
	      break;
	    case SA_IFINDEX:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && nh->iface) ? nh->iface->index : 0 } );
	      break;
	    case SA_WEIGHT:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh ? nh->weight : 0) + 1 } );
	      break;
	    case SA_GW_MPLS:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && nh->labels) ? nh->label[0] : MPLS_NULL } );
	      break;
	    case SA_ONLINK:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && !!(nh->flags & RNF_ONLINK)) } );
	      break;
	    default:
	      bug("Invalid static attribute access (%u/%u)", sa.type, sa.sa_code);
	  }
	}
      }
    }
  }

  
  #undef whati
#line 740 "filter/f-inst.c"
  }
#line 740

#line 740

#line 897 "filter/f-inst.c"
 /* Constructor for FI_RTA_SET */
#line 897
struct f_inst *
#line 742 "filter/f-inst.c"
NONNULL(2)
#line 897 "filter/f-inst.c"
f_new_inst_FI_RTA_SET(enum f_instruction_code fi_code
#line 742 "filter/f-inst.c"
  , struct f_inst * f1
#line 743 "filter/f-inst.c"
  , struct f_static_attr sa
#line 897 "filter/f-inst.c"
)
#line 897
  {
#line 897
    /* Allocate the structure */
#line 897
    struct f_inst *what = fi_new(fi_code);
#line 897
    
#line 897

#line 897
    /* Initialize all the members */
#line 897
  #define whati (&(what->i_FI_RTA_SET))
#line 897
  #line 742 "filter/f-inst.c"
whati->f1 = f1;
#line 742
const struct f_inst *child1 = f1;
#line 742
do {
#line 742
  what->size += child1->size;
#line 742

#line 742
} while (child1 = child1->next);
#line 742

#line 743 "filter/f-inst.c"
whati->sa = sa;
#line 744 "filter/f-inst.c"
if (f1->type && (f1->type != (sa.type)) && !f_const_promotion(f1, (sa.type)))
#line 744
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 744
	   f_instruction_name(what->fi_code), f_type_name(sa.type), f_type_name(f1->type));

#line 897 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 897
    
#line 897
      return what;
#line 897

#line 897
    /* Try to pre-calculate the result */
#line 897
      #undef whati
#line 897
  }
#line 897

#line 897

#line 934 "filter/f-inst.c"
 /* Constructor for FI_EA_GET */
#line 934
struct f_inst *
#line 898 "filter/f-inst.c"
NONNULL(2)
#line 934 "filter/f-inst.c"
f_new_inst_FI_EA_GET(enum f_instruction_code fi_code
#line 898 "filter/f-inst.c"
  , struct f_inst * f1
#line 899 "filter/f-inst.c"
  , const struct ea_class * da
#line 934 "filter/f-inst.c"
)
#line 934
  {
#line 934
    /* Allocate the structure */
#line 934
    struct f_inst *what = fi_new(fi_code);
#line 934
    uint constargs = 1;
#line 934

#line 934
    /* Initialize all the members */
#line 934
  #define whati (&(what->i_FI_EA_GET))
#line 934
  #line 898 "filter/f-inst.c"
whati->f1 = f1;
#line 898
const struct f_inst *child1 = f1;
#line 898
do {
#line 898
  what->size += child1->size;
#line 898

#line 898
  if (child1->fi_code != FI_CONSTANT)
#line 898
    constargs = 0;
#line 898

#line 898
} while (child1 = child1->next);
#line 898

#line 898 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTE)) && !f_const_promotion(f1, (T_ROUTE)))
#line 898
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 898
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTE), f_type_name(f1->type));
#line 899 "filter/f-inst.c"
whati->da = da;
#line 900 "filter/f-inst.c"
what->type = da->type;

#line 934 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 934
    if (!constargs)
#line 934
      return what;
#line 934

#line 934
    /* Try to pre-calculate the result */
#line 934
    #line 897 "filter/f-inst.c"
 {	/* Access to extended attributes */
    
#line 898 "filter/f-inst.c"
 #line 898 "filter/f-inst.c"
 ;
#line 899 "filter/f-inst.c"
    #line 899 "filter/f-inst.c"
;
     
#line 900 "filter/f-inst.c"
;
    {
      struct f_val empty;
      const eattr *e = ea_find(v1.val.rte->attrs, da->id);

      if (e)
      {
	ASSERT_DIE(e->type == da->type);

	switch (e->type) {
	  case T_IP:
	    return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip = *((const ip_addr *) e->u.ptr->data) } );
	    break;

	  case T_STRING:
	    return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s = (const char *) e->u.ptr->data } );
	    break;

	  default:
	    return fi_constant(what, (struct f_val) {
#line 919
		.type = e->type,
#line 919
		.val.bval = e->u,
#line 919
		});
#line 923
	}
      }
      else if (da->empty)
	return fi_constant(what, da->empty(da));
      else if ((empty = f_get_empty(da->type)).type != T_VOID)
	return fi_constant(what, empty);
      else
	return fi_constant(what,  (struct f_val) { .type = T_VOID } );
    }
  }

  
  #undef whati
#line 934 "filter/f-inst.c"
  }
#line 934

#line 934

#line 975 "filter/f-inst.c"
 /* Constructor for FI_EA_SET */
#line 975
struct f_inst *
#line 936 "filter/f-inst.c"
NONNULL(2)
#line 975 "filter/f-inst.c"
f_new_inst_FI_EA_SET(enum f_instruction_code fi_code
#line 936 "filter/f-inst.c"
  , struct f_inst * f1
#line 937 "filter/f-inst.c"
  , const struct ea_class * da
#line 975 "filter/f-inst.c"
)
#line 975
  {
#line 975
    /* Allocate the structure */
#line 975
    struct f_inst *what = fi_new(fi_code);
#line 975
    
#line 975

#line 975
    /* Initialize all the members */
#line 975
  #define whati (&(what->i_FI_EA_SET))
#line 975
  #line 936 "filter/f-inst.c"
whati->f1 = f1;
#line 936
const struct f_inst *child1 = f1;
#line 936
do {
#line 936
  what->size += child1->size;
#line 936

#line 936
} while (child1 = child1->next);
#line 936

#line 937 "filter/f-inst.c"
whati->da = da;
#line 938 "filter/f-inst.c"
if (f1->type && (f1->type != (da->type)) && !f_const_promotion(f1, (da->type)))
#line 938
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 938
	   f_instruction_name(what->fi_code), f_type_name(da->type), f_type_name(f1->type));
;
#line 941 "filter/f-inst.c"
      if (da->type == T_OPAQUE)
	cf_error("Setting opaque attribute is not allowed");

    
#line 975 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 975
    
#line 975
      return what;
#line 975

#line 975
    /* Try to pre-calculate the result */
#line 975
      #undef whati
#line 975
  }
#line 975

#line 975

#line 982 "filter/f-inst.c"
 /* Constructor for FI_EA_UNSET */
#line 982
struct f_inst *
#line 982
f_new_inst_FI_EA_UNSET(enum f_instruction_code fi_code
#line 976 "filter/f-inst.c"
  , const struct ea_class * da
#line 982 "filter/f-inst.c"
)
#line 982
  {
#line 982
    /* Allocate the structure */
#line 982
    struct f_inst *what = fi_new(fi_code);
#line 982
    
#line 982

#line 982
    /* Initialize all the members */
#line 982
  #define whati (&(what->i_FI_EA_UNSET))
#line 982
  #line 976 "filter/f-inst.c"
whati->da = da;

#line 982 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 982
    
#line 982
      return what;
#line 982

#line 982
    /* Try to pre-calculate the result */
#line 982
      #undef whati
#line 982
  }
#line 982

#line 982

#line 996 "filter/f-inst.c"
 /* Constructor for FI_DEFAULT */
#line 996
struct f_inst *
#line 983 "filter/f-inst.c"
NONNULL(2)
#line 984 "filter/f-inst.c"
NONNULL(3)
#line 996 "filter/f-inst.c"
f_new_inst_FI_DEFAULT(enum f_instruction_code fi_code
#line 983 "filter/f-inst.c"
  , struct f_inst * f1
#line 984 "filter/f-inst.c"
  , struct f_inst * f2
#line 996 "filter/f-inst.c"
)
#line 996
  {
#line 996
    /* Allocate the structure */
#line 996
    struct f_inst *what = fi_new(fi_code);
#line 996
    uint constargs = 1;
#line 996

#line 996
    /* Initialize all the members */
#line 996
  #define whati (&(what->i_FI_DEFAULT))
#line 996
  #line 983 "filter/f-inst.c"
whati->f1 = f1;
#line 983
const struct f_inst *child1 = f1;
#line 983
do {
#line 983
  what->size += child1->size;
#line 983

#line 983
  if (child1->fi_code != FI_CONSTANT)
#line 983
    constargs = 0;
#line 983

#line 983
} while (child1 = child1->next);
#line 983

#line 984 "filter/f-inst.c"
whati->f2 = f2;
#line 984
const struct f_inst *child2 = f2;
#line 984
do {
#line 984
  what->size += child2->size;
#line 984

#line 984
  if (child2->fi_code != FI_CONSTANT)
#line 984
    constargs = 0;
#line 984

#line 984
} while (child2 = child2->next);
#line 985 "filter/f-inst.c"
what->type = f_type_element_type(v2.type);

#line 996 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 996
    if (!constargs)
#line 996
      return what;
#line 996

#line 996
    /* Try to pre-calculate the result */
#line 996
    #line 982 "filter/f-inst.c"
 {
    
#line 983 "filter/f-inst.c"
;
    
#line 984 "filter/f-inst.c"
;
     
#line 985 "filter/f-inst.c"
;

    log(L_INFO "Type of arg 1 is: %d", v1.type);

    if (v1.type == T_VOID)
      return fi_constant(what, v2);
    else
      return fi_constant(what, v1);
  }

  /* Get length of */
  
  #undef whati
#line 996 "filter/f-inst.c"
  }
#line 996

#line 996

#line 997 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__len */
#line 997
struct f_inst *
#line 996 "filter/f-inst.c"
NONNULL(2)
#line 997 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__len(enum f_instruction_code fi_code
#line 996 "filter/f-inst.c"
  , struct f_inst * f1
#line 997 "filter/f-inst.c"
)
#line 997
  {
#line 997
    /* Allocate the structure */
#line 997
    struct f_inst *what = fi_new(fi_code);
#line 997
    uint constargs = 1;
#line 997

#line 997
    /* Initialize all the members */
#line 997
  #define whati (&(what->i_FI_METHOD__T_NET__len))
#line 997
  #line 996 "filter/f-inst.c"
whati->f1 = f1;
#line 996
const struct f_inst *child1 = f1;
#line 996
do {
#line 996
  what->size += child1->size;
#line 996

#line 996
  if (child1->fi_code != FI_CONSTANT)
#line 996
    constargs = 0;
#line 996

#line 996
} while (child1 = child1->next);
#line 996

#line 996 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 996
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 996
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 996 "filter/f-inst.c"
what->type = T_INT;

#line 997 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 997
    if (!constargs)
#line 997
      return what;
#line 997

#line 997
    /* Try to pre-calculate the result */
#line 997
    #line 996 "filter/f-inst.c"
 {
#line 996
  
#line 996 "filter/f-inst.c"
 #line 996 "filter/f-inst.c"
 ;
#line 996 "filter/f-inst.c"
    
#line 996 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = net_pxlen(v1.val.net) } ) 
#line 996
  #line 996 "filter/f-inst.c"
;
#line 996
};
  
  #undef whati
#line 997 "filter/f-inst.c"
  }
#line 997

#line 997

#line 998 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__len */
#line 998
struct f_inst *
#line 997 "filter/f-inst.c"
NONNULL(2)
#line 998 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__len(enum f_instruction_code fi_code
#line 997 "filter/f-inst.c"
  , struct f_inst * f1
#line 998 "filter/f-inst.c"
)
#line 998
  {
#line 998
    /* Allocate the structure */
#line 998
    struct f_inst *what = fi_new(fi_code);
#line 998
    uint constargs = 1;
#line 998

#line 998
    /* Initialize all the members */
#line 998
  #define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 998
  #line 997 "filter/f-inst.c"
whati->f1 = f1;
#line 997
const struct f_inst *child1 = f1;
#line 997
do {
#line 997
  what->size += child1->size;
#line 997

#line 997
  if (child1->fi_code != FI_CONSTANT)
#line 997
    constargs = 0;
#line 997

#line 997
} while (child1 = child1->next);
#line 997

#line 997 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 997
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 997
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 997 "filter/f-inst.c"
what->type = T_INT;

#line 998 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 998
    if (!constargs)
#line 998
      return what;
#line 998

#line 998
    /* Try to pre-calculate the result */
#line 998
    #line 997 "filter/f-inst.c"
 {
#line 997
  
#line 997 "filter/f-inst.c"
 #line 997 "filter/f-inst.c"
 ;
#line 997 "filter/f-inst.c"
    
#line 997 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = as_path_getlen(v1.val.ad) } ) 
#line 997
  #line 997 "filter/f-inst.c"
;
#line 997
};
  
  #undef whati
#line 998 "filter/f-inst.c"
  }
#line 998

#line 998

#line 999 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__len */
#line 999
struct f_inst *
#line 998 "filter/f-inst.c"
NONNULL(2)
#line 999 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__len(enum f_instruction_code fi_code
#line 998 "filter/f-inst.c"
  , struct f_inst * f1
#line 999 "filter/f-inst.c"
)
#line 999
  {
#line 999
    /* Allocate the structure */
#line 999
    struct f_inst *what = fi_new(fi_code);
#line 999
    uint constargs = 1;
#line 999

#line 999
    /* Initialize all the members */
#line 999
  #define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 999
  #line 998 "filter/f-inst.c"
whati->f1 = f1;
#line 998
const struct f_inst *child1 = f1;
#line 998
do {
#line 998
  what->size += child1->size;
#line 998

#line 998
  if (child1->fi_code != FI_CONSTANT)
#line 998
    constargs = 0;
#line 998

#line 998
} while (child1 = child1->next);
#line 998

#line 998 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 998
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 998
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 998 "filter/f-inst.c"
what->type = T_INT;

#line 999 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 999
    if (!constargs)
#line 999
      return what;
#line 999

#line 999
    /* Try to pre-calculate the result */
#line 999
    #line 998 "filter/f-inst.c"
 {
#line 998
  
#line 998 "filter/f-inst.c"
 #line 998 "filter/f-inst.c"
 ;
#line 998 "filter/f-inst.c"
    
#line 998 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = int_set_get_size(v1.val.ad) } ) 
#line 998
  #line 998 "filter/f-inst.c"
;
#line 998
};
  
  #undef whati
#line 999 "filter/f-inst.c"
  }
#line 999

#line 999

#line 1000 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__len */
#line 1000
struct f_inst *
#line 999 "filter/f-inst.c"
NONNULL(2)
#line 1000 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__len(enum f_instruction_code fi_code
#line 999 "filter/f-inst.c"
  , struct f_inst * f1
#line 1000 "filter/f-inst.c"
)
#line 1000
  {
#line 1000
    /* Allocate the structure */
#line 1000
    struct f_inst *what = fi_new(fi_code);
#line 1000
    uint constargs = 1;
#line 1000

#line 1000
    /* Initialize all the members */
#line 1000
  #define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 1000
  #line 999 "filter/f-inst.c"
whati->f1 = f1;
#line 999
const struct f_inst *child1 = f1;
#line 999
do {
#line 999
  what->size += child1->size;
#line 999

#line 999
  if (child1->fi_code != FI_CONSTANT)
#line 999
    constargs = 0;
#line 999

#line 999
} while (child1 = child1->next);
#line 999

#line 999 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 999
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 999
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 999 "filter/f-inst.c"
what->type = T_INT;

#line 1000 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1000
    if (!constargs)
#line 1000
      return what;
#line 1000

#line 1000
    /* Try to pre-calculate the result */
#line 1000
    #line 999 "filter/f-inst.c"
 {
#line 999
  
#line 999 "filter/f-inst.c"
 #line 999 "filter/f-inst.c"
 ;
#line 999 "filter/f-inst.c"
    
#line 999 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ec_set_get_size(v1.val.ad) } ) 
#line 999
  #line 999 "filter/f-inst.c"
;
#line 999
};
  
  #undef whati
#line 1000 "filter/f-inst.c"
  }
#line 1000

#line 1000

#line 1002 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__len */
#line 1002
struct f_inst *
#line 1000 "filter/f-inst.c"
NONNULL(2)
#line 1002 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__len(enum f_instruction_code fi_code
#line 1000 "filter/f-inst.c"
  , struct f_inst * f1
#line 1002 "filter/f-inst.c"
)
#line 1002
  {
#line 1002
    /* Allocate the structure */
#line 1002
    struct f_inst *what = fi_new(fi_code);
#line 1002
    uint constargs = 1;
#line 1002

#line 1002
    /* Initialize all the members */
#line 1002
  #define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 1002
  #line 1000 "filter/f-inst.c"
whati->f1 = f1;
#line 1000
const struct f_inst *child1 = f1;
#line 1000
do {
#line 1000
  what->size += child1->size;
#line 1000

#line 1000
  if (child1->fi_code != FI_CONSTANT)
#line 1000
    constargs = 0;
#line 1000

#line 1000
} while (child1 = child1->next);
#line 1000

#line 1000 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1000
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1000
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1000 "filter/f-inst.c"
what->type = T_INT;

#line 1002 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1002
    if (!constargs)
#line 1002
      return what;
#line 1002

#line 1002
    /* Try to pre-calculate the result */
#line 1002
    #line 1000 "filter/f-inst.c"
 {
#line 1000
  
#line 1000 "filter/f-inst.c"
 #line 1000 "filter/f-inst.c"
 ;
#line 1000 "filter/f-inst.c"
    
#line 1000 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = lc_set_get_size(v1.val.ad) } ) 
#line 1000
  #line 1000 "filter/f-inst.c"
;
#line 1000
};

  
  #undef whati
#line 1002 "filter/f-inst.c"
  }
#line 1002

#line 1002

#line 1038 "filter/f-inst.c"
 /* Constructor for FI_NET_SRC */
#line 1038
struct f_inst *
#line 1003 "filter/f-inst.c"
NONNULL(2)
#line 1038 "filter/f-inst.c"
f_new_inst_FI_NET_SRC(enum f_instruction_code fi_code
#line 1003 "filter/f-inst.c"
  , struct f_inst * f1
#line 1038 "filter/f-inst.c"
)
#line 1038
  {
#line 1038
    /* Allocate the structure */
#line 1038
    struct f_inst *what = fi_new(fi_code);
#line 1038
    uint constargs = 1;
#line 1038

#line 1038
    /* Initialize all the members */
#line 1038
  #define whati (&(what->i_FI_NET_SRC))
#line 1038
  #line 1003 "filter/f-inst.c"
whati->f1 = f1;
#line 1003
const struct f_inst *child1 = f1;
#line 1003
do {
#line 1003
  what->size += child1->size;
#line 1003

#line 1003
  if (child1->fi_code != FI_CONSTANT)
#line 1003
    constargs = 0;
#line 1003

#line 1003
} while (child1 = child1->next);
#line 1003

#line 1003 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1003
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1003
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1035 "filter/f-inst.c"
what->type = T_NET;

#line 1038 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1038
    if (!constargs)
#line 1038
      return what;
#line 1038

#line 1038
    /* Try to pre-calculate the result */
#line 1038
    #line 1002 "filter/f-inst.c"
 { 	/* Get src prefix */
    
#line 1003 "filter/f-inst.c"
 #line 1003 "filter/f-inst.c"
 ;
#line 1004 "filter/f-inst.c"
    #line 1004 "filter/f-inst.c"
;

    net_addr_union *net = (void *) v1.val.net;
    net_addr *src = falloc(sizeof(net_addr_ip6));
    const byte *part;

    switch(v1.val.net->type) {
    case NET_FLOW4:
      part = flow4_get_part(&net->flow4, FLOW_TYPE_SRC_PREFIX);
      if (part)
	net_fill_ip4(src, flow_read_ip4_part(part), flow_read_pxlen(part));
      else
	net_fill_ip4(src, IP4_NONE, 0);
      break;

    case NET_FLOW6:
      part = flow6_get_part(&net->flow6, FLOW_TYPE_SRC_PREFIX);
      if (part)
	net_fill_ip6(src, flow_read_ip6_part(part), flow_read_pxlen(part));
      else
	net_fill_ip6(src, IP6_NONE, 0);
      break;

    case NET_IP6_SADR:
      net_fill_ip6(src, net->ip6_sadr.src_prefix, net->ip6_sadr.src_pxlen);
      break;

    default:
      runtime( "Flow or SADR expected" );
    }

     
#line 1035 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_NET, .val.net = src } );
  }

  
  #undef whati
#line 1038 "filter/f-inst.c"
  }
#line 1038

#line 1038

#line 1075 "filter/f-inst.c"
 /* Constructor for FI_NET_DST */
#line 1075
struct f_inst *
#line 1039 "filter/f-inst.c"
NONNULL(2)
#line 1075 "filter/f-inst.c"
f_new_inst_FI_NET_DST(enum f_instruction_code fi_code
#line 1039 "filter/f-inst.c"
  , struct f_inst * f1
#line 1075 "filter/f-inst.c"
)
#line 1075
  {
#line 1075
    /* Allocate the structure */
#line 1075
    struct f_inst *what = fi_new(fi_code);
#line 1075
    uint constargs = 1;
#line 1075

#line 1075
    /* Initialize all the members */
#line 1075
  #define whati (&(what->i_FI_NET_DST))
#line 1075
  #line 1039 "filter/f-inst.c"
whati->f1 = f1;
#line 1039
const struct f_inst *child1 = f1;
#line 1039
do {
#line 1039
  what->size += child1->size;
#line 1039

#line 1039
  if (child1->fi_code != FI_CONSTANT)
#line 1039
    constargs = 0;
#line 1039

#line 1039
} while (child1 = child1->next);
#line 1039

#line 1039 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1039
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1039
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1071 "filter/f-inst.c"
what->type = T_NET;

#line 1075 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1075
    if (!constargs)
#line 1075
      return what;
#line 1075

#line 1075
    /* Try to pre-calculate the result */
#line 1075
    #line 1038 "filter/f-inst.c"
 { 	/* Get dst prefix */
    
#line 1039 "filter/f-inst.c"
 #line 1039 "filter/f-inst.c"
 ;
#line 1040 "filter/f-inst.c"
    #line 1040 "filter/f-inst.c"
;

    net_addr_union *net = (void *) v1.val.net;
    net_addr *dst = falloc(sizeof(net_addr_ip6));
    const byte *part;

    switch(v1.val.net->type) {
    case NET_FLOW4:
      part = flow4_get_part(&net->flow4, FLOW_TYPE_DST_PREFIX);
      if (part)
	net_fill_ip4(dst, flow_read_ip4_part(part), flow_read_pxlen(part));
      else
	net_fill_ip4(dst, IP4_NONE, 0);
      break;

    case NET_FLOW6:
      part = flow6_get_part(&net->flow6, FLOW_TYPE_DST_PREFIX);
      if (part)
	net_fill_ip6(dst, flow_read_ip6_part(part), flow_read_pxlen(part));
      else
	net_fill_ip6(dst, IP6_NONE, 0);
      break;

    case NET_IP6_SADR:
      net_fill_ip6(dst, net->ip6_sadr.dst_prefix, net->ip6_sadr.dst_pxlen);
      break;

    default:
      runtime( "Flow or SADR expected" );
    }

     
#line 1071 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_NET, .val.net = dst } );
  }

  /* Get ROA max prefix length */
  
  #undef whati
#line 1075 "filter/f-inst.c"
  }
#line 1075

#line 1075

#line 1085 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__maxlen */
#line 1085
struct f_inst *
#line 1075 "filter/f-inst.c"
NONNULL(2)
#line 1085 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__maxlen(enum f_instruction_code fi_code
#line 1075 "filter/f-inst.c"
  , struct f_inst * f1
#line 1085 "filter/f-inst.c"
)
#line 1085
  {
#line 1085
    /* Allocate the structure */
#line 1085
    struct f_inst *what = fi_new(fi_code);
#line 1085
    uint constargs = 1;
#line 1085

#line 1085
    /* Initialize all the members */
#line 1085
  #define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1085
  #line 1075 "filter/f-inst.c"
whati->f1 = f1;
#line 1075
const struct f_inst *child1 = f1;
#line 1075
do {
#line 1075
  what->size += child1->size;
#line 1075

#line 1075
  if (child1->fi_code != FI_CONSTANT)
#line 1075
    constargs = 0;
#line 1075

#line 1075
} while (child1 = child1->next);
#line 1075

#line 1075 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1075
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1075
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1075 "filter/f-inst.c"
what->type = T_INT;

#line 1085 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1085
    if (!constargs)
#line 1085
      return what;
#line 1085

#line 1085
    /* Try to pre-calculate the result */
#line 1085
    #line 1075 "filter/f-inst.c"
 {
#line 1075
  
#line 1075 "filter/f-inst.c"
 #line 1075 "filter/f-inst.c"
 ;
#line 1075 "filter/f-inst.c"
  
#line 1075
    if (!net_is_roa(v1.val.net))
#line 1075
      runtime( "ROA expected" );
#line 1075

#line 1075
     
#line 1075 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = (v1.val.net->type == NET_ROA4) ?
#line 1075
      ((net_addr_roa4 *) v1.val.net)->max_pxlen :
#line 1075
      ((net_addr_roa6 *) v1.val.net)->max_pxlen } );
#line 1075
  
#line 1075
  #line 1075 "filter/f-inst.c"
;
#line 1075
};
#line 1083

  /* Get ROA ASN */
  
  #undef whati
#line 1085 "filter/f-inst.c"
  }
#line 1085

#line 1085

#line 1095 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__asn */
#line 1095
struct f_inst *
#line 1085 "filter/f-inst.c"
NONNULL(2)
#line 1095 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__asn(enum f_instruction_code fi_code
#line 1085 "filter/f-inst.c"
  , struct f_inst * f1
#line 1095 "filter/f-inst.c"
)
#line 1095
  {
#line 1095
    /* Allocate the structure */
#line 1095
    struct f_inst *what = fi_new(fi_code);
#line 1095
    uint constargs = 1;
#line 1095

#line 1095
    /* Initialize all the members */
#line 1095
  #define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1095
  #line 1085 "filter/f-inst.c"
whati->f1 = f1;
#line 1085
const struct f_inst *child1 = f1;
#line 1085
do {
#line 1085
  what->size += child1->size;
#line 1085

#line 1085
  if (child1->fi_code != FI_CONSTANT)
#line 1085
    constargs = 0;
#line 1085

#line 1085
} while (child1 = child1->next);
#line 1085

#line 1085 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1085
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1085
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1085 "filter/f-inst.c"
what->type = T_INT;

#line 1095 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1095
    if (!constargs)
#line 1095
      return what;
#line 1095

#line 1095
    /* Try to pre-calculate the result */
#line 1095
    #line 1085 "filter/f-inst.c"
 {
#line 1085
  
#line 1085 "filter/f-inst.c"
 #line 1085 "filter/f-inst.c"
 ;
#line 1085 "filter/f-inst.c"
  
#line 1085
        if (!net_is_roa(v1.val.net))
#line 1085
          runtime( "ROA expected" );
#line 1085

#line 1085
         
#line 1085 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = (v1.val.net->type == NET_ROA4) ?
#line 1085
          ((net_addr_roa4 *) v1.val.net)->asn :
#line 1085
          ((net_addr_roa6 *) v1.val.net)->asn } );
#line 1085
  
#line 1085
  #line 1085 "filter/f-inst.c"
;
#line 1085
};
#line 1093

  /* Convert prefix to IP */
  
  #undef whati
#line 1095 "filter/f-inst.c"
  }
#line 1095

#line 1095

#line 1097 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__ip */
#line 1097
struct f_inst *
#line 1095 "filter/f-inst.c"
NONNULL(2)
#line 1097 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__ip(enum f_instruction_code fi_code
#line 1095 "filter/f-inst.c"
  , struct f_inst * f1
#line 1097 "filter/f-inst.c"
)
#line 1097
  {
#line 1097
    /* Allocate the structure */
#line 1097
    struct f_inst *what = fi_new(fi_code);
#line 1097
    uint constargs = 1;
#line 1097

#line 1097
    /* Initialize all the members */
#line 1097
  #define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1097
  #line 1095 "filter/f-inst.c"
whati->f1 = f1;
#line 1095
const struct f_inst *child1 = f1;
#line 1095
do {
#line 1095
  what->size += child1->size;
#line 1095

#line 1095
  if (child1->fi_code != FI_CONSTANT)
#line 1095
    constargs = 0;
#line 1095

#line 1095
} while (child1 = child1->next);
#line 1095

#line 1095 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1095
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1095
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1095 "filter/f-inst.c"
what->type = T_IP;

#line 1097 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1097
    if (!constargs)
#line 1097
      return what;
#line 1097

#line 1097
    /* Try to pre-calculate the result */
#line 1097
    #line 1095 "filter/f-inst.c"
 {
#line 1095
  
#line 1095 "filter/f-inst.c"
 #line 1095 "filter/f-inst.c"
 ;
#line 1095 "filter/f-inst.c"
    
#line 1095 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip = net_prefix(v1.val.net) } ) 
#line 1095
  #line 1095 "filter/f-inst.c"
;
#line 1095
};

  
  #undef whati
#line 1097 "filter/f-inst.c"
  }
#line 1097

#line 1097

#line 1106 "filter/f-inst.c"
 /* Constructor for FI_ROUTE_DISTINGUISHER */
#line 1106
struct f_inst *
#line 1098 "filter/f-inst.c"
NONNULL(2)
#line 1106 "filter/f-inst.c"
f_new_inst_FI_ROUTE_DISTINGUISHER(enum f_instruction_code fi_code
#line 1098 "filter/f-inst.c"
  , struct f_inst * f1
#line 1106 "filter/f-inst.c"
)
#line 1106
  {
#line 1106
    /* Allocate the structure */
#line 1106
    struct f_inst *what = fi_new(fi_code);
#line 1106
    uint constargs = 1;
#line 1106

#line 1106
    /* Initialize all the members */
#line 1106
  #define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1106
  #line 1098 "filter/f-inst.c"
whati->f1 = f1;
#line 1098
const struct f_inst *child1 = f1;
#line 1098
do {
#line 1098
  what->size += child1->size;
#line 1098

#line 1098
  if (child1->fi_code != FI_CONSTANT)
#line 1098
    constargs = 0;
#line 1098

#line 1098
} while (child1 = child1->next);
#line 1098

#line 1098 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1098
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1098
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1102 "filter/f-inst.c"
what->type = T_RD;

#line 1106 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1106
    if (!constargs)
#line 1106
      return what;
#line 1106

#line 1106
    /* Try to pre-calculate the result */
#line 1106
    #line 1097 "filter/f-inst.c"
 {
    
#line 1098 "filter/f-inst.c"
 #line 1098 "filter/f-inst.c"
 ;
#line 1099 "filter/f-inst.c"
    #line 1099 "filter/f-inst.c"
;
    if (!net_is_vpn(v1.val.net))
      runtime( "VPN address expected" );
     
#line 1102 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_RD, .val.rd = net_rd(v1.val.net) } );
  }

  /* Get first ASN from AS PATH */
  
  #undef whati
#line 1106 "filter/f-inst.c"
  }
#line 1106

#line 1106

#line 1109 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__first */
#line 1109
struct f_inst *
#line 1106 "filter/f-inst.c"
NONNULL(2)
#line 1109 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__first(enum f_instruction_code fi_code
#line 1106 "filter/f-inst.c"
  , struct f_inst * f1
#line 1109 "filter/f-inst.c"
)
#line 1109
  {
#line 1109
    /* Allocate the structure */
#line 1109
    struct f_inst *what = fi_new(fi_code);
#line 1109
    uint constargs = 1;
#line 1109

#line 1109
    /* Initialize all the members */
#line 1109
  #define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1109
  #line 1106 "filter/f-inst.c"
whati->f1 = f1;
#line 1106
const struct f_inst *child1 = f1;
#line 1106
do {
#line 1106
  what->size += child1->size;
#line 1106

#line 1106
  if (child1->fi_code != FI_CONSTANT)
#line 1106
    constargs = 0;
#line 1106

#line 1106
} while (child1 = child1->next);
#line 1106

#line 1106 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1106
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1106
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1106 "filter/f-inst.c"
what->type = T_INT;

#line 1109 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1109
    if (!constargs)
#line 1109
      return what;
#line 1109

#line 1109
    /* Try to pre-calculate the result */
#line 1109
    #line 1106 "filter/f-inst.c"
 {
#line 1106
  
#line 1106 "filter/f-inst.c"
 #line 1106 "filter/f-inst.c"
 ;
#line 1106 "filter/f-inst.c"
    
#line 1106 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ({ u32 as = 0; as_path_get_first(v1.val.ad, &as); as; }) } ) 
#line 1106
  #line 1106 "filter/f-inst.c"
;
#line 1106
};

  /* Get last ASN from AS PATH */
  
  #undef whati
#line 1109 "filter/f-inst.c"
  }
#line 1109

#line 1109

#line 1112 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__last */
#line 1112
struct f_inst *
#line 1109 "filter/f-inst.c"
NONNULL(2)
#line 1112 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__last(enum f_instruction_code fi_code
#line 1109 "filter/f-inst.c"
  , struct f_inst * f1
#line 1112 "filter/f-inst.c"
)
#line 1112
  {
#line 1112
    /* Allocate the structure */
#line 1112
    struct f_inst *what = fi_new(fi_code);
#line 1112
    uint constargs = 1;
#line 1112

#line 1112
    /* Initialize all the members */
#line 1112
  #define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1112
  #line 1109 "filter/f-inst.c"
whati->f1 = f1;
#line 1109
const struct f_inst *child1 = f1;
#line 1109
do {
#line 1109
  what->size += child1->size;
#line 1109

#line 1109
  if (child1->fi_code != FI_CONSTANT)
#line 1109
    constargs = 0;
#line 1109

#line 1109
} while (child1 = child1->next);
#line 1109

#line 1109 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1109
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1109
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1109 "filter/f-inst.c"
what->type = T_INT;

#line 1112 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1112
    if (!constargs)
#line 1112
      return what;
#line 1112

#line 1112
    /* Try to pre-calculate the result */
#line 1112
    #line 1109 "filter/f-inst.c"
 {
#line 1109
  
#line 1109 "filter/f-inst.c"
 #line 1109 "filter/f-inst.c"
 ;
#line 1109 "filter/f-inst.c"
    
#line 1109 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ({ u32 as = 0; as_path_get_last(v1.val.ad, &as); as; }) } ) 
#line 1109
  #line 1109 "filter/f-inst.c"
;
#line 1109
};

  /* Get last ASN from non-aggregated part of AS PATH */
  
  #undef whati
#line 1112 "filter/f-inst.c"
  }
#line 1112

#line 1112

#line 1115 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
struct f_inst *
#line 1112 "filter/f-inst.c"
NONNULL(2)
#line 1115 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__last_nonaggregated(enum f_instruction_code fi_code
#line 1112 "filter/f-inst.c"
  , struct f_inst * f1
#line 1115 "filter/f-inst.c"
)
#line 1115
  {
#line 1115
    /* Allocate the structure */
#line 1115
    struct f_inst *what = fi_new(fi_code);
#line 1115
    uint constargs = 1;
#line 1115

#line 1115
    /* Initialize all the members */
#line 1115
  #define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
  #line 1112 "filter/f-inst.c"
whati->f1 = f1;
#line 1112
const struct f_inst *child1 = f1;
#line 1112
do {
#line 1112
  what->size += child1->size;
#line 1112

#line 1112
  if (child1->fi_code != FI_CONSTANT)
#line 1112
    constargs = 0;
#line 1112

#line 1112
} while (child1 = child1->next);
#line 1112

#line 1112 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1112
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1112
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1112 "filter/f-inst.c"
what->type = T_INT;

#line 1115 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1115
    if (!constargs)
#line 1115
      return what;
#line 1115

#line 1115
    /* Try to pre-calculate the result */
#line 1115
    #line 1112 "filter/f-inst.c"
 {
#line 1112
  
#line 1112 "filter/f-inst.c"
 #line 1112 "filter/f-inst.c"
 ;
#line 1112 "filter/f-inst.c"
    
#line 1112 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = as_path_get_last_nonaggregated(v1.val.ad) } ) 
#line 1112
  #line 1112 "filter/f-inst.c"
;
#line 1112
};

  /* Get ASN part from the standard community ASN */
  
  #undef whati
#line 1115 "filter/f-inst.c"
  }
#line 1115

#line 1115

#line 1118 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PAIR__asn */
#line 1118
struct f_inst *
#line 1115 "filter/f-inst.c"
NONNULL(2)
#line 1118 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PAIR__asn(enum f_instruction_code fi_code
#line 1115 "filter/f-inst.c"
  , struct f_inst * f1
#line 1118 "filter/f-inst.c"
)
#line 1118
  {
#line 1118
    /* Allocate the structure */
#line 1118
    struct f_inst *what = fi_new(fi_code);
#line 1118
    uint constargs = 1;
#line 1118

#line 1118
    /* Initialize all the members */
#line 1118
  #define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1118
  #line 1115 "filter/f-inst.c"
whati->f1 = f1;
#line 1115
const struct f_inst *child1 = f1;
#line 1115
do {
#line 1115
  what->size += child1->size;
#line 1115

#line 1115
  if (child1->fi_code != FI_CONSTANT)
#line 1115
    constargs = 0;
#line 1115

#line 1115
} while (child1 = child1->next);
#line 1115

#line 1115 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PAIR)) && !f_const_promotion(f1, (T_PAIR)))
#line 1115
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1115
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f1->type));
#line 1115 "filter/f-inst.c"
what->type = T_INT;

#line 1118 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1118
    if (!constargs)
#line 1118
      return what;
#line 1118

#line 1118
    /* Try to pre-calculate the result */
#line 1118
    #line 1115 "filter/f-inst.c"
 {
#line 1115
  
#line 1115 "filter/f-inst.c"
 #line 1115 "filter/f-inst.c"
 ;
#line 1115 "filter/f-inst.c"
    
#line 1115 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i >> 16 } ) 
#line 1115
  #line 1115 "filter/f-inst.c"
;
#line 1115
};

  /* Get data part from the standard community */
  
  #undef whati
#line 1118 "filter/f-inst.c"
  }
#line 1118

#line 1118

#line 1121 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PAIR__data */
#line 1121
struct f_inst *
#line 1118 "filter/f-inst.c"
NONNULL(2)
#line 1121 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PAIR__data(enum f_instruction_code fi_code
#line 1118 "filter/f-inst.c"
  , struct f_inst * f1
#line 1121 "filter/f-inst.c"
)
#line 1121
  {
#line 1121
    /* Allocate the structure */
#line 1121
    struct f_inst *what = fi_new(fi_code);
#line 1121
    uint constargs = 1;
#line 1121

#line 1121
    /* Initialize all the members */
#line 1121
  #define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1121
  #line 1118 "filter/f-inst.c"
whati->f1 = f1;
#line 1118
const struct f_inst *child1 = f1;
#line 1118
do {
#line 1118
  what->size += child1->size;
#line 1118

#line 1118
  if (child1->fi_code != FI_CONSTANT)
#line 1118
    constargs = 0;
#line 1118

#line 1118
} while (child1 = child1->next);
#line 1118

#line 1118 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PAIR)) && !f_const_promotion(f1, (T_PAIR)))
#line 1118
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1118
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f1->type));
#line 1118 "filter/f-inst.c"
what->type = T_INT;

#line 1121 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1121
    if (!constargs)
#line 1121
      return what;
#line 1121

#line 1121
    /* Try to pre-calculate the result */
#line 1121
    #line 1118 "filter/f-inst.c"
 {
#line 1118
  
#line 1118 "filter/f-inst.c"
 #line 1118 "filter/f-inst.c"
 ;
#line 1118 "filter/f-inst.c"
    
#line 1118 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i & 0xFFFF } ) 
#line 1118
  #line 1118 "filter/f-inst.c"
;
#line 1118
};

  /* Get ASN part from the large community */
  
  #undef whati
#line 1121 "filter/f-inst.c"
  }
#line 1121

#line 1121

#line 1124 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__asn */
#line 1124
struct f_inst *
#line 1121 "filter/f-inst.c"
NONNULL(2)
#line 1124 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__asn(enum f_instruction_code fi_code
#line 1121 "filter/f-inst.c"
  , struct f_inst * f1
#line 1124 "filter/f-inst.c"
)
#line 1124
  {
#line 1124
    /* Allocate the structure */
#line 1124
    struct f_inst *what = fi_new(fi_code);
#line 1124
    uint constargs = 1;
#line 1124

#line 1124
    /* Initialize all the members */
#line 1124
  #define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1124
  #line 1121 "filter/f-inst.c"
whati->f1 = f1;
#line 1121
const struct f_inst *child1 = f1;
#line 1121
do {
#line 1121
  what->size += child1->size;
#line 1121

#line 1121
  if (child1->fi_code != FI_CONSTANT)
#line 1121
    constargs = 0;
#line 1121

#line 1121
} while (child1 = child1->next);
#line 1121

#line 1121 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1121
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1121
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1121 "filter/f-inst.c"
what->type = T_INT;

#line 1124 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1124
    if (!constargs)
#line 1124
      return what;
#line 1124

#line 1124
    /* Try to pre-calculate the result */
#line 1124
    #line 1121 "filter/f-inst.c"
 {
#line 1121
  
#line 1121 "filter/f-inst.c"
 #line 1121 "filter/f-inst.c"
 ;
#line 1121 "filter/f-inst.c"
    
#line 1121 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.asn } ) 
#line 1121
  #line 1121 "filter/f-inst.c"
;
#line 1121
};

  /* Get data1 part from the large community */
  
  #undef whati
#line 1124 "filter/f-inst.c"
  }
#line 1124

#line 1124

#line 1127 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__data1 */
#line 1127
struct f_inst *
#line 1124 "filter/f-inst.c"
NONNULL(2)
#line 1127 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__data1(enum f_instruction_code fi_code
#line 1124 "filter/f-inst.c"
  , struct f_inst * f1
#line 1127 "filter/f-inst.c"
)
#line 1127
  {
#line 1127
    /* Allocate the structure */
#line 1127
    struct f_inst *what = fi_new(fi_code);
#line 1127
    uint constargs = 1;
#line 1127

#line 1127
    /* Initialize all the members */
#line 1127
  #define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1127
  #line 1124 "filter/f-inst.c"
whati->f1 = f1;
#line 1124
const struct f_inst *child1 = f1;
#line 1124
do {
#line 1124
  what->size += child1->size;
#line 1124

#line 1124
  if (child1->fi_code != FI_CONSTANT)
#line 1124
    constargs = 0;
#line 1124

#line 1124
} while (child1 = child1->next);
#line 1124

#line 1124 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1124
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1124
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1124 "filter/f-inst.c"
what->type = T_INT;

#line 1127 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1127
    if (!constargs)
#line 1127
      return what;
#line 1127

#line 1127
    /* Try to pre-calculate the result */
#line 1127
    #line 1124 "filter/f-inst.c"
 {
#line 1124
  
#line 1124 "filter/f-inst.c"
 #line 1124 "filter/f-inst.c"
 ;
#line 1124 "filter/f-inst.c"
    
#line 1124 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.ldp1 } ) 
#line 1124
  #line 1124 "filter/f-inst.c"
;
#line 1124
};

  /* Get data2 part from the large community */
  
  #undef whati
#line 1127 "filter/f-inst.c"
  }
#line 1127

#line 1127

#line 1130 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__data2 */
#line 1130
struct f_inst *
#line 1127 "filter/f-inst.c"
NONNULL(2)
#line 1130 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__data2(enum f_instruction_code fi_code
#line 1127 "filter/f-inst.c"
  , struct f_inst * f1
#line 1130 "filter/f-inst.c"
)
#line 1130
  {
#line 1130
    /* Allocate the structure */
#line 1130
    struct f_inst *what = fi_new(fi_code);
#line 1130
    uint constargs = 1;
#line 1130

#line 1130
    /* Initialize all the members */
#line 1130
  #define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1130
  #line 1127 "filter/f-inst.c"
whati->f1 = f1;
#line 1127
const struct f_inst *child1 = f1;
#line 1127
do {
#line 1127
  what->size += child1->size;
#line 1127

#line 1127
  if (child1->fi_code != FI_CONSTANT)
#line 1127
    constargs = 0;
#line 1127

#line 1127
} while (child1 = child1->next);
#line 1127

#line 1127 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1127
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1127
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1127 "filter/f-inst.c"
what->type = T_INT;

#line 1130 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1130
    if (!constargs)
#line 1130
      return what;
#line 1130

#line 1130
    /* Try to pre-calculate the result */
#line 1130
    #line 1127 "filter/f-inst.c"
 {
#line 1127
  
#line 1127 "filter/f-inst.c"
 #line 1127 "filter/f-inst.c"
 ;
#line 1127 "filter/f-inst.c"
    
#line 1127 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.ldp2 } ) 
#line 1127
  #line 1127 "filter/f-inst.c"
;
#line 1127
};

  /* Get minimum element from clist */
  
  #undef whati
#line 1130 "filter/f-inst.c"
  }
#line 1130

#line 1130

#line 1133 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__min */
#line 1133
struct f_inst *
#line 1130 "filter/f-inst.c"
NONNULL(2)
#line 1133 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__min(enum f_instruction_code fi_code
#line 1130 "filter/f-inst.c"
  , struct f_inst * f1
#line 1133 "filter/f-inst.c"
)
#line 1133
  {
#line 1133
    /* Allocate the structure */
#line 1133
    struct f_inst *what = fi_new(fi_code);
#line 1133
    uint constargs = 1;
#line 1133

#line 1133
    /* Initialize all the members */
#line 1133
  #define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1133
  #line 1130 "filter/f-inst.c"
whati->f1 = f1;
#line 1130
const struct f_inst *child1 = f1;
#line 1130
do {
#line 1130
  what->size += child1->size;
#line 1130

#line 1130
  if (child1->fi_code != FI_CONSTANT)
#line 1130
    constargs = 0;
#line 1130

#line 1130
} while (child1 = child1->next);
#line 1130

#line 1130 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1130
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1130
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1130 "filter/f-inst.c"
what->type = T_PAIR;

#line 1133 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1133
    if (!constargs)
#line 1133
      return what;
#line 1133

#line 1133
    /* Try to pre-calculate the result */
#line 1133
    #line 1130 "filter/f-inst.c"
 {
#line 1130
  
#line 1130 "filter/f-inst.c"
 #line 1130 "filter/f-inst.c"
 ;
#line 1130 "filter/f-inst.c"
    
#line 1130 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = ({ u32 val = 0; int_set_min(v1.val.ad, &val); val; }) } ) 
#line 1130
  #line 1130 "filter/f-inst.c"
;
#line 1130
};

  /* Get maximum element from clist */
  
  #undef whati
#line 1133 "filter/f-inst.c"
  }
#line 1133

#line 1133

#line 1136 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__max */
#line 1136
struct f_inst *
#line 1133 "filter/f-inst.c"
NONNULL(2)
#line 1136 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__max(enum f_instruction_code fi_code
#line 1133 "filter/f-inst.c"
  , struct f_inst * f1
#line 1136 "filter/f-inst.c"
)
#line 1136
  {
#line 1136
    /* Allocate the structure */
#line 1136
    struct f_inst *what = fi_new(fi_code);
#line 1136
    uint constargs = 1;
#line 1136

#line 1136
    /* Initialize all the members */
#line 1136
  #define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1136
  #line 1133 "filter/f-inst.c"
whati->f1 = f1;
#line 1133
const struct f_inst *child1 = f1;
#line 1133
do {
#line 1133
  what->size += child1->size;
#line 1133

#line 1133
  if (child1->fi_code != FI_CONSTANT)
#line 1133
    constargs = 0;
#line 1133

#line 1133
} while (child1 = child1->next);
#line 1133

#line 1133 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1133
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1133
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1133 "filter/f-inst.c"
what->type = T_PAIR;

#line 1136 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1136
    if (!constargs)
#line 1136
      return what;
#line 1136

#line 1136
    /* Try to pre-calculate the result */
#line 1136
    #line 1133 "filter/f-inst.c"
 {
#line 1133
  
#line 1133 "filter/f-inst.c"
 #line 1133 "filter/f-inst.c"
 ;
#line 1133 "filter/f-inst.c"
    
#line 1133 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = ({ u32 val = 0; int_set_max(v1.val.ad, &val); val; }) } ) 
#line 1133
  #line 1133 "filter/f-inst.c"
;
#line 1133
};

  /* Get minimum element from eclist */
  
  #undef whati
#line 1136 "filter/f-inst.c"
  }
#line 1136

#line 1136

#line 1139 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__min */
#line 1139
struct f_inst *
#line 1136 "filter/f-inst.c"
NONNULL(2)
#line 1139 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__min(enum f_instruction_code fi_code
#line 1136 "filter/f-inst.c"
  , struct f_inst * f1
#line 1139 "filter/f-inst.c"
)
#line 1139
  {
#line 1139
    /* Allocate the structure */
#line 1139
    struct f_inst *what = fi_new(fi_code);
#line 1139
    uint constargs = 1;
#line 1139

#line 1139
    /* Initialize all the members */
#line 1139
  #define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1139
  #line 1136 "filter/f-inst.c"
whati->f1 = f1;
#line 1136
const struct f_inst *child1 = f1;
#line 1136
do {
#line 1136
  what->size += child1->size;
#line 1136

#line 1136
  if (child1->fi_code != FI_CONSTANT)
#line 1136
    constargs = 0;
#line 1136

#line 1136
} while (child1 = child1->next);
#line 1136

#line 1136 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1136
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1136
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1136 "filter/f-inst.c"
what->type = T_EC;

#line 1139 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1139
    if (!constargs)
#line 1139
      return what;
#line 1139

#line 1139
    /* Try to pre-calculate the result */
#line 1139
    #line 1136 "filter/f-inst.c"
 {
#line 1136
  
#line 1136 "filter/f-inst.c"
 #line 1136 "filter/f-inst.c"
 ;
#line 1136 "filter/f-inst.c"
    
#line 1136 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ({ u64 val = 0; ec_set_min(v1.val.ad, &val); val; }) } ) 
#line 1136
  #line 1136 "filter/f-inst.c"
;
#line 1136
};

  /* Get maximum element from eclist */
  
  #undef whati
#line 1139 "filter/f-inst.c"
  }
#line 1139

#line 1139

#line 1142 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__max */
#line 1142
struct f_inst *
#line 1139 "filter/f-inst.c"
NONNULL(2)
#line 1142 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__max(enum f_instruction_code fi_code
#line 1139 "filter/f-inst.c"
  , struct f_inst * f1
#line 1142 "filter/f-inst.c"
)
#line 1142
  {
#line 1142
    /* Allocate the structure */
#line 1142
    struct f_inst *what = fi_new(fi_code);
#line 1142
    uint constargs = 1;
#line 1142

#line 1142
    /* Initialize all the members */
#line 1142
  #define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1142
  #line 1139 "filter/f-inst.c"
whati->f1 = f1;
#line 1139
const struct f_inst *child1 = f1;
#line 1139
do {
#line 1139
  what->size += child1->size;
#line 1139

#line 1139
  if (child1->fi_code != FI_CONSTANT)
#line 1139
    constargs = 0;
#line 1139

#line 1139
} while (child1 = child1->next);
#line 1139

#line 1139 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1139
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1139
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1139 "filter/f-inst.c"
what->type = T_EC;

#line 1142 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1142
    if (!constargs)
#line 1142
      return what;
#line 1142

#line 1142
    /* Try to pre-calculate the result */
#line 1142
    #line 1139 "filter/f-inst.c"
 {
#line 1139
  
#line 1139 "filter/f-inst.c"
 #line 1139 "filter/f-inst.c"
 ;
#line 1139 "filter/f-inst.c"
    
#line 1139 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ({ u64 val = 0; ec_set_max(v1.val.ad, &val); val; }) } ) 
#line 1139
  #line 1139 "filter/f-inst.c"
;
#line 1139
};

  /* Get minimum element from lclist */
  
  #undef whati
#line 1142 "filter/f-inst.c"
  }
#line 1142

#line 1142

#line 1145 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__min */
#line 1145
struct f_inst *
#line 1142 "filter/f-inst.c"
NONNULL(2)
#line 1145 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__min(enum f_instruction_code fi_code
#line 1142 "filter/f-inst.c"
  , struct f_inst * f1
#line 1145 "filter/f-inst.c"
)
#line 1145
  {
#line 1145
    /* Allocate the structure */
#line 1145
    struct f_inst *what = fi_new(fi_code);
#line 1145
    uint constargs = 1;
#line 1145

#line 1145
    /* Initialize all the members */
#line 1145
  #define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1145
  #line 1142 "filter/f-inst.c"
whati->f1 = f1;
#line 1142
const struct f_inst *child1 = f1;
#line 1142
do {
#line 1142
  what->size += child1->size;
#line 1142

#line 1142
  if (child1->fi_code != FI_CONSTANT)
#line 1142
    constargs = 0;
#line 1142

#line 1142
} while (child1 = child1->next);
#line 1142

#line 1142 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1142
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1142
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1142 "filter/f-inst.c"
what->type = T_LC;

#line 1145 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1145
    if (!constargs)
#line 1145
      return what;
#line 1145

#line 1145
    /* Try to pre-calculate the result */
#line 1145
    #line 1142 "filter/f-inst.c"
 {
#line 1142
  
#line 1142 "filter/f-inst.c"
 #line 1142 "filter/f-inst.c"
 ;
#line 1142 "filter/f-inst.c"
    
#line 1142 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = ({ lcomm val = {}; lc_set_min(v1.val.ad, &val); val; }) } ) 
#line 1142
  #line 1142 "filter/f-inst.c"
;
#line 1142
};

  /* Get maximum element from lclist */
  
  #undef whati
#line 1145 "filter/f-inst.c"
  }
#line 1145

#line 1145

#line 1147 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__max */
#line 1147
struct f_inst *
#line 1145 "filter/f-inst.c"
NONNULL(2)
#line 1147 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__max(enum f_instruction_code fi_code
#line 1145 "filter/f-inst.c"
  , struct f_inst * f1
#line 1147 "filter/f-inst.c"
)
#line 1147
  {
#line 1147
    /* Allocate the structure */
#line 1147
    struct f_inst *what = fi_new(fi_code);
#line 1147
    uint constargs = 1;
#line 1147

#line 1147
    /* Initialize all the members */
#line 1147
  #define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1147
  #line 1145 "filter/f-inst.c"
whati->f1 = f1;
#line 1145
const struct f_inst *child1 = f1;
#line 1145
do {
#line 1145
  what->size += child1->size;
#line 1145

#line 1145
  if (child1->fi_code != FI_CONSTANT)
#line 1145
    constargs = 0;
#line 1145

#line 1145
} while (child1 = child1->next);
#line 1145

#line 1145 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1145
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1145
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1145 "filter/f-inst.c"
what->type = T_LC;

#line 1147 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1147
    if (!constargs)
#line 1147
      return what;
#line 1147

#line 1147
    /* Try to pre-calculate the result */
#line 1147
    #line 1145 "filter/f-inst.c"
 {
#line 1145
  
#line 1145 "filter/f-inst.c"
 #line 1145 "filter/f-inst.c"
 ;
#line 1145 "filter/f-inst.c"
    
#line 1145 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = ({ lcomm val = {}; lc_set_max(v1.val.ad, &val); val; }) } ) 
#line 1145
  #line 1145 "filter/f-inst.c"
;
#line 1145
};

  
  #undef whati
#line 1147 "filter/f-inst.c"
  }
#line 1147

#line 1147

#line 1173 "filter/f-inst.c"
 /* Constructor for FI_RETURN */
#line 1173
struct f_inst *
#line 1150 "filter/f-inst.c"
NONNULL(2)
#line 1173 "filter/f-inst.c"
f_new_inst_FI_RETURN(enum f_instruction_code fi_code
#line 1150 "filter/f-inst.c"
  , struct f_inst * f1
#line 1173 "filter/f-inst.c"
)
#line 1173
  {
#line 1173
    /* Allocate the structure */
#line 1173
    struct f_inst *what = fi_new(fi_code);
#line 1173
    
#line 1173

#line 1173
    /* Initialize all the members */
#line 1173
  #define whati (&(what->i_FI_RETURN))
#line 1173
  #line 1150 "filter/f-inst.c"
whati->f1 = f1;
#line 1150
const struct f_inst *child1 = f1;
#line 1150
do {
#line 1150
  what->size += child1->size;
#line 1150

#line 1150
} while (child1 = child1->next);
#line 1150


#line 1173 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1173
    
#line 1173
      return what;
#line 1173

#line 1173
    /* Try to pre-calculate the result */
#line 1173
      #undef whati
#line 1173
  }
#line 1173

#line 1173

#line 1233 "filter/f-inst.c"
 /* Constructor for FI_CALL */
#line 1233
struct f_inst *
#line 1233
f_new_inst_FI_CALL(enum f_instruction_code fi_code
#line 1175 "filter/f-inst.c"
  , struct f_inst * fvar
#line 1176 "filter/f-inst.c"
  , struct symbol * sym
#line 1233 "filter/f-inst.c"
)
#line 1233
  {
#line 1233
    /* Allocate the structure */
#line 1233
    struct f_inst *what = fi_new(fi_code);
#line 1233
    
#line 1233

#line 1233
    /* Initialize all the members */
#line 1233
  #define whati (&(what->i_FI_CALL))
#line 1233
  #line 1175 "filter/f-inst.c"
whati->varcount = 0;
#line 1175
whati->fvar = fvar;
#line 1175
for (const struct f_inst *child = fvar; child; child = child->next, whati->varcount++) {
#line 1175
  what->size += child->size;
#line 1175

#line 1175
}
#line 1175

#line 1176 "filter/f-inst.c"
whati->sym = sym;
#line 1177 "filter/f-inst.c"
what->type = sym->function->return_type;

#line 1180 "filter/f-inst.c"
    ASSERT(sym->class == SYM_FUNCTION);

    if (whati->varcount != sym->function->args)
      cf_error("Function '%s' expects %u arguments, got %u arguments",
	       sym->name, sym->function->args, whati->varcount);

    /* Typecheck individual arguments */
    struct f_inst *a = fvar;
    struct f_arg *b = sym->function->arg_list;
    for (uint i = 1; a && b; a = a->next, b = b->next, i++)
    {
      enum btype b_type = b->arg->class & 0xff;

      if (a->type && (a->type != b_type) && !f_const_promotion(a, b_type))
	cf_error("Argument %u of '%s' must be %s, got %s",
		 i, sym->name, f_type_name(b_type), f_type_name(a->type));
    }
    ASSERT(!a && !b);

    /* Add implicit void slot for the return value */
    struct f_inst *tmp = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_VOID });
    tmp->next = whati->fvar;
    whati->fvar = tmp;
    what->size += tmp->size;

    /* Mark recursive calls, they have dummy f_line */
    if (!sym->function->len)
      what->flags |= FIF_RECURSIVE;

    
#line 1233 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1233
    
#line 1233
      return what;
#line 1233

#line 1233
    /* Try to pre-calculate the result */
#line 1233
      #undef whati
#line 1233
  }
#line 1233

#line 1233

#line 1238 "filter/f-inst.c"
 /* Constructor for FI_DROP_RESULT */
#line 1238
struct f_inst *
#line 1235 "filter/f-inst.c"
NONNULL(2)
#line 1238 "filter/f-inst.c"
f_new_inst_FI_DROP_RESULT(enum f_instruction_code fi_code
#line 1235 "filter/f-inst.c"
  , struct f_inst * f1
#line 1238 "filter/f-inst.c"
)
#line 1238
  {
#line 1238
    /* Allocate the structure */
#line 1238
    struct f_inst *what = fi_new(fi_code);
#line 1238
    
#line 1238

#line 1238
    /* Initialize all the members */
#line 1238
  #define whati (&(what->i_FI_DROP_RESULT))
#line 1238
  #line 1235 "filter/f-inst.c"
whati->f1 = f1;
#line 1235
const struct f_inst *child1 = f1;
#line 1235
do {
#line 1235
  what->size += child1->size;
#line 1235

#line 1235
} while (child1 = child1->next);
#line 1235


#line 1238 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1238
    
#line 1238
      return what;
#line 1238

#line 1238
    /* Try to pre-calculate the result */
#line 1238
      #undef whati
#line 1238
  }
#line 1238

#line 1238

#line 1282 "filter/f-inst.c"
 /* Constructor for FI_SWITCH */
#line 1282
struct f_inst *
#line 1239 "filter/f-inst.c"
NONNULL(2)
#line 1282 "filter/f-inst.c"
f_new_inst_FI_SWITCH(enum f_instruction_code fi_code
#line 1239 "filter/f-inst.c"
  , struct f_inst * f1
#line 1241 "filter/f-inst.c"
  , struct f_tree * tree
#line 1282 "filter/f-inst.c"
)
#line 1282
  {
#line 1282
    /* Allocate the structure */
#line 1282
    struct f_inst *what = fi_new(fi_code);
#line 1282
    uint constargs = 1;
#line 1282

#line 1282
    /* Initialize all the members */
#line 1282
  #define whati (&(what->i_FI_SWITCH))
#line 1282
  #line 1239 "filter/f-inst.c"
whati->f1 = f1;
#line 1239
const struct f_inst *child1 = f1;
#line 1239
do {
#line 1239
  what->size += child1->size;
#line 1239

#line 1239
  if (child1->fi_code != FI_CONSTANT)
#line 1239
    constargs = 0;
#line 1239

#line 1239
} while (child1 = child1->next);
#line 1239

#line 1241 "filter/f-inst.c"
whati->tree = tree;

#line 1282 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1282
    if (!constargs)
#line 1282
      return what;
#line 1282

#line 1282
    /* Try to pre-calculate the result */
#line 1282
    #line 1238 "filter/f-inst.c"
 {
    
#line 1239 "filter/f-inst.c"
;

    #line 1241 "filter/f-inst.c"
;

    
#line 1268 "filter/f-inst.c"
    /* In parse-time use find_tree_linear(), in runtime use find_tree() */
    const struct f_tree *t = find_tree_linear(tree, &v1);
    if (!t) {
      v1.type = T_VOID;
      t = find_tree_linear(tree, &v1);
      if (!t) {
	debug( "No else statement?\n");
	return NULL;
      }
    }

    return t->data ;
#line 1280 "filter/f-inst.c"
  }

  
  #undef whati
#line 1282 "filter/f-inst.c"
  }
#line 1282

#line 1282

#line 1291 "filter/f-inst.c"
 /* Constructor for FI_IP_MASK */
#line 1291
struct f_inst *
#line 1283 "filter/f-inst.c"
NONNULL(2)
#line 1284 "filter/f-inst.c"
NONNULL(3)
#line 1291 "filter/f-inst.c"
f_new_inst_FI_IP_MASK(enum f_instruction_code fi_code
#line 1283 "filter/f-inst.c"
  , struct f_inst * f1
#line 1284 "filter/f-inst.c"
  , struct f_inst * f2
#line 1291 "filter/f-inst.c"
)
#line 1291
  {
#line 1291
    /* Allocate the structure */
#line 1291
    struct f_inst *what = fi_new(fi_code);
#line 1291
    uint constargs = 1;
#line 1291

#line 1291
    /* Initialize all the members */
#line 1291
  #define whati (&(what->i_FI_IP_MASK))
#line 1291
  #line 1283 "filter/f-inst.c"
whati->f1 = f1;
#line 1283
const struct f_inst *child1 = f1;
#line 1283
do {
#line 1283
  what->size += child1->size;
#line 1283

#line 1283
  if (child1->fi_code != FI_CONSTANT)
#line 1283
    constargs = 0;
#line 1283

#line 1283
} while (child1 = child1->next);
#line 1283

#line 1283 "filter/f-inst.c"
if (f1->type && (f1->type != (T_IP)) && !f_const_promotion(f1, (T_IP)))
#line 1283
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1283
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f1->type));
#line 1284 "filter/f-inst.c"
whati->f2 = f2;
#line 1284
const struct f_inst *child2 = f2;
#line 1284
do {
#line 1284
  what->size += child2->size;
#line 1284

#line 1284
  if (child2->fi_code != FI_CONSTANT)
#line 1284
    constargs = 0;
#line 1284

#line 1284
} while (child2 = child2->next);
#line 1284 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1284
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1284
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1286 "filter/f-inst.c"
what->type = T_IP;

#line 1291 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1291
    if (!constargs)
#line 1291
      return what;
#line 1291

#line 1291
    /* Try to pre-calculate the result */
#line 1291
    #line 1282 "filter/f-inst.c"
 { /* IP.MASK(val) */
    
#line 1283 "filter/f-inst.c"
 #line 1283 "filter/f-inst.c"
 ;
#line 1284 "filter/f-inst.c"
    
#line 1284 "filter/f-inst.c"
 #line 1284 "filter/f-inst.c"
 ;
#line 1285 "filter/f-inst.c"
    #line 1285 "filter/f-inst.c"
;
     
#line 1286 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip =  ipa_is_ip4(v1.val.ip) ?
#line 1286
      ipa_from_ip4(ip4_and(ipa_to_ip4(v1.val.ip), ip4_mkmask(v2.val.i))) :
#line 1286
      ipa_from_ip6(ip6_and(ipa_to_ip6(v1.val.ip), ip6_mkmask(v2.val.i)))  } );
#line 1289
  }

  
  #undef whati
#line 1291 "filter/f-inst.c"
  }
#line 1291

#line 1291

#line 1299 "filter/f-inst.c"
 /* Constructor for FI_PATH_PREPEND */
#line 1299
struct f_inst *
#line 1292 "filter/f-inst.c"
NONNULL(2)
#line 1293 "filter/f-inst.c"
NONNULL(3)
#line 1299 "filter/f-inst.c"
f_new_inst_FI_PATH_PREPEND(enum f_instruction_code fi_code
#line 1292 "filter/f-inst.c"
  , struct f_inst * f1
#line 1293 "filter/f-inst.c"
  , struct f_inst * f2
#line 1299 "filter/f-inst.c"
)
#line 1299
  {
#line 1299
    /* Allocate the structure */
#line 1299
    struct f_inst *what = fi_new(fi_code);
#line 1299
    uint constargs = 1;
#line 1299

#line 1299
    /* Initialize all the members */
#line 1299
  #define whati (&(what->i_FI_PATH_PREPEND))
#line 1299
  #line 1292 "filter/f-inst.c"
whati->f1 = f1;
#line 1292
const struct f_inst *child1 = f1;
#line 1292
do {
#line 1292
  what->size += child1->size;
#line 1292

#line 1292
  if (child1->fi_code != FI_CONSTANT)
#line 1292
    constargs = 0;
#line 1292

#line 1292
} while (child1 = child1->next);
#line 1292

#line 1292 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1292
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1292
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1293 "filter/f-inst.c"
whati->f2 = f2;
#line 1293
const struct f_inst *child2 = f2;
#line 1293
do {
#line 1293
  what->size += child2->size;
#line 1293

#line 1293
  if (child2->fi_code != FI_CONSTANT)
#line 1293
    constargs = 0;
#line 1293

#line 1293
} while (child2 = child2->next);
#line 1293 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1293
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1293
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1295 "filter/f-inst.c"
what->type = T_PATH;

#line 1299 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1299
    if (!constargs)
#line 1299
      return what;
#line 1299

#line 1299
    /* Try to pre-calculate the result */
#line 1299
    #line 1291 "filter/f-inst.c"
 {	/* Path prepend */
    
#line 1292 "filter/f-inst.c"
 #line 1292 "filter/f-inst.c"
 ;
#line 1293 "filter/f-inst.c"
    
#line 1293 "filter/f-inst.c"
 #line 1293 "filter/f-inst.c"
 ;
#line 1294 "filter/f-inst.c"
    #line 1294 "filter/f-inst.c"
;
     
#line 1295 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_prepend(fpool, v1.val.ad, v2.val.i)  } );
  }

  /* String append */
  
  #undef whati
#line 1299 "filter/f-inst.c"
  }
#line 1299

#line 1299

#line 1307 "filter/f-inst.c"
 /* Constructor for FI_STRING_APPEND */
#line 1307
struct f_inst *
#line 1300 "filter/f-inst.c"
NONNULL(2)
#line 1301 "filter/f-inst.c"
NONNULL(3)
#line 1307 "filter/f-inst.c"
f_new_inst_FI_STRING_APPEND(enum f_instruction_code fi_code
#line 1300 "filter/f-inst.c"
  , struct f_inst * f1
#line 1301 "filter/f-inst.c"
  , struct f_inst * f2
#line 1307 "filter/f-inst.c"
)
#line 1307
  {
#line 1307
    /* Allocate the structure */
#line 1307
    struct f_inst *what = fi_new(fi_code);
#line 1307
    uint constargs = 1;
#line 1307

#line 1307
    /* Initialize all the members */
#line 1307
  #define whati (&(what->i_FI_STRING_APPEND))
#line 1307
  #line 1300 "filter/f-inst.c"
whati->f1 = f1;
#line 1300
const struct f_inst *child1 = f1;
#line 1300
do {
#line 1300
  what->size += child1->size;
#line 1300

#line 1300
  if (child1->fi_code != FI_CONSTANT)
#line 1300
    constargs = 0;
#line 1300

#line 1300
} while (child1 = child1->next);
#line 1300

#line 1300 "filter/f-inst.c"
if (f1->type && (f1->type != (T_STRING)) && !f_const_promotion(f1, (T_STRING)))
#line 1300
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1300
	   f_instruction_name(what->fi_code), f_type_name(T_STRING), f_type_name(f1->type));
#line 1301 "filter/f-inst.c"
whati->f2 = f2;
#line 1301
const struct f_inst *child2 = f2;
#line 1301
do {
#line 1301
  what->size += child2->size;
#line 1301

#line 1301
  if (child2->fi_code != FI_CONSTANT)
#line 1301
    constargs = 0;
#line 1301

#line 1301
} while (child2 = child2->next);
#line 1301 "filter/f-inst.c"
if (f2->type && (f2->type != (T_STRING)) && !f_const_promotion(f2, (T_STRING)))
#line 1301
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1301
	   f_instruction_name(what->fi_code), f_type_name(T_STRING), f_type_name(f2->type));
#line 1303 "filter/f-inst.c"
what->type = T_STRING;

#line 1307 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1307
    if (!constargs)
#line 1307
      return what;
#line 1307

#line 1307
    /* Try to pre-calculate the result */
#line 1307
    #line 1299 "filter/f-inst.c"
 {
    
#line 1300 "filter/f-inst.c"
 #line 1300 "filter/f-inst.c"
 ;
#line 1301 "filter/f-inst.c"
    
#line 1301 "filter/f-inst.c"
 #line 1301 "filter/f-inst.c"
 ;
#line 1302 "filter/f-inst.c"
    #line 1302 "filter/f-inst.c"
;
     
#line 1303 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s =  lp_strcat(fpool, v1.val.s, v2.val.s)  } );
  }

  /* Bytestring append */
  
  #undef whati
#line 1307 "filter/f-inst.c"
  }
#line 1307

#line 1307

#line 1315 "filter/f-inst.c"
 /* Constructor for FI_BYTESTRING_APPEND */
#line 1315
struct f_inst *
#line 1308 "filter/f-inst.c"
NONNULL(2)
#line 1309 "filter/f-inst.c"
NONNULL(3)
#line 1315 "filter/f-inst.c"
f_new_inst_FI_BYTESTRING_APPEND(enum f_instruction_code fi_code
#line 1308 "filter/f-inst.c"
  , struct f_inst * f1
#line 1309 "filter/f-inst.c"
  , struct f_inst * f2
#line 1315 "filter/f-inst.c"
)
#line 1315
  {
#line 1315
    /* Allocate the structure */
#line 1315
    struct f_inst *what = fi_new(fi_code);
#line 1315
    uint constargs = 1;
#line 1315

#line 1315
    /* Initialize all the members */
#line 1315
  #define whati (&(what->i_FI_BYTESTRING_APPEND))
#line 1315
  #line 1308 "filter/f-inst.c"
whati->f1 = f1;
#line 1308
const struct f_inst *child1 = f1;
#line 1308
do {
#line 1308
  what->size += child1->size;
#line 1308

#line 1308
  if (child1->fi_code != FI_CONSTANT)
#line 1308
    constargs = 0;
#line 1308

#line 1308
} while (child1 = child1->next);
#line 1308

#line 1308 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BYTESTRING)) && !f_const_promotion(f1, (T_BYTESTRING)))
#line 1308
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1308
	   f_instruction_name(what->fi_code), f_type_name(T_BYTESTRING), f_type_name(f1->type));
#line 1309 "filter/f-inst.c"
whati->f2 = f2;
#line 1309
const struct f_inst *child2 = f2;
#line 1309
do {
#line 1309
  what->size += child2->size;
#line 1309

#line 1309
  if (child2->fi_code != FI_CONSTANT)
#line 1309
    constargs = 0;
#line 1309

#line 1309
} while (child2 = child2->next);
#line 1309 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BYTESTRING)) && !f_const_promotion(f2, (T_BYTESTRING)))
#line 1309
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1309
	   f_instruction_name(what->fi_code), f_type_name(T_BYTESTRING), f_type_name(f2->type));
#line 1311 "filter/f-inst.c"
what->type = T_BYTESTRING;

#line 1315 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1315
    if (!constargs)
#line 1315
      return what;
#line 1315

#line 1315
    /* Try to pre-calculate the result */
#line 1315
    #line 1307 "filter/f-inst.c"
 {
    
#line 1308 "filter/f-inst.c"
 #line 1308 "filter/f-inst.c"
 ;
#line 1309 "filter/f-inst.c"
    
#line 1309 "filter/f-inst.c"
 #line 1309 "filter/f-inst.c"
 ;
#line 1310 "filter/f-inst.c"
    #line 1310 "filter/f-inst.c"
;
     
#line 1311 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BYTESTRING, .val.ad =  bytestring_append(fpool, v1.val.ad, v2.val.ad)  } );
  }

  /* Community list add */
  
  #undef whati
#line 1315 "filter/f-inst.c"
  }
#line 1315

#line 1315

#line 1322 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_PAIR */
#line 1322
struct f_inst *
#line 1316 "filter/f-inst.c"
NONNULL(2)
#line 1317 "filter/f-inst.c"
NONNULL(3)
#line 1322 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_PAIR(enum f_instruction_code fi_code
#line 1316 "filter/f-inst.c"
  , struct f_inst * f1
#line 1317 "filter/f-inst.c"
  , struct f_inst * f2
#line 1322 "filter/f-inst.c"
)
#line 1322
  {
#line 1322
    /* Allocate the structure */
#line 1322
    struct f_inst *what = fi_new(fi_code);
#line 1322
    uint constargs = 1;
#line 1322

#line 1322
    /* Initialize all the members */
#line 1322
  #define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1322
  #line 1316 "filter/f-inst.c"
whati->f1 = f1;
#line 1316
const struct f_inst *child1 = f1;
#line 1316
do {
#line 1316
  what->size += child1->size;
#line 1316

#line 1316
  if (child1->fi_code != FI_CONSTANT)
#line 1316
    constargs = 0;
#line 1316

#line 1316
} while (child1 = child1->next);
#line 1316

#line 1316 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1316
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1316
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1317 "filter/f-inst.c"
whati->f2 = f2;
#line 1317
const struct f_inst *child2 = f2;
#line 1317
do {
#line 1317
  what->size += child2->size;
#line 1317

#line 1317
  if (child2->fi_code != FI_CONSTANT)
#line 1317
    constargs = 0;
#line 1317

#line 1317
} while (child2 = child2->next);
#line 1317 "filter/f-inst.c"
if (f2->type && (f2->type != (T_PAIR)) && !f_const_promotion(f2, (T_PAIR)))
#line 1317
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1317
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f2->type));
#line 1319 "filter/f-inst.c"
what->type = T_CLIST;

#line 1322 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1322
    if (!constargs)
#line 1322
      return what;
#line 1322

#line 1322
    /* Try to pre-calculate the result */
#line 1322
    #line 1315 "filter/f-inst.c"
 {
    
#line 1316 "filter/f-inst.c"
 #line 1316 "filter/f-inst.c"
 ;
#line 1317 "filter/f-inst.c"
    
#line 1317 "filter/f-inst.c"
 #line 1317 "filter/f-inst.c"
 ;
#line 1318 "filter/f-inst.c"
    #line 1318 "filter/f-inst.c"
;
     
#line 1319 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1322 "filter/f-inst.c"
  }
#line 1322

#line 1322

#line 1336 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_IP */
#line 1336
struct f_inst *
#line 1323 "filter/f-inst.c"
NONNULL(2)
#line 1324 "filter/f-inst.c"
NONNULL(3)
#line 1336 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_IP(enum f_instruction_code fi_code
#line 1323 "filter/f-inst.c"
  , struct f_inst * f1
#line 1324 "filter/f-inst.c"
  , struct f_inst * f2
#line 1336 "filter/f-inst.c"
)
#line 1336
  {
#line 1336
    /* Allocate the structure */
#line 1336
    struct f_inst *what = fi_new(fi_code);
#line 1336
    uint constargs = 1;
#line 1336

#line 1336
    /* Initialize all the members */
#line 1336
  #define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1336
  #line 1323 "filter/f-inst.c"
whati->f1 = f1;
#line 1323
const struct f_inst *child1 = f1;
#line 1323
do {
#line 1323
  what->size += child1->size;
#line 1323

#line 1323
  if (child1->fi_code != FI_CONSTANT)
#line 1323
    constargs = 0;
#line 1323

#line 1323
} while (child1 = child1->next);
#line 1323

#line 1323 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1323
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1323
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1324 "filter/f-inst.c"
whati->f2 = f2;
#line 1324
const struct f_inst *child2 = f2;
#line 1324
do {
#line 1324
  what->size += child2->size;
#line 1324

#line 1324
  if (child2->fi_code != FI_CONSTANT)
#line 1324
    constargs = 0;
#line 1324

#line 1324
} while (child2 = child2->next);
#line 1324 "filter/f-inst.c"
if (f2->type && (f2->type != (T_IP)) && !f_const_promotion(f2, (T_IP)))
#line 1324
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1324
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f2->type));
;
#line 1328 "filter/f-inst.c"
    /* IP->Quad implicit conversion, must be before FI_CLIST_ADD_QUAD */
    cf_warn("Method add(clist, ip) is deprecated, please use add(clist, quad)");

    #line 1333 "filter/f-inst.c"
what->type = T_CLIST;

#line 1336 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1336
    if (!constargs)
#line 1336
      return what;
#line 1336

#line 1336
    /* Try to pre-calculate the result */
#line 1336
    #line 1322 "filter/f-inst.c"
 {
    
#line 1323 "filter/f-inst.c"
 #line 1323 "filter/f-inst.c"
 ;
#line 1324 "filter/f-inst.c"
    
#line 1324 "filter/f-inst.c"
 #line 1324 "filter/f-inst.c"
 ;
#line 1325 "filter/f-inst.c"
    #line 1325 "filter/f-inst.c"
;

    ;
#line 1332 "filter/f-inst.c"
    if (!val_is_ip4(&v2)) runtime("Mismatched IP type");
     
#line 1333 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, ipa_to_u32(v2.val.ip))  } );
  }

  
  #undef whati
#line 1336 "filter/f-inst.c"
  }
#line 1336

#line 1336

#line 1343 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_QUAD */
#line 1343
struct f_inst *
#line 1337 "filter/f-inst.c"
NONNULL(2)
#line 1338 "filter/f-inst.c"
NONNULL(3)
#line 1343 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_QUAD(enum f_instruction_code fi_code
#line 1337 "filter/f-inst.c"
  , struct f_inst * f1
#line 1338 "filter/f-inst.c"
  , struct f_inst * f2
#line 1343 "filter/f-inst.c"
)
#line 1343
  {
#line 1343
    /* Allocate the structure */
#line 1343
    struct f_inst *what = fi_new(fi_code);
#line 1343
    uint constargs = 1;
#line 1343

#line 1343
    /* Initialize all the members */
#line 1343
  #define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1343
  #line 1337 "filter/f-inst.c"
whati->f1 = f1;
#line 1337
const struct f_inst *child1 = f1;
#line 1337
do {
#line 1337
  what->size += child1->size;
#line 1337

#line 1337
  if (child1->fi_code != FI_CONSTANT)
#line 1337
    constargs = 0;
#line 1337

#line 1337
} while (child1 = child1->next);
#line 1337

#line 1337 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1337
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1337
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1338 "filter/f-inst.c"
whati->f2 = f2;
#line 1338
const struct f_inst *child2 = f2;
#line 1338
do {
#line 1338
  what->size += child2->size;
#line 1338

#line 1338
  if (child2->fi_code != FI_CONSTANT)
#line 1338
    constargs = 0;
#line 1338

#line 1338
} while (child2 = child2->next);
#line 1338 "filter/f-inst.c"
if (f2->type && (f2->type != (T_QUAD)) && !f_const_promotion(f2, (T_QUAD)))
#line 1338
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1338
	   f_instruction_name(what->fi_code), f_type_name(T_QUAD), f_type_name(f2->type));
#line 1340 "filter/f-inst.c"
what->type = T_CLIST;

#line 1343 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1343
    if (!constargs)
#line 1343
      return what;
#line 1343

#line 1343
    /* Try to pre-calculate the result */
#line 1343
    #line 1336 "filter/f-inst.c"
 {
    
#line 1337 "filter/f-inst.c"
 #line 1337 "filter/f-inst.c"
 ;
#line 1338 "filter/f-inst.c"
    
#line 1338 "filter/f-inst.c"
 #line 1338 "filter/f-inst.c"
 ;
#line 1339 "filter/f-inst.c"
    #line 1339 "filter/f-inst.c"
;
     
#line 1340 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1343 "filter/f-inst.c"
  }
#line 1343

#line 1343

#line 1350 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_CLIST */
#line 1350
struct f_inst *
#line 1344 "filter/f-inst.c"
NONNULL(2)
#line 1345 "filter/f-inst.c"
NONNULL(3)
#line 1350 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_CLIST(enum f_instruction_code fi_code
#line 1344 "filter/f-inst.c"
  , struct f_inst * f1
#line 1345 "filter/f-inst.c"
  , struct f_inst * f2
#line 1350 "filter/f-inst.c"
)
#line 1350
  {
#line 1350
    /* Allocate the structure */
#line 1350
    struct f_inst *what = fi_new(fi_code);
#line 1350
    uint constargs = 1;
#line 1350

#line 1350
    /* Initialize all the members */
#line 1350
  #define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1350
  #line 1344 "filter/f-inst.c"
whati->f1 = f1;
#line 1344
const struct f_inst *child1 = f1;
#line 1344
do {
#line 1344
  what->size += child1->size;
#line 1344

#line 1344
  if (child1->fi_code != FI_CONSTANT)
#line 1344
    constargs = 0;
#line 1344

#line 1344
} while (child1 = child1->next);
#line 1344

#line 1344 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1344
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1344
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1345 "filter/f-inst.c"
whati->f2 = f2;
#line 1345
const struct f_inst *child2 = f2;
#line 1345
do {
#line 1345
  what->size += child2->size;
#line 1345

#line 1345
  if (child2->fi_code != FI_CONSTANT)
#line 1345
    constargs = 0;
#line 1345

#line 1345
} while (child2 = child2->next);
#line 1345 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1345
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1345
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1347 "filter/f-inst.c"
what->type = T_CLIST;

#line 1350 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1350
    if (!constargs)
#line 1350
      return what;
#line 1350

#line 1350
    /* Try to pre-calculate the result */
#line 1350
    #line 1343 "filter/f-inst.c"
 {
    
#line 1344 "filter/f-inst.c"
 #line 1344 "filter/f-inst.c"
 ;
#line 1345 "filter/f-inst.c"
    
#line 1345 "filter/f-inst.c"
 #line 1345 "filter/f-inst.c"
 ;
#line 1346 "filter/f-inst.c"
    #line 1346 "filter/f-inst.c"
;
     
#line 1347 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1350 "filter/f-inst.c"
  }
#line 1350

#line 1350

#line 1357 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_ADD_EC */
#line 1357
struct f_inst *
#line 1351 "filter/f-inst.c"
NONNULL(2)
#line 1352 "filter/f-inst.c"
NONNULL(3)
#line 1357 "filter/f-inst.c"
f_new_inst_FI_ECLIST_ADD_EC(enum f_instruction_code fi_code
#line 1351 "filter/f-inst.c"
  , struct f_inst * f1
#line 1352 "filter/f-inst.c"
  , struct f_inst * f2
#line 1357 "filter/f-inst.c"
)
#line 1357
  {
#line 1357
    /* Allocate the structure */
#line 1357
    struct f_inst *what = fi_new(fi_code);
#line 1357
    uint constargs = 1;
#line 1357

#line 1357
    /* Initialize all the members */
#line 1357
  #define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1357
  #line 1351 "filter/f-inst.c"
whati->f1 = f1;
#line 1351
const struct f_inst *child1 = f1;
#line 1351
do {
#line 1351
  what->size += child1->size;
#line 1351

#line 1351
  if (child1->fi_code != FI_CONSTANT)
#line 1351
    constargs = 0;
#line 1351

#line 1351
} while (child1 = child1->next);
#line 1351

#line 1351 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1351
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1351
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1352 "filter/f-inst.c"
whati->f2 = f2;
#line 1352
const struct f_inst *child2 = f2;
#line 1352
do {
#line 1352
  what->size += child2->size;
#line 1352

#line 1352
  if (child2->fi_code != FI_CONSTANT)
#line 1352
    constargs = 0;
#line 1352

#line 1352
} while (child2 = child2->next);
#line 1352 "filter/f-inst.c"
if (f2->type && (f2->type != (T_EC)) && !f_const_promotion(f2, (T_EC)))
#line 1352
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1352
	   f_instruction_name(what->fi_code), f_type_name(T_EC), f_type_name(f2->type));
#line 1354 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1357 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1357
    if (!constargs)
#line 1357
      return what;
#line 1357

#line 1357
    /* Try to pre-calculate the result */
#line 1357
    #line 1350 "filter/f-inst.c"
 {
    
#line 1351 "filter/f-inst.c"
 #line 1351 "filter/f-inst.c"
 ;
#line 1352 "filter/f-inst.c"
    
#line 1352 "filter/f-inst.c"
 #line 1352 "filter/f-inst.c"
 ;
#line 1353 "filter/f-inst.c"
    #line 1353 "filter/f-inst.c"
;
     
#line 1354 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_add(fpool, v1.val.ad, v2.val.ec)  } );
  }

  
  #undef whati
#line 1357 "filter/f-inst.c"
  }
#line 1357

#line 1357

#line 1364 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_ADD_ECLIST */
#line 1364
struct f_inst *
#line 1358 "filter/f-inst.c"
NONNULL(2)
#line 1359 "filter/f-inst.c"
NONNULL(3)
#line 1364 "filter/f-inst.c"
f_new_inst_FI_ECLIST_ADD_ECLIST(enum f_instruction_code fi_code
#line 1358 "filter/f-inst.c"
  , struct f_inst * f1
#line 1359 "filter/f-inst.c"
  , struct f_inst * f2
#line 1364 "filter/f-inst.c"
)
#line 1364
  {
#line 1364
    /* Allocate the structure */
#line 1364
    struct f_inst *what = fi_new(fi_code);
#line 1364
    uint constargs = 1;
#line 1364

#line 1364
    /* Initialize all the members */
#line 1364
  #define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1364
  #line 1358 "filter/f-inst.c"
whati->f1 = f1;
#line 1358
const struct f_inst *child1 = f1;
#line 1358
do {
#line 1358
  what->size += child1->size;
#line 1358

#line 1358
  if (child1->fi_code != FI_CONSTANT)
#line 1358
    constargs = 0;
#line 1358

#line 1358
} while (child1 = child1->next);
#line 1358

#line 1358 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1358
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1358
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1359 "filter/f-inst.c"
whati->f2 = f2;
#line 1359
const struct f_inst *child2 = f2;
#line 1359
do {
#line 1359
  what->size += child2->size;
#line 1359

#line 1359
  if (child2->fi_code != FI_CONSTANT)
#line 1359
    constargs = 0;
#line 1359

#line 1359
} while (child2 = child2->next);
#line 1359 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1359
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1359
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1361 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1364 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1364
    if (!constargs)
#line 1364
      return what;
#line 1364

#line 1364
    /* Try to pre-calculate the result */
#line 1364
    #line 1357 "filter/f-inst.c"
 {
    
#line 1358 "filter/f-inst.c"
 #line 1358 "filter/f-inst.c"
 ;
#line 1359 "filter/f-inst.c"
    
#line 1359 "filter/f-inst.c"
 #line 1359 "filter/f-inst.c"
 ;
#line 1360 "filter/f-inst.c"
    #line 1360 "filter/f-inst.c"
;
     
#line 1361 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1364 "filter/f-inst.c"
  }
#line 1364

#line 1364

#line 1371 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_ADD_LC */
#line 1371
struct f_inst *
#line 1365 "filter/f-inst.c"
NONNULL(2)
#line 1366 "filter/f-inst.c"
NONNULL(3)
#line 1371 "filter/f-inst.c"
f_new_inst_FI_LCLIST_ADD_LC(enum f_instruction_code fi_code
#line 1365 "filter/f-inst.c"
  , struct f_inst * f1
#line 1366 "filter/f-inst.c"
  , struct f_inst * f2
#line 1371 "filter/f-inst.c"
)
#line 1371
  {
#line 1371
    /* Allocate the structure */
#line 1371
    struct f_inst *what = fi_new(fi_code);
#line 1371
    uint constargs = 1;
#line 1371

#line 1371
    /* Initialize all the members */
#line 1371
  #define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1371
  #line 1365 "filter/f-inst.c"
whati->f1 = f1;
#line 1365
const struct f_inst *child1 = f1;
#line 1365
do {
#line 1365
  what->size += child1->size;
#line 1365

#line 1365
  if (child1->fi_code != FI_CONSTANT)
#line 1365
    constargs = 0;
#line 1365

#line 1365
} while (child1 = child1->next);
#line 1365

#line 1365 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1365
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1365
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1366 "filter/f-inst.c"
whati->f2 = f2;
#line 1366
const struct f_inst *child2 = f2;
#line 1366
do {
#line 1366
  what->size += child2->size;
#line 1366

#line 1366
  if (child2->fi_code != FI_CONSTANT)
#line 1366
    constargs = 0;
#line 1366

#line 1366
} while (child2 = child2->next);
#line 1366 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LC)) && !f_const_promotion(f2, (T_LC)))
#line 1366
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1366
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f2->type));
#line 1368 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1371 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1371
    if (!constargs)
#line 1371
      return what;
#line 1371

#line 1371
    /* Try to pre-calculate the result */
#line 1371
    #line 1364 "filter/f-inst.c"
 {
    
#line 1365 "filter/f-inst.c"
 #line 1365 "filter/f-inst.c"
 ;
#line 1366 "filter/f-inst.c"
    
#line 1366 "filter/f-inst.c"
 #line 1366 "filter/f-inst.c"
 ;
#line 1367 "filter/f-inst.c"
    #line 1367 "filter/f-inst.c"
;
     
#line 1368 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_add(fpool, v1.val.ad, v2.val.lc)  } );
  }

  
  #undef whati
#line 1371 "filter/f-inst.c"
  }
#line 1371

#line 1371

#line 1378 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_ADD_LCLIST */
#line 1378
struct f_inst *
#line 1372 "filter/f-inst.c"
NONNULL(2)
#line 1373 "filter/f-inst.c"
NONNULL(3)
#line 1378 "filter/f-inst.c"
f_new_inst_FI_LCLIST_ADD_LCLIST(enum f_instruction_code fi_code
#line 1372 "filter/f-inst.c"
  , struct f_inst * f1
#line 1373 "filter/f-inst.c"
  , struct f_inst * f2
#line 1378 "filter/f-inst.c"
)
#line 1378
  {
#line 1378
    /* Allocate the structure */
#line 1378
    struct f_inst *what = fi_new(fi_code);
#line 1378
    uint constargs = 1;
#line 1378

#line 1378
    /* Initialize all the members */
#line 1378
  #define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1378
  #line 1372 "filter/f-inst.c"
whati->f1 = f1;
#line 1372
const struct f_inst *child1 = f1;
#line 1372
do {
#line 1372
  what->size += child1->size;
#line 1372

#line 1372
  if (child1->fi_code != FI_CONSTANT)
#line 1372
    constargs = 0;
#line 1372

#line 1372
} while (child1 = child1->next);
#line 1372

#line 1372 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1372
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1372
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1373 "filter/f-inst.c"
whati->f2 = f2;
#line 1373
const struct f_inst *child2 = f2;
#line 1373
do {
#line 1373
  what->size += child2->size;
#line 1373

#line 1373
  if (child2->fi_code != FI_CONSTANT)
#line 1373
    constargs = 0;
#line 1373

#line 1373
} while (child2 = child2->next);
#line 1373 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1373
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1373
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1375 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1378 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1378
    if (!constargs)
#line 1378
      return what;
#line 1378

#line 1378
    /* Try to pre-calculate the result */
#line 1378
    #line 1371 "filter/f-inst.c"
 {
    
#line 1372 "filter/f-inst.c"
 #line 1372 "filter/f-inst.c"
 ;
#line 1373 "filter/f-inst.c"
    
#line 1373 "filter/f-inst.c"
 #line 1373 "filter/f-inst.c"
 ;
#line 1374 "filter/f-inst.c"
    #line 1374 "filter/f-inst.c"
;
     
#line 1375 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1378 "filter/f-inst.c"
  }
#line 1378

#line 1378

#line 1385 "filter/f-inst.c"
 /* Constructor for FI_PATH_DELETE_INT */
#line 1385
struct f_inst *
#line 1379 "filter/f-inst.c"
NONNULL(2)
#line 1380 "filter/f-inst.c"
NONNULL(3)
#line 1385 "filter/f-inst.c"
f_new_inst_FI_PATH_DELETE_INT(enum f_instruction_code fi_code
#line 1379 "filter/f-inst.c"
  , struct f_inst * f1
#line 1380 "filter/f-inst.c"
  , struct f_inst * f2
#line 1385 "filter/f-inst.c"
)
#line 1385
  {
#line 1385
    /* Allocate the structure */
#line 1385
    struct f_inst *what = fi_new(fi_code);
#line 1385
    uint constargs = 1;
#line 1385

#line 1385
    /* Initialize all the members */
#line 1385
  #define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1385
  #line 1379 "filter/f-inst.c"
whati->f1 = f1;
#line 1379
const struct f_inst *child1 = f1;
#line 1379
do {
#line 1379
  what->size += child1->size;
#line 1379

#line 1379
  if (child1->fi_code != FI_CONSTANT)
#line 1379
    constargs = 0;
#line 1379

#line 1379
} while (child1 = child1->next);
#line 1379

#line 1379 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1379
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1379
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1380 "filter/f-inst.c"
whati->f2 = f2;
#line 1380
const struct f_inst *child2 = f2;
#line 1380
do {
#line 1380
  what->size += child2->size;
#line 1380

#line 1380
  if (child2->fi_code != FI_CONSTANT)
#line 1380
    constargs = 0;
#line 1380

#line 1380
} while (child2 = child2->next);
#line 1380 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1380
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1380
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1382 "filter/f-inst.c"
what->type = T_PATH;

#line 1385 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1385
    if (!constargs)
#line 1385
      return what;
#line 1385

#line 1385
    /* Try to pre-calculate the result */
#line 1385
    #line 1378 "filter/f-inst.c"
 {
    
#line 1379 "filter/f-inst.c"
 #line 1379 "filter/f-inst.c"
 ;
#line 1380 "filter/f-inst.c"
    
#line 1380 "filter/f-inst.c"
 #line 1380 "filter/f-inst.c"
 ;
#line 1381 "filter/f-inst.c"
    #line 1381 "filter/f-inst.c"
;
     
#line 1382 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1385 "filter/f-inst.c"
  }
#line 1385

#line 1385

#line 1397 "filter/f-inst.c"
 /* Constructor for FI_PATH_DELETE_SET */
#line 1397
struct f_inst *
#line 1386 "filter/f-inst.c"
NONNULL(2)
#line 1387 "filter/f-inst.c"
NONNULL(3)
#line 1397 "filter/f-inst.c"
f_new_inst_FI_PATH_DELETE_SET(enum f_instruction_code fi_code
#line 1386 "filter/f-inst.c"
  , struct f_inst * f1
#line 1387 "filter/f-inst.c"
  , struct f_inst * f2
#line 1397 "filter/f-inst.c"
)
#line 1397
  {
#line 1397
    /* Allocate the structure */
#line 1397
    struct f_inst *what = fi_new(fi_code);
#line 1397
    uint constargs = 1;
#line 1397

#line 1397
    /* Initialize all the members */
#line 1397
  #define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1397
  #line 1386 "filter/f-inst.c"
whati->f1 = f1;
#line 1386
const struct f_inst *child1 = f1;
#line 1386
do {
#line 1386
  what->size += child1->size;
#line 1386

#line 1386
  if (child1->fi_code != FI_CONSTANT)
#line 1386
    constargs = 0;
#line 1386

#line 1386
} while (child1 = child1->next);
#line 1386

#line 1386 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1386
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1386
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1387 "filter/f-inst.c"
whati->f2 = f2;
#line 1387
const struct f_inst *child2 = f2;
#line 1387
do {
#line 1387
  what->size += child2->size;
#line 1387

#line 1387
  if (child2->fi_code != FI_CONSTANT)
#line 1387
    constargs = 0;
#line 1387

#line 1387
} while (child2 = child2->next);
#line 1387 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1387
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1387
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1393 "filter/f-inst.c"
what->type = T_PATH;

#line 1397 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1397
    if (!constargs)
#line 1397
      return what;
#line 1397

#line 1397
    /* Try to pre-calculate the result */
#line 1397
    #line 1385 "filter/f-inst.c"
 {
    
#line 1386 "filter/f-inst.c"
 #line 1386 "filter/f-inst.c"
 ;
#line 1387 "filter/f-inst.c"
    
#line 1387 "filter/f-inst.c"
 #line 1387 "filter/f-inst.c"
 ;
#line 1388 "filter/f-inst.c"
    #line 1388 "filter/f-inst.c"
;

    if (!path_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1393 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  /* Community list delete */
  
  #undef whati
#line 1397 "filter/f-inst.c"
  }
#line 1397

#line 1397

#line 1404 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_PAIR */
#line 1404
struct f_inst *
#line 1398 "filter/f-inst.c"
NONNULL(2)
#line 1399 "filter/f-inst.c"
NONNULL(3)
#line 1404 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_PAIR(enum f_instruction_code fi_code
#line 1398 "filter/f-inst.c"
  , struct f_inst * f1
#line 1399 "filter/f-inst.c"
  , struct f_inst * f2
#line 1404 "filter/f-inst.c"
)
#line 1404
  {
#line 1404
    /* Allocate the structure */
#line 1404
    struct f_inst *what = fi_new(fi_code);
#line 1404
    uint constargs = 1;
#line 1404

#line 1404
    /* Initialize all the members */
#line 1404
  #define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1404
  #line 1398 "filter/f-inst.c"
whati->f1 = f1;
#line 1398
const struct f_inst *child1 = f1;
#line 1398
do {
#line 1398
  what->size += child1->size;
#line 1398

#line 1398
  if (child1->fi_code != FI_CONSTANT)
#line 1398
    constargs = 0;
#line 1398

#line 1398
} while (child1 = child1->next);
#line 1398

#line 1398 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1398
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1398
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1399 "filter/f-inst.c"
whati->f2 = f2;
#line 1399
const struct f_inst *child2 = f2;
#line 1399
do {
#line 1399
  what->size += child2->size;
#line 1399

#line 1399
  if (child2->fi_code != FI_CONSTANT)
#line 1399
    constargs = 0;
#line 1399

#line 1399
} while (child2 = child2->next);
#line 1399 "filter/f-inst.c"
if (f2->type && (f2->type != (T_PAIR)) && !f_const_promotion(f2, (T_PAIR)))
#line 1399
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1399
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f2->type));
#line 1401 "filter/f-inst.c"
what->type = T_CLIST;

#line 1404 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1404
    if (!constargs)
#line 1404
      return what;
#line 1404

#line 1404
    /* Try to pre-calculate the result */
#line 1404
    #line 1397 "filter/f-inst.c"
 {
    
#line 1398 "filter/f-inst.c"
 #line 1398 "filter/f-inst.c"
 ;
#line 1399 "filter/f-inst.c"
    
#line 1399 "filter/f-inst.c"
 #line 1399 "filter/f-inst.c"
 ;
#line 1400 "filter/f-inst.c"
    #line 1400 "filter/f-inst.c"
;
     
#line 1401 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1404 "filter/f-inst.c"
  }
#line 1404

#line 1404

#line 1418 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_IP */
#line 1418
struct f_inst *
#line 1405 "filter/f-inst.c"
NONNULL(2)
#line 1406 "filter/f-inst.c"
NONNULL(3)
#line 1418 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_IP(enum f_instruction_code fi_code
#line 1405 "filter/f-inst.c"
  , struct f_inst * f1
#line 1406 "filter/f-inst.c"
  , struct f_inst * f2
#line 1418 "filter/f-inst.c"
)
#line 1418
  {
#line 1418
    /* Allocate the structure */
#line 1418
    struct f_inst *what = fi_new(fi_code);
#line 1418
    uint constargs = 1;
#line 1418

#line 1418
    /* Initialize all the members */
#line 1418
  #define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1418
  #line 1405 "filter/f-inst.c"
whati->f1 = f1;
#line 1405
const struct f_inst *child1 = f1;
#line 1405
do {
#line 1405
  what->size += child1->size;
#line 1405

#line 1405
  if (child1->fi_code != FI_CONSTANT)
#line 1405
    constargs = 0;
#line 1405

#line 1405
} while (child1 = child1->next);
#line 1405

#line 1405 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1405
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1405
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1406 "filter/f-inst.c"
whati->f2 = f2;
#line 1406
const struct f_inst *child2 = f2;
#line 1406
do {
#line 1406
  what->size += child2->size;
#line 1406

#line 1406
  if (child2->fi_code != FI_CONSTANT)
#line 1406
    constargs = 0;
#line 1406

#line 1406
} while (child2 = child2->next);
#line 1406 "filter/f-inst.c"
if (f2->type && (f2->type != (T_IP)) && !f_const_promotion(f2, (T_IP)))
#line 1406
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1406
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f2->type));
;
#line 1410 "filter/f-inst.c"
    /* IP->Quad implicit conversion, must be before FI_CLIST_DELETE_QUAD */
    cf_warn("Method delete(clist, ip) is deprecated, please use delete(clist, quad)");

    #line 1415 "filter/f-inst.c"
what->type = T_CLIST;

#line 1418 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1418
    if (!constargs)
#line 1418
      return what;
#line 1418

#line 1418
    /* Try to pre-calculate the result */
#line 1418
    #line 1404 "filter/f-inst.c"
 {
    
#line 1405 "filter/f-inst.c"
 #line 1405 "filter/f-inst.c"
 ;
#line 1406 "filter/f-inst.c"
    
#line 1406 "filter/f-inst.c"
 #line 1406 "filter/f-inst.c"
 ;
#line 1407 "filter/f-inst.c"
    #line 1407 "filter/f-inst.c"
;

    ;
#line 1414 "filter/f-inst.c"
    if (!val_is_ip4(&v2)) runtime("Mismatched IP type");
     
#line 1415 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, ipa_to_u32(v2.val.ip))  } );
  }

  
  #undef whati
#line 1418 "filter/f-inst.c"
  }
#line 1418

#line 1418

#line 1425 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_QUAD */
#line 1425
struct f_inst *
#line 1419 "filter/f-inst.c"
NONNULL(2)
#line 1420 "filter/f-inst.c"
NONNULL(3)
#line 1425 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_QUAD(enum f_instruction_code fi_code
#line 1419 "filter/f-inst.c"
  , struct f_inst * f1
#line 1420 "filter/f-inst.c"
  , struct f_inst * f2
#line 1425 "filter/f-inst.c"
)
#line 1425
  {
#line 1425
    /* Allocate the structure */
#line 1425
    struct f_inst *what = fi_new(fi_code);
#line 1425
    uint constargs = 1;
#line 1425

#line 1425
    /* Initialize all the members */
#line 1425
  #define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1425
  #line 1419 "filter/f-inst.c"
whati->f1 = f1;
#line 1419
const struct f_inst *child1 = f1;
#line 1419
do {
#line 1419
  what->size += child1->size;
#line 1419

#line 1419
  if (child1->fi_code != FI_CONSTANT)
#line 1419
    constargs = 0;
#line 1419

#line 1419
} while (child1 = child1->next);
#line 1419

#line 1419 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1419
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1419
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1420 "filter/f-inst.c"
whati->f2 = f2;
#line 1420
const struct f_inst *child2 = f2;
#line 1420
do {
#line 1420
  what->size += child2->size;
#line 1420

#line 1420
  if (child2->fi_code != FI_CONSTANT)
#line 1420
    constargs = 0;
#line 1420

#line 1420
} while (child2 = child2->next);
#line 1420 "filter/f-inst.c"
if (f2->type && (f2->type != (T_QUAD)) && !f_const_promotion(f2, (T_QUAD)))
#line 1420
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1420
	   f_instruction_name(what->fi_code), f_type_name(T_QUAD), f_type_name(f2->type));
#line 1422 "filter/f-inst.c"
what->type = T_CLIST;

#line 1425 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1425
    if (!constargs)
#line 1425
      return what;
#line 1425

#line 1425
    /* Try to pre-calculate the result */
#line 1425
    #line 1418 "filter/f-inst.c"
 {
    
#line 1419 "filter/f-inst.c"
 #line 1419 "filter/f-inst.c"
 ;
#line 1420 "filter/f-inst.c"
    
#line 1420 "filter/f-inst.c"
 #line 1420 "filter/f-inst.c"
 ;
#line 1421 "filter/f-inst.c"
    #line 1421 "filter/f-inst.c"
;
     
#line 1422 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1425 "filter/f-inst.c"
  }
#line 1425

#line 1425

#line 1432 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_CLIST */
#line 1432
struct f_inst *
#line 1426 "filter/f-inst.c"
NONNULL(2)
#line 1427 "filter/f-inst.c"
NONNULL(3)
#line 1432 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_CLIST(enum f_instruction_code fi_code
#line 1426 "filter/f-inst.c"
  , struct f_inst * f1
#line 1427 "filter/f-inst.c"
  , struct f_inst * f2
#line 1432 "filter/f-inst.c"
)
#line 1432
  {
#line 1432
    /* Allocate the structure */
#line 1432
    struct f_inst *what = fi_new(fi_code);
#line 1432
    uint constargs = 1;
#line 1432

#line 1432
    /* Initialize all the members */
#line 1432
  #define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1432
  #line 1426 "filter/f-inst.c"
whati->f1 = f1;
#line 1426
const struct f_inst *child1 = f1;
#line 1426
do {
#line 1426
  what->size += child1->size;
#line 1426

#line 1426
  if (child1->fi_code != FI_CONSTANT)
#line 1426
    constargs = 0;
#line 1426

#line 1426
} while (child1 = child1->next);
#line 1426

#line 1426 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1426
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1426
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1427 "filter/f-inst.c"
whati->f2 = f2;
#line 1427
const struct f_inst *child2 = f2;
#line 1427
do {
#line 1427
  what->size += child2->size;
#line 1427

#line 1427
  if (child2->fi_code != FI_CONSTANT)
#line 1427
    constargs = 0;
#line 1427

#line 1427
} while (child2 = child2->next);
#line 1427 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1427
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1427
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1429 "filter/f-inst.c"
what->type = T_CLIST;

#line 1432 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1432
    if (!constargs)
#line 1432
      return what;
#line 1432

#line 1432
    /* Try to pre-calculate the result */
#line 1432
    #line 1425 "filter/f-inst.c"
 {
    
#line 1426 "filter/f-inst.c"
 #line 1426 "filter/f-inst.c"
 ;
#line 1427 "filter/f-inst.c"
    
#line 1427 "filter/f-inst.c"
 #line 1427 "filter/f-inst.c"
 ;
#line 1428 "filter/f-inst.c"
    #line 1428 "filter/f-inst.c"
;
     
#line 1429 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1432 "filter/f-inst.c"
  }
#line 1432

#line 1432

#line 1443 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_SET */
#line 1443
struct f_inst *
#line 1433 "filter/f-inst.c"
NONNULL(2)
#line 1434 "filter/f-inst.c"
NONNULL(3)
#line 1443 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1433 "filter/f-inst.c"
  , struct f_inst * f1
#line 1434 "filter/f-inst.c"
  , struct f_inst * f2
#line 1443 "filter/f-inst.c"
)
#line 1443
  {
#line 1443
    /* Allocate the structure */
#line 1443
    struct f_inst *what = fi_new(fi_code);
#line 1443
    uint constargs = 1;
#line 1443

#line 1443
    /* Initialize all the members */
#line 1443
  #define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1443
  #line 1433 "filter/f-inst.c"
whati->f1 = f1;
#line 1433
const struct f_inst *child1 = f1;
#line 1433
do {
#line 1433
  what->size += child1->size;
#line 1433

#line 1433
  if (child1->fi_code != FI_CONSTANT)
#line 1433
    constargs = 0;
#line 1433

#line 1433
} while (child1 = child1->next);
#line 1433

#line 1433 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1433
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1433
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1434 "filter/f-inst.c"
whati->f2 = f2;
#line 1434
const struct f_inst *child2 = f2;
#line 1434
do {
#line 1434
  what->size += child2->size;
#line 1434

#line 1434
  if (child2->fi_code != FI_CONSTANT)
#line 1434
    constargs = 0;
#line 1434

#line 1434
} while (child2 = child2->next);
#line 1434 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1434
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1434
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1440 "filter/f-inst.c"
what->type = T_CLIST;

#line 1443 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1443
    if (!constargs)
#line 1443
      return what;
#line 1443

#line 1443
    /* Try to pre-calculate the result */
#line 1443
    #line 1432 "filter/f-inst.c"
 {
    
#line 1433 "filter/f-inst.c"
 #line 1433 "filter/f-inst.c"
 ;
#line 1434 "filter/f-inst.c"
    
#line 1434 "filter/f-inst.c"
 #line 1434 "filter/f-inst.c"
 ;
#line 1435 "filter/f-inst.c"
    #line 1435 "filter/f-inst.c"
;

    if (!clist_set_type(v2.val.t, &(struct f_val){}))
      runtime("Mismatched set type");

     
#line 1440 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1443 "filter/f-inst.c"
  }
#line 1443

#line 1443

#line 1450 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_EC */
#line 1450
struct f_inst *
#line 1444 "filter/f-inst.c"
NONNULL(2)
#line 1445 "filter/f-inst.c"
NONNULL(3)
#line 1450 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_EC(enum f_instruction_code fi_code
#line 1444 "filter/f-inst.c"
  , struct f_inst * f1
#line 1445 "filter/f-inst.c"
  , struct f_inst * f2
#line 1450 "filter/f-inst.c"
)
#line 1450
  {
#line 1450
    /* Allocate the structure */
#line 1450
    struct f_inst *what = fi_new(fi_code);
#line 1450
    uint constargs = 1;
#line 1450

#line 1450
    /* Initialize all the members */
#line 1450
  #define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1450
  #line 1444 "filter/f-inst.c"
whati->f1 = f1;
#line 1444
const struct f_inst *child1 = f1;
#line 1444
do {
#line 1444
  what->size += child1->size;
#line 1444

#line 1444
  if (child1->fi_code != FI_CONSTANT)
#line 1444
    constargs = 0;
#line 1444

#line 1444
} while (child1 = child1->next);
#line 1444

#line 1444 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1444
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1444
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1445 "filter/f-inst.c"
whati->f2 = f2;
#line 1445
const struct f_inst *child2 = f2;
#line 1445
do {
#line 1445
  what->size += child2->size;
#line 1445

#line 1445
  if (child2->fi_code != FI_CONSTANT)
#line 1445
    constargs = 0;
#line 1445

#line 1445
} while (child2 = child2->next);
#line 1445 "filter/f-inst.c"
if (f2->type && (f2->type != (T_EC)) && !f_const_promotion(f2, (T_EC)))
#line 1445
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1445
	   f_instruction_name(what->fi_code), f_type_name(T_EC), f_type_name(f2->type));
#line 1447 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1450 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1450
    if (!constargs)
#line 1450
      return what;
#line 1450

#line 1450
    /* Try to pre-calculate the result */
#line 1450
    #line 1443 "filter/f-inst.c"
 {
    
#line 1444 "filter/f-inst.c"
 #line 1444 "filter/f-inst.c"
 ;
#line 1445 "filter/f-inst.c"
    
#line 1445 "filter/f-inst.c"
 #line 1445 "filter/f-inst.c"
 ;
#line 1446 "filter/f-inst.c"
    #line 1446 "filter/f-inst.c"
;
     
#line 1447 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_del(fpool, v1.val.ad, v2.val.ec)  } );
  }

  
  #undef whati
#line 1450 "filter/f-inst.c"
  }
#line 1450

#line 1450

#line 1457 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_ECLIST */
#line 1457
struct f_inst *
#line 1451 "filter/f-inst.c"
NONNULL(2)
#line 1452 "filter/f-inst.c"
NONNULL(3)
#line 1457 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_ECLIST(enum f_instruction_code fi_code
#line 1451 "filter/f-inst.c"
  , struct f_inst * f1
#line 1452 "filter/f-inst.c"
  , struct f_inst * f2
#line 1457 "filter/f-inst.c"
)
#line 1457
  {
#line 1457
    /* Allocate the structure */
#line 1457
    struct f_inst *what = fi_new(fi_code);
#line 1457
    uint constargs = 1;
#line 1457

#line 1457
    /* Initialize all the members */
#line 1457
  #define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1457
  #line 1451 "filter/f-inst.c"
whati->f1 = f1;
#line 1451
const struct f_inst *child1 = f1;
#line 1451
do {
#line 1451
  what->size += child1->size;
#line 1451

#line 1451
  if (child1->fi_code != FI_CONSTANT)
#line 1451
    constargs = 0;
#line 1451

#line 1451
} while (child1 = child1->next);
#line 1451

#line 1451 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1451
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1451
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1452 "filter/f-inst.c"
whati->f2 = f2;
#line 1452
const struct f_inst *child2 = f2;
#line 1452
do {
#line 1452
  what->size += child2->size;
#line 1452

#line 1452
  if (child2->fi_code != FI_CONSTANT)
#line 1452
    constargs = 0;
#line 1452

#line 1452
} while (child2 = child2->next);
#line 1452 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1452
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1452
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1454 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1457 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1457
    if (!constargs)
#line 1457
      return what;
#line 1457

#line 1457
    /* Try to pre-calculate the result */
#line 1457
    #line 1450 "filter/f-inst.c"
 {
    
#line 1451 "filter/f-inst.c"
 #line 1451 "filter/f-inst.c"
 ;
#line 1452 "filter/f-inst.c"
    
#line 1452 "filter/f-inst.c"
 #line 1452 "filter/f-inst.c"
 ;
#line 1453 "filter/f-inst.c"
    #line 1453 "filter/f-inst.c"
;
     
#line 1454 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1457 "filter/f-inst.c"
  }
#line 1457

#line 1457

#line 1468 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_SET */
#line 1468
struct f_inst *
#line 1458 "filter/f-inst.c"
NONNULL(2)
#line 1459 "filter/f-inst.c"
NONNULL(3)
#line 1468 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1458 "filter/f-inst.c"
  , struct f_inst * f1
#line 1459 "filter/f-inst.c"
  , struct f_inst * f2
#line 1468 "filter/f-inst.c"
)
#line 1468
  {
#line 1468
    /* Allocate the structure */
#line 1468
    struct f_inst *what = fi_new(fi_code);
#line 1468
    uint constargs = 1;
#line 1468

#line 1468
    /* Initialize all the members */
#line 1468
  #define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1468
  #line 1458 "filter/f-inst.c"
whati->f1 = f1;
#line 1458
const struct f_inst *child1 = f1;
#line 1458
do {
#line 1458
  what->size += child1->size;
#line 1458

#line 1458
  if (child1->fi_code != FI_CONSTANT)
#line 1458
    constargs = 0;
#line 1458

#line 1458
} while (child1 = child1->next);
#line 1458

#line 1458 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1458
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1458
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1459 "filter/f-inst.c"
whati->f2 = f2;
#line 1459
const struct f_inst *child2 = f2;
#line 1459
do {
#line 1459
  what->size += child2->size;
#line 1459

#line 1459
  if (child2->fi_code != FI_CONSTANT)
#line 1459
    constargs = 0;
#line 1459

#line 1459
} while (child2 = child2->next);
#line 1459 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1459
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1459
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1465 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1468 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1468
    if (!constargs)
#line 1468
      return what;
#line 1468

#line 1468
    /* Try to pre-calculate the result */
#line 1468
    #line 1457 "filter/f-inst.c"
 {
    
#line 1458 "filter/f-inst.c"
 #line 1458 "filter/f-inst.c"
 ;
#line 1459 "filter/f-inst.c"
    
#line 1459 "filter/f-inst.c"
 #line 1459 "filter/f-inst.c"
 ;
#line 1460 "filter/f-inst.c"
    #line 1460 "filter/f-inst.c"
;

    if (!eclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1465 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1468 "filter/f-inst.c"
  }
#line 1468

#line 1468

#line 1475 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_LC */
#line 1475
struct f_inst *
#line 1469 "filter/f-inst.c"
NONNULL(2)
#line 1470 "filter/f-inst.c"
NONNULL(3)
#line 1475 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_LC(enum f_instruction_code fi_code
#line 1469 "filter/f-inst.c"
  , struct f_inst * f1
#line 1470 "filter/f-inst.c"
  , struct f_inst * f2
#line 1475 "filter/f-inst.c"
)
#line 1475
  {
#line 1475
    /* Allocate the structure */
#line 1475
    struct f_inst *what = fi_new(fi_code);
#line 1475
    uint constargs = 1;
#line 1475

#line 1475
    /* Initialize all the members */
#line 1475
  #define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1475
  #line 1469 "filter/f-inst.c"
whati->f1 = f1;
#line 1469
const struct f_inst *child1 = f1;
#line 1469
do {
#line 1469
  what->size += child1->size;
#line 1469

#line 1469
  if (child1->fi_code != FI_CONSTANT)
#line 1469
    constargs = 0;
#line 1469

#line 1469
} while (child1 = child1->next);
#line 1469

#line 1469 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1469
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1469
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1470 "filter/f-inst.c"
whati->f2 = f2;
#line 1470
const struct f_inst *child2 = f2;
#line 1470
do {
#line 1470
  what->size += child2->size;
#line 1470

#line 1470
  if (child2->fi_code != FI_CONSTANT)
#line 1470
    constargs = 0;
#line 1470

#line 1470
} while (child2 = child2->next);
#line 1470 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LC)) && !f_const_promotion(f2, (T_LC)))
#line 1470
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1470
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f2->type));
#line 1472 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1475 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1475
    if (!constargs)
#line 1475
      return what;
#line 1475

#line 1475
    /* Try to pre-calculate the result */
#line 1475
    #line 1468 "filter/f-inst.c"
 {
    
#line 1469 "filter/f-inst.c"
 #line 1469 "filter/f-inst.c"
 ;
#line 1470 "filter/f-inst.c"
    
#line 1470 "filter/f-inst.c"
 #line 1470 "filter/f-inst.c"
 ;
#line 1471 "filter/f-inst.c"
    #line 1471 "filter/f-inst.c"
;
     
#line 1472 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_del(fpool, v1.val.ad, v2.val.lc)  } );
  }

  
  #undef whati
#line 1475 "filter/f-inst.c"
  }
#line 1475

#line 1475

#line 1482 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_LCLIST */
#line 1482
struct f_inst *
#line 1476 "filter/f-inst.c"
NONNULL(2)
#line 1477 "filter/f-inst.c"
NONNULL(3)
#line 1482 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_LCLIST(enum f_instruction_code fi_code
#line 1476 "filter/f-inst.c"
  , struct f_inst * f1
#line 1477 "filter/f-inst.c"
  , struct f_inst * f2
#line 1482 "filter/f-inst.c"
)
#line 1482
  {
#line 1482
    /* Allocate the structure */
#line 1482
    struct f_inst *what = fi_new(fi_code);
#line 1482
    uint constargs = 1;
#line 1482

#line 1482
    /* Initialize all the members */
#line 1482
  #define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1482
  #line 1476 "filter/f-inst.c"
whati->f1 = f1;
#line 1476
const struct f_inst *child1 = f1;
#line 1476
do {
#line 1476
  what->size += child1->size;
#line 1476

#line 1476
  if (child1->fi_code != FI_CONSTANT)
#line 1476
    constargs = 0;
#line 1476

#line 1476
} while (child1 = child1->next);
#line 1476

#line 1476 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1476
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1476
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1477 "filter/f-inst.c"
whati->f2 = f2;
#line 1477
const struct f_inst *child2 = f2;
#line 1477
do {
#line 1477
  what->size += child2->size;
#line 1477

#line 1477
  if (child2->fi_code != FI_CONSTANT)
#line 1477
    constargs = 0;
#line 1477

#line 1477
} while (child2 = child2->next);
#line 1477 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1477
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1477
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1479 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1482 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1482
    if (!constargs)
#line 1482
      return what;
#line 1482

#line 1482
    /* Try to pre-calculate the result */
#line 1482
    #line 1475 "filter/f-inst.c"
 {
    
#line 1476 "filter/f-inst.c"
 #line 1476 "filter/f-inst.c"
 ;
#line 1477 "filter/f-inst.c"
    
#line 1477 "filter/f-inst.c"
 #line 1477 "filter/f-inst.c"
 ;
#line 1478 "filter/f-inst.c"
    #line 1478 "filter/f-inst.c"
;
     
#line 1479 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1482 "filter/f-inst.c"
  }
#line 1482

#line 1482

#line 1493 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_SET */
#line 1493
struct f_inst *
#line 1483 "filter/f-inst.c"
NONNULL(2)
#line 1484 "filter/f-inst.c"
NONNULL(3)
#line 1493 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1483 "filter/f-inst.c"
  , struct f_inst * f1
#line 1484 "filter/f-inst.c"
  , struct f_inst * f2
#line 1493 "filter/f-inst.c"
)
#line 1493
  {
#line 1493
    /* Allocate the structure */
#line 1493
    struct f_inst *what = fi_new(fi_code);
#line 1493
    uint constargs = 1;
#line 1493

#line 1493
    /* Initialize all the members */
#line 1493
  #define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1493
  #line 1483 "filter/f-inst.c"
whati->f1 = f1;
#line 1483
const struct f_inst *child1 = f1;
#line 1483
do {
#line 1483
  what->size += child1->size;
#line 1483

#line 1483
  if (child1->fi_code != FI_CONSTANT)
#line 1483
    constargs = 0;
#line 1483

#line 1483
} while (child1 = child1->next);
#line 1483

#line 1483 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1483
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1483
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1484 "filter/f-inst.c"
whati->f2 = f2;
#line 1484
const struct f_inst *child2 = f2;
#line 1484
do {
#line 1484
  what->size += child2->size;
#line 1484

#line 1484
  if (child2->fi_code != FI_CONSTANT)
#line 1484
    constargs = 0;
#line 1484

#line 1484
} while (child2 = child2->next);
#line 1484 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1484
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1484
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1490 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1493 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1493
    if (!constargs)
#line 1493
      return what;
#line 1493

#line 1493
    /* Try to pre-calculate the result */
#line 1493
    #line 1482 "filter/f-inst.c"
 {
    
#line 1483 "filter/f-inst.c"
 #line 1483 "filter/f-inst.c"
 ;
#line 1484 "filter/f-inst.c"
    
#line 1484 "filter/f-inst.c"
 #line 1484 "filter/f-inst.c"
 ;
#line 1485 "filter/f-inst.c"
    #line 1485 "filter/f-inst.c"
;

    if (!lclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1490 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1493 "filter/f-inst.c"
  }
#line 1493

#line 1493

#line 1504 "filter/f-inst.c"
 /* Constructor for FI_PATH_FILTER_SET */
#line 1504
struct f_inst *
#line 1494 "filter/f-inst.c"
NONNULL(2)
#line 1495 "filter/f-inst.c"
NONNULL(3)
#line 1504 "filter/f-inst.c"
f_new_inst_FI_PATH_FILTER_SET(enum f_instruction_code fi_code
#line 1494 "filter/f-inst.c"
  , struct f_inst * f1
#line 1495 "filter/f-inst.c"
  , struct f_inst * f2
#line 1504 "filter/f-inst.c"
)
#line 1504
  {
#line 1504
    /* Allocate the structure */
#line 1504
    struct f_inst *what = fi_new(fi_code);
#line 1504
    uint constargs = 1;
#line 1504

#line 1504
    /* Initialize all the members */
#line 1504
  #define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1504
  #line 1494 "filter/f-inst.c"
whati->f1 = f1;
#line 1494
const struct f_inst *child1 = f1;
#line 1494
do {
#line 1494
  what->size += child1->size;
#line 1494

#line 1494
  if (child1->fi_code != FI_CONSTANT)
#line 1494
    constargs = 0;
#line 1494

#line 1494
} while (child1 = child1->next);
#line 1494

#line 1494 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1494
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1494
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1495 "filter/f-inst.c"
whati->f2 = f2;
#line 1495
const struct f_inst *child2 = f2;
#line 1495
do {
#line 1495
  what->size += child2->size;
#line 1495

#line 1495
  if (child2->fi_code != FI_CONSTANT)
#line 1495
    constargs = 0;
#line 1495

#line 1495
} while (child2 = child2->next);
#line 1495 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1495
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1495
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1501 "filter/f-inst.c"
what->type = T_PATH;

#line 1504 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1504
    if (!constargs)
#line 1504
      return what;
#line 1504

#line 1504
    /* Try to pre-calculate the result */
#line 1504
    #line 1493 "filter/f-inst.c"
 {
    
#line 1494 "filter/f-inst.c"
 #line 1494 "filter/f-inst.c"
 ;
#line 1495 "filter/f-inst.c"
    
#line 1495 "filter/f-inst.c"
 #line 1495 "filter/f-inst.c"
 ;
#line 1496 "filter/f-inst.c"
    #line 1496 "filter/f-inst.c"
;

    if (!path_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1501 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1504 "filter/f-inst.c"
  }
#line 1504

#line 1504

#line 1511 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FILTER_CLIST */
#line 1511
struct f_inst *
#line 1505 "filter/f-inst.c"
NONNULL(2)
#line 1506 "filter/f-inst.c"
NONNULL(3)
#line 1511 "filter/f-inst.c"
f_new_inst_FI_CLIST_FILTER_CLIST(enum f_instruction_code fi_code
#line 1505 "filter/f-inst.c"
  , struct f_inst * f1
#line 1506 "filter/f-inst.c"
  , struct f_inst * f2
#line 1511 "filter/f-inst.c"
)
#line 1511
  {
#line 1511
    /* Allocate the structure */
#line 1511
    struct f_inst *what = fi_new(fi_code);
#line 1511
    uint constargs = 1;
#line 1511

#line 1511
    /* Initialize all the members */
#line 1511
  #define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1511
  #line 1505 "filter/f-inst.c"
whati->f1 = f1;
#line 1505
const struct f_inst *child1 = f1;
#line 1505
do {
#line 1505
  what->size += child1->size;
#line 1505

#line 1505
  if (child1->fi_code != FI_CONSTANT)
#line 1505
    constargs = 0;
#line 1505

#line 1505
} while (child1 = child1->next);
#line 1505

#line 1505 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1505
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1505
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1506 "filter/f-inst.c"
whati->f2 = f2;
#line 1506
const struct f_inst *child2 = f2;
#line 1506
do {
#line 1506
  what->size += child2->size;
#line 1506

#line 1506
  if (child2->fi_code != FI_CONSTANT)
#line 1506
    constargs = 0;
#line 1506

#line 1506
} while (child2 = child2->next);
#line 1506 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1506
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1506
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1508 "filter/f-inst.c"
what->type = T_CLIST;

#line 1511 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1511
    if (!constargs)
#line 1511
      return what;
#line 1511

#line 1511
    /* Try to pre-calculate the result */
#line 1511
    #line 1504 "filter/f-inst.c"
 {
    
#line 1505 "filter/f-inst.c"
 #line 1505 "filter/f-inst.c"
 ;
#line 1506 "filter/f-inst.c"
    
#line 1506 "filter/f-inst.c"
 #line 1506 "filter/f-inst.c"
 ;
#line 1507 "filter/f-inst.c"
    #line 1507 "filter/f-inst.c"
;
     
#line 1508 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1511 "filter/f-inst.c"
  }
#line 1511

#line 1511

#line 1522 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FILTER_SET */
#line 1522
struct f_inst *
#line 1512 "filter/f-inst.c"
NONNULL(2)
#line 1513 "filter/f-inst.c"
NONNULL(3)
#line 1522 "filter/f-inst.c"
f_new_inst_FI_CLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1512 "filter/f-inst.c"
  , struct f_inst * f1
#line 1513 "filter/f-inst.c"
  , struct f_inst * f2
#line 1522 "filter/f-inst.c"
)
#line 1522
  {
#line 1522
    /* Allocate the structure */
#line 1522
    struct f_inst *what = fi_new(fi_code);
#line 1522
    uint constargs = 1;
#line 1522

#line 1522
    /* Initialize all the members */
#line 1522
  #define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1522
  #line 1512 "filter/f-inst.c"
whati->f1 = f1;
#line 1512
const struct f_inst *child1 = f1;
#line 1512
do {
#line 1512
  what->size += child1->size;
#line 1512

#line 1512
  if (child1->fi_code != FI_CONSTANT)
#line 1512
    constargs = 0;
#line 1512

#line 1512
} while (child1 = child1->next);
#line 1512

#line 1512 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1512
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1512
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1513 "filter/f-inst.c"
whati->f2 = f2;
#line 1513
const struct f_inst *child2 = f2;
#line 1513
do {
#line 1513
  what->size += child2->size;
#line 1513

#line 1513
  if (child2->fi_code != FI_CONSTANT)
#line 1513
    constargs = 0;
#line 1513

#line 1513
} while (child2 = child2->next);
#line 1513 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1513
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1513
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1519 "filter/f-inst.c"
what->type = T_CLIST;

#line 1522 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1522
    if (!constargs)
#line 1522
      return what;
#line 1522

#line 1522
    /* Try to pre-calculate the result */
#line 1522
    #line 1511 "filter/f-inst.c"
 {
    
#line 1512 "filter/f-inst.c"
 #line 1512 "filter/f-inst.c"
 ;
#line 1513 "filter/f-inst.c"
    
#line 1513 "filter/f-inst.c"
 #line 1513 "filter/f-inst.c"
 ;
#line 1514 "filter/f-inst.c"
    #line 1514 "filter/f-inst.c"
;

    if (!clist_set_type(v2.val.t, &(struct f_val){}))
      runtime("Mismatched set type");

     
#line 1519 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1522 "filter/f-inst.c"
  }
#line 1522

#line 1522

#line 1529 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FILTER_ECLIST */
#line 1529
struct f_inst *
#line 1523 "filter/f-inst.c"
NONNULL(2)
#line 1524 "filter/f-inst.c"
NONNULL(3)
#line 1529 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FILTER_ECLIST(enum f_instruction_code fi_code
#line 1523 "filter/f-inst.c"
  , struct f_inst * f1
#line 1524 "filter/f-inst.c"
  , struct f_inst * f2
#line 1529 "filter/f-inst.c"
)
#line 1529
  {
#line 1529
    /* Allocate the structure */
#line 1529
    struct f_inst *what = fi_new(fi_code);
#line 1529
    uint constargs = 1;
#line 1529

#line 1529
    /* Initialize all the members */
#line 1529
  #define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1529
  #line 1523 "filter/f-inst.c"
whati->f1 = f1;
#line 1523
const struct f_inst *child1 = f1;
#line 1523
do {
#line 1523
  what->size += child1->size;
#line 1523

#line 1523
  if (child1->fi_code != FI_CONSTANT)
#line 1523
    constargs = 0;
#line 1523

#line 1523
} while (child1 = child1->next);
#line 1523

#line 1523 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1523
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1523
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1524 "filter/f-inst.c"
whati->f2 = f2;
#line 1524
const struct f_inst *child2 = f2;
#line 1524
do {
#line 1524
  what->size += child2->size;
#line 1524

#line 1524
  if (child2->fi_code != FI_CONSTANT)
#line 1524
    constargs = 0;
#line 1524

#line 1524
} while (child2 = child2->next);
#line 1524 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1524
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1524
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1526 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1529 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1529
    if (!constargs)
#line 1529
      return what;
#line 1529

#line 1529
    /* Try to pre-calculate the result */
#line 1529
    #line 1522 "filter/f-inst.c"
 {
    
#line 1523 "filter/f-inst.c"
 #line 1523 "filter/f-inst.c"
 ;
#line 1524 "filter/f-inst.c"
    
#line 1524 "filter/f-inst.c"
 #line 1524 "filter/f-inst.c"
 ;
#line 1525 "filter/f-inst.c"
    #line 1525 "filter/f-inst.c"
;
     
#line 1526 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1529 "filter/f-inst.c"
  }
#line 1529

#line 1529

#line 1540 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FILTER_SET */
#line 1540
struct f_inst *
#line 1530 "filter/f-inst.c"
NONNULL(2)
#line 1531 "filter/f-inst.c"
NONNULL(3)
#line 1540 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1530 "filter/f-inst.c"
  , struct f_inst * f1
#line 1531 "filter/f-inst.c"
  , struct f_inst * f2
#line 1540 "filter/f-inst.c"
)
#line 1540
  {
#line 1540
    /* Allocate the structure */
#line 1540
    struct f_inst *what = fi_new(fi_code);
#line 1540
    uint constargs = 1;
#line 1540

#line 1540
    /* Initialize all the members */
#line 1540
  #define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1540
  #line 1530 "filter/f-inst.c"
whati->f1 = f1;
#line 1530
const struct f_inst *child1 = f1;
#line 1530
do {
#line 1530
  what->size += child1->size;
#line 1530

#line 1530
  if (child1->fi_code != FI_CONSTANT)
#line 1530
    constargs = 0;
#line 1530

#line 1530
} while (child1 = child1->next);
#line 1530

#line 1530 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1530
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1530
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1531 "filter/f-inst.c"
whati->f2 = f2;
#line 1531
const struct f_inst *child2 = f2;
#line 1531
do {
#line 1531
  what->size += child2->size;
#line 1531

#line 1531
  if (child2->fi_code != FI_CONSTANT)
#line 1531
    constargs = 0;
#line 1531

#line 1531
} while (child2 = child2->next);
#line 1531 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1531
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1531
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1537 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1540 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1540
    if (!constargs)
#line 1540
      return what;
#line 1540

#line 1540
    /* Try to pre-calculate the result */
#line 1540
    #line 1529 "filter/f-inst.c"
 {
    
#line 1530 "filter/f-inst.c"
 #line 1530 "filter/f-inst.c"
 ;
#line 1531 "filter/f-inst.c"
    
#line 1531 "filter/f-inst.c"
 #line 1531 "filter/f-inst.c"
 ;
#line 1532 "filter/f-inst.c"
    #line 1532 "filter/f-inst.c"
;

    if (!eclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1537 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1540 "filter/f-inst.c"
  }
#line 1540

#line 1540

#line 1547 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FILTER_LCLIST */
#line 1547
struct f_inst *
#line 1541 "filter/f-inst.c"
NONNULL(2)
#line 1542 "filter/f-inst.c"
NONNULL(3)
#line 1547 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FILTER_LCLIST(enum f_instruction_code fi_code
#line 1541 "filter/f-inst.c"
  , struct f_inst * f1
#line 1542 "filter/f-inst.c"
  , struct f_inst * f2
#line 1547 "filter/f-inst.c"
)
#line 1547
  {
#line 1547
    /* Allocate the structure */
#line 1547
    struct f_inst *what = fi_new(fi_code);
#line 1547
    uint constargs = 1;
#line 1547

#line 1547
    /* Initialize all the members */
#line 1547
  #define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1547
  #line 1541 "filter/f-inst.c"
whati->f1 = f1;
#line 1541
const struct f_inst *child1 = f1;
#line 1541
do {
#line 1541
  what->size += child1->size;
#line 1541

#line 1541
  if (child1->fi_code != FI_CONSTANT)
#line 1541
    constargs = 0;
#line 1541

#line 1541
} while (child1 = child1->next);
#line 1541

#line 1541 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1541
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1541
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1542 "filter/f-inst.c"
whati->f2 = f2;
#line 1542
const struct f_inst *child2 = f2;
#line 1542
do {
#line 1542
  what->size += child2->size;
#line 1542

#line 1542
  if (child2->fi_code != FI_CONSTANT)
#line 1542
    constargs = 0;
#line 1542

#line 1542
} while (child2 = child2->next);
#line 1542 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1542
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1542
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1544 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1547 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1547
    if (!constargs)
#line 1547
      return what;
#line 1547

#line 1547
    /* Try to pre-calculate the result */
#line 1547
    #line 1540 "filter/f-inst.c"
 {
    
#line 1541 "filter/f-inst.c"
 #line 1541 "filter/f-inst.c"
 ;
#line 1542 "filter/f-inst.c"
    
#line 1542 "filter/f-inst.c"
 #line 1542 "filter/f-inst.c"
 ;
#line 1543 "filter/f-inst.c"
    #line 1543 "filter/f-inst.c"
;
     
#line 1544 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1547 "filter/f-inst.c"
  }
#line 1547

#line 1547

#line 1558 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FILTER_SET */
#line 1558
struct f_inst *
#line 1548 "filter/f-inst.c"
NONNULL(2)
#line 1549 "filter/f-inst.c"
NONNULL(3)
#line 1558 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1548 "filter/f-inst.c"
  , struct f_inst * f1
#line 1549 "filter/f-inst.c"
  , struct f_inst * f2
#line 1558 "filter/f-inst.c"
)
#line 1558
  {
#line 1558
    /* Allocate the structure */
#line 1558
    struct f_inst *what = fi_new(fi_code);
#line 1558
    uint constargs = 1;
#line 1558

#line 1558
    /* Initialize all the members */
#line 1558
  #define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1558
  #line 1548 "filter/f-inst.c"
whati->f1 = f1;
#line 1548
const struct f_inst *child1 = f1;
#line 1548
do {
#line 1548
  what->size += child1->size;
#line 1548

#line 1548
  if (child1->fi_code != FI_CONSTANT)
#line 1548
    constargs = 0;
#line 1548

#line 1548
} while (child1 = child1->next);
#line 1548

#line 1548 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1548
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1548
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1549 "filter/f-inst.c"
whati->f2 = f2;
#line 1549
const struct f_inst *child2 = f2;
#line 1549
do {
#line 1549
  what->size += child2->size;
#line 1549

#line 1549
  if (child2->fi_code != FI_CONSTANT)
#line 1549
    constargs = 0;
#line 1549

#line 1549
} while (child2 = child2->next);
#line 1549 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1549
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1549
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1555 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1558 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1558
    if (!constargs)
#line 1558
      return what;
#line 1558

#line 1558
    /* Try to pre-calculate the result */
#line 1558
    #line 1547 "filter/f-inst.c"
 {
    
#line 1548 "filter/f-inst.c"
 #line 1548 "filter/f-inst.c"
 ;
#line 1549 "filter/f-inst.c"
    
#line 1549 "filter/f-inst.c"
 #line 1549 "filter/f-inst.c"
 ;
#line 1550 "filter/f-inst.c"
    #line 1550 "filter/f-inst.c"
;

    if (!lclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1555 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1558 "filter/f-inst.c"
  }
#line 1558

#line 1558

#line 1580 "filter/f-inst.c"
 /* Constructor for FI_ROA_CHECK */
#line 1580
struct f_inst *
#line 1560 "filter/f-inst.c"
NONNULL(2)
#line 1561 "filter/f-inst.c"
NONNULL(3)
#line 1580 "filter/f-inst.c"
f_new_inst_FI_ROA_CHECK(enum f_instruction_code fi_code
#line 1560 "filter/f-inst.c"
  , struct f_inst * f1
#line 1561 "filter/f-inst.c"
  , struct f_inst * f2
#line 1562 "filter/f-inst.c"
  , struct rtable_config * rtc
#line 1580 "filter/f-inst.c"
)
#line 1580
  {
#line 1580
    /* Allocate the structure */
#line 1580
    struct f_inst *what = fi_new(fi_code);
#line 1580
    
#line 1580

#line 1580
    /* Initialize all the members */
#line 1580
  #define whati (&(what->i_FI_ROA_CHECK))
#line 1580
  #line 1560 "filter/f-inst.c"
whati->f1 = f1;
#line 1560
const struct f_inst *child1 = f1;
#line 1560
do {
#line 1560
  what->size += child1->size;
#line 1560

#line 1560
} while (child1 = child1->next);
#line 1560

#line 1560 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1560
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1560
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1561 "filter/f-inst.c"
whati->f2 = f2;
#line 1561
const struct f_inst *child2 = f2;
#line 1561
do {
#line 1561
  what->size += child2->size;
#line 1561

#line 1561
} while (child2 = child2->next);
#line 1561 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1561
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1561
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1562 "filter/f-inst.c"
whati->rtc = rtc;
#line 1574 "filter/f-inst.c"
what->type = T_ENUM_ROA;

#line 1580 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1580
    
#line 1580
      return what;
#line 1580

#line 1580
    /* Try to pre-calculate the result */
#line 1580
      #undef whati
#line 1580
  }
#line 1580

#line 1580

#line 1596 "filter/f-inst.c"
 /* Constructor for FI_ASPA_CHECK_EXPLICIT */
#line 1596
struct f_inst *
#line 1582 "filter/f-inst.c"
NONNULL(2)
#line 1583 "filter/f-inst.c"
NONNULL(3)
#line 1596 "filter/f-inst.c"
f_new_inst_FI_ASPA_CHECK_EXPLICIT(enum f_instruction_code fi_code
#line 1582 "filter/f-inst.c"
  , struct f_inst * f1
#line 1583 "filter/f-inst.c"
  , struct f_inst * f2
#line 1584 "filter/f-inst.c"
  , struct rtable_config * rtc
#line 1596 "filter/f-inst.c"
)
#line 1596
  {
#line 1596
    /* Allocate the structure */
#line 1596
    struct f_inst *what = fi_new(fi_code);
#line 1596
    
#line 1596

#line 1596
    /* Initialize all the members */
#line 1596
  #define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1596
  #line 1582 "filter/f-inst.c"
whati->f1 = f1;
#line 1582
const struct f_inst *child1 = f1;
#line 1582
do {
#line 1582
  what->size += child1->size;
#line 1582

#line 1582
} while (child1 = child1->next);
#line 1582

#line 1582 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1582
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1582
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1583 "filter/f-inst.c"
whati->f2 = f2;
#line 1583
const struct f_inst *child2 = f2;
#line 1583
do {
#line 1583
  what->size += child2->size;
#line 1583

#line 1583
} while (child2 = child2->next);
#line 1583 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 1583
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1583
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 1584 "filter/f-inst.c"
whati->rtc = rtc;
#line 1593 "filter/f-inst.c"
what->type = T_ENUM_ASPA;

#line 1596 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1596
    
#line 1596
      return what;
#line 1596

#line 1596
    /* Try to pre-calculate the result */
#line 1596
      #undef whati
#line 1596
  }
#line 1596

#line 1596

#line 1611 "filter/f-inst.c"
 /* Constructor for FI_FROM_HEX */
#line 1611
struct f_inst *
#line 1597 "filter/f-inst.c"
NONNULL(2)
#line 1611 "filter/f-inst.c"
f_new_inst_FI_FROM_HEX(enum f_instruction_code fi_code
#line 1597 "filter/f-inst.c"
  , struct f_inst * f1
#line 1611 "filter/f-inst.c"
)
#line 1611
  {
#line 1611
    /* Allocate the structure */
#line 1611
    struct f_inst *what = fi_new(fi_code);
#line 1611
    uint constargs = 1;
#line 1611

#line 1611
    /* Initialize all the members */
#line 1611
  #define whati (&(what->i_FI_FROM_HEX))
#line 1611
  #line 1597 "filter/f-inst.c"
whati->f1 = f1;
#line 1597
const struct f_inst *child1 = f1;
#line 1597
do {
#line 1597
  what->size += child1->size;
#line 1597

#line 1597
  if (child1->fi_code != FI_CONSTANT)
#line 1597
    constargs = 0;
#line 1597

#line 1597
} while (child1 = child1->next);
#line 1597

#line 1597 "filter/f-inst.c"
if (f1->type && (f1->type != (T_STRING)) && !f_const_promotion(f1, (T_STRING)))
#line 1597
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1597
	   f_instruction_name(what->fi_code), f_type_name(T_STRING), f_type_name(f1->type));
#line 1608 "filter/f-inst.c"
what->type = T_BYTESTRING;

#line 1611 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1611
    if (!constargs)
#line 1611
      return what;
#line 1611

#line 1611
    /* Try to pre-calculate the result */
#line 1611
    #line 1596 "filter/f-inst.c"
 {	/* Convert hex text to bytestring */
    
#line 1597 "filter/f-inst.c"
 #line 1597 "filter/f-inst.c"
 ;
#line 1598 "filter/f-inst.c"

    int len = bstrhextobin(v1.val.s, NULL);
    if (len < 0)
      runtime("Invalid hex string");

    struct adata *bs;
    bs = falloc(sizeof(struct adata) + len);
    bs->length = bstrhextobin(v1.val.s, bs->data);
    ASSERT(bs->length == (size_t) len);

     
#line 1608 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BYTESTRING, .val.bs = bs } );
  }

  
  #undef whati
#line 1611 "filter/f-inst.c"
  }
#line 1611

#line 1611

#line 1616 "filter/f-inst.c"
 /* Constructor for FI_FORMAT */
#line 1616
struct f_inst *
#line 1612 "filter/f-inst.c"
NONNULL(2)
#line 1616 "filter/f-inst.c"
f_new_inst_FI_FORMAT(enum f_instruction_code fi_code
#line 1612 "filter/f-inst.c"
  , struct f_inst * f1
#line 1616 "filter/f-inst.c"
)
#line 1616
  {
#line 1616
    /* Allocate the structure */
#line 1616
    struct f_inst *what = fi_new(fi_code);
#line 1616
    uint constargs = 1;
#line 1616

#line 1616
    /* Initialize all the members */
#line 1616
  #define whati (&(what->i_FI_FORMAT))
#line 1616
  #line 1612 "filter/f-inst.c"
whati->f1 = f1;
#line 1612
const struct f_inst *child1 = f1;
#line 1612
do {
#line 1612
  what->size += child1->size;
#line 1612

#line 1612
  if (child1->fi_code != FI_CONSTANT)
#line 1612
    constargs = 0;
#line 1612

#line 1612
} while (child1 = child1->next);
#line 1612

#line 1613 "filter/f-inst.c"
what->type = T_STRING;

#line 1616 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1616
    if (!constargs)
#line 1616
      return what;
#line 1616

#line 1616
    /* Try to pre-calculate the result */
#line 1616
    #line 1611 "filter/f-inst.c"
 {	/* Format */
    
#line 1612 "filter/f-inst.c"
;
     
#line 1613 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s = val_format_str(fpool, &v1) } );
  }

  
  #undef whati
#line 1616 "filter/f-inst.c"
  }
#line 1616

#line 1616

#line 830 "filter/decl.m4"
 /* Constructor for FI_ASSERT */
#line 830
struct f_inst *
#line 1618 "filter/f-inst.c"
NONNULL(2)
#line 830 "filter/decl.m4"
f_new_inst_FI_ASSERT(enum f_instruction_code fi_code
#line 1618 "filter/f-inst.c"
  , struct f_inst * f1
#line 1620 "filter/f-inst.c"
  , char * s
#line 830 "filter/decl.m4"
)
#line 830
  {
#line 830
    /* Allocate the structure */
#line 830
    struct f_inst *what = fi_new(fi_code);
#line 830
    
#line 830

#line 830
    /* Initialize all the members */
#line 830
  #define whati (&(what->i_FI_ASSERT))
#line 830
  #line 1618 "filter/f-inst.c"
whati->f1 = f1;
#line 1618
const struct f_inst *child1 = f1;
#line 1618
do {
#line 1618
  what->size += child1->size;
#line 1618

#line 1618
} while (child1 = child1->next);
#line 1618

#line 1618 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 1618
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1618
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 1620 "filter/f-inst.c"
whati->s = s;

#line 830 "filter/decl.m4"
    /* If not constant, return the instruction itself */
#line 830
    
#line 830
      return what;
#line 830

#line 830
    /* Try to pre-calculate the result */
#line 830
      #undef whati
#line 830
  }
#line 830

#line 830

#line 611 "filter/decl.m4"

#undef v1
#undef v2
#undef v3
#undef vv

/* Method constructor wrappers */
#line 288 "filter/f-inst.c"

#line 293 "filter/f-inst.c"

#line 298 "filter/f-inst.c"

#line 304 "filter/f-inst.c"

#line 309 "filter/f-inst.c"

#line 314 "filter/f-inst.c"

#line 324 "filter/f-inst.c"

#line 335 "filter/f-inst.c"

#line 345 "filter/f-inst.c"

#line 385 "filter/f-inst.c"

#line 392 "filter/f-inst.c"

#line 442 "filter/f-inst.c"

#line 449 "filter/f-inst.c"

#line 456 "filter/f-inst.c"

#line 467 "filter/f-inst.c"

#line 478 "filter/f-inst.c"

#line 483 "filter/f-inst.c"

#line 492 "filter/f-inst.c"

#line 501 "filter/f-inst.c"

#line 506 "filter/f-inst.c"

#line 507 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__type */
#line 507
struct f_inst * NONNULL(1)
#line 507
f_new_method_FI_METHOD__T_NET__type(struct f_inst *obj, struct f_inst *args)
#line 507
  {
#line 507
    /* Unwind the arguments (1) */
#line 507
        if (args) cf_error("Too many arguments");
#line 506 "filter/f-inst.c"

#line 506

    return f_new_inst(FI_METHOD__T_NET__type, obj
#line 507 "filter/f-inst.c"

#line 507
    );
#line 507
  }
#line 507

#line 510 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_IP__is_v4 */
#line 510
struct f_inst * NONNULL(1)
#line 510
f_new_method_FI_METHOD__T_IP__is_v4(struct f_inst *obj, struct f_inst *args)
#line 510
  {
#line 510
    /* Unwind the arguments (1) */
#line 510
        if (args) cf_error("Too many arguments");
#line 507 "filter/f-inst.c"

#line 507

    return f_new_inst(FI_METHOD__T_IP__is_v4, obj
#line 510 "filter/f-inst.c"

#line 510
    );
#line 510
  }
#line 510

#line 523 "filter/f-inst.c"

#line 534 "filter/f-inst.c"

#line 543 "filter/f-inst.c"

#line 550 "filter/f-inst.c"

#line 563 "filter/f-inst.c"

#line 564 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__empty */
#line 564
struct f_inst * NONNULL(1)
#line 564
f_new_method_FI_METHOD__T_PATH__empty(struct f_inst *obj, struct f_inst *args)
#line 564
  {
#line 564
    /* Unwind the arguments (1) */
#line 564
        if (args) cf_error("Too many arguments");
#line 563 "filter/f-inst.c"

#line 563

    return f_new_inst(FI_METHOD__T_PATH__empty, obj
#line 564 "filter/f-inst.c"

#line 564
    );
#line 564
  }
#line 564

#line 565 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__empty */
#line 565
struct f_inst * NONNULL(1)
#line 565
f_new_method_FI_METHOD__T_CLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 565
  {
#line 565
    /* Unwind the arguments (1) */
#line 565
        if (args) cf_error("Too many arguments");
#line 564 "filter/f-inst.c"

#line 564

    return f_new_inst(FI_METHOD__T_CLIST__empty, obj
#line 565 "filter/f-inst.c"

#line 565
    );
#line 565
  }
#line 565

#line 566 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__empty */
#line 566
struct f_inst * NONNULL(1)
#line 566
f_new_method_FI_METHOD__T_ECLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 566
  {
#line 566
    /* Unwind the arguments (1) */
#line 566
        if (args) cf_error("Too many arguments");
#line 565 "filter/f-inst.c"

#line 565

    return f_new_inst(FI_METHOD__T_ECLIST__empty, obj
#line 566 "filter/f-inst.c"

#line 566
    );
#line 566
  }
#line 566

#line 569 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__empty */
#line 569
struct f_inst * NONNULL(1)
#line 569
f_new_method_FI_METHOD__T_LCLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 569
  {
#line 569
    /* Unwind the arguments (1) */
#line 569
        if (args) cf_error("Too many arguments");
#line 566 "filter/f-inst.c"

#line 566

    return f_new_inst(FI_METHOD__T_LCLIST__empty, obj
#line 569 "filter/f-inst.c"

#line 569
    );
#line 569
  }
#line 569

#line 591 "filter/f-inst.c"

#line 600 "filter/f-inst.c"
 /* Method constructor for FI_PATH_FOR_NEXT */
#line 600
struct f_inst * NONNULL(1)
#line 600
f_new_method_FI_PATH_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 600
  {
#line 600
    /* Unwind the arguments (2) */
#line 600
    #line 595 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 595
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_FOR_NEXT */
#line 595
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 597 "filter/f-inst.c"

#line 597

    return f_new_inst(FI_PATH_FOR_NEXT, obj
#line 595 "filter/f-inst.c"
    , arg2
#line 600 "filter/f-inst.c"

#line 600
    );
#line 600
  }
#line 600

#line 609 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FOR_NEXT */
#line 609
struct f_inst * NONNULL(1)
#line 609
f_new_method_FI_CLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 609
  {
#line 609
    /* Unwind the arguments (2) */
#line 609
    #line 604 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 604
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FOR_NEXT */
#line 604
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 606 "filter/f-inst.c"

#line 606

    return f_new_inst(FI_CLIST_FOR_NEXT, obj
#line 604 "filter/f-inst.c"
    , arg2
#line 609 "filter/f-inst.c"

#line 609
    );
#line 609
  }
#line 609

#line 618 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FOR_NEXT */
#line 618
struct f_inst * NONNULL(1)
#line 618
f_new_method_FI_ECLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 618
  {
#line 618
    /* Unwind the arguments (2) */
#line 618
    #line 613 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 613
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FOR_NEXT */
#line 613
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 615 "filter/f-inst.c"

#line 615

    return f_new_inst(FI_ECLIST_FOR_NEXT, obj
#line 613 "filter/f-inst.c"
    , arg2
#line 618 "filter/f-inst.c"

#line 618
    );
#line 618
  }
#line 618

#line 627 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FOR_NEXT */
#line 627
struct f_inst * NONNULL(1)
#line 627
f_new_method_FI_LCLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 627
  {
#line 627
    /* Unwind the arguments (2) */
#line 627
    #line 622 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 622
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FOR_NEXT */
#line 622
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 624 "filter/f-inst.c"

#line 624

    return f_new_inst(FI_LCLIST_FOR_NEXT, obj
#line 622 "filter/f-inst.c"
    , arg2
#line 627 "filter/f-inst.c"

#line 627
    );
#line 627
  }
#line 627

#line 640 "filter/f-inst.c"
 /* Method constructor for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
struct f_inst * NONNULL(1)
#line 640
f_new_method_FI_ROUTES_BLOCK_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 640
  {
#line 640
    /* Unwind the arguments (2) */
#line 640
    #line 634 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 634
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ROUTES_BLOCK_FOR_NEXT */
#line 634
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 637 "filter/f-inst.c"

#line 637

    return f_new_inst(FI_ROUTES_BLOCK_FOR_NEXT, obj
#line 634 "filter/f-inst.c"
    , arg2
#line 640 "filter/f-inst.c"

#line 640
    );
#line 640
  }
#line 640

#line 648 "filter/f-inst.c"

#line 661 "filter/f-inst.c"

#line 668 "filter/f-inst.c"

#line 682 "filter/f-inst.c"

#line 689 "filter/f-inst.c"

#line 740 "filter/f-inst.c"

#line 897 "filter/f-inst.c"

#line 934 "filter/f-inst.c"

#line 975 "filter/f-inst.c"

#line 982 "filter/f-inst.c"

#line 996 "filter/f-inst.c"

#line 997 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__len */
#line 997
struct f_inst * NONNULL(1)
#line 997
f_new_method_FI_METHOD__T_NET__len(struct f_inst *obj, struct f_inst *args)
#line 997
  {
#line 997
    /* Unwind the arguments (1) */
#line 997
        if (args) cf_error("Too many arguments");
#line 996 "filter/f-inst.c"

#line 996

    return f_new_inst(FI_METHOD__T_NET__len, obj
#line 997 "filter/f-inst.c"

#line 997
    );
#line 997
  }
#line 997

#line 998 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__len */
#line 998
struct f_inst * NONNULL(1)
#line 998
f_new_method_FI_METHOD__T_PATH__len(struct f_inst *obj, struct f_inst *args)
#line 998
  {
#line 998
    /* Unwind the arguments (1) */
#line 998
        if (args) cf_error("Too many arguments");
#line 997 "filter/f-inst.c"

#line 997

    return f_new_inst(FI_METHOD__T_PATH__len, obj
#line 998 "filter/f-inst.c"

#line 998
    );
#line 998
  }
#line 998

#line 999 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__len */
#line 999
struct f_inst * NONNULL(1)
#line 999
f_new_method_FI_METHOD__T_CLIST__len(struct f_inst *obj, struct f_inst *args)
#line 999
  {
#line 999
    /* Unwind the arguments (1) */
#line 999
        if (args) cf_error("Too many arguments");
#line 998 "filter/f-inst.c"

#line 998

    return f_new_inst(FI_METHOD__T_CLIST__len, obj
#line 999 "filter/f-inst.c"

#line 999
    );
#line 999
  }
#line 999

#line 1000 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__len */
#line 1000
struct f_inst * NONNULL(1)
#line 1000
f_new_method_FI_METHOD__T_ECLIST__len(struct f_inst *obj, struct f_inst *args)
#line 1000
  {
#line 1000
    /* Unwind the arguments (1) */
#line 1000
        if (args) cf_error("Too many arguments");
#line 999 "filter/f-inst.c"

#line 999

    return f_new_inst(FI_METHOD__T_ECLIST__len, obj
#line 1000 "filter/f-inst.c"

#line 1000
    );
#line 1000
  }
#line 1000

#line 1002 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__len */
#line 1002
struct f_inst * NONNULL(1)
#line 1002
f_new_method_FI_METHOD__T_LCLIST__len(struct f_inst *obj, struct f_inst *args)
#line 1002
  {
#line 1002
    /* Unwind the arguments (1) */
#line 1002
        if (args) cf_error("Too many arguments");
#line 1000 "filter/f-inst.c"

#line 1000

    return f_new_inst(FI_METHOD__T_LCLIST__len, obj
#line 1002 "filter/f-inst.c"

#line 1002
    );
#line 1002
  }
#line 1002

#line 1038 "filter/f-inst.c"
 /* Method constructor for FI_NET_SRC */
#line 1038
struct f_inst * NONNULL(1)
#line 1038
f_new_method_FI_NET_SRC(struct f_inst *obj, struct f_inst *args)
#line 1038
  {
#line 1038
    /* Unwind the arguments (1) */
#line 1038
        if (args) cf_error("Too many arguments");
#line 1004 "filter/f-inst.c"

#line 1004

    return f_new_inst(FI_NET_SRC, obj
#line 1038 "filter/f-inst.c"

#line 1038
    );
#line 1038
  }
#line 1038

#line 1075 "filter/f-inst.c"
 /* Method constructor for FI_NET_DST */
#line 1075
struct f_inst * NONNULL(1)
#line 1075
f_new_method_FI_NET_DST(struct f_inst *obj, struct f_inst *args)
#line 1075
  {
#line 1075
    /* Unwind the arguments (1) */
#line 1075
        if (args) cf_error("Too many arguments");
#line 1040 "filter/f-inst.c"

#line 1040

    return f_new_inst(FI_NET_DST, obj
#line 1075 "filter/f-inst.c"

#line 1075
    );
#line 1075
  }
#line 1075

#line 1085 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__maxlen */
#line 1085
struct f_inst * NONNULL(1)
#line 1085
f_new_method_FI_METHOD__T_NET__maxlen(struct f_inst *obj, struct f_inst *args)
#line 1085
  {
#line 1085
    /* Unwind the arguments (1) */
#line 1085
        if (args) cf_error("Too many arguments");
#line 1075 "filter/f-inst.c"

#line 1075

    return f_new_inst(FI_METHOD__T_NET__maxlen, obj
#line 1085 "filter/f-inst.c"

#line 1085
    );
#line 1085
  }
#line 1085

#line 1095 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__asn */
#line 1095
struct f_inst * NONNULL(1)
#line 1095
f_new_method_FI_METHOD__T_NET__asn(struct f_inst *obj, struct f_inst *args)
#line 1095
  {
#line 1095
    /* Unwind the arguments (1) */
#line 1095
        if (args) cf_error("Too many arguments");
#line 1085 "filter/f-inst.c"

#line 1085

    return f_new_inst(FI_METHOD__T_NET__asn, obj
#line 1095 "filter/f-inst.c"

#line 1095
    );
#line 1095
  }
#line 1095

#line 1097 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__ip */
#line 1097
struct f_inst * NONNULL(1)
#line 1097
f_new_method_FI_METHOD__T_NET__ip(struct f_inst *obj, struct f_inst *args)
#line 1097
  {
#line 1097
    /* Unwind the arguments (1) */
#line 1097
        if (args) cf_error("Too many arguments");
#line 1095 "filter/f-inst.c"

#line 1095

    return f_new_inst(FI_METHOD__T_NET__ip, obj
#line 1097 "filter/f-inst.c"

#line 1097
    );
#line 1097
  }
#line 1097

#line 1106 "filter/f-inst.c"
 /* Method constructor for FI_ROUTE_DISTINGUISHER */
#line 1106
struct f_inst * NONNULL(1)
#line 1106
f_new_method_FI_ROUTE_DISTINGUISHER(struct f_inst *obj, struct f_inst *args)
#line 1106
  {
#line 1106
    /* Unwind the arguments (1) */
#line 1106
        if (args) cf_error("Too many arguments");
#line 1099 "filter/f-inst.c"

#line 1099

    return f_new_inst(FI_ROUTE_DISTINGUISHER, obj
#line 1106 "filter/f-inst.c"

#line 1106
    );
#line 1106
  }
#line 1106

#line 1109 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__first */
#line 1109
struct f_inst * NONNULL(1)
#line 1109
f_new_method_FI_METHOD__T_PATH__first(struct f_inst *obj, struct f_inst *args)
#line 1109
  {
#line 1109
    /* Unwind the arguments (1) */
#line 1109
        if (args) cf_error("Too many arguments");
#line 1106 "filter/f-inst.c"

#line 1106

    return f_new_inst(FI_METHOD__T_PATH__first, obj
#line 1109 "filter/f-inst.c"

#line 1109
    );
#line 1109
  }
#line 1109

#line 1112 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__last */
#line 1112
struct f_inst * NONNULL(1)
#line 1112
f_new_method_FI_METHOD__T_PATH__last(struct f_inst *obj, struct f_inst *args)
#line 1112
  {
#line 1112
    /* Unwind the arguments (1) */
#line 1112
        if (args) cf_error("Too many arguments");
#line 1109 "filter/f-inst.c"

#line 1109

    return f_new_inst(FI_METHOD__T_PATH__last, obj
#line 1112 "filter/f-inst.c"

#line 1112
    );
#line 1112
  }
#line 1112

#line 1115 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
struct f_inst * NONNULL(1)
#line 1115
f_new_method_FI_METHOD__T_PATH__last_nonaggregated(struct f_inst *obj, struct f_inst *args)
#line 1115
  {
#line 1115
    /* Unwind the arguments (1) */
#line 1115
        if (args) cf_error("Too many arguments");
#line 1112 "filter/f-inst.c"

#line 1112

    return f_new_inst(FI_METHOD__T_PATH__last_nonaggregated, obj
#line 1115 "filter/f-inst.c"

#line 1115
    );
#line 1115
  }
#line 1115

#line 1118 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PAIR__asn */
#line 1118
struct f_inst * NONNULL(1)
#line 1118
f_new_method_FI_METHOD__T_PAIR__asn(struct f_inst *obj, struct f_inst *args)
#line 1118
  {
#line 1118
    /* Unwind the arguments (1) */
#line 1118
        if (args) cf_error("Too many arguments");
#line 1115 "filter/f-inst.c"

#line 1115

    return f_new_inst(FI_METHOD__T_PAIR__asn, obj
#line 1118 "filter/f-inst.c"

#line 1118
    );
#line 1118
  }
#line 1118

#line 1121 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PAIR__data */
#line 1121
struct f_inst * NONNULL(1)
#line 1121
f_new_method_FI_METHOD__T_PAIR__data(struct f_inst *obj, struct f_inst *args)
#line 1121
  {
#line 1121
    /* Unwind the arguments (1) */
#line 1121
        if (args) cf_error("Too many arguments");
#line 1118 "filter/f-inst.c"

#line 1118

    return f_new_inst(FI_METHOD__T_PAIR__data, obj
#line 1121 "filter/f-inst.c"

#line 1121
    );
#line 1121
  }
#line 1121

#line 1124 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__asn */
#line 1124
struct f_inst * NONNULL(1)
#line 1124
f_new_method_FI_METHOD__T_LC__asn(struct f_inst *obj, struct f_inst *args)
#line 1124
  {
#line 1124
    /* Unwind the arguments (1) */
#line 1124
        if (args) cf_error("Too many arguments");
#line 1121 "filter/f-inst.c"

#line 1121

    return f_new_inst(FI_METHOD__T_LC__asn, obj
#line 1124 "filter/f-inst.c"

#line 1124
    );
#line 1124
  }
#line 1124

#line 1127 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__data1 */
#line 1127
struct f_inst * NONNULL(1)
#line 1127
f_new_method_FI_METHOD__T_LC__data1(struct f_inst *obj, struct f_inst *args)
#line 1127
  {
#line 1127
    /* Unwind the arguments (1) */
#line 1127
        if (args) cf_error("Too many arguments");
#line 1124 "filter/f-inst.c"

#line 1124

    return f_new_inst(FI_METHOD__T_LC__data1, obj
#line 1127 "filter/f-inst.c"

#line 1127
    );
#line 1127
  }
#line 1127

#line 1130 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__data2 */
#line 1130
struct f_inst * NONNULL(1)
#line 1130
f_new_method_FI_METHOD__T_LC__data2(struct f_inst *obj, struct f_inst *args)
#line 1130
  {
#line 1130
    /* Unwind the arguments (1) */
#line 1130
        if (args) cf_error("Too many arguments");
#line 1127 "filter/f-inst.c"

#line 1127

    return f_new_inst(FI_METHOD__T_LC__data2, obj
#line 1130 "filter/f-inst.c"

#line 1130
    );
#line 1130
  }
#line 1130

#line 1133 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__min */
#line 1133
struct f_inst * NONNULL(1)
#line 1133
f_new_method_FI_METHOD__T_CLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1133
  {
#line 1133
    /* Unwind the arguments (1) */
#line 1133
        if (args) cf_error("Too many arguments");
#line 1130 "filter/f-inst.c"

#line 1130

    return f_new_inst(FI_METHOD__T_CLIST__min, obj
#line 1133 "filter/f-inst.c"

#line 1133
    );
#line 1133
  }
#line 1133

#line 1136 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__max */
#line 1136
struct f_inst * NONNULL(1)
#line 1136
f_new_method_FI_METHOD__T_CLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1136
  {
#line 1136
    /* Unwind the arguments (1) */
#line 1136
        if (args) cf_error("Too many arguments");
#line 1133 "filter/f-inst.c"

#line 1133

    return f_new_inst(FI_METHOD__T_CLIST__max, obj
#line 1136 "filter/f-inst.c"

#line 1136
    );
#line 1136
  }
#line 1136

#line 1139 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__min */
#line 1139
struct f_inst * NONNULL(1)
#line 1139
f_new_method_FI_METHOD__T_ECLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1139
  {
#line 1139
    /* Unwind the arguments (1) */
#line 1139
        if (args) cf_error("Too many arguments");
#line 1136 "filter/f-inst.c"

#line 1136

    return f_new_inst(FI_METHOD__T_ECLIST__min, obj
#line 1139 "filter/f-inst.c"

#line 1139
    );
#line 1139
  }
#line 1139

#line 1142 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__max */
#line 1142
struct f_inst * NONNULL(1)
#line 1142
f_new_method_FI_METHOD__T_ECLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1142
  {
#line 1142
    /* Unwind the arguments (1) */
#line 1142
        if (args) cf_error("Too many arguments");
#line 1139 "filter/f-inst.c"

#line 1139

    return f_new_inst(FI_METHOD__T_ECLIST__max, obj
#line 1142 "filter/f-inst.c"

#line 1142
    );
#line 1142
  }
#line 1142

#line 1145 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__min */
#line 1145
struct f_inst * NONNULL(1)
#line 1145
f_new_method_FI_METHOD__T_LCLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1145
  {
#line 1145
    /* Unwind the arguments (1) */
#line 1145
        if (args) cf_error("Too many arguments");
#line 1142 "filter/f-inst.c"

#line 1142

    return f_new_inst(FI_METHOD__T_LCLIST__min, obj
#line 1145 "filter/f-inst.c"

#line 1145
    );
#line 1145
  }
#line 1145

#line 1147 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__max */
#line 1147
struct f_inst * NONNULL(1)
#line 1147
f_new_method_FI_METHOD__T_LCLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1147
  {
#line 1147
    /* Unwind the arguments (1) */
#line 1147
        if (args) cf_error("Too many arguments");
#line 1145 "filter/f-inst.c"

#line 1145

    return f_new_inst(FI_METHOD__T_LCLIST__max, obj
#line 1147 "filter/f-inst.c"

#line 1147
    );
#line 1147
  }
#line 1147

#line 1173 "filter/f-inst.c"

#line 1233 "filter/f-inst.c"

#line 1238 "filter/f-inst.c"

#line 1282 "filter/f-inst.c"

#line 1291 "filter/f-inst.c"
 /* Method constructor for FI_IP_MASK */
#line 1291
struct f_inst * NONNULL(1)
#line 1291
f_new_method_FI_IP_MASK(struct f_inst *obj, struct f_inst *args)
#line 1291
  {
#line 1291
    /* Unwind the arguments (2) */
#line 1291
    #line 1284 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1284
  if (args == NULL) cf_error("Not enough arguments"); /* FI_IP_MASK */
#line 1284
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1285 "filter/f-inst.c"

#line 1285

    return f_new_inst(FI_IP_MASK, obj
#line 1284 "filter/f-inst.c"
    , arg2
#line 1291 "filter/f-inst.c"

#line 1291
    );
#line 1291
  }
#line 1291

#line 1299 "filter/f-inst.c"
 /* Method constructor for FI_PATH_PREPEND */
#line 1299
struct f_inst * NONNULL(1)
#line 1299
f_new_method_FI_PATH_PREPEND(struct f_inst *obj, struct f_inst *args)
#line 1299
  {
#line 1299
    /* Unwind the arguments (2) */
#line 1299
    #line 1293 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1293
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_PREPEND */
#line 1293
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1294 "filter/f-inst.c"

#line 1294

    return f_new_inst(FI_PATH_PREPEND, obj
#line 1293 "filter/f-inst.c"
    , arg2
#line 1299 "filter/f-inst.c"

#line 1299
    );
#line 1299
  }
#line 1299

#line 1307 "filter/f-inst.c"
 /* Method constructor for FI_STRING_APPEND */
#line 1307
struct f_inst * NONNULL(1)
#line 1307
f_new_method_FI_STRING_APPEND(struct f_inst *obj, struct f_inst *args)
#line 1307
  {
#line 1307
    /* Unwind the arguments (2) */
#line 1307
    #line 1301 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1301
  if (args == NULL) cf_error("Not enough arguments"); /* FI_STRING_APPEND */
#line 1301
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1302 "filter/f-inst.c"

#line 1302

    return f_new_inst(FI_STRING_APPEND, obj
#line 1301 "filter/f-inst.c"
    , arg2
#line 1307 "filter/f-inst.c"

#line 1307
    );
#line 1307
  }
#line 1307

#line 1315 "filter/f-inst.c"
 /* Method constructor for FI_BYTESTRING_APPEND */
#line 1315
struct f_inst * NONNULL(1)
#line 1315
f_new_method_FI_BYTESTRING_APPEND(struct f_inst *obj, struct f_inst *args)
#line 1315
  {
#line 1315
    /* Unwind the arguments (2) */
#line 1315
    #line 1309 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1309
  if (args == NULL) cf_error("Not enough arguments"); /* FI_BYTESTRING_APPEND */
#line 1309
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1310 "filter/f-inst.c"

#line 1310

    return f_new_inst(FI_BYTESTRING_APPEND, obj
#line 1309 "filter/f-inst.c"
    , arg2
#line 1315 "filter/f-inst.c"

#line 1315
    );
#line 1315
  }
#line 1315

#line 1322 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_PAIR */
#line 1322
struct f_inst * NONNULL(1)
#line 1322
f_new_method_FI_CLIST_ADD_PAIR(struct f_inst *obj, struct f_inst *args)
#line 1322
  {
#line 1322
    /* Unwind the arguments (2) */
#line 1322
    #line 1317 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1317
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_PAIR */
#line 1317
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1318 "filter/f-inst.c"

#line 1318

    return f_new_inst(FI_CLIST_ADD_PAIR, obj
#line 1317 "filter/f-inst.c"
    , arg2
#line 1322 "filter/f-inst.c"

#line 1322
    );
#line 1322
  }
#line 1322

#line 1336 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_IP */
#line 1336
struct f_inst * NONNULL(1)
#line 1336
f_new_method_FI_CLIST_ADD_IP(struct f_inst *obj, struct f_inst *args)
#line 1336
  {
#line 1336
    /* Unwind the arguments (2) */
#line 1336
    #line 1324 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1324
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_IP */
#line 1324
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1325 "filter/f-inst.c"

#line 1325

    return f_new_inst(FI_CLIST_ADD_IP, obj
#line 1324 "filter/f-inst.c"
    , arg2
#line 1336 "filter/f-inst.c"

#line 1336
    );
#line 1336
  }
#line 1336

#line 1343 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_QUAD */
#line 1343
struct f_inst * NONNULL(1)
#line 1343
f_new_method_FI_CLIST_ADD_QUAD(struct f_inst *obj, struct f_inst *args)
#line 1343
  {
#line 1343
    /* Unwind the arguments (2) */
#line 1343
    #line 1338 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1338
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_QUAD */
#line 1338
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1339 "filter/f-inst.c"

#line 1339

    return f_new_inst(FI_CLIST_ADD_QUAD, obj
#line 1338 "filter/f-inst.c"
    , arg2
#line 1343 "filter/f-inst.c"

#line 1343
    );
#line 1343
  }
#line 1343

#line 1350 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_CLIST */
#line 1350
struct f_inst * NONNULL(1)
#line 1350
f_new_method_FI_CLIST_ADD_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1350
  {
#line 1350
    /* Unwind the arguments (2) */
#line 1350
    #line 1345 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1345
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_CLIST */
#line 1345
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1346 "filter/f-inst.c"

#line 1346

    return f_new_inst(FI_CLIST_ADD_CLIST, obj
#line 1345 "filter/f-inst.c"
    , arg2
#line 1350 "filter/f-inst.c"

#line 1350
    );
#line 1350
  }
#line 1350

#line 1357 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_ADD_EC */
#line 1357
struct f_inst * NONNULL(1)
#line 1357
f_new_method_FI_ECLIST_ADD_EC(struct f_inst *obj, struct f_inst *args)
#line 1357
  {
#line 1357
    /* Unwind the arguments (2) */
#line 1357
    #line 1352 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1352
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_ADD_EC */
#line 1352
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1353 "filter/f-inst.c"

#line 1353

    return f_new_inst(FI_ECLIST_ADD_EC, obj
#line 1352 "filter/f-inst.c"
    , arg2
#line 1357 "filter/f-inst.c"

#line 1357
    );
#line 1357
  }
#line 1357

#line 1364 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_ADD_ECLIST */
#line 1364
struct f_inst * NONNULL(1)
#line 1364
f_new_method_FI_ECLIST_ADD_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1364
  {
#line 1364
    /* Unwind the arguments (2) */
#line 1364
    #line 1359 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1359
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_ADD_ECLIST */
#line 1359
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1360 "filter/f-inst.c"

#line 1360

    return f_new_inst(FI_ECLIST_ADD_ECLIST, obj
#line 1359 "filter/f-inst.c"
    , arg2
#line 1364 "filter/f-inst.c"

#line 1364
    );
#line 1364
  }
#line 1364

#line 1371 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_ADD_LC */
#line 1371
struct f_inst * NONNULL(1)
#line 1371
f_new_method_FI_LCLIST_ADD_LC(struct f_inst *obj, struct f_inst *args)
#line 1371
  {
#line 1371
    /* Unwind the arguments (2) */
#line 1371
    #line 1366 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1366
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_ADD_LC */
#line 1366
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1367 "filter/f-inst.c"

#line 1367

    return f_new_inst(FI_LCLIST_ADD_LC, obj
#line 1366 "filter/f-inst.c"
    , arg2
#line 1371 "filter/f-inst.c"

#line 1371
    );
#line 1371
  }
#line 1371

#line 1378 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_ADD_LCLIST */
#line 1378
struct f_inst * NONNULL(1)
#line 1378
f_new_method_FI_LCLIST_ADD_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1378
  {
#line 1378
    /* Unwind the arguments (2) */
#line 1378
    #line 1373 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1373
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_ADD_LCLIST */
#line 1373
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1374 "filter/f-inst.c"

#line 1374

    return f_new_inst(FI_LCLIST_ADD_LCLIST, obj
#line 1373 "filter/f-inst.c"
    , arg2
#line 1378 "filter/f-inst.c"

#line 1378
    );
#line 1378
  }
#line 1378

#line 1385 "filter/f-inst.c"
 /* Method constructor for FI_PATH_DELETE_INT */
#line 1385
struct f_inst * NONNULL(1)
#line 1385
f_new_method_FI_PATH_DELETE_INT(struct f_inst *obj, struct f_inst *args)
#line 1385
  {
#line 1385
    /* Unwind the arguments (2) */
#line 1385
    #line 1380 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1380
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_DELETE_INT */
#line 1380
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1381 "filter/f-inst.c"

#line 1381

    return f_new_inst(FI_PATH_DELETE_INT, obj
#line 1380 "filter/f-inst.c"
    , arg2
#line 1385 "filter/f-inst.c"

#line 1385
    );
#line 1385
  }
#line 1385

#line 1397 "filter/f-inst.c"
 /* Method constructor for FI_PATH_DELETE_SET */
#line 1397
struct f_inst * NONNULL(1)
#line 1397
f_new_method_FI_PATH_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1397
  {
#line 1397
    /* Unwind the arguments (2) */
#line 1397
    #line 1387 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1387
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_DELETE_SET */
#line 1387
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1388 "filter/f-inst.c"

#line 1388

    return f_new_inst(FI_PATH_DELETE_SET, obj
#line 1387 "filter/f-inst.c"
    , arg2
#line 1397 "filter/f-inst.c"

#line 1397
    );
#line 1397
  }
#line 1397

#line 1404 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_PAIR */
#line 1404
struct f_inst * NONNULL(1)
#line 1404
f_new_method_FI_CLIST_DELETE_PAIR(struct f_inst *obj, struct f_inst *args)
#line 1404
  {
#line 1404
    /* Unwind the arguments (2) */
#line 1404
    #line 1399 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1399
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_PAIR */
#line 1399
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1400 "filter/f-inst.c"

#line 1400

    return f_new_inst(FI_CLIST_DELETE_PAIR, obj
#line 1399 "filter/f-inst.c"
    , arg2
#line 1404 "filter/f-inst.c"

#line 1404
    );
#line 1404
  }
#line 1404

#line 1418 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_IP */
#line 1418
struct f_inst * NONNULL(1)
#line 1418
f_new_method_FI_CLIST_DELETE_IP(struct f_inst *obj, struct f_inst *args)
#line 1418
  {
#line 1418
    /* Unwind the arguments (2) */
#line 1418
    #line 1406 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1406
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_IP */
#line 1406
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1407 "filter/f-inst.c"

#line 1407

    return f_new_inst(FI_CLIST_DELETE_IP, obj
#line 1406 "filter/f-inst.c"
    , arg2
#line 1418 "filter/f-inst.c"

#line 1418
    );
#line 1418
  }
#line 1418

#line 1425 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_QUAD */
#line 1425
struct f_inst * NONNULL(1)
#line 1425
f_new_method_FI_CLIST_DELETE_QUAD(struct f_inst *obj, struct f_inst *args)
#line 1425
  {
#line 1425
    /* Unwind the arguments (2) */
#line 1425
    #line 1420 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1420
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_QUAD */
#line 1420
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1421 "filter/f-inst.c"

#line 1421

    return f_new_inst(FI_CLIST_DELETE_QUAD, obj
#line 1420 "filter/f-inst.c"
    , arg2
#line 1425 "filter/f-inst.c"

#line 1425
    );
#line 1425
  }
#line 1425

#line 1432 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_CLIST */
#line 1432
struct f_inst * NONNULL(1)
#line 1432
f_new_method_FI_CLIST_DELETE_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1432
  {
#line 1432
    /* Unwind the arguments (2) */
#line 1432
    #line 1427 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1427
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_CLIST */
#line 1427
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1428 "filter/f-inst.c"

#line 1428

    return f_new_inst(FI_CLIST_DELETE_CLIST, obj
#line 1427 "filter/f-inst.c"
    , arg2
#line 1432 "filter/f-inst.c"

#line 1432
    );
#line 1432
  }
#line 1432

#line 1443 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_SET */
#line 1443
struct f_inst * NONNULL(1)
#line 1443
f_new_method_FI_CLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1443
  {
#line 1443
    /* Unwind the arguments (2) */
#line 1443
    #line 1434 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1434
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_SET */
#line 1434
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1435 "filter/f-inst.c"

#line 1435

    return f_new_inst(FI_CLIST_DELETE_SET, obj
#line 1434 "filter/f-inst.c"
    , arg2
#line 1443 "filter/f-inst.c"

#line 1443
    );
#line 1443
  }
#line 1443

#line 1450 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_EC */
#line 1450
struct f_inst * NONNULL(1)
#line 1450
f_new_method_FI_ECLIST_DELETE_EC(struct f_inst *obj, struct f_inst *args)
#line 1450
  {
#line 1450
    /* Unwind the arguments (2) */
#line 1450
    #line 1445 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1445
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_EC */
#line 1445
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1446 "filter/f-inst.c"

#line 1446

    return f_new_inst(FI_ECLIST_DELETE_EC, obj
#line 1445 "filter/f-inst.c"
    , arg2
#line 1450 "filter/f-inst.c"

#line 1450
    );
#line 1450
  }
#line 1450

#line 1457 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_ECLIST */
#line 1457
struct f_inst * NONNULL(1)
#line 1457
f_new_method_FI_ECLIST_DELETE_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1457
  {
#line 1457
    /* Unwind the arguments (2) */
#line 1457
    #line 1452 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1452
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_ECLIST */
#line 1452
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1453 "filter/f-inst.c"

#line 1453

    return f_new_inst(FI_ECLIST_DELETE_ECLIST, obj
#line 1452 "filter/f-inst.c"
    , arg2
#line 1457 "filter/f-inst.c"

#line 1457
    );
#line 1457
  }
#line 1457

#line 1468 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_SET */
#line 1468
struct f_inst * NONNULL(1)
#line 1468
f_new_method_FI_ECLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1468
  {
#line 1468
    /* Unwind the arguments (2) */
#line 1468
    #line 1459 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1459
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_SET */
#line 1459
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1460 "filter/f-inst.c"

#line 1460

    return f_new_inst(FI_ECLIST_DELETE_SET, obj
#line 1459 "filter/f-inst.c"
    , arg2
#line 1468 "filter/f-inst.c"

#line 1468
    );
#line 1468
  }
#line 1468

#line 1475 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_LC */
#line 1475
struct f_inst * NONNULL(1)
#line 1475
f_new_method_FI_LCLIST_DELETE_LC(struct f_inst *obj, struct f_inst *args)
#line 1475
  {
#line 1475
    /* Unwind the arguments (2) */
#line 1475
    #line 1470 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1470
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_LC */
#line 1470
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1471 "filter/f-inst.c"

#line 1471

    return f_new_inst(FI_LCLIST_DELETE_LC, obj
#line 1470 "filter/f-inst.c"
    , arg2
#line 1475 "filter/f-inst.c"

#line 1475
    );
#line 1475
  }
#line 1475

#line 1482 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_LCLIST */
#line 1482
struct f_inst * NONNULL(1)
#line 1482
f_new_method_FI_LCLIST_DELETE_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1482
  {
#line 1482
    /* Unwind the arguments (2) */
#line 1482
    #line 1477 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1477
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_LCLIST */
#line 1477
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1478 "filter/f-inst.c"

#line 1478

    return f_new_inst(FI_LCLIST_DELETE_LCLIST, obj
#line 1477 "filter/f-inst.c"
    , arg2
#line 1482 "filter/f-inst.c"

#line 1482
    );
#line 1482
  }
#line 1482

#line 1493 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_SET */
#line 1493
struct f_inst * NONNULL(1)
#line 1493
f_new_method_FI_LCLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1493
  {
#line 1493
    /* Unwind the arguments (2) */
#line 1493
    #line 1484 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1484
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_SET */
#line 1484
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1485 "filter/f-inst.c"

#line 1485

    return f_new_inst(FI_LCLIST_DELETE_SET, obj
#line 1484 "filter/f-inst.c"
    , arg2
#line 1493 "filter/f-inst.c"

#line 1493
    );
#line 1493
  }
#line 1493

#line 1504 "filter/f-inst.c"
 /* Method constructor for FI_PATH_FILTER_SET */
#line 1504
struct f_inst * NONNULL(1)
#line 1504
f_new_method_FI_PATH_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1504
  {
#line 1504
    /* Unwind the arguments (2) */
#line 1504
    #line 1495 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1495
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_FILTER_SET */
#line 1495
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1496 "filter/f-inst.c"

#line 1496

    return f_new_inst(FI_PATH_FILTER_SET, obj
#line 1495 "filter/f-inst.c"
    , arg2
#line 1504 "filter/f-inst.c"

#line 1504
    );
#line 1504
  }
#line 1504

#line 1511 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FILTER_CLIST */
#line 1511
struct f_inst * NONNULL(1)
#line 1511
f_new_method_FI_CLIST_FILTER_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1511
  {
#line 1511
    /* Unwind the arguments (2) */
#line 1511
    #line 1506 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1506
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FILTER_CLIST */
#line 1506
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1507 "filter/f-inst.c"

#line 1507

    return f_new_inst(FI_CLIST_FILTER_CLIST, obj
#line 1506 "filter/f-inst.c"
    , arg2
#line 1511 "filter/f-inst.c"

#line 1511
    );
#line 1511
  }
#line 1511

#line 1522 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FILTER_SET */
#line 1522
struct f_inst * NONNULL(1)
#line 1522
f_new_method_FI_CLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1522
  {
#line 1522
    /* Unwind the arguments (2) */
#line 1522
    #line 1513 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1513
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FILTER_SET */
#line 1513
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1514 "filter/f-inst.c"

#line 1514

    return f_new_inst(FI_CLIST_FILTER_SET, obj
#line 1513 "filter/f-inst.c"
    , arg2
#line 1522 "filter/f-inst.c"

#line 1522
    );
#line 1522
  }
#line 1522

#line 1529 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FILTER_ECLIST */
#line 1529
struct f_inst * NONNULL(1)
#line 1529
f_new_method_FI_ECLIST_FILTER_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1529
  {
#line 1529
    /* Unwind the arguments (2) */
#line 1529
    #line 1524 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1524
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FILTER_ECLIST */
#line 1524
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1525 "filter/f-inst.c"

#line 1525

    return f_new_inst(FI_ECLIST_FILTER_ECLIST, obj
#line 1524 "filter/f-inst.c"
    , arg2
#line 1529 "filter/f-inst.c"

#line 1529
    );
#line 1529
  }
#line 1529

#line 1540 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FILTER_SET */
#line 1540
struct f_inst * NONNULL(1)
#line 1540
f_new_method_FI_ECLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1540
  {
#line 1540
    /* Unwind the arguments (2) */
#line 1540
    #line 1531 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1531
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FILTER_SET */
#line 1531
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1532 "filter/f-inst.c"

#line 1532

    return f_new_inst(FI_ECLIST_FILTER_SET, obj
#line 1531 "filter/f-inst.c"
    , arg2
#line 1540 "filter/f-inst.c"

#line 1540
    );
#line 1540
  }
#line 1540

#line 1547 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FILTER_LCLIST */
#line 1547
struct f_inst * NONNULL(1)
#line 1547
f_new_method_FI_LCLIST_FILTER_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1547
  {
#line 1547
    /* Unwind the arguments (2) */
#line 1547
    #line 1542 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1542
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FILTER_LCLIST */
#line 1542
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1543 "filter/f-inst.c"

#line 1543

    return f_new_inst(FI_LCLIST_FILTER_LCLIST, obj
#line 1542 "filter/f-inst.c"
    , arg2
#line 1547 "filter/f-inst.c"

#line 1547
    );
#line 1547
  }
#line 1547

#line 1558 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FILTER_SET */
#line 1558
struct f_inst * NONNULL(1)
#line 1558
f_new_method_FI_LCLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1558
  {
#line 1558
    /* Unwind the arguments (2) */
#line 1558
    #line 1549 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1549
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FILTER_SET */
#line 1549
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1550 "filter/f-inst.c"

#line 1550

    return f_new_inst(FI_LCLIST_FILTER_SET, obj
#line 1549 "filter/f-inst.c"
    , arg2
#line 1558 "filter/f-inst.c"

#line 1558
    );
#line 1558
  }
#line 1558

#line 1580 "filter/f-inst.c"

#line 1596 "filter/f-inst.c"

#line 1611 "filter/f-inst.c"

#line 1616 "filter/f-inst.c"

#line 830 "filter/decl.m4"

#line 618 "filter/decl.m4"


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverride-init"
#endif

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Winitializer-overrides"
#endif

static struct sym_scope f_type_method_scopes[] = {
#line 507 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__type */
#line 507
  [T_NET] = {},
#line 510 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_IP__is_v4 */
#line 510
  [T_IP] = {},
#line 564 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__empty */
#line 564
  [T_PATH] = {},
#line 565 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__empty */
#line 565
  [T_CLIST] = {},
#line 566 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__empty */
#line 566
  [T_ECLIST] = {},
#line 569 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__empty */
#line 569
  [T_LCLIST] = {},
#line 600 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_FOR_NEXT */
#line 600
  [T_PATH] = {},
#line 609 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FOR_NEXT */
#line 609
  [T_CLIST] = {},
#line 618 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FOR_NEXT */
#line 618
  [T_ECLIST] = {},
#line 627 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FOR_NEXT */
#line 627
  [T_LCLIST] = {},
#line 640 "filter/f-inst.c"
 /* Method scope initializator for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  [T_ROUTES_BLOCK] = {},
#line 997 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__len */
#line 997
  [T_NET] = {},
#line 998 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__len */
#line 998
  [T_PATH] = {},
#line 999 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__len */
#line 999
  [T_CLIST] = {},
#line 1000 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__len */
#line 1000
  [T_ECLIST] = {},
#line 1002 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__len */
#line 1002
  [T_LCLIST] = {},
#line 1038 "filter/f-inst.c"
 /* Method scope initializator for FI_NET_SRC */
#line 1038
  [T_NET] = {},
#line 1075 "filter/f-inst.c"
 /* Method scope initializator for FI_NET_DST */
#line 1075
  [T_NET] = {},
#line 1085 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__maxlen */
#line 1085
  [T_NET] = {},
#line 1095 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__asn */
#line 1095
  [T_NET] = {},
#line 1097 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__ip */
#line 1097
  [T_NET] = {},
#line 1106 "filter/f-inst.c"
 /* Method scope initializator for FI_ROUTE_DISTINGUISHER */
#line 1106
  [T_NET] = {},
#line 1109 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__first */
#line 1109
  [T_PATH] = {},
#line 1112 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__last */
#line 1112
  [T_PATH] = {},
#line 1115 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
  [T_PATH] = {},
#line 1118 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PAIR__asn */
#line 1118
  [T_PAIR] = {},
#line 1121 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PAIR__data */
#line 1121
  [T_PAIR] = {},
#line 1124 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__asn */
#line 1124
  [T_LC] = {},
#line 1127 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__data1 */
#line 1127
  [T_LC] = {},
#line 1130 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__data2 */
#line 1130
  [T_LC] = {},
#line 1133 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__min */
#line 1133
  [T_CLIST] = {},
#line 1136 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__max */
#line 1136
  [T_CLIST] = {},
#line 1139 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__min */
#line 1139
  [T_ECLIST] = {},
#line 1142 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__max */
#line 1142
  [T_ECLIST] = {},
#line 1145 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__min */
#line 1145
  [T_LCLIST] = {},
#line 1147 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__max */
#line 1147
  [T_LCLIST] = {},
#line 1291 "filter/f-inst.c"
 /* Method scope initializator for FI_IP_MASK */
#line 1291
  [T_IP] = {},
#line 1299 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_PREPEND */
#line 1299
  [T_PATH] = {},
#line 1307 "filter/f-inst.c"
 /* Method scope initializator for FI_STRING_APPEND */
#line 1307
  [T_STRING] = {},
#line 1315 "filter/f-inst.c"
 /* Method scope initializator for FI_BYTESTRING_APPEND */
#line 1315
  [T_BYTESTRING] = {},
#line 1322 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_PAIR */
#line 1322
  [T_CLIST] = {},
#line 1336 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_IP */
#line 1336
  [T_CLIST] = {},
#line 1343 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_QUAD */
#line 1343
  [T_CLIST] = {},
#line 1350 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_CLIST */
#line 1350
  [T_CLIST] = {},
#line 1357 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_ADD_EC */
#line 1357
  [T_ECLIST] = {},
#line 1364 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_ADD_ECLIST */
#line 1364
  [T_ECLIST] = {},
#line 1371 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_ADD_LC */
#line 1371
  [T_LCLIST] = {},
#line 1378 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_ADD_LCLIST */
#line 1378
  [T_LCLIST] = {},
#line 1385 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_DELETE_INT */
#line 1385
  [T_PATH] = {},
#line 1397 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_DELETE_SET */
#line 1397
  [T_PATH] = {},
#line 1404 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_PAIR */
#line 1404
  [T_CLIST] = {},
#line 1418 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_IP */
#line 1418
  [T_CLIST] = {},
#line 1425 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_QUAD */
#line 1425
  [T_CLIST] = {},
#line 1432 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_CLIST */
#line 1432
  [T_CLIST] = {},
#line 1443 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_SET */
#line 1443
  [T_CLIST] = {},
#line 1450 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_EC */
#line 1450
  [T_ECLIST] = {},
#line 1457 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_ECLIST */
#line 1457
  [T_ECLIST] = {},
#line 1468 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_SET */
#line 1468
  [T_ECLIST] = {},
#line 1475 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_LC */
#line 1475
  [T_LCLIST] = {},
#line 1482 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_LCLIST */
#line 1482
  [T_LCLIST] = {},
#line 1493 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_SET */
#line 1493
  [T_LCLIST] = {},
#line 1504 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_FILTER_SET */
#line 1504
  [T_PATH] = {},
#line 1511 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FILTER_CLIST */
#line 1511
  [T_CLIST] = {},
#line 1522 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FILTER_SET */
#line 1522
  [T_CLIST] = {},
#line 1529 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FILTER_ECLIST */
#line 1529
  [T_ECLIST] = {},
#line 1540 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FILTER_SET */
#line 1540
  [T_ECLIST] = {},
#line 1547 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FILTER_LCLIST */
#line 1547
  [T_LCLIST] = {},
#line 1558 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FILTER_SET */
#line 1558
  [T_LCLIST] = {},
#line 631 "filter/decl.m4"

};

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic pop
#endif

struct sym_scope *f_type_method_scope(enum btype t)
{
  return (t < ARRAY_SIZE(f_type_method_scopes)) ? &f_type_method_scopes[t] : NULL;
}

static void
f_register_method(enum btype t, const byte *name, struct f_method *dsc)
{
  struct sym_scope *scope = &f_type_method_scopes[t];
  struct symbol *sym = cf_find_symbol_scope(scope, name);

  if (!sym)
  {
    sym = cf_root_symbol(name, scope);
    sym->class = SYM_METHOD;
  }

  dsc->sym = sym;
  dsc->next = sym->method;
  sym->method = dsc;
}

extern struct sym_scope global_filter_scope;

void f_type_methods_register(void)
{
  struct f_method *method;

#line 507 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__type */
#line 507
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 507
  method->new_inst = f_new_method_FI_METHOD__T_NET__type;
#line 507
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 507 "filter/f-inst.c"

#line 507
  f_register_method(T_NET, "type", method);
#line 507

#line 507

#line 510 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_IP__is_v4 */
#line 510
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 510
  method->new_inst = f_new_method_FI_METHOD__T_IP__is_v4;
#line 510
  method->arg_num = 1;
  method->args_type[0] = T_IP;
#line 510 "filter/f-inst.c"

#line 510
  f_register_method(T_IP, "is_v4", method);
#line 510

#line 510

#line 564 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__empty */
#line 564
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 564
  method->new_inst = f_new_method_FI_METHOD__T_PATH__empty;
#line 564
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 564 "filter/f-inst.c"

#line 564
  f_register_method(T_PATH, "empty", method);
#line 564

#line 564

#line 565 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__empty */
#line 565
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 565
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__empty;
#line 565
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 565 "filter/f-inst.c"

#line 565
  f_register_method(T_CLIST, "empty", method);
#line 565

#line 565

#line 566 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__empty */
#line 566
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 566
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__empty;
#line 566
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 566 "filter/f-inst.c"

#line 566
  f_register_method(T_ECLIST, "empty", method);
#line 566

#line 566

#line 569 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__empty */
#line 569
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 569
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__empty;
#line 569
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 569 "filter/f-inst.c"

#line 569
  f_register_method(T_LCLIST, "empty", method);
#line 569

#line 569

#line 600 "filter/f-inst.c"
 /* Method registrator for FI_PATH_FOR_NEXT */
#line 600
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 600
  method->new_inst = f_new_method_FI_PATH_FOR_NEXT;
#line 600
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
#line 600 "filter/f-inst.c"

#line 600
  f_register_method(T_PATH, "!for_next", method);
#line 600

#line 600

#line 609 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FOR_NEXT */
#line 609
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 609
  method->new_inst = f_new_method_FI_CLIST_FOR_NEXT;
#line 609
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
#line 609 "filter/f-inst.c"

#line 609
  f_register_method(T_CLIST, "!for_next", method);
#line 609

#line 609

#line 618 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FOR_NEXT */
#line 618
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 618
  method->new_inst = f_new_method_FI_ECLIST_FOR_NEXT;
#line 618
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
#line 618 "filter/f-inst.c"

#line 618
  f_register_method(T_ECLIST, "!for_next", method);
#line 618

#line 618

#line 627 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FOR_NEXT */
#line 627
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 627
  method->new_inst = f_new_method_FI_LCLIST_FOR_NEXT;
#line 627
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
#line 627 "filter/f-inst.c"

#line 627
  f_register_method(T_LCLIST, "!for_next", method);
#line 627

#line 627

#line 640 "filter/f-inst.c"
 /* Method registrator for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 640
  method->new_inst = f_new_method_FI_ROUTES_BLOCK_FOR_NEXT;
#line 640
  method->arg_num = 2;
  method->args_type[0] = T_ROUTES_BLOCK;
#line 640 "filter/f-inst.c"

#line 640
  f_register_method(T_ROUTES_BLOCK, "!for_next", method);
#line 640

#line 640

#line 997 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__len */
#line 997
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 997
  method->new_inst = f_new_method_FI_METHOD__T_NET__len;
#line 997
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 997 "filter/f-inst.c"

#line 997
  f_register_method(T_NET, "len", method);
#line 997

#line 997

#line 998 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__len */
#line 998
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 998
  method->new_inst = f_new_method_FI_METHOD__T_PATH__len;
#line 998
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 998 "filter/f-inst.c"

#line 998
  f_register_method(T_PATH, "len", method);
#line 998

#line 998

#line 999 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__len */
#line 999
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 999
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__len;
#line 999
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 999 "filter/f-inst.c"

#line 999
  f_register_method(T_CLIST, "len", method);
#line 999

#line 999

#line 1000 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__len */
#line 1000
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1000
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__len;
#line 1000
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1000 "filter/f-inst.c"

#line 1000
  f_register_method(T_ECLIST, "len", method);
#line 1000

#line 1000

#line 1002 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__len */
#line 1002
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1002
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__len;
#line 1002
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1002 "filter/f-inst.c"

#line 1002
  f_register_method(T_LCLIST, "len", method);
#line 1002

#line 1002

#line 1038 "filter/f-inst.c"
 /* Method registrator for FI_NET_SRC */
#line 1038
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1038
  method->new_inst = f_new_method_FI_NET_SRC;
#line 1038
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1038 "filter/f-inst.c"

#line 1038
  f_register_method(T_NET, "src", method);
#line 1038

#line 1038

#line 1075 "filter/f-inst.c"
 /* Method registrator for FI_NET_DST */
#line 1075
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1075
  method->new_inst = f_new_method_FI_NET_DST;
#line 1075
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1075 "filter/f-inst.c"

#line 1075
  f_register_method(T_NET, "dst", method);
#line 1075

#line 1075

#line 1085 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__maxlen */
#line 1085
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1085
  method->new_inst = f_new_method_FI_METHOD__T_NET__maxlen;
#line 1085
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1085 "filter/f-inst.c"

#line 1085
  f_register_method(T_NET, "maxlen", method);
#line 1085

#line 1085

#line 1095 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__asn */
#line 1095
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1095
  method->new_inst = f_new_method_FI_METHOD__T_NET__asn;
#line 1095
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1095 "filter/f-inst.c"

#line 1095
  f_register_method(T_NET, "asn", method);
#line 1095

#line 1095

#line 1097 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__ip */
#line 1097
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1097
  method->new_inst = f_new_method_FI_METHOD__T_NET__ip;
#line 1097
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1097 "filter/f-inst.c"

#line 1097
  f_register_method(T_NET, "ip", method);
#line 1097

#line 1097

#line 1106 "filter/f-inst.c"
 /* Method registrator for FI_ROUTE_DISTINGUISHER */
#line 1106
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1106
  method->new_inst = f_new_method_FI_ROUTE_DISTINGUISHER;
#line 1106
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1106 "filter/f-inst.c"

#line 1106
  f_register_method(T_NET, "rd", method);
#line 1106

#line 1106

#line 1109 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__first */
#line 1109
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1109
  method->new_inst = f_new_method_FI_METHOD__T_PATH__first;
#line 1109
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1109 "filter/f-inst.c"

#line 1109
  f_register_method(T_PATH, "first", method);
#line 1109

#line 1109

#line 1112 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__last */
#line 1112
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1112
  method->new_inst = f_new_method_FI_METHOD__T_PATH__last;
#line 1112
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1112 "filter/f-inst.c"

#line 1112
  f_register_method(T_PATH, "last", method);
#line 1112

#line 1112

#line 1115 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1115
  method->new_inst = f_new_method_FI_METHOD__T_PATH__last_nonaggregated;
#line 1115
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1115 "filter/f-inst.c"

#line 1115
  f_register_method(T_PATH, "last_nonaggregated", method);
#line 1115

#line 1115

#line 1118 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PAIR__asn */
#line 1118
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1118
  method->new_inst = f_new_method_FI_METHOD__T_PAIR__asn;
#line 1118
  method->arg_num = 1;
  method->args_type[0] = T_PAIR;
#line 1118 "filter/f-inst.c"

#line 1118
  f_register_method(T_PAIR, "asn", method);
#line 1118

#line 1118

#line 1121 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PAIR__data */
#line 1121
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1121
  method->new_inst = f_new_method_FI_METHOD__T_PAIR__data;
#line 1121
  method->arg_num = 1;
  method->args_type[0] = T_PAIR;
#line 1121 "filter/f-inst.c"

#line 1121
  f_register_method(T_PAIR, "data", method);
#line 1121

#line 1121

#line 1124 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__asn */
#line 1124
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1124
  method->new_inst = f_new_method_FI_METHOD__T_LC__asn;
#line 1124
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1124 "filter/f-inst.c"

#line 1124
  f_register_method(T_LC, "asn", method);
#line 1124

#line 1124

#line 1127 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__data1 */
#line 1127
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1127
  method->new_inst = f_new_method_FI_METHOD__T_LC__data1;
#line 1127
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1127 "filter/f-inst.c"

#line 1127
  f_register_method(T_LC, "data1", method);
#line 1127

#line 1127

#line 1130 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__data2 */
#line 1130
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1130
  method->new_inst = f_new_method_FI_METHOD__T_LC__data2;
#line 1130
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1130 "filter/f-inst.c"

#line 1130
  f_register_method(T_LC, "data2", method);
#line 1130

#line 1130

#line 1133 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__min */
#line 1133
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1133
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__min;
#line 1133
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 1133 "filter/f-inst.c"

#line 1133
  f_register_method(T_CLIST, "min", method);
#line 1133

#line 1133

#line 1136 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__max */
#line 1136
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1136
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__max;
#line 1136
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 1136 "filter/f-inst.c"

#line 1136
  f_register_method(T_CLIST, "max", method);
#line 1136

#line 1136

#line 1139 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__min */
#line 1139
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1139
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__min;
#line 1139
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1139 "filter/f-inst.c"

#line 1139
  f_register_method(T_ECLIST, "min", method);
#line 1139

#line 1139

#line 1142 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__max */
#line 1142
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1142
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__max;
#line 1142
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1142 "filter/f-inst.c"

#line 1142
  f_register_method(T_ECLIST, "max", method);
#line 1142

#line 1142

#line 1145 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__min */
#line 1145
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1145
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__min;
#line 1145
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1145 "filter/f-inst.c"

#line 1145
  f_register_method(T_LCLIST, "min", method);
#line 1145

#line 1145

#line 1147 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__max */
#line 1147
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1147
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__max;
#line 1147
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1147 "filter/f-inst.c"

#line 1147
  f_register_method(T_LCLIST, "max", method);
#line 1147

#line 1147

#line 1291 "filter/f-inst.c"
 /* Method registrator for FI_IP_MASK */
#line 1291
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1291
  method->new_inst = f_new_method_FI_IP_MASK;
#line 1291
  method->arg_num = 2;
  method->args_type[0] = T_IP;
  method->args_type[1] = T_INT;
#line 1291 "filter/f-inst.c"

#line 1291
  f_register_method(T_IP, "mask", method);
#line 1291

#line 1291

#line 1299 "filter/f-inst.c"
 /* Method registrator for FI_PATH_PREPEND */
#line 1299
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1299
  method->new_inst = f_new_method_FI_PATH_PREPEND;
#line 1299
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_INT;
#line 1299 "filter/f-inst.c"

#line 1299
  f_register_method(T_PATH, "prepend", method);
#line 1299

#line 1299

#line 1307 "filter/f-inst.c"
 /* Method registrator for FI_STRING_APPEND */
#line 1307
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1307
  method->new_inst = f_new_method_FI_STRING_APPEND;
#line 1307
  method->arg_num = 2;
  method->args_type[0] = T_STRING;
  method->args_type[1] = T_STRING;
#line 1307 "filter/f-inst.c"

#line 1307
  f_register_method(T_STRING, "append", method);
#line 1307

#line 1307

#line 1315 "filter/f-inst.c"
 /* Method registrator for FI_BYTESTRING_APPEND */
#line 1315
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1315
  method->new_inst = f_new_method_FI_BYTESTRING_APPEND;
#line 1315
  method->arg_num = 2;
  method->args_type[0] = T_BYTESTRING;
  method->args_type[1] = T_BYTESTRING;
#line 1315 "filter/f-inst.c"

#line 1315
  f_register_method(T_BYTESTRING, "append", method);
#line 1315

#line 1315

#line 1322 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_PAIR */
#line 1322
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1322
  method->new_inst = f_new_method_FI_CLIST_ADD_PAIR;
#line 1322
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_PAIR;
#line 1322 "filter/f-inst.c"

#line 1322
  f_register_method(T_CLIST, "add", method);
#line 1322

#line 1322

#line 1336 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_IP */
#line 1336
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1336
  method->new_inst = f_new_method_FI_CLIST_ADD_IP;
#line 1336
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_IP;
#line 1336 "filter/f-inst.c"

#line 1336
  f_register_method(T_CLIST, "add", method);
#line 1336

#line 1336

#line 1343 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_QUAD */
#line 1343
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1343
  method->new_inst = f_new_method_FI_CLIST_ADD_QUAD;
#line 1343
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_QUAD;
#line 1343 "filter/f-inst.c"

#line 1343
  f_register_method(T_CLIST, "add", method);
#line 1343

#line 1343

#line 1350 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_CLIST */
#line 1350
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1350
  method->new_inst = f_new_method_FI_CLIST_ADD_CLIST;
#line 1350
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1350 "filter/f-inst.c"

#line 1350
  f_register_method(T_CLIST, "add", method);
#line 1350

#line 1350

#line 1357 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_ADD_EC */
#line 1357
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1357
  method->new_inst = f_new_method_FI_ECLIST_ADD_EC;
#line 1357
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_EC;
#line 1357 "filter/f-inst.c"

#line 1357
  f_register_method(T_ECLIST, "add", method);
#line 1357

#line 1357

#line 1364 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_ADD_ECLIST */
#line 1364
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1364
  method->new_inst = f_new_method_FI_ECLIST_ADD_ECLIST;
#line 1364
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1364 "filter/f-inst.c"

#line 1364
  f_register_method(T_ECLIST, "add", method);
#line 1364

#line 1364

#line 1371 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_ADD_LC */
#line 1371
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1371
  method->new_inst = f_new_method_FI_LCLIST_ADD_LC;
#line 1371
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LC;
#line 1371 "filter/f-inst.c"

#line 1371
  f_register_method(T_LCLIST, "add", method);
#line 1371

#line 1371

#line 1378 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_ADD_LCLIST */
#line 1378
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1378
  method->new_inst = f_new_method_FI_LCLIST_ADD_LCLIST;
#line 1378
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1378 "filter/f-inst.c"

#line 1378
  f_register_method(T_LCLIST, "add", method);
#line 1378

#line 1378

#line 1385 "filter/f-inst.c"
 /* Method registrator for FI_PATH_DELETE_INT */
#line 1385
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1385
  method->new_inst = f_new_method_FI_PATH_DELETE_INT;
#line 1385
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_INT;
#line 1385 "filter/f-inst.c"

#line 1385
  f_register_method(T_PATH, "delete", method);
#line 1385

#line 1385

#line 1397 "filter/f-inst.c"
 /* Method registrator for FI_PATH_DELETE_SET */
#line 1397
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1397
  method->new_inst = f_new_method_FI_PATH_DELETE_SET;
#line 1397
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_SET;
#line 1397 "filter/f-inst.c"

#line 1397
  f_register_method(T_PATH, "delete", method);
#line 1397

#line 1397

#line 1404 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_PAIR */
#line 1404
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1404
  method->new_inst = f_new_method_FI_CLIST_DELETE_PAIR;
#line 1404
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_PAIR;
#line 1404 "filter/f-inst.c"

#line 1404
  f_register_method(T_CLIST, "delete", method);
#line 1404

#line 1404

#line 1418 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_IP */
#line 1418
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1418
  method->new_inst = f_new_method_FI_CLIST_DELETE_IP;
#line 1418
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_IP;
#line 1418 "filter/f-inst.c"

#line 1418
  f_register_method(T_CLIST, "delete", method);
#line 1418

#line 1418

#line 1425 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_QUAD */
#line 1425
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1425
  method->new_inst = f_new_method_FI_CLIST_DELETE_QUAD;
#line 1425
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_QUAD;
#line 1425 "filter/f-inst.c"

#line 1425
  f_register_method(T_CLIST, "delete", method);
#line 1425

#line 1425

#line 1432 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_CLIST */
#line 1432
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1432
  method->new_inst = f_new_method_FI_CLIST_DELETE_CLIST;
#line 1432
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1432 "filter/f-inst.c"

#line 1432
  f_register_method(T_CLIST, "delete", method);
#line 1432

#line 1432

#line 1443 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_SET */
#line 1443
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1443
  method->new_inst = f_new_method_FI_CLIST_DELETE_SET;
#line 1443
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_SET;
#line 1443 "filter/f-inst.c"

#line 1443
  f_register_method(T_CLIST, "delete", method);
#line 1443

#line 1443

#line 1450 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_EC */
#line 1450
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1450
  method->new_inst = f_new_method_FI_ECLIST_DELETE_EC;
#line 1450
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_EC;
#line 1450 "filter/f-inst.c"

#line 1450
  f_register_method(T_ECLIST, "delete", method);
#line 1450

#line 1450

#line 1457 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_ECLIST */
#line 1457
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1457
  method->new_inst = f_new_method_FI_ECLIST_DELETE_ECLIST;
#line 1457
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1457 "filter/f-inst.c"

#line 1457
  f_register_method(T_ECLIST, "delete", method);
#line 1457

#line 1457

#line 1468 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_SET */
#line 1468
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1468
  method->new_inst = f_new_method_FI_ECLIST_DELETE_SET;
#line 1468
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_SET;
#line 1468 "filter/f-inst.c"

#line 1468
  f_register_method(T_ECLIST, "delete", method);
#line 1468

#line 1468

#line 1475 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_LC */
#line 1475
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1475
  method->new_inst = f_new_method_FI_LCLIST_DELETE_LC;
#line 1475
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LC;
#line 1475 "filter/f-inst.c"

#line 1475
  f_register_method(T_LCLIST, "delete", method);
#line 1475

#line 1475

#line 1482 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_LCLIST */
#line 1482
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1482
  method->new_inst = f_new_method_FI_LCLIST_DELETE_LCLIST;
#line 1482
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1482 "filter/f-inst.c"

#line 1482
  f_register_method(T_LCLIST, "delete", method);
#line 1482

#line 1482

#line 1493 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_SET */
#line 1493
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1493
  method->new_inst = f_new_method_FI_LCLIST_DELETE_SET;
#line 1493
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_SET;
#line 1493 "filter/f-inst.c"

#line 1493
  f_register_method(T_LCLIST, "delete", method);
#line 1493

#line 1493

#line 1504 "filter/f-inst.c"
 /* Method registrator for FI_PATH_FILTER_SET */
#line 1504
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1504
  method->new_inst = f_new_method_FI_PATH_FILTER_SET;
#line 1504
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_SET;
#line 1504 "filter/f-inst.c"

#line 1504
  f_register_method(T_PATH, "filter", method);
#line 1504

#line 1504

#line 1511 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FILTER_CLIST */
#line 1511
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1511
  method->new_inst = f_new_method_FI_CLIST_FILTER_CLIST;
#line 1511
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1511 "filter/f-inst.c"

#line 1511
  f_register_method(T_CLIST, "filter", method);
#line 1511

#line 1511

#line 1522 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FILTER_SET */
#line 1522
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1522
  method->new_inst = f_new_method_FI_CLIST_FILTER_SET;
#line 1522
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_SET;
#line 1522 "filter/f-inst.c"

#line 1522
  f_register_method(T_CLIST, "filter", method);
#line 1522

#line 1522

#line 1529 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FILTER_ECLIST */
#line 1529
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1529
  method->new_inst = f_new_method_FI_ECLIST_FILTER_ECLIST;
#line 1529
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1529 "filter/f-inst.c"

#line 1529
  f_register_method(T_ECLIST, "filter", method);
#line 1529

#line 1529

#line 1540 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FILTER_SET */
#line 1540
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1540
  method->new_inst = f_new_method_FI_ECLIST_FILTER_SET;
#line 1540
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_SET;
#line 1540 "filter/f-inst.c"

#line 1540
  f_register_method(T_ECLIST, "filter", method);
#line 1540

#line 1540

#line 1547 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FILTER_LCLIST */
#line 1547
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1547
  method->new_inst = f_new_method_FI_LCLIST_FILTER_LCLIST;
#line 1547
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1547 "filter/f-inst.c"

#line 1547
  f_register_method(T_LCLIST, "filter", method);
#line 1547

#line 1547

#line 1558 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FILTER_SET */
#line 1558
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1558
  method->new_inst = f_new_method_FI_LCLIST_FILTER_SET;
#line 1558
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_SET;
#line 1558 "filter/f-inst.c"

#line 1558
  f_register_method(T_LCLIST, "filter", method);
#line 1558

#line 1558

#line 670 "filter/decl.m4"


  for (uint i = 0; i < ARRAY_SIZE(f_type_method_scopes); i++)
    f_type_method_scopes[i].readonly = 1;

  f_type_method_scopes[T_ROUTE].next = &global_filter_scope;
}

/* Line dumpers */
#define INDENT (((const char *) f_dump_line_indent_str) + sizeof(f_dump_line_indent_str) - (indent) - 1)
static const char f_dump_line_indent_str[] = "                                ";

#line 288 "filter/f-inst.c"
 /* Dump line for FI_ADD */
#line 288
static inline void f_dump_line_item_FI_ADD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 288

#line 288
{
#line 288
#define item (&(item_->i_FI_ADD))
#line 288
#undef item
#line 288
}
#line 288

#line 293 "filter/f-inst.c"
 /* Dump line for FI_SUBTRACT */
#line 293
static inline void f_dump_line_item_FI_SUBTRACT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 293

#line 293
{
#line 293
#define item (&(item_->i_FI_SUBTRACT))
#line 293
#undef item
#line 293
}
#line 293

#line 298 "filter/f-inst.c"
 /* Dump line for FI_MULTIPLY */
#line 298
static inline void f_dump_line_item_FI_MULTIPLY(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 298

#line 298
{
#line 298
#define item (&(item_->i_FI_MULTIPLY))
#line 298
#undef item
#line 298
}
#line 298

#line 304 "filter/f-inst.c"
 /* Dump line for FI_DIVIDE */
#line 304
static inline void f_dump_line_item_FI_DIVIDE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 304

#line 304
{
#line 304
#define item (&(item_->i_FI_DIVIDE))
#line 304
#undef item
#line 304
}
#line 304

#line 309 "filter/f-inst.c"
 /* Dump line for FI_BITOR */
#line 309
static inline void f_dump_line_item_FI_BITOR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 309

#line 309
{
#line 309
#define item (&(item_->i_FI_BITOR))
#line 309
#undef item
#line 309
}
#line 309

#line 314 "filter/f-inst.c"
 /* Dump line for FI_BITAND */
#line 314
static inline void f_dump_line_item_FI_BITAND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 314

#line 314
{
#line 314
#define item (&(item_->i_FI_BITAND))
#line 314
#undef item
#line 314
}
#line 314

#line 324 "filter/f-inst.c"
 /* Dump line for FI_AND */
#line 324
static inline void f_dump_line_item_FI_AND(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 324

#line 324
{
#line 324
#define item (&(item_->i_FI_AND))
#line 320 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 324 "filter/f-inst.c"
#undef item
#line 324
}
#line 324

#line 335 "filter/f-inst.c"
 /* Dump line for FI_OR */
#line 335
static inline void f_dump_line_item_FI_OR(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 335

#line 335
{
#line 335
#define item (&(item_->i_FI_OR))
#line 330 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 335 "filter/f-inst.c"
#undef item
#line 335
}
#line 335

#line 345 "filter/f-inst.c"
 /* Dump line for FI_PAIR_CONSTRUCT */
#line 345
static inline void f_dump_line_item_FI_PAIR_CONSTRUCT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 345

#line 345
{
#line 345
#define item (&(item_->i_FI_PAIR_CONSTRUCT))
#line 345
#undef item
#line 345
}
#line 345

#line 385 "filter/f-inst.c"
 /* Dump line for FI_EC_CONSTRUCT */
#line 385
static inline void f_dump_line_item_FI_EC_CONSTRUCT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 385

#line 385
{
#line 385
#define item (&(item_->i_FI_EC_CONSTRUCT))
#line 349 "filter/f-inst.c"
RDUMP("%s" "ec subtype %s" "\n", INDENT, ec_subtype_str(item->ecs));
#line 349

#line 385 "filter/f-inst.c"
#undef item
#line 385
}
#line 385

#line 392 "filter/f-inst.c"
 /* Dump line for FI_LC_CONSTRUCT */
#line 392
static inline void f_dump_line_item_FI_LC_CONSTRUCT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 392

#line 392
{
#line 392
#define item (&(item_->i_FI_LC_CONSTRUCT))
#line 392
#undef item
#line 392
}
#line 392

#line 442 "filter/f-inst.c"
 /* Dump line for FI_PATHMASK_CONSTRUCT */
#line 442
static inline void f_dump_line_item_FI_PATHMASK_CONSTRUCT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 442

#line 442
{
#line 442
#define item (&(item_->i_FI_PATHMASK_CONSTRUCT))
#line 393 "filter/f-inst.c"
  RDUMP("%snumber of varargs %u\n", INDENT, item->varcount);
#line 442 "filter/f-inst.c"
#undef item
#line 442
}
#line 442

#line 449 "filter/f-inst.c"
 /* Dump line for FI_NEQ */
#line 449
static inline void f_dump_line_item_FI_NEQ(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 449

#line 449
{
#line 449
#define item (&(item_->i_FI_NEQ))
#line 449
#undef item
#line 449
}
#line 449

#line 456 "filter/f-inst.c"
 /* Dump line for FI_EQ */
#line 456
static inline void f_dump_line_item_FI_EQ(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 456

#line 456
{
#line 456
#define item (&(item_->i_FI_EQ))
#line 456
#undef item
#line 456
}
#line 456

#line 467 "filter/f-inst.c"
 /* Dump line for FI_LT */
#line 467
static inline void f_dump_line_item_FI_LT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 467

#line 467
{
#line 467
#define item (&(item_->i_FI_LT))
#line 467
#undef item
#line 467
}
#line 467

#line 478 "filter/f-inst.c"
 /* Dump line for FI_LTE */
#line 478
static inline void f_dump_line_item_FI_LTE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 478

#line 478
{
#line 478
#define item (&(item_->i_FI_LTE))
#line 478
#undef item
#line 478
}
#line 478

#line 483 "filter/f-inst.c"
 /* Dump line for FI_NOT */
#line 483
static inline void f_dump_line_item_FI_NOT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 483

#line 483
{
#line 483
#define item (&(item_->i_FI_NOT))
#line 483
#undef item
#line 483
}
#line 483

#line 492 "filter/f-inst.c"
 /* Dump line for FI_MATCH */
#line 492
static inline void f_dump_line_item_FI_MATCH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 492

#line 492
{
#line 492
#define item (&(item_->i_FI_MATCH))
#line 492
#undef item
#line 492
}
#line 492

#line 501 "filter/f-inst.c"
 /* Dump line for FI_NOT_MATCH */
#line 501
static inline void f_dump_line_item_FI_NOT_MATCH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 501

#line 501
{
#line 501
#define item (&(item_->i_FI_NOT_MATCH))
#line 501
#undef item
#line 501
}
#line 501

#line 506 "filter/f-inst.c"
 /* Dump line for FI_DEFINED */
#line 506
static inline void f_dump_line_item_FI_DEFINED(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 506

#line 506
{
#line 506
#define item (&(item_->i_FI_DEFINED))
#line 506
#undef item
#line 506
}
#line 506

#line 507 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__type */
#line 507
static inline void f_dump_line_item_FI_METHOD__T_NET__type(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 507

#line 507
{
#line 507
#define item (&(item_->i_FI_METHOD__T_NET__type))
#line 507
#undef item
#line 507
}
#line 507

#line 510 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_IP__is_v4 */
#line 510
static inline void f_dump_line_item_FI_METHOD__T_IP__is_v4(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 510

#line 510
{
#line 510
#define item (&(item_->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef item
#line 510
}
#line 510

#line 523 "filter/f-inst.c"
 /* Dump line for FI_VAR_INIT */
#line 523
static inline void f_dump_line_item_FI_VAR_INIT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 523

#line 523
{
#line 523
#define item (&(item_->i_FI_VAR_INIT))
#line 513 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 513

#line 523 "filter/f-inst.c"
#undef item
#line 523
}
#line 523

#line 534 "filter/f-inst.c"
 /* Dump line for FI_VAR_INIT0 */
#line 534
static inline void f_dump_line_item_FI_VAR_INIT0(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 534

#line 534
{
#line 534
#define item (&(item_->i_FI_VAR_INIT0))
#line 525 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 525

#line 534 "filter/f-inst.c"
#undef item
#line 534
}
#line 534

#line 543 "filter/f-inst.c"
 /* Dump line for FI_VAR_SET */
#line 543
static inline void f_dump_line_item_FI_VAR_SET(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 543

#line 543
{
#line 543
#define item (&(item_->i_FI_VAR_SET))
#line 537 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 537

#line 543 "filter/f-inst.c"
#undef item
#line 543
}
#line 543

#line 550 "filter/f-inst.c"
 /* Dump line for FI_VAR_GET */
#line 550
static inline void f_dump_line_item_FI_VAR_GET(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 550

#line 550
{
#line 550
#define item (&(item_->i_FI_VAR_GET))
#line 544 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 544

#line 550 "filter/f-inst.c"
#undef item
#line 550
}
#line 550

#line 563 "filter/f-inst.c"
 /* Dump line for FI_CONSTANT */
#line 563
static inline void f_dump_line_item_FI_CONSTANT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 563

#line 563
{
#line 563
#define item (&(item_->i_FI_CONSTANT))
#line 551 "filter/f-inst.c"
RDUMP("%s" "value %s" "\n", INDENT, val_dump(&(item->val))
#line 551
    );
#line 551

#line 563 "filter/f-inst.c"
#undef item
#line 563
}
#line 563

#line 564 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__empty */
#line 564
static inline void f_dump_line_item_FI_METHOD__T_PATH__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 564

#line 564
{
#line 564
#define item (&(item_->i_FI_METHOD__T_PATH__empty))
#line 564
#undef item
#line 564
}
#line 564

#line 565 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__empty */
#line 565
static inline void f_dump_line_item_FI_METHOD__T_CLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 565

#line 565
{
#line 565
#define item (&(item_->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef item
#line 565
}
#line 565

#line 566 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__empty */
#line 566
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 566

#line 566
{
#line 566
#define item (&(item_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef item
#line 566
}
#line 566

#line 569 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__empty */
#line 569
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 569

#line 569
{
#line 569
#define item (&(item_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef item
#line 569
}
#line 569

#line 591 "filter/f-inst.c"
 /* Dump line for FI_FOR_LOOP_START */
#line 591
static inline void f_dump_line_item_FI_FOR_LOOP_START(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 591

#line 591
{
#line 591
#define item (&(item_->i_FI_FOR_LOOP_START))
#line 571 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 571

#line 591 "filter/f-inst.c"
#undef item
#line 591
}
#line 591

#line 600 "filter/f-inst.c"
 /* Dump line for FI_PATH_FOR_NEXT */
#line 600
static inline void f_dump_line_item_FI_PATH_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 600

#line 600
{
#line 600
#define item (&(item_->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 600 "filter/f-inst.c"
#undef item
#line 600
}
#line 600

#line 609 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FOR_NEXT */
#line 609
static inline void f_dump_line_item_FI_CLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 609

#line 609
{
#line 609
#define item (&(item_->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 609 "filter/f-inst.c"
#undef item
#line 609
}
#line 609

#line 618 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FOR_NEXT */
#line 618
static inline void f_dump_line_item_FI_ECLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 618

#line 618
{
#line 618
#define item (&(item_->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 618 "filter/f-inst.c"
#undef item
#line 618
}
#line 618

#line 627 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FOR_NEXT */
#line 627
static inline void f_dump_line_item_FI_LCLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 627

#line 627
{
#line 627
#define item (&(item_->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 627 "filter/f-inst.c"
#undef item
#line 627
}
#line 627

#line 640 "filter/f-inst.c"
 /* Dump line for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
static inline void f_dump_line_item_FI_ROUTES_BLOCK_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 640

#line 640
{
#line 640
#define item (&(item_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 640 "filter/f-inst.c"
#undef item
#line 640
}
#line 640

#line 648 "filter/f-inst.c"
 /* Dump line for FI_CONDITION */
#line 648
static inline void f_dump_line_item_FI_CONDITION(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 648

#line 648
{
#line 648
#define item (&(item_->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 645 "filter/f-inst.c"
f_dump_line(dreq, item->fl3, indent + 1);
#line 648 "filter/f-inst.c"
#undef item
#line 648
}
#line 648

#line 661 "filter/f-inst.c"
 /* Dump line for FI_PRINT */
#line 661
static inline void f_dump_line_item_FI_PRINT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 661

#line 661
{
#line 661
#define item (&(item_->i_FI_PRINT))
#line 661
#undef item
#line 661
}
#line 661

#line 668 "filter/f-inst.c"
 /* Dump line for FI_FLUSH */
#line 668
static inline void f_dump_line_item_FI_FLUSH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 668

#line 668
{
#line 668
#define item (&(item_->i_FI_FLUSH))
#line 668
#undef item
#line 668
}
#line 668

#line 682 "filter/f-inst.c"
 /* Dump line for FI_DIE */
#line 682
static inline void f_dump_line_item_FI_DIE(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 682

#line 682
{
#line 682
#define item (&(item_->i_FI_DIE))
#line 670 "filter/f-inst.c"
RDUMP("%s" "%s" "\n", INDENT, filter_return_str(item->fret));
#line 670

#line 682 "filter/f-inst.c"
#undef item
#line 682
}
#line 682

#line 689 "filter/f-inst.c"
 /* Dump line for FI_CURRENT_ROUTE */
#line 689
static inline void f_dump_line_item_FI_CURRENT_ROUTE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 689

#line 689
{
#line 689
#define item (&(item_->i_FI_CURRENT_ROUTE))
#line 689
#undef item
#line 689
}
#line 689

#line 740 "filter/f-inst.c"
 /* Dump line for FI_RTA_GET */
#line 740
static inline void f_dump_line_item_FI_RTA_GET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 740

#line 740
{
#line 740
#define item (&(item_->i_FI_RTA_GET))
#line 740
#undef item
#line 740
}
#line 740

#line 897 "filter/f-inst.c"
 /* Dump line for FI_RTA_SET */
#line 897
static inline void f_dump_line_item_FI_RTA_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 897

#line 897
{
#line 897
#define item (&(item_->i_FI_RTA_SET))
#line 897
#undef item
#line 897
}
#line 897

#line 934 "filter/f-inst.c"
 /* Dump line for FI_EA_GET */
#line 934
static inline void f_dump_line_item_FI_EA_GET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 934

#line 934
{
#line 934
#define item (&(item_->i_FI_EA_GET))
#line 934
#undef item
#line 934
}
#line 934

#line 975 "filter/f-inst.c"
 /* Dump line for FI_EA_SET */
#line 975
static inline void f_dump_line_item_FI_EA_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 975

#line 975
{
#line 975
#define item (&(item_->i_FI_EA_SET))
#line 975
#undef item
#line 975
}
#line 975

#line 982 "filter/f-inst.c"
 /* Dump line for FI_EA_UNSET */
#line 982
static inline void f_dump_line_item_FI_EA_UNSET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 982

#line 982
{
#line 982
#define item (&(item_->i_FI_EA_UNSET))
#line 982
#undef item
#line 982
}
#line 982

#line 996 "filter/f-inst.c"
 /* Dump line for FI_DEFAULT */
#line 996
static inline void f_dump_line_item_FI_DEFAULT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 996

#line 996
{
#line 996
#define item (&(item_->i_FI_DEFAULT))
#line 996
#undef item
#line 996
}
#line 996

#line 997 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__len */
#line 997
static inline void f_dump_line_item_FI_METHOD__T_NET__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 997

#line 997
{
#line 997
#define item (&(item_->i_FI_METHOD__T_NET__len))
#line 997
#undef item
#line 997
}
#line 997

#line 998 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__len */
#line 998
static inline void f_dump_line_item_FI_METHOD__T_PATH__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 998

#line 998
{
#line 998
#define item (&(item_->i_FI_METHOD__T_PATH__len))
#line 998
#undef item
#line 998
}
#line 998

#line 999 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__len */
#line 999
static inline void f_dump_line_item_FI_METHOD__T_CLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 999

#line 999
{
#line 999
#define item (&(item_->i_FI_METHOD__T_CLIST__len))
#line 999
#undef item
#line 999
}
#line 999

#line 1000 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__len */
#line 1000
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1000

#line 1000
{
#line 1000
#define item (&(item_->i_FI_METHOD__T_ECLIST__len))
#line 1000
#undef item
#line 1000
}
#line 1000

#line 1002 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__len */
#line 1002
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1002

#line 1002
{
#line 1002
#define item (&(item_->i_FI_METHOD__T_LCLIST__len))
#line 1002
#undef item
#line 1002
}
#line 1002

#line 1038 "filter/f-inst.c"
 /* Dump line for FI_NET_SRC */
#line 1038
static inline void f_dump_line_item_FI_NET_SRC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1038

#line 1038
{
#line 1038
#define item (&(item_->i_FI_NET_SRC))
#line 1038
#undef item
#line 1038
}
#line 1038

#line 1075 "filter/f-inst.c"
 /* Dump line for FI_NET_DST */
#line 1075
static inline void f_dump_line_item_FI_NET_DST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1075

#line 1075
{
#line 1075
#define item (&(item_->i_FI_NET_DST))
#line 1075
#undef item
#line 1075
}
#line 1075

#line 1085 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__maxlen */
#line 1085
static inline void f_dump_line_item_FI_METHOD__T_NET__maxlen(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1085

#line 1085
{
#line 1085
#define item (&(item_->i_FI_METHOD__T_NET__maxlen))
#line 1085
#undef item
#line 1085
}
#line 1085

#line 1095 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__asn */
#line 1095
static inline void f_dump_line_item_FI_METHOD__T_NET__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1095

#line 1095
{
#line 1095
#define item (&(item_->i_FI_METHOD__T_NET__asn))
#line 1095
#undef item
#line 1095
}
#line 1095

#line 1097 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__ip */
#line 1097
static inline void f_dump_line_item_FI_METHOD__T_NET__ip(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1097

#line 1097
{
#line 1097
#define item (&(item_->i_FI_METHOD__T_NET__ip))
#line 1097
#undef item
#line 1097
}
#line 1097

#line 1106 "filter/f-inst.c"
 /* Dump line for FI_ROUTE_DISTINGUISHER */
#line 1106
static inline void f_dump_line_item_FI_ROUTE_DISTINGUISHER(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1106

#line 1106
{
#line 1106
#define item (&(item_->i_FI_ROUTE_DISTINGUISHER))
#line 1106
#undef item
#line 1106
}
#line 1106

#line 1109 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__first */
#line 1109
static inline void f_dump_line_item_FI_METHOD__T_PATH__first(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1109

#line 1109
{
#line 1109
#define item (&(item_->i_FI_METHOD__T_PATH__first))
#line 1109
#undef item
#line 1109
}
#line 1109

#line 1112 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__last */
#line 1112
static inline void f_dump_line_item_FI_METHOD__T_PATH__last(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1112

#line 1112
{
#line 1112
#define item (&(item_->i_FI_METHOD__T_PATH__last))
#line 1112
#undef item
#line 1112
}
#line 1112

#line 1115 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
static inline void f_dump_line_item_FI_METHOD__T_PATH__last_nonaggregated(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1115

#line 1115
{
#line 1115
#define item (&(item_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
#undef item
#line 1115
}
#line 1115

#line 1118 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PAIR__asn */
#line 1118
static inline void f_dump_line_item_FI_METHOD__T_PAIR__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1118

#line 1118
{
#line 1118
#define item (&(item_->i_FI_METHOD__T_PAIR__asn))
#line 1118
#undef item
#line 1118
}
#line 1118

#line 1121 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PAIR__data */
#line 1121
static inline void f_dump_line_item_FI_METHOD__T_PAIR__data(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1121

#line 1121
{
#line 1121
#define item (&(item_->i_FI_METHOD__T_PAIR__data))
#line 1121
#undef item
#line 1121
}
#line 1121

#line 1124 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__asn */
#line 1124
static inline void f_dump_line_item_FI_METHOD__T_LC__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1124

#line 1124
{
#line 1124
#define item (&(item_->i_FI_METHOD__T_LC__asn))
#line 1124
#undef item
#line 1124
}
#line 1124

#line 1127 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__data1 */
#line 1127
static inline void f_dump_line_item_FI_METHOD__T_LC__data1(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1127

#line 1127
{
#line 1127
#define item (&(item_->i_FI_METHOD__T_LC__data1))
#line 1127
#undef item
#line 1127
}
#line 1127

#line 1130 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__data2 */
#line 1130
static inline void f_dump_line_item_FI_METHOD__T_LC__data2(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1130

#line 1130
{
#line 1130
#define item (&(item_->i_FI_METHOD__T_LC__data2))
#line 1130
#undef item
#line 1130
}
#line 1130

#line 1133 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__min */
#line 1133
static inline void f_dump_line_item_FI_METHOD__T_CLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1133

#line 1133
{
#line 1133
#define item (&(item_->i_FI_METHOD__T_CLIST__min))
#line 1133
#undef item
#line 1133
}
#line 1133

#line 1136 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__max */
#line 1136
static inline void f_dump_line_item_FI_METHOD__T_CLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1136

#line 1136
{
#line 1136
#define item (&(item_->i_FI_METHOD__T_CLIST__max))
#line 1136
#undef item
#line 1136
}
#line 1136

#line 1139 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__min */
#line 1139
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1139

#line 1139
{
#line 1139
#define item (&(item_->i_FI_METHOD__T_ECLIST__min))
#line 1139
#undef item
#line 1139
}
#line 1139

#line 1142 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__max */
#line 1142
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1142

#line 1142
{
#line 1142
#define item (&(item_->i_FI_METHOD__T_ECLIST__max))
#line 1142
#undef item
#line 1142
}
#line 1142

#line 1145 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__min */
#line 1145
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1145

#line 1145
{
#line 1145
#define item (&(item_->i_FI_METHOD__T_LCLIST__min))
#line 1145
#undef item
#line 1145
}
#line 1145

#line 1147 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__max */
#line 1147
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1147

#line 1147
{
#line 1147
#define item (&(item_->i_FI_METHOD__T_LCLIST__max))
#line 1147
#undef item
#line 1147
}
#line 1147

#line 1173 "filter/f-inst.c"
 /* Dump line for FI_RETURN */
#line 1173
static inline void f_dump_line_item_FI_RETURN(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1173

#line 1173
{
#line 1173
#define item (&(item_->i_FI_RETURN))
#line 1173
#undef item
#line 1173
}
#line 1173

#line 1233 "filter/f-inst.c"
 /* Dump line for FI_CALL */
#line 1233
static inline void f_dump_line_item_FI_CALL(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1233

#line 1233
{
#line 1233
#define item (&(item_->i_FI_CALL))
#line 1175 "filter/f-inst.c"
  RDUMP("%snumber of varargs %u\n", INDENT, item->varcount);
#line 1176 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 1176

#line 1233 "filter/f-inst.c"
#undef item
#line 1233
}
#line 1233

#line 1238 "filter/f-inst.c"
 /* Dump line for FI_DROP_RESULT */
#line 1238
static inline void f_dump_line_item_FI_DROP_RESULT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1238

#line 1238
{
#line 1238
#define item (&(item_->i_FI_DROP_RESULT))
#line 1238
#undef item
#line 1238
}
#line 1238

#line 1282 "filter/f-inst.c"
 /* Dump line for FI_SWITCH */
#line 1282
static inline void f_dump_line_item_FI_SWITCH(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1282

#line 1282
{
#line 1282
#define item (&(item_->i_FI_SWITCH))
#line 1241 "filter/f-inst.c"
RDUMP("%s" "tree %p" "\n", INDENT, item->tree);
#line 1241

#line 1282 "filter/f-inst.c"
#undef item
#line 1282
}
#line 1282

#line 1291 "filter/f-inst.c"
 /* Dump line for FI_IP_MASK */
#line 1291
static inline void f_dump_line_item_FI_IP_MASK(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1291

#line 1291
{
#line 1291
#define item (&(item_->i_FI_IP_MASK))
#line 1291
#undef item
#line 1291
}
#line 1291

#line 1299 "filter/f-inst.c"
 /* Dump line for FI_PATH_PREPEND */
#line 1299
static inline void f_dump_line_item_FI_PATH_PREPEND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1299

#line 1299
{
#line 1299
#define item (&(item_->i_FI_PATH_PREPEND))
#line 1299
#undef item
#line 1299
}
#line 1299

#line 1307 "filter/f-inst.c"
 /* Dump line for FI_STRING_APPEND */
#line 1307
static inline void f_dump_line_item_FI_STRING_APPEND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1307

#line 1307
{
#line 1307
#define item (&(item_->i_FI_STRING_APPEND))
#line 1307
#undef item
#line 1307
}
#line 1307

#line 1315 "filter/f-inst.c"
 /* Dump line for FI_BYTESTRING_APPEND */
#line 1315
static inline void f_dump_line_item_FI_BYTESTRING_APPEND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1315

#line 1315
{
#line 1315
#define item (&(item_->i_FI_BYTESTRING_APPEND))
#line 1315
#undef item
#line 1315
}
#line 1315

#line 1322 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_PAIR */
#line 1322
static inline void f_dump_line_item_FI_CLIST_ADD_PAIR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1322

#line 1322
{
#line 1322
#define item (&(item_->i_FI_CLIST_ADD_PAIR))
#line 1322
#undef item
#line 1322
}
#line 1322

#line 1336 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_IP */
#line 1336
static inline void f_dump_line_item_FI_CLIST_ADD_IP(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1336

#line 1336
{
#line 1336
#define item (&(item_->i_FI_CLIST_ADD_IP))
#line 1336
#undef item
#line 1336
}
#line 1336

#line 1343 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_QUAD */
#line 1343
static inline void f_dump_line_item_FI_CLIST_ADD_QUAD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1343

#line 1343
{
#line 1343
#define item (&(item_->i_FI_CLIST_ADD_QUAD))
#line 1343
#undef item
#line 1343
}
#line 1343

#line 1350 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_CLIST */
#line 1350
static inline void f_dump_line_item_FI_CLIST_ADD_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1350

#line 1350
{
#line 1350
#define item (&(item_->i_FI_CLIST_ADD_CLIST))
#line 1350
#undef item
#line 1350
}
#line 1350

#line 1357 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_ADD_EC */
#line 1357
static inline void f_dump_line_item_FI_ECLIST_ADD_EC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1357

#line 1357
{
#line 1357
#define item (&(item_->i_FI_ECLIST_ADD_EC))
#line 1357
#undef item
#line 1357
}
#line 1357

#line 1364 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_ADD_ECLIST */
#line 1364
static inline void f_dump_line_item_FI_ECLIST_ADD_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1364

#line 1364
{
#line 1364
#define item (&(item_->i_FI_ECLIST_ADD_ECLIST))
#line 1364
#undef item
#line 1364
}
#line 1364

#line 1371 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_ADD_LC */
#line 1371
static inline void f_dump_line_item_FI_LCLIST_ADD_LC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1371

#line 1371
{
#line 1371
#define item (&(item_->i_FI_LCLIST_ADD_LC))
#line 1371
#undef item
#line 1371
}
#line 1371

#line 1378 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_ADD_LCLIST */
#line 1378
static inline void f_dump_line_item_FI_LCLIST_ADD_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1378

#line 1378
{
#line 1378
#define item (&(item_->i_FI_LCLIST_ADD_LCLIST))
#line 1378
#undef item
#line 1378
}
#line 1378

#line 1385 "filter/f-inst.c"
 /* Dump line for FI_PATH_DELETE_INT */
#line 1385
static inline void f_dump_line_item_FI_PATH_DELETE_INT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1385

#line 1385
{
#line 1385
#define item (&(item_->i_FI_PATH_DELETE_INT))
#line 1385
#undef item
#line 1385
}
#line 1385

#line 1397 "filter/f-inst.c"
 /* Dump line for FI_PATH_DELETE_SET */
#line 1397
static inline void f_dump_line_item_FI_PATH_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1397

#line 1397
{
#line 1397
#define item (&(item_->i_FI_PATH_DELETE_SET))
#line 1397
#undef item
#line 1397
}
#line 1397

#line 1404 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_PAIR */
#line 1404
static inline void f_dump_line_item_FI_CLIST_DELETE_PAIR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1404

#line 1404
{
#line 1404
#define item (&(item_->i_FI_CLIST_DELETE_PAIR))
#line 1404
#undef item
#line 1404
}
#line 1404

#line 1418 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_IP */
#line 1418
static inline void f_dump_line_item_FI_CLIST_DELETE_IP(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1418

#line 1418
{
#line 1418
#define item (&(item_->i_FI_CLIST_DELETE_IP))
#line 1418
#undef item
#line 1418
}
#line 1418

#line 1425 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_QUAD */
#line 1425
static inline void f_dump_line_item_FI_CLIST_DELETE_QUAD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1425

#line 1425
{
#line 1425
#define item (&(item_->i_FI_CLIST_DELETE_QUAD))
#line 1425
#undef item
#line 1425
}
#line 1425

#line 1432 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_CLIST */
#line 1432
static inline void f_dump_line_item_FI_CLIST_DELETE_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1432

#line 1432
{
#line 1432
#define item (&(item_->i_FI_CLIST_DELETE_CLIST))
#line 1432
#undef item
#line 1432
}
#line 1432

#line 1443 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_SET */
#line 1443
static inline void f_dump_line_item_FI_CLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1443

#line 1443
{
#line 1443
#define item (&(item_->i_FI_CLIST_DELETE_SET))
#line 1443
#undef item
#line 1443
}
#line 1443

#line 1450 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_EC */
#line 1450
static inline void f_dump_line_item_FI_ECLIST_DELETE_EC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1450

#line 1450
{
#line 1450
#define item (&(item_->i_FI_ECLIST_DELETE_EC))
#line 1450
#undef item
#line 1450
}
#line 1450

#line 1457 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_ECLIST */
#line 1457
static inline void f_dump_line_item_FI_ECLIST_DELETE_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1457

#line 1457
{
#line 1457
#define item (&(item_->i_FI_ECLIST_DELETE_ECLIST))
#line 1457
#undef item
#line 1457
}
#line 1457

#line 1468 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_SET */
#line 1468
static inline void f_dump_line_item_FI_ECLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1468

#line 1468
{
#line 1468
#define item (&(item_->i_FI_ECLIST_DELETE_SET))
#line 1468
#undef item
#line 1468
}
#line 1468

#line 1475 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_LC */
#line 1475
static inline void f_dump_line_item_FI_LCLIST_DELETE_LC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1475

#line 1475
{
#line 1475
#define item (&(item_->i_FI_LCLIST_DELETE_LC))
#line 1475
#undef item
#line 1475
}
#line 1475

#line 1482 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_LCLIST */
#line 1482
static inline void f_dump_line_item_FI_LCLIST_DELETE_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1482

#line 1482
{
#line 1482
#define item (&(item_->i_FI_LCLIST_DELETE_LCLIST))
#line 1482
#undef item
#line 1482
}
#line 1482

#line 1493 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_SET */
#line 1493
static inline void f_dump_line_item_FI_LCLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1493

#line 1493
{
#line 1493
#define item (&(item_->i_FI_LCLIST_DELETE_SET))
#line 1493
#undef item
#line 1493
}
#line 1493

#line 1504 "filter/f-inst.c"
 /* Dump line for FI_PATH_FILTER_SET */
#line 1504
static inline void f_dump_line_item_FI_PATH_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1504

#line 1504
{
#line 1504
#define item (&(item_->i_FI_PATH_FILTER_SET))
#line 1504
#undef item
#line 1504
}
#line 1504

#line 1511 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FILTER_CLIST */
#line 1511
static inline void f_dump_line_item_FI_CLIST_FILTER_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1511

#line 1511
{
#line 1511
#define item (&(item_->i_FI_CLIST_FILTER_CLIST))
#line 1511
#undef item
#line 1511
}
#line 1511

#line 1522 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FILTER_SET */
#line 1522
static inline void f_dump_line_item_FI_CLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1522

#line 1522
{
#line 1522
#define item (&(item_->i_FI_CLIST_FILTER_SET))
#line 1522
#undef item
#line 1522
}
#line 1522

#line 1529 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FILTER_ECLIST */
#line 1529
static inline void f_dump_line_item_FI_ECLIST_FILTER_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1529

#line 1529
{
#line 1529
#define item (&(item_->i_FI_ECLIST_FILTER_ECLIST))
#line 1529
#undef item
#line 1529
}
#line 1529

#line 1540 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FILTER_SET */
#line 1540
static inline void f_dump_line_item_FI_ECLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1540

#line 1540
{
#line 1540
#define item (&(item_->i_FI_ECLIST_FILTER_SET))
#line 1540
#undef item
#line 1540
}
#line 1540

#line 1547 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FILTER_LCLIST */
#line 1547
static inline void f_dump_line_item_FI_LCLIST_FILTER_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1547

#line 1547
{
#line 1547
#define item (&(item_->i_FI_LCLIST_FILTER_LCLIST))
#line 1547
#undef item
#line 1547
}
#line 1547

#line 1558 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FILTER_SET */
#line 1558
static inline void f_dump_line_item_FI_LCLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1558

#line 1558
{
#line 1558
#define item (&(item_->i_FI_LCLIST_FILTER_SET))
#line 1558
#undef item
#line 1558
}
#line 1558

#line 1580 "filter/f-inst.c"
 /* Dump line for FI_ROA_CHECK */
#line 1580
static inline void f_dump_line_item_FI_ROA_CHECK(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1580

#line 1580
{
#line 1580
#define item (&(item_->i_FI_ROA_CHECK))
#line 1562 "filter/f-inst.c"
RDUMP("%s" "route table %s" "\n", INDENT, item->rtc->name);
#line 1562

#line 1580 "filter/f-inst.c"
#undef item
#line 1580
}
#line 1580

#line 1596 "filter/f-inst.c"
 /* Dump line for FI_ASPA_CHECK_EXPLICIT */
#line 1596
static inline void f_dump_line_item_FI_ASPA_CHECK_EXPLICIT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1596

#line 1596
{
#line 1596
#define item (&(item_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1584 "filter/f-inst.c"
RDUMP("%s" "route table %s" "\n", INDENT, item->rtc->name);
#line 1584

#line 1596 "filter/f-inst.c"
#undef item
#line 1596
}
#line 1596

#line 1611 "filter/f-inst.c"
 /* Dump line for FI_FROM_HEX */
#line 1611
static inline void f_dump_line_item_FI_FROM_HEX(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1611

#line 1611
{
#line 1611
#define item (&(item_->i_FI_FROM_HEX))
#line 1611
#undef item
#line 1611
}
#line 1611

#line 1616 "filter/f-inst.c"
 /* Dump line for FI_FORMAT */
#line 1616
static inline void f_dump_line_item_FI_FORMAT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1616

#line 1616
{
#line 1616
#define item (&(item_->i_FI_FORMAT))
#line 1616
#undef item
#line 1616
}
#line 1616

#line 830 "filter/decl.m4"
 /* Dump line for FI_ASSERT */
#line 830
static inline void f_dump_line_item_FI_ASSERT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 830

#line 830
{
#line 830
#define item (&(item_->i_FI_ASSERT))
#line 1620 "filter/f-inst.c"
RDUMP("%s" "string %s" "\n", INDENT, item->s);
#line 1620

#line 830 "filter/decl.m4"
#undef item
#line 830
}
#line 830

#line 682 "filter/decl.m4"


void f_dump_line(struct dump_request *dreq, const struct f_line *dest, uint indent)
{
  if (!dest) {
    RDUMP("%sNo filter line (NULL)\n", INDENT);
    return;
  }
  RDUMP("%sFilter line %p (len=%u)\n", INDENT, dest, dest->len);
  for (uint i=0; i<dest->len; i++) {
    const struct f_line_item *item = &dest->items[i];
    RDUMP("%sInstruction %s at line %u\n", INDENT, f_instruction_name_(item->fi_code), item->lineno);
    switch (item->fi_code) {
#line 288 "filter/f-inst.c"
 /* Dump line caller for FI_ADD */
#line 288
case FI_ADD: f_dump_line_item_FI_ADD(dreq, item, indent + 1); break;
#line 288

#line 293 "filter/f-inst.c"
 /* Dump line caller for FI_SUBTRACT */
#line 293
case FI_SUBTRACT: f_dump_line_item_FI_SUBTRACT(dreq, item, indent + 1); break;
#line 293

#line 298 "filter/f-inst.c"
 /* Dump line caller for FI_MULTIPLY */
#line 298
case FI_MULTIPLY: f_dump_line_item_FI_MULTIPLY(dreq, item, indent + 1); break;
#line 298

#line 304 "filter/f-inst.c"
 /* Dump line caller for FI_DIVIDE */
#line 304
case FI_DIVIDE: f_dump_line_item_FI_DIVIDE(dreq, item, indent + 1); break;
#line 304

#line 309 "filter/f-inst.c"
 /* Dump line caller for FI_BITOR */
#line 309
case FI_BITOR: f_dump_line_item_FI_BITOR(dreq, item, indent + 1); break;
#line 309

#line 314 "filter/f-inst.c"
 /* Dump line caller for FI_BITAND */
#line 314
case FI_BITAND: f_dump_line_item_FI_BITAND(dreq, item, indent + 1); break;
#line 314

#line 324 "filter/f-inst.c"
 /* Dump line caller for FI_AND */
#line 324
case FI_AND: f_dump_line_item_FI_AND(dreq, item, indent + 1); break;
#line 324

#line 335 "filter/f-inst.c"
 /* Dump line caller for FI_OR */
#line 335
case FI_OR: f_dump_line_item_FI_OR(dreq, item, indent + 1); break;
#line 335

#line 345 "filter/f-inst.c"
 /* Dump line caller for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT: f_dump_line_item_FI_PAIR_CONSTRUCT(dreq, item, indent + 1); break;
#line 345

#line 385 "filter/f-inst.c"
 /* Dump line caller for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT: f_dump_line_item_FI_EC_CONSTRUCT(dreq, item, indent + 1); break;
#line 385

#line 392 "filter/f-inst.c"
 /* Dump line caller for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT: f_dump_line_item_FI_LC_CONSTRUCT(dreq, item, indent + 1); break;
#line 392

#line 442 "filter/f-inst.c"
 /* Dump line caller for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT: f_dump_line_item_FI_PATHMASK_CONSTRUCT(dreq, item, indent + 1); break;
#line 442

#line 449 "filter/f-inst.c"
 /* Dump line caller for FI_NEQ */
#line 449
case FI_NEQ: f_dump_line_item_FI_NEQ(dreq, item, indent + 1); break;
#line 449

#line 456 "filter/f-inst.c"
 /* Dump line caller for FI_EQ */
#line 456
case FI_EQ: f_dump_line_item_FI_EQ(dreq, item, indent + 1); break;
#line 456

#line 467 "filter/f-inst.c"
 /* Dump line caller for FI_LT */
#line 467
case FI_LT: f_dump_line_item_FI_LT(dreq, item, indent + 1); break;
#line 467

#line 478 "filter/f-inst.c"
 /* Dump line caller for FI_LTE */
#line 478
case FI_LTE: f_dump_line_item_FI_LTE(dreq, item, indent + 1); break;
#line 478

#line 483 "filter/f-inst.c"
 /* Dump line caller for FI_NOT */
#line 483
case FI_NOT: f_dump_line_item_FI_NOT(dreq, item, indent + 1); break;
#line 483

#line 492 "filter/f-inst.c"
 /* Dump line caller for FI_MATCH */
#line 492
case FI_MATCH: f_dump_line_item_FI_MATCH(dreq, item, indent + 1); break;
#line 492

#line 501 "filter/f-inst.c"
 /* Dump line caller for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH: f_dump_line_item_FI_NOT_MATCH(dreq, item, indent + 1); break;
#line 501

#line 506 "filter/f-inst.c"
 /* Dump line caller for FI_DEFINED */
#line 506
case FI_DEFINED: f_dump_line_item_FI_DEFINED(dreq, item, indent + 1); break;
#line 506

#line 507 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type: f_dump_line_item_FI_METHOD__T_NET__type(dreq, item, indent + 1); break;
#line 507

#line 510 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4: f_dump_line_item_FI_METHOD__T_IP__is_v4(dreq, item, indent + 1); break;
#line 510

#line 523 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_INIT */
#line 523
case FI_VAR_INIT: f_dump_line_item_FI_VAR_INIT(dreq, item, indent + 1); break;
#line 523

#line 534 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0: f_dump_line_item_FI_VAR_INIT0(dreq, item, indent + 1); break;
#line 534

#line 543 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_SET */
#line 543
case FI_VAR_SET: f_dump_line_item_FI_VAR_SET(dreq, item, indent + 1); break;
#line 543

#line 550 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_GET */
#line 550
case FI_VAR_GET: f_dump_line_item_FI_VAR_GET(dreq, item, indent + 1); break;
#line 550

#line 563 "filter/f-inst.c"
 /* Dump line caller for FI_CONSTANT */
#line 563
case FI_CONSTANT: f_dump_line_item_FI_CONSTANT(dreq, item, indent + 1); break;
#line 563

#line 564 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty: f_dump_line_item_FI_METHOD__T_PATH__empty(dreq, item, indent + 1); break;
#line 564

#line 565 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty: f_dump_line_item_FI_METHOD__T_CLIST__empty(dreq, item, indent + 1); break;
#line 565

#line 566 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty: f_dump_line_item_FI_METHOD__T_ECLIST__empty(dreq, item, indent + 1); break;
#line 566

#line 569 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty: f_dump_line_item_FI_METHOD__T_LCLIST__empty(dreq, item, indent + 1); break;
#line 569

#line 591 "filter/f-inst.c"
 /* Dump line caller for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START: f_dump_line_item_FI_FOR_LOOP_START(dreq, item, indent + 1); break;
#line 591

#line 600 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT: f_dump_line_item_FI_PATH_FOR_NEXT(dreq, item, indent + 1); break;
#line 600

#line 609 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT: f_dump_line_item_FI_CLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 609

#line 618 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT: f_dump_line_item_FI_ECLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 618

#line 627 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT: f_dump_line_item_FI_LCLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 627

#line 640 "filter/f-inst.c"
 /* Dump line caller for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT: f_dump_line_item_FI_ROUTES_BLOCK_FOR_NEXT(dreq, item, indent + 1); break;
#line 640

#line 648 "filter/f-inst.c"
 /* Dump line caller for FI_CONDITION */
#line 648
case FI_CONDITION: f_dump_line_item_FI_CONDITION(dreq, item, indent + 1); break;
#line 648

#line 661 "filter/f-inst.c"
 /* Dump line caller for FI_PRINT */
#line 661
case FI_PRINT: f_dump_line_item_FI_PRINT(dreq, item, indent + 1); break;
#line 661

#line 668 "filter/f-inst.c"
 /* Dump line caller for FI_FLUSH */
#line 668
case FI_FLUSH: f_dump_line_item_FI_FLUSH(dreq, item, indent + 1); break;
#line 668

#line 682 "filter/f-inst.c"
 /* Dump line caller for FI_DIE */
#line 682
case FI_DIE: f_dump_line_item_FI_DIE(dreq, item, indent + 1); break;
#line 682

#line 689 "filter/f-inst.c"
 /* Dump line caller for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE: f_dump_line_item_FI_CURRENT_ROUTE(dreq, item, indent + 1); break;
#line 689

#line 740 "filter/f-inst.c"
 /* Dump line caller for FI_RTA_GET */
#line 740
case FI_RTA_GET: f_dump_line_item_FI_RTA_GET(dreq, item, indent + 1); break;
#line 740

#line 897 "filter/f-inst.c"
 /* Dump line caller for FI_RTA_SET */
#line 897
case FI_RTA_SET: f_dump_line_item_FI_RTA_SET(dreq, item, indent + 1); break;
#line 897

#line 934 "filter/f-inst.c"
 /* Dump line caller for FI_EA_GET */
#line 934
case FI_EA_GET: f_dump_line_item_FI_EA_GET(dreq, item, indent + 1); break;
#line 934

#line 975 "filter/f-inst.c"
 /* Dump line caller for FI_EA_SET */
#line 975
case FI_EA_SET: f_dump_line_item_FI_EA_SET(dreq, item, indent + 1); break;
#line 975

#line 982 "filter/f-inst.c"
 /* Dump line caller for FI_EA_UNSET */
#line 982
case FI_EA_UNSET: f_dump_line_item_FI_EA_UNSET(dreq, item, indent + 1); break;
#line 982

#line 996 "filter/f-inst.c"
 /* Dump line caller for FI_DEFAULT */
#line 996
case FI_DEFAULT: f_dump_line_item_FI_DEFAULT(dreq, item, indent + 1); break;
#line 996

#line 997 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__len */
#line 997
case FI_METHOD__T_NET__len: f_dump_line_item_FI_METHOD__T_NET__len(dreq, item, indent + 1); break;
#line 997

#line 998 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__len */
#line 998
case FI_METHOD__T_PATH__len: f_dump_line_item_FI_METHOD__T_PATH__len(dreq, item, indent + 1); break;
#line 998

#line 999 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__len */
#line 999
case FI_METHOD__T_CLIST__len: f_dump_line_item_FI_METHOD__T_CLIST__len(dreq, item, indent + 1); break;
#line 999

#line 1000 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__len */
#line 1000
case FI_METHOD__T_ECLIST__len: f_dump_line_item_FI_METHOD__T_ECLIST__len(dreq, item, indent + 1); break;
#line 1000

#line 1002 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__len */
#line 1002
case FI_METHOD__T_LCLIST__len: f_dump_line_item_FI_METHOD__T_LCLIST__len(dreq, item, indent + 1); break;
#line 1002

#line 1038 "filter/f-inst.c"
 /* Dump line caller for FI_NET_SRC */
#line 1038
case FI_NET_SRC: f_dump_line_item_FI_NET_SRC(dreq, item, indent + 1); break;
#line 1038

#line 1075 "filter/f-inst.c"
 /* Dump line caller for FI_NET_DST */
#line 1075
case FI_NET_DST: f_dump_line_item_FI_NET_DST(dreq, item, indent + 1); break;
#line 1075

#line 1085 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__maxlen */
#line 1085
case FI_METHOD__T_NET__maxlen: f_dump_line_item_FI_METHOD__T_NET__maxlen(dreq, item, indent + 1); break;
#line 1085

#line 1095 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__asn */
#line 1095
case FI_METHOD__T_NET__asn: f_dump_line_item_FI_METHOD__T_NET__asn(dreq, item, indent + 1); break;
#line 1095

#line 1097 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__ip */
#line 1097
case FI_METHOD__T_NET__ip: f_dump_line_item_FI_METHOD__T_NET__ip(dreq, item, indent + 1); break;
#line 1097

#line 1106 "filter/f-inst.c"
 /* Dump line caller for FI_ROUTE_DISTINGUISHER */
#line 1106
case FI_ROUTE_DISTINGUISHER: f_dump_line_item_FI_ROUTE_DISTINGUISHER(dreq, item, indent + 1); break;
#line 1106

#line 1109 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__first */
#line 1109
case FI_METHOD__T_PATH__first: f_dump_line_item_FI_METHOD__T_PATH__first(dreq, item, indent + 1); break;
#line 1109

#line 1112 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__last */
#line 1112
case FI_METHOD__T_PATH__last: f_dump_line_item_FI_METHOD__T_PATH__last(dreq, item, indent + 1); break;
#line 1112

#line 1115 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
case FI_METHOD__T_PATH__last_nonaggregated: f_dump_line_item_FI_METHOD__T_PATH__last_nonaggregated(dreq, item, indent + 1); break;
#line 1115

#line 1118 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PAIR__asn */
#line 1118
case FI_METHOD__T_PAIR__asn: f_dump_line_item_FI_METHOD__T_PAIR__asn(dreq, item, indent + 1); break;
#line 1118

#line 1121 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PAIR__data */
#line 1121
case FI_METHOD__T_PAIR__data: f_dump_line_item_FI_METHOD__T_PAIR__data(dreq, item, indent + 1); break;
#line 1121

#line 1124 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__asn */
#line 1124
case FI_METHOD__T_LC__asn: f_dump_line_item_FI_METHOD__T_LC__asn(dreq, item, indent + 1); break;
#line 1124

#line 1127 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__data1 */
#line 1127
case FI_METHOD__T_LC__data1: f_dump_line_item_FI_METHOD__T_LC__data1(dreq, item, indent + 1); break;
#line 1127

#line 1130 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__data2 */
#line 1130
case FI_METHOD__T_LC__data2: f_dump_line_item_FI_METHOD__T_LC__data2(dreq, item, indent + 1); break;
#line 1130

#line 1133 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__min */
#line 1133
case FI_METHOD__T_CLIST__min: f_dump_line_item_FI_METHOD__T_CLIST__min(dreq, item, indent + 1); break;
#line 1133

#line 1136 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__max */
#line 1136
case FI_METHOD__T_CLIST__max: f_dump_line_item_FI_METHOD__T_CLIST__max(dreq, item, indent + 1); break;
#line 1136

#line 1139 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__min */
#line 1139
case FI_METHOD__T_ECLIST__min: f_dump_line_item_FI_METHOD__T_ECLIST__min(dreq, item, indent + 1); break;
#line 1139

#line 1142 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__max */
#line 1142
case FI_METHOD__T_ECLIST__max: f_dump_line_item_FI_METHOD__T_ECLIST__max(dreq, item, indent + 1); break;
#line 1142

#line 1145 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__min */
#line 1145
case FI_METHOD__T_LCLIST__min: f_dump_line_item_FI_METHOD__T_LCLIST__min(dreq, item, indent + 1); break;
#line 1145

#line 1147 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__max */
#line 1147
case FI_METHOD__T_LCLIST__max: f_dump_line_item_FI_METHOD__T_LCLIST__max(dreq, item, indent + 1); break;
#line 1147

#line 1173 "filter/f-inst.c"
 /* Dump line caller for FI_RETURN */
#line 1173
case FI_RETURN: f_dump_line_item_FI_RETURN(dreq, item, indent + 1); break;
#line 1173

#line 1233 "filter/f-inst.c"
 /* Dump line caller for FI_CALL */
#line 1233
case FI_CALL: f_dump_line_item_FI_CALL(dreq, item, indent + 1); break;
#line 1233

#line 1238 "filter/f-inst.c"
 /* Dump line caller for FI_DROP_RESULT */
#line 1238
case FI_DROP_RESULT: f_dump_line_item_FI_DROP_RESULT(dreq, item, indent + 1); break;
#line 1238

#line 1282 "filter/f-inst.c"
 /* Dump line caller for FI_SWITCH */
#line 1282
case FI_SWITCH: f_dump_line_item_FI_SWITCH(dreq, item, indent + 1); break;
#line 1282

#line 1291 "filter/f-inst.c"
 /* Dump line caller for FI_IP_MASK */
#line 1291
case FI_IP_MASK: f_dump_line_item_FI_IP_MASK(dreq, item, indent + 1); break;
#line 1291

#line 1299 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_PREPEND */
#line 1299
case FI_PATH_PREPEND: f_dump_line_item_FI_PATH_PREPEND(dreq, item, indent + 1); break;
#line 1299

#line 1307 "filter/f-inst.c"
 /* Dump line caller for FI_STRING_APPEND */
#line 1307
case FI_STRING_APPEND: f_dump_line_item_FI_STRING_APPEND(dreq, item, indent + 1); break;
#line 1307

#line 1315 "filter/f-inst.c"
 /* Dump line caller for FI_BYTESTRING_APPEND */
#line 1315
case FI_BYTESTRING_APPEND: f_dump_line_item_FI_BYTESTRING_APPEND(dreq, item, indent + 1); break;
#line 1315

#line 1322 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_PAIR */
#line 1322
case FI_CLIST_ADD_PAIR: f_dump_line_item_FI_CLIST_ADD_PAIR(dreq, item, indent + 1); break;
#line 1322

#line 1336 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_IP */
#line 1336
case FI_CLIST_ADD_IP: f_dump_line_item_FI_CLIST_ADD_IP(dreq, item, indent + 1); break;
#line 1336

#line 1343 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_QUAD */
#line 1343
case FI_CLIST_ADD_QUAD: f_dump_line_item_FI_CLIST_ADD_QUAD(dreq, item, indent + 1); break;
#line 1343

#line 1350 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_CLIST */
#line 1350
case FI_CLIST_ADD_CLIST: f_dump_line_item_FI_CLIST_ADD_CLIST(dreq, item, indent + 1); break;
#line 1350

#line 1357 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_ADD_EC */
#line 1357
case FI_ECLIST_ADD_EC: f_dump_line_item_FI_ECLIST_ADD_EC(dreq, item, indent + 1); break;
#line 1357

#line 1364 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_ADD_ECLIST */
#line 1364
case FI_ECLIST_ADD_ECLIST: f_dump_line_item_FI_ECLIST_ADD_ECLIST(dreq, item, indent + 1); break;
#line 1364

#line 1371 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_ADD_LC */
#line 1371
case FI_LCLIST_ADD_LC: f_dump_line_item_FI_LCLIST_ADD_LC(dreq, item, indent + 1); break;
#line 1371

#line 1378 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_ADD_LCLIST */
#line 1378
case FI_LCLIST_ADD_LCLIST: f_dump_line_item_FI_LCLIST_ADD_LCLIST(dreq, item, indent + 1); break;
#line 1378

#line 1385 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_DELETE_INT */
#line 1385
case FI_PATH_DELETE_INT: f_dump_line_item_FI_PATH_DELETE_INT(dreq, item, indent + 1); break;
#line 1385

#line 1397 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_DELETE_SET */
#line 1397
case FI_PATH_DELETE_SET: f_dump_line_item_FI_PATH_DELETE_SET(dreq, item, indent + 1); break;
#line 1397

#line 1404 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_PAIR */
#line 1404
case FI_CLIST_DELETE_PAIR: f_dump_line_item_FI_CLIST_DELETE_PAIR(dreq, item, indent + 1); break;
#line 1404

#line 1418 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_IP */
#line 1418
case FI_CLIST_DELETE_IP: f_dump_line_item_FI_CLIST_DELETE_IP(dreq, item, indent + 1); break;
#line 1418

#line 1425 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_QUAD */
#line 1425
case FI_CLIST_DELETE_QUAD: f_dump_line_item_FI_CLIST_DELETE_QUAD(dreq, item, indent + 1); break;
#line 1425

#line 1432 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_CLIST */
#line 1432
case FI_CLIST_DELETE_CLIST: f_dump_line_item_FI_CLIST_DELETE_CLIST(dreq, item, indent + 1); break;
#line 1432

#line 1443 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_SET */
#line 1443
case FI_CLIST_DELETE_SET: f_dump_line_item_FI_CLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1443

#line 1450 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_EC */
#line 1450
case FI_ECLIST_DELETE_EC: f_dump_line_item_FI_ECLIST_DELETE_EC(dreq, item, indent + 1); break;
#line 1450

#line 1457 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_ECLIST */
#line 1457
case FI_ECLIST_DELETE_ECLIST: f_dump_line_item_FI_ECLIST_DELETE_ECLIST(dreq, item, indent + 1); break;
#line 1457

#line 1468 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_SET */
#line 1468
case FI_ECLIST_DELETE_SET: f_dump_line_item_FI_ECLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1468

#line 1475 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_LC */
#line 1475
case FI_LCLIST_DELETE_LC: f_dump_line_item_FI_LCLIST_DELETE_LC(dreq, item, indent + 1); break;
#line 1475

#line 1482 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_LCLIST */
#line 1482
case FI_LCLIST_DELETE_LCLIST: f_dump_line_item_FI_LCLIST_DELETE_LCLIST(dreq, item, indent + 1); break;
#line 1482

#line 1493 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_SET */
#line 1493
case FI_LCLIST_DELETE_SET: f_dump_line_item_FI_LCLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1493

#line 1504 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_FILTER_SET */
#line 1504
case FI_PATH_FILTER_SET: f_dump_line_item_FI_PATH_FILTER_SET(dreq, item, indent + 1); break;
#line 1504

#line 1511 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FILTER_CLIST */
#line 1511
case FI_CLIST_FILTER_CLIST: f_dump_line_item_FI_CLIST_FILTER_CLIST(dreq, item, indent + 1); break;
#line 1511

#line 1522 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FILTER_SET */
#line 1522
case FI_CLIST_FILTER_SET: f_dump_line_item_FI_CLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1522

#line 1529 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FILTER_ECLIST */
#line 1529
case FI_ECLIST_FILTER_ECLIST: f_dump_line_item_FI_ECLIST_FILTER_ECLIST(dreq, item, indent + 1); break;
#line 1529

#line 1540 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FILTER_SET */
#line 1540
case FI_ECLIST_FILTER_SET: f_dump_line_item_FI_ECLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1540

#line 1547 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FILTER_LCLIST */
#line 1547
case FI_LCLIST_FILTER_LCLIST: f_dump_line_item_FI_LCLIST_FILTER_LCLIST(dreq, item, indent + 1); break;
#line 1547

#line 1558 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FILTER_SET */
#line 1558
case FI_LCLIST_FILTER_SET: f_dump_line_item_FI_LCLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1558

#line 1580 "filter/f-inst.c"
 /* Dump line caller for FI_ROA_CHECK */
#line 1580
case FI_ROA_CHECK: f_dump_line_item_FI_ROA_CHECK(dreq, item, indent + 1); break;
#line 1580

#line 1596 "filter/f-inst.c"
 /* Dump line caller for FI_ASPA_CHECK_EXPLICIT */
#line 1596
case FI_ASPA_CHECK_EXPLICIT: f_dump_line_item_FI_ASPA_CHECK_EXPLICIT(dreq, item, indent + 1); break;
#line 1596

#line 1611 "filter/f-inst.c"
 /* Dump line caller for FI_FROM_HEX */
#line 1611
case FI_FROM_HEX: f_dump_line_item_FI_FROM_HEX(dreq, item, indent + 1); break;
#line 1611

#line 1616 "filter/f-inst.c"
 /* Dump line caller for FI_FORMAT */
#line 1616
case FI_FORMAT: f_dump_line_item_FI_FORMAT(dreq, item, indent + 1); break;
#line 1616

#line 830 "filter/decl.m4"
 /* Dump line caller for FI_ASSERT */
#line 830
case FI_ASSERT: f_dump_line_item_FI_ASSERT(dreq, item, indent + 1); break;
#line 830

#line 695 "filter/decl.m4"

      default: bug("Unknown instruction %x in f_dump_line", item->fi_code);
    }
  }
  RDUMP("%sFilter line %p dump done\n", INDENT, dest);
}

/* Linearize */
static uint
linearize(struct f_line *dest, const struct f_inst *what, uint pos)
{
  for ( ; what; what = what->next) {
    switch (what->fi_code) {
#line 288 "filter/f-inst.c"
 /* Linearize for FI_ADD */
#line 288
case FI_ADD: {
#line 288
#define whati (&(what->i_FI_ADD))
#line 288
#define item (&(dest->items[pos].i_FI_ADD))
#line 288
  #line 284 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 285 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 288 "filter/f-inst.c"
#undef item
#line 288
  dest->items[pos].fi_code = what->fi_code;
#line 288
  dest->items[pos].flags = what->flags;
#line 288
  dest->items[pos].lineno = what->lineno;
#line 288
  break;
#line 288
}
#line 288

#line 293 "filter/f-inst.c"
 /* Linearize for FI_SUBTRACT */
#line 293
case FI_SUBTRACT: {
#line 293
#define whati (&(what->i_FI_SUBTRACT))
#line 293
#define item (&(dest->items[pos].i_FI_SUBTRACT))
#line 293
  #line 289 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 290 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 293 "filter/f-inst.c"
#undef item
#line 293
  dest->items[pos].fi_code = what->fi_code;
#line 293
  dest->items[pos].flags = what->flags;
#line 293
  dest->items[pos].lineno = what->lineno;
#line 293
  break;
#line 293
}
#line 293

#line 298 "filter/f-inst.c"
 /* Linearize for FI_MULTIPLY */
#line 298
case FI_MULTIPLY: {
#line 298
#define whati (&(what->i_FI_MULTIPLY))
#line 298
#define item (&(dest->items[pos].i_FI_MULTIPLY))
#line 298
  #line 294 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 295 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 298 "filter/f-inst.c"
#undef item
#line 298
  dest->items[pos].fi_code = what->fi_code;
#line 298
  dest->items[pos].flags = what->flags;
#line 298
  dest->items[pos].lineno = what->lineno;
#line 298
  break;
#line 298
}
#line 298

#line 304 "filter/f-inst.c"
 /* Linearize for FI_DIVIDE */
#line 304
case FI_DIVIDE: {
#line 304
#define whati (&(what->i_FI_DIVIDE))
#line 304
#define item (&(dest->items[pos].i_FI_DIVIDE))
#line 304
  #line 299 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 300 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 304 "filter/f-inst.c"
#undef item
#line 304
  dest->items[pos].fi_code = what->fi_code;
#line 304
  dest->items[pos].flags = what->flags;
#line 304
  dest->items[pos].lineno = what->lineno;
#line 304
  break;
#line 304
}
#line 304

#line 309 "filter/f-inst.c"
 /* Linearize for FI_BITOR */
#line 309
case FI_BITOR: {
#line 309
#define whati (&(what->i_FI_BITOR))
#line 309
#define item (&(dest->items[pos].i_FI_BITOR))
#line 309
  #line 305 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 306 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 309 "filter/f-inst.c"
#undef item
#line 309
  dest->items[pos].fi_code = what->fi_code;
#line 309
  dest->items[pos].flags = what->flags;
#line 309
  dest->items[pos].lineno = what->lineno;
#line 309
  break;
#line 309
}
#line 309

#line 314 "filter/f-inst.c"
 /* Linearize for FI_BITAND */
#line 314
case FI_BITAND: {
#line 314
#define whati (&(what->i_FI_BITAND))
#line 314
#define item (&(dest->items[pos].i_FI_BITAND))
#line 314
  #line 310 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 311 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 314 "filter/f-inst.c"
#undef item
#line 314
  dest->items[pos].fi_code = what->fi_code;
#line 314
  dest->items[pos].flags = what->flags;
#line 314
  dest->items[pos].lineno = what->lineno;
#line 314
  break;
#line 314
}
#line 314

#line 324 "filter/f-inst.c"
 /* Linearize for FI_AND */
#line 324
case FI_AND: {
#line 324
#define whati (&(what->i_FI_AND))
#line 324
#define item (&(dest->items[pos].i_FI_AND))
#line 324
  #line 315 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 320 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 1);
#undef whati
#line 324 "filter/f-inst.c"
#undef item
#line 324
  dest->items[pos].fi_code = what->fi_code;
#line 324
  dest->items[pos].flags = what->flags;
#line 324
  dest->items[pos].lineno = what->lineno;
#line 324
  break;
#line 324
}
#line 324

#line 335 "filter/f-inst.c"
 /* Linearize for FI_OR */
#line 335
case FI_OR: {
#line 335
#define whati (&(what->i_FI_OR))
#line 335
#define item (&(dest->items[pos].i_FI_OR))
#line 335
  #line 325 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 330 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 1);
#undef whati
#line 335 "filter/f-inst.c"
#undef item
#line 335
  dest->items[pos].fi_code = what->fi_code;
#line 335
  dest->items[pos].flags = what->flags;
#line 335
  dest->items[pos].lineno = what->lineno;
#line 335
  break;
#line 335
}
#line 335

#line 345 "filter/f-inst.c"
 /* Linearize for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT: {
#line 345
#define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
#define item (&(dest->items[pos].i_FI_PAIR_CONSTRUCT))
#line 345
  #line 336 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 337 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 345 "filter/f-inst.c"
#undef item
#line 345
  dest->items[pos].fi_code = what->fi_code;
#line 345
  dest->items[pos].flags = what->flags;
#line 345
  dest->items[pos].lineno = what->lineno;
#line 345
  break;
#line 345
}
#line 345

#line 385 "filter/f-inst.c"
 /* Linearize for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT: {
#line 385
#define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
#define item (&(dest->items[pos].i_FI_EC_CONSTRUCT))
#line 385
  #line 346 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 347 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 349 "filter/f-inst.c"
item->ecs = whati->ecs;
#line 349

#undef whati
#line 385 "filter/f-inst.c"
#undef item
#line 385
  dest->items[pos].fi_code = what->fi_code;
#line 385
  dest->items[pos].flags = what->flags;
#line 385
  dest->items[pos].lineno = what->lineno;
#line 385
  break;
#line 385
}
#line 385

#line 392 "filter/f-inst.c"
 /* Linearize for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT: {
#line 392
#define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
#define item (&(dest->items[pos].i_FI_LC_CONSTRUCT))
#line 392
  #line 386 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 387 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 388 "filter/f-inst.c"
pos = linearize(dest, whati->f3, pos);
#undef whati
#line 392 "filter/f-inst.c"
#undef item
#line 392
  dest->items[pos].fi_code = what->fi_code;
#line 392
  dest->items[pos].flags = what->flags;
#line 392
  dest->items[pos].lineno = what->lineno;
#line 392
  break;
#line 392
}
#line 392

#line 442 "filter/f-inst.c"
 /* Linearize for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT: {
#line 442
#define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
#define item (&(dest->items[pos].i_FI_PATHMASK_CONSTRUCT))
#line 442
  #line 393 "filter/f-inst.c"
  pos = linearize(dest, whati->fvar, pos);
#line 393
  item->varcount = whati->varcount;
#undef whati
#line 442 "filter/f-inst.c"
#undef item
#line 442
  dest->items[pos].fi_code = what->fi_code;
#line 442
  dest->items[pos].flags = what->flags;
#line 442
  dest->items[pos].lineno = what->lineno;
#line 442
  break;
#line 442
}
#line 442

#line 449 "filter/f-inst.c"
 /* Linearize for FI_NEQ */
#line 449
case FI_NEQ: {
#line 449
#define whati (&(what->i_FI_NEQ))
#line 449
#define item (&(dest->items[pos].i_FI_NEQ))
#line 449
  #line 443 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 444 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 449 "filter/f-inst.c"
#undef item
#line 449
  dest->items[pos].fi_code = what->fi_code;
#line 449
  dest->items[pos].flags = what->flags;
#line 449
  dest->items[pos].lineno = what->lineno;
#line 449
  break;
#line 449
}
#line 449

#line 456 "filter/f-inst.c"
 /* Linearize for FI_EQ */
#line 456
case FI_EQ: {
#line 456
#define whati (&(what->i_FI_EQ))
#line 456
#define item (&(dest->items[pos].i_FI_EQ))
#line 456
  #line 450 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 451 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 456 "filter/f-inst.c"
#undef item
#line 456
  dest->items[pos].fi_code = what->fi_code;
#line 456
  dest->items[pos].flags = what->flags;
#line 456
  dest->items[pos].lineno = what->lineno;
#line 456
  break;
#line 456
}
#line 456

#line 467 "filter/f-inst.c"
 /* Linearize for FI_LT */
#line 467
case FI_LT: {
#line 467
#define whati (&(what->i_FI_LT))
#line 467
#define item (&(dest->items[pos].i_FI_LT))
#line 467
  #line 457 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 458 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 467 "filter/f-inst.c"
#undef item
#line 467
  dest->items[pos].fi_code = what->fi_code;
#line 467
  dest->items[pos].flags = what->flags;
#line 467
  dest->items[pos].lineno = what->lineno;
#line 467
  break;
#line 467
}
#line 467

#line 478 "filter/f-inst.c"
 /* Linearize for FI_LTE */
#line 478
case FI_LTE: {
#line 478
#define whati (&(what->i_FI_LTE))
#line 478
#define item (&(dest->items[pos].i_FI_LTE))
#line 478
  #line 468 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 469 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 478 "filter/f-inst.c"
#undef item
#line 478
  dest->items[pos].fi_code = what->fi_code;
#line 478
  dest->items[pos].flags = what->flags;
#line 478
  dest->items[pos].lineno = what->lineno;
#line 478
  break;
#line 478
}
#line 478

#line 483 "filter/f-inst.c"
 /* Linearize for FI_NOT */
#line 483
case FI_NOT: {
#line 483
#define whati (&(what->i_FI_NOT))
#line 483
#define item (&(dest->items[pos].i_FI_NOT))
#line 483
  #line 479 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 483 "filter/f-inst.c"
#undef item
#line 483
  dest->items[pos].fi_code = what->fi_code;
#line 483
  dest->items[pos].flags = what->flags;
#line 483
  dest->items[pos].lineno = what->lineno;
#line 483
  break;
#line 483
}
#line 483

#line 492 "filter/f-inst.c"
 /* Linearize for FI_MATCH */
#line 492
case FI_MATCH: {
#line 492
#define whati (&(what->i_FI_MATCH))
#line 492
#define item (&(dest->items[pos].i_FI_MATCH))
#line 492
  #line 484 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 485 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 492 "filter/f-inst.c"
#undef item
#line 492
  dest->items[pos].fi_code = what->fi_code;
#line 492
  dest->items[pos].flags = what->flags;
#line 492
  dest->items[pos].lineno = what->lineno;
#line 492
  break;
#line 492
}
#line 492

#line 501 "filter/f-inst.c"
 /* Linearize for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH: {
#line 501
#define whati (&(what->i_FI_NOT_MATCH))
#line 501
#define item (&(dest->items[pos].i_FI_NOT_MATCH))
#line 501
  #line 493 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 494 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 501 "filter/f-inst.c"
#undef item
#line 501
  dest->items[pos].fi_code = what->fi_code;
#line 501
  dest->items[pos].flags = what->flags;
#line 501
  dest->items[pos].lineno = what->lineno;
#line 501
  break;
#line 501
}
#line 501

#line 506 "filter/f-inst.c"
 /* Linearize for FI_DEFINED */
#line 506
case FI_DEFINED: {
#line 506
#define whati (&(what->i_FI_DEFINED))
#line 506
#define item (&(dest->items[pos].i_FI_DEFINED))
#line 506
  #line 502 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 506 "filter/f-inst.c"
#undef item
#line 506
  dest->items[pos].fi_code = what->fi_code;
#line 506
  dest->items[pos].flags = what->flags;
#line 506
  dest->items[pos].lineno = what->lineno;
#line 506
  break;
#line 506
}
#line 506

#line 507 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type: {
#line 507
#define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__type))
#line 507
  #line 506 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 507 "filter/f-inst.c"
#undef item
#line 507
  dest->items[pos].fi_code = what->fi_code;
#line 507
  dest->items[pos].flags = what->flags;
#line 507
  dest->items[pos].lineno = what->lineno;
#line 507
  break;
#line 507
}
#line 507

#line 510 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4: {
#line 510
#define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
#define item (&(dest->items[pos].i_FI_METHOD__T_IP__is_v4))
#line 510
  #line 507 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 510 "filter/f-inst.c"
#undef item
#line 510
  dest->items[pos].fi_code = what->fi_code;
#line 510
  dest->items[pos].flags = what->flags;
#line 510
  dest->items[pos].lineno = what->lineno;
#line 510
  break;
#line 510
}
#line 510

#line 523 "filter/f-inst.c"
 /* Linearize for FI_VAR_INIT */
#line 523
case FI_VAR_INIT: {
#line 523
#define whati (&(what->i_FI_VAR_INIT))
#line 523
#define item (&(dest->items[pos].i_FI_VAR_INIT))
#line 523
  #line 512 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 513 "filter/f-inst.c"
item->sym = whati->sym;
#line 513

#undef whati
#line 523 "filter/f-inst.c"
#undef item
#line 523
  dest->items[pos].fi_code = what->fi_code;
#line 523
  dest->items[pos].flags = what->flags;
#line 523
  dest->items[pos].lineno = what->lineno;
#line 523
  break;
#line 523
}
#line 523

#line 534 "filter/f-inst.c"
 /* Linearize for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0: {
#line 534
#define whati (&(what->i_FI_VAR_INIT0))
#line 534
#define item (&(dest->items[pos].i_FI_VAR_INIT0))
#line 534
  #line 525 "filter/f-inst.c"
item->sym = whati->sym;
#line 525

#undef whati
#line 534 "filter/f-inst.c"
#undef item
#line 534
  dest->items[pos].fi_code = what->fi_code;
#line 534
  dest->items[pos].flags = what->flags;
#line 534
  dest->items[pos].lineno = what->lineno;
#line 534
  break;
#line 534
}
#line 534

#line 543 "filter/f-inst.c"
 /* Linearize for FI_VAR_SET */
#line 543
case FI_VAR_SET: {
#line 543
#define whati (&(what->i_FI_VAR_SET))
#line 543
#define item (&(dest->items[pos].i_FI_VAR_SET))
#line 543
  #line 536 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 537 "filter/f-inst.c"
item->sym = whati->sym;
#line 537

#undef whati
#line 543 "filter/f-inst.c"
#undef item
#line 543
  dest->items[pos].fi_code = what->fi_code;
#line 543
  dest->items[pos].flags = what->flags;
#line 543
  dest->items[pos].lineno = what->lineno;
#line 543
  break;
#line 543
}
#line 543

#line 550 "filter/f-inst.c"
 /* Linearize for FI_VAR_GET */
#line 550
case FI_VAR_GET: {
#line 550
#define whati (&(what->i_FI_VAR_GET))
#line 550
#define item (&(dest->items[pos].i_FI_VAR_GET))
#line 550
  #line 544 "filter/f-inst.c"
item->sym = whati->sym;
#line 544

#undef whati
#line 550 "filter/f-inst.c"
#undef item
#line 550
  dest->items[pos].fi_code = what->fi_code;
#line 550
  dest->items[pos].flags = what->flags;
#line 550
  dest->items[pos].lineno = what->lineno;
#line 550
  break;
#line 550
}
#line 550

#line 563 "filter/f-inst.c"
 /* Linearize for FI_CONSTANT */
#line 563
case FI_CONSTANT: {
#line 563
#define whati (&(what->i_FI_CONSTANT))
#line 563
#define item (&(dest->items[pos].i_FI_CONSTANT))
#line 563
  #line 551 "filter/f-inst.c"
item->val = whati->val;
#line 551

#undef whati
#line 563 "filter/f-inst.c"
#undef item
#line 563
  dest->items[pos].fi_code = what->fi_code;
#line 563
  dest->items[pos].flags = what->flags;
#line 563
  dest->items[pos].lineno = what->lineno;
#line 563
  break;
#line 563
}
#line 563

#line 564 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty: {
#line 564
#define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__empty))
#line 564
  #line 563 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 564 "filter/f-inst.c"
#undef item
#line 564
  dest->items[pos].fi_code = what->fi_code;
#line 564
  dest->items[pos].flags = what->flags;
#line 564
  dest->items[pos].lineno = what->lineno;
#line 564
  break;
#line 564
}
#line 564

#line 565 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty: {
#line 565
#define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__empty))
#line 565
  #line 564 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 565 "filter/f-inst.c"
#undef item
#line 565
  dest->items[pos].fi_code = what->fi_code;
#line 565
  dest->items[pos].flags = what->flags;
#line 565
  dest->items[pos].lineno = what->lineno;
#line 565
  break;
#line 565
}
#line 565

#line 566 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty: {
#line 566
#define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__empty))
#line 566
  #line 565 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 566 "filter/f-inst.c"
#undef item
#line 566
  dest->items[pos].fi_code = what->fi_code;
#line 566
  dest->items[pos].flags = what->flags;
#line 566
  dest->items[pos].lineno = what->lineno;
#line 566
  break;
#line 566
}
#line 566

#line 569 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty: {
#line 569
#define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__empty))
#line 569
  #line 566 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 569 "filter/f-inst.c"
#undef item
#line 569
  dest->items[pos].fi_code = what->fi_code;
#line 569
  dest->items[pos].flags = what->flags;
#line 569
  dest->items[pos].lineno = what->lineno;
#line 569
  break;
#line 569
}
#line 569

#line 591 "filter/f-inst.c"
 /* Linearize for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START: {
#line 591
#define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
#define item (&(dest->items[pos].i_FI_FOR_LOOP_START))
#line 591
  #line 571 "filter/f-inst.c"
item->sym = whati->sym;
#line 571

#undef whati
#line 591 "filter/f-inst.c"
#undef item
#line 591
  dest->items[pos].fi_code = what->fi_code;
#line 591
  dest->items[pos].flags = what->flags;
#line 591
  dest->items[pos].lineno = what->lineno;
#line 591
  break;
#line 591
}
#line 591

#line 600 "filter/f-inst.c"
 /* Linearize for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT: {
#line 600
#define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 600
#define item (&(dest->items[pos].i_FI_PATH_FOR_NEXT))
#line 600
  #line 593 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 595 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 600 "filter/f-inst.c"
#undef item
#line 600
  dest->items[pos].fi_code = what->fi_code;
#line 600
  dest->items[pos].flags = what->flags;
#line 600
  dest->items[pos].lineno = what->lineno;
#line 600
  break;
#line 600
}
#line 600

#line 609 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT: {
#line 609
#define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 609
#define item (&(dest->items[pos].i_FI_CLIST_FOR_NEXT))
#line 609
  #line 602 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 604 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 609 "filter/f-inst.c"
#undef item
#line 609
  dest->items[pos].fi_code = what->fi_code;
#line 609
  dest->items[pos].flags = what->flags;
#line 609
  dest->items[pos].lineno = what->lineno;
#line 609
  break;
#line 609
}
#line 609

#line 618 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT: {
#line 618
#define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 618
#define item (&(dest->items[pos].i_FI_ECLIST_FOR_NEXT))
#line 618
  #line 611 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 613 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 618 "filter/f-inst.c"
#undef item
#line 618
  dest->items[pos].fi_code = what->fi_code;
#line 618
  dest->items[pos].flags = what->flags;
#line 618
  dest->items[pos].lineno = what->lineno;
#line 618
  break;
#line 618
}
#line 618

#line 627 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT: {
#line 627
#define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 627
#define item (&(dest->items[pos].i_FI_LCLIST_FOR_NEXT))
#line 627
  #line 620 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 622 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 627 "filter/f-inst.c"
#undef item
#line 627
  dest->items[pos].fi_code = what->fi_code;
#line 627
  dest->items[pos].flags = what->flags;
#line 627
  dest->items[pos].lineno = what->lineno;
#line 627
  break;
#line 627
}
#line 627

#line 640 "filter/f-inst.c"
 /* Linearize for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT: {
#line 640
#define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
#define item (&(dest->items[pos].i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
  #line 629 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 634 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 640 "filter/f-inst.c"
#undef item
#line 640
  dest->items[pos].fi_code = what->fi_code;
#line 640
  dest->items[pos].flags = what->flags;
#line 640
  dest->items[pos].lineno = what->lineno;
#line 640
  break;
#line 640
}
#line 640

#line 648 "filter/f-inst.c"
 /* Linearize for FI_CONDITION */
#line 648
case FI_CONDITION: {
#line 648
#define whati (&(what->i_FI_CONDITION))
#line 648
#define item (&(dest->items[pos].i_FI_CONDITION))
#line 648
  #line 641 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 643 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#line 645 "filter/f-inst.c"
item->fl3 = f_linearize(whati->f3, 0);
#undef whati
#line 648 "filter/f-inst.c"
#undef item
#line 648
  dest->items[pos].fi_code = what->fi_code;
#line 648
  dest->items[pos].flags = what->flags;
#line 648
  dest->items[pos].lineno = what->lineno;
#line 648
  break;
#line 648
}
#line 648

#line 661 "filter/f-inst.c"
 /* Linearize for FI_PRINT */
#line 661
case FI_PRINT: {
#line 661
#define whati (&(what->i_FI_PRINT))
#line 661
#define item (&(dest->items[pos].i_FI_PRINT))
#line 661
  #line 650 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 661 "filter/f-inst.c"
#undef item
#line 661
  dest->items[pos].fi_code = what->fi_code;
#line 661
  dest->items[pos].flags = what->flags;
#line 661
  dest->items[pos].lineno = what->lineno;
#line 661
  break;
#line 661
}
#line 661

#line 668 "filter/f-inst.c"
 /* Linearize for FI_FLUSH */
#line 668
case FI_FLUSH: {
#line 668
#define whati (&(what->i_FI_FLUSH))
#line 668
#define item (&(dest->items[pos].i_FI_FLUSH))
#line 668
  #undef whati
#line 668
#undef item
#line 668
  dest->items[pos].fi_code = what->fi_code;
#line 668
  dest->items[pos].flags = what->flags;
#line 668
  dest->items[pos].lineno = what->lineno;
#line 668
  break;
#line 668
}
#line 668

#line 682 "filter/f-inst.c"
 /* Linearize for FI_DIE */
#line 682
case FI_DIE: {
#line 682
#define whati (&(what->i_FI_DIE))
#line 682
#define item (&(dest->items[pos].i_FI_DIE))
#line 682
  #line 670 "filter/f-inst.c"
item->fret = whati->fret;
#line 670

#undef whati
#line 682 "filter/f-inst.c"
#undef item
#line 682
  dest->items[pos].fi_code = what->fi_code;
#line 682
  dest->items[pos].flags = what->flags;
#line 682
  dest->items[pos].lineno = what->lineno;
#line 682
  break;
#line 682
}
#line 682

#line 689 "filter/f-inst.c"
 /* Linearize for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE: {
#line 689
#define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
#define item (&(dest->items[pos].i_FI_CURRENT_ROUTE))
#line 689
  #undef whati
#line 689
#undef item
#line 689
  dest->items[pos].fi_code = what->fi_code;
#line 689
  dest->items[pos].flags = what->flags;
#line 689
  dest->items[pos].lineno = what->lineno;
#line 689
  break;
#line 689
}
#line 689

#line 740 "filter/f-inst.c"
 /* Linearize for FI_RTA_GET */
#line 740
case FI_RTA_GET: {
#line 740
#define whati (&(what->i_FI_RTA_GET))
#line 740
#define item (&(dest->items[pos].i_FI_RTA_GET))
#line 740
  #line 691 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 692 "filter/f-inst.c"
item->sa = whati->sa;
#line 692

#undef whati
#line 740 "filter/f-inst.c"
#undef item
#line 740
  dest->items[pos].fi_code = what->fi_code;
#line 740
  dest->items[pos].flags = what->flags;
#line 740
  dest->items[pos].lineno = what->lineno;
#line 740
  break;
#line 740
}
#line 740

#line 897 "filter/f-inst.c"
 /* Linearize for FI_RTA_SET */
#line 897
case FI_RTA_SET: {
#line 897
#define whati (&(what->i_FI_RTA_SET))
#line 897
#define item (&(dest->items[pos].i_FI_RTA_SET))
#line 897
  #line 742 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 743 "filter/f-inst.c"
item->sa = whati->sa;
#line 743

#undef whati
#line 897 "filter/f-inst.c"
#undef item
#line 897
  dest->items[pos].fi_code = what->fi_code;
#line 897
  dest->items[pos].flags = what->flags;
#line 897
  dest->items[pos].lineno = what->lineno;
#line 897
  break;
#line 897
}
#line 897

#line 934 "filter/f-inst.c"
 /* Linearize for FI_EA_GET */
#line 934
case FI_EA_GET: {
#line 934
#define whati (&(what->i_FI_EA_GET))
#line 934
#define item (&(dest->items[pos].i_FI_EA_GET))
#line 934
  #line 898 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 899 "filter/f-inst.c"
item->da = whati->da;
#line 899

#undef whati
#line 934 "filter/f-inst.c"
#undef item
#line 934
  dest->items[pos].fi_code = what->fi_code;
#line 934
  dest->items[pos].flags = what->flags;
#line 934
  dest->items[pos].lineno = what->lineno;
#line 934
  break;
#line 934
}
#line 934

#line 975 "filter/f-inst.c"
 /* Linearize for FI_EA_SET */
#line 975
case FI_EA_SET: {
#line 975
#define whati (&(what->i_FI_EA_SET))
#line 975
#define item (&(dest->items[pos].i_FI_EA_SET))
#line 975
  #line 936 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 937 "filter/f-inst.c"
item->da = whati->da;
#line 937

#undef whati
#line 975 "filter/f-inst.c"
#undef item
#line 975
  dest->items[pos].fi_code = what->fi_code;
#line 975
  dest->items[pos].flags = what->flags;
#line 975
  dest->items[pos].lineno = what->lineno;
#line 975
  break;
#line 975
}
#line 975

#line 982 "filter/f-inst.c"
 /* Linearize for FI_EA_UNSET */
#line 982
case FI_EA_UNSET: {
#line 982
#define whati (&(what->i_FI_EA_UNSET))
#line 982
#define item (&(dest->items[pos].i_FI_EA_UNSET))
#line 982
  #line 976 "filter/f-inst.c"
item->da = whati->da;
#line 976

#undef whati
#line 982 "filter/f-inst.c"
#undef item
#line 982
  dest->items[pos].fi_code = what->fi_code;
#line 982
  dest->items[pos].flags = what->flags;
#line 982
  dest->items[pos].lineno = what->lineno;
#line 982
  break;
#line 982
}
#line 982

#line 996 "filter/f-inst.c"
 /* Linearize for FI_DEFAULT */
#line 996
case FI_DEFAULT: {
#line 996
#define whati (&(what->i_FI_DEFAULT))
#line 996
#define item (&(dest->items[pos].i_FI_DEFAULT))
#line 996
  #line 983 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 984 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 996 "filter/f-inst.c"
#undef item
#line 996
  dest->items[pos].fi_code = what->fi_code;
#line 996
  dest->items[pos].flags = what->flags;
#line 996
  dest->items[pos].lineno = what->lineno;
#line 996
  break;
#line 996
}
#line 996

#line 997 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__len */
#line 997
case FI_METHOD__T_NET__len: {
#line 997
#define whati (&(what->i_FI_METHOD__T_NET__len))
#line 997
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__len))
#line 997
  #line 996 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 997 "filter/f-inst.c"
#undef item
#line 997
  dest->items[pos].fi_code = what->fi_code;
#line 997
  dest->items[pos].flags = what->flags;
#line 997
  dest->items[pos].lineno = what->lineno;
#line 997
  break;
#line 997
}
#line 997

#line 998 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__len */
#line 998
case FI_METHOD__T_PATH__len: {
#line 998
#define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 998
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__len))
#line 998
  #line 997 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 998 "filter/f-inst.c"
#undef item
#line 998
  dest->items[pos].fi_code = what->fi_code;
#line 998
  dest->items[pos].flags = what->flags;
#line 998
  dest->items[pos].lineno = what->lineno;
#line 998
  break;
#line 998
}
#line 998

#line 999 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__len */
#line 999
case FI_METHOD__T_CLIST__len: {
#line 999
#define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 999
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__len))
#line 999
  #line 998 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 999 "filter/f-inst.c"
#undef item
#line 999
  dest->items[pos].fi_code = what->fi_code;
#line 999
  dest->items[pos].flags = what->flags;
#line 999
  dest->items[pos].lineno = what->lineno;
#line 999
  break;
#line 999
}
#line 999

#line 1000 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__len */
#line 1000
case FI_METHOD__T_ECLIST__len: {
#line 1000
#define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 1000
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__len))
#line 1000
  #line 999 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1000 "filter/f-inst.c"
#undef item
#line 1000
  dest->items[pos].fi_code = what->fi_code;
#line 1000
  dest->items[pos].flags = what->flags;
#line 1000
  dest->items[pos].lineno = what->lineno;
#line 1000
  break;
#line 1000
}
#line 1000

#line 1002 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__len */
#line 1002
case FI_METHOD__T_LCLIST__len: {
#line 1002
#define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 1002
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__len))
#line 1002
  #line 1000 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1002 "filter/f-inst.c"
#undef item
#line 1002
  dest->items[pos].fi_code = what->fi_code;
#line 1002
  dest->items[pos].flags = what->flags;
#line 1002
  dest->items[pos].lineno = what->lineno;
#line 1002
  break;
#line 1002
}
#line 1002

#line 1038 "filter/f-inst.c"
 /* Linearize for FI_NET_SRC */
#line 1038
case FI_NET_SRC: {
#line 1038
#define whati (&(what->i_FI_NET_SRC))
#line 1038
#define item (&(dest->items[pos].i_FI_NET_SRC))
#line 1038
  #line 1003 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1038 "filter/f-inst.c"
#undef item
#line 1038
  dest->items[pos].fi_code = what->fi_code;
#line 1038
  dest->items[pos].flags = what->flags;
#line 1038
  dest->items[pos].lineno = what->lineno;
#line 1038
  break;
#line 1038
}
#line 1038

#line 1075 "filter/f-inst.c"
 /* Linearize for FI_NET_DST */
#line 1075
case FI_NET_DST: {
#line 1075
#define whati (&(what->i_FI_NET_DST))
#line 1075
#define item (&(dest->items[pos].i_FI_NET_DST))
#line 1075
  #line 1039 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1075 "filter/f-inst.c"
#undef item
#line 1075
  dest->items[pos].fi_code = what->fi_code;
#line 1075
  dest->items[pos].flags = what->flags;
#line 1075
  dest->items[pos].lineno = what->lineno;
#line 1075
  break;
#line 1075
}
#line 1075

#line 1085 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__maxlen */
#line 1085
case FI_METHOD__T_NET__maxlen: {
#line 1085
#define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1085
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__maxlen))
#line 1085
  #line 1075 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1085 "filter/f-inst.c"
#undef item
#line 1085
  dest->items[pos].fi_code = what->fi_code;
#line 1085
  dest->items[pos].flags = what->flags;
#line 1085
  dest->items[pos].lineno = what->lineno;
#line 1085
  break;
#line 1085
}
#line 1085

#line 1095 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__asn */
#line 1095
case FI_METHOD__T_NET__asn: {
#line 1095
#define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1095
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__asn))
#line 1095
  #line 1085 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1095 "filter/f-inst.c"
#undef item
#line 1095
  dest->items[pos].fi_code = what->fi_code;
#line 1095
  dest->items[pos].flags = what->flags;
#line 1095
  dest->items[pos].lineno = what->lineno;
#line 1095
  break;
#line 1095
}
#line 1095

#line 1097 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__ip */
#line 1097
case FI_METHOD__T_NET__ip: {
#line 1097
#define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1097
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__ip))
#line 1097
  #line 1095 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1097 "filter/f-inst.c"
#undef item
#line 1097
  dest->items[pos].fi_code = what->fi_code;
#line 1097
  dest->items[pos].flags = what->flags;
#line 1097
  dest->items[pos].lineno = what->lineno;
#line 1097
  break;
#line 1097
}
#line 1097

#line 1106 "filter/f-inst.c"
 /* Linearize for FI_ROUTE_DISTINGUISHER */
#line 1106
case FI_ROUTE_DISTINGUISHER: {
#line 1106
#define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1106
#define item (&(dest->items[pos].i_FI_ROUTE_DISTINGUISHER))
#line 1106
  #line 1098 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1106 "filter/f-inst.c"
#undef item
#line 1106
  dest->items[pos].fi_code = what->fi_code;
#line 1106
  dest->items[pos].flags = what->flags;
#line 1106
  dest->items[pos].lineno = what->lineno;
#line 1106
  break;
#line 1106
}
#line 1106

#line 1109 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__first */
#line 1109
case FI_METHOD__T_PATH__first: {
#line 1109
#define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1109
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__first))
#line 1109
  #line 1106 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1109 "filter/f-inst.c"
#undef item
#line 1109
  dest->items[pos].fi_code = what->fi_code;
#line 1109
  dest->items[pos].flags = what->flags;
#line 1109
  dest->items[pos].lineno = what->lineno;
#line 1109
  break;
#line 1109
}
#line 1109

#line 1112 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__last */
#line 1112
case FI_METHOD__T_PATH__last: {
#line 1112
#define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1112
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__last))
#line 1112
  #line 1109 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1112 "filter/f-inst.c"
#undef item
#line 1112
  dest->items[pos].fi_code = what->fi_code;
#line 1112
  dest->items[pos].flags = what->flags;
#line 1112
  dest->items[pos].lineno = what->lineno;
#line 1112
  break;
#line 1112
}
#line 1112

#line 1115 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
case FI_METHOD__T_PATH__last_nonaggregated: {
#line 1115
#define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
  #line 1112 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1115 "filter/f-inst.c"
#undef item
#line 1115
  dest->items[pos].fi_code = what->fi_code;
#line 1115
  dest->items[pos].flags = what->flags;
#line 1115
  dest->items[pos].lineno = what->lineno;
#line 1115
  break;
#line 1115
}
#line 1115

#line 1118 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PAIR__asn */
#line 1118
case FI_METHOD__T_PAIR__asn: {
#line 1118
#define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1118
#define item (&(dest->items[pos].i_FI_METHOD__T_PAIR__asn))
#line 1118
  #line 1115 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1118 "filter/f-inst.c"
#undef item
#line 1118
  dest->items[pos].fi_code = what->fi_code;
#line 1118
  dest->items[pos].flags = what->flags;
#line 1118
  dest->items[pos].lineno = what->lineno;
#line 1118
  break;
#line 1118
}
#line 1118

#line 1121 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PAIR__data */
#line 1121
case FI_METHOD__T_PAIR__data: {
#line 1121
#define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1121
#define item (&(dest->items[pos].i_FI_METHOD__T_PAIR__data))
#line 1121
  #line 1118 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1121 "filter/f-inst.c"
#undef item
#line 1121
  dest->items[pos].fi_code = what->fi_code;
#line 1121
  dest->items[pos].flags = what->flags;
#line 1121
  dest->items[pos].lineno = what->lineno;
#line 1121
  break;
#line 1121
}
#line 1121

#line 1124 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__asn */
#line 1124
case FI_METHOD__T_LC__asn: {
#line 1124
#define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1124
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__asn))
#line 1124
  #line 1121 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1124 "filter/f-inst.c"
#undef item
#line 1124
  dest->items[pos].fi_code = what->fi_code;
#line 1124
  dest->items[pos].flags = what->flags;
#line 1124
  dest->items[pos].lineno = what->lineno;
#line 1124
  break;
#line 1124
}
#line 1124

#line 1127 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__data1 */
#line 1127
case FI_METHOD__T_LC__data1: {
#line 1127
#define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1127
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__data1))
#line 1127
  #line 1124 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1127 "filter/f-inst.c"
#undef item
#line 1127
  dest->items[pos].fi_code = what->fi_code;
#line 1127
  dest->items[pos].flags = what->flags;
#line 1127
  dest->items[pos].lineno = what->lineno;
#line 1127
  break;
#line 1127
}
#line 1127

#line 1130 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__data2 */
#line 1130
case FI_METHOD__T_LC__data2: {
#line 1130
#define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1130
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__data2))
#line 1130
  #line 1127 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1130 "filter/f-inst.c"
#undef item
#line 1130
  dest->items[pos].fi_code = what->fi_code;
#line 1130
  dest->items[pos].flags = what->flags;
#line 1130
  dest->items[pos].lineno = what->lineno;
#line 1130
  break;
#line 1130
}
#line 1130

#line 1133 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__min */
#line 1133
case FI_METHOD__T_CLIST__min: {
#line 1133
#define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1133
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__min))
#line 1133
  #line 1130 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1133 "filter/f-inst.c"
#undef item
#line 1133
  dest->items[pos].fi_code = what->fi_code;
#line 1133
  dest->items[pos].flags = what->flags;
#line 1133
  dest->items[pos].lineno = what->lineno;
#line 1133
  break;
#line 1133
}
#line 1133

#line 1136 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__max */
#line 1136
case FI_METHOD__T_CLIST__max: {
#line 1136
#define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1136
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__max))
#line 1136
  #line 1133 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1136 "filter/f-inst.c"
#undef item
#line 1136
  dest->items[pos].fi_code = what->fi_code;
#line 1136
  dest->items[pos].flags = what->flags;
#line 1136
  dest->items[pos].lineno = what->lineno;
#line 1136
  break;
#line 1136
}
#line 1136

#line 1139 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__min */
#line 1139
case FI_METHOD__T_ECLIST__min: {
#line 1139
#define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1139
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__min))
#line 1139
  #line 1136 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1139 "filter/f-inst.c"
#undef item
#line 1139
  dest->items[pos].fi_code = what->fi_code;
#line 1139
  dest->items[pos].flags = what->flags;
#line 1139
  dest->items[pos].lineno = what->lineno;
#line 1139
  break;
#line 1139
}
#line 1139

#line 1142 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__max */
#line 1142
case FI_METHOD__T_ECLIST__max: {
#line 1142
#define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1142
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__max))
#line 1142
  #line 1139 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1142 "filter/f-inst.c"
#undef item
#line 1142
  dest->items[pos].fi_code = what->fi_code;
#line 1142
  dest->items[pos].flags = what->flags;
#line 1142
  dest->items[pos].lineno = what->lineno;
#line 1142
  break;
#line 1142
}
#line 1142

#line 1145 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__min */
#line 1145
case FI_METHOD__T_LCLIST__min: {
#line 1145
#define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1145
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__min))
#line 1145
  #line 1142 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1145 "filter/f-inst.c"
#undef item
#line 1145
  dest->items[pos].fi_code = what->fi_code;
#line 1145
  dest->items[pos].flags = what->flags;
#line 1145
  dest->items[pos].lineno = what->lineno;
#line 1145
  break;
#line 1145
}
#line 1145

#line 1147 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__max */
#line 1147
case FI_METHOD__T_LCLIST__max: {
#line 1147
#define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1147
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__max))
#line 1147
  #line 1145 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1147 "filter/f-inst.c"
#undef item
#line 1147
  dest->items[pos].fi_code = what->fi_code;
#line 1147
  dest->items[pos].flags = what->flags;
#line 1147
  dest->items[pos].lineno = what->lineno;
#line 1147
  break;
#line 1147
}
#line 1147

#line 1173 "filter/f-inst.c"
 /* Linearize for FI_RETURN */
#line 1173
case FI_RETURN: {
#line 1173
#define whati (&(what->i_FI_RETURN))
#line 1173
#define item (&(dest->items[pos].i_FI_RETURN))
#line 1173
  #line 1150 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1173 "filter/f-inst.c"
#undef item
#line 1173
  dest->items[pos].fi_code = what->fi_code;
#line 1173
  dest->items[pos].flags = what->flags;
#line 1173
  dest->items[pos].lineno = what->lineno;
#line 1173
  break;
#line 1173
}
#line 1173

#line 1233 "filter/f-inst.c"
 /* Linearize for FI_CALL */
#line 1233
case FI_CALL: {
#line 1233
#define whati (&(what->i_FI_CALL))
#line 1233
#define item (&(dest->items[pos].i_FI_CALL))
#line 1233
  #line 1175 "filter/f-inst.c"
  pos = linearize(dest, whati->fvar, pos);
#line 1175
  item->varcount = whati->varcount;
#line 1176 "filter/f-inst.c"
item->sym = whati->sym;
#line 1176

#undef whati
#line 1233 "filter/f-inst.c"
#undef item
#line 1233
  dest->items[pos].fi_code = what->fi_code;
#line 1233
  dest->items[pos].flags = what->flags;
#line 1233
  dest->items[pos].lineno = what->lineno;
#line 1233
  break;
#line 1233
}
#line 1233

#line 1238 "filter/f-inst.c"
 /* Linearize for FI_DROP_RESULT */
#line 1238
case FI_DROP_RESULT: {
#line 1238
#define whati (&(what->i_FI_DROP_RESULT))
#line 1238
#define item (&(dest->items[pos].i_FI_DROP_RESULT))
#line 1238
  #line 1235 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1238 "filter/f-inst.c"
#undef item
#line 1238
  dest->items[pos].fi_code = what->fi_code;
#line 1238
  dest->items[pos].flags = what->flags;
#line 1238
  dest->items[pos].lineno = what->lineno;
#line 1238
  break;
#line 1238
}
#line 1238

#line 1282 "filter/f-inst.c"
 /* Linearize for FI_SWITCH */
#line 1282
case FI_SWITCH: {
#line 1282
#define whati (&(what->i_FI_SWITCH))
#line 1282
#define item (&(dest->items[pos].i_FI_SWITCH))
#line 1282
  #line 1239 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1241 "filter/f-inst.c"
item->tree = whati->tree;
#line 1241


#line 1244 "filter/f-inst.c"
    /* Linearize all branches in switch */
    struct f_inst *last_inst = NULL;
    struct f_line *last_line = NULL;
    for (struct f_tree *t = whati->tree; t; t = t->left)
    {
      if (t->data != last_inst)
      {
	last_inst = t->data;
	last_line = f_linearize(t->data, 0);
      }

      t->data = last_line;
    }

    /* Balance the tree */
    item->tree = build_tree(whati->tree, false);

    if (whati->tree && !item->tree)
      cf_error("Overlaping intervals in switch cases not allowed");

    #undef whati
#line 1282 "filter/f-inst.c"
#undef item
#line 1282
  dest->items[pos].fi_code = what->fi_code;
#line 1282
  dest->items[pos].flags = what->flags;
#line 1282
  dest->items[pos].lineno = what->lineno;
#line 1282
  break;
#line 1282
}
#line 1282

#line 1291 "filter/f-inst.c"
 /* Linearize for FI_IP_MASK */
#line 1291
case FI_IP_MASK: {
#line 1291
#define whati (&(what->i_FI_IP_MASK))
#line 1291
#define item (&(dest->items[pos].i_FI_IP_MASK))
#line 1291
  #line 1283 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1284 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1291 "filter/f-inst.c"
#undef item
#line 1291
  dest->items[pos].fi_code = what->fi_code;
#line 1291
  dest->items[pos].flags = what->flags;
#line 1291
  dest->items[pos].lineno = what->lineno;
#line 1291
  break;
#line 1291
}
#line 1291

#line 1299 "filter/f-inst.c"
 /* Linearize for FI_PATH_PREPEND */
#line 1299
case FI_PATH_PREPEND: {
#line 1299
#define whati (&(what->i_FI_PATH_PREPEND))
#line 1299
#define item (&(dest->items[pos].i_FI_PATH_PREPEND))
#line 1299
  #line 1292 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1293 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1299 "filter/f-inst.c"
#undef item
#line 1299
  dest->items[pos].fi_code = what->fi_code;
#line 1299
  dest->items[pos].flags = what->flags;
#line 1299
  dest->items[pos].lineno = what->lineno;
#line 1299
  break;
#line 1299
}
#line 1299

#line 1307 "filter/f-inst.c"
 /* Linearize for FI_STRING_APPEND */
#line 1307
case FI_STRING_APPEND: {
#line 1307
#define whati (&(what->i_FI_STRING_APPEND))
#line 1307
#define item (&(dest->items[pos].i_FI_STRING_APPEND))
#line 1307
  #line 1300 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1301 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1307 "filter/f-inst.c"
#undef item
#line 1307
  dest->items[pos].fi_code = what->fi_code;
#line 1307
  dest->items[pos].flags = what->flags;
#line 1307
  dest->items[pos].lineno = what->lineno;
#line 1307
  break;
#line 1307
}
#line 1307

#line 1315 "filter/f-inst.c"
 /* Linearize for FI_BYTESTRING_APPEND */
#line 1315
case FI_BYTESTRING_APPEND: {
#line 1315
#define whati (&(what->i_FI_BYTESTRING_APPEND))
#line 1315
#define item (&(dest->items[pos].i_FI_BYTESTRING_APPEND))
#line 1315
  #line 1308 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1309 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1315 "filter/f-inst.c"
#undef item
#line 1315
  dest->items[pos].fi_code = what->fi_code;
#line 1315
  dest->items[pos].flags = what->flags;
#line 1315
  dest->items[pos].lineno = what->lineno;
#line 1315
  break;
#line 1315
}
#line 1315

#line 1322 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_PAIR */
#line 1322
case FI_CLIST_ADD_PAIR: {
#line 1322
#define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1322
#define item (&(dest->items[pos].i_FI_CLIST_ADD_PAIR))
#line 1322
  #line 1316 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1317 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1322 "filter/f-inst.c"
#undef item
#line 1322
  dest->items[pos].fi_code = what->fi_code;
#line 1322
  dest->items[pos].flags = what->flags;
#line 1322
  dest->items[pos].lineno = what->lineno;
#line 1322
  break;
#line 1322
}
#line 1322

#line 1336 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_IP */
#line 1336
case FI_CLIST_ADD_IP: {
#line 1336
#define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1336
#define item (&(dest->items[pos].i_FI_CLIST_ADD_IP))
#line 1336
  #line 1323 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1324 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1336 "filter/f-inst.c"
#undef item
#line 1336
  dest->items[pos].fi_code = what->fi_code;
#line 1336
  dest->items[pos].flags = what->flags;
#line 1336
  dest->items[pos].lineno = what->lineno;
#line 1336
  break;
#line 1336
}
#line 1336

#line 1343 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_QUAD */
#line 1343
case FI_CLIST_ADD_QUAD: {
#line 1343
#define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1343
#define item (&(dest->items[pos].i_FI_CLIST_ADD_QUAD))
#line 1343
  #line 1337 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1338 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1343 "filter/f-inst.c"
#undef item
#line 1343
  dest->items[pos].fi_code = what->fi_code;
#line 1343
  dest->items[pos].flags = what->flags;
#line 1343
  dest->items[pos].lineno = what->lineno;
#line 1343
  break;
#line 1343
}
#line 1343

#line 1350 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_CLIST */
#line 1350
case FI_CLIST_ADD_CLIST: {
#line 1350
#define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1350
#define item (&(dest->items[pos].i_FI_CLIST_ADD_CLIST))
#line 1350
  #line 1344 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1345 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1350 "filter/f-inst.c"
#undef item
#line 1350
  dest->items[pos].fi_code = what->fi_code;
#line 1350
  dest->items[pos].flags = what->flags;
#line 1350
  dest->items[pos].lineno = what->lineno;
#line 1350
  break;
#line 1350
}
#line 1350

#line 1357 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_ADD_EC */
#line 1357
case FI_ECLIST_ADD_EC: {
#line 1357
#define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1357
#define item (&(dest->items[pos].i_FI_ECLIST_ADD_EC))
#line 1357
  #line 1351 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1352 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1357 "filter/f-inst.c"
#undef item
#line 1357
  dest->items[pos].fi_code = what->fi_code;
#line 1357
  dest->items[pos].flags = what->flags;
#line 1357
  dest->items[pos].lineno = what->lineno;
#line 1357
  break;
#line 1357
}
#line 1357

#line 1364 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_ADD_ECLIST */
#line 1364
case FI_ECLIST_ADD_ECLIST: {
#line 1364
#define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1364
#define item (&(dest->items[pos].i_FI_ECLIST_ADD_ECLIST))
#line 1364
  #line 1358 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1359 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1364 "filter/f-inst.c"
#undef item
#line 1364
  dest->items[pos].fi_code = what->fi_code;
#line 1364
  dest->items[pos].flags = what->flags;
#line 1364
  dest->items[pos].lineno = what->lineno;
#line 1364
  break;
#line 1364
}
#line 1364

#line 1371 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_ADD_LC */
#line 1371
case FI_LCLIST_ADD_LC: {
#line 1371
#define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1371
#define item (&(dest->items[pos].i_FI_LCLIST_ADD_LC))
#line 1371
  #line 1365 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1366 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1371 "filter/f-inst.c"
#undef item
#line 1371
  dest->items[pos].fi_code = what->fi_code;
#line 1371
  dest->items[pos].flags = what->flags;
#line 1371
  dest->items[pos].lineno = what->lineno;
#line 1371
  break;
#line 1371
}
#line 1371

#line 1378 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_ADD_LCLIST */
#line 1378
case FI_LCLIST_ADD_LCLIST: {
#line 1378
#define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1378
#define item (&(dest->items[pos].i_FI_LCLIST_ADD_LCLIST))
#line 1378
  #line 1372 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1373 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1378 "filter/f-inst.c"
#undef item
#line 1378
  dest->items[pos].fi_code = what->fi_code;
#line 1378
  dest->items[pos].flags = what->flags;
#line 1378
  dest->items[pos].lineno = what->lineno;
#line 1378
  break;
#line 1378
}
#line 1378

#line 1385 "filter/f-inst.c"
 /* Linearize for FI_PATH_DELETE_INT */
#line 1385
case FI_PATH_DELETE_INT: {
#line 1385
#define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1385
#define item (&(dest->items[pos].i_FI_PATH_DELETE_INT))
#line 1385
  #line 1379 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1380 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1385 "filter/f-inst.c"
#undef item
#line 1385
  dest->items[pos].fi_code = what->fi_code;
#line 1385
  dest->items[pos].flags = what->flags;
#line 1385
  dest->items[pos].lineno = what->lineno;
#line 1385
  break;
#line 1385
}
#line 1385

#line 1397 "filter/f-inst.c"
 /* Linearize for FI_PATH_DELETE_SET */
#line 1397
case FI_PATH_DELETE_SET: {
#line 1397
#define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1397
#define item (&(dest->items[pos].i_FI_PATH_DELETE_SET))
#line 1397
  #line 1386 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1387 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1397 "filter/f-inst.c"
#undef item
#line 1397
  dest->items[pos].fi_code = what->fi_code;
#line 1397
  dest->items[pos].flags = what->flags;
#line 1397
  dest->items[pos].lineno = what->lineno;
#line 1397
  break;
#line 1397
}
#line 1397

#line 1404 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_PAIR */
#line 1404
case FI_CLIST_DELETE_PAIR: {
#line 1404
#define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1404
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_PAIR))
#line 1404
  #line 1398 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1399 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1404 "filter/f-inst.c"
#undef item
#line 1404
  dest->items[pos].fi_code = what->fi_code;
#line 1404
  dest->items[pos].flags = what->flags;
#line 1404
  dest->items[pos].lineno = what->lineno;
#line 1404
  break;
#line 1404
}
#line 1404

#line 1418 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_IP */
#line 1418
case FI_CLIST_DELETE_IP: {
#line 1418
#define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1418
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_IP))
#line 1418
  #line 1405 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1406 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1418 "filter/f-inst.c"
#undef item
#line 1418
  dest->items[pos].fi_code = what->fi_code;
#line 1418
  dest->items[pos].flags = what->flags;
#line 1418
  dest->items[pos].lineno = what->lineno;
#line 1418
  break;
#line 1418
}
#line 1418

#line 1425 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_QUAD */
#line 1425
case FI_CLIST_DELETE_QUAD: {
#line 1425
#define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1425
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_QUAD))
#line 1425
  #line 1419 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1420 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1425 "filter/f-inst.c"
#undef item
#line 1425
  dest->items[pos].fi_code = what->fi_code;
#line 1425
  dest->items[pos].flags = what->flags;
#line 1425
  dest->items[pos].lineno = what->lineno;
#line 1425
  break;
#line 1425
}
#line 1425

#line 1432 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_CLIST */
#line 1432
case FI_CLIST_DELETE_CLIST: {
#line 1432
#define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1432
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_CLIST))
#line 1432
  #line 1426 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1427 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1432 "filter/f-inst.c"
#undef item
#line 1432
  dest->items[pos].fi_code = what->fi_code;
#line 1432
  dest->items[pos].flags = what->flags;
#line 1432
  dest->items[pos].lineno = what->lineno;
#line 1432
  break;
#line 1432
}
#line 1432

#line 1443 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_SET */
#line 1443
case FI_CLIST_DELETE_SET: {
#line 1443
#define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1443
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_SET))
#line 1443
  #line 1433 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1434 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1443 "filter/f-inst.c"
#undef item
#line 1443
  dest->items[pos].fi_code = what->fi_code;
#line 1443
  dest->items[pos].flags = what->flags;
#line 1443
  dest->items[pos].lineno = what->lineno;
#line 1443
  break;
#line 1443
}
#line 1443

#line 1450 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_EC */
#line 1450
case FI_ECLIST_DELETE_EC: {
#line 1450
#define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1450
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_EC))
#line 1450
  #line 1444 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1445 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1450 "filter/f-inst.c"
#undef item
#line 1450
  dest->items[pos].fi_code = what->fi_code;
#line 1450
  dest->items[pos].flags = what->flags;
#line 1450
  dest->items[pos].lineno = what->lineno;
#line 1450
  break;
#line 1450
}
#line 1450

#line 1457 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_ECLIST */
#line 1457
case FI_ECLIST_DELETE_ECLIST: {
#line 1457
#define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1457
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_ECLIST))
#line 1457
  #line 1451 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1452 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1457 "filter/f-inst.c"
#undef item
#line 1457
  dest->items[pos].fi_code = what->fi_code;
#line 1457
  dest->items[pos].flags = what->flags;
#line 1457
  dest->items[pos].lineno = what->lineno;
#line 1457
  break;
#line 1457
}
#line 1457

#line 1468 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_SET */
#line 1468
case FI_ECLIST_DELETE_SET: {
#line 1468
#define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1468
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_SET))
#line 1468
  #line 1458 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1459 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1468 "filter/f-inst.c"
#undef item
#line 1468
  dest->items[pos].fi_code = what->fi_code;
#line 1468
  dest->items[pos].flags = what->flags;
#line 1468
  dest->items[pos].lineno = what->lineno;
#line 1468
  break;
#line 1468
}
#line 1468

#line 1475 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_LC */
#line 1475
case FI_LCLIST_DELETE_LC: {
#line 1475
#define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1475
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_LC))
#line 1475
  #line 1469 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1470 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1475 "filter/f-inst.c"
#undef item
#line 1475
  dest->items[pos].fi_code = what->fi_code;
#line 1475
  dest->items[pos].flags = what->flags;
#line 1475
  dest->items[pos].lineno = what->lineno;
#line 1475
  break;
#line 1475
}
#line 1475

#line 1482 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_LCLIST */
#line 1482
case FI_LCLIST_DELETE_LCLIST: {
#line 1482
#define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1482
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_LCLIST))
#line 1482
  #line 1476 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1477 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1482 "filter/f-inst.c"
#undef item
#line 1482
  dest->items[pos].fi_code = what->fi_code;
#line 1482
  dest->items[pos].flags = what->flags;
#line 1482
  dest->items[pos].lineno = what->lineno;
#line 1482
  break;
#line 1482
}
#line 1482

#line 1493 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_SET */
#line 1493
case FI_LCLIST_DELETE_SET: {
#line 1493
#define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1493
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_SET))
#line 1493
  #line 1483 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1484 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1493 "filter/f-inst.c"
#undef item
#line 1493
  dest->items[pos].fi_code = what->fi_code;
#line 1493
  dest->items[pos].flags = what->flags;
#line 1493
  dest->items[pos].lineno = what->lineno;
#line 1493
  break;
#line 1493
}
#line 1493

#line 1504 "filter/f-inst.c"
 /* Linearize for FI_PATH_FILTER_SET */
#line 1504
case FI_PATH_FILTER_SET: {
#line 1504
#define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1504
#define item (&(dest->items[pos].i_FI_PATH_FILTER_SET))
#line 1504
  #line 1494 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1495 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1504 "filter/f-inst.c"
#undef item
#line 1504
  dest->items[pos].fi_code = what->fi_code;
#line 1504
  dest->items[pos].flags = what->flags;
#line 1504
  dest->items[pos].lineno = what->lineno;
#line 1504
  break;
#line 1504
}
#line 1504

#line 1511 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FILTER_CLIST */
#line 1511
case FI_CLIST_FILTER_CLIST: {
#line 1511
#define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1511
#define item (&(dest->items[pos].i_FI_CLIST_FILTER_CLIST))
#line 1511
  #line 1505 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1506 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1511 "filter/f-inst.c"
#undef item
#line 1511
  dest->items[pos].fi_code = what->fi_code;
#line 1511
  dest->items[pos].flags = what->flags;
#line 1511
  dest->items[pos].lineno = what->lineno;
#line 1511
  break;
#line 1511
}
#line 1511

#line 1522 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FILTER_SET */
#line 1522
case FI_CLIST_FILTER_SET: {
#line 1522
#define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1522
#define item (&(dest->items[pos].i_FI_CLIST_FILTER_SET))
#line 1522
  #line 1512 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1513 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1522 "filter/f-inst.c"
#undef item
#line 1522
  dest->items[pos].fi_code = what->fi_code;
#line 1522
  dest->items[pos].flags = what->flags;
#line 1522
  dest->items[pos].lineno = what->lineno;
#line 1522
  break;
#line 1522
}
#line 1522

#line 1529 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FILTER_ECLIST */
#line 1529
case FI_ECLIST_FILTER_ECLIST: {
#line 1529
#define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1529
#define item (&(dest->items[pos].i_FI_ECLIST_FILTER_ECLIST))
#line 1529
  #line 1523 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1524 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1529 "filter/f-inst.c"
#undef item
#line 1529
  dest->items[pos].fi_code = what->fi_code;
#line 1529
  dest->items[pos].flags = what->flags;
#line 1529
  dest->items[pos].lineno = what->lineno;
#line 1529
  break;
#line 1529
}
#line 1529

#line 1540 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FILTER_SET */
#line 1540
case FI_ECLIST_FILTER_SET: {
#line 1540
#define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1540
#define item (&(dest->items[pos].i_FI_ECLIST_FILTER_SET))
#line 1540
  #line 1530 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1531 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1540 "filter/f-inst.c"
#undef item
#line 1540
  dest->items[pos].fi_code = what->fi_code;
#line 1540
  dest->items[pos].flags = what->flags;
#line 1540
  dest->items[pos].lineno = what->lineno;
#line 1540
  break;
#line 1540
}
#line 1540

#line 1547 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FILTER_LCLIST */
#line 1547
case FI_LCLIST_FILTER_LCLIST: {
#line 1547
#define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1547
#define item (&(dest->items[pos].i_FI_LCLIST_FILTER_LCLIST))
#line 1547
  #line 1541 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1542 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1547 "filter/f-inst.c"
#undef item
#line 1547
  dest->items[pos].fi_code = what->fi_code;
#line 1547
  dest->items[pos].flags = what->flags;
#line 1547
  dest->items[pos].lineno = what->lineno;
#line 1547
  break;
#line 1547
}
#line 1547

#line 1558 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FILTER_SET */
#line 1558
case FI_LCLIST_FILTER_SET: {
#line 1558
#define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1558
#define item (&(dest->items[pos].i_FI_LCLIST_FILTER_SET))
#line 1558
  #line 1548 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1549 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1558 "filter/f-inst.c"
#undef item
#line 1558
  dest->items[pos].fi_code = what->fi_code;
#line 1558
  dest->items[pos].flags = what->flags;
#line 1558
  dest->items[pos].lineno = what->lineno;
#line 1558
  break;
#line 1558
}
#line 1558

#line 1580 "filter/f-inst.c"
 /* Linearize for FI_ROA_CHECK */
#line 1580
case FI_ROA_CHECK: {
#line 1580
#define whati (&(what->i_FI_ROA_CHECK))
#line 1580
#define item (&(dest->items[pos].i_FI_ROA_CHECK))
#line 1580
  #line 1560 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1561 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 1562 "filter/f-inst.c"
item->rtc = whati->rtc;
#line 1562

#undef whati
#line 1580 "filter/f-inst.c"
#undef item
#line 1580
  dest->items[pos].fi_code = what->fi_code;
#line 1580
  dest->items[pos].flags = what->flags;
#line 1580
  dest->items[pos].lineno = what->lineno;
#line 1580
  break;
#line 1580
}
#line 1580

#line 1596 "filter/f-inst.c"
 /* Linearize for FI_ASPA_CHECK_EXPLICIT */
#line 1596
case FI_ASPA_CHECK_EXPLICIT: {
#line 1596
#define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1596
#define item (&(dest->items[pos].i_FI_ASPA_CHECK_EXPLICIT))
#line 1596
  #line 1582 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1583 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 1584 "filter/f-inst.c"
item->rtc = whati->rtc;
#line 1584

#undef whati
#line 1596 "filter/f-inst.c"
#undef item
#line 1596
  dest->items[pos].fi_code = what->fi_code;
#line 1596
  dest->items[pos].flags = what->flags;
#line 1596
  dest->items[pos].lineno = what->lineno;
#line 1596
  break;
#line 1596
}
#line 1596

#line 1611 "filter/f-inst.c"
 /* Linearize for FI_FROM_HEX */
#line 1611
case FI_FROM_HEX: {
#line 1611
#define whati (&(what->i_FI_FROM_HEX))
#line 1611
#define item (&(dest->items[pos].i_FI_FROM_HEX))
#line 1611
  #line 1597 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1611 "filter/f-inst.c"
#undef item
#line 1611
  dest->items[pos].fi_code = what->fi_code;
#line 1611
  dest->items[pos].flags = what->flags;
#line 1611
  dest->items[pos].lineno = what->lineno;
#line 1611
  break;
#line 1611
}
#line 1611

#line 1616 "filter/f-inst.c"
 /* Linearize for FI_FORMAT */
#line 1616
case FI_FORMAT: {
#line 1616
#define whati (&(what->i_FI_FORMAT))
#line 1616
#define item (&(dest->items[pos].i_FI_FORMAT))
#line 1616
  #line 1612 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1616 "filter/f-inst.c"
#undef item
#line 1616
  dest->items[pos].fi_code = what->fi_code;
#line 1616
  dest->items[pos].flags = what->flags;
#line 1616
  dest->items[pos].lineno = what->lineno;
#line 1616
  break;
#line 1616
}
#line 1616

#line 830 "filter/decl.m4"
 /* Linearize for FI_ASSERT */
#line 830
case FI_ASSERT: {
#line 830
#define whati (&(what->i_FI_ASSERT))
#line 830
#define item (&(dest->items[pos].i_FI_ASSERT))
#line 830
  #line 1618 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1620 "filter/f-inst.c"
item->s = whati->s;
#line 1620

#undef whati
#line 830 "filter/decl.m4"
#undef item
#line 830
  dest->items[pos].fi_code = what->fi_code;
#line 830
  dest->items[pos].flags = what->flags;
#line 830
  dest->items[pos].lineno = what->lineno;
#line 830
  break;
#line 830
}
#line 830

#line 708 "filter/decl.m4"

    }
    pos++;
  }
  return pos;
}

struct f_line *
f_linearize_concat(const struct f_inst * const inst[], uint count, uint results)
{
  uint len = 0;
  for (uint i=0; i<count; i++)
    for (const struct f_inst *what = inst[i]; what; what = what->next)
      len += what->size;

  struct f_line *out = cfg_allocz(sizeof(struct f_line) + sizeof(struct f_line_item)*len);

  for (uint i=0; i<count; i++)
    out->len = linearize(out, inst[i], out->len);

  out->results = results;
  return out;
}

/* Filter line comparison */
int
f_same(const struct f_line *fl1, const struct f_line *fl2)
{
  if ((!fl1) && (!fl2))
    return 1;
  if ((!fl1) || (!fl2))
    return 0;
  if (fl1->len != fl2->len)
    return 0;
  for (uint i=0; i<fl1->len; i++) {
#define f1_ (&(fl1->items[i]))
#define f2_ (&(fl2->items[i]))
    if (f1_->fi_code != f2_->fi_code)
      return 0;
    if (f1_->flags != f2_->flags)
      return 0;

    switch(f1_->fi_code) {
#line 288 "filter/f-inst.c"
 /* Comparison for FI_ADD */
#line 288
case FI_ADD:
#line 288
#define f1 (&(f1_->i_FI_ADD))
#line 288
#define f2 (&(f2_->i_FI_ADD))
#line 288
#undef f1
#line 288
#undef f2
#line 288
break;
#line 288

#line 293 "filter/f-inst.c"
 /* Comparison for FI_SUBTRACT */
#line 293
case FI_SUBTRACT:
#line 293
#define f1 (&(f1_->i_FI_SUBTRACT))
#line 293
#define f2 (&(f2_->i_FI_SUBTRACT))
#line 293
#undef f1
#line 293
#undef f2
#line 293
break;
#line 293

#line 298 "filter/f-inst.c"
 /* Comparison for FI_MULTIPLY */
#line 298
case FI_MULTIPLY:
#line 298
#define f1 (&(f1_->i_FI_MULTIPLY))
#line 298
#define f2 (&(f2_->i_FI_MULTIPLY))
#line 298
#undef f1
#line 298
#undef f2
#line 298
break;
#line 298

#line 304 "filter/f-inst.c"
 /* Comparison for FI_DIVIDE */
#line 304
case FI_DIVIDE:
#line 304
#define f1 (&(f1_->i_FI_DIVIDE))
#line 304
#define f2 (&(f2_->i_FI_DIVIDE))
#line 304
#undef f1
#line 304
#undef f2
#line 304
break;
#line 304

#line 309 "filter/f-inst.c"
 /* Comparison for FI_BITOR */
#line 309
case FI_BITOR:
#line 309
#define f1 (&(f1_->i_FI_BITOR))
#line 309
#define f2 (&(f2_->i_FI_BITOR))
#line 309
#undef f1
#line 309
#undef f2
#line 309
break;
#line 309

#line 314 "filter/f-inst.c"
 /* Comparison for FI_BITAND */
#line 314
case FI_BITAND:
#line 314
#define f1 (&(f1_->i_FI_BITAND))
#line 314
#define f2 (&(f2_->i_FI_BITAND))
#line 314
#undef f1
#line 314
#undef f2
#line 314
break;
#line 314

#line 324 "filter/f-inst.c"
 /* Comparison for FI_AND */
#line 324
case FI_AND:
#line 324
#define f1 (&(f1_->i_FI_AND))
#line 324
#define f2 (&(f2_->i_FI_AND))
#line 320 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 324 "filter/f-inst.c"
#undef f1
#line 324
#undef f2
#line 324
break;
#line 324

#line 335 "filter/f-inst.c"
 /* Comparison for FI_OR */
#line 335
case FI_OR:
#line 335
#define f1 (&(f1_->i_FI_OR))
#line 335
#define f2 (&(f2_->i_FI_OR))
#line 330 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 335 "filter/f-inst.c"
#undef f1
#line 335
#undef f2
#line 335
break;
#line 335

#line 345 "filter/f-inst.c"
 /* Comparison for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT:
#line 345
#define f1 (&(f1_->i_FI_PAIR_CONSTRUCT))
#line 345
#define f2 (&(f2_->i_FI_PAIR_CONSTRUCT))
#line 345
#undef f1
#line 345
#undef f2
#line 345
break;
#line 345

#line 385 "filter/f-inst.c"
 /* Comparison for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT:
#line 385
#define f1 (&(f1_->i_FI_EC_CONSTRUCT))
#line 385
#define f2 (&(f2_->i_FI_EC_CONSTRUCT))
#line 349 "filter/f-inst.c"
if (f1->ecs != f2->ecs) return 0;
#line 349

#line 349

#line 385 "filter/f-inst.c"
#undef f1
#line 385
#undef f2
#line 385
break;
#line 385

#line 392 "filter/f-inst.c"
 /* Comparison for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT:
#line 392
#define f1 (&(f1_->i_FI_LC_CONSTRUCT))
#line 392
#define f2 (&(f2_->i_FI_LC_CONSTRUCT))
#line 392
#undef f1
#line 392
#undef f2
#line 392
break;
#line 392

#line 442 "filter/f-inst.c"
 /* Comparison for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT:
#line 442
#define f1 (&(f1_->i_FI_PATHMASK_CONSTRUCT))
#line 442
#define f2 (&(f2_->i_FI_PATHMASK_CONSTRUCT))
#line 393 "filter/f-inst.c"
  if (f1->varcount != f2->varcount) return 0;
#line 442 "filter/f-inst.c"
#undef f1
#line 442
#undef f2
#line 442
break;
#line 442

#line 449 "filter/f-inst.c"
 /* Comparison for FI_NEQ */
#line 449
case FI_NEQ:
#line 449
#define f1 (&(f1_->i_FI_NEQ))
#line 449
#define f2 (&(f2_->i_FI_NEQ))
#line 449
#undef f1
#line 449
#undef f2
#line 449
break;
#line 449

#line 456 "filter/f-inst.c"
 /* Comparison for FI_EQ */
#line 456
case FI_EQ:
#line 456
#define f1 (&(f1_->i_FI_EQ))
#line 456
#define f2 (&(f2_->i_FI_EQ))
#line 456
#undef f1
#line 456
#undef f2
#line 456
break;
#line 456

#line 467 "filter/f-inst.c"
 /* Comparison for FI_LT */
#line 467
case FI_LT:
#line 467
#define f1 (&(f1_->i_FI_LT))
#line 467
#define f2 (&(f2_->i_FI_LT))
#line 467
#undef f1
#line 467
#undef f2
#line 467
break;
#line 467

#line 478 "filter/f-inst.c"
 /* Comparison for FI_LTE */
#line 478
case FI_LTE:
#line 478
#define f1 (&(f1_->i_FI_LTE))
#line 478
#define f2 (&(f2_->i_FI_LTE))
#line 478
#undef f1
#line 478
#undef f2
#line 478
break;
#line 478

#line 483 "filter/f-inst.c"
 /* Comparison for FI_NOT */
#line 483
case FI_NOT:
#line 483
#define f1 (&(f1_->i_FI_NOT))
#line 483
#define f2 (&(f2_->i_FI_NOT))
#line 483
#undef f1
#line 483
#undef f2
#line 483
break;
#line 483

#line 492 "filter/f-inst.c"
 /* Comparison for FI_MATCH */
#line 492
case FI_MATCH:
#line 492
#define f1 (&(f1_->i_FI_MATCH))
#line 492
#define f2 (&(f2_->i_FI_MATCH))
#line 492
#undef f1
#line 492
#undef f2
#line 492
break;
#line 492

#line 501 "filter/f-inst.c"
 /* Comparison for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH:
#line 501
#define f1 (&(f1_->i_FI_NOT_MATCH))
#line 501
#define f2 (&(f2_->i_FI_NOT_MATCH))
#line 501
#undef f1
#line 501
#undef f2
#line 501
break;
#line 501

#line 506 "filter/f-inst.c"
 /* Comparison for FI_DEFINED */
#line 506
case FI_DEFINED:
#line 506
#define f1 (&(f1_->i_FI_DEFINED))
#line 506
#define f2 (&(f2_->i_FI_DEFINED))
#line 506
#undef f1
#line 506
#undef f2
#line 506
break;
#line 506

#line 507 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type:
#line 507
#define f1 (&(f1_->i_FI_METHOD__T_NET__type))
#line 507
#define f2 (&(f2_->i_FI_METHOD__T_NET__type))
#line 507
#undef f1
#line 507
#undef f2
#line 507
break;
#line 507

#line 510 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4:
#line 510
#define f1 (&(f1_->i_FI_METHOD__T_IP__is_v4))
#line 510
#define f2 (&(f2_->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef f1
#line 510
#undef f2
#line 510
break;
#line 510

#line 523 "filter/f-inst.c"
 /* Comparison for FI_VAR_INIT */
#line 523
case FI_VAR_INIT:
#line 523
#define f1 (&(f1_->i_FI_VAR_INIT))
#line 523
#define f2 (&(f2_->i_FI_VAR_INIT))
#line 513 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 513

#line 513

#line 523 "filter/f-inst.c"
#undef f1
#line 523
#undef f2
#line 523
break;
#line 523

#line 534 "filter/f-inst.c"
 /* Comparison for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0:
#line 534
#define f1 (&(f1_->i_FI_VAR_INIT0))
#line 534
#define f2 (&(f2_->i_FI_VAR_INIT0))
#line 525 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 525

#line 525

#line 534 "filter/f-inst.c"
#undef f1
#line 534
#undef f2
#line 534
break;
#line 534

#line 543 "filter/f-inst.c"
 /* Comparison for FI_VAR_SET */
#line 543
case FI_VAR_SET:
#line 543
#define f1 (&(f1_->i_FI_VAR_SET))
#line 543
#define f2 (&(f2_->i_FI_VAR_SET))
#line 537 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 537

#line 537

#line 543 "filter/f-inst.c"
#undef f1
#line 543
#undef f2
#line 543
break;
#line 543

#line 550 "filter/f-inst.c"
 /* Comparison for FI_VAR_GET */
#line 550
case FI_VAR_GET:
#line 550
#define f1 (&(f1_->i_FI_VAR_GET))
#line 550
#define f2 (&(f2_->i_FI_VAR_GET))
#line 544 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 544

#line 544

#line 550 "filter/f-inst.c"
#undef f1
#line 550
#undef f2
#line 550
break;
#line 550

#line 563 "filter/f-inst.c"
 /* Comparison for FI_CONSTANT */
#line 563
case FI_CONSTANT:
#line 563
#define f1 (&(f1_->i_FI_CONSTANT))
#line 563
#define f2 (&(f2_->i_FI_CONSTANT))
#line 551 "filter/f-inst.c"
if ( !val_same(&(f1->val), &(f2->val)) ) return 0;
#line 551

#line 551

#line 563 "filter/f-inst.c"
#undef f1
#line 563
#undef f2
#line 563
break;
#line 563

#line 564 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty:
#line 564
#define f1 (&(f1_->i_FI_METHOD__T_PATH__empty))
#line 564
#define f2 (&(f2_->i_FI_METHOD__T_PATH__empty))
#line 564
#undef f1
#line 564
#undef f2
#line 564
break;
#line 564

#line 565 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty:
#line 565
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__empty))
#line 565
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef f1
#line 565
#undef f2
#line 565
break;
#line 565

#line 566 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty:
#line 566
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef f1
#line 566
#undef f2
#line 566
break;
#line 566

#line 569 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty:
#line 569
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef f1
#line 569
#undef f2
#line 569
break;
#line 569

#line 591 "filter/f-inst.c"
 /* Comparison for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START:
#line 591
#define f1 (&(f1_->i_FI_FOR_LOOP_START))
#line 591
#define f2 (&(f2_->i_FI_FOR_LOOP_START))
#line 571 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 571

#line 571

#line 591 "filter/f-inst.c"
#undef f1
#line 591
#undef f2
#line 591
break;
#line 591

#line 600 "filter/f-inst.c"
 /* Comparison for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT:
#line 600
#define f1 (&(f1_->i_FI_PATH_FOR_NEXT))
#line 600
#define f2 (&(f2_->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 600 "filter/f-inst.c"
#undef f1
#line 600
#undef f2
#line 600
break;
#line 600

#line 609 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT:
#line 609
#define f1 (&(f1_->i_FI_CLIST_FOR_NEXT))
#line 609
#define f2 (&(f2_->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 609 "filter/f-inst.c"
#undef f1
#line 609
#undef f2
#line 609
break;
#line 609

#line 618 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT:
#line 618
#define f1 (&(f1_->i_FI_ECLIST_FOR_NEXT))
#line 618
#define f2 (&(f2_->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 618 "filter/f-inst.c"
#undef f1
#line 618
#undef f2
#line 618
break;
#line 618

#line 627 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT:
#line 627
#define f1 (&(f1_->i_FI_LCLIST_FOR_NEXT))
#line 627
#define f2 (&(f2_->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 627 "filter/f-inst.c"
#undef f1
#line 627
#undef f2
#line 627
break;
#line 627

#line 640 "filter/f-inst.c"
 /* Comparison for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT:
#line 640
#define f1 (&(f1_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
#define f2 (&(f2_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 640 "filter/f-inst.c"
#undef f1
#line 640
#undef f2
#line 640
break;
#line 640

#line 648 "filter/f-inst.c"
 /* Comparison for FI_CONDITION */
#line 648
case FI_CONDITION:
#line 648
#define f1 (&(f1_->i_FI_CONDITION))
#line 648
#define f2 (&(f2_->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 645 "filter/f-inst.c"
if (!f_same(f1->fl3, f2->fl3)) return 0;
#line 648 "filter/f-inst.c"
#undef f1
#line 648
#undef f2
#line 648
break;
#line 648

#line 661 "filter/f-inst.c"
 /* Comparison for FI_PRINT */
#line 661
case FI_PRINT:
#line 661
#define f1 (&(f1_->i_FI_PRINT))
#line 661
#define f2 (&(f2_->i_FI_PRINT))
#line 661
#undef f1
#line 661
#undef f2
#line 661
break;
#line 661

#line 668 "filter/f-inst.c"
 /* Comparison for FI_FLUSH */
#line 668
case FI_FLUSH:
#line 668
#define f1 (&(f1_->i_FI_FLUSH))
#line 668
#define f2 (&(f2_->i_FI_FLUSH))
#line 668
#undef f1
#line 668
#undef f2
#line 668
break;
#line 668

#line 682 "filter/f-inst.c"
 /* Comparison for FI_DIE */
#line 682
case FI_DIE:
#line 682
#define f1 (&(f1_->i_FI_DIE))
#line 682
#define f2 (&(f2_->i_FI_DIE))
#line 670 "filter/f-inst.c"
if (f1->fret != f2->fret) return 0;
#line 670

#line 670

#line 682 "filter/f-inst.c"
#undef f1
#line 682
#undef f2
#line 682
break;
#line 682

#line 689 "filter/f-inst.c"
 /* Comparison for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE:
#line 689
#define f1 (&(f1_->i_FI_CURRENT_ROUTE))
#line 689
#define f2 (&(f2_->i_FI_CURRENT_ROUTE))
#line 689
#undef f1
#line 689
#undef f2
#line 689
break;
#line 689

#line 740 "filter/f-inst.c"
 /* Comparison for FI_RTA_GET */
#line 740
case FI_RTA_GET:
#line 740
#define f1 (&(f1_->i_FI_RTA_GET))
#line 740
#define f2 (&(f2_->i_FI_RTA_GET))
#line 692 "filter/f-inst.c"
if (f1->sa.sa_code != f2->sa.sa_code) return 0;
#line 692

#line 692

#line 740 "filter/f-inst.c"
#undef f1
#line 740
#undef f2
#line 740
break;
#line 740

#line 897 "filter/f-inst.c"
 /* Comparison for FI_RTA_SET */
#line 897
case FI_RTA_SET:
#line 897
#define f1 (&(f1_->i_FI_RTA_SET))
#line 897
#define f2 (&(f2_->i_FI_RTA_SET))
#line 743 "filter/f-inst.c"
if (f1->sa.sa_code != f2->sa.sa_code) return 0;
#line 743

#line 743

#line 897 "filter/f-inst.c"
#undef f1
#line 897
#undef f2
#line 897
break;
#line 897

#line 934 "filter/f-inst.c"
 /* Comparison for FI_EA_GET */
#line 934
case FI_EA_GET:
#line 934
#define f1 (&(f1_->i_FI_EA_GET))
#line 934
#define f2 (&(f2_->i_FI_EA_GET))
#line 899 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 899

#line 899

#line 934 "filter/f-inst.c"
#undef f1
#line 934
#undef f2
#line 934
break;
#line 934

#line 975 "filter/f-inst.c"
 /* Comparison for FI_EA_SET */
#line 975
case FI_EA_SET:
#line 975
#define f1 (&(f1_->i_FI_EA_SET))
#line 975
#define f2 (&(f2_->i_FI_EA_SET))
#line 937 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 937

#line 937

#line 975 "filter/f-inst.c"
#undef f1
#line 975
#undef f2
#line 975
break;
#line 975

#line 982 "filter/f-inst.c"
 /* Comparison for FI_EA_UNSET */
#line 982
case FI_EA_UNSET:
#line 982
#define f1 (&(f1_->i_FI_EA_UNSET))
#line 982
#define f2 (&(f2_->i_FI_EA_UNSET))
#line 976 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 976

#line 976

#line 982 "filter/f-inst.c"
#undef f1
#line 982
#undef f2
#line 982
break;
#line 982

#line 996 "filter/f-inst.c"
 /* Comparison for FI_DEFAULT */
#line 996
case FI_DEFAULT:
#line 996
#define f1 (&(f1_->i_FI_DEFAULT))
#line 996
#define f2 (&(f2_->i_FI_DEFAULT))
#line 996
#undef f1
#line 996
#undef f2
#line 996
break;
#line 996

#line 997 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__len */
#line 997
case FI_METHOD__T_NET__len:
#line 997
#define f1 (&(f1_->i_FI_METHOD__T_NET__len))
#line 997
#define f2 (&(f2_->i_FI_METHOD__T_NET__len))
#line 997
#undef f1
#line 997
#undef f2
#line 997
break;
#line 997

#line 998 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__len */
#line 998
case FI_METHOD__T_PATH__len:
#line 998
#define f1 (&(f1_->i_FI_METHOD__T_PATH__len))
#line 998
#define f2 (&(f2_->i_FI_METHOD__T_PATH__len))
#line 998
#undef f1
#line 998
#undef f2
#line 998
break;
#line 998

#line 999 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__len */
#line 999
case FI_METHOD__T_CLIST__len:
#line 999
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__len))
#line 999
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__len))
#line 999
#undef f1
#line 999
#undef f2
#line 999
break;
#line 999

#line 1000 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__len */
#line 1000
case FI_METHOD__T_ECLIST__len:
#line 1000
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__len))
#line 1000
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__len))
#line 1000
#undef f1
#line 1000
#undef f2
#line 1000
break;
#line 1000

#line 1002 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__len */
#line 1002
case FI_METHOD__T_LCLIST__len:
#line 1002
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__len))
#line 1002
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__len))
#line 1002
#undef f1
#line 1002
#undef f2
#line 1002
break;
#line 1002

#line 1038 "filter/f-inst.c"
 /* Comparison for FI_NET_SRC */
#line 1038
case FI_NET_SRC:
#line 1038
#define f1 (&(f1_->i_FI_NET_SRC))
#line 1038
#define f2 (&(f2_->i_FI_NET_SRC))
#line 1038
#undef f1
#line 1038
#undef f2
#line 1038
break;
#line 1038

#line 1075 "filter/f-inst.c"
 /* Comparison for FI_NET_DST */
#line 1075
case FI_NET_DST:
#line 1075
#define f1 (&(f1_->i_FI_NET_DST))
#line 1075
#define f2 (&(f2_->i_FI_NET_DST))
#line 1075
#undef f1
#line 1075
#undef f2
#line 1075
break;
#line 1075

#line 1085 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__maxlen */
#line 1085
case FI_METHOD__T_NET__maxlen:
#line 1085
#define f1 (&(f1_->i_FI_METHOD__T_NET__maxlen))
#line 1085
#define f2 (&(f2_->i_FI_METHOD__T_NET__maxlen))
#line 1085
#undef f1
#line 1085
#undef f2
#line 1085
break;
#line 1085

#line 1095 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__asn */
#line 1095
case FI_METHOD__T_NET__asn:
#line 1095
#define f1 (&(f1_->i_FI_METHOD__T_NET__asn))
#line 1095
#define f2 (&(f2_->i_FI_METHOD__T_NET__asn))
#line 1095
#undef f1
#line 1095
#undef f2
#line 1095
break;
#line 1095

#line 1097 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__ip */
#line 1097
case FI_METHOD__T_NET__ip:
#line 1097
#define f1 (&(f1_->i_FI_METHOD__T_NET__ip))
#line 1097
#define f2 (&(f2_->i_FI_METHOD__T_NET__ip))
#line 1097
#undef f1
#line 1097
#undef f2
#line 1097
break;
#line 1097

#line 1106 "filter/f-inst.c"
 /* Comparison for FI_ROUTE_DISTINGUISHER */
#line 1106
case FI_ROUTE_DISTINGUISHER:
#line 1106
#define f1 (&(f1_->i_FI_ROUTE_DISTINGUISHER))
#line 1106
#define f2 (&(f2_->i_FI_ROUTE_DISTINGUISHER))
#line 1106
#undef f1
#line 1106
#undef f2
#line 1106
break;
#line 1106

#line 1109 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__first */
#line 1109
case FI_METHOD__T_PATH__first:
#line 1109
#define f1 (&(f1_->i_FI_METHOD__T_PATH__first))
#line 1109
#define f2 (&(f2_->i_FI_METHOD__T_PATH__first))
#line 1109
#undef f1
#line 1109
#undef f2
#line 1109
break;
#line 1109

#line 1112 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__last */
#line 1112
case FI_METHOD__T_PATH__last:
#line 1112
#define f1 (&(f1_->i_FI_METHOD__T_PATH__last))
#line 1112
#define f2 (&(f2_->i_FI_METHOD__T_PATH__last))
#line 1112
#undef f1
#line 1112
#undef f2
#line 1112
break;
#line 1112

#line 1115 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
case FI_METHOD__T_PATH__last_nonaggregated:
#line 1115
#define f1 (&(f1_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
#define f2 (&(f2_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
#undef f1
#line 1115
#undef f2
#line 1115
break;
#line 1115

#line 1118 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PAIR__asn */
#line 1118
case FI_METHOD__T_PAIR__asn:
#line 1118
#define f1 (&(f1_->i_FI_METHOD__T_PAIR__asn))
#line 1118
#define f2 (&(f2_->i_FI_METHOD__T_PAIR__asn))
#line 1118
#undef f1
#line 1118
#undef f2
#line 1118
break;
#line 1118

#line 1121 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PAIR__data */
#line 1121
case FI_METHOD__T_PAIR__data:
#line 1121
#define f1 (&(f1_->i_FI_METHOD__T_PAIR__data))
#line 1121
#define f2 (&(f2_->i_FI_METHOD__T_PAIR__data))
#line 1121
#undef f1
#line 1121
#undef f2
#line 1121
break;
#line 1121

#line 1124 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__asn */
#line 1124
case FI_METHOD__T_LC__asn:
#line 1124
#define f1 (&(f1_->i_FI_METHOD__T_LC__asn))
#line 1124
#define f2 (&(f2_->i_FI_METHOD__T_LC__asn))
#line 1124
#undef f1
#line 1124
#undef f2
#line 1124
break;
#line 1124

#line 1127 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__data1 */
#line 1127
case FI_METHOD__T_LC__data1:
#line 1127
#define f1 (&(f1_->i_FI_METHOD__T_LC__data1))
#line 1127
#define f2 (&(f2_->i_FI_METHOD__T_LC__data1))
#line 1127
#undef f1
#line 1127
#undef f2
#line 1127
break;
#line 1127

#line 1130 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__data2 */
#line 1130
case FI_METHOD__T_LC__data2:
#line 1130
#define f1 (&(f1_->i_FI_METHOD__T_LC__data2))
#line 1130
#define f2 (&(f2_->i_FI_METHOD__T_LC__data2))
#line 1130
#undef f1
#line 1130
#undef f2
#line 1130
break;
#line 1130

#line 1133 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__min */
#line 1133
case FI_METHOD__T_CLIST__min:
#line 1133
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__min))
#line 1133
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__min))
#line 1133
#undef f1
#line 1133
#undef f2
#line 1133
break;
#line 1133

#line 1136 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__max */
#line 1136
case FI_METHOD__T_CLIST__max:
#line 1136
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__max))
#line 1136
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__max))
#line 1136
#undef f1
#line 1136
#undef f2
#line 1136
break;
#line 1136

#line 1139 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__min */
#line 1139
case FI_METHOD__T_ECLIST__min:
#line 1139
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__min))
#line 1139
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__min))
#line 1139
#undef f1
#line 1139
#undef f2
#line 1139
break;
#line 1139

#line 1142 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__max */
#line 1142
case FI_METHOD__T_ECLIST__max:
#line 1142
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__max))
#line 1142
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__max))
#line 1142
#undef f1
#line 1142
#undef f2
#line 1142
break;
#line 1142

#line 1145 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__min */
#line 1145
case FI_METHOD__T_LCLIST__min:
#line 1145
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__min))
#line 1145
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__min))
#line 1145
#undef f1
#line 1145
#undef f2
#line 1145
break;
#line 1145

#line 1147 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__max */
#line 1147
case FI_METHOD__T_LCLIST__max:
#line 1147
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__max))
#line 1147
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__max))
#line 1147
#undef f1
#line 1147
#undef f2
#line 1147
break;
#line 1147

#line 1173 "filter/f-inst.c"
 /* Comparison for FI_RETURN */
#line 1173
case FI_RETURN:
#line 1173
#define f1 (&(f1_->i_FI_RETURN))
#line 1173
#define f2 (&(f2_->i_FI_RETURN))
#line 1173
#undef f1
#line 1173
#undef f2
#line 1173
break;
#line 1173

#line 1233 "filter/f-inst.c"
 /* Comparison for FI_CALL */
#line 1233
case FI_CALL:
#line 1233
#define f1 (&(f1_->i_FI_CALL))
#line 1233
#define f2 (&(f2_->i_FI_CALL))
#line 1175 "filter/f-inst.c"
  if (f1->varcount != f2->varcount) return 0;
#line 1176 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 1176

#line 1176


#line 1210 "filter/f-inst.c"
    if (!(f1->sym->flags & SYM_FLAG_SAME) && !(f1_->flags & FIF_RECURSIVE))
      return 0;

    #line 1233 "filter/f-inst.c"
#undef f1
#line 1233
#undef f2
#line 1233
break;
#line 1233

#line 1238 "filter/f-inst.c"
 /* Comparison for FI_DROP_RESULT */
#line 1238
case FI_DROP_RESULT:
#line 1238
#define f1 (&(f1_->i_FI_DROP_RESULT))
#line 1238
#define f2 (&(f2_->i_FI_DROP_RESULT))
#line 1238
#undef f1
#line 1238
#undef f2
#line 1238
break;
#line 1238

#line 1282 "filter/f-inst.c"
 /* Comparison for FI_SWITCH */
#line 1282
case FI_SWITCH:
#line 1282
#define f1 (&(f1_->i_FI_SWITCH))
#line 1282
#define f2 (&(f2_->i_FI_SWITCH))
#line 1241 "filter/f-inst.c"
if (!same_tree(f1->tree, f2->tree)) return 0;
#line 1241

#line 1241

#line 1282 "filter/f-inst.c"
#undef f1
#line 1282
#undef f2
#line 1282
break;
#line 1282

#line 1291 "filter/f-inst.c"
 /* Comparison for FI_IP_MASK */
#line 1291
case FI_IP_MASK:
#line 1291
#define f1 (&(f1_->i_FI_IP_MASK))
#line 1291
#define f2 (&(f2_->i_FI_IP_MASK))
#line 1291
#undef f1
#line 1291
#undef f2
#line 1291
break;
#line 1291

#line 1299 "filter/f-inst.c"
 /* Comparison for FI_PATH_PREPEND */
#line 1299
case FI_PATH_PREPEND:
#line 1299
#define f1 (&(f1_->i_FI_PATH_PREPEND))
#line 1299
#define f2 (&(f2_->i_FI_PATH_PREPEND))
#line 1299
#undef f1
#line 1299
#undef f2
#line 1299
break;
#line 1299

#line 1307 "filter/f-inst.c"
 /* Comparison for FI_STRING_APPEND */
#line 1307
case FI_STRING_APPEND:
#line 1307
#define f1 (&(f1_->i_FI_STRING_APPEND))
#line 1307
#define f2 (&(f2_->i_FI_STRING_APPEND))
#line 1307
#undef f1
#line 1307
#undef f2
#line 1307
break;
#line 1307

#line 1315 "filter/f-inst.c"
 /* Comparison for FI_BYTESTRING_APPEND */
#line 1315
case FI_BYTESTRING_APPEND:
#line 1315
#define f1 (&(f1_->i_FI_BYTESTRING_APPEND))
#line 1315
#define f2 (&(f2_->i_FI_BYTESTRING_APPEND))
#line 1315
#undef f1
#line 1315
#undef f2
#line 1315
break;
#line 1315

#line 1322 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_PAIR */
#line 1322
case FI_CLIST_ADD_PAIR:
#line 1322
#define f1 (&(f1_->i_FI_CLIST_ADD_PAIR))
#line 1322
#define f2 (&(f2_->i_FI_CLIST_ADD_PAIR))
#line 1322
#undef f1
#line 1322
#undef f2
#line 1322
break;
#line 1322

#line 1336 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_IP */
#line 1336
case FI_CLIST_ADD_IP:
#line 1336
#define f1 (&(f1_->i_FI_CLIST_ADD_IP))
#line 1336
#define f2 (&(f2_->i_FI_CLIST_ADD_IP))
#line 1336
#undef f1
#line 1336
#undef f2
#line 1336
break;
#line 1336

#line 1343 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_QUAD */
#line 1343
case FI_CLIST_ADD_QUAD:
#line 1343
#define f1 (&(f1_->i_FI_CLIST_ADD_QUAD))
#line 1343
#define f2 (&(f2_->i_FI_CLIST_ADD_QUAD))
#line 1343
#undef f1
#line 1343
#undef f2
#line 1343
break;
#line 1343

#line 1350 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_CLIST */
#line 1350
case FI_CLIST_ADD_CLIST:
#line 1350
#define f1 (&(f1_->i_FI_CLIST_ADD_CLIST))
#line 1350
#define f2 (&(f2_->i_FI_CLIST_ADD_CLIST))
#line 1350
#undef f1
#line 1350
#undef f2
#line 1350
break;
#line 1350

#line 1357 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_ADD_EC */
#line 1357
case FI_ECLIST_ADD_EC:
#line 1357
#define f1 (&(f1_->i_FI_ECLIST_ADD_EC))
#line 1357
#define f2 (&(f2_->i_FI_ECLIST_ADD_EC))
#line 1357
#undef f1
#line 1357
#undef f2
#line 1357
break;
#line 1357

#line 1364 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_ADD_ECLIST */
#line 1364
case FI_ECLIST_ADD_ECLIST:
#line 1364
#define f1 (&(f1_->i_FI_ECLIST_ADD_ECLIST))
#line 1364
#define f2 (&(f2_->i_FI_ECLIST_ADD_ECLIST))
#line 1364
#undef f1
#line 1364
#undef f2
#line 1364
break;
#line 1364

#line 1371 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_ADD_LC */
#line 1371
case FI_LCLIST_ADD_LC:
#line 1371
#define f1 (&(f1_->i_FI_LCLIST_ADD_LC))
#line 1371
#define f2 (&(f2_->i_FI_LCLIST_ADD_LC))
#line 1371
#undef f1
#line 1371
#undef f2
#line 1371
break;
#line 1371

#line 1378 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_ADD_LCLIST */
#line 1378
case FI_LCLIST_ADD_LCLIST:
#line 1378
#define f1 (&(f1_->i_FI_LCLIST_ADD_LCLIST))
#line 1378
#define f2 (&(f2_->i_FI_LCLIST_ADD_LCLIST))
#line 1378
#undef f1
#line 1378
#undef f2
#line 1378
break;
#line 1378

#line 1385 "filter/f-inst.c"
 /* Comparison for FI_PATH_DELETE_INT */
#line 1385
case FI_PATH_DELETE_INT:
#line 1385
#define f1 (&(f1_->i_FI_PATH_DELETE_INT))
#line 1385
#define f2 (&(f2_->i_FI_PATH_DELETE_INT))
#line 1385
#undef f1
#line 1385
#undef f2
#line 1385
break;
#line 1385

#line 1397 "filter/f-inst.c"
 /* Comparison for FI_PATH_DELETE_SET */
#line 1397
case FI_PATH_DELETE_SET:
#line 1397
#define f1 (&(f1_->i_FI_PATH_DELETE_SET))
#line 1397
#define f2 (&(f2_->i_FI_PATH_DELETE_SET))
#line 1397
#undef f1
#line 1397
#undef f2
#line 1397
break;
#line 1397

#line 1404 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_PAIR */
#line 1404
case FI_CLIST_DELETE_PAIR:
#line 1404
#define f1 (&(f1_->i_FI_CLIST_DELETE_PAIR))
#line 1404
#define f2 (&(f2_->i_FI_CLIST_DELETE_PAIR))
#line 1404
#undef f1
#line 1404
#undef f2
#line 1404
break;
#line 1404

#line 1418 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_IP */
#line 1418
case FI_CLIST_DELETE_IP:
#line 1418
#define f1 (&(f1_->i_FI_CLIST_DELETE_IP))
#line 1418
#define f2 (&(f2_->i_FI_CLIST_DELETE_IP))
#line 1418
#undef f1
#line 1418
#undef f2
#line 1418
break;
#line 1418

#line 1425 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_QUAD */
#line 1425
case FI_CLIST_DELETE_QUAD:
#line 1425
#define f1 (&(f1_->i_FI_CLIST_DELETE_QUAD))
#line 1425
#define f2 (&(f2_->i_FI_CLIST_DELETE_QUAD))
#line 1425
#undef f1
#line 1425
#undef f2
#line 1425
break;
#line 1425

#line 1432 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_CLIST */
#line 1432
case FI_CLIST_DELETE_CLIST:
#line 1432
#define f1 (&(f1_->i_FI_CLIST_DELETE_CLIST))
#line 1432
#define f2 (&(f2_->i_FI_CLIST_DELETE_CLIST))
#line 1432
#undef f1
#line 1432
#undef f2
#line 1432
break;
#line 1432

#line 1443 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_SET */
#line 1443
case FI_CLIST_DELETE_SET:
#line 1443
#define f1 (&(f1_->i_FI_CLIST_DELETE_SET))
#line 1443
#define f2 (&(f2_->i_FI_CLIST_DELETE_SET))
#line 1443
#undef f1
#line 1443
#undef f2
#line 1443
break;
#line 1443

#line 1450 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_EC */
#line 1450
case FI_ECLIST_DELETE_EC:
#line 1450
#define f1 (&(f1_->i_FI_ECLIST_DELETE_EC))
#line 1450
#define f2 (&(f2_->i_FI_ECLIST_DELETE_EC))
#line 1450
#undef f1
#line 1450
#undef f2
#line 1450
break;
#line 1450

#line 1457 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_ECLIST */
#line 1457
case FI_ECLIST_DELETE_ECLIST:
#line 1457
#define f1 (&(f1_->i_FI_ECLIST_DELETE_ECLIST))
#line 1457
#define f2 (&(f2_->i_FI_ECLIST_DELETE_ECLIST))
#line 1457
#undef f1
#line 1457
#undef f2
#line 1457
break;
#line 1457

#line 1468 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_SET */
#line 1468
case FI_ECLIST_DELETE_SET:
#line 1468
#define f1 (&(f1_->i_FI_ECLIST_DELETE_SET))
#line 1468
#define f2 (&(f2_->i_FI_ECLIST_DELETE_SET))
#line 1468
#undef f1
#line 1468
#undef f2
#line 1468
break;
#line 1468

#line 1475 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_LC */
#line 1475
case FI_LCLIST_DELETE_LC:
#line 1475
#define f1 (&(f1_->i_FI_LCLIST_DELETE_LC))
#line 1475
#define f2 (&(f2_->i_FI_LCLIST_DELETE_LC))
#line 1475
#undef f1
#line 1475
#undef f2
#line 1475
break;
#line 1475

#line 1482 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_LCLIST */
#line 1482
case FI_LCLIST_DELETE_LCLIST:
#line 1482
#define f1 (&(f1_->i_FI_LCLIST_DELETE_LCLIST))
#line 1482
#define f2 (&(f2_->i_FI_LCLIST_DELETE_LCLIST))
#line 1482
#undef f1
#line 1482
#undef f2
#line 1482
break;
#line 1482

#line 1493 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_SET */
#line 1493
case FI_LCLIST_DELETE_SET:
#line 1493
#define f1 (&(f1_->i_FI_LCLIST_DELETE_SET))
#line 1493
#define f2 (&(f2_->i_FI_LCLIST_DELETE_SET))
#line 1493
#undef f1
#line 1493
#undef f2
#line 1493
break;
#line 1493

#line 1504 "filter/f-inst.c"
 /* Comparison for FI_PATH_FILTER_SET */
#line 1504
case FI_PATH_FILTER_SET:
#line 1504
#define f1 (&(f1_->i_FI_PATH_FILTER_SET))
#line 1504
#define f2 (&(f2_->i_FI_PATH_FILTER_SET))
#line 1504
#undef f1
#line 1504
#undef f2
#line 1504
break;
#line 1504

#line 1511 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FILTER_CLIST */
#line 1511
case FI_CLIST_FILTER_CLIST:
#line 1511
#define f1 (&(f1_->i_FI_CLIST_FILTER_CLIST))
#line 1511
#define f2 (&(f2_->i_FI_CLIST_FILTER_CLIST))
#line 1511
#undef f1
#line 1511
#undef f2
#line 1511
break;
#line 1511

#line 1522 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FILTER_SET */
#line 1522
case FI_CLIST_FILTER_SET:
#line 1522
#define f1 (&(f1_->i_FI_CLIST_FILTER_SET))
#line 1522
#define f2 (&(f2_->i_FI_CLIST_FILTER_SET))
#line 1522
#undef f1
#line 1522
#undef f2
#line 1522
break;
#line 1522

#line 1529 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FILTER_ECLIST */
#line 1529
case FI_ECLIST_FILTER_ECLIST:
#line 1529
#define f1 (&(f1_->i_FI_ECLIST_FILTER_ECLIST))
#line 1529
#define f2 (&(f2_->i_FI_ECLIST_FILTER_ECLIST))
#line 1529
#undef f1
#line 1529
#undef f2
#line 1529
break;
#line 1529

#line 1540 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FILTER_SET */
#line 1540
case FI_ECLIST_FILTER_SET:
#line 1540
#define f1 (&(f1_->i_FI_ECLIST_FILTER_SET))
#line 1540
#define f2 (&(f2_->i_FI_ECLIST_FILTER_SET))
#line 1540
#undef f1
#line 1540
#undef f2
#line 1540
break;
#line 1540

#line 1547 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FILTER_LCLIST */
#line 1547
case FI_LCLIST_FILTER_LCLIST:
#line 1547
#define f1 (&(f1_->i_FI_LCLIST_FILTER_LCLIST))
#line 1547
#define f2 (&(f2_->i_FI_LCLIST_FILTER_LCLIST))
#line 1547
#undef f1
#line 1547
#undef f2
#line 1547
break;
#line 1547

#line 1558 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FILTER_SET */
#line 1558
case FI_LCLIST_FILTER_SET:
#line 1558
#define f1 (&(f1_->i_FI_LCLIST_FILTER_SET))
#line 1558
#define f2 (&(f2_->i_FI_LCLIST_FILTER_SET))
#line 1558
#undef f1
#line 1558
#undef f2
#line 1558
break;
#line 1558

#line 1580 "filter/f-inst.c"
 /* Comparison for FI_ROA_CHECK */
#line 1580
case FI_ROA_CHECK:
#line 1580
#define f1 (&(f1_->i_FI_ROA_CHECK))
#line 1580
#define f2 (&(f2_->i_FI_ROA_CHECK))
#line 1562 "filter/f-inst.c"
if (strcmp(f1->rtc->name, f2->rtc->name)) return 0;
#line 1562

#line 1562

#line 1580 "filter/f-inst.c"
#undef f1
#line 1580
#undef f2
#line 1580
break;
#line 1580

#line 1596 "filter/f-inst.c"
 /* Comparison for FI_ASPA_CHECK_EXPLICIT */
#line 1596
case FI_ASPA_CHECK_EXPLICIT:
#line 1596
#define f1 (&(f1_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1596
#define f2 (&(f2_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1584 "filter/f-inst.c"
if (strcmp(f1->rtc->name, f2->rtc->name)) return 0;
#line 1584

#line 1584

#line 1596 "filter/f-inst.c"
#undef f1
#line 1596
#undef f2
#line 1596
break;
#line 1596

#line 1611 "filter/f-inst.c"
 /* Comparison for FI_FROM_HEX */
#line 1611
case FI_FROM_HEX:
#line 1611
#define f1 (&(f1_->i_FI_FROM_HEX))
#line 1611
#define f2 (&(f2_->i_FI_FROM_HEX))
#line 1611
#undef f1
#line 1611
#undef f2
#line 1611
break;
#line 1611

#line 1616 "filter/f-inst.c"
 /* Comparison for FI_FORMAT */
#line 1616
case FI_FORMAT:
#line 1616
#define f1 (&(f1_->i_FI_FORMAT))
#line 1616
#define f2 (&(f2_->i_FI_FORMAT))
#line 1616
#undef f1
#line 1616
#undef f2
#line 1616
break;
#line 1616

#line 830 "filter/decl.m4"
 /* Comparison for FI_ASSERT */
#line 830
case FI_ASSERT:
#line 830
#define f1 (&(f1_->i_FI_ASSERT))
#line 830
#define f2 (&(f2_->i_FI_ASSERT))
#line 1620 "filter/f-inst.c"
if (strcmp(f1->s, f2->s)) return 0;
#line 1620

#line 1620

#line 830 "filter/decl.m4"
#undef f1
#line 830
#undef f2
#line 830
break;
#line 830

#line 751 "filter/decl.m4"

    }
  }
#undef f1_
#undef f2_
  return 1;
}


/* Part of FI_SWITCH filter iterator */
static void
f_add_tree_lines(const struct f_tree *t, void *fit_)
{
  struct filter_iterator * fit = fit_;

  if (t->data)
    BUFFER_PUSH(fit->lines) = t->data;
}

/* Filter line iterator */
void
f_add_lines(const struct f_line_item *what, struct filter_iterator *fit)
{
  switch(what->fi_code) {
#line 288 "filter/f-inst.c"
 /* Iteration for FI_ADD */
#line 288
case FI_ADD:
#line 288
#define whati (&(what->i_FI_ADD))
#line 288
#undef whati
#line 288
break;
#line 288

#line 293 "filter/f-inst.c"
 /* Iteration for FI_SUBTRACT */
#line 293
case FI_SUBTRACT:
#line 293
#define whati (&(what->i_FI_SUBTRACT))
#line 293
#undef whati
#line 293
break;
#line 293

#line 298 "filter/f-inst.c"
 /* Iteration for FI_MULTIPLY */
#line 298
case FI_MULTIPLY:
#line 298
#define whati (&(what->i_FI_MULTIPLY))
#line 298
#undef whati
#line 298
break;
#line 298

#line 304 "filter/f-inst.c"
 /* Iteration for FI_DIVIDE */
#line 304
case FI_DIVIDE:
#line 304
#define whati (&(what->i_FI_DIVIDE))
#line 304
#undef whati
#line 304
break;
#line 304

#line 309 "filter/f-inst.c"
 /* Iteration for FI_BITOR */
#line 309
case FI_BITOR:
#line 309
#define whati (&(what->i_FI_BITOR))
#line 309
#undef whati
#line 309
break;
#line 309

#line 314 "filter/f-inst.c"
 /* Iteration for FI_BITAND */
#line 314
case FI_BITAND:
#line 314
#define whati (&(what->i_FI_BITAND))
#line 314
#undef whati
#line 314
break;
#line 314

#line 324 "filter/f-inst.c"
 /* Iteration for FI_AND */
#line 324
case FI_AND:
#line 324
#define whati (&(what->i_FI_AND))
#line 320 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 324 "filter/f-inst.c"
#undef whati
#line 324
break;
#line 324

#line 335 "filter/f-inst.c"
 /* Iteration for FI_OR */
#line 335
case FI_OR:
#line 335
#define whati (&(what->i_FI_OR))
#line 330 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 335 "filter/f-inst.c"
#undef whati
#line 335
break;
#line 335

#line 345 "filter/f-inst.c"
 /* Iteration for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT:
#line 345
#define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
#undef whati
#line 345
break;
#line 345

#line 385 "filter/f-inst.c"
 /* Iteration for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT:
#line 385
#define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
#undef whati
#line 385
break;
#line 385

#line 392 "filter/f-inst.c"
 /* Iteration for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT:
#line 392
#define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
#undef whati
#line 392
break;
#line 392

#line 442 "filter/f-inst.c"
 /* Iteration for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT:
#line 442
#define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
#undef whati
#line 442
break;
#line 442

#line 449 "filter/f-inst.c"
 /* Iteration for FI_NEQ */
#line 449
case FI_NEQ:
#line 449
#define whati (&(what->i_FI_NEQ))
#line 449
#undef whati
#line 449
break;
#line 449

#line 456 "filter/f-inst.c"
 /* Iteration for FI_EQ */
#line 456
case FI_EQ:
#line 456
#define whati (&(what->i_FI_EQ))
#line 456
#undef whati
#line 456
break;
#line 456

#line 467 "filter/f-inst.c"
 /* Iteration for FI_LT */
#line 467
case FI_LT:
#line 467
#define whati (&(what->i_FI_LT))
#line 467
#undef whati
#line 467
break;
#line 467

#line 478 "filter/f-inst.c"
 /* Iteration for FI_LTE */
#line 478
case FI_LTE:
#line 478
#define whati (&(what->i_FI_LTE))
#line 478
#undef whati
#line 478
break;
#line 478

#line 483 "filter/f-inst.c"
 /* Iteration for FI_NOT */
#line 483
case FI_NOT:
#line 483
#define whati (&(what->i_FI_NOT))
#line 483
#undef whati
#line 483
break;
#line 483

#line 492 "filter/f-inst.c"
 /* Iteration for FI_MATCH */
#line 492
case FI_MATCH:
#line 492
#define whati (&(what->i_FI_MATCH))
#line 492
#undef whati
#line 492
break;
#line 492

#line 501 "filter/f-inst.c"
 /* Iteration for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH:
#line 501
#define whati (&(what->i_FI_NOT_MATCH))
#line 501
#undef whati
#line 501
break;
#line 501

#line 506 "filter/f-inst.c"
 /* Iteration for FI_DEFINED */
#line 506
case FI_DEFINED:
#line 506
#define whati (&(what->i_FI_DEFINED))
#line 506
#undef whati
#line 506
break;
#line 506

#line 507 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type:
#line 507
#define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
#undef whati
#line 507
break;
#line 507

#line 510 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4:
#line 510
#define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef whati
#line 510
break;
#line 510

#line 523 "filter/f-inst.c"
 /* Iteration for FI_VAR_INIT */
#line 523
case FI_VAR_INIT:
#line 523
#define whati (&(what->i_FI_VAR_INIT))
#line 523
#undef whati
#line 523
break;
#line 523

#line 534 "filter/f-inst.c"
 /* Iteration for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0:
#line 534
#define whati (&(what->i_FI_VAR_INIT0))
#line 534
#undef whati
#line 534
break;
#line 534

#line 543 "filter/f-inst.c"
 /* Iteration for FI_VAR_SET */
#line 543
case FI_VAR_SET:
#line 543
#define whati (&(what->i_FI_VAR_SET))
#line 543
#undef whati
#line 543
break;
#line 543

#line 550 "filter/f-inst.c"
 /* Iteration for FI_VAR_GET */
#line 550
case FI_VAR_GET:
#line 550
#define whati (&(what->i_FI_VAR_GET))
#line 550
#undef whati
#line 550
break;
#line 550

#line 563 "filter/f-inst.c"
 /* Iteration for FI_CONSTANT */
#line 563
case FI_CONSTANT:
#line 563
#define whati (&(what->i_FI_CONSTANT))
#line 563
#undef whati
#line 563
break;
#line 563

#line 564 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty:
#line 564
#define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
#undef whati
#line 564
break;
#line 564

#line 565 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty:
#line 565
#define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef whati
#line 565
break;
#line 565

#line 566 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty:
#line 566
#define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef whati
#line 566
break;
#line 566

#line 569 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty:
#line 569
#define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef whati
#line 569
break;
#line 569

#line 591 "filter/f-inst.c"
 /* Iteration for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START:
#line 591
#define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
#undef whati
#line 591
break;
#line 591

#line 600 "filter/f-inst.c"
 /* Iteration for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT:
#line 600
#define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 600 "filter/f-inst.c"
#undef whati
#line 600
break;
#line 600

#line 609 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT:
#line 609
#define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 609 "filter/f-inst.c"
#undef whati
#line 609
break;
#line 609

#line 618 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT:
#line 618
#define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 618 "filter/f-inst.c"
#undef whati
#line 618
break;
#line 618

#line 627 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT:
#line 627
#define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 627 "filter/f-inst.c"
#undef whati
#line 627
break;
#line 627

#line 640 "filter/f-inst.c"
 /* Iteration for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT:
#line 640
#define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 640 "filter/f-inst.c"
#undef whati
#line 640
break;
#line 640

#line 648 "filter/f-inst.c"
 /* Iteration for FI_CONDITION */
#line 648
case FI_CONDITION:
#line 648
#define whati (&(what->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 645 "filter/f-inst.c"
if (whati->fl3) BUFFER_PUSH(fit->lines) = whati->fl3;
#line 648 "filter/f-inst.c"
#undef whati
#line 648
break;
#line 648

#line 661 "filter/f-inst.c"
 /* Iteration for FI_PRINT */
#line 661
case FI_PRINT:
#line 661
#define whati (&(what->i_FI_PRINT))
#line 661
#undef whati
#line 661
break;
#line 661

#line 668 "filter/f-inst.c"
 /* Iteration for FI_FLUSH */
#line 668
case FI_FLUSH:
#line 668
#define whati (&(what->i_FI_FLUSH))
#line 668
#undef whati
#line 668
break;
#line 668

#line 682 "filter/f-inst.c"
 /* Iteration for FI_DIE */
#line 682
case FI_DIE:
#line 682
#define whati (&(what->i_FI_DIE))
#line 682
#undef whati
#line 682
break;
#line 682

#line 689 "filter/f-inst.c"
 /* Iteration for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE:
#line 689
#define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
#undef whati
#line 689
break;
#line 689

#line 740 "filter/f-inst.c"
 /* Iteration for FI_RTA_GET */
#line 740
case FI_RTA_GET:
#line 740
#define whati (&(what->i_FI_RTA_GET))
#line 740
#undef whati
#line 740
break;
#line 740

#line 897 "filter/f-inst.c"
 /* Iteration for FI_RTA_SET */
#line 897
case FI_RTA_SET:
#line 897
#define whati (&(what->i_FI_RTA_SET))
#line 897
#undef whati
#line 897
break;
#line 897

#line 934 "filter/f-inst.c"
 /* Iteration for FI_EA_GET */
#line 934
case FI_EA_GET:
#line 934
#define whati (&(what->i_FI_EA_GET))
#line 934
#undef whati
#line 934
break;
#line 934

#line 975 "filter/f-inst.c"
 /* Iteration for FI_EA_SET */
#line 975
case FI_EA_SET:
#line 975
#define whati (&(what->i_FI_EA_SET))
#line 975
#undef whati
#line 975
break;
#line 975

#line 982 "filter/f-inst.c"
 /* Iteration for FI_EA_UNSET */
#line 982
case FI_EA_UNSET:
#line 982
#define whati (&(what->i_FI_EA_UNSET))
#line 982
#undef whati
#line 982
break;
#line 982

#line 996 "filter/f-inst.c"
 /* Iteration for FI_DEFAULT */
#line 996
case FI_DEFAULT:
#line 996
#define whati (&(what->i_FI_DEFAULT))
#line 996
#undef whati
#line 996
break;
#line 996

#line 997 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__len */
#line 997
case FI_METHOD__T_NET__len:
#line 997
#define whati (&(what->i_FI_METHOD__T_NET__len))
#line 997
#undef whati
#line 997
break;
#line 997

#line 998 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__len */
#line 998
case FI_METHOD__T_PATH__len:
#line 998
#define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 998
#undef whati
#line 998
break;
#line 998

#line 999 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__len */
#line 999
case FI_METHOD__T_CLIST__len:
#line 999
#define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 999
#undef whati
#line 999
break;
#line 999

#line 1000 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__len */
#line 1000
case FI_METHOD__T_ECLIST__len:
#line 1000
#define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 1000
#undef whati
#line 1000
break;
#line 1000

#line 1002 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__len */
#line 1002
case FI_METHOD__T_LCLIST__len:
#line 1002
#define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 1002
#undef whati
#line 1002
break;
#line 1002

#line 1038 "filter/f-inst.c"
 /* Iteration for FI_NET_SRC */
#line 1038
case FI_NET_SRC:
#line 1038
#define whati (&(what->i_FI_NET_SRC))
#line 1038
#undef whati
#line 1038
break;
#line 1038

#line 1075 "filter/f-inst.c"
 /* Iteration for FI_NET_DST */
#line 1075
case FI_NET_DST:
#line 1075
#define whati (&(what->i_FI_NET_DST))
#line 1075
#undef whati
#line 1075
break;
#line 1075

#line 1085 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__maxlen */
#line 1085
case FI_METHOD__T_NET__maxlen:
#line 1085
#define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1085
#undef whati
#line 1085
break;
#line 1085

#line 1095 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__asn */
#line 1095
case FI_METHOD__T_NET__asn:
#line 1095
#define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1095
#undef whati
#line 1095
break;
#line 1095

#line 1097 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__ip */
#line 1097
case FI_METHOD__T_NET__ip:
#line 1097
#define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1097
#undef whati
#line 1097
break;
#line 1097

#line 1106 "filter/f-inst.c"
 /* Iteration for FI_ROUTE_DISTINGUISHER */
#line 1106
case FI_ROUTE_DISTINGUISHER:
#line 1106
#define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1106
#undef whati
#line 1106
break;
#line 1106

#line 1109 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__first */
#line 1109
case FI_METHOD__T_PATH__first:
#line 1109
#define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1109
#undef whati
#line 1109
break;
#line 1109

#line 1112 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__last */
#line 1112
case FI_METHOD__T_PATH__last:
#line 1112
#define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1112
#undef whati
#line 1112
break;
#line 1112

#line 1115 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__last_nonaggregated */
#line 1115
case FI_METHOD__T_PATH__last_nonaggregated:
#line 1115
#define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1115
#undef whati
#line 1115
break;
#line 1115

#line 1118 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PAIR__asn */
#line 1118
case FI_METHOD__T_PAIR__asn:
#line 1118
#define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1118
#undef whati
#line 1118
break;
#line 1118

#line 1121 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PAIR__data */
#line 1121
case FI_METHOD__T_PAIR__data:
#line 1121
#define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1121
#undef whati
#line 1121
break;
#line 1121

#line 1124 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__asn */
#line 1124
case FI_METHOD__T_LC__asn:
#line 1124
#define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1124
#undef whati
#line 1124
break;
#line 1124

#line 1127 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__data1 */
#line 1127
case FI_METHOD__T_LC__data1:
#line 1127
#define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1127
#undef whati
#line 1127
break;
#line 1127

#line 1130 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__data2 */
#line 1130
case FI_METHOD__T_LC__data2:
#line 1130
#define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1130
#undef whati
#line 1130
break;
#line 1130

#line 1133 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__min */
#line 1133
case FI_METHOD__T_CLIST__min:
#line 1133
#define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1133
#undef whati
#line 1133
break;
#line 1133

#line 1136 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__max */
#line 1136
case FI_METHOD__T_CLIST__max:
#line 1136
#define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1136
#undef whati
#line 1136
break;
#line 1136

#line 1139 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__min */
#line 1139
case FI_METHOD__T_ECLIST__min:
#line 1139
#define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1139
#undef whati
#line 1139
break;
#line 1139

#line 1142 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__max */
#line 1142
case FI_METHOD__T_ECLIST__max:
#line 1142
#define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1142
#undef whati
#line 1142
break;
#line 1142

#line 1145 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__min */
#line 1145
case FI_METHOD__T_LCLIST__min:
#line 1145
#define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1145
#undef whati
#line 1145
break;
#line 1145

#line 1147 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__max */
#line 1147
case FI_METHOD__T_LCLIST__max:
#line 1147
#define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1147
#undef whati
#line 1147
break;
#line 1147

#line 1173 "filter/f-inst.c"
 /* Iteration for FI_RETURN */
#line 1173
case FI_RETURN:
#line 1173
#define whati (&(what->i_FI_RETURN))
#line 1173
#undef whati
#line 1173
break;
#line 1173

#line 1233 "filter/f-inst.c"
 /* Iteration for FI_CALL */
#line 1233
case FI_CALL:
#line 1233
#define whati (&(what->i_FI_CALL))

#line 1214 "filter/f-inst.c"
    if (!(what->flags & FIF_RECURSIVE))
      BUFFER_PUSH(fit->lines) = whati->sym->function;

    #line 1233 "filter/f-inst.c"
#undef whati
#line 1233
break;
#line 1233

#line 1238 "filter/f-inst.c"
 /* Iteration for FI_DROP_RESULT */
#line 1238
case FI_DROP_RESULT:
#line 1238
#define whati (&(what->i_FI_DROP_RESULT))
#line 1238
#undef whati
#line 1238
break;
#line 1238

#line 1282 "filter/f-inst.c"
 /* Iteration for FI_SWITCH */
#line 1282
case FI_SWITCH:
#line 1282
#define whati (&(what->i_FI_SWITCH))

#line 1265 "filter/f-inst.c"
    tree_walk(whati->tree, f_add_tree_lines, fit);

    #line 1282 "filter/f-inst.c"
#undef whati
#line 1282
break;
#line 1282

#line 1291 "filter/f-inst.c"
 /* Iteration for FI_IP_MASK */
#line 1291
case FI_IP_MASK:
#line 1291
#define whati (&(what->i_FI_IP_MASK))
#line 1291
#undef whati
#line 1291
break;
#line 1291

#line 1299 "filter/f-inst.c"
 /* Iteration for FI_PATH_PREPEND */
#line 1299
case FI_PATH_PREPEND:
#line 1299
#define whati (&(what->i_FI_PATH_PREPEND))
#line 1299
#undef whati
#line 1299
break;
#line 1299

#line 1307 "filter/f-inst.c"
 /* Iteration for FI_STRING_APPEND */
#line 1307
case FI_STRING_APPEND:
#line 1307
#define whati (&(what->i_FI_STRING_APPEND))
#line 1307
#undef whati
#line 1307
break;
#line 1307

#line 1315 "filter/f-inst.c"
 /* Iteration for FI_BYTESTRING_APPEND */
#line 1315
case FI_BYTESTRING_APPEND:
#line 1315
#define whati (&(what->i_FI_BYTESTRING_APPEND))
#line 1315
#undef whati
#line 1315
break;
#line 1315

#line 1322 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_PAIR */
#line 1322
case FI_CLIST_ADD_PAIR:
#line 1322
#define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1322
#undef whati
#line 1322
break;
#line 1322

#line 1336 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_IP */
#line 1336
case FI_CLIST_ADD_IP:
#line 1336
#define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1336
#undef whati
#line 1336
break;
#line 1336

#line 1343 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_QUAD */
#line 1343
case FI_CLIST_ADD_QUAD:
#line 1343
#define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1343
#undef whati
#line 1343
break;
#line 1343

#line 1350 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_CLIST */
#line 1350
case FI_CLIST_ADD_CLIST:
#line 1350
#define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1350
#undef whati
#line 1350
break;
#line 1350

#line 1357 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_ADD_EC */
#line 1357
case FI_ECLIST_ADD_EC:
#line 1357
#define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1357
#undef whati
#line 1357
break;
#line 1357

#line 1364 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_ADD_ECLIST */
#line 1364
case FI_ECLIST_ADD_ECLIST:
#line 1364
#define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1364
#undef whati
#line 1364
break;
#line 1364

#line 1371 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_ADD_LC */
#line 1371
case FI_LCLIST_ADD_LC:
#line 1371
#define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1371
#undef whati
#line 1371
break;
#line 1371

#line 1378 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_ADD_LCLIST */
#line 1378
case FI_LCLIST_ADD_LCLIST:
#line 1378
#define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1378
#undef whati
#line 1378
break;
#line 1378

#line 1385 "filter/f-inst.c"
 /* Iteration for FI_PATH_DELETE_INT */
#line 1385
case FI_PATH_DELETE_INT:
#line 1385
#define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1385
#undef whati
#line 1385
break;
#line 1385

#line 1397 "filter/f-inst.c"
 /* Iteration for FI_PATH_DELETE_SET */
#line 1397
case FI_PATH_DELETE_SET:
#line 1397
#define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1397
#undef whati
#line 1397
break;
#line 1397

#line 1404 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_PAIR */
#line 1404
case FI_CLIST_DELETE_PAIR:
#line 1404
#define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1404
#undef whati
#line 1404
break;
#line 1404

#line 1418 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_IP */
#line 1418
case FI_CLIST_DELETE_IP:
#line 1418
#define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1418
#undef whati
#line 1418
break;
#line 1418

#line 1425 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_QUAD */
#line 1425
case FI_CLIST_DELETE_QUAD:
#line 1425
#define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1425
#undef whati
#line 1425
break;
#line 1425

#line 1432 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_CLIST */
#line 1432
case FI_CLIST_DELETE_CLIST:
#line 1432
#define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1432
#undef whati
#line 1432
break;
#line 1432

#line 1443 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_SET */
#line 1443
case FI_CLIST_DELETE_SET:
#line 1443
#define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1443
#undef whati
#line 1443
break;
#line 1443

#line 1450 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_EC */
#line 1450
case FI_ECLIST_DELETE_EC:
#line 1450
#define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1450
#undef whati
#line 1450
break;
#line 1450

#line 1457 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_ECLIST */
#line 1457
case FI_ECLIST_DELETE_ECLIST:
#line 1457
#define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1457
#undef whati
#line 1457
break;
#line 1457

#line 1468 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_SET */
#line 1468
case FI_ECLIST_DELETE_SET:
#line 1468
#define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1468
#undef whati
#line 1468
break;
#line 1468

#line 1475 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_LC */
#line 1475
case FI_LCLIST_DELETE_LC:
#line 1475
#define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1475
#undef whati
#line 1475
break;
#line 1475

#line 1482 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_LCLIST */
#line 1482
case FI_LCLIST_DELETE_LCLIST:
#line 1482
#define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1482
#undef whati
#line 1482
break;
#line 1482

#line 1493 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_SET */
#line 1493
case FI_LCLIST_DELETE_SET:
#line 1493
#define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1493
#undef whati
#line 1493
break;
#line 1493

#line 1504 "filter/f-inst.c"
 /* Iteration for FI_PATH_FILTER_SET */
#line 1504
case FI_PATH_FILTER_SET:
#line 1504
#define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1504
#undef whati
#line 1504
break;
#line 1504

#line 1511 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FILTER_CLIST */
#line 1511
case FI_CLIST_FILTER_CLIST:
#line 1511
#define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1511
#undef whati
#line 1511
break;
#line 1511

#line 1522 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FILTER_SET */
#line 1522
case FI_CLIST_FILTER_SET:
#line 1522
#define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1522
#undef whati
#line 1522
break;
#line 1522

#line 1529 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FILTER_ECLIST */
#line 1529
case FI_ECLIST_FILTER_ECLIST:
#line 1529
#define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1529
#undef whati
#line 1529
break;
#line 1529

#line 1540 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FILTER_SET */
#line 1540
case FI_ECLIST_FILTER_SET:
#line 1540
#define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1540
#undef whati
#line 1540
break;
#line 1540

#line 1547 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FILTER_LCLIST */
#line 1547
case FI_LCLIST_FILTER_LCLIST:
#line 1547
#define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1547
#undef whati
#line 1547
break;
#line 1547

#line 1558 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FILTER_SET */
#line 1558
case FI_LCLIST_FILTER_SET:
#line 1558
#define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1558
#undef whati
#line 1558
break;
#line 1558

#line 1580 "filter/f-inst.c"
 /* Iteration for FI_ROA_CHECK */
#line 1580
case FI_ROA_CHECK:
#line 1580
#define whati (&(what->i_FI_ROA_CHECK))
#line 1580
#undef whati
#line 1580
break;
#line 1580

#line 1596 "filter/f-inst.c"
 /* Iteration for FI_ASPA_CHECK_EXPLICIT */
#line 1596
case FI_ASPA_CHECK_EXPLICIT:
#line 1596
#define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1596
#undef whati
#line 1596
break;
#line 1596

#line 1611 "filter/f-inst.c"
 /* Iteration for FI_FROM_HEX */
#line 1611
case FI_FROM_HEX:
#line 1611
#define whati (&(what->i_FI_FROM_HEX))
#line 1611
#undef whati
#line 1611
break;
#line 1611

#line 1616 "filter/f-inst.c"
 /* Iteration for FI_FORMAT */
#line 1616
case FI_FORMAT:
#line 1616
#define whati (&(what->i_FI_FORMAT))
#line 1616
#undef whati
#line 1616
break;
#line 1616

#line 830 "filter/decl.m4"
 /* Iteration for FI_ASSERT */
#line 830
case FI_ASSERT:
#line 830
#define whati (&(what->i_FI_ASSERT))
#line 830
#undef whati
#line 830
break;
#line 830

#line 775 "filter/decl.m4"

  }
}


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic pop
#endif

