/* CmapSubtableFormat4.c generated by valac 0.56.17, the Vala compiler
 * generated from CmapSubtableFormat4.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CMAP_SUBTABLE_FORMAT4_0_PROPERTY,
	BIRD_FONT_CMAP_SUBTABLE_FORMAT4_NUM_PROPERTIES
};
static GParamSpec* bird_font_cmap_subtable_format4_properties[BIRD_FONT_CMAP_SUBTABLE_FORMAT4_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))

struct _BirdFontCmapSubtableFormat4Private {
	guint16 format;
	GHashTable* table;
	guint16 length;
	BirdFontFontData* cmap_data;
};

static gint BirdFontCmapSubtableFormat4_private_offset;
static gpointer bird_font_cmap_subtable_format4_parent_class = NULL;

static void _g_free0_ (gpointer var);
static gushort bird_font_cmap_subtable_format4_real_get_platform (BirdFontCmapSubtable* base);
static gushort bird_font_cmap_subtable_format4_real_get_encoding (BirdFontCmapSubtable* base);
static BirdFontFontData* bird_font_cmap_subtable_format4_real_get_cmap_data (BirdFontCmapSubtable* base);
static gint64* _int64_dup (gint64* self);
static gboolean _int64_equal (const gint64 * s1,
                       const gint64 * s2);
static guint64* _uint64_dup (guint64* self);
static void bird_font_cmap_subtable_format4_real_generate_cmap_data (BirdFontCmapSubtable* base,
                                                              BirdFontGlyfTable* glyf_table,
                                                              GError** error);
VALA_EXTERN guint16 bird_font_largest_pow2 (guint16 max);
VALA_EXTERN guint16 bird_font_largest_pow2_exponent (guint16 max);
static void bird_font_cmap_subtable_format4_finalize (GObject * obj);
static GType bird_font_cmap_subtable_format4_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_cmap_subtable_format4_get_instance_private (BirdFontCmapSubtableFormat4* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCmapSubtableFormat4_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

BirdFontCmapSubtableFormat4*
bird_font_cmap_subtable_format4_construct (GType object_type)
{
	BirdFontCmapSubtableFormat4 * self = NULL;
	self = (BirdFontCmapSubtableFormat4*) bird_font_cmap_subtable_construct (object_type);
	return self;
}

BirdFontCmapSubtableFormat4*
bird_font_cmap_subtable_format4_new (void)
{
	return bird_font_cmap_subtable_format4_construct (BIRD_FONT_TYPE_CMAP_SUBTABLE_FORMAT4);
}

static gushort
bird_font_cmap_subtable_format4_real_get_platform (BirdFontCmapSubtable* base)
{
	BirdFontCmapSubtableFormat4 * self;
	gushort result;
	self = (BirdFontCmapSubtableFormat4*) base;
	result = (gushort) 3;
	return result;
}

static gushort
bird_font_cmap_subtable_format4_real_get_encoding (BirdFontCmapSubtable* base)
{
	BirdFontCmapSubtableFormat4 * self;
	gushort result;
	self = (BirdFontCmapSubtableFormat4*) base;
	result = (gushort) 1;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static BirdFontFontData*
bird_font_cmap_subtable_format4_real_get_cmap_data (BirdFontCmapSubtable* base)
{
	BirdFontCmapSubtableFormat4 * self;
	BirdFontFontData* _tmp0_;
	BirdFontFontData* _tmp1_;
	BirdFontFontData* result;
	self = (BirdFontCmapSubtableFormat4*) base;
	_tmp0_ = self->priv->cmap_data;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

guint
bird_font_cmap_subtable_format4_get_length (BirdFontCmapSubtableFormat4* self)
{
	GHashTable* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->table;
	result = g_hash_table_size (_tmp0_);
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static gboolean
_int64_equal (const gint64 * s1,
              const gint64 * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

gunichar
bird_font_cmap_subtable_format4_get_char (BirdFontCmapSubtableFormat4* self,
                                          guint32 index)
{
	gint64* c = NULL;
	GHashTable* _tmp0_;
	guint64 _tmp1_;
	gconstpointer _tmp2_;
	gint64 _tmp3_;
	gint64* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint64* _tmp6_;
	gint64 _tmp7_;
	gint64* _tmp8_;
	gint64 _tmp9_;
	gint64* _tmp21_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->table;
	_tmp1_ = (guint64) index;
	_tmp2_ = g_hash_table_lookup (_tmp0_, &_tmp1_);
	_tmp3_ = (gint64) ((gunichar) ((gintptr) _tmp2_));
	_tmp4_ = __int64_dup0 (&_tmp3_);
	c = _tmp4_;
	_tmp6_ = c;
	_tmp7_ = (gint64) 0;
	if (_int64_equal (_tmp6_, &_tmp7_) == TRUE) {
		_tmp5_ = index == ((guint32) 0);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = (gunichar) 0;
		_g_free0 (c);
		return result;
	}
	_tmp8_ = c;
	_tmp9_ = (gint64) 0;
	if (_int64_equal (_tmp8_, &_tmp9_) == TRUE) {
		gchar* _tmp14_;
		gchar* _tmp15_;
		GHashTable* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		while (TRUE) {
			GHashTable* _tmp10_;
			guint32 _tmp11_;
			guint64 _tmp12_;
			gconstpointer _tmp13_;
			_tmp10_ = self->priv->table;
			index = index - 1;
			_tmp11_ = index;
			_tmp12_ = (guint64) _tmp11_;
			_tmp13_ = g_hash_table_lookup (_tmp10_, &_tmp12_);
			if (!(((gunichar) ((gintptr) _tmp13_)) == ((gunichar) 0))) {
				break;
			}
			if (index == ((guint32) 0)) {
				result = (gunichar) 0;
				_g_free0 (c);
				return result;
			}
		}
		_tmp14_ = g_strdup_printf ("%u", index);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->table;
		_tmp17_ = g_strdup_printf ("%u", g_hash_table_size (_tmp16_));
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat ("There is no character for glyph number ", _tmp15_, " in cmap table. table.size: ", _tmp18_, ")", NULL);
		_tmp20_ = _tmp19_;
		g_warning ("CmapSubtableFormat4.vala:59: %s", _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp15_);
		result = (gunichar) 0;
		_g_free0 (c);
		return result;
	}
	_tmp21_ = c;
	result = (gunichar) (*_tmp21_);
	_g_free0 (c);
	return result;
}

void
bird_font_cmap_subtable_format4_parse (BirdFontCmapSubtableFormat4* self,
                                       BirdFontFontData* dis,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) self->offset);
	self->priv->format = bird_font_font_data_read_ushort (dis);
	switch (self->priv->format) {
		case 4:
		{
			bird_font_cmap_subtable_format4_parse_format4 (self, dis, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			break;
		}
		default:
		{
			FILE* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp0_ = stderr;
			_tmp1_ = g_strdup_printf ("%hu", self->priv->format);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strconcat ("CmapSubtable is in format ", _tmp2_, ", it is not supportet (yet).\n", NULL);
			_tmp4_ = _tmp3_;
			fprintf (_tmp0_, "%s", _tmp4_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp2_);
			break;
		}
	}
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

void
bird_font_cmap_subtable_format4_parse_format4 (BirdFontCmapSubtableFormat4* self,
                                               BirdFontFontData* dis,
                                               GError** error)
{
	guint16 lang = 0U;
	guint16 seg_count_x2 = 0U;
	guint16 seg_count = 0U;
	guint16 search_range = 0U;
	guint16 entry_selector = 0U;
	guint16 range_shift = 0U;
	guint16* end_char = NULL;
	guint16* start_char = NULL;
	gint16* id_delta = NULL;
	guint16* id_range_offset = NULL;
	guint16* glyph_id_array = NULL;
	guint32 gid_len = 0U;
	guint16* _tmp0_;
	guint16* _tmp4_;
	guint16 _tmp5_;
	guint16* _tmp6_;
	gint16* _tmp10_;
	guint16* _tmp15_;
	guint16* _tmp19_;
	gint index = 0;
	gunichar character = 0U;
	guint32 id = 0U;
	guint16* _tmp61_;
	guint16* _tmp63_;
	gint16* _tmp65_;
	guint16* _tmp67_;
	guint16* _tmp69_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	end_char = NULL;
	start_char = NULL;
	id_delta = NULL;
	id_range_offset = NULL;
	glyph_id_array = NULL;
	self->priv->length = bird_font_font_data_read_ushort (dis);
	lang = bird_font_font_data_read_ushort (dis);
	seg_count_x2 = bird_font_font_data_read_ushort (dis);
	search_range = bird_font_font_data_read_ushort (dis);
	entry_selector = bird_font_font_data_read_ushort (dis);
	range_shift = bird_font_font_data_read_ushort (dis);
	g_return_if_fail ((seg_count_x2 % 2) == 0);
	seg_count = (guint16) (seg_count_x2 / 2);
	_tmp0_ = g_new0 (guint16, seg_count);
	end_char = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint16* _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((gint) seg_count))) {
					break;
				}
				_tmp3_ = end_char;
				_tmp3_[i] = bird_font_font_data_read_ushort (dis);
			}
		}
	}
	_tmp4_ = end_char;
	_tmp5_ = _tmp4_[seg_count - 1];
	if (((gint) _tmp5_) != 0xFFFF) {
		g_warning ("CmapSubtableFormat4.vala:115: end_char is $(end_char[seg_count - 1]), " \
"expecting 0xFFFF.");
	}
	bird_font_font_data_read_ushort (dis);
	_tmp6_ = g_new0 (guint16, seg_count);
	start_char = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				guint16* _tmp9_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < ((gint) seg_count))) {
					break;
				}
				_tmp9_ = start_char;
				_tmp9_[i] = bird_font_font_data_read_ushort (dis);
			}
		}
	}
	_tmp10_ = g_new0 (gint16, seg_count);
	id_delta = _tmp10_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint16 _tmp13_ = 0;
				gint16* _tmp14_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < ((gint) seg_count))) {
					break;
				}
				_tmp13_ = bird_font_font_data_read_short (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				_tmp14_ = id_delta;
				_tmp14_[i] = _tmp13_;
			}
		}
	}
	_tmp15_ = g_new0 (guint16, seg_count);
	id_range_offset = _tmp15_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				guint16* _tmp18_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				if (!(i < ((gint) seg_count))) {
					break;
				}
				_tmp18_ = id_range_offset;
				_tmp18_[i] = bird_font_font_data_read_ushort (dis);
			}
		}
	}
	if (((gint) self->priv->length) == 0) {
		g_warning ("CmapSubtableFormat4.vala:136: cmap subtable version 4 has length 0.");
		return;
	}
	gid_len = (guint32) (((self->priv->length - 16) - (8 * seg_count)) / 2);
	_tmp19_ = g_new0 (guint16, gid_len);
	glyph_id_array = _tmp19_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				guint16* _tmp22_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				if (!(((guint32) i) < gid_len)) {
					break;
				}
				_tmp22_ = glyph_id_array;
				_tmp22_[i] = bird_font_font_data_read_ushort (dis);
			}
		}
	}
	index = 0;
	character = (gunichar) 0;
	{
		guint16 i = 0U;
		i = (guint16) 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp25_ = FALSE;
				guint16 j = 0U;
				if (!_tmp23_) {
					guint16 _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				if (i < seg_count) {
					guint16* _tmp26_;
					guint16 _tmp27_;
					_tmp26_ = start_char;
					_tmp27_ = _tmp26_[i];
					_tmp25_ = ((gint) _tmp27_) != 0xFFFF;
				} else {
					_tmp25_ = FALSE;
				}
				if (!_tmp25_) {
					break;
				}
				j = (guint16) 0;
				{
					gboolean _tmp28_ = FALSE;
					_tmp28_ = TRUE;
					while (TRUE) {
						guint16* _tmp31_;
						guint16 _tmp32_;
						guint16* _tmp33_;
						guint16 _tmp34_;
						gint16* _tmp35_;
						gint16 _tmp36_;
						guint16* _tmp37_;
						guint16 _tmp38_;
						guint16 _tmp60_;
						if (!_tmp28_) {
							guint16* _tmp29_;
							guint16 _tmp30_;
							_tmp29_ = end_char;
							_tmp30_ = _tmp29_[i];
							if (!(character != ((gunichar) _tmp30_))) {
								break;
							}
						}
						_tmp28_ = FALSE;
						_tmp31_ = start_char;
						_tmp32_ = _tmp31_[i];
						character = (gunichar) (_tmp32_ + j);
						_tmp33_ = start_char;
						_tmp34_ = _tmp33_[i];
						_tmp35_ = id_delta;
						_tmp36_ = _tmp35_[i];
						index = (gint) ((_tmp34_ + _tmp36_) + j);
						_tmp37_ = id_range_offset;
						_tmp38_ = _tmp37_[i];
						if (((gint) _tmp38_) == 0) {
							GHashTable* _tmp39_;
							guint64 _tmp40_;
							guint64* _tmp41_;
							_tmp39_ = self->priv->table;
							_tmp40_ = (guint64) index;
							_tmp41_ = __uint64_dup0 (&_tmp40_);
							g_hash_table_insert (_tmp39_, _tmp41_, (gpointer) ((gintptr) character));
						} else {
							guint16* _tmp42_;
							guint16 _tmp43_;
							guint32 _tmp44_;
							guint16* _tmp51_;
							guint16 _tmp52_;
							gint16* _tmp53_;
							gint16 _tmp54_;
							GString* s = NULL;
							GString* _tmp55_;
							GString* _tmp56_;
							GHashTable* _tmp57_;
							guint64 _tmp58_;
							guint64* _tmp59_;
							_tmp42_ = id_range_offset;
							_tmp43_ = _tmp42_[i];
							id = (guint32) ((((_tmp43_ / 2) + j) + i) - seg_count);
							_tmp44_ = id;
							if (!((((guint32) 0) <= _tmp44_) && (_tmp44_ < gid_len))) {
								gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
								gchar* _tmp50_;
								_tmp45_ = g_strdup_printf ("%u", id);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strdup_printf ("%u", gid_len);
								_tmp48_ = _tmp47_;
								_tmp49_ = g_strconcat ("(0 <= id < gid_len) (0 <= ", _tmp46_, " < ", _tmp48_, ")", NULL);
								_tmp50_ = _tmp49_;
								g_warning ("CmapSubtableFormat4.vala:166: %s", _tmp50_);
								_g_free0 (_tmp50_);
								_g_free0 (_tmp48_);
								_g_free0 (_tmp46_);
								break;
							}
							_tmp51_ = glyph_id_array;
							_tmp52_ = _tmp51_[id];
							_tmp53_ = id_delta;
							_tmp54_ = _tmp53_[i];
							index = (gint) (_tmp52_ + _tmp54_);
							_tmp55_ = g_string_new ("");
							s = _tmp55_;
							_tmp56_ = s;
							g_string_append_unichar (_tmp56_, character);
							_tmp57_ = self->priv->table;
							_tmp58_ = (guint64) index;
							_tmp59_ = __uint64_dup0 (&_tmp58_);
							g_hash_table_insert (_tmp57_, _tmp59_, (gpointer) ((gintptr) character));
							_g_string_free0 (s);
						}
						_tmp60_ = j;
						j = _tmp60_ + 1;
					}
				}
			}
		}
	}
	_tmp61_ = end_char;
	if (_tmp61_ != NULL) {
		guint16* _tmp62_;
		_tmp62_ = end_char;
		_g_free0 (_tmp62_);
	}
	_tmp63_ = start_char;
	if (_tmp63_ != NULL) {
		guint16* _tmp64_;
		_tmp64_ = start_char;
		_g_free0 (_tmp64_);
	}
	_tmp65_ = id_delta;
	if (_tmp65_ != NULL) {
		gint16* _tmp66_;
		_tmp66_ = id_delta;
		_g_free0 (_tmp66_);
	}
	_tmp67_ = id_range_offset;
	if (_tmp67_ != NULL) {
		guint16* _tmp68_;
		_tmp68_ = id_range_offset;
		_g_free0 (_tmp68_);
	}
	_tmp69_ = glyph_id_array;
	if (_tmp69_ != NULL) {
		guint16* _tmp70_;
		_tmp70_ = glyph_id_array;
		_g_free0 (_tmp70_);
	}
}

static void
bird_font_cmap_subtable_format4_real_generate_cmap_data (BirdFontCmapSubtable* base,
                                                         BirdFontGlyfTable* glyf_table,
                                                         GError** error)
{
	BirdFontCmapSubtableFormat4 * self;
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontGlyphRange* glyph_range = NULL;
	BirdFontGlyphRange* _tmp1_;
	GeeArrayList* ranges = NULL;
	guint16 seg_count_2 = 0U;
	guint16 seg_count = 0U;
	guint16 search_range = 0U;
	guint16 entry_selector = 0U;
	guint16 range_shift = 0U;
	guint16 gid_length = 0U;
	guint32 index = 0U;
	guint32 first_assigned = 0U;
	BirdFontGlyphRange* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	BirdFontFontData* _tmp21_;
	BirdFontFontData* _tmp22_;
	BirdFontFontData* _tmp23_;
	BirdFontFontData* _tmp24_;
	BirdFontFontData* _tmp25_;
	BirdFontFontData* _tmp26_;
	BirdFontFontData* _tmp27_;
	BirdFontFontData* _tmp40_;
	BirdFontFontData* _tmp41_;
	BirdFontFontData* _tmp54_;
	BirdFontFontData* _tmp69_;
	BirdFontFontData* _tmp80_;
	BirdFontFontData* _tmp81_;
	BirdFontFontData* _tmp82_;
	GError* _inner_error0_ = NULL;
	self = (BirdFontCmapSubtableFormat4*) base;
	g_return_if_fail (glyf_table != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = bird_font_glyph_range_new ();
	glyph_range = _tmp1_;
	gid_length = (guint16) 0;
	first_assigned = (guint32) 1;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp2_;
		gint _g_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _g_index = 0;
		_tmp2_ = glyf_table->glyphs;
		_g_list = _tmp2_;
		_tmp3_ = _g_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_size = _tmp5_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			BirdFontGlyphCollection* _tmp11_;
			_g_index = _g_index + 1;
			_tmp6_ = _g_index;
			_tmp7_ = _g_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _g_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp9_;
			_tmp11_ = g;
			if (!bird_font_glyph_collection_is_unassigned (_tmp11_)) {
				BirdFontGlyphCollection* _tmp12_;
				_tmp12_ = g;
				_tmp10_ = bird_font_glyph_collection_get_unicode_character (_tmp12_) < ((gunichar) 0xFFFF);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				BirdFontGlyphRange* _tmp13_;
				BirdFontGlyphCollection* _tmp14_;
				_tmp13_ = glyph_range;
				_tmp14_ = g;
				bird_font_glyph_range_add_single (_tmp13_, bird_font_glyph_collection_get_unicode_character (_tmp14_));
			}
			_g_object_unref0 (g);
		}
	}
	_tmp15_ = glyph_range;
	_tmp16_ = bird_font_glyph_range_get_ranges (_tmp15_);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (ranges);
	ranges = _tmp17_;
	_tmp18_ = ranges;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	seg_count = (guint16) (((guint16) _tmp20_) + 1);
	seg_count_2 = (guint16) (seg_count * 2);
	search_range = (guint16) (2 * bird_font_largest_pow2 (seg_count));
	entry_selector = bird_font_largest_pow2_exponent (seg_count);
	range_shift = seg_count_2 - search_range;
	_tmp21_ = fd;
	bird_font_font_data_add_ushort (_tmp21_, (guint16) 4, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp22_ = fd;
	bird_font_font_data_add_ushort (_tmp22_, (guint16) ((16 + (8 * seg_count)) + gid_length), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp23_ = fd;
	bird_font_font_data_add_ushort (_tmp23_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp24_ = fd;
	bird_font_font_data_add_ushort (_tmp24_, seg_count_2, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp25_ = fd;
	bird_font_font_data_add_ushort (_tmp25_, search_range, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp26_ = fd;
	bird_font_font_data_add_ushort (_tmp26_, entry_selector, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp27_ = fd;
	bird_font_font_data_add_ushort (_tmp27_, range_shift, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	index = first_assigned;
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp28_;
		gint _u_size = 0;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _u_index = 0;
		_tmp28_ = ranges;
		_u_list = _tmp28_;
		_tmp29_ = _u_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_u_size = _tmp31_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp34_;
			gpointer _tmp35_;
			BirdFontUniRange* _tmp36_;
			_u_index = _u_index + 1;
			_tmp32_ = _u_index;
			_tmp33_ = _u_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _u_list;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _u_index);
			u = (BirdFontUniRange*) _tmp35_;
			_tmp36_ = u;
			if (_tmp36_->stop >= ((gunichar) 0xFFFF)) {
				g_warning ("CmapSubtableFormat4.vala:238: Not implemented yet.");
			} else {
				BirdFontFontData* _tmp37_;
				BirdFontUniRange* _tmp38_;
				BirdFontUniRange* _tmp39_;
				_tmp37_ = fd;
				_tmp38_ = u;
				bird_font_font_data_add_ushort (_tmp37_, (guint16) _tmp38_->stop, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (u);
					_g_object_unref0 (ranges);
					_bird_font_glyph_range_unref0 (glyph_range);
					_g_object_unref0 (fd);
					return;
				}
				_tmp39_ = u;
				index += (guint32) bird_font_uni_range_length (_tmp39_);
			}
			_g_object_unref0 (u);
		}
	}
	_tmp40_ = fd;
	bird_font_font_data_add_ushort (_tmp40_, (guint16) 0xFFFF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp41_ = fd;
	bird_font_font_data_add_ushort (_tmp41_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	index = first_assigned;
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp42_;
		gint _u_size = 0;
		GeeArrayList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _u_index = 0;
		_tmp42_ = ranges;
		_u_list = _tmp42_;
		_tmp43_ = _u_list;
		_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_u_size = _tmp45_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp46_;
			gint _tmp47_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp48_;
			gpointer _tmp49_;
			BirdFontUniRange* _tmp50_;
			_u_index = _u_index + 1;
			_tmp46_ = _u_index;
			_tmp47_ = _u_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _u_list;
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp48_, _u_index);
			u = (BirdFontUniRange*) _tmp49_;
			_tmp50_ = u;
			if (_tmp50_->start >= ((gunichar) 0xFFFF)) {
				g_warning ("CmapSubtableFormat4.vala:252: Not implemented yet.");
			} else {
				BirdFontFontData* _tmp51_;
				BirdFontUniRange* _tmp52_;
				BirdFontUniRange* _tmp53_;
				_tmp51_ = fd;
				_tmp52_ = u;
				bird_font_font_data_add_ushort (_tmp51_, (guint16) _tmp52_->start, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (u);
					_g_object_unref0 (ranges);
					_bird_font_glyph_range_unref0 (glyph_range);
					_g_object_unref0 (fd);
					return;
				}
				_tmp53_ = u;
				index += (guint32) bird_font_uni_range_length (_tmp53_);
			}
			_g_object_unref0 (u);
		}
	}
	_tmp54_ = fd;
	bird_font_font_data_add_ushort (_tmp54_, (guint16) 0xFFFF, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	index = first_assigned;
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp55_;
		gint _u_size = 0;
		GeeArrayList* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gint _u_index = 0;
		_tmp55_ = ranges;
		_u_list = _tmp55_;
		_tmp56_ = _u_list;
		_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
		_tmp58_ = _tmp57_;
		_u_size = _tmp58_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp59_;
			gint _tmp60_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp61_;
			gpointer _tmp62_;
			gboolean _tmp63_ = FALSE;
			BirdFontUniRange* _tmp64_;
			_u_index = _u_index + 1;
			_tmp59_ = _u_index;
			_tmp60_ = _u_size;
			if (!(_tmp59_ < _tmp60_)) {
				break;
			}
			_tmp61_ = _u_list;
			_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, _u_index);
			u = (BirdFontUniRange*) _tmp62_;
			_tmp64_ = u;
			if ((_tmp64_->start - index) > ((gunichar) 0xFFFF)) {
				BirdFontUniRange* _tmp65_;
				_tmp65_ = u;
				_tmp63_ = _tmp65_->start > ((gunichar) index);
			} else {
				_tmp63_ = FALSE;
			}
			if (_tmp63_) {
				g_warning ("CmapSubtableFormat4.vala:264: Need range offset.");
			} else {
				BirdFontFontData* _tmp66_;
				BirdFontUniRange* _tmp67_;
				BirdFontUniRange* _tmp68_;
				_tmp66_ = fd;
				_tmp67_ = u;
				bird_font_font_data_add_short (_tmp66_, (gint16) (index - _tmp67_->start), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (u);
					_g_object_unref0 (ranges);
					_bird_font_glyph_range_unref0 (glyph_range);
					_g_object_unref0 (fd);
					return;
				}
				_tmp68_ = u;
				index += (guint32) bird_font_uni_range_length (_tmp68_);
			}
			_g_object_unref0 (u);
		}
	}
	_tmp69_ = fd;
	bird_font_font_data_add_ushort (_tmp69_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp70_;
		gint _u_size = 0;
		GeeArrayList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _u_index = 0;
		_tmp70_ = ranges;
		_u_list = _tmp70_;
		_tmp71_ = _u_list;
		_tmp72_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_u_size = _tmp73_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp76_;
			gpointer _tmp77_;
			BirdFontUniRange* _tmp78_;
			_u_index = _u_index + 1;
			_tmp74_ = _u_index;
			_tmp75_ = _u_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _u_list;
			_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, _u_index);
			u = (BirdFontUniRange*) _tmp77_;
			_tmp78_ = u;
			if (_tmp78_->stop <= ((gunichar) 0xFFFF)) {
				BirdFontFontData* _tmp79_;
				_tmp79_ = fd;
				bird_font_font_data_add_ushort (_tmp79_, (guint16) 0, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (u);
					_g_object_unref0 (ranges);
					_bird_font_glyph_range_unref0 (glyph_range);
					_g_object_unref0 (fd);
					return;
				}
			} else {
				g_warning ("CmapSubtableFormat4.vala:277: Not implemented yet.");
			}
			_g_object_unref0 (u);
		}
	}
	_tmp80_ = fd;
	bird_font_font_data_add_ushort (_tmp80_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ranges);
		_bird_font_glyph_range_unref0 (glyph_range);
		_g_object_unref0 (fd);
		return;
	}
	_tmp81_ = fd;
	_tmp82_ = _g_object_ref0 (_tmp81_);
	_g_object_unref0 (self->priv->cmap_data);
	self->priv->cmap_data = _tmp82_;
	_g_object_unref0 (ranges);
	_bird_font_glyph_range_unref0 (glyph_range);
	_g_object_unref0 (fd);
}

static void
bird_font_cmap_subtable_format4_class_init (BirdFontCmapSubtableFormat4Class * klass,
                                            gpointer klass_data)
{
	bird_font_cmap_subtable_format4_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCmapSubtableFormat4_private_offset);
	((BirdFontCmapSubtableClass *) klass)->get_platform = (gushort (*) (BirdFontCmapSubtable*)) bird_font_cmap_subtable_format4_real_get_platform;
	((BirdFontCmapSubtableClass *) klass)->get_encoding = (gushort (*) (BirdFontCmapSubtable*)) bird_font_cmap_subtable_format4_real_get_encoding;
	((BirdFontCmapSubtableClass *) klass)->get_cmap_data = (BirdFontFontData* (*) (BirdFontCmapSubtable*)) bird_font_cmap_subtable_format4_real_get_cmap_data;
	((BirdFontCmapSubtableClass *) klass)->generate_cmap_data = (void (*) (BirdFontCmapSubtable*, BirdFontGlyfTable*, GError**)) bird_font_cmap_subtable_format4_real_generate_cmap_data;
	G_OBJECT_CLASS (klass)->finalize = bird_font_cmap_subtable_format4_finalize;
}

static void
bird_font_cmap_subtable_format4_instance_init (BirdFontCmapSubtableFormat4 * self,
                                               gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	BirdFontFontData* _tmp3_;
	self->priv = bird_font_cmap_subtable_format4_get_instance_private (self);
	self->priv->format = (guint16) 0;
	_tmp0_ = g_int64_hash;
	_tmp1_ = g_int_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	self->priv->table = _tmp2_;
	self->priv->length = (guint16) 0;
	_tmp3_ = bird_font_font_data_new ((guint32) 1024);
	self->priv->cmap_data = _tmp3_;
}

static void
bird_font_cmap_subtable_format4_finalize (GObject * obj)
{
	BirdFontCmapSubtableFormat4 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CMAP_SUBTABLE_FORMAT4, BirdFontCmapSubtableFormat4);
	_g_hash_table_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->cmap_data);
	G_OBJECT_CLASS (bird_font_cmap_subtable_format4_parent_class)->finalize (obj);
}

/** Format 4 cmap subtable */
static GType
bird_font_cmap_subtable_format4_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCmapSubtableFormat4Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_cmap_subtable_format4_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCmapSubtableFormat4), 0, (GInstanceInitFunc) bird_font_cmap_subtable_format4_instance_init, NULL };
	GType bird_font_cmap_subtable_format4_type_id;
	bird_font_cmap_subtable_format4_type_id = g_type_register_static (BIRD_FONT_TYPE_CMAP_SUBTABLE, "BirdFontCmapSubtableFormat4", &g_define_type_info, 0);
	BirdFontCmapSubtableFormat4_private_offset = g_type_add_instance_private (bird_font_cmap_subtable_format4_type_id, sizeof (BirdFontCmapSubtableFormat4Private));
	return bird_font_cmap_subtable_format4_type_id;
}

GType
bird_font_cmap_subtable_format4_get_type (void)
{
	static volatile gsize bird_font_cmap_subtable_format4_type_id__once = 0;
	if (g_once_init_enter (&bird_font_cmap_subtable_format4_type_id__once)) {
		GType bird_font_cmap_subtable_format4_type_id;
		bird_font_cmap_subtable_format4_type_id = bird_font_cmap_subtable_format4_get_type_once ();
		g_once_init_leave (&bird_font_cmap_subtable_format4_type_id__once, bird_font_cmap_subtable_format4_type_id);
	}
	return bird_font_cmap_subtable_format4_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

