/* UnicodeRangeBits.c generated by valac 0.56.17, the Vala compiler
 * generated from UnicodeRangeBits.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT (bird_font_unicode_range_bits_range_bit_get_type ())
#define BIRD_FONT_UNICODE_RANGE_BITS_RANGE_BIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT, BirdFontUnicodeRangeBitsRangeBit))
#define BIRD_FONT_UNICODE_RANGE_BITS_RANGE_BIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT, BirdFontUnicodeRangeBitsRangeBitClass))
#define BIRD_FONT_UNICODE_RANGE_BITS_IS_RANGE_BIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT))
#define BIRD_FONT_UNICODE_RANGE_BITS_IS_RANGE_BIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT))
#define BIRD_FONT_UNICODE_RANGE_BITS_RANGE_BIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT, BirdFontUnicodeRangeBitsRangeBitClass))

typedef struct _BirdFontUnicodeRangeBitsRangeBit BirdFontUnicodeRangeBitsRangeBit;
typedef struct _BirdFontUnicodeRangeBitsRangeBitClass BirdFontUnicodeRangeBitsRangeBitClass;
enum  {
	BIRD_FONT_UNICODE_RANGE_BITS_0_PROPERTY,
	BIRD_FONT_UNICODE_RANGE_BITS_NUM_PROPERTIES
};
static GParamSpec* bird_font_unicode_range_bits_properties[BIRD_FONT_UNICODE_RANGE_BITS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BirdFontUnicodeRangeBitsRangeBitPrivate BirdFontUnicodeRangeBitsRangeBitPrivate;
enum  {
	BIRD_FONT_UNICODE_RANGE_BITS_RANGE_BIT_0_PROPERTY,
	BIRD_FONT_UNICODE_RANGE_BITS_RANGE_BIT_NUM_PROPERTIES
};
static GParamSpec* bird_font_unicode_range_bits_range_bit_properties[BIRD_FONT_UNICODE_RANGE_BITS_RANGE_BIT_NUM_PROPERTIES];

struct _BirdFontUnicodeRangeBitsPrivate {
	GeeArrayList* bits;
};

struct _BirdFontUnicodeRangeBitsRangeBit {
	GObject parent_instance;
	BirdFontUnicodeRangeBitsRangeBitPrivate * priv;
	gint32 bit;
	BirdFontUniRange* range;
};

struct _BirdFontUnicodeRangeBitsRangeBitClass {
	GObjectClass parent_class;
};

static gint BirdFontUnicodeRangeBits_private_offset;
static gpointer bird_font_unicode_range_bits_parent_class = NULL;
static gpointer bird_font_unicode_range_bits_range_bit_parent_class = NULL;

static GType bird_font_unicode_range_bits_range_bit_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void bird_font_unicode_range_bits_add_ranges (BirdFontUnicodeRangeBits* self);
static gint bird_font_unicode_range_bits_get_bit (BirdFontUnicodeRangeBits* self,
                                           gunichar c);
static void bird_font_unicode_range_bits_set_bit (BirdFontUnicodeRangeBits* self,
                                           gint bit,
                                           guint32* r0,
                                           guint32* r1,
                                           guint32* r2,
                                           guint32* r3);
static void bird_font_unicode_range_bits_add_range (BirdFontUnicodeRangeBits* self,
                                             gint bit,
                                             gunichar start,
                                             gunichar stop);
static BirdFontUnicodeRangeBitsRangeBit* bird_font_unicode_range_bits_range_bit_new (gint bit,
                                                                              gunichar start,
                                                                              gunichar stop);
static BirdFontUnicodeRangeBitsRangeBit* bird_font_unicode_range_bits_range_bit_construct (GType object_type,
                                                                                    gint bit,
                                                                                    gunichar start,
                                                                                    gunichar stop);
static void bird_font_unicode_range_bits_range_bit_finalize (GObject * obj);
static GType bird_font_unicode_range_bits_range_bit_get_type_once (void);
static void bird_font_unicode_range_bits_finalize (GObject * obj);
static GType bird_font_unicode_range_bits_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_unicode_range_bits_get_instance_private (BirdFontUnicodeRangeBits* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontUnicodeRangeBits_private_offset);
}

BirdFontUnicodeRangeBits*
bird_font_unicode_range_bits_construct (GType object_type)
{
	BirdFontUnicodeRangeBits * self = NULL;
	self = (BirdFontUnicodeRangeBits*) g_object_new (object_type, NULL);
	bird_font_unicode_range_bits_add_ranges (self);
	return self;
}

BirdFontUnicodeRangeBits*
bird_font_unicode_range_bits_new (void)
{
	return bird_font_unicode_range_bits_construct (BIRD_FONT_TYPE_UNICODE_RANGE_BITS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_unicode_range_bits_get_ranges (BirdFontUnicodeRangeBits* self,
                                         BirdFontFont* font,
                                         guint32* r0,
                                         guint32* r1,
                                         guint32* r2,
                                         guint32* r3)
{
	guint32 _vala_r0 = 0U;
	guint32 _vala_r1 = 0U;
	guint32 _vala_r2 = 0U;
	guint32 _vala_r3 = 0U;
	guint32 index = 0U;
	BirdFontGlyphCollection* gl = NULL;
	BirdFontGlyphCollection* g = NULL;
	gint bit = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_vala_r0 = (guint32) 0;
	_vala_r1 = (guint32) 0;
	_vala_r2 = (guint32) 0;
	_vala_r3 = (guint32) 0;
	{
		gboolean _tmp0_ = FALSE;
		index = (guint32) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			BirdFontGlyphCollection* _tmp2_;
			BirdFontGlyphCollection* _tmp3_;
			BirdFontGlyphCollection* _tmp4_;
			BirdFontGlyphCollection* _tmp5_;
			BirdFontGlyphCollection* _tmp6_;
			if (!_tmp0_) {
				guint32 _tmp1_;
				_tmp1_ = index;
				index = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = bird_font_font_get_glyph_collection_index (font, (gunichar) index);
			_g_object_unref0 (gl);
			gl = _tmp2_;
			_tmp3_ = gl;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = gl;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			_g_object_unref0 (g);
			g = _tmp5_;
			_tmp6_ = g;
			if (!bird_font_glyph_collection_is_unassigned (_tmp6_)) {
				BirdFontGlyphCollection* _tmp7_;
				_tmp7_ = g;
				bit = bird_font_unicode_range_bits_get_bit (self, bird_font_glyph_collection_get_unicode_character (_tmp7_));
				if (G_LIKELY (bit >= 0)) {
					bird_font_unicode_range_bits_set_bit (self, bit, &_vala_r0, &_vala_r1, &_vala_r2, &_vala_r3);
				} else {
					BirdFontGlyphCollection* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp8_ = g;
					_tmp9_ = bird_font_glyph_collection_get_name (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = string_to_string (_tmp10_);
					_tmp12_ = g_strconcat ("Can't find range for character ", _tmp11_, ".", NULL);
					_tmp13_ = _tmp12_;
					g_warning ("UnicodeRangeBits.vala:43: %s", _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp10_);
				}
			}
		}
	}
	_g_object_unref0 (g);
	_g_object_unref0 (gl);
	if (r0) {
		*r0 = _vala_r0;
	}
	if (r1) {
		*r1 = _vala_r1;
	}
	if (r2) {
		*r2 = _vala_r2;
	}
	if (r3) {
		*r3 = _vala_r3;
	}
}

static void
bird_font_unicode_range_bits_set_bit (BirdFontUnicodeRangeBits* self,
                                      gint bit,
                                      guint32* r0,
                                      guint32* r1,
                                      guint32* r2,
                                      guint32* r3)
{
	static const gint length = 32;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bit;
	if ((0 <= _tmp0_) && (_tmp0_ <= length)) {
		*r0 = (*r0) | (1 << bit);
	} else {
		gint _tmp1_;
		_tmp1_ = bit;
		if ((length <= _tmp1_) && (_tmp1_ <= (2 * length))) {
			*r1 = (*r1) | (1 << (bit - length));
		} else {
			gint _tmp2_;
			_tmp2_ = bit;
			if (((2 * length) <= _tmp2_) && (_tmp2_ <= (3 * length))) {
				*r2 = (*r2) | (1 << (bit - (2 * length)));
			} else {
				gint _tmp3_;
				_tmp3_ = bit;
				if (((3 * length) <= _tmp3_) && (_tmp3_ <= 122)) {
					*r3 = (*r3) | (1 << (bit - (3 * length)));
				} else {
					if (G_UNLIKELY (bit > 122)) {
						g_warning ("UnicodeRangeBits.vala:61: Reserved bit");
					}
				}
			}
		}
	}
}

static gint
bird_font_unicode_range_bits_get_bit (BirdFontUnicodeRangeBits* self,
                                      gunichar c)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	{
		GeeArrayList* _b_list = NULL;
		GeeArrayList* _tmp0_;
		gint _b_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _b_index = 0;
		_tmp0_ = self->priv->bits;
		_b_list = _tmp0_;
		_tmp1_ = _b_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_b_size = _tmp3_;
		_b_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontUnicodeRangeBitsRangeBit* b = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontUnicodeRangeBitsRangeBit* _tmp8_;
			BirdFontUniRange* _tmp9_;
			_b_index = _b_index + 1;
			_tmp4_ = _b_index;
			_tmp5_ = _b_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _b_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _b_index);
			b = (BirdFontUnicodeRangeBitsRangeBit*) _tmp7_;
			_tmp8_ = b;
			_tmp9_ = _tmp8_->range;
			if (bird_font_uni_range_has_character (_tmp9_, c)) {
				BirdFontUnicodeRangeBitsRangeBit* _tmp10_;
				_tmp10_ = b;
				result = (gint) _tmp10_->bit;
				_g_object_unref0 (b);
				return result;
			}
			_g_object_unref0 (b);
		}
	}
	result = -1;
	return result;
}

static void
bird_font_unicode_range_bits_add_range (BirdFontUnicodeRangeBits* self,
                                        gint bit,
                                        gunichar start,
                                        gunichar stop)
{
	GeeArrayList* _tmp0_;
	BirdFontUnicodeRangeBitsRangeBit* _tmp1_;
	BirdFontUnicodeRangeBitsRangeBit* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bits;
	_tmp1_ = bird_font_unicode_range_bits_range_bit_new (bit, start, stop);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
bird_font_unicode_range_bits_add_ranges (BirdFontUnicodeRangeBits* self)
{
	g_return_if_fail (self != NULL);
	bird_font_unicode_range_bits_add_range (self, 0, (gunichar) 0x0000, (gunichar) 0x007F);
	bird_font_unicode_range_bits_add_range (self, 1, (gunichar) 0x0080, (gunichar) 0x00FF);
	bird_font_unicode_range_bits_add_range (self, 2, (gunichar) 0x0100, (gunichar) 0x017F);
	bird_font_unicode_range_bits_add_range (self, 3, (gunichar) 0x0180, (gunichar) 0x024F);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0x0250, (gunichar) 0x02AF);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0x1D00, (gunichar) 0x1D7F);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0x1D80, (gunichar) 0x1DBF);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0x02B0, (gunichar) 0x02FF);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0xA700, (gunichar) 0xA71F);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0x0300, (gunichar) 0x036F);
	bird_font_unicode_range_bits_add_range (self, 4, (gunichar) 0x1DC0, (gunichar) 0x1DFF);
	bird_font_unicode_range_bits_add_range (self, 7, (gunichar) 0x0370, (gunichar) 0x03FF);
	bird_font_unicode_range_bits_add_range (self, 8, (gunichar) 0x2C80, (gunichar) 0x2CFF);
	bird_font_unicode_range_bits_add_range (self, 9, (gunichar) 0x0400, (gunichar) 0x04FF);
	bird_font_unicode_range_bits_add_range (self, 9, (gunichar) 0x0500, (gunichar) 0x052F);
	bird_font_unicode_range_bits_add_range (self, 9, (gunichar) 0x2DE0, (gunichar) 0x2DFF);
	bird_font_unicode_range_bits_add_range (self, 9, (gunichar) 0xA640, (gunichar) 0xA69F);
	bird_font_unicode_range_bits_add_range (self, 10, (gunichar) 0x0530, (gunichar) 0x058F);
	bird_font_unicode_range_bits_add_range (self, 11, (gunichar) 0x0590, (gunichar) 0x05FF);
	bird_font_unicode_range_bits_add_range (self, 12, (gunichar) 0xA500, (gunichar) 0xA63F);
	bird_font_unicode_range_bits_add_range (self, 13, (gunichar) 0x0600, (gunichar) 0x06FF);
	bird_font_unicode_range_bits_add_range (self, 13, (gunichar) 0x0750, (gunichar) 0x077F);
	bird_font_unicode_range_bits_add_range (self, 14, (gunichar) 0x07C0, (gunichar) 0x07FF);
	bird_font_unicode_range_bits_add_range (self, 15, (gunichar) 0x0900, (gunichar) 0x097F);
	bird_font_unicode_range_bits_add_range (self, 16, (gunichar) 0x0980, (gunichar) 0x09FF);
	bird_font_unicode_range_bits_add_range (self, 17, (gunichar) 0x0A00, (gunichar) 0x0A7F);
	bird_font_unicode_range_bits_add_range (self, 18, (gunichar) 0x0A80, (gunichar) 0x0AFF);
	bird_font_unicode_range_bits_add_range (self, 19, (gunichar) 0x0B00, (gunichar) 0x0B7F);
	bird_font_unicode_range_bits_add_range (self, 20, (gunichar) 0x0B80, (gunichar) 0x0BFF);
	bird_font_unicode_range_bits_add_range (self, 21, (gunichar) 0x0C00, (gunichar) 0x0C7F);
	bird_font_unicode_range_bits_add_range (self, 22, (gunichar) 0x0C80, (gunichar) 0x0CFF);
	bird_font_unicode_range_bits_add_range (self, 23, (gunichar) 0x0D00, (gunichar) 0x0D7F);
	bird_font_unicode_range_bits_add_range (self, 24, (gunichar) 0x0E00, (gunichar) 0x0E7F);
	bird_font_unicode_range_bits_add_range (self, 25, (gunichar) 0x0E80, (gunichar) 0x0EFF);
	bird_font_unicode_range_bits_add_range (self, 26, (gunichar) 0x10A0, (gunichar) 0x10FF);
	bird_font_unicode_range_bits_add_range (self, 26, (gunichar) 0x2D00, (gunichar) 0x2D2F);
	bird_font_unicode_range_bits_add_range (self, 27, (gunichar) 0x1B00, (gunichar) 0x1B7F);
	bird_font_unicode_range_bits_add_range (self, 28, (gunichar) 0x1100, (gunichar) 0x11FF);
	bird_font_unicode_range_bits_add_range (self, 29, (gunichar) 0x1E00, (gunichar) 0x1EFF);
	bird_font_unicode_range_bits_add_range (self, 29, (gunichar) 0x2C60, (gunichar) 0x2C7F);
	bird_font_unicode_range_bits_add_range (self, 29, (gunichar) 0xA720, (gunichar) 0xA7FF);
	bird_font_unicode_range_bits_add_range (self, 30, (gunichar) 0x1F00, (gunichar) 0x1FFF);
	bird_font_unicode_range_bits_add_range (self, 31, (gunichar) 0x2000, (gunichar) 0x206F);
	bird_font_unicode_range_bits_add_range (self, 31, (gunichar) 0x2E00, (gunichar) 0x2E7F);
	bird_font_unicode_range_bits_add_range (self, 32, (gunichar) 0x2070, (gunichar) 0x209F);
	bird_font_unicode_range_bits_add_range (self, 33, (gunichar) 0x20A0, (gunichar) 0x20CF);
	bird_font_unicode_range_bits_add_range (self, 34, (gunichar) 0x20D0, (gunichar) 0x20FF);
	bird_font_unicode_range_bits_add_range (self, 35, (gunichar) 0x2100, (gunichar) 0x214F);
	bird_font_unicode_range_bits_add_range (self, 36, (gunichar) 0x2150, (gunichar) 0x218F);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x2190, (gunichar) 0x21FF);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x27F0, (gunichar) 0x27FF);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x2900, (gunichar) 0x297F);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x2B00, (gunichar) 0x2BFF);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x2200, (gunichar) 0x22FF);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x2A00, (gunichar) 0x2AFF);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x27C0, (gunichar) 0x27EF);
	bird_font_unicode_range_bits_add_range (self, 37, (gunichar) 0x2980, (gunichar) 0x29FF);
	bird_font_unicode_range_bits_add_range (self, 39, (gunichar) 0x2300, (gunichar) 0x23FF);
	bird_font_unicode_range_bits_add_range (self, 40, (gunichar) 0x2400, (gunichar) 0x243F);
	bird_font_unicode_range_bits_add_range (self, 41, (gunichar) 0x2440, (gunichar) 0x245F);
	bird_font_unicode_range_bits_add_range (self, 42, (gunichar) 0x2460, (gunichar) 0x24FF);
	bird_font_unicode_range_bits_add_range (self, 43, (gunichar) 0x2500, (gunichar) 0x257F);
	bird_font_unicode_range_bits_add_range (self, 44, (gunichar) 0x2580, (gunichar) 0x259F);
	bird_font_unicode_range_bits_add_range (self, 45, (gunichar) 0x25A0, (gunichar) 0x25FF);
	bird_font_unicode_range_bits_add_range (self, 46, (gunichar) 0x2600, (gunichar) 0x26FF);
	bird_font_unicode_range_bits_add_range (self, 47, (gunichar) 0x2700, (gunichar) 0x27BF);
	bird_font_unicode_range_bits_add_range (self, 48, (gunichar) 0x3000, (gunichar) 0x303F);
	bird_font_unicode_range_bits_add_range (self, 49, (gunichar) 0x3040, (gunichar) 0x309F);
	bird_font_unicode_range_bits_add_range (self, 50, (gunichar) 0x30A0, (gunichar) 0x30FF);
	bird_font_unicode_range_bits_add_range (self, 50, (gunichar) 0x31F0, (gunichar) 0x31FF);
	bird_font_unicode_range_bits_add_range (self, 50, (gunichar) 0x3100, (gunichar) 0x312F);
	bird_font_unicode_range_bits_add_range (self, 50, (gunichar) 0x31A0, (gunichar) 0x31BF);
	bird_font_unicode_range_bits_add_range (self, 52, (gunichar) 0x3130, (gunichar) 0x318F);
	bird_font_unicode_range_bits_add_range (self, 53, (gunichar) 0xA840, (gunichar) 0xA87F);
	bird_font_unicode_range_bits_add_range (self, 54, (gunichar) 0x3200, (gunichar) 0x32FF);
	bird_font_unicode_range_bits_add_range (self, 55, (gunichar) 0x3300, (gunichar) 0x33FF);
	bird_font_unicode_range_bits_add_range (self, 56, (gunichar) 0xAC00, (gunichar) 0xD7AF);
	bird_font_unicode_range_bits_add_range (self, 57, (gunichar) 0xD800, (gunichar) 0xDFFF);
	bird_font_unicode_range_bits_add_range (self, 58, (gunichar) 0x10900, (gunichar) 0x1091F);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x4E00, (gunichar) 0x9FFF);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x2E80, (gunichar) 0x2EFF);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x2F00, (gunichar) 0x2FDF);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x2FF0, (gunichar) 0x2FFF);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x3400, (gunichar) 0x4DBF);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x20000, (gunichar) 0x2A6DF);
	bird_font_unicode_range_bits_add_range (self, 59, (gunichar) 0x3190, (gunichar) 0x319F);
	bird_font_unicode_range_bits_add_range (self, 60, (gunichar) 0xE000, (gunichar) 0xF8FF);
	bird_font_unicode_range_bits_add_range (self, 61, (gunichar) 0x31C0, (gunichar) 0x31EF);
	bird_font_unicode_range_bits_add_range (self, 61, (gunichar) 0xF900, (gunichar) 0xFAFF);
	bird_font_unicode_range_bits_add_range (self, 61, (gunichar) 0x2F800, (gunichar) 0x2Fa1F);
	bird_font_unicode_range_bits_add_range (self, 61, (gunichar) 0xFB00, (gunichar) 0xFB4F);
	bird_font_unicode_range_bits_add_range (self, 63, (gunichar) 0xFB50, (gunichar) 0xFDFF);
	bird_font_unicode_range_bits_add_range (self, 64, (gunichar) 0xFE20, (gunichar) 0xFE2F);
	bird_font_unicode_range_bits_add_range (self, 65, (gunichar) 0xFE10, (gunichar) 0xFE1F);
	bird_font_unicode_range_bits_add_range (self, 65, (gunichar) 0xFE30, (gunichar) 0xFE4F);
	bird_font_unicode_range_bits_add_range (self, 66, (gunichar) 0xFE50, (gunichar) 0xFE6F);
	bird_font_unicode_range_bits_add_range (self, 67, (gunichar) 0xFE70, (gunichar) 0xFEFF);
	bird_font_unicode_range_bits_add_range (self, 68, (gunichar) 0xFF00, (gunichar) 0xFFEF);
	bird_font_unicode_range_bits_add_range (self, 69, (gunichar) 0xFFF0, (gunichar) 0xFFFF);
	bird_font_unicode_range_bits_add_range (self, 70, (gunichar) 0x0F00, (gunichar) 0x0FFF);
	bird_font_unicode_range_bits_add_range (self, 71, (gunichar) 0x0700, (gunichar) 0x074F);
	bird_font_unicode_range_bits_add_range (self, 72, (gunichar) 0x0780, (gunichar) 0x07BF);
	bird_font_unicode_range_bits_add_range (self, 73, (gunichar) 0x0D80, (gunichar) 0x0DFF);
	bird_font_unicode_range_bits_add_range (self, 74, (gunichar) 0x1000, (gunichar) 0x109F);
	bird_font_unicode_range_bits_add_range (self, 75, (gunichar) 0x1200, (gunichar) 0x137F);
	bird_font_unicode_range_bits_add_range (self, 75, (gunichar) 0x1380, (gunichar) 0x139F);
	bird_font_unicode_range_bits_add_range (self, 75, (gunichar) 0x2D80, (gunichar) 0x2DDF);
	bird_font_unicode_range_bits_add_range (self, 76, (gunichar) 0x13A0, (gunichar) 0x13FF);
	bird_font_unicode_range_bits_add_range (self, 77, (gunichar) 0x1400, (gunichar) 0x167F);
	bird_font_unicode_range_bits_add_range (self, 78, (gunichar) 0x1680, (gunichar) 0x169F);
	bird_font_unicode_range_bits_add_range (self, 79, (gunichar) 0x16A0, (gunichar) 0x16FF);
	bird_font_unicode_range_bits_add_range (self, 80, (gunichar) 0x1780, (gunichar) 0x17FF);
	bird_font_unicode_range_bits_add_range (self, 80, (gunichar) 0x19E0, (gunichar) 0x19FF);
	bird_font_unicode_range_bits_add_range (self, 81, (gunichar) 0x1800, (gunichar) 0x18AF);
	bird_font_unicode_range_bits_add_range (self, 82, (gunichar) 0x2800, (gunichar) 0x28FF);
	bird_font_unicode_range_bits_add_range (self, 83, (gunichar) 0xA000, (gunichar) 0xA48F);
	bird_font_unicode_range_bits_add_range (self, 83, (gunichar) 0xA490, (gunichar) 0xA4CF);
	bird_font_unicode_range_bits_add_range (self, 83, (gunichar) 0x1700, (gunichar) 0x171F);
	bird_font_unicode_range_bits_add_range (self, 83, (gunichar) 0x1720, (gunichar) 0x173F);
	bird_font_unicode_range_bits_add_range (self, 83, (gunichar) 0x1740, (gunichar) 0x175F);
	bird_font_unicode_range_bits_add_range (self, 83, (gunichar) 0x1760, (gunichar) 0x177F);
	bird_font_unicode_range_bits_add_range (self, 85, (gunichar) 0x10300, (gunichar) 0x1032F);
	bird_font_unicode_range_bits_add_range (self, 86, (gunichar) 0x10330, (gunichar) 0x1034F);
	bird_font_unicode_range_bits_add_range (self, 87, (gunichar) 0x10400, (gunichar) 0x1044F);
	bird_font_unicode_range_bits_add_range (self, 88, (gunichar) 0x1D000, (gunichar) 0x1D0FF);
	bird_font_unicode_range_bits_add_range (self, 88, (gunichar) 0x1D100, (gunichar) 0x1D1FF);
	bird_font_unicode_range_bits_add_range (self, 88, (gunichar) 0x1D200, (gunichar) 0x1D24F);
	bird_font_unicode_range_bits_add_range (self, 89, (gunichar) 0x1D400, (gunichar) 0x1D7FF);
	bird_font_unicode_range_bits_add_range (self, 90, (gunichar) 0xFF000, (gunichar) 0xFFFFD);
	bird_font_unicode_range_bits_add_range (self, 90, (gunichar) 0x100000, (gunichar) 0x10FFFD);
	bird_font_unicode_range_bits_add_range (self, 90, (gunichar) 0xFE00, (gunichar) 0xFE0F);
	bird_font_unicode_range_bits_add_range (self, 90, (gunichar) 0xE0100, (gunichar) 0xE01EF);
	bird_font_unicode_range_bits_add_range (self, 92, (gunichar) 0xE0000, (gunichar) 0xE007F);
	bird_font_unicode_range_bits_add_range (self, 93, (gunichar) 0x1900, (gunichar) 0x194F);
	bird_font_unicode_range_bits_add_range (self, 94, (gunichar) 0x1950, (gunichar) 0x197F);
	bird_font_unicode_range_bits_add_range (self, 95, (gunichar) 0x1980, (gunichar) 0x19DF);
	bird_font_unicode_range_bits_add_range (self, 96, (gunichar) 0x1A00, (gunichar) 0x1A1F);
	bird_font_unicode_range_bits_add_range (self, 97, (gunichar) 0x2C00, (gunichar) 0x2C5F);
	bird_font_unicode_range_bits_add_range (self, 98, (gunichar) 0x2D30, (gunichar) 0x2D7F);
	bird_font_unicode_range_bits_add_range (self, 99, (gunichar) 0x4DC0, (gunichar) 0x4DFF);
	bird_font_unicode_range_bits_add_range (self, 100, (gunichar) 0xA800, (gunichar) 0xA82F);
	bird_font_unicode_range_bits_add_range (self, 101, (gunichar) 0x10000, (gunichar) 0x1007F);
	bird_font_unicode_range_bits_add_range (self, 101, (gunichar) 0x10080, (gunichar) 0x100FF);
	bird_font_unicode_range_bits_add_range (self, 101, (gunichar) 0x10100, (gunichar) 0x1013F);
	bird_font_unicode_range_bits_add_range (self, 102, (gunichar) 0x10140, (gunichar) 0x1018F);
	bird_font_unicode_range_bits_add_range (self, 103, (gunichar) 0x10380, (gunichar) 0x1039F);
	bird_font_unicode_range_bits_add_range (self, 104, (gunichar) 0x103A0, (gunichar) 0x103DF);
	bird_font_unicode_range_bits_add_range (self, 105, (gunichar) 0x10450, (gunichar) 0x1047F);
	bird_font_unicode_range_bits_add_range (self, 106, (gunichar) 0x10480, (gunichar) 0x104AF);
	bird_font_unicode_range_bits_add_range (self, 107, (gunichar) 0x10800, (gunichar) 0x1083F);
	bird_font_unicode_range_bits_add_range (self, 108, (gunichar) 0x10A00, (gunichar) 0x10A5F);
	bird_font_unicode_range_bits_add_range (self, 109, (gunichar) 0x1D300, (gunichar) 0x1D35F);
	bird_font_unicode_range_bits_add_range (self, 110, (gunichar) 0x12000, (gunichar) 0x123FF);
	bird_font_unicode_range_bits_add_range (self, 110, (gunichar) 0x12400, (gunichar) 0x1247F);
	bird_font_unicode_range_bits_add_range (self, 111, (gunichar) 0x1D360, (gunichar) 0x1D37F);
	bird_font_unicode_range_bits_add_range (self, 112, (gunichar) 0x1B80, (gunichar) 0x1BBF);
	bird_font_unicode_range_bits_add_range (self, 113, (gunichar) 0x1C00, (gunichar) 0x1C4F);
	bird_font_unicode_range_bits_add_range (self, 114, (gunichar) 0x1C50, (gunichar) 0x1C7F);
	bird_font_unicode_range_bits_add_range (self, 115, (gunichar) 0xA880, (gunichar) 0xA8DF);
	bird_font_unicode_range_bits_add_range (self, 116, (gunichar) 0xA900, (gunichar) 0xA92F);
	bird_font_unicode_range_bits_add_range (self, 117, (gunichar) 0xA930, (gunichar) 0xA95F);
	bird_font_unicode_range_bits_add_range (self, 118, (gunichar) 0xAA00, (gunichar) 0xAA5F);
	bird_font_unicode_range_bits_add_range (self, 119, (gunichar) 0x10190, (gunichar) 0x101CF);
	bird_font_unicode_range_bits_add_range (self, 120, (gunichar) 0x101D0, (gunichar) 0x101FF);
	bird_font_unicode_range_bits_add_range (self, 121, (gunichar) 0x102A0, (gunichar) 0x102DF);
	bird_font_unicode_range_bits_add_range (self, 121, (gunichar) 0x10280, (gunichar) 0x1029F);
	bird_font_unicode_range_bits_add_range (self, 121, (gunichar) 0x10920, (gunichar) 0x1093F);
	bird_font_unicode_range_bits_add_range (self, 122, (gunichar) 0x1F030, (gunichar) 0x1F09F);
	bird_font_unicode_range_bits_add_range (self, 122, (gunichar) 0x1F000, (gunichar) 0x1F02F);
}

static BirdFontUnicodeRangeBitsRangeBit*
bird_font_unicode_range_bits_range_bit_construct (GType object_type,
                                                  gint bit,
                                                  gunichar start,
                                                  gunichar stop)
{
	BirdFontUnicodeRangeBitsRangeBit * self = NULL;
	BirdFontUniRange* _tmp0_;
	self = (BirdFontUnicodeRangeBitsRangeBit*) g_object_new (object_type, NULL);
	_tmp0_ = bird_font_uni_range_new (start, stop);
	_g_object_unref0 (self->range);
	self->range = _tmp0_;
	return self;
}

static BirdFontUnicodeRangeBitsRangeBit*
bird_font_unicode_range_bits_range_bit_new (gint bit,
                                            gunichar start,
                                            gunichar stop)
{
	return bird_font_unicode_range_bits_range_bit_construct (BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT, bit, start, stop);
}

static void
bird_font_unicode_range_bits_range_bit_class_init (BirdFontUnicodeRangeBitsRangeBitClass * klass,
                                                   gpointer klass_data)
{
	bird_font_unicode_range_bits_range_bit_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_unicode_range_bits_range_bit_finalize;
}

static void
bird_font_unicode_range_bits_range_bit_instance_init (BirdFontUnicodeRangeBitsRangeBit * self,
                                                      gpointer klass)
{
	self->bit = (gint32) 0;
}

static void
bird_font_unicode_range_bits_range_bit_finalize (GObject * obj)
{
	BirdFontUnicodeRangeBitsRangeBit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT, BirdFontUnicodeRangeBitsRangeBit);
	_g_object_unref0 (self->range);
	G_OBJECT_CLASS (bird_font_unicode_range_bits_range_bit_parent_class)->finalize (obj);
}

static GType
bird_font_unicode_range_bits_range_bit_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontUnicodeRangeBitsRangeBitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_unicode_range_bits_range_bit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontUnicodeRangeBitsRangeBit), 0, (GInstanceInitFunc) bird_font_unicode_range_bits_range_bit_instance_init, NULL };
	GType bird_font_unicode_range_bits_range_bit_type_id;
	bird_font_unicode_range_bits_range_bit_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontUnicodeRangeBitsRangeBit", &g_define_type_info, 0);
	return bird_font_unicode_range_bits_range_bit_type_id;
}

static GType
bird_font_unicode_range_bits_range_bit_get_type (void)
{
	static volatile gsize bird_font_unicode_range_bits_range_bit_type_id__once = 0;
	if (g_once_init_enter (&bird_font_unicode_range_bits_range_bit_type_id__once)) {
		GType bird_font_unicode_range_bits_range_bit_type_id;
		bird_font_unicode_range_bits_range_bit_type_id = bird_font_unicode_range_bits_range_bit_get_type_once ();
		g_once_init_leave (&bird_font_unicode_range_bits_range_bit_type_id__once, bird_font_unicode_range_bits_range_bit_type_id);
	}
	return bird_font_unicode_range_bits_range_bit_type_id__once;
}

static void
bird_font_unicode_range_bits_class_init (BirdFontUnicodeRangeBitsClass * klass,
                                         gpointer klass_data)
{
	bird_font_unicode_range_bits_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontUnicodeRangeBits_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_unicode_range_bits_finalize;
}

static void
bird_font_unicode_range_bits_instance_init (BirdFontUnicodeRangeBits * self,
                                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_unicode_range_bits_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_UNICODE_RANGE_BITS_TYPE_RANGE_BIT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->bits = _tmp0_;
}

static void
bird_font_unicode_range_bits_finalize (GObject * obj)
{
	BirdFontUnicodeRangeBits * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_UNICODE_RANGE_BITS, BirdFontUnicodeRangeBits);
	_g_object_unref0 (self->priv->bits);
	G_OBJECT_CLASS (bird_font_unicode_range_bits_parent_class)->finalize (obj);
}

static GType
bird_font_unicode_range_bits_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontUnicodeRangeBitsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_unicode_range_bits_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontUnicodeRangeBits), 0, (GInstanceInitFunc) bird_font_unicode_range_bits_instance_init, NULL };
	GType bird_font_unicode_range_bits_type_id;
	bird_font_unicode_range_bits_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontUnicodeRangeBits", &g_define_type_info, 0);
	BirdFontUnicodeRangeBits_private_offset = g_type_add_instance_private (bird_font_unicode_range_bits_type_id, sizeof (BirdFontUnicodeRangeBitsPrivate));
	return bird_font_unicode_range_bits_type_id;
}

GType
bird_font_unicode_range_bits_get_type (void)
{
	static volatile gsize bird_font_unicode_range_bits_type_id__once = 0;
	if (g_once_init_enter (&bird_font_unicode_range_bits_type_id__once)) {
		GType bird_font_unicode_range_bits_type_id;
		bird_font_unicode_range_bits_type_id = bird_font_unicode_range_bits_get_type_once ();
		g_once_init_leave (&bird_font_unicode_range_bits_type_id__once, bird_font_unicode_range_bits_type_id);
	}
	return bird_font_unicode_range_bits_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

