/* mobiReader.c generated by valac 0.56.18, the Vala compiler
 * generated from mobiReader.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for parsing MOBI file formats
* The Mobi unpack utility mobi_unpack.py (v0.47) by adamselene
* is used to extract the contents of the mobi file
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>
#include <granite.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE _ ("Problem in extracting contents of book. Ensure there is a valid eBook " \
"file here: ")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE _ ("Invalid content found. Ensure there is a valid eBook file here: ")
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION "/tmp/" BOOKWORM_APP_CONSTANTS_bookworm_id "/"
#define BOOKWORM_APP_CONSTANTS_INSTALL_MOBILIB_DIR "/usr/share/com.github.babluboy.bookworm/scripts/mobi_lib"
#define BOOKWORM_APP_CONSTANTS_MOBIUNPACK_SCRIPT_LOCATION BOOKWORM_APP_CONSTANTS_INSTALL_MOBILIB_DIR "/mobi_unpack.py"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE _ ("Unknown Book")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_MOBI_READER (bookworm_app_mobi_reader_get_type ())
#define BOOKWORM_APP_MOBI_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_MOBI_READER, BookwormAppmobiReader))
#define BOOKWORM_APP_MOBI_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_MOBI_READER, BookwormAppmobiReaderClass))
#define BOOKWORM_APP_IS_MOBI_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_MOBI_READER))
#define BOOKWORM_APP_IS_MOBI_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_MOBI_READER))
#define BOOKWORM_APP_MOBI_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_MOBI_READER, BookwormAppmobiReaderClass))

typedef struct _BookwormAppmobiReader BookwormAppmobiReader;
typedef struct _BookwormAppmobiReaderClass BookwormAppmobiReaderClass;
typedef struct _BookwormAppmobiReaderPrivate BookwormAppmobiReaderPrivate;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _BookwormAppParamSpecmobiReader BookwormAppParamSpecmobiReader;

struct _BookwormAppmobiReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppmobiReaderPrivate * priv;
};

struct _BookwormAppmobiReaderClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppmobiReader *self);
};

struct _BookwormAppParamSpecmobiReader {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_mobi_reader_parent_class = NULL;
VALA_EXTERN gchar* bookworm_app_mobi_reader_OpfContents;
gchar* bookworm_app_mobi_reader_OpfContents = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;

VALA_EXTERN gpointer bookworm_app_mobi_reader_ref (gpointer instance);
VALA_EXTERN void bookworm_app_mobi_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_mobi_reader (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_mobi_reader (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_mobi_reader (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_mobi_reader (const GValue* value);
VALA_EXTERN GType bookworm_app_mobi_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppmobiReader, bookworm_app_mobi_reader_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_mobi_reader_parseMobiBook (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_mobi_reader_extractEBook (const gchar* eBookLocation);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN gchar* bookworm_app_mobi_reader_getOPFFileLocation (const gchar* extractionLocation);
VALA_EXTERN void bookworm_app_book_setBaseLocationOfContents (BookwormAppBook* self,
                                                  const gchar* aBaseLocationOfContents);
VALA_EXTERN GeeArrayList* bookworm_app_mobi_reader_parseManifestData (const gchar* locationOfOPFFile);
VALA_EXTERN GeeArrayList* bookworm_app_mobi_reader_parseSpineData (const gchar* locationOfOPFFile);
VALA_EXTERN BookwormAppBook* bookworm_app_mobi_reader_getContentList (BookwormAppBook* aBook,
                                                          GeeArrayList* manifestItemsList,
                                                          GeeArrayList* spineItemsList);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_mobi_reader_setCoverImage (BookwormAppBook* aBook,
                                                         GeeArrayList* manifestItemsList);
VALA_EXTERN BookwormAppBook* bookworm_app_mobi_reader_setBookMetaData (BookwormAppBook* aBook,
                                                           const gchar* locationOfOPFFile);
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN gchar* bookworm_app_utils_extractXMLTag (const gchar* xmlData,
                                         const gchar* startTag,
                                         const gchar* endTag,
                                         GError** error);
VALA_EXTERN gchar** bookworm_app_utils_multiExtractBetweenTwoStrings (const gchar* stringToBeSearched,
                                                          const gchar* startString,
                                                          const gchar* endString,
                                                          gint* result_length1);
VALA_EXTERN gchar* bookworm_app_utils_getFullPathFromFilename (const gchar* rootDirectoryToSearch,
                                                   const gchar* fileName);
VALA_EXTERN gchar* bookworm_app_book_getBaseLocationOfContents (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN void bookworm_app_book_clearBookContentList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN void bookworm_app_book_setTOC (BookwormAppBook* self,
                               GeeHashMap* toc);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN BookwormAppmobiReader* bookworm_app_mobi_reader_new (void);
VALA_EXTERN BookwormAppmobiReader* bookworm_app_mobi_reader_construct (GType object_type);
static void bookworm_app_mobi_reader_finalize (BookwormAppmobiReader * obj);
static GType bookworm_app_mobi_reader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 33 "../src/mobiReader.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 224 "mobiReader.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 246 "mobiReader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 250 "mobiReader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 256 "mobiReader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 260 "mobiReader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 264 "mobiReader.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 272 "mobiReader.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 300 "mobiReader.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 309 "mobiReader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 323 "mobiReader.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 332 "mobiReader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 346 "mobiReader.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 355 "mobiReader.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 364 "mobiReader.c"
}

BookwormAppBook*
bookworm_app_mobi_reader_parseMobiBook (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	BookwormAppBook* _tmp62_;
	BookwormAppBook* result;
#line 24 "../src/mobiReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 25 "../src/mobiReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 25 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 25 "../src/mobiReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:parseMobiBook] book.location=", _tmp1_, NULL);
#line 25 "../src/mobiReader.vala"
	_tmp3_ = _tmp2_;
#line 25 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:25: %s", _tmp3_);
#line 25 "../src/mobiReader.vala"
	_g_free0 (_tmp3_);
#line 25 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 27 "../src/mobiReader.vala"
	if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 398 "mobiReader.c"
		gchar* extractionLocation = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* locationOfOPFFile = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* baseLocationOfContents = NULL;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		GeeArrayList* manifestItemsList = NULL;
		const gchar* _tmp24_;
		GeeArrayList* _tmp25_;
		GeeArrayList* _tmp26_;
		gpointer _tmp27_;
		gchar* _tmp28_;
		gboolean _tmp29_;
		GeeArrayList* spineItemsList = NULL;
		const gchar* _tmp31_;
		GeeArrayList* _tmp32_;
		GeeArrayList* _tmp33_;
		gpointer _tmp34_;
		gchar* _tmp35_;
		gboolean _tmp36_;
		BookwormAppBook* _tmp38_;
		GeeArrayList* _tmp39_;
		GeeArrayList* _tmp40_;
		BookwormAppBook* _tmp41_;
		GeeArrayList* _tmp42_;
		GeeArrayList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gboolean _tmp46_;
		BookwormAppBook* _tmp51_;
		const gchar* _tmp52_;
		BookwormAppBook* _tmp53_;
#line 29 "../src/mobiReader.vala"
		_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 29 "../src/mobiReader.vala"
		_tmp5_ = _tmp4_;
#line 29 "../src/mobiReader.vala"
		_tmp6_ = bookworm_app_mobi_reader_extractEBook (_tmp5_);
#line 29 "../src/mobiReader.vala"
		_tmp7_ = _tmp6_;
#line 29 "../src/mobiReader.vala"
		_g_free0 (_tmp5_);
#line 29 "../src/mobiReader.vala"
		extractionLocation = _tmp7_;
#line 30 "../src/mobiReader.vala"
		_tmp8_ = extractionLocation;
#line 30 "../src/mobiReader.vala"
		if (g_strcmp0 ("false", _tmp8_) == 0) {
#line 461 "mobiReader.c"
			BookwormAppBook* _tmp9_;
#line 31 "../src/mobiReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 32 "../src/mobiReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 33 "../src/mobiReader.vala"
			_tmp9_ = _bookworm_app_book_ref0 (aBook);
#line 33 "../src/mobiReader.vala"
			result = _tmp9_;
#line 33 "../src/mobiReader.vala"
			_g_free0 (extractionLocation);
#line 33 "../src/mobiReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 33 "../src/mobiReader.vala"
			return result;
#line 477 "mobiReader.c"
		} else {
			const gchar* _tmp10_;
#line 35 "../src/mobiReader.vala"
			_tmp10_ = extractionLocation;
#line 35 "../src/mobiReader.vala"
			bookworm_app_book_setBookExtractionLocation (aBook, _tmp10_);
#line 484 "mobiReader.c"
		}
#line 39 "../src/mobiReader.vala"
		_tmp11_ = extractionLocation;
#line 39 "../src/mobiReader.vala"
		_tmp12_ = bookworm_app_mobi_reader_getOPFFileLocation (_tmp11_);
#line 39 "../src/mobiReader.vala"
		locationOfOPFFile = _tmp12_;
#line 40 "../src/mobiReader.vala"
		_tmp13_ = locationOfOPFFile;
#line 40 "../src/mobiReader.vala"
		if (g_strcmp0 ("false", _tmp13_) == 0) {
#line 496 "mobiReader.c"
			BookwormAppBook* _tmp14_;
#line 41 "../src/mobiReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 42 "../src/mobiReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 43 "../src/mobiReader.vala"
			_tmp14_ = _bookworm_app_book_ref0 (aBook);
#line 43 "../src/mobiReader.vala"
			result = _tmp14_;
#line 43 "../src/mobiReader.vala"
			_g_free0 (locationOfOPFFile);
#line 43 "../src/mobiReader.vala"
			_g_free0 (extractionLocation);
#line 43 "../src/mobiReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 43 "../src/mobiReader.vala"
			return result;
#line 514 "mobiReader.c"
		}
#line 45 "../src/mobiReader.vala"
		_tmp15_ = locationOfOPFFile;
#line 45 "../src/mobiReader.vala"
		_tmp16_ = locationOfOPFFile;
#line 45 "../src/mobiReader.vala"
		_tmp17_ = g_file_new_for_path (_tmp16_);
#line 45 "../src/mobiReader.vala"
		_tmp18_ = _tmp17_;
#line 45 "../src/mobiReader.vala"
		_tmp19_ = g_file_get_basename (_tmp18_);
#line 45 "../src/mobiReader.vala"
		_tmp20_ = _tmp19_;
#line 45 "../src/mobiReader.vala"
		_tmp21_ = string_replace (_tmp15_, _tmp20_, "");
#line 45 "../src/mobiReader.vala"
		_tmp22_ = _tmp21_;
#line 45 "../src/mobiReader.vala"
		_g_free0 (_tmp20_);
#line 45 "../src/mobiReader.vala"
		_g_object_unref0 (_tmp18_);
#line 45 "../src/mobiReader.vala"
		baseLocationOfContents = _tmp22_;
#line 46 "../src/mobiReader.vala"
		_tmp23_ = baseLocationOfContents;
#line 46 "../src/mobiReader.vala"
		bookworm_app_book_setBaseLocationOfContents (aBook, _tmp23_);
#line 49 "../src/mobiReader.vala"
		_tmp24_ = locationOfOPFFile;
#line 49 "../src/mobiReader.vala"
		_tmp25_ = bookworm_app_mobi_reader_parseManifestData (_tmp24_);
#line 49 "../src/mobiReader.vala"
		manifestItemsList = _tmp25_;
#line 50 "../src/mobiReader.vala"
		_tmp26_ = manifestItemsList;
#line 50 "../src/mobiReader.vala"
		_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, 0);
#line 50 "../src/mobiReader.vala"
		_tmp28_ = (gchar*) _tmp27_;
#line 50 "../src/mobiReader.vala"
		_tmp29_ = g_strcmp0 ("false", _tmp28_) == 0;
#line 50 "../src/mobiReader.vala"
		_g_free0 (_tmp28_);
#line 50 "../src/mobiReader.vala"
		if (_tmp29_) {
#line 560 "mobiReader.c"
			BookwormAppBook* _tmp30_;
#line 51 "../src/mobiReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 52 "../src/mobiReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 53 "../src/mobiReader.vala"
			_tmp30_ = _bookworm_app_book_ref0 (aBook);
#line 53 "../src/mobiReader.vala"
			result = _tmp30_;
#line 53 "../src/mobiReader.vala"
			_g_object_unref0 (manifestItemsList);
#line 53 "../src/mobiReader.vala"
			_g_free0 (baseLocationOfContents);
#line 53 "../src/mobiReader.vala"
			_g_free0 (locationOfOPFFile);
#line 53 "../src/mobiReader.vala"
			_g_free0 (extractionLocation);
#line 53 "../src/mobiReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 53 "../src/mobiReader.vala"
			return result;
#line 582 "mobiReader.c"
		}
#line 57 "../src/mobiReader.vala"
		_tmp31_ = locationOfOPFFile;
#line 57 "../src/mobiReader.vala"
		_tmp32_ = bookworm_app_mobi_reader_parseSpineData (_tmp31_);
#line 57 "../src/mobiReader.vala"
		spineItemsList = _tmp32_;
#line 58 "../src/mobiReader.vala"
		_tmp33_ = spineItemsList;
#line 58 "../src/mobiReader.vala"
		_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, 0);
#line 58 "../src/mobiReader.vala"
		_tmp35_ = (gchar*) _tmp34_;
#line 58 "../src/mobiReader.vala"
		_tmp36_ = g_strcmp0 ("false", _tmp35_) == 0;
#line 58 "../src/mobiReader.vala"
		_g_free0 (_tmp35_);
#line 58 "../src/mobiReader.vala"
		if (_tmp36_) {
#line 602 "mobiReader.c"
			BookwormAppBook* _tmp37_;
#line 59 "../src/mobiReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 60 "../src/mobiReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 61 "../src/mobiReader.vala"
			_tmp37_ = _bookworm_app_book_ref0 (aBook);
#line 61 "../src/mobiReader.vala"
			result = _tmp37_;
#line 61 "../src/mobiReader.vala"
			_g_object_unref0 (spineItemsList);
#line 61 "../src/mobiReader.vala"
			_g_object_unref0 (manifestItemsList);
#line 61 "../src/mobiReader.vala"
			_g_free0 (baseLocationOfContents);
#line 61 "../src/mobiReader.vala"
			_g_free0 (locationOfOPFFile);
#line 61 "../src/mobiReader.vala"
			_g_free0 (extractionLocation);
#line 61 "../src/mobiReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 61 "../src/mobiReader.vala"
			return result;
#line 626 "mobiReader.c"
		}
#line 65 "../src/mobiReader.vala"
		_tmp38_ = _bookworm_app_book_ref0 (aBook);
#line 65 "../src/mobiReader.vala"
		_tmp39_ = manifestItemsList;
#line 65 "../src/mobiReader.vala"
		_tmp40_ = spineItemsList;
#line 65 "../src/mobiReader.vala"
		_tmp41_ = bookworm_app_mobi_reader_getContentList (_tmp38_, _tmp39_, _tmp40_);
#line 65 "../src/mobiReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 65 "../src/mobiReader.vala"
		aBook = _tmp41_;
#line 66 "../src/mobiReader.vala"
		_tmp42_ = bookworm_app_book_getBookContentList (aBook);
#line 66 "../src/mobiReader.vala"
		_tmp43_ = _tmp42_;
#line 66 "../src/mobiReader.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
#line 66 "../src/mobiReader.vala"
		_tmp45_ = _tmp44_;
#line 66 "../src/mobiReader.vala"
		_tmp46_ = _tmp45_ < 1;
#line 66 "../src/mobiReader.vala"
		_g_object_unref0 (_tmp43_);
#line 66 "../src/mobiReader.vala"
		if (_tmp46_) {
#line 654 "mobiReader.c"
			BookwormAppBook* _tmp47_;
#line 67 "../src/mobiReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 68 "../src/mobiReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 69 "../src/mobiReader.vala"
			_tmp47_ = _bookworm_app_book_ref0 (aBook);
#line 69 "../src/mobiReader.vala"
			result = _tmp47_;
#line 69 "../src/mobiReader.vala"
			_g_object_unref0 (spineItemsList);
#line 69 "../src/mobiReader.vala"
			_g_object_unref0 (manifestItemsList);
#line 69 "../src/mobiReader.vala"
			_g_free0 (baseLocationOfContents);
#line 69 "../src/mobiReader.vala"
			_g_free0 (locationOfOPFFile);
#line 69 "../src/mobiReader.vala"
			_g_free0 (extractionLocation);
#line 69 "../src/mobiReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 69 "../src/mobiReader.vala"
			return result;
#line 678 "mobiReader.c"
		}
#line 73 "../src/mobiReader.vala"
		if (!bookworm_app_book_getIsBookCoverImagePresent (aBook)) {
#line 682 "mobiReader.c"
			BookwormAppBook* _tmp48_;
			GeeArrayList* _tmp49_;
			BookwormAppBook* _tmp50_;
#line 74 "../src/mobiReader.vala"
			_tmp48_ = _bookworm_app_book_ref0 (aBook);
#line 74 "../src/mobiReader.vala"
			_tmp49_ = manifestItemsList;
#line 74 "../src/mobiReader.vala"
			_tmp50_ = bookworm_app_mobi_reader_setCoverImage (_tmp48_, _tmp49_);
#line 74 "../src/mobiReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 74 "../src/mobiReader.vala"
			aBook = _tmp50_;
#line 696 "mobiReader.c"
		}
#line 78 "../src/mobiReader.vala"
		_tmp51_ = _bookworm_app_book_ref0 (aBook);
#line 78 "../src/mobiReader.vala"
		_tmp52_ = locationOfOPFFile;
#line 78 "../src/mobiReader.vala"
		_tmp53_ = bookworm_app_mobi_reader_setBookMetaData (_tmp51_, _tmp52_);
#line 78 "../src/mobiReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 78 "../src/mobiReader.vala"
		aBook = _tmp53_;
#line 80 "../src/mobiReader.vala"
		bookworm_app_book_setIsBookParsed (aBook, TRUE);
#line 27 "../src/mobiReader.vala"
		_g_object_unref0 (spineItemsList);
#line 27 "../src/mobiReader.vala"
		_g_object_unref0 (manifestItemsList);
#line 27 "../src/mobiReader.vala"
		_g_free0 (baseLocationOfContents);
#line 27 "../src/mobiReader.vala"
		_g_free0 (locationOfOPFFile);
#line 27 "../src/mobiReader.vala"
		_g_free0 (extractionLocation);
#line 720 "mobiReader.c"
	} else {
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
#line 82 "../src/mobiReader.vala"
		_tmp54_ = bookworm_app_book_getBookLocation (aBook);
#line 82 "../src/mobiReader.vala"
		_tmp55_ = _tmp54_;
#line 82 "../src/mobiReader.vala"
		_tmp56_ = g_strconcat ("eBook already parsed, skipping MOBI parsing. book.location=", _tmp55_, NULL);
#line 82 "../src/mobiReader.vala"
		_tmp57_ = _tmp56_;
#line 82 "../src/mobiReader.vala"
		g_debug ("mobiReader.vala:82: %s", _tmp57_);
#line 82 "../src/mobiReader.vala"
		_g_free0 (_tmp57_);
#line 82 "../src/mobiReader.vala"
		_g_free0 (_tmp55_);
#line 740 "mobiReader.c"
	}
#line 84 "../src/mobiReader.vala"
	_tmp58_ = bookworm_app_book_getBookLocation (aBook);
#line 84 "../src/mobiReader.vala"
	_tmp59_ = _tmp58_;
#line 84 "../src/mobiReader.vala"
	_tmp60_ = g_strconcat ("[END] [FUNCTION:parseMobiBook] book.location=", _tmp59_, NULL);
#line 84 "../src/mobiReader.vala"
	_tmp61_ = _tmp60_;
#line 84 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:84: %s", _tmp61_);
#line 84 "../src/mobiReader.vala"
	_g_free0 (_tmp61_);
#line 84 "../src/mobiReader.vala"
	_g_free0 (_tmp59_);
#line 85 "../src/mobiReader.vala"
	_tmp62_ = _bookworm_app_book_ref0 (aBook);
#line 85 "../src/mobiReader.vala"
	result = _tmp62_;
#line 85 "../src/mobiReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 85 "../src/mobiReader.vala"
	return result;
#line 764 "mobiReader.c"
}

gchar*
bookworm_app_mobi_reader_extractEBook (const gchar* eBookLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* extractionLocation = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BookwormAppSettings* _tmp5_;
	BookwormAppSettings* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* result;
#line 88 "../src/mobiReader.vala"
	g_return_val_if_fail (eBookLocation != NULL, NULL);
#line 89 "../src/mobiReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:extractEBook] book.location=", eBookLocation, NULL);
#line 89 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 89 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:89: %s", _tmp1_);
#line 89 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 90 "../src/mobiReader.vala"
	_tmp2_ = g_strdup ("false");
#line 90 "../src/mobiReader.vala"
	extractionLocation = _tmp2_;
#line 91 "../src/mobiReader.vala"
	_tmp3_ = g_strconcat ("Initiated process for content extraction of mobi Book located at:", eBookLocation, NULL);
#line 91 "../src/mobiReader.vala"
	_tmp4_ = _tmp3_;
#line 91 "../src/mobiReader.vala"
	g_debug ("mobiReader.vala:91: %s", _tmp4_);
#line 91 "../src/mobiReader.vala"
	_g_free0 (_tmp4_);
#line 93 "../src/mobiReader.vala"
	_tmp5_ = bookworm_app_bookworm_settings;
#line 93 "../src/mobiReader.vala"
	if (_tmp5_ == NULL) {
#line 824 "mobiReader.c"
		BookwormAppSettings* _tmp6_;
#line 94 "../src/mobiReader.vala"
		_tmp6_ = bookworm_app_settings_get_instance ();
#line 94 "../src/mobiReader.vala"
		_g_object_unref0 (bookworm_app_bookworm_settings);
#line 94 "../src/mobiReader.vala"
		bookworm_app_bookworm_settings = _tmp6_;
#line 832 "mobiReader.c"
	}
#line 96 "../src/mobiReader.vala"
	_tmp7_ = bookworm_app_bookworm_settings;
#line 96 "../src/mobiReader.vala"
	_tmp8_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp7_);
#line 96 "../src/mobiReader.vala"
	_tmp9_ = _tmp8_;
#line 96 "../src/mobiReader.vala"
	if (_tmp9_) {
#line 842 "mobiReader.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 97 "../src/mobiReader.vala"
		_tmp10_ = bookworm_app_bookworm_bookworm_config_path;
#line 97 "../src/mobiReader.vala"
		_tmp11_ = g_strconcat (_tmp10_, "/books/", NULL);
#line 97 "../src/mobiReader.vala"
		_tmp12_ = _tmp11_;
#line 97 "../src/mobiReader.vala"
		_tmp13_ = g_file_new_for_path (eBookLocation);
#line 97 "../src/mobiReader.vala"
		_tmp14_ = _tmp13_;
#line 97 "../src/mobiReader.vala"
		_tmp15_ = g_file_get_basename (_tmp14_);
#line 97 "../src/mobiReader.vala"
		_tmp16_ = _tmp15_;
#line 97 "../src/mobiReader.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 97 "../src/mobiReader.vala"
		_g_free0 (extractionLocation);
#line 97 "../src/mobiReader.vala"
		extractionLocation = _tmp17_;
#line 97 "../src/mobiReader.vala"
		_g_free0 (_tmp16_);
#line 97 "../src/mobiReader.vala"
		_g_object_unref0 (_tmp14_);
#line 97 "../src/mobiReader.vala"
		_g_free0 (_tmp12_);
#line 877 "mobiReader.c"
	} else {
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 99 "../src/mobiReader.vala"
		_tmp18_ = g_file_new_for_path (eBookLocation);
#line 99 "../src/mobiReader.vala"
		_tmp19_ = _tmp18_;
#line 99 "../src/mobiReader.vala"
		_tmp20_ = g_file_get_basename (_tmp19_);
#line 99 "../src/mobiReader.vala"
		_tmp21_ = _tmp20_;
#line 99 "../src/mobiReader.vala"
		_tmp22_ = g_strconcat (BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION, _tmp21_, NULL);
#line 99 "../src/mobiReader.vala"
		_g_free0 (extractionLocation);
#line 99 "../src/mobiReader.vala"
		extractionLocation = _tmp22_;
#line 99 "../src/mobiReader.vala"
		_g_free0 (_tmp21_);
#line 99 "../src/mobiReader.vala"
		_g_object_unref0 (_tmp19_);
#line 902 "mobiReader.c"
	}
#line 102 "../src/mobiReader.vala"
	_tmp23_ = extractionLocation;
#line 102 "../src/mobiReader.vala"
	_tmp24_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp23_, "", "");
#line 102 "../src/mobiReader.vala"
	_tmp25_ = _tmp24_;
#line 102 "../src/mobiReader.vala"
	_g_free0 (_tmp25_);
#line 104 "../src/mobiReader.vala"
	_tmp26_ = g_strconcat (BOOKWORM_APP_CONSTANTS_MOBIUNPACK_SCRIPT_LOCATION " \"", eBookLocation, NULL);
#line 104 "../src/mobiReader.vala"
	_tmp27_ = _tmp26_;
#line 104 "../src/mobiReader.vala"
	_tmp28_ = g_strconcat (_tmp27_, "\" \"", NULL);
#line 104 "../src/mobiReader.vala"
	_tmp29_ = _tmp28_;
#line 104 "../src/mobiReader.vala"
	_tmp30_ = extractionLocation;
#line 104 "../src/mobiReader.vala"
	_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
#line 104 "../src/mobiReader.vala"
	_tmp32_ = _tmp31_;
#line 104 "../src/mobiReader.vala"
	_tmp33_ = g_strconcat (_tmp32_, "/\"", NULL);
#line 104 "../src/mobiReader.vala"
	_tmp34_ = _tmp33_;
#line 104 "../src/mobiReader.vala"
	_tmp35_ = bookworm_app_utils_execute_sync_command (_tmp34_);
#line 104 "../src/mobiReader.vala"
	_tmp36_ = _tmp35_;
#line 104 "../src/mobiReader.vala"
	_g_free0 (_tmp36_);
#line 104 "../src/mobiReader.vala"
	_g_free0 (_tmp34_);
#line 104 "../src/mobiReader.vala"
	_g_free0 (_tmp32_);
#line 104 "../src/mobiReader.vala"
	_g_free0 (_tmp29_);
#line 104 "../src/mobiReader.vala"
	_g_free0 (_tmp27_);
#line 107 "../src/mobiReader.vala"
	_tmp37_ = extractionLocation;
#line 107 "../src/mobiReader.vala"
	_tmp38_ = g_strconcat ("[END] [FUNCTION:extractEBook] extractionLocation=", _tmp37_, NULL);
#line 107 "../src/mobiReader.vala"
	_tmp39_ = _tmp38_;
#line 107 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:107: %s", _tmp39_);
#line 107 "../src/mobiReader.vala"
	_g_free0 (_tmp39_);
#line 108 "../src/mobiReader.vala"
	result = extractionLocation;
#line 108 "../src/mobiReader.vala"
	return result;
#line 958 "mobiReader.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 979 "mobiReader.c"
}

gchar*
bookworm_app_mobi_reader_getOPFFileLocation (const gchar* extractionLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* locationOfOPFFile = NULL;
	gchar* _tmp2_;
	gchar* isMobiExtractionFolderPresent = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
#line 111 "../src/mobiReader.vala"
	g_return_val_if_fail (extractionLocation != NULL, NULL);
#line 112 "../src/mobiReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:getOPFFileLocation] extractionLocation=", extractionLocation, NULL);
#line 112 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 112 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:112: %s", _tmp1_);
#line 112 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 113 "../src/mobiReader.vala"
	_tmp2_ = g_strdup ("false");
#line 113 "../src/mobiReader.vala"
	locationOfOPFFile = _tmp2_;
#line 115 "../src/mobiReader.vala"
	_tmp3_ = g_strconcat (extractionLocation, "/mobi7", NULL);
#line 115 "../src/mobiReader.vala"
	_tmp4_ = _tmp3_;
#line 115 "../src/mobiReader.vala"
	_tmp5_ = bookworm_app_utils_fileOperations ("DIR_EXISTS", _tmp4_, "", "");
#line 115 "../src/mobiReader.vala"
	_tmp6_ = _tmp5_;
#line 115 "../src/mobiReader.vala"
	_g_free0 (_tmp4_);
#line 115 "../src/mobiReader.vala"
	isMobiExtractionFolderPresent = _tmp6_;
#line 116 "../src/mobiReader.vala"
	if (g_strcmp0 ("false", isMobiExtractionFolderPresent) != 0) {
#line 1026 "mobiReader.c"
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 118 "../src/mobiReader.vala"
		_tmp7_ = g_strconcat ("find " "\"", extractionLocation, NULL);
#line 118 "../src/mobiReader.vala"
		_tmp8_ = _tmp7_;
#line 118 "../src/mobiReader.vala"
		_tmp9_ = g_strconcat (_tmp8_, "/mobi7/", NULL);
#line 118 "../src/mobiReader.vala"
		_tmp10_ = _tmp9_;
#line 118 "../src/mobiReader.vala"
		_tmp11_ = g_strconcat (_tmp10_, "\"", NULL);
#line 118 "../src/mobiReader.vala"
		_tmp12_ = _tmp11_;
#line 118 "../src/mobiReader.vala"
		_tmp13_ = g_strconcat (_tmp12_, " -iname *.OPF", NULL);
#line 118 "../src/mobiReader.vala"
		_tmp14_ = _tmp13_;
#line 118 "../src/mobiReader.vala"
		_tmp15_ = bookworm_app_utils_execute_sync_command (_tmp14_);
#line 118 "../src/mobiReader.vala"
		_tmp16_ = _tmp15_;
#line 118 "../src/mobiReader.vala"
		_tmp17_ = string_strip (_tmp16_);
#line 118 "../src/mobiReader.vala"
		_g_free0 (locationOfOPFFile);
#line 118 "../src/mobiReader.vala"
		locationOfOPFFile = _tmp17_;
#line 118 "../src/mobiReader.vala"
		_g_free0 (_tmp16_);
#line 118 "../src/mobiReader.vala"
		_g_free0 (_tmp14_);
#line 118 "../src/mobiReader.vala"
		_g_free0 (_tmp12_);
#line 118 "../src/mobiReader.vala"
		_g_free0 (_tmp10_);
#line 118 "../src/mobiReader.vala"
		_g_free0 (_tmp8_);
#line 1074 "mobiReader.c"
	} else {
		gchar* _tmp18_;
#line 122 "../src/mobiReader.vala"
		_tmp18_ = g_strdup ("false");
#line 122 "../src/mobiReader.vala"
		result = _tmp18_;
#line 122 "../src/mobiReader.vala"
		_g_free0 (isMobiExtractionFolderPresent);
#line 122 "../src/mobiReader.vala"
		_g_free0 (locationOfOPFFile);
#line 122 "../src/mobiReader.vala"
		return result;
#line 1087 "mobiReader.c"
	}
#line 124 "../src/mobiReader.vala"
	_tmp19_ = locationOfOPFFile;
#line 124 "../src/mobiReader.vala"
	_tmp20_ = g_strconcat ("[END] [FUNCTION:getOPFFileLocation] locationOfOPFFile=", _tmp19_, NULL);
#line 124 "../src/mobiReader.vala"
	_tmp21_ = _tmp20_;
#line 124 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:124: %s", _tmp21_);
#line 124 "../src/mobiReader.vala"
	_g_free0 (_tmp21_);
#line 125 "../src/mobiReader.vala"
	result = locationOfOPFFile;
#line 125 "../src/mobiReader.vala"
	_g_free0 (isMobiExtractionFolderPresent);
#line 125 "../src/mobiReader.vala"
	return result;
#line 1105 "mobiReader.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1124 "mobiReader.c"
}

GeeArrayList*
bookworm_app_mobi_reader_parseManifestData (const gchar* locationOfOPFFile)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* manifestItemsList = NULL;
	GeeArrayList* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* manifestData = NULL;
	gchar* _tmp12_;
	gchar** manifestList = NULL;
	const gchar* _tmp26_;
	gint _tmp27_ = 0;
	gchar** _tmp28_;
	gint manifestList_length1;
	gint _manifestList_size_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GeeArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GeeArrayList* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
#line 128 "../src/mobiReader.vala"
	g_return_val_if_fail (locationOfOPFFile != NULL, NULL);
#line 129 "../src/mobiReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:parseManifestData] locationOfOPFFile=", locationOfOPFFile, NULL);
#line 129 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 129 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:129: %s", _tmp1_);
#line 129 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 130 "../src/mobiReader.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 130 "../src/mobiReader.vala"
	manifestItemsList = _tmp2_;
#line 133 "../src/mobiReader.vala"
	_tmp3_ = g_strconcat ("cat \"", locationOfOPFFile, NULL);
#line 133 "../src/mobiReader.vala"
	_tmp4_ = _tmp3_;
#line 133 "../src/mobiReader.vala"
	_tmp5_ = g_strconcat (_tmp4_, "\"", NULL);
#line 133 "../src/mobiReader.vala"
	_tmp6_ = _tmp5_;
#line 133 "../src/mobiReader.vala"
	_tmp7_ = bookworm_app_utils_execute_sync_command (_tmp6_);
#line 133 "../src/mobiReader.vala"
	_g_free0 (bookworm_app_mobi_reader_OpfContents);
#line 133 "../src/mobiReader.vala"
	bookworm_app_mobi_reader_OpfContents = _tmp7_;
#line 133 "../src/mobiReader.vala"
	_g_free0 (_tmp6_);
#line 133 "../src/mobiReader.vala"
	_g_free0 (_tmp4_);
#line 134 "../src/mobiReader.vala"
	_tmp8_ = bookworm_app_mobi_reader_OpfContents;
#line 134 "../src/mobiReader.vala"
	if (string_contains (_tmp8_, "No such file or directory")) {
#line 1198 "mobiReader.c"
		gchar* _tmp9_;
		gchar* _tmp10_;
		GeeArrayList* _tmp11_;
#line 136 "../src/mobiReader.vala"
		_tmp9_ = g_strconcat ("OPF contents could not be read from file:", locationOfOPFFile, NULL);
#line 136 "../src/mobiReader.vala"
		_tmp10_ = _tmp9_;
#line 136 "../src/mobiReader.vala"
		g_warning ("mobiReader.vala:136: %s", _tmp10_);
#line 136 "../src/mobiReader.vala"
		_g_free0 (_tmp10_);
#line 137 "../src/mobiReader.vala"
		_tmp11_ = manifestItemsList;
#line 137 "../src/mobiReader.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "false");
#line 138 "../src/mobiReader.vala"
		result = manifestItemsList;
#line 138 "../src/mobiReader.vala"
		return result;
#line 1218 "mobiReader.c"
	}
#line 140 "../src/mobiReader.vala"
	_tmp12_ = g_strdup ("");
#line 140 "../src/mobiReader.vala"
	manifestData = _tmp12_;
#line 1224 "mobiReader.c"
	{
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 142 "../src/mobiReader.vala"
		_tmp14_ = bookworm_app_mobi_reader_OpfContents;
#line 142 "../src/mobiReader.vala"
		_tmp15_ = bookworm_app_utils_extractXMLTag (_tmp14_, "<manifest", "</manifest>", &_inner_error0_);
#line 142 "../src/mobiReader.vala"
		_tmp13_ = _tmp15_;
#line 142 "../src/mobiReader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1238 "mobiReader.c"
			goto __catch0_g_error;
		}
#line 142 "../src/mobiReader.vala"
		_tmp16_ = _tmp13_;
#line 142 "../src/mobiReader.vala"
		_tmp13_ = NULL;
#line 142 "../src/mobiReader.vala"
		_g_free0 (manifestData);
#line 142 "../src/mobiReader.vala"
		manifestData = _tmp16_;
#line 141 "../src/mobiReader.vala"
		_g_free0 (_tmp13_);
#line 1251 "mobiReader.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
#line 141 "../src/mobiReader.vala"
		e = _inner_error0_;
#line 141 "../src/mobiReader.vala"
		_inner_error0_ = NULL;
#line 144 "../src/mobiReader.vala"
		_tmp17_ = bookworm_app_mobi_reader_OpfContents;
#line 144 "../src/mobiReader.vala"
		_tmp18_ = g_strconcat ("Error while parsing manifest data [", _tmp17_, NULL);
#line 144 "../src/mobiReader.vala"
		_tmp19_ = _tmp18_;
#line 144 "../src/mobiReader.vala"
		_tmp20_ = g_strconcat (_tmp19_, "] :", NULL);
#line 144 "../src/mobiReader.vala"
		_tmp21_ = _tmp20_;
#line 144 "../src/mobiReader.vala"
		_tmp22_ = e;
#line 144 "../src/mobiReader.vala"
		_tmp23_ = _tmp22_->message;
#line 144 "../src/mobiReader.vala"
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
#line 144 "../src/mobiReader.vala"
		_tmp25_ = _tmp24_;
#line 144 "../src/mobiReader.vala"
		g_warning ("mobiReader.vala:144: %s", _tmp25_);
#line 144 "../src/mobiReader.vala"
		_g_free0 (_tmp25_);
#line 144 "../src/mobiReader.vala"
		_g_free0 (_tmp21_);
#line 144 "../src/mobiReader.vala"
		_g_free0 (_tmp19_);
#line 141 "../src/mobiReader.vala"
		_g_error_free0 (e);
#line 1298 "mobiReader.c"
	}
	__finally0:
#line 141 "../src/mobiReader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 141 "../src/mobiReader.vala"
		_g_free0 (manifestData);
#line 141 "../src/mobiReader.vala"
		_g_object_unref0 (manifestItemsList);
#line 141 "../src/mobiReader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 141 "../src/mobiReader.vala"
		g_clear_error (&_inner_error0_);
#line 141 "../src/mobiReader.vala"
		return NULL;
#line 1313 "mobiReader.c"
	}
#line 146 "../src/mobiReader.vala"
	_tmp26_ = manifestData;
#line 146 "../src/mobiReader.vala"
	_tmp28_ = bookworm_app_utils_multiExtractBetweenTwoStrings (_tmp26_, "<item", ">", &_tmp27_);
#line 146 "../src/mobiReader.vala"
	manifestList = _tmp28_;
#line 146 "../src/mobiReader.vala"
	manifestList_length1 = _tmp27_;
#line 146 "../src/mobiReader.vala"
	_manifestList_size_ = manifestList_length1;
#line 147 "../src/mobiReader.vala"
	_tmp29_ = manifestList;
#line 147 "../src/mobiReader.vala"
	_tmp29__length1 = manifestList_length1;
#line 1329 "mobiReader.c"
	{
		gchar** manifestItem_collection = NULL;
		gint manifestItem_collection_length1 = 0;
		gint _manifestItem_collection_size_ = 0;
		gint manifestItem_it = 0;
#line 147 "../src/mobiReader.vala"
		manifestItem_collection = _tmp29_;
#line 147 "../src/mobiReader.vala"
		manifestItem_collection_length1 = _tmp29__length1;
#line 147 "../src/mobiReader.vala"
		for (manifestItem_it = 0; manifestItem_it < manifestItem_collection_length1; manifestItem_it = manifestItem_it + 1) {
#line 1341 "mobiReader.c"
			gchar* _tmp30_;
			gchar* manifestItem = NULL;
#line 147 "../src/mobiReader.vala"
			_tmp30_ = g_strdup (manifestItem_collection[manifestItem_it]);
#line 147 "../src/mobiReader.vala"
			manifestItem = _tmp30_;
#line 1348 "mobiReader.c"
			{
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				GeeArrayList* _tmp34_;
				const gchar* _tmp35_;
#line 148 "../src/mobiReader.vala"
				_tmp31_ = manifestItem;
#line 148 "../src/mobiReader.vala"
				_tmp32_ = g_strconcat ("Manifest Item=", _tmp31_, NULL);
#line 148 "../src/mobiReader.vala"
				_tmp33_ = _tmp32_;
#line 148 "../src/mobiReader.vala"
				g_debug ("mobiReader.vala:148: %s", _tmp33_);
#line 148 "../src/mobiReader.vala"
				_g_free0 (_tmp33_);
#line 149 "../src/mobiReader.vala"
				_tmp34_ = manifestItemsList;
#line 149 "../src/mobiReader.vala"
				_tmp35_ = manifestItem;
#line 149 "../src/mobiReader.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
#line 147 "../src/mobiReader.vala"
				_g_free0 (manifestItem);
#line 1373 "mobiReader.c"
			}
		}
	}
#line 151 "../src/mobiReader.vala"
	_tmp36_ = manifestItemsList;
#line 151 "../src/mobiReader.vala"
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
#line 151 "../src/mobiReader.vala"
	_tmp38_ = _tmp37_;
#line 151 "../src/mobiReader.vala"
	if (_tmp38_ < 1) {
#line 1385 "mobiReader.c"
		gchar* _tmp39_;
		gchar* _tmp40_;
		GeeArrayList* _tmp41_;
#line 153 "../src/mobiReader.vala"
		_tmp39_ = g_strconcat ("OPF contents could not be read from file:", locationOfOPFFile, NULL);
#line 153 "../src/mobiReader.vala"
		_tmp40_ = _tmp39_;
#line 153 "../src/mobiReader.vala"
		g_warning ("mobiReader.vala:153: %s", _tmp40_);
#line 153 "../src/mobiReader.vala"
		_g_free0 (_tmp40_);
#line 154 "../src/mobiReader.vala"
		_tmp41_ = manifestItemsList;
#line 154 "../src/mobiReader.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, "false");
#line 155 "../src/mobiReader.vala"
		result = manifestItemsList;
#line 155 "../src/mobiReader.vala"
		manifestList = (_vala_array_free (manifestList, manifestList_length1, (GDestroyNotify) g_free), NULL);
#line 155 "../src/mobiReader.vala"
		_g_free0 (manifestData);
#line 155 "../src/mobiReader.vala"
		return result;
#line 1409 "mobiReader.c"
	}
#line 157 "../src/mobiReader.vala"
	_tmp42_ = manifestItemsList;
#line 157 "../src/mobiReader.vala"
	_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
#line 157 "../src/mobiReader.vala"
	_tmp44_ = _tmp43_;
#line 157 "../src/mobiReader.vala"
	_tmp45_ = g_strdup_printf ("%i", _tmp44_);
#line 157 "../src/mobiReader.vala"
	_tmp46_ = _tmp45_;
#line 157 "../src/mobiReader.vala"
	_tmp47_ = g_strconcat ("[END] [FUNCTION:parseManifestData] manifestItemsList.size=", _tmp46_, NULL);
#line 157 "../src/mobiReader.vala"
	_tmp48_ = _tmp47_;
#line 157 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:157: %s", _tmp48_);
#line 157 "../src/mobiReader.vala"
	_g_free0 (_tmp48_);
#line 157 "../src/mobiReader.vala"
	_g_free0 (_tmp46_);
#line 158 "../src/mobiReader.vala"
	result = manifestItemsList;
#line 158 "../src/mobiReader.vala"
	manifestList = (_vala_array_free (manifestList, manifestList_length1, (GDestroyNotify) g_free), NULL);
#line 158 "../src/mobiReader.vala"
	_g_free0 (manifestData);
#line 158 "../src/mobiReader.vala"
	return result;
#line 1439 "mobiReader.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1463 "mobiReader.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1471 "mobiReader.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1477 "mobiReader.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1505 "mobiReader.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1511 "mobiReader.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1517 "mobiReader.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1521 "mobiReader.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1529 "mobiReader.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1533 "mobiReader.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1545 "mobiReader.c"
}

GeeArrayList*
bookworm_app_mobi_reader_parseSpineData (const gchar* locationOfOPFFile)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* spineItemsList = NULL;
	GeeArrayList* _tmp2_;
	gchar* spineData = NULL;
	gchar* _tmp3_;
	gint startTOCPosition = 0;
	const gchar* _tmp17_;
	gint endTOCPosition = 0;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gchar** spineList = NULL;
	const gchar* _tmp31_;
	gint _tmp32_ = 0;
	gchar** _tmp33_;
	gint spineList_length1;
	gint _spineList_size_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp44_;
	gint _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
#line 161 "../src/mobiReader.vala"
	g_return_val_if_fail (locationOfOPFFile != NULL, NULL);
#line 162 "../src/mobiReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:parseSpineData] locationOfOPFFile=", locationOfOPFFile, NULL);
#line 162 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 162 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:162: %s", _tmp1_);
#line 162 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 163 "../src/mobiReader.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 163 "../src/mobiReader.vala"
	spineItemsList = _tmp2_;
#line 164 "../src/mobiReader.vala"
	_tmp3_ = g_strdup ("");
#line 164 "../src/mobiReader.vala"
	spineData = _tmp3_;
#line 1601 "mobiReader.c"
	{
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 166 "../src/mobiReader.vala"
		_tmp5_ = bookworm_app_mobi_reader_OpfContents;
#line 166 "../src/mobiReader.vala"
		_tmp6_ = bookworm_app_utils_extractXMLTag (_tmp5_, "<spine", "</spine>", &_inner_error0_);
#line 166 "../src/mobiReader.vala"
		_tmp4_ = _tmp6_;
#line 166 "../src/mobiReader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1615 "mobiReader.c"
			goto __catch0_g_error;
		}
#line 166 "../src/mobiReader.vala"
		_tmp7_ = _tmp4_;
#line 166 "../src/mobiReader.vala"
		_tmp4_ = NULL;
#line 166 "../src/mobiReader.vala"
		_g_free0 (spineData);
#line 166 "../src/mobiReader.vala"
		spineData = _tmp7_;
#line 165 "../src/mobiReader.vala"
		_g_free0 (_tmp4_);
#line 1628 "mobiReader.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 165 "../src/mobiReader.vala"
		e = _inner_error0_;
#line 165 "../src/mobiReader.vala"
		_inner_error0_ = NULL;
#line 168 "../src/mobiReader.vala"
		_tmp8_ = bookworm_app_mobi_reader_OpfContents;
#line 168 "../src/mobiReader.vala"
		_tmp9_ = g_strconcat ("Error while parsing spine data [", _tmp8_, NULL);
#line 168 "../src/mobiReader.vala"
		_tmp10_ = _tmp9_;
#line 168 "../src/mobiReader.vala"
		_tmp11_ = g_strconcat (_tmp10_, "] :", NULL);
#line 168 "../src/mobiReader.vala"
		_tmp12_ = _tmp11_;
#line 168 "../src/mobiReader.vala"
		_tmp13_ = e;
#line 168 "../src/mobiReader.vala"
		_tmp14_ = _tmp13_->message;
#line 168 "../src/mobiReader.vala"
		_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
#line 168 "../src/mobiReader.vala"
		_tmp16_ = _tmp15_;
#line 168 "../src/mobiReader.vala"
		g_warning ("mobiReader.vala:168: %s", _tmp16_);
#line 168 "../src/mobiReader.vala"
		_g_free0 (_tmp16_);
#line 168 "../src/mobiReader.vala"
		_g_free0 (_tmp12_);
#line 168 "../src/mobiReader.vala"
		_g_free0 (_tmp10_);
#line 165 "../src/mobiReader.vala"
		_g_error_free0 (e);
#line 1675 "mobiReader.c"
	}
	__finally0:
#line 165 "../src/mobiReader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 165 "../src/mobiReader.vala"
		_g_free0 (spineData);
#line 165 "../src/mobiReader.vala"
		_g_object_unref0 (spineItemsList);
#line 165 "../src/mobiReader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 165 "../src/mobiReader.vala"
		g_clear_error (&_inner_error0_);
#line 165 "../src/mobiReader.vala"
		return NULL;
#line 1690 "mobiReader.c"
	}
#line 171 "../src/mobiReader.vala"
	_tmp17_ = spineData;
#line 171 "../src/mobiReader.vala"
	startTOCPosition = string_index_of (_tmp17_, "toc=\"", 0);
#line 172 "../src/mobiReader.vala"
	_tmp18_ = spineData;
#line 172 "../src/mobiReader.vala"
	_tmp19_ = strlen ("toc=\"");
#line 172 "../src/mobiReader.vala"
	_tmp20_ = _tmp19_;
#line 172 "../src/mobiReader.vala"
	endTOCPosition = string_index_of (_tmp18_, "\"", (startTOCPosition + _tmp20_) + 1);
#line 173 "../src/mobiReader.vala"
	if (startTOCPosition != -1) {
#line 173 "../src/mobiReader.vala"
		_tmp22_ = endTOCPosition != -1;
#line 1708 "mobiReader.c"
	} else {
#line 173 "../src/mobiReader.vala"
		_tmp22_ = FALSE;
#line 1712 "mobiReader.c"
	}
#line 173 "../src/mobiReader.vala"
	if (_tmp22_) {
#line 173 "../src/mobiReader.vala"
		_tmp21_ = endTOCPosition > startTOCPosition;
#line 1718 "mobiReader.c"
	} else {
#line 173 "../src/mobiReader.vala"
		_tmp21_ = FALSE;
#line 1722 "mobiReader.c"
	}
#line 173 "../src/mobiReader.vala"
	if (_tmp21_) {
#line 1726 "mobiReader.c"
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
#line 174 "../src/mobiReader.vala"
		_tmp23_ = spineData;
#line 174 "../src/mobiReader.vala"
		_tmp24_ = string_slice (_tmp23_, (glong) startTOCPosition, (glong) endTOCPosition);
#line 174 "../src/mobiReader.vala"
		_tmp25_ = _tmp24_;
#line 174 "../src/mobiReader.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) spineItemsList, _tmp25_);
#line 174 "../src/mobiReader.vala"
		_g_free0 (_tmp25_);
#line 175 "../src/mobiReader.vala"
		_tmp26_ = spineData;
#line 175 "../src/mobiReader.vala"
		_tmp27_ = string_slice (_tmp26_, (glong) startTOCPosition, (glong) endTOCPosition);
#line 175 "../src/mobiReader.vala"
		_tmp28_ = _tmp27_;
#line 175 "../src/mobiReader.vala"
		_tmp29_ = g_strconcat ("TOC ID=", _tmp28_, NULL);
#line 175 "../src/mobiReader.vala"
		_tmp30_ = _tmp29_;
#line 175 "../src/mobiReader.vala"
		g_debug ("mobiReader.vala:175: %s", _tmp30_);
#line 175 "../src/mobiReader.vala"
		_g_free0 (_tmp30_);
#line 175 "../src/mobiReader.vala"
		_g_free0 (_tmp28_);
#line 1761 "mobiReader.c"
	}
#line 178 "../src/mobiReader.vala"
	_tmp31_ = spineData;
#line 178 "../src/mobiReader.vala"
	_tmp33_ = bookworm_app_utils_multiExtractBetweenTwoStrings (_tmp31_, "<itemref", ">", &_tmp32_);
#line 178 "../src/mobiReader.vala"
	spineList = _tmp33_;
#line 178 "../src/mobiReader.vala"
	spineList_length1 = _tmp32_;
#line 178 "../src/mobiReader.vala"
	_spineList_size_ = spineList_length1;
#line 179 "../src/mobiReader.vala"
	_tmp34_ = spineList;
#line 179 "../src/mobiReader.vala"
	_tmp34__length1 = spineList_length1;
#line 1777 "mobiReader.c"
	{
		gchar** spineItem_collection = NULL;
		gint spineItem_collection_length1 = 0;
		gint _spineItem_collection_size_ = 0;
		gint spineItem_it = 0;
#line 179 "../src/mobiReader.vala"
		spineItem_collection = _tmp34_;
#line 179 "../src/mobiReader.vala"
		spineItem_collection_length1 = _tmp34__length1;
#line 179 "../src/mobiReader.vala"
		for (spineItem_it = 0; spineItem_it < spineItem_collection_length1; spineItem_it = spineItem_it + 1) {
#line 1789 "mobiReader.c"
			gchar* _tmp35_;
			gchar* spineItem = NULL;
#line 179 "../src/mobiReader.vala"
			_tmp35_ = g_strdup (spineItem_collection[spineItem_it]);
#line 179 "../src/mobiReader.vala"
			spineItem = _tmp35_;
#line 1796 "mobiReader.c"
			{
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				const gchar* _tmp39_;
#line 180 "../src/mobiReader.vala"
				_tmp36_ = spineItem;
#line 180 "../src/mobiReader.vala"
				_tmp37_ = g_strconcat ("Spine Item=", _tmp36_, NULL);
#line 180 "../src/mobiReader.vala"
				_tmp38_ = _tmp37_;
#line 180 "../src/mobiReader.vala"
				g_debug ("mobiReader.vala:180: %s", _tmp38_);
#line 180 "../src/mobiReader.vala"
				_g_free0 (_tmp38_);
#line 181 "../src/mobiReader.vala"
				_tmp39_ = spineItem;
#line 181 "../src/mobiReader.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) spineItemsList, _tmp39_);
#line 179 "../src/mobiReader.vala"
				_g_free0 (spineItem);
#line 1818 "mobiReader.c"
			}
		}
	}
#line 183 "../src/mobiReader.vala"
	_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) spineItemsList);
#line 183 "../src/mobiReader.vala"
	_tmp41_ = _tmp40_;
#line 183 "../src/mobiReader.vala"
	if (_tmp41_ < 1) {
#line 1828 "mobiReader.c"
		gchar* _tmp42_;
		gchar* _tmp43_;
#line 185 "../src/mobiReader.vala"
		_tmp42_ = g_strconcat ("Spine contents could not be read from file:", locationOfOPFFile, NULL);
#line 185 "../src/mobiReader.vala"
		_tmp43_ = _tmp42_;
#line 185 "../src/mobiReader.vala"
		g_warning ("mobiReader.vala:185: %s", _tmp43_);
#line 185 "../src/mobiReader.vala"
		_g_free0 (_tmp43_);
#line 186 "../src/mobiReader.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) spineItemsList, "false");
#line 187 "../src/mobiReader.vala"
		result = spineItemsList;
#line 187 "../src/mobiReader.vala"
		spineList = (_vala_array_free (spineList, spineList_length1, (GDestroyNotify) g_free), NULL);
#line 187 "../src/mobiReader.vala"
		_g_free0 (spineData);
#line 187 "../src/mobiReader.vala"
		return result;
#line 1849 "mobiReader.c"
	}
#line 189 "../src/mobiReader.vala"
	_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) spineItemsList);
#line 189 "../src/mobiReader.vala"
	_tmp45_ = _tmp44_;
#line 189 "../src/mobiReader.vala"
	_tmp46_ = g_strdup_printf ("%i", _tmp45_);
#line 189 "../src/mobiReader.vala"
	_tmp47_ = _tmp46_;
#line 189 "../src/mobiReader.vala"
	_tmp48_ = g_strconcat ("[END] [FUNCTION:parseSpineData] spineItemsList.size=", _tmp47_, NULL);
#line 189 "../src/mobiReader.vala"
	_tmp49_ = _tmp48_;
#line 189 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:189: %s", _tmp49_);
#line 189 "../src/mobiReader.vala"
	_g_free0 (_tmp49_);
#line 189 "../src/mobiReader.vala"
	_g_free0 (_tmp47_);
#line 190 "../src/mobiReader.vala"
	result = spineItemsList;
#line 190 "../src/mobiReader.vala"
	spineList = (_vala_array_free (spineList, spineList_length1, (GDestroyNotify) g_free), NULL);
#line 190 "../src/mobiReader.vala"
	_g_free0 (spineData);
#line 190 "../src/mobiReader.vala"
	return result;
#line 1877 "mobiReader.c"
}

BookwormAppBook*
bookworm_app_mobi_reader_getContentList (BookwormAppBook* aBook,
                                         GeeArrayList* manifestItemsList,
                                         GeeArrayList* spineItemsList)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GString* bufferForSpineData = NULL;
	GString* _tmp4_;
	GString* bufferForLocationOfContentData = NULL;
	GString* _tmp5_;
	GeeArrayList* tocList = NULL;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	GeeArrayList* _tmp374_;
	gint _tmp375_;
	gint _tmp376_;
	gchar* _tmp377_;
	gchar* _tmp378_;
	gchar* _tmp379_;
	gchar* _tmp380_;
	BookwormAppBook* _tmp381_;
	GError* _inner_error0_ = NULL;
	BookwormAppBook* result;
#line 193 "../src/mobiReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 193 "../src/mobiReader.vala"
	g_return_val_if_fail (manifestItemsList != NULL, NULL);
#line 193 "../src/mobiReader.vala"
	g_return_val_if_fail (spineItemsList != NULL, NULL);
#line 197 "../src/mobiReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 197 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 197 "../src/mobiReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:getContentList] book.location=", _tmp1_, NULL);
#line 197 "../src/mobiReader.vala"
	_tmp3_ = _tmp2_;
#line 197 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:197: %s", _tmp3_);
#line 197 "../src/mobiReader.vala"
	_g_free0 (_tmp3_);
#line 197 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 198 "../src/mobiReader.vala"
	_tmp4_ = g_string_new ("");
#line 198 "../src/mobiReader.vala"
	bufferForSpineData = _tmp4_;
#line 199 "../src/mobiReader.vala"
	_tmp5_ = g_string_new ("");
#line 199 "../src/mobiReader.vala"
	bufferForLocationOfContentData = _tmp5_;
#line 200 "../src/mobiReader.vala"
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 200 "../src/mobiReader.vala"
	tocList = _tmp6_;
#line 202 "../src/mobiReader.vala"
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) spineItemsList, 0);
#line 202 "../src/mobiReader.vala"
	_tmp8_ = (gchar*) _tmp7_;
#line 202 "../src/mobiReader.vala"
	_tmp9_ = string_contains (_tmp8_, "toc=\"");
#line 202 "../src/mobiReader.vala"
	_g_free0 (_tmp8_);
#line 202 "../src/mobiReader.vala"
	if (_tmp9_) {
#line 1950 "mobiReader.c"
		gint tocRefStartPos = 0;
		gpointer _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gboolean _tmp15_ = FALSE;
		gint _tmp16_;
		gint _tmp17_;
		GString* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
#line 203 "../src/mobiReader.vala"
		_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) spineItemsList, 0);
#line 203 "../src/mobiReader.vala"
		_tmp11_ = (gchar*) _tmp10_;
#line 203 "../src/mobiReader.vala"
		_tmp12_ = strlen ("toc=\"");
#line 203 "../src/mobiReader.vala"
		_tmp13_ = _tmp12_;
#line 203 "../src/mobiReader.vala"
		_tmp14_ = string_index_of (_tmp11_, "toc=\"", 0) + _tmp13_;
#line 203 "../src/mobiReader.vala"
		_g_free0 (_tmp11_);
#line 203 "../src/mobiReader.vala"
		tocRefStartPos = _tmp14_;
#line 204 "../src/mobiReader.vala"
		_tmp16_ = strlen ("toc=\"");
#line 204 "../src/mobiReader.vala"
		_tmp17_ = _tmp16_;
#line 204 "../src/mobiReader.vala"
		if ((tocRefStartPos - _tmp17_) != -1) {
#line 1984 "mobiReader.c"
			gpointer _tmp18_;
			gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
#line 204 "../src/mobiReader.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) spineItemsList, 0);
#line 204 "../src/mobiReader.vala"
			_tmp19_ = (gchar*) _tmp18_;
#line 204 "../src/mobiReader.vala"
			_tmp20_ = strlen (_tmp19_);
#line 204 "../src/mobiReader.vala"
			_tmp21_ = _tmp20_;
#line 204 "../src/mobiReader.vala"
			_tmp15_ = _tmp21_ > tocRefStartPos;
#line 204 "../src/mobiReader.vala"
			_g_free0 (_tmp19_);
#line 2001 "mobiReader.c"
		} else {
#line 204 "../src/mobiReader.vala"
			_tmp15_ = FALSE;
#line 2005 "mobiReader.c"
		}
#line 204 "../src/mobiReader.vala"
		if (_tmp15_) {
#line 2009 "mobiReader.c"
			GString* _tmp22_;
			gpointer _tmp23_;
			gchar* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
#line 205 "../src/mobiReader.vala"
			_tmp22_ = bufferForSpineData;
#line 205 "../src/mobiReader.vala"
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) spineItemsList, 0);
#line 205 "../src/mobiReader.vala"
			_tmp24_ = (gchar*) _tmp23_;
#line 205 "../src/mobiReader.vala"
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) spineItemsList, 0);
#line 205 "../src/mobiReader.vala"
			_tmp26_ = (gchar*) _tmp25_;
#line 205 "../src/mobiReader.vala"
			_tmp27_ = strlen (_tmp26_);
#line 205 "../src/mobiReader.vala"
			_tmp28_ = _tmp27_;
#line 205 "../src/mobiReader.vala"
			_tmp29_ = string_slice (_tmp24_, (glong) tocRefStartPos, (glong) _tmp28_);
#line 205 "../src/mobiReader.vala"
			_tmp30_ = _tmp29_;
#line 205 "../src/mobiReader.vala"
			g_string_assign (_tmp22_, _tmp30_);
#line 205 "../src/mobiReader.vala"
			_g_free0 (_tmp30_);
#line 205 "../src/mobiReader.vala"
			_g_free0 (_tmp26_);
#line 205 "../src/mobiReader.vala"
			_g_free0 (_tmp24_);
#line 2045 "mobiReader.c"
		} else {
			GString* _tmp31_;
#line 207 "../src/mobiReader.vala"
			_tmp31_ = bufferForSpineData;
#line 207 "../src/mobiReader.vala"
			g_string_assign (_tmp31_, "");
#line 2052 "mobiReader.c"
		}
#line 209 "../src/mobiReader.vala"
		_tmp32_ = bufferForSpineData;
#line 209 "../src/mobiReader.vala"
		_tmp33_ = _tmp32_->str;
#line 209 "../src/mobiReader.vala"
		_tmp34_ = strlen (_tmp33_);
#line 209 "../src/mobiReader.vala"
		_tmp35_ = _tmp34_;
#line 209 "../src/mobiReader.vala"
		if (_tmp35_ > 0) {
#line 2064 "mobiReader.c"
			{
				GeeArrayList* _manifestItem_list = NULL;
				gint _manifestItem_size = 0;
				GeeArrayList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _manifestItem_index = 0;
#line 211 "../src/mobiReader.vala"
				_manifestItem_list = manifestItemsList;
#line 211 "../src/mobiReader.vala"
				_tmp36_ = _manifestItem_list;
#line 211 "../src/mobiReader.vala"
				_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
#line 211 "../src/mobiReader.vala"
				_tmp38_ = _tmp37_;
#line 211 "../src/mobiReader.vala"
				_manifestItem_size = _tmp38_;
#line 211 "../src/mobiReader.vala"
				_manifestItem_index = -1;
#line 211 "../src/mobiReader.vala"
				while (TRUE) {
#line 2086 "mobiReader.c"
					gint _tmp39_;
					gint _tmp40_;
					gchar* manifestItem = NULL;
					GeeArrayList* _tmp41_;
					gpointer _tmp42_;
					const gchar* _tmp43_;
					GString* _tmp44_;
					const gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gboolean _tmp50_;
#line 211 "../src/mobiReader.vala"
					_manifestItem_index = _manifestItem_index + 1;
#line 211 "../src/mobiReader.vala"
					_tmp39_ = _manifestItem_index;
#line 211 "../src/mobiReader.vala"
					_tmp40_ = _manifestItem_size;
#line 211 "../src/mobiReader.vala"
					if (!(_tmp39_ < _tmp40_)) {
#line 211 "../src/mobiReader.vala"
						break;
#line 2110 "mobiReader.c"
					}
#line 211 "../src/mobiReader.vala"
					_tmp41_ = _manifestItem_list;
#line 211 "../src/mobiReader.vala"
					_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, _manifestItem_index);
#line 211 "../src/mobiReader.vala"
					manifestItem = (gchar*) _tmp42_;
#line 212 "../src/mobiReader.vala"
					_tmp43_ = manifestItem;
#line 212 "../src/mobiReader.vala"
					_tmp44_ = bufferForSpineData;
#line 212 "../src/mobiReader.vala"
					_tmp45_ = _tmp44_->str;
#line 212 "../src/mobiReader.vala"
					_tmp46_ = g_strconcat ("id=\"", _tmp45_, NULL);
#line 212 "../src/mobiReader.vala"
					_tmp47_ = _tmp46_;
#line 212 "../src/mobiReader.vala"
					_tmp48_ = g_strconcat (_tmp47_, "\"", NULL);
#line 212 "../src/mobiReader.vala"
					_tmp49_ = _tmp48_;
#line 212 "../src/mobiReader.vala"
					_tmp50_ = string_index_of (_tmp43_, _tmp49_, 0) != -1;
#line 212 "../src/mobiReader.vala"
					_g_free0 (_tmp49_);
#line 212 "../src/mobiReader.vala"
					_g_free0 (_tmp47_);
#line 212 "../src/mobiReader.vala"
					if (_tmp50_) {
#line 2140 "mobiReader.c"
						gint startPosOfNCXContentItem = 0;
						const gchar* _tmp51_;
						gint _tmp52_;
						gint _tmp53_;
						gint endPosOfNCXContentItem = 0;
						const gchar* _tmp54_;
						gboolean _tmp55_ = FALSE;
						gboolean _tmp56_ = FALSE;
#line 213 "../src/mobiReader.vala"
						_tmp51_ = manifestItem;
#line 213 "../src/mobiReader.vala"
						_tmp52_ = strlen ("href=");
#line 213 "../src/mobiReader.vala"
						_tmp53_ = _tmp52_;
#line 213 "../src/mobiReader.vala"
						startPosOfNCXContentItem = (string_index_of (_tmp51_, "href=", 0) + _tmp53_) + 1;
#line 214 "../src/mobiReader.vala"
						_tmp54_ = manifestItem;
#line 214 "../src/mobiReader.vala"
						endPosOfNCXContentItem = string_index_of (_tmp54_, "\"", startPosOfNCXContentItem + 1);
#line 215 "../src/mobiReader.vala"
						if (startPosOfNCXContentItem != -1) {
#line 215 "../src/mobiReader.vala"
							_tmp56_ = endPosOfNCXContentItem != -1;
#line 2165 "mobiReader.c"
						} else {
#line 215 "../src/mobiReader.vala"
							_tmp56_ = FALSE;
#line 2169 "mobiReader.c"
						}
#line 215 "../src/mobiReader.vala"
						if (_tmp56_) {
#line 215 "../src/mobiReader.vala"
							_tmp55_ = endPosOfNCXContentItem > startPosOfNCXContentItem;
#line 2175 "mobiReader.c"
						} else {
#line 215 "../src/mobiReader.vala"
							_tmp55_ = FALSE;
#line 2179 "mobiReader.c"
						}
#line 215 "../src/mobiReader.vala"
						if (_tmp55_) {
#line 2183 "mobiReader.c"
							GString* _tmp57_;
							const gchar* _tmp58_;
							gchar* _tmp59_;
							gchar* _tmp60_;
							GString* _tmp61_;
							const gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							gchar* _tmp66_;
							GString* _tmp67_;
							const gchar* _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							gchar* navigationData = NULL;
							gchar* _tmp71_;
							gchar* _tmp72_;
							GString* _tmp73_;
							const gchar* _tmp74_;
							gchar* _tmp75_;
							gchar* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							gchar* _tmp79_;
							gchar* _tmp80_;
							gchar* _tmp81_;
							gchar* _tmp82_;
							gchar** navPointList = NULL;
							const gchar* _tmp83_;
							gint _tmp84_ = 0;
							gchar** _tmp85_;
							gint navPointList_length1;
							gint _navPointList_size_;
							gchar** _tmp86_;
							gint _tmp86__length1;
#line 216 "../src/mobiReader.vala"
							_tmp57_ = bufferForLocationOfContentData;
#line 216 "../src/mobiReader.vala"
							_tmp58_ = manifestItem;
#line 216 "../src/mobiReader.vala"
							_tmp59_ = string_slice (_tmp58_, (glong) startPosOfNCXContentItem, (glong) endPosOfNCXContentItem);
#line 216 "../src/mobiReader.vala"
							_tmp60_ = _tmp59_;
#line 216 "../src/mobiReader.vala"
							g_string_assign (_tmp57_, _tmp60_);
#line 216 "../src/mobiReader.vala"
							_g_free0 (_tmp60_);
#line 217 "../src/mobiReader.vala"
							_tmp61_ = bufferForSpineData;
#line 217 "../src/mobiReader.vala"
							_tmp62_ = _tmp61_->str;
#line 217 "../src/mobiReader.vala"
							_tmp63_ = g_strconcat ("SpineData=", _tmp62_, NULL);
#line 217 "../src/mobiReader.vala"
							_tmp64_ = _tmp63_;
#line 217 "../src/mobiReader.vala"
							_tmp65_ = g_strconcat (_tmp64_, " | Location Of NCX ContentData=", NULL);
#line 217 "../src/mobiReader.vala"
							_tmp66_ = _tmp65_;
#line 217 "../src/mobiReader.vala"
							_tmp67_ = bufferForLocationOfContentData;
#line 217 "../src/mobiReader.vala"
							_tmp68_ = _tmp67_->str;
#line 217 "../src/mobiReader.vala"
							_tmp69_ = g_strconcat (_tmp66_, _tmp68_, NULL);
#line 217 "../src/mobiReader.vala"
							_tmp70_ = _tmp69_;
#line 217 "../src/mobiReader.vala"
							g_debug ("mobiReader.vala:217: %s", _tmp70_);
#line 217 "../src/mobiReader.vala"
							_g_free0 (_tmp70_);
#line 217 "../src/mobiReader.vala"
							_g_free0 (_tmp66_);
#line 217 "../src/mobiReader.vala"
							_g_free0 (_tmp64_);
#line 219 "../src/mobiReader.vala"
							_tmp71_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 219 "../src/mobiReader.vala"
							_tmp72_ = _tmp71_;
#line 219 "../src/mobiReader.vala"
							_tmp73_ = bufferForLocationOfContentData;
#line 219 "../src/mobiReader.vala"
							_tmp74_ = _tmp73_->str;
#line 219 "../src/mobiReader.vala"
							_tmp75_ = string_strip (_tmp74_);
#line 219 "../src/mobiReader.vala"
							_tmp76_ = _tmp75_;
#line 219 "../src/mobiReader.vala"
							_tmp77_ = bookworm_app_utils_getFullPathFromFilename (_tmp72_, _tmp76_);
#line 219 "../src/mobiReader.vala"
							_tmp78_ = _tmp77_;
#line 219 "../src/mobiReader.vala"
							_tmp79_ = string_strip (_tmp78_);
#line 219 "../src/mobiReader.vala"
							_tmp80_ = _tmp79_;
#line 219 "../src/mobiReader.vala"
							_tmp81_ = bookworm_app_utils_fileOperations ("READ_FILE", _tmp80_, "", "");
#line 219 "../src/mobiReader.vala"
							_tmp82_ = _tmp81_;
#line 219 "../src/mobiReader.vala"
							_g_free0 (_tmp80_);
#line 219 "../src/mobiReader.vala"
							_g_free0 (_tmp78_);
#line 219 "../src/mobiReader.vala"
							_g_free0 (_tmp76_);
#line 219 "../src/mobiReader.vala"
							_g_free0 (_tmp72_);
#line 219 "../src/mobiReader.vala"
							navigationData = _tmp82_;
#line 220 "../src/mobiReader.vala"
							_tmp83_ = navigationData;
#line 220 "../src/mobiReader.vala"
							_tmp85_ = bookworm_app_utils_multiExtractBetweenTwoStrings (_tmp83_, "<navPoint", "</navPoint>", &_tmp84_);
#line 220 "../src/mobiReader.vala"
							navPointList = _tmp85_;
#line 220 "../src/mobiReader.vala"
							navPointList_length1 = _tmp84_;
#line 220 "../src/mobiReader.vala"
							_navPointList_size_ = navPointList_length1;
#line 221 "../src/mobiReader.vala"
							_tmp86_ = navPointList;
#line 221 "../src/mobiReader.vala"
							_tmp86__length1 = navPointList_length1;
#line 221 "../src/mobiReader.vala"
							if (_tmp86__length1 > 0) {
#line 2309 "mobiReader.c"
								gchar** _tmp87_;
								gint _tmp87__length1;
#line 222 "../src/mobiReader.vala"
								_tmp87_ = navPointList;
#line 222 "../src/mobiReader.vala"
								_tmp87__length1 = navPointList_length1;
#line 2316 "mobiReader.c"
								{
									gchar** navPointItem_collection = NULL;
									gint navPointItem_collection_length1 = 0;
									gint _navPointItem_collection_size_ = 0;
									gint navPointItem_it = 0;
#line 222 "../src/mobiReader.vala"
									navPointItem_collection = _tmp87_;
#line 222 "../src/mobiReader.vala"
									navPointItem_collection_length1 = _tmp87__length1;
#line 222 "../src/mobiReader.vala"
									for (navPointItem_it = 0; navPointItem_it < navPointItem_collection_length1; navPointItem_it = navPointItem_it + 1) {
#line 2328 "mobiReader.c"
										gchar* _tmp88_;
										gchar* navPointItem = NULL;
#line 222 "../src/mobiReader.vala"
										_tmp88_ = g_strdup (navPointItem_collection[navPointItem_it]);
#line 222 "../src/mobiReader.vala"
										navPointItem = _tmp88_;
#line 2335 "mobiReader.c"
										{
											gchar* tocText = NULL;
											gchar* _tmp89_;
											gint tocNavStartPoint = 0;
											const gchar* _tmp103_;
											gint tocNavEndPoint = 0;
											const gchar* _tmp104_;
											gint _tmp105_;
											gint _tmp106_;
											gboolean _tmp107_ = FALSE;
											gboolean _tmp108_ = FALSE;
#line 223 "../src/mobiReader.vala"
											_tmp89_ = g_strdup ("");
#line 223 "../src/mobiReader.vala"
											tocText = _tmp89_;
#line 2351 "mobiReader.c"
											{
												gchar* _tmp90_ = NULL;
												const gchar* _tmp91_;
												gchar* _tmp92_;
												gchar* _tmp93_;
#line 225 "../src/mobiReader.vala"
												_tmp91_ = navPointItem;
#line 225 "../src/mobiReader.vala"
												_tmp92_ = bookworm_app_utils_extractXMLTag (_tmp91_, "<text>", "</text>", &_inner_error0_);
#line 225 "../src/mobiReader.vala"
												_tmp90_ = _tmp92_;
#line 225 "../src/mobiReader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2365 "mobiReader.c"
													goto __catch0_g_error;
												}
#line 225 "../src/mobiReader.vala"
												_tmp93_ = bookworm_app_utils_decodeHTMLChars (_tmp90_);
#line 225 "../src/mobiReader.vala"
												_g_free0 (tocText);
#line 225 "../src/mobiReader.vala"
												tocText = _tmp93_;
#line 224 "../src/mobiReader.vala"
												_g_free0 (_tmp90_);
#line 2376 "mobiReader.c"
											}
											goto __finally0;
											__catch0_g_error:
											{
												GError* e = NULL;
												const gchar* _tmp94_;
												gchar* _tmp95_;
												gchar* _tmp96_;
												gchar* _tmp97_;
												gchar* _tmp98_;
												GError* _tmp99_;
												const gchar* _tmp100_;
												gchar* _tmp101_;
												gchar* _tmp102_;
#line 224 "../src/mobiReader.vala"
												e = _inner_error0_;
#line 224 "../src/mobiReader.vala"
												_inner_error0_ = NULL;
#line 227 "../src/mobiReader.vala"
												_tmp94_ = navPointItem;
#line 227 "../src/mobiReader.vala"
												_tmp95_ = g_strconcat ("Error while parsing ToC data [", _tmp94_, NULL);
#line 227 "../src/mobiReader.vala"
												_tmp96_ = _tmp95_;
#line 227 "../src/mobiReader.vala"
												_tmp97_ = g_strconcat (_tmp96_, "] : ", NULL);
#line 227 "../src/mobiReader.vala"
												_tmp98_ = _tmp97_;
#line 227 "../src/mobiReader.vala"
												_tmp99_ = e;
#line 227 "../src/mobiReader.vala"
												_tmp100_ = _tmp99_->message;
#line 227 "../src/mobiReader.vala"
												_tmp101_ = g_strconcat (_tmp98_, _tmp100_, NULL);
#line 227 "../src/mobiReader.vala"
												_tmp102_ = _tmp101_;
#line 227 "../src/mobiReader.vala"
												g_warning ("mobiReader.vala:227: %s", _tmp102_);
#line 227 "../src/mobiReader.vala"
												_g_free0 (_tmp102_);
#line 227 "../src/mobiReader.vala"
												_g_free0 (_tmp98_);
#line 227 "../src/mobiReader.vala"
												_g_free0 (_tmp96_);
#line 224 "../src/mobiReader.vala"
												_g_error_free0 (e);
#line 2423 "mobiReader.c"
											}
											__finally0:
#line 224 "../src/mobiReader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 224 "../src/mobiReader.vala"
												_g_free0 (tocText);
#line 224 "../src/mobiReader.vala"
												_g_free0 (navPointItem);
#line 224 "../src/mobiReader.vala"
												navPointList = (_vala_array_free (navPointList, navPointList_length1, (GDestroyNotify) g_free), NULL);
#line 224 "../src/mobiReader.vala"
												_g_free0 (navigationData);
#line 224 "../src/mobiReader.vala"
												_g_free0 (manifestItem);
#line 224 "../src/mobiReader.vala"
												_g_object_unref0 (tocList);
#line 224 "../src/mobiReader.vala"
												_g_string_free0 (bufferForLocationOfContentData);
#line 224 "../src/mobiReader.vala"
												_g_string_free0 (bufferForSpineData);
#line 224 "../src/mobiReader.vala"
												_bookworm_app_book_unref0 (aBook);
#line 224 "../src/mobiReader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 224 "../src/mobiReader.vala"
												g_clear_error (&_inner_error0_);
#line 224 "../src/mobiReader.vala"
												return NULL;
#line 2452 "mobiReader.c"
											}
#line 229 "../src/mobiReader.vala"
											_tmp103_ = navPointItem;
#line 229 "../src/mobiReader.vala"
											tocNavStartPoint = string_index_of (_tmp103_, "src=\"", 0);
#line 230 "../src/mobiReader.vala"
											_tmp104_ = navPointItem;
#line 230 "../src/mobiReader.vala"
											_tmp105_ = strlen ("src=\"");
#line 230 "../src/mobiReader.vala"
											_tmp106_ = _tmp105_;
#line 230 "../src/mobiReader.vala"
											tocNavEndPoint = string_index_of (_tmp104_, "\"", tocNavStartPoint + _tmp106_);
#line 231 "../src/mobiReader.vala"
											if (tocNavStartPoint != -1) {
#line 231 "../src/mobiReader.vala"
												_tmp108_ = tocNavEndPoint != -1;
#line 2470 "mobiReader.c"
											} else {
#line 231 "../src/mobiReader.vala"
												_tmp108_ = FALSE;
#line 2474 "mobiReader.c"
											}
#line 231 "../src/mobiReader.vala"
											if (_tmp108_) {
#line 231 "../src/mobiReader.vala"
												_tmp107_ = tocNavEndPoint > tocNavStartPoint;
#line 2480 "mobiReader.c"
											} else {
#line 231 "../src/mobiReader.vala"
												_tmp107_ = FALSE;
#line 2484 "mobiReader.c"
											}
#line 231 "../src/mobiReader.vala"
											if (_tmp107_) {
#line 2488 "mobiReader.c"
												gchar* tocNavLocation = NULL;
												const gchar* _tmp109_;
												gint _tmp110_;
												gint _tmp111_;
												gchar* _tmp112_;
												gchar* _tmp113_;
												gchar* _tmp114_;
												gchar* _tmp115_;
												const gchar* _tmp116_;
												gint _tmp117_;
												gint _tmp118_;
#line 232 "../src/mobiReader.vala"
												_tmp109_ = navPointItem;
#line 232 "../src/mobiReader.vala"
												_tmp110_ = strlen ("src=\"");
#line 232 "../src/mobiReader.vala"
												_tmp111_ = _tmp110_;
#line 232 "../src/mobiReader.vala"
												_tmp112_ = string_slice (_tmp109_, (glong) (tocNavStartPoint + _tmp111_), (glong) tocNavEndPoint);
#line 232 "../src/mobiReader.vala"
												_tmp113_ = _tmp112_;
#line 232 "../src/mobiReader.vala"
												_tmp114_ = string_strip (_tmp113_);
#line 232 "../src/mobiReader.vala"
												_tmp115_ = _tmp114_;
#line 232 "../src/mobiReader.vala"
												_g_free0 (_tmp113_);
#line 232 "../src/mobiReader.vala"
												tocNavLocation = _tmp115_;
#line 233 "../src/mobiReader.vala"
												_tmp116_ = tocNavLocation;
#line 233 "../src/mobiReader.vala"
												_tmp117_ = strlen (_tmp116_);
#line 233 "../src/mobiReader.vala"
												_tmp118_ = _tmp117_;
#line 233 "../src/mobiReader.vala"
												if (_tmp118_ > 0) {
#line 2526 "mobiReader.c"
													GeeArrayList* _tmp119_;
													const gchar* _tmp120_;
													gchar* _tmp121_;
													gchar* _tmp122_;
													const gchar* _tmp123_;
													gchar* _tmp124_;
													gchar* _tmp125_;
#line 234 "../src/mobiReader.vala"
													_tmp119_ = tocList;
#line 234 "../src/mobiReader.vala"
													_tmp120_ = tocNavLocation;
#line 234 "../src/mobiReader.vala"
													_tmp121_ = g_strconcat (_tmp120_, "~~$$~~", NULL);
#line 234 "../src/mobiReader.vala"
													_tmp122_ = _tmp121_;
#line 234 "../src/mobiReader.vala"
													_tmp123_ = tocText;
#line 234 "../src/mobiReader.vala"
													_tmp124_ = g_strconcat (_tmp122_, _tmp123_, NULL);
#line 234 "../src/mobiReader.vala"
													_tmp125_ = _tmp124_;
#line 234 "../src/mobiReader.vala"
													gee_abstract_collection_add ((GeeAbstractCollection*) _tmp119_, _tmp125_);
#line 234 "../src/mobiReader.vala"
													_g_free0 (_tmp125_);
#line 234 "../src/mobiReader.vala"
													_g_free0 (_tmp122_);
#line 2554 "mobiReader.c"
												}
#line 231 "../src/mobiReader.vala"
												_g_free0 (tocNavLocation);
#line 2558 "mobiReader.c"
											}
#line 222 "../src/mobiReader.vala"
											_g_free0 (tocText);
#line 222 "../src/mobiReader.vala"
											_g_free0 (navPointItem);
#line 2564 "mobiReader.c"
										}
									}
								}
							}
#line 215 "../src/mobiReader.vala"
							navPointList = (_vala_array_free (navPointList, navPointList_length1, (GDestroyNotify) g_free), NULL);
#line 215 "../src/mobiReader.vala"
							_g_free0 (navigationData);
#line 2573 "mobiReader.c"
						}
#line 240 "../src/mobiReader.vala"
						_g_free0 (manifestItem);
#line 240 "../src/mobiReader.vala"
						break;
#line 2579 "mobiReader.c"
					}
#line 211 "../src/mobiReader.vala"
					_g_free0 (manifestItem);
#line 2583 "mobiReader.c"
				}
			}
		}
	}
#line 246 "../src/mobiReader.vala"
	bookworm_app_book_clearBookContentList (aBook);
#line 2590 "mobiReader.c"
	{
		GeeArrayList* _spineItem_list = NULL;
		gint _spineItem_size = 0;
		GeeArrayList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _spineItem_index = 0;
#line 248 "../src/mobiReader.vala"
		_spineItem_list = spineItemsList;
#line 248 "../src/mobiReader.vala"
		_tmp126_ = _spineItem_list;
#line 248 "../src/mobiReader.vala"
		_tmp127_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp126_);
#line 248 "../src/mobiReader.vala"
		_tmp128_ = _tmp127_;
#line 248 "../src/mobiReader.vala"
		_spineItem_size = _tmp128_;
#line 248 "../src/mobiReader.vala"
		_spineItem_index = -1;
#line 248 "../src/mobiReader.vala"
		while (TRUE) {
#line 2612 "mobiReader.c"
			gint _tmp129_;
			gint _tmp130_;
			gchar* spineItem = NULL;
			GeeArrayList* _tmp131_;
			gpointer _tmp132_;
			gint startPosOfSpineItem = 0;
			const gchar* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			gint endPosOfSpineItem = 0;
			const gchar* _tmp136_;
			gboolean _tmp137_ = FALSE;
			gboolean _tmp138_ = FALSE;
			GString* _tmp144_;
			const gchar* _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
#line 248 "../src/mobiReader.vala"
			_spineItem_index = _spineItem_index + 1;
#line 248 "../src/mobiReader.vala"
			_tmp129_ = _spineItem_index;
#line 248 "../src/mobiReader.vala"
			_tmp130_ = _spineItem_size;
#line 248 "../src/mobiReader.vala"
			if (!(_tmp129_ < _tmp130_)) {
#line 248 "../src/mobiReader.vala"
				break;
#line 2640 "mobiReader.c"
			}
#line 248 "../src/mobiReader.vala"
			_tmp131_ = _spineItem_list;
#line 248 "../src/mobiReader.vala"
			_tmp132_ = gee_abstract_list_get ((GeeAbstractList*) _tmp131_, _spineItem_index);
#line 248 "../src/mobiReader.vala"
			spineItem = (gchar*) _tmp132_;
#line 249 "../src/mobiReader.vala"
			_tmp133_ = spineItem;
#line 249 "../src/mobiReader.vala"
			_tmp134_ = strlen ("idref=");
#line 249 "../src/mobiReader.vala"
			_tmp135_ = _tmp134_;
#line 249 "../src/mobiReader.vala"
			startPosOfSpineItem = (string_index_of (_tmp133_, "idref=", 0) + _tmp135_) + 1;
#line 250 "../src/mobiReader.vala"
			_tmp136_ = spineItem;
#line 250 "../src/mobiReader.vala"
			endPosOfSpineItem = string_index_of (_tmp136_, "\"", startPosOfSpineItem + 1);
#line 251 "../src/mobiReader.vala"
			if (startPosOfSpineItem != -1) {
#line 251 "../src/mobiReader.vala"
				_tmp138_ = endPosOfSpineItem != -1;
#line 2664 "mobiReader.c"
			} else {
#line 251 "../src/mobiReader.vala"
				_tmp138_ = FALSE;
#line 2668 "mobiReader.c"
			}
#line 251 "../src/mobiReader.vala"
			if (_tmp138_) {
#line 251 "../src/mobiReader.vala"
				_tmp137_ = endPosOfSpineItem > startPosOfSpineItem;
#line 2674 "mobiReader.c"
			} else {
#line 251 "../src/mobiReader.vala"
				_tmp137_ = FALSE;
#line 2678 "mobiReader.c"
			}
#line 251 "../src/mobiReader.vala"
			if (_tmp137_) {
#line 2682 "mobiReader.c"
				GString* _tmp139_;
				const gchar* _tmp140_;
				gchar* _tmp141_;
				gchar* _tmp142_;
#line 252 "../src/mobiReader.vala"
				_tmp139_ = bufferForSpineData;
#line 252 "../src/mobiReader.vala"
				_tmp140_ = spineItem;
#line 252 "../src/mobiReader.vala"
				_tmp141_ = string_slice (_tmp140_, (glong) startPosOfSpineItem, (glong) endPosOfSpineItem);
#line 252 "../src/mobiReader.vala"
				_tmp142_ = _tmp141_;
#line 252 "../src/mobiReader.vala"
				g_string_assign (_tmp139_, _tmp142_);
#line 252 "../src/mobiReader.vala"
				_g_free0 (_tmp142_);
#line 2699 "mobiReader.c"
			} else {
				GString* _tmp143_;
#line 254 "../src/mobiReader.vala"
				_tmp143_ = bufferForSpineData;
#line 254 "../src/mobiReader.vala"
				g_string_assign (_tmp143_, "");
#line 2706 "mobiReader.c"
			}
#line 256 "../src/mobiReader.vala"
			_tmp144_ = bufferForSpineData;
#line 256 "../src/mobiReader.vala"
			_tmp145_ = _tmp144_->str;
#line 256 "../src/mobiReader.vala"
			_tmp146_ = strlen (_tmp145_);
#line 256 "../src/mobiReader.vala"
			_tmp147_ = _tmp146_;
#line 256 "../src/mobiReader.vala"
			if (_tmp147_ > 0) {
#line 2718 "mobiReader.c"
				{
					GeeArrayList* _manifestItem_list = NULL;
					gint _manifestItem_size = 0;
					GeeArrayList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _manifestItem_index = 0;
#line 258 "../src/mobiReader.vala"
					_manifestItem_list = manifestItemsList;
#line 258 "../src/mobiReader.vala"
					_tmp148_ = _manifestItem_list;
#line 258 "../src/mobiReader.vala"
					_tmp149_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp148_);
#line 258 "../src/mobiReader.vala"
					_tmp150_ = _tmp149_;
#line 258 "../src/mobiReader.vala"
					_manifestItem_size = _tmp150_;
#line 258 "../src/mobiReader.vala"
					_manifestItem_index = -1;
#line 258 "../src/mobiReader.vala"
					while (TRUE) {
#line 2740 "mobiReader.c"
						gint _tmp151_;
						gint _tmp152_;
						gchar* manifestItem = NULL;
						GeeArrayList* _tmp153_;
						gpointer _tmp154_;
						const gchar* _tmp155_;
						GString* _tmp156_;
						const gchar* _tmp157_;
						gchar* _tmp158_;
						gchar* _tmp159_;
						gchar* _tmp160_;
						gchar* _tmp161_;
						gboolean _tmp162_;
#line 258 "../src/mobiReader.vala"
						_manifestItem_index = _manifestItem_index + 1;
#line 258 "../src/mobiReader.vala"
						_tmp151_ = _manifestItem_index;
#line 258 "../src/mobiReader.vala"
						_tmp152_ = _manifestItem_size;
#line 258 "../src/mobiReader.vala"
						if (!(_tmp151_ < _tmp152_)) {
#line 258 "../src/mobiReader.vala"
							break;
#line 2764 "mobiReader.c"
						}
#line 258 "../src/mobiReader.vala"
						_tmp153_ = _manifestItem_list;
#line 258 "../src/mobiReader.vala"
						_tmp154_ = gee_abstract_list_get ((GeeAbstractList*) _tmp153_, _manifestItem_index);
#line 258 "../src/mobiReader.vala"
						manifestItem = (gchar*) _tmp154_;
#line 259 "../src/mobiReader.vala"
						_tmp155_ = manifestItem;
#line 259 "../src/mobiReader.vala"
						_tmp156_ = bufferForSpineData;
#line 259 "../src/mobiReader.vala"
						_tmp157_ = _tmp156_->str;
#line 259 "../src/mobiReader.vala"
						_tmp158_ = g_strconcat ("id=\"", _tmp157_, NULL);
#line 259 "../src/mobiReader.vala"
						_tmp159_ = _tmp158_;
#line 259 "../src/mobiReader.vala"
						_tmp160_ = g_strconcat (_tmp159_, "\"", NULL);
#line 259 "../src/mobiReader.vala"
						_tmp161_ = _tmp160_;
#line 259 "../src/mobiReader.vala"
						_tmp162_ = string_contains (_tmp155_, _tmp161_);
#line 259 "../src/mobiReader.vala"
						_g_free0 (_tmp161_);
#line 259 "../src/mobiReader.vala"
						_g_free0 (_tmp159_);
#line 259 "../src/mobiReader.vala"
						if (_tmp162_) {
#line 2794 "mobiReader.c"
							gint startPosOfContentItem = 0;
							const gchar* _tmp163_;
							gint _tmp164_;
							gint _tmp165_;
							gint endPosOfContentItem = 0;
							const gchar* _tmp166_;
							gboolean _tmp167_ = FALSE;
							gboolean _tmp168_ = FALSE;
#line 260 "../src/mobiReader.vala"
							_tmp163_ = manifestItem;
#line 260 "../src/mobiReader.vala"
							_tmp164_ = strlen ("href=");
#line 260 "../src/mobiReader.vala"
							_tmp165_ = _tmp164_;
#line 260 "../src/mobiReader.vala"
							startPosOfContentItem = (string_index_of (_tmp163_, "href=", 0) + _tmp165_) + 1;
#line 261 "../src/mobiReader.vala"
							_tmp166_ = manifestItem;
#line 261 "../src/mobiReader.vala"
							endPosOfContentItem = string_index_of (_tmp166_, "\"", startPosOfContentItem + 1);
#line 262 "../src/mobiReader.vala"
							if (startPosOfContentItem != -1) {
#line 262 "../src/mobiReader.vala"
								_tmp168_ = endPosOfContentItem != -1;
#line 2819 "mobiReader.c"
							} else {
#line 262 "../src/mobiReader.vala"
								_tmp168_ = FALSE;
#line 2823 "mobiReader.c"
							}
#line 262 "../src/mobiReader.vala"
							if (_tmp168_) {
#line 262 "../src/mobiReader.vala"
								_tmp167_ = endPosOfContentItem > startPosOfContentItem;
#line 2829 "mobiReader.c"
							} else {
#line 262 "../src/mobiReader.vala"
								_tmp167_ = FALSE;
#line 2833 "mobiReader.c"
							}
#line 262 "../src/mobiReader.vala"
							if (_tmp167_) {
#line 2837 "mobiReader.c"
								GString* _tmp169_;
								const gchar* _tmp170_;
								gchar* _tmp171_;
								gchar* _tmp172_;
								GString* _tmp173_;
								const gchar* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								gchar* _tmp177_;
								gchar* _tmp178_;
								GString* _tmp179_;
								const gchar* _tmp180_;
								gchar* _tmp181_;
								gchar* _tmp182_;
								gchar* locationOfBookHTMLFile = NULL;
								gchar* _tmp183_;
								gchar* _tmp184_;
								GString* _tmp185_;
								const gchar* _tmp186_;
								gchar* _tmp187_;
								gchar* _tmp188_;
								GFile* mobiHTMLFile = NULL;
								const gchar* _tmp189_;
								GFile* _tmp190_;
								GFile* _tmp191_;
#line 263 "../src/mobiReader.vala"
								_tmp169_ = bufferForLocationOfContentData;
#line 263 "../src/mobiReader.vala"
								_tmp170_ = manifestItem;
#line 263 "../src/mobiReader.vala"
								_tmp171_ = string_slice (_tmp170_, (glong) startPosOfContentItem, (glong) endPosOfContentItem);
#line 263 "../src/mobiReader.vala"
								_tmp172_ = _tmp171_;
#line 263 "../src/mobiReader.vala"
								g_string_assign (_tmp169_, _tmp172_);
#line 263 "../src/mobiReader.vala"
								_g_free0 (_tmp172_);
#line 264 "../src/mobiReader.vala"
								_tmp173_ = bufferForSpineData;
#line 264 "../src/mobiReader.vala"
								_tmp174_ = _tmp173_->str;
#line 264 "../src/mobiReader.vala"
								_tmp175_ = g_strconcat ("SpineData=", _tmp174_, NULL);
#line 264 "../src/mobiReader.vala"
								_tmp176_ = _tmp175_;
#line 264 "../src/mobiReader.vala"
								_tmp177_ = g_strconcat (_tmp176_, " | LocationOfContentData=", NULL);
#line 264 "../src/mobiReader.vala"
								_tmp178_ = _tmp177_;
#line 264 "../src/mobiReader.vala"
								_tmp179_ = bufferForLocationOfContentData;
#line 264 "../src/mobiReader.vala"
								_tmp180_ = _tmp179_->str;
#line 264 "../src/mobiReader.vala"
								_tmp181_ = g_strconcat (_tmp178_, _tmp180_, NULL);
#line 264 "../src/mobiReader.vala"
								_tmp182_ = _tmp181_;
#line 264 "../src/mobiReader.vala"
								g_debug ("mobiReader.vala:264: %s", _tmp182_);
#line 264 "../src/mobiReader.vala"
								_g_free0 (_tmp182_);
#line 264 "../src/mobiReader.vala"
								_g_free0 (_tmp178_);
#line 264 "../src/mobiReader.vala"
								_g_free0 (_tmp176_);
#line 266 "../src/mobiReader.vala"
								_tmp183_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 266 "../src/mobiReader.vala"
								_tmp184_ = _tmp183_;
#line 266 "../src/mobiReader.vala"
								_tmp185_ = bufferForLocationOfContentData;
#line 266 "../src/mobiReader.vala"
								_tmp186_ = _tmp185_->str;
#line 266 "../src/mobiReader.vala"
								_tmp187_ = g_strconcat (_tmp184_, _tmp186_, NULL);
#line 266 "../src/mobiReader.vala"
								_tmp188_ = _tmp187_;
#line 266 "../src/mobiReader.vala"
								_g_free0 (_tmp184_);
#line 266 "../src/mobiReader.vala"
								locationOfBookHTMLFile = _tmp188_;
#line 267 "../src/mobiReader.vala"
								_tmp189_ = locationOfBookHTMLFile;
#line 267 "../src/mobiReader.vala"
								_tmp190_ = g_file_new_for_path (_tmp189_);
#line 267 "../src/mobiReader.vala"
								mobiHTMLFile = _tmp190_;
#line 268 "../src/mobiReader.vala"
								_tmp191_ = mobiHTMLFile;
#line 268 "../src/mobiReader.vala"
								if (!g_file_query_exists (_tmp191_, NULL)) {
#line 2929 "mobiReader.c"
									const gchar* _tmp192_;
									gchar* _tmp193_;
									gchar* _tmp194_;
#line 269 "../src/mobiReader.vala"
									_tmp192_ = locationOfBookHTMLFile;
#line 269 "../src/mobiReader.vala"
									_tmp193_ = g_strconcat ("Main HTML File for book doesn't exist at location:", _tmp192_, NULL);
#line 269 "../src/mobiReader.vala"
									_tmp194_ = _tmp193_;
#line 269 "../src/mobiReader.vala"
									g_warning ("mobiReader.vala:269: %s", _tmp194_);
#line 269 "../src/mobiReader.vala"
									_g_free0 (_tmp194_);
#line 2943 "mobiReader.c"
								} else {
									GString* mobiHTMLContent = NULL;
									GString* _tmp195_;
									GString* _tmp196_;
									const gchar* _tmp197_;
									gchar* _tmp198_;
									gchar* _tmp199_;
									gint splitStartPos = 0;
									gint splitEndPos = 0;
									GString* _tmp200_;
									const gchar* _tmp201_;
									gint _tmp202_;
									gint _tmp203_;
									GString* tocIDValue = NULL;
									GString* _tmp204_;
									GString* splitFileName = NULL;
									GString* _tmp205_;
									GString* splitHTMLContent = NULL;
									GString* _tmp206_;
									GString* splitPosIdentifierString = NULL;
									GString* _tmp207_;
									GString* tocName = NULL;
									GString* _tmp208_;
									GeeArrayList* _tmp209_;
									gint _tmp210_;
									gint _tmp211_;
#line 272 "../src/mobiReader.vala"
									_tmp195_ = g_string_new ("");
#line 272 "../src/mobiReader.vala"
									mobiHTMLContent = _tmp195_;
#line 273 "../src/mobiReader.vala"
									_tmp196_ = mobiHTMLContent;
#line 273 "../src/mobiReader.vala"
									_tmp197_ = locationOfBookHTMLFile;
#line 273 "../src/mobiReader.vala"
									_tmp198_ = bookworm_app_utils_fileOperations ("READ_FILE", _tmp197_, "", "");
#line 273 "../src/mobiReader.vala"
									_tmp199_ = _tmp198_;
#line 273 "../src/mobiReader.vala"
									g_string_assign (_tmp196_, _tmp199_);
#line 273 "../src/mobiReader.vala"
									_g_free0 (_tmp199_);
#line 274 "../src/mobiReader.vala"
									splitStartPos = 0;
#line 275 "../src/mobiReader.vala"
									_tmp200_ = mobiHTMLContent;
#line 275 "../src/mobiReader.vala"
									_tmp201_ = _tmp200_->str;
#line 275 "../src/mobiReader.vala"
									_tmp202_ = strlen (_tmp201_);
#line 275 "../src/mobiReader.vala"
									_tmp203_ = _tmp202_;
#line 275 "../src/mobiReader.vala"
									splitEndPos = _tmp203_;
#line 276 "../src/mobiReader.vala"
									_tmp204_ = g_string_new ("");
#line 276 "../src/mobiReader.vala"
									tocIDValue = _tmp204_;
#line 277 "../src/mobiReader.vala"
									_tmp205_ = g_string_new ("_(Start)");
#line 277 "../src/mobiReader.vala"
									splitFileName = _tmp205_;
#line 278 "../src/mobiReader.vala"
									_tmp206_ = g_string_new ("");
#line 278 "../src/mobiReader.vala"
									splitHTMLContent = _tmp206_;
#line 279 "../src/mobiReader.vala"
									_tmp207_ = g_string_new ("");
#line 279 "../src/mobiReader.vala"
									splitPosIdentifierString = _tmp207_;
#line 280 "../src/mobiReader.vala"
									_tmp208_ = g_string_new ("");
#line 280 "../src/mobiReader.vala"
									tocName = _tmp208_;
#line 283 "../src/mobiReader.vala"
									_tmp209_ = tocList;
#line 283 "../src/mobiReader.vala"
									_tmp210_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp209_);
#line 283 "../src/mobiReader.vala"
									_tmp211_ = _tmp210_;
#line 283 "../src/mobiReader.vala"
									if (_tmp211_ > 0) {
#line 3026 "mobiReader.c"
										{
											GeeArrayList* _tocItem_list = NULL;
											GeeArrayList* _tmp212_;
											gint _tocItem_size = 0;
											GeeArrayList* _tmp213_;
											gint _tmp214_;
											gint _tmp215_;
											gint _tocItem_index = 0;
#line 284 "../src/mobiReader.vala"
											_tmp212_ = tocList;
#line 284 "../src/mobiReader.vala"
											_tocItem_list = _tmp212_;
#line 284 "../src/mobiReader.vala"
											_tmp213_ = _tocItem_list;
#line 284 "../src/mobiReader.vala"
											_tmp214_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp213_);
#line 284 "../src/mobiReader.vala"
											_tmp215_ = _tmp214_;
#line 284 "../src/mobiReader.vala"
											_tocItem_size = _tmp215_;
#line 284 "../src/mobiReader.vala"
											_tocItem_index = -1;
#line 284 "../src/mobiReader.vala"
											while (TRUE) {
#line 3051 "mobiReader.c"
												gint _tmp216_;
												gint _tmp217_;
												gchar* tocItem = NULL;
												GeeArrayList* _tmp218_;
												gpointer _tmp219_;
												gchar** tocItemAttributes = NULL;
												const gchar* _tmp220_;
												gchar** _tmp221_;
												gchar** _tmp222_;
												gint tocItemAttributes_length1;
												gint _tocItemAttributes_size_;
												gchar** _tmp223_;
												gint _tmp223__length1;
												const gchar* _tmp224_;
												gchar* _tmp225_;
												gchar* _tmp226_;
												GString* _tmp227_;
												gchar** _tmp228_;
												gint _tmp228__length1;
												const gchar* _tmp229_;
												gchar** _tmp230_;
												gint _tmp230__length1;
												const gchar* _tmp231_;
												gchar** _tmp232_;
												gint _tmp232__length1;
												const gchar* _tmp233_;
												gint _tmp234_;
												gint _tmp235_;
												gchar* _tmp236_;
												gchar* _tmp237_;
												GString* _tmp238_;
												GString* _tmp239_;
												const gchar* _tmp240_;
												gchar* _tmp241_;
												gchar* _tmp242_;
												gchar* _tmp243_;
												gchar* _tmp244_;
												GString* _tmp245_;
												const gchar* _tmp246_;
												GString* _tmp247_;
												const gchar* _tmp248_;
#line 284 "../src/mobiReader.vala"
												_tocItem_index = _tocItem_index + 1;
#line 284 "../src/mobiReader.vala"
												_tmp216_ = _tocItem_index;
#line 284 "../src/mobiReader.vala"
												_tmp217_ = _tocItem_size;
#line 284 "../src/mobiReader.vala"
												if (!(_tmp216_ < _tmp217_)) {
#line 284 "../src/mobiReader.vala"
													break;
#line 3103 "mobiReader.c"
												}
#line 284 "../src/mobiReader.vala"
												_tmp218_ = _tocItem_list;
#line 284 "../src/mobiReader.vala"
												_tmp219_ = gee_abstract_list_get ((GeeAbstractList*) _tmp218_, _tocItem_index);
#line 284 "../src/mobiReader.vala"
												tocItem = (gchar*) _tmp219_;
#line 285 "../src/mobiReader.vala"
												_tmp220_ = tocItem;
#line 285 "../src/mobiReader.vala"
												_tmp222_ = _tmp221_ = g_strsplit (_tmp220_, "~~$$~~", -1);
#line 285 "../src/mobiReader.vala"
												tocItemAttributes = _tmp222_;
#line 285 "../src/mobiReader.vala"
												tocItemAttributes_length1 = _vala_array_length (_tmp221_);
#line 285 "../src/mobiReader.vala"
												_tocItemAttributes_size_ = tocItemAttributes_length1;
#line 287 "../src/mobiReader.vala"
												_tmp223_ = tocItemAttributes;
#line 287 "../src/mobiReader.vala"
												_tmp223__length1 = tocItemAttributes_length1;
#line 287 "../src/mobiReader.vala"
												_tmp224_ = _tmp223_[0];
#line 287 "../src/mobiReader.vala"
												_tmp225_ = g_strconcat ("parsing bookmark value:", _tmp224_, NULL);
#line 287 "../src/mobiReader.vala"
												_tmp226_ = _tmp225_;
#line 287 "../src/mobiReader.vala"
												g_debug ("mobiReader.vala:287: %s", _tmp226_);
#line 287 "../src/mobiReader.vala"
												_g_free0 (_tmp226_);
#line 288 "../src/mobiReader.vala"
												_tmp227_ = tocIDValue;
#line 288 "../src/mobiReader.vala"
												_tmp228_ = tocItemAttributes;
#line 288 "../src/mobiReader.vala"
												_tmp228__length1 = tocItemAttributes_length1;
#line 288 "../src/mobiReader.vala"
												_tmp229_ = _tmp228_[0];
#line 288 "../src/mobiReader.vala"
												_tmp230_ = tocItemAttributes;
#line 288 "../src/mobiReader.vala"
												_tmp230__length1 = tocItemAttributes_length1;
#line 288 "../src/mobiReader.vala"
												_tmp231_ = _tmp230_[0];
#line 288 "../src/mobiReader.vala"
												_tmp232_ = tocItemAttributes;
#line 288 "../src/mobiReader.vala"
												_tmp232__length1 = tocItemAttributes_length1;
#line 288 "../src/mobiReader.vala"
												_tmp233_ = _tmp232_[0];
#line 288 "../src/mobiReader.vala"
												_tmp234_ = strlen (_tmp233_);
#line 288 "../src/mobiReader.vala"
												_tmp235_ = _tmp234_;
#line 288 "../src/mobiReader.vala"
												_tmp236_ = string_slice (_tmp229_, (glong) (string_index_of (_tmp231_, "#", 0) + 1), (glong) _tmp235_);
#line 288 "../src/mobiReader.vala"
												_tmp237_ = _tmp236_;
#line 288 "../src/mobiReader.vala"
												g_string_assign (_tmp227_, _tmp237_);
#line 288 "../src/mobiReader.vala"
												_g_free0 (_tmp237_);
#line 289 "../src/mobiReader.vala"
												_tmp238_ = splitPosIdentifierString;
#line 289 "../src/mobiReader.vala"
												_tmp239_ = tocIDValue;
#line 289 "../src/mobiReader.vala"
												_tmp240_ = _tmp239_->str;
#line 289 "../src/mobiReader.vala"
												_tmp241_ = g_strconcat ("<a id=\"", _tmp240_, NULL);
#line 289 "../src/mobiReader.vala"
												_tmp242_ = _tmp241_;
#line 289 "../src/mobiReader.vala"
												_tmp243_ = g_strconcat (_tmp242_, "\"", NULL);
#line 289 "../src/mobiReader.vala"
												_tmp244_ = _tmp243_;
#line 289 "../src/mobiReader.vala"
												g_string_assign (_tmp238_, _tmp244_);
#line 289 "../src/mobiReader.vala"
												_g_free0 (_tmp244_);
#line 289 "../src/mobiReader.vala"
												_g_free0 (_tmp242_);
#line 291 "../src/mobiReader.vala"
												_tmp245_ = mobiHTMLContent;
#line 291 "../src/mobiReader.vala"
												_tmp246_ = _tmp245_->str;
#line 291 "../src/mobiReader.vala"
												_tmp247_ = splitPosIdentifierString;
#line 291 "../src/mobiReader.vala"
												_tmp248_ = _tmp247_->str;
#line 291 "../src/mobiReader.vala"
												if (string_index_of (_tmp246_, _tmp248_, 0) != -1) {
#line 3197 "mobiReader.c"
													GString* _tmp249_;
													GString* _tmp250_;
													const gchar* _tmp251_;
													GString* _tmp252_;
													const gchar* _tmp253_;
													GString* _tmp254_;
													const gchar* _tmp255_;
													gchar* _tmp256_;
													gchar* _tmp257_;
													GString* _tmp258_;
													GString* _tmp259_;
													gchar* _tmp260_;
													gchar* _tmp261_;
													gchar* _tmp262_;
													gchar* _tmp263_;
													GString* _tmp264_;
													const gchar* _tmp265_;
													gchar* _tmp266_;
													gchar* _tmp267_;
													GString* _tmp268_;
													const gchar* _tmp269_;
													gchar* _tmp270_;
													gchar* _tmp271_;
													gchar* _tmp272_;
													gchar* _tmp273_;
													gchar* _tmp274_;
													gchar* _tmp275_;
													GString* _tmp276_;
													const gchar* _tmp277_;
													gchar* _tmp278_;
													gchar* _tmp279_;
													gchar* _tmp280_;
													gchar* _tmp281_;
													GeeHashMap* TOCMapItemUpdated = NULL;
													GeeHashMap* _tmp282_;
													GeeHashMap* _tmp283_;
													gchar* _tmp284_;
													gchar* _tmp285_;
													gchar* _tmp286_;
													gchar* _tmp287_;
													GString* _tmp288_;
													const gchar* _tmp289_;
													gchar* _tmp290_;
													gchar* _tmp291_;
													gchar* _tmp292_;
													gchar* _tmp293_;
													GString* _tmp294_;
													const gchar* _tmp295_;
													GeeHashMap* _tmp296_;
													gchar* _tmp297_;
													gchar* _tmp298_;
													gchar* _tmp299_;
													gchar* _tmp300_;
													gchar* _tmp301_;
													gchar* _tmp302_;
													GString* _tmp303_;
													const gchar* _tmp304_;
													gchar* _tmp305_;
													gchar* _tmp306_;
													gchar* _tmp307_;
													gchar* _tmp308_;
													gchar* _tmp309_;
													gchar* _tmp310_;
													GString* _tmp311_;
													const gchar* _tmp312_;
													gchar* _tmp313_;
													gchar* _tmp314_;
													GString* _tmp315_;
													const gchar* _tmp316_;
													GString* _tmp317_;
													const gchar* _tmp318_;
													GString* _tmp319_;
													GString* _tmp320_;
													const gchar* _tmp321_;
													GString* _tmp322_;
													gchar** _tmp323_;
													gint _tmp323__length1;
													const gchar* _tmp324_;
#line 292 "../src/mobiReader.vala"
													_tmp249_ = splitHTMLContent;
#line 292 "../src/mobiReader.vala"
													_tmp250_ = mobiHTMLContent;
#line 292 "../src/mobiReader.vala"
													_tmp251_ = _tmp250_->str;
#line 292 "../src/mobiReader.vala"
													_tmp252_ = mobiHTMLContent;
#line 292 "../src/mobiReader.vala"
													_tmp253_ = _tmp252_->str;
#line 292 "../src/mobiReader.vala"
													_tmp254_ = splitPosIdentifierString;
#line 292 "../src/mobiReader.vala"
													_tmp255_ = _tmp254_->str;
#line 292 "../src/mobiReader.vala"
													_tmp256_ = string_slice (_tmp251_, (glong) splitStartPos, (glong) string_index_of (_tmp253_, _tmp255_, 0));
#line 292 "../src/mobiReader.vala"
													_tmp257_ = _tmp256_;
#line 292 "../src/mobiReader.vala"
													g_string_assign (_tmp249_, _tmp257_);
#line 292 "../src/mobiReader.vala"
													_g_free0 (_tmp257_);
#line 293 "../src/mobiReader.vala"
													_tmp258_ = splitHTMLContent;
#line 293 "../src/mobiReader.vala"
													g_string_prepend (_tmp258_, "<html><body>");
#line 294 "../src/mobiReader.vala"
													_tmp259_ = splitHTMLContent;
#line 294 "../src/mobiReader.vala"
													g_string_append (_tmp259_, "</body></html>");
#line 296 "../src/mobiReader.vala"
													_tmp260_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 296 "../src/mobiReader.vala"
													_tmp261_ = _tmp260_;
#line 296 "../src/mobiReader.vala"
													_tmp262_ = g_strconcat (_tmp261_, "split_html", NULL);
#line 296 "../src/mobiReader.vala"
													_tmp263_ = _tmp262_;
#line 296 "../src/mobiReader.vala"
													_tmp264_ = splitFileName;
#line 296 "../src/mobiReader.vala"
													_tmp265_ = _tmp264_->str;
#line 296 "../src/mobiReader.vala"
													_tmp266_ = g_strconcat (_tmp265_, ".html", NULL);
#line 296 "../src/mobiReader.vala"
													_tmp267_ = _tmp266_;
#line 296 "../src/mobiReader.vala"
													_tmp268_ = splitHTMLContent;
#line 296 "../src/mobiReader.vala"
													_tmp269_ = _tmp268_->str;
#line 296 "../src/mobiReader.vala"
													_tmp270_ = bookworm_app_utils_fileOperations ("WRITE", _tmp263_, _tmp267_, _tmp269_);
#line 296 "../src/mobiReader.vala"
													_tmp271_ = _tmp270_;
#line 296 "../src/mobiReader.vala"
													_g_free0 (_tmp271_);
#line 296 "../src/mobiReader.vala"
													_g_free0 (_tmp267_);
#line 296 "../src/mobiReader.vala"
													_g_free0 (_tmp263_);
#line 296 "../src/mobiReader.vala"
													_g_free0 (_tmp261_);
#line 298 "../src/mobiReader.vala"
													_tmp272_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 298 "../src/mobiReader.vala"
													_tmp273_ = _tmp272_;
#line 298 "../src/mobiReader.vala"
													_tmp274_ = g_strconcat (_tmp273_, "split_html/", NULL);
#line 298 "../src/mobiReader.vala"
													_tmp275_ = _tmp274_;
#line 298 "../src/mobiReader.vala"
													_tmp276_ = splitFileName;
#line 298 "../src/mobiReader.vala"
													_tmp277_ = _tmp276_->str;
#line 298 "../src/mobiReader.vala"
													_tmp278_ = g_strconcat (_tmp275_, _tmp277_, NULL);
#line 298 "../src/mobiReader.vala"
													_tmp279_ = _tmp278_;
#line 298 "../src/mobiReader.vala"
													_tmp280_ = g_strconcat (_tmp279_, ".html", NULL);
#line 298 "../src/mobiReader.vala"
													_tmp281_ = _tmp280_;
#line 298 "../src/mobiReader.vala"
													bookworm_app_book_setBookContentList (aBook, _tmp281_);
#line 298 "../src/mobiReader.vala"
													_g_free0 (_tmp281_);
#line 298 "../src/mobiReader.vala"
													_g_free0 (_tmp279_);
#line 298 "../src/mobiReader.vala"
													_g_free0 (_tmp275_);
#line 298 "../src/mobiReader.vala"
													_g_free0 (_tmp273_);
#line 300 "../src/mobiReader.vala"
													_tmp282_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 300 "../src/mobiReader.vala"
													TOCMapItemUpdated = _tmp282_;
#line 301 "../src/mobiReader.vala"
													_tmp283_ = TOCMapItemUpdated;
#line 301 "../src/mobiReader.vala"
													_tmp284_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 301 "../src/mobiReader.vala"
													_tmp285_ = _tmp284_;
#line 301 "../src/mobiReader.vala"
													_tmp286_ = g_strconcat (_tmp285_, "split_html/", NULL);
#line 301 "../src/mobiReader.vala"
													_tmp287_ = _tmp286_;
#line 301 "../src/mobiReader.vala"
													_tmp288_ = splitFileName;
#line 301 "../src/mobiReader.vala"
													_tmp289_ = _tmp288_->str;
#line 301 "../src/mobiReader.vala"
													_tmp290_ = g_strconcat (_tmp287_, _tmp289_, NULL);
#line 301 "../src/mobiReader.vala"
													_tmp291_ = _tmp290_;
#line 301 "../src/mobiReader.vala"
													_tmp292_ = g_strconcat (_tmp291_, ".html", NULL);
#line 301 "../src/mobiReader.vala"
													_tmp293_ = _tmp292_;
#line 301 "../src/mobiReader.vala"
													_tmp294_ = tocName;
#line 301 "../src/mobiReader.vala"
													_tmp295_ = _tmp294_->str;
#line 301 "../src/mobiReader.vala"
													gee_abstract_map_set ((GeeAbstractMap*) _tmp283_, _tmp293_, _tmp295_);
#line 301 "../src/mobiReader.vala"
													_g_free0 (_tmp293_);
#line 301 "../src/mobiReader.vala"
													_g_free0 (_tmp291_);
#line 301 "../src/mobiReader.vala"
													_g_free0 (_tmp287_);
#line 301 "../src/mobiReader.vala"
													_g_free0 (_tmp285_);
#line 302 "../src/mobiReader.vala"
													_tmp296_ = TOCMapItemUpdated;
#line 302 "../src/mobiReader.vala"
													bookworm_app_book_setTOC (aBook, _tmp296_);
#line 303 "../src/mobiReader.vala"
													_tmp297_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 303 "../src/mobiReader.vala"
													_tmp298_ = _tmp297_;
#line 303 "../src/mobiReader.vala"
													_tmp299_ = g_strconcat ("Updating TOC:", _tmp298_, NULL);
#line 303 "../src/mobiReader.vala"
													_tmp300_ = _tmp299_;
#line 303 "../src/mobiReader.vala"
													_tmp301_ = g_strconcat (_tmp300_, "split_html/", NULL);
#line 303 "../src/mobiReader.vala"
													_tmp302_ = _tmp301_;
#line 303 "../src/mobiReader.vala"
													_tmp303_ = splitFileName;
#line 303 "../src/mobiReader.vala"
													_tmp304_ = _tmp303_->str;
#line 303 "../src/mobiReader.vala"
													_tmp305_ = g_strconcat (_tmp302_, _tmp304_, NULL);
#line 303 "../src/mobiReader.vala"
													_tmp306_ = _tmp305_;
#line 303 "../src/mobiReader.vala"
													_tmp307_ = g_strconcat (_tmp306_, ".html", NULL);
#line 303 "../src/mobiReader.vala"
													_tmp308_ = _tmp307_;
#line 303 "../src/mobiReader.vala"
													_tmp309_ = g_strconcat (_tmp308_, "::", NULL);
#line 303 "../src/mobiReader.vala"
													_tmp310_ = _tmp309_;
#line 303 "../src/mobiReader.vala"
													_tmp311_ = tocName;
#line 303 "../src/mobiReader.vala"
													_tmp312_ = _tmp311_->str;
#line 303 "../src/mobiReader.vala"
													_tmp313_ = g_strconcat (_tmp310_, _tmp312_, NULL);
#line 303 "../src/mobiReader.vala"
													_tmp314_ = _tmp313_;
#line 303 "../src/mobiReader.vala"
													g_debug ("mobiReader.vala:303: %s", _tmp314_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp314_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp310_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp308_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp306_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp302_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp300_);
#line 303 "../src/mobiReader.vala"
													_g_free0 (_tmp298_);
#line 305 "../src/mobiReader.vala"
													_tmp315_ = mobiHTMLContent;
#line 305 "../src/mobiReader.vala"
													_tmp316_ = _tmp315_->str;
#line 305 "../src/mobiReader.vala"
													_tmp317_ = splitPosIdentifierString;
#line 305 "../src/mobiReader.vala"
													_tmp318_ = _tmp317_->str;
#line 305 "../src/mobiReader.vala"
													splitStartPos = string_index_of (_tmp316_, _tmp318_, 0);
#line 306 "../src/mobiReader.vala"
													_tmp319_ = splitFileName;
#line 306 "../src/mobiReader.vala"
													_tmp320_ = tocIDValue;
#line 306 "../src/mobiReader.vala"
													_tmp321_ = _tmp320_->str;
#line 306 "../src/mobiReader.vala"
													g_string_assign (_tmp319_, _tmp321_);
#line 307 "../src/mobiReader.vala"
													_tmp322_ = tocName;
#line 307 "../src/mobiReader.vala"
													_tmp323_ = tocItemAttributes;
#line 307 "../src/mobiReader.vala"
													_tmp323__length1 = tocItemAttributes_length1;
#line 307 "../src/mobiReader.vala"
													_tmp324_ = _tmp323_[1];
#line 307 "../src/mobiReader.vala"
													g_string_assign (_tmp322_, _tmp324_);
#line 291 "../src/mobiReader.vala"
													_g_object_unref0 (TOCMapItemUpdated);
#line 3494 "mobiReader.c"
												}
#line 284 "../src/mobiReader.vala"
												tocItemAttributes = (_vala_array_free (tocItemAttributes, tocItemAttributes_length1, (GDestroyNotify) g_free), NULL);
#line 284 "../src/mobiReader.vala"
												_g_free0 (tocItem);
#line 3500 "mobiReader.c"
											}
										}
#line 311 "../src/mobiReader.vala"
										if (splitEndPos > splitStartPos) {
#line 3505 "mobiReader.c"
											GString* _tmp325_;
											GString* _tmp326_;
											const gchar* _tmp327_;
											gchar* _tmp328_;
											gchar* _tmp329_;
											GString* _tmp330_;
											GString* _tmp331_;
											gchar* _tmp332_;
											gchar* _tmp333_;
											gchar* _tmp334_;
											gchar* _tmp335_;
											GString* _tmp336_;
											const gchar* _tmp337_;
											gchar* _tmp338_;
											gchar* _tmp339_;
											GString* _tmp340_;
											const gchar* _tmp341_;
											gchar* _tmp342_;
											gchar* _tmp343_;
											gchar* _tmp344_;
											gchar* _tmp345_;
											gchar* _tmp346_;
											gchar* _tmp347_;
											GString* _tmp348_;
											const gchar* _tmp349_;
											gchar* _tmp350_;
											gchar* _tmp351_;
											gchar* _tmp352_;
											gchar* _tmp353_;
											GeeHashMap* TOCMapItem = NULL;
											GeeHashMap* _tmp354_;
											GeeHashMap* _tmp355_;
											gchar* _tmp356_;
											gchar* _tmp357_;
											gchar* _tmp358_;
											gchar* _tmp359_;
											GString* _tmp360_;
											const gchar* _tmp361_;
											gchar* _tmp362_;
											gchar* _tmp363_;
											gchar* _tmp364_;
											gchar* _tmp365_;
											GString* _tmp366_;
											const gchar* _tmp367_;
											GeeHashMap* _tmp368_;
#line 312 "../src/mobiReader.vala"
											_tmp325_ = splitHTMLContent;
#line 312 "../src/mobiReader.vala"
											_tmp326_ = mobiHTMLContent;
#line 312 "../src/mobiReader.vala"
											_tmp327_ = _tmp326_->str;
#line 312 "../src/mobiReader.vala"
											_tmp328_ = string_slice (_tmp327_, (glong) splitStartPos, (glong) splitEndPos);
#line 312 "../src/mobiReader.vala"
											_tmp329_ = _tmp328_;
#line 312 "../src/mobiReader.vala"
											g_string_assign (_tmp325_, _tmp329_);
#line 312 "../src/mobiReader.vala"
											_g_free0 (_tmp329_);
#line 313 "../src/mobiReader.vala"
											_tmp330_ = splitHTMLContent;
#line 313 "../src/mobiReader.vala"
											g_string_prepend (_tmp330_, "<html><body>");
#line 314 "../src/mobiReader.vala"
											_tmp331_ = splitHTMLContent;
#line 314 "../src/mobiReader.vala"
											g_string_append (_tmp331_, "</body></html>");
#line 316 "../src/mobiReader.vala"
											_tmp332_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 316 "../src/mobiReader.vala"
											_tmp333_ = _tmp332_;
#line 316 "../src/mobiReader.vala"
											_tmp334_ = g_strconcat (_tmp333_, "split_html", NULL);
#line 316 "../src/mobiReader.vala"
											_tmp335_ = _tmp334_;
#line 316 "../src/mobiReader.vala"
											_tmp336_ = splitFileName;
#line 316 "../src/mobiReader.vala"
											_tmp337_ = _tmp336_->str;
#line 316 "../src/mobiReader.vala"
											_tmp338_ = g_strconcat (_tmp337_, ".html", NULL);
#line 316 "../src/mobiReader.vala"
											_tmp339_ = _tmp338_;
#line 316 "../src/mobiReader.vala"
											_tmp340_ = splitHTMLContent;
#line 316 "../src/mobiReader.vala"
											_tmp341_ = _tmp340_->str;
#line 316 "../src/mobiReader.vala"
											_tmp342_ = bookworm_app_utils_fileOperations ("WRITE", _tmp335_, _tmp339_, _tmp341_);
#line 316 "../src/mobiReader.vala"
											_tmp343_ = _tmp342_;
#line 316 "../src/mobiReader.vala"
											_g_free0 (_tmp343_);
#line 316 "../src/mobiReader.vala"
											_g_free0 (_tmp339_);
#line 316 "../src/mobiReader.vala"
											_g_free0 (_tmp335_);
#line 316 "../src/mobiReader.vala"
											_g_free0 (_tmp333_);
#line 318 "../src/mobiReader.vala"
											_tmp344_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 318 "../src/mobiReader.vala"
											_tmp345_ = _tmp344_;
#line 318 "../src/mobiReader.vala"
											_tmp346_ = g_strconcat (_tmp345_, "split_html/", NULL);
#line 318 "../src/mobiReader.vala"
											_tmp347_ = _tmp346_;
#line 318 "../src/mobiReader.vala"
											_tmp348_ = splitFileName;
#line 318 "../src/mobiReader.vala"
											_tmp349_ = _tmp348_->str;
#line 318 "../src/mobiReader.vala"
											_tmp350_ = g_strconcat (_tmp347_, _tmp349_, NULL);
#line 318 "../src/mobiReader.vala"
											_tmp351_ = _tmp350_;
#line 318 "../src/mobiReader.vala"
											_tmp352_ = g_strconcat (_tmp351_, ".html", NULL);
#line 318 "../src/mobiReader.vala"
											_tmp353_ = _tmp352_;
#line 318 "../src/mobiReader.vala"
											bookworm_app_book_setBookContentList (aBook, _tmp353_);
#line 318 "../src/mobiReader.vala"
											_g_free0 (_tmp353_);
#line 318 "../src/mobiReader.vala"
											_g_free0 (_tmp351_);
#line 318 "../src/mobiReader.vala"
											_g_free0 (_tmp347_);
#line 318 "../src/mobiReader.vala"
											_g_free0 (_tmp345_);
#line 320 "../src/mobiReader.vala"
											_tmp354_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 320 "../src/mobiReader.vala"
											TOCMapItem = _tmp354_;
#line 321 "../src/mobiReader.vala"
											_tmp355_ = TOCMapItem;
#line 321 "../src/mobiReader.vala"
											_tmp356_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 321 "../src/mobiReader.vala"
											_tmp357_ = _tmp356_;
#line 321 "../src/mobiReader.vala"
											_tmp358_ = g_strconcat (_tmp357_, "split_html/", NULL);
#line 321 "../src/mobiReader.vala"
											_tmp359_ = _tmp358_;
#line 321 "../src/mobiReader.vala"
											_tmp360_ = splitFileName;
#line 321 "../src/mobiReader.vala"
											_tmp361_ = _tmp360_->str;
#line 321 "../src/mobiReader.vala"
											_tmp362_ = g_strconcat (_tmp359_, _tmp361_, NULL);
#line 321 "../src/mobiReader.vala"
											_tmp363_ = _tmp362_;
#line 321 "../src/mobiReader.vala"
											_tmp364_ = g_strconcat (_tmp363_, ".html", NULL);
#line 321 "../src/mobiReader.vala"
											_tmp365_ = _tmp364_;
#line 321 "../src/mobiReader.vala"
											_tmp366_ = tocName;
#line 321 "../src/mobiReader.vala"
											_tmp367_ = _tmp366_->str;
#line 321 "../src/mobiReader.vala"
											gee_abstract_map_set ((GeeAbstractMap*) _tmp355_, _tmp365_, _tmp367_);
#line 321 "../src/mobiReader.vala"
											_g_free0 (_tmp365_);
#line 321 "../src/mobiReader.vala"
											_g_free0 (_tmp363_);
#line 321 "../src/mobiReader.vala"
											_g_free0 (_tmp359_);
#line 321 "../src/mobiReader.vala"
											_g_free0 (_tmp357_);
#line 322 "../src/mobiReader.vala"
											_tmp368_ = TOCMapItem;
#line 322 "../src/mobiReader.vala"
											bookworm_app_book_setTOC (aBook, _tmp368_);
#line 311 "../src/mobiReader.vala"
											_g_object_unref0 (TOCMapItem);
#line 3681 "mobiReader.c"
										}
									} else {
										const gchar* _tmp369_;
										GeeHashMap* TOCMapItem = NULL;
										GeeHashMap* _tmp370_;
										GeeHashMap* _tmp371_;
										const gchar* _tmp372_;
										GeeHashMap* _tmp373_;
#line 326 "../src/mobiReader.vala"
										_tmp369_ = locationOfBookHTMLFile;
#line 326 "../src/mobiReader.vala"
										bookworm_app_book_setBookContentList (aBook, _tmp369_);
#line 328 "../src/mobiReader.vala"
										_tmp370_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 328 "../src/mobiReader.vala"
										TOCMapItem = _tmp370_;
#line 329 "../src/mobiReader.vala"
										_tmp371_ = TOCMapItem;
#line 329 "../src/mobiReader.vala"
										_tmp372_ = locationOfBookHTMLFile;
#line 329 "../src/mobiReader.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp371_, _tmp372_, _ ("Book"));
#line 330 "../src/mobiReader.vala"
										_tmp373_ = TOCMapItem;
#line 330 "../src/mobiReader.vala"
										bookworm_app_book_setTOC (aBook, _tmp373_);
#line 283 "../src/mobiReader.vala"
										_g_object_unref0 (TOCMapItem);
#line 3710 "mobiReader.c"
									}
#line 268 "../src/mobiReader.vala"
									_g_string_free0 (tocName);
#line 268 "../src/mobiReader.vala"
									_g_string_free0 (splitPosIdentifierString);
#line 268 "../src/mobiReader.vala"
									_g_string_free0 (splitHTMLContent);
#line 268 "../src/mobiReader.vala"
									_g_string_free0 (splitFileName);
#line 268 "../src/mobiReader.vala"
									_g_string_free0 (tocIDValue);
#line 268 "../src/mobiReader.vala"
									_g_string_free0 (mobiHTMLContent);
#line 3724 "mobiReader.c"
								}
#line 262 "../src/mobiReader.vala"
								_g_object_unref0 (mobiHTMLFile);
#line 262 "../src/mobiReader.vala"
								_g_free0 (locationOfBookHTMLFile);
#line 3730 "mobiReader.c"
							}
#line 362 "../src/mobiReader.vala"
							_g_free0 (manifestItem);
#line 362 "../src/mobiReader.vala"
							break;
#line 3736 "mobiReader.c"
						}
#line 258 "../src/mobiReader.vala"
						_g_free0 (manifestItem);
#line 3740 "mobiReader.c"
					}
				}
			}
#line 248 "../src/mobiReader.vala"
			_g_free0 (spineItem);
#line 3746 "mobiReader.c"
		}
	}
#line 367 "../src/mobiReader.vala"
	_tmp374_ = tocList;
#line 367 "../src/mobiReader.vala"
	_tmp375_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp374_);
#line 367 "../src/mobiReader.vala"
	_tmp376_ = _tmp375_;
#line 367 "../src/mobiReader.vala"
	_tmp377_ = g_strdup_printf ("%i", _tmp376_);
#line 367 "../src/mobiReader.vala"
	_tmp378_ = _tmp377_;
#line 367 "../src/mobiReader.vala"
	_tmp379_ = g_strconcat ("[END] [FUNCTION:getContentList] tocList.size=", _tmp378_, NULL);
#line 367 "../src/mobiReader.vala"
	_tmp380_ = _tmp379_;
#line 367 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:367: %s", _tmp380_);
#line 367 "../src/mobiReader.vala"
	_g_free0 (_tmp380_);
#line 367 "../src/mobiReader.vala"
	_g_free0 (_tmp378_);
#line 368 "../src/mobiReader.vala"
	_tmp381_ = _bookworm_app_book_ref0 (aBook);
#line 368 "../src/mobiReader.vala"
	result = _tmp381_;
#line 368 "../src/mobiReader.vala"
	_g_object_unref0 (tocList);
#line 368 "../src/mobiReader.vala"
	_g_string_free0 (bufferForLocationOfContentData);
#line 368 "../src/mobiReader.vala"
	_g_string_free0 (bufferForSpineData);
#line 368 "../src/mobiReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 368 "../src/mobiReader.vala"
	return result;
#line 3783 "mobiReader.c"
}

BookwormAppBook*
bookworm_app_mobi_reader_setCoverImage (BookwormAppBook* aBook,
                                        GeeArrayList* manifestItemsList)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* bookCoverLocation = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	BookwormAppBook* _tmp41_;
	BookwormAppBook* result;
#line 371 "../src/mobiReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 371 "../src/mobiReader.vala"
	g_return_val_if_fail (manifestItemsList != NULL, NULL);
#line 372 "../src/mobiReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 372 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 372 "../src/mobiReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setCoverImage] book.location=", _tmp1_, NULL);
#line 372 "../src/mobiReader.vala"
	_tmp3_ = _tmp2_;
#line 372 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:372: %s", _tmp3_);
#line 372 "../src/mobiReader.vala"
	_g_free0 (_tmp3_);
#line 372 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 373 "../src/mobiReader.vala"
	_tmp4_ = g_strdup ("");
#line 373 "../src/mobiReader.vala"
	bookCoverLocation = _tmp4_;
#line 375 "../src/mobiReader.vala"
	_tmp6_ = bookworm_app_mobi_reader_OpfContents;
#line 375 "../src/mobiReader.vala"
	if (string_contains (_tmp6_, "<meta name=\"Cover ThumbNail Image\"")) {
#line 3831 "mobiReader.c"
		const gchar* _tmp7_;
#line 375 "../src/mobiReader.vala"
		_tmp7_ = bookworm_app_mobi_reader_OpfContents;
#line 375 "../src/mobiReader.vala"
		_tmp5_ = string_contains (_tmp7_, "content=\"");
#line 3837 "mobiReader.c"
	} else {
#line 375 "../src/mobiReader.vala"
		_tmp5_ = FALSE;
#line 3841 "mobiReader.c"
	}
#line 375 "../src/mobiReader.vala"
	if (_tmp5_) {
#line 3845 "mobiReader.c"
		gint startOfCoverImageLocation = 0;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint endOfCoverImageLocation = 0;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 376 "../src/mobiReader.vala"
		_tmp8_ = bookworm_app_mobi_reader_OpfContents;
#line 376 "../src/mobiReader.vala"
		_tmp9_ = bookworm_app_mobi_reader_OpfContents;
#line 376 "../src/mobiReader.vala"
		startOfCoverImageLocation = string_index_of (_tmp8_, "content=\"", string_index_of (_tmp9_, "<meta name=\"Cover ThumbNail Image\"", 0));
#line 377 "../src/mobiReader.vala"
		_tmp10_ = bookworm_app_mobi_reader_OpfContents;
#line 377 "../src/mobiReader.vala"
		endOfCoverImageLocation = string_index_of (_tmp10_, "\" />", startOfCoverImageLocation);
#line 378 "../src/mobiReader.vala"
		if (startOfCoverImageLocation != -1) {
#line 378 "../src/mobiReader.vala"
			_tmp12_ = endOfCoverImageLocation != -1;
#line 3867 "mobiReader.c"
		} else {
#line 378 "../src/mobiReader.vala"
			_tmp12_ = FALSE;
#line 3871 "mobiReader.c"
		}
#line 378 "../src/mobiReader.vala"
		if (_tmp12_) {
#line 378 "../src/mobiReader.vala"
			_tmp11_ = endOfCoverImageLocation > startOfCoverImageLocation;
#line 3877 "mobiReader.c"
		} else {
#line 378 "../src/mobiReader.vala"
			_tmp11_ = FALSE;
#line 3881 "mobiReader.c"
		}
#line 378 "../src/mobiReader.vala"
		if (_tmp11_) {
#line 3885 "mobiReader.c"
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
#line 379 "../src/mobiReader.vala"
			_tmp13_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 379 "../src/mobiReader.vala"
			_tmp14_ = _tmp13_;
#line 379 "../src/mobiReader.vala"
			_tmp15_ = bookworm_app_mobi_reader_OpfContents;
#line 379 "../src/mobiReader.vala"
			_tmp16_ = strlen ("content=\"");
#line 379 "../src/mobiReader.vala"
			_tmp17_ = _tmp16_;
#line 379 "../src/mobiReader.vala"
			_tmp18_ = string_slice (_tmp15_, (glong) (startOfCoverImageLocation + _tmp17_), (glong) endOfCoverImageLocation);
#line 379 "../src/mobiReader.vala"
			_tmp19_ = _tmp18_;
#line 379 "../src/mobiReader.vala"
			_tmp20_ = bookworm_app_utils_decodeHTMLChars (_tmp19_);
#line 379 "../src/mobiReader.vala"
			_tmp21_ = _tmp20_;
#line 379 "../src/mobiReader.vala"
			_tmp22_ = g_strconcat (_tmp14_, _tmp21_, NULL);
#line 379 "../src/mobiReader.vala"
			_g_free0 (bookCoverLocation);
#line 379 "../src/mobiReader.vala"
			bookCoverLocation = _tmp22_;
#line 379 "../src/mobiReader.vala"
			_g_free0 (_tmp21_);
#line 379 "../src/mobiReader.vala"
			_g_free0 (_tmp19_);
#line 379 "../src/mobiReader.vala"
			_g_free0 (_tmp14_);
#line 381 "../src/mobiReader.vala"
			_tmp23_ = bookCoverLocation;
#line 381 "../src/mobiReader.vala"
			_tmp24_ = g_strconcat ("Determined eBook Cover Image Location as:", _tmp23_, NULL);
#line 381 "../src/mobiReader.vala"
			_tmp25_ = _tmp24_;
#line 381 "../src/mobiReader.vala"
			g_debug ("mobiReader.vala:381: %s", _tmp25_);
#line 381 "../src/mobiReader.vala"
			_g_free0 (_tmp25_);
#line 3939 "mobiReader.c"
		}
	}
#line 385 "../src/mobiReader.vala"
	_tmp27_ = bookCoverLocation;
#line 385 "../src/mobiReader.vala"
	if (_tmp27_ == NULL) {
#line 385 "../src/mobiReader.vala"
		_tmp26_ = TRUE;
#line 3948 "mobiReader.c"
	} else {
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
#line 385 "../src/mobiReader.vala"
		_tmp28_ = bookCoverLocation;
#line 385 "../src/mobiReader.vala"
		_tmp29_ = strlen (_tmp28_);
#line 385 "../src/mobiReader.vala"
		_tmp30_ = _tmp29_;
#line 385 "../src/mobiReader.vala"
		_tmp26_ = _tmp30_ < 1;
#line 3961 "mobiReader.c"
	}
#line 385 "../src/mobiReader.vala"
	if (_tmp26_) {
#line 3965 "mobiReader.c"
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
#line 386 "../src/mobiReader.vala"
		bookworm_app_book_setIsBookCoverImagePresent (aBook, FALSE);
#line 387 "../src/mobiReader.vala"
		_tmp31_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 387 "../src/mobiReader.vala"
		_tmp32_ = _tmp31_;
#line 387 "../src/mobiReader.vala"
		_tmp33_ = g_strconcat ("Cover image not found for book located at:", _tmp32_, NULL);
#line 387 "../src/mobiReader.vala"
		_tmp34_ = _tmp33_;
#line 387 "../src/mobiReader.vala"
		g_debug ("mobiReader.vala:387: %s", _tmp34_);
#line 387 "../src/mobiReader.vala"
		_g_free0 (_tmp34_);
#line 387 "../src/mobiReader.vala"
		_g_free0 (_tmp32_);
#line 3986 "mobiReader.c"
	} else {
		BookwormAppBook* _tmp35_;
		const gchar* _tmp36_;
		BookwormAppBook* _tmp37_;
#line 390 "../src/mobiReader.vala"
		_tmp35_ = _bookworm_app_book_ref0 (aBook);
#line 390 "../src/mobiReader.vala"
		_tmp36_ = bookCoverLocation;
#line 390 "../src/mobiReader.vala"
		_tmp37_ = bookworm_app_utils_setBookCoverImage (_tmp35_, _tmp36_);
#line 390 "../src/mobiReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 390 "../src/mobiReader.vala"
		aBook = _tmp37_;
#line 4001 "mobiReader.c"
	}
#line 392 "../src/mobiReader.vala"
	_tmp38_ = bookCoverLocation;
#line 392 "../src/mobiReader.vala"
	_tmp39_ = g_strconcat ("[END] [FUNCTION:setCoverImage] bookCoverLocation=", _tmp38_, NULL);
#line 392 "../src/mobiReader.vala"
	_tmp40_ = _tmp39_;
#line 392 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:392: %s", _tmp40_);
#line 392 "../src/mobiReader.vala"
	_g_free0 (_tmp40_);
#line 393 "../src/mobiReader.vala"
	_tmp41_ = _bookworm_app_book_ref0 (aBook);
#line 393 "../src/mobiReader.vala"
	result = _tmp41_;
#line 393 "../src/mobiReader.vala"
	_g_free0 (bookCoverLocation);
#line 393 "../src/mobiReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 393 "../src/mobiReader.vala"
	return result;
#line 4023 "mobiReader.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 4047 "mobiReader.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 4055 "mobiReader.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 4061 "mobiReader.c"
	}
}

BookwormAppBook*
bookworm_app_mobi_reader_setBookMetaData (BookwormAppBook* aBook,
                                          const gchar* locationOfOPFFile)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp29_ = FALSE;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	BookwormAppBook* _tmp68_;
	BookwormAppBook* result;
#line 396 "../src/mobiReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 396 "../src/mobiReader.vala"
	g_return_val_if_fail (locationOfOPFFile != NULL, NULL);
#line 397 "../src/mobiReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 397 "../src/mobiReader.vala"
	_tmp1_ = _tmp0_;
#line 397 "../src/mobiReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setBookMetaData] book.location=", _tmp1_, NULL);
#line 397 "../src/mobiReader.vala"
	_tmp3_ = _tmp2_;
#line 397 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:397: %s", _tmp3_);
#line 397 "../src/mobiReader.vala"
	_g_free0 (_tmp3_);
#line 397 "../src/mobiReader.vala"
	_g_free0 (_tmp1_);
#line 399 "../src/mobiReader.vala"
	_tmp5_ = bookworm_app_book_getBookTitle (aBook);
#line 399 "../src/mobiReader.vala"
	_tmp6_ = _tmp5_;
#line 399 "../src/mobiReader.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 399 "../src/mobiReader.vala"
	_g_free0 (_tmp6_);
#line 399 "../src/mobiReader.vala"
	if (_tmp7_) {
#line 4113 "mobiReader.c"
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 399 "../src/mobiReader.vala"
		_tmp8_ = bookworm_app_book_getBookTitle (aBook);
#line 399 "../src/mobiReader.vala"
		_tmp9_ = _tmp8_;
#line 399 "../src/mobiReader.vala"
		_tmp10_ = strlen (_tmp9_);
#line 399 "../src/mobiReader.vala"
		_tmp11_ = _tmp10_;
#line 399 "../src/mobiReader.vala"
		_tmp4_ = _tmp11_ < 1;
#line 399 "../src/mobiReader.vala"
		_g_free0 (_tmp9_);
#line 4130 "mobiReader.c"
	} else {
#line 399 "../src/mobiReader.vala"
		_tmp4_ = FALSE;
#line 4134 "mobiReader.c"
	}
#line 399 "../src/mobiReader.vala"
	if (_tmp4_) {
#line 4138 "mobiReader.c"
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
#line 400 "../src/mobiReader.vala"
		_tmp13_ = bookworm_app_mobi_reader_OpfContents;
#line 400 "../src/mobiReader.vala"
		if (string_contains (_tmp13_, "<dc:title")) {
#line 4145 "mobiReader.c"
			const gchar* _tmp14_;
#line 400 "../src/mobiReader.vala"
			_tmp14_ = bookworm_app_mobi_reader_OpfContents;
#line 400 "../src/mobiReader.vala"
			_tmp12_ = string_contains (_tmp14_, "</dc:title>");
#line 4151 "mobiReader.c"
		} else {
#line 400 "../src/mobiReader.vala"
			_tmp12_ = FALSE;
#line 4155 "mobiReader.c"
		}
#line 400 "../src/mobiReader.vala"
		if (_tmp12_) {
#line 4159 "mobiReader.c"
			gint startOfTitleText = 0;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gint endOfTittleText = 0;
			const gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
#line 401 "../src/mobiReader.vala"
			_tmp15_ = bookworm_app_mobi_reader_OpfContents;
#line 401 "../src/mobiReader.vala"
			_tmp16_ = bookworm_app_mobi_reader_OpfContents;
#line 401 "../src/mobiReader.vala"
			startOfTitleText = string_index_of (_tmp15_, ">", string_index_of (_tmp16_, "<dc:title", 0));
#line 402 "../src/mobiReader.vala"
			_tmp17_ = bookworm_app_mobi_reader_OpfContents;
#line 402 "../src/mobiReader.vala"
			endOfTittleText = string_index_of (_tmp17_, "</dc:title>", startOfTitleText);
#line 403 "../src/mobiReader.vala"
			if (startOfTitleText != -1) {
#line 403 "../src/mobiReader.vala"
				_tmp19_ = endOfTittleText != -1;
#line 4181 "mobiReader.c"
			} else {
#line 403 "../src/mobiReader.vala"
				_tmp19_ = FALSE;
#line 4185 "mobiReader.c"
			}
#line 403 "../src/mobiReader.vala"
			if (_tmp19_) {
#line 403 "../src/mobiReader.vala"
				_tmp18_ = endOfTittleText > startOfTitleText;
#line 4191 "mobiReader.c"
			} else {
#line 403 "../src/mobiReader.vala"
				_tmp18_ = FALSE;
#line 4195 "mobiReader.c"
			}
#line 403 "../src/mobiReader.vala"
			if (_tmp18_) {
#line 4199 "mobiReader.c"
				gchar* bookTitle = NULL;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
#line 404 "../src/mobiReader.vala"
				_tmp20_ = bookworm_app_mobi_reader_OpfContents;
#line 404 "../src/mobiReader.vala"
				_tmp21_ = string_slice (_tmp20_, (glong) (startOfTitleText + 1), (glong) endOfTittleText);
#line 404 "../src/mobiReader.vala"
				_tmp22_ = _tmp21_;
#line 404 "../src/mobiReader.vala"
				_tmp23_ = bookworm_app_utils_decodeHTMLChars (_tmp22_);
#line 404 "../src/mobiReader.vala"
				_tmp24_ = _tmp23_;
#line 404 "../src/mobiReader.vala"
				_g_free0 (_tmp22_);
#line 404 "../src/mobiReader.vala"
				bookTitle = _tmp24_;
#line 405 "../src/mobiReader.vala"
				_tmp25_ = bookTitle;
#line 405 "../src/mobiReader.vala"
				bookworm_app_book_setBookTitle (aBook, _tmp25_);
#line 406 "../src/mobiReader.vala"
				_tmp26_ = bookTitle;
#line 406 "../src/mobiReader.vala"
				_tmp27_ = g_strconcat ("Determined eBook Title as:", _tmp26_, NULL);
#line 406 "../src/mobiReader.vala"
				_tmp28_ = _tmp27_;
#line 406 "../src/mobiReader.vala"
				g_debug ("mobiReader.vala:406: %s", _tmp28_);
#line 406 "../src/mobiReader.vala"
				_g_free0 (_tmp28_);
#line 403 "../src/mobiReader.vala"
				_g_free0 (bookTitle);
#line 4240 "mobiReader.c"
			}
		}
	}
#line 411 "../src/mobiReader.vala"
	_tmp30_ = bookworm_app_book_getBookTitle (aBook);
#line 411 "../src/mobiReader.vala"
	_tmp31_ = _tmp30_;
#line 411 "../src/mobiReader.vala"
	_tmp32_ = _tmp31_ != NULL;
#line 411 "../src/mobiReader.vala"
	_g_free0 (_tmp31_);
#line 411 "../src/mobiReader.vala"
	if (_tmp32_) {
#line 4254 "mobiReader.c"
		gchar* _tmp33_;
		gchar* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
#line 411 "../src/mobiReader.vala"
		_tmp33_ = bookworm_app_book_getBookTitle (aBook);
#line 411 "../src/mobiReader.vala"
		_tmp34_ = _tmp33_;
#line 411 "../src/mobiReader.vala"
		_tmp35_ = strlen (_tmp34_);
#line 411 "../src/mobiReader.vala"
		_tmp36_ = _tmp35_;
#line 411 "../src/mobiReader.vala"
		_tmp29_ = _tmp36_ < 1;
#line 411 "../src/mobiReader.vala"
		_g_free0 (_tmp34_);
#line 4271 "mobiReader.c"
	} else {
#line 411 "../src/mobiReader.vala"
		_tmp29_ = FALSE;
#line 4275 "mobiReader.c"
	}
#line 411 "../src/mobiReader.vala"
	if (_tmp29_) {
#line 4279 "mobiReader.c"
		gchar* bookTitle = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GFile* _tmp39_;
		GFile* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
#line 412 "../src/mobiReader.vala"
		_tmp37_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 412 "../src/mobiReader.vala"
		_tmp38_ = _tmp37_;
#line 412 "../src/mobiReader.vala"
		_tmp39_ = g_file_new_for_path (_tmp38_);
#line 412 "../src/mobiReader.vala"
		_tmp40_ = _tmp39_;
#line 412 "../src/mobiReader.vala"
		_tmp41_ = g_file_get_basename (_tmp40_);
#line 412 "../src/mobiReader.vala"
		_tmp42_ = _tmp41_;
#line 412 "../src/mobiReader.vala"
		_g_object_unref0 (_tmp40_);
#line 412 "../src/mobiReader.vala"
		_g_free0 (_tmp38_);
#line 412 "../src/mobiReader.vala"
		bookTitle = _tmp42_;
#line 413 "../src/mobiReader.vala"
		_tmp43_ = bookTitle;
#line 413 "../src/mobiReader.vala"
		if (string_last_index_of (_tmp43_, ".", 0) != -1) {
#line 4314 "mobiReader.c"
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
#line 414 "../src/mobiReader.vala"
			_tmp44_ = bookTitle;
#line 414 "../src/mobiReader.vala"
			_tmp45_ = bookTitle;
#line 414 "../src/mobiReader.vala"
			_tmp46_ = string_slice (_tmp44_, (glong) 0, (glong) string_last_index_of (_tmp45_, ".", 0));
#line 414 "../src/mobiReader.vala"
			_g_free0 (bookTitle);
#line 414 "../src/mobiReader.vala"
			bookTitle = _tmp46_;
#line 4328 "mobiReader.c"
		}
#line 416 "../src/mobiReader.vala"
		_tmp47_ = bookTitle;
#line 416 "../src/mobiReader.vala"
		bookworm_app_book_setBookTitle (aBook, _tmp47_);
#line 417 "../src/mobiReader.vala"
		_tmp48_ = bookTitle;
#line 417 "../src/mobiReader.vala"
		_tmp49_ = g_strconcat ("File name set as Title:", _tmp48_, NULL);
#line 417 "../src/mobiReader.vala"
		_tmp50_ = _tmp49_;
#line 417 "../src/mobiReader.vala"
		g_debug ("mobiReader.vala:417: %s", _tmp50_);
#line 417 "../src/mobiReader.vala"
		_g_free0 (_tmp50_);
#line 411 "../src/mobiReader.vala"
		_g_free0 (bookTitle);
#line 4346 "mobiReader.c"
	}
#line 421 "../src/mobiReader.vala"
	_tmp52_ = bookworm_app_mobi_reader_OpfContents;
#line 421 "../src/mobiReader.vala"
	if (string_contains (_tmp52_, "<dc:creator")) {
#line 4352 "mobiReader.c"
		const gchar* _tmp53_;
#line 421 "../src/mobiReader.vala"
		_tmp53_ = bookworm_app_mobi_reader_OpfContents;
#line 421 "../src/mobiReader.vala"
		_tmp51_ = string_contains (_tmp53_, "</dc:creator>");
#line 4358 "mobiReader.c"
	} else {
#line 421 "../src/mobiReader.vala"
		_tmp51_ = FALSE;
#line 4362 "mobiReader.c"
	}
#line 421 "../src/mobiReader.vala"
	if (_tmp51_) {
#line 4366 "mobiReader.c"
		gint startOfAuthorText = 0;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gint endOfAuthorText = 0;
		const gchar* _tmp56_;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
#line 422 "../src/mobiReader.vala"
		_tmp54_ = bookworm_app_mobi_reader_OpfContents;
#line 422 "../src/mobiReader.vala"
		_tmp55_ = bookworm_app_mobi_reader_OpfContents;
#line 422 "../src/mobiReader.vala"
		startOfAuthorText = string_index_of (_tmp54_, ">", string_index_of (_tmp55_, "<dc:creator", 0));
#line 423 "../src/mobiReader.vala"
		_tmp56_ = bookworm_app_mobi_reader_OpfContents;
#line 423 "../src/mobiReader.vala"
		endOfAuthorText = string_index_of (_tmp56_, "</dc:creator>", startOfAuthorText);
#line 424 "../src/mobiReader.vala"
		if (startOfAuthorText != -1) {
#line 424 "../src/mobiReader.vala"
			_tmp58_ = endOfAuthorText != -1;
#line 4388 "mobiReader.c"
		} else {
#line 424 "../src/mobiReader.vala"
			_tmp58_ = FALSE;
#line 4392 "mobiReader.c"
		}
#line 424 "../src/mobiReader.vala"
		if (_tmp58_) {
#line 424 "../src/mobiReader.vala"
			_tmp57_ = endOfAuthorText > startOfAuthorText;
#line 4398 "mobiReader.c"
		} else {
#line 424 "../src/mobiReader.vala"
			_tmp57_ = FALSE;
#line 4402 "mobiReader.c"
		}
#line 424 "../src/mobiReader.vala"
		if (_tmp57_) {
#line 4406 "mobiReader.c"
			gchar* bookAuthor = NULL;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
#line 425 "../src/mobiReader.vala"
			_tmp59_ = bookworm_app_mobi_reader_OpfContents;
#line 425 "../src/mobiReader.vala"
			_tmp60_ = string_slice (_tmp59_, (glong) (startOfAuthorText + 1), (glong) endOfAuthorText);
#line 425 "../src/mobiReader.vala"
			_tmp61_ = _tmp60_;
#line 425 "../src/mobiReader.vala"
			_tmp62_ = bookworm_app_utils_decodeHTMLChars (_tmp61_);
#line 425 "../src/mobiReader.vala"
			_tmp63_ = _tmp62_;
#line 425 "../src/mobiReader.vala"
			_g_free0 (_tmp61_);
#line 425 "../src/mobiReader.vala"
			bookAuthor = _tmp63_;
#line 426 "../src/mobiReader.vala"
			_tmp64_ = bookAuthor;
#line 426 "../src/mobiReader.vala"
			bookworm_app_book_setBookAuthor (aBook, _tmp64_);
#line 427 "../src/mobiReader.vala"
			_tmp65_ = bookAuthor;
#line 427 "../src/mobiReader.vala"
			_tmp66_ = g_strconcat ("Determined eBook Author as:", _tmp65_, NULL);
#line 427 "../src/mobiReader.vala"
			_tmp67_ = _tmp66_;
#line 427 "../src/mobiReader.vala"
			g_debug ("mobiReader.vala:427: %s", _tmp67_);
#line 427 "../src/mobiReader.vala"
			_g_free0 (_tmp67_);
#line 424 "../src/mobiReader.vala"
			_g_free0 (bookAuthor);
#line 4447 "mobiReader.c"
		} else {
#line 429 "../src/mobiReader.vala"
			bookworm_app_book_setBookAuthor (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 430 "../src/mobiReader.vala"
			g_debug ("mobiReader.vala:430: Could not determine eBook Author, default Author " \
"set");
#line 4453 "mobiReader.c"
		}
	} else {
#line 433 "../src/mobiReader.vala"
		bookworm_app_book_setBookAuthor (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 434 "../src/mobiReader.vala"
		g_debug ("mobiReader.vala:434: Could not determine eBook Author, default title s" \
"et");
#line 4460 "mobiReader.c"
	}
#line 436 "../src/mobiReader.vala"
	g_info ("mobiReader.vala:436: [END] [FUNCTION:setBookMetaData]");
#line 437 "../src/mobiReader.vala"
	_tmp68_ = _bookworm_app_book_ref0 (aBook);
#line 437 "../src/mobiReader.vala"
	result = _tmp68_;
#line 437 "../src/mobiReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 437 "../src/mobiReader.vala"
	return result;
#line 4472 "mobiReader.c"
}

BookwormAppmobiReader*
bookworm_app_mobi_reader_construct (GType object_type)
{
	BookwormAppmobiReader* self = NULL;
#line 22 "../src/mobiReader.vala"
	self = (BookwormAppmobiReader*) g_type_create_instance (object_type);
#line 22 "../src/mobiReader.vala"
	return self;
#line 4483 "mobiReader.c"
}

BookwormAppmobiReader*
bookworm_app_mobi_reader_new (void)
{
#line 22 "../src/mobiReader.vala"
	return bookworm_app_mobi_reader_construct (BOOKWORM_APP_TYPE_MOBI_READER);
#line 4491 "mobiReader.c"
}

static void
bookworm_app_value_mobi_reader_init (GValue* value)
{
#line 22 "../src/mobiReader.vala"
	value->data[0].v_pointer = NULL;
#line 4499 "mobiReader.c"
}

static void
bookworm_app_value_mobi_reader_free_value (GValue* value)
{
#line 22 "../src/mobiReader.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/mobiReader.vala"
		bookworm_app_mobi_reader_unref (value->data[0].v_pointer);
#line 4509 "mobiReader.c"
	}
}

static void
bookworm_app_value_mobi_reader_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
#line 22 "../src/mobiReader.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/mobiReader.vala"
		dest_value->data[0].v_pointer = bookworm_app_mobi_reader_ref (src_value->data[0].v_pointer);
#line 4521 "mobiReader.c"
	} else {
#line 22 "../src/mobiReader.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4525 "mobiReader.c"
	}
}

static gpointer
bookworm_app_value_mobi_reader_peek_pointer (const GValue* value)
{
#line 22 "../src/mobiReader.vala"
	return value->data[0].v_pointer;
#line 4534 "mobiReader.c"
}

static gchar*
bookworm_app_value_mobi_reader_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
#line 22 "../src/mobiReader.vala"
	if (collect_values[0].v_pointer) {
#line 4545 "mobiReader.c"
		BookwormAppmobiReader * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/mobiReader.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/mobiReader.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4552 "mobiReader.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/mobiReader.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4556 "mobiReader.c"
		}
#line 22 "../src/mobiReader.vala"
		value->data[0].v_pointer = bookworm_app_mobi_reader_ref (object);
#line 4560 "mobiReader.c"
	} else {
#line 22 "../src/mobiReader.vala"
		value->data[0].v_pointer = NULL;
#line 4564 "mobiReader.c"
	}
#line 22 "../src/mobiReader.vala"
	return NULL;
#line 4568 "mobiReader.c"
}

static gchar*
bookworm_app_value_mobi_reader_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	BookwormAppmobiReader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/mobiReader.vala"
	if (!object_p) {
#line 22 "../src/mobiReader.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4583 "mobiReader.c"
	}
#line 22 "../src/mobiReader.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/mobiReader.vala"
		*object_p = NULL;
#line 4589 "mobiReader.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/mobiReader.vala"
		*object_p = value->data[0].v_pointer;
#line 4593 "mobiReader.c"
	} else {
#line 22 "../src/mobiReader.vala"
		*object_p = bookworm_app_mobi_reader_ref (value->data[0].v_pointer);
#line 4597 "mobiReader.c"
	}
#line 22 "../src/mobiReader.vala"
	return NULL;
#line 4601 "mobiReader.c"
}

GParamSpec*
bookworm_app_param_spec_mobi_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	BookwormAppParamSpecmobiReader* spec;
#line 22 "../src/mobiReader.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_MOBI_READER), NULL);
#line 22 "../src/mobiReader.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/mobiReader.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/mobiReader.vala"
	return G_PARAM_SPEC (spec);
#line 4620 "mobiReader.c"
}

gpointer
bookworm_app_value_get_mobi_reader (const GValue* value)
{
#line 22 "../src/mobiReader.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_MOBI_READER), NULL);
#line 22 "../src/mobiReader.vala"
	return value->data[0].v_pointer;
#line 4630 "mobiReader.c"
}

void
bookworm_app_value_set_mobi_reader (GValue* value,
                                    gpointer v_object)
{
	BookwormAppmobiReader * old;
#line 22 "../src/mobiReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_MOBI_READER));
#line 22 "../src/mobiReader.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/mobiReader.vala"
	if (v_object) {
#line 22 "../src/mobiReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_MOBI_READER));
#line 22 "../src/mobiReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/mobiReader.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/mobiReader.vala"
		bookworm_app_mobi_reader_ref (value->data[0].v_pointer);
#line 4652 "mobiReader.c"
	} else {
#line 22 "../src/mobiReader.vala"
		value->data[0].v_pointer = NULL;
#line 4656 "mobiReader.c"
	}
#line 22 "../src/mobiReader.vala"
	if (old) {
#line 22 "../src/mobiReader.vala"
		bookworm_app_mobi_reader_unref (old);
#line 4662 "mobiReader.c"
	}
}

void
bookworm_app_value_take_mobi_reader (GValue* value,
                                     gpointer v_object)
{
	BookwormAppmobiReader * old;
#line 22 "../src/mobiReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_MOBI_READER));
#line 22 "../src/mobiReader.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/mobiReader.vala"
	if (v_object) {
#line 22 "../src/mobiReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_MOBI_READER));
#line 22 "../src/mobiReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/mobiReader.vala"
		value->data[0].v_pointer = v_object;
#line 4683 "mobiReader.c"
	} else {
#line 22 "../src/mobiReader.vala"
		value->data[0].v_pointer = NULL;
#line 4687 "mobiReader.c"
	}
#line 22 "../src/mobiReader.vala"
	if (old) {
#line 22 "../src/mobiReader.vala"
		bookworm_app_mobi_reader_unref (old);
#line 4693 "mobiReader.c"
	}
}

static void
bookworm_app_mobi_reader_class_init (BookwormAppmobiReaderClass * klass,
                                     gpointer klass_data)
{
	gchar* _tmp0_;
#line 22 "../src/mobiReader.vala"
	bookworm_app_mobi_reader_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/mobiReader.vala"
	((BookwormAppmobiReaderClass *) klass)->finalize = bookworm_app_mobi_reader_finalize;
#line 23 "../src/mobiReader.vala"
	_tmp0_ = g_strdup ("");
#line 23 "../src/mobiReader.vala"
	bookworm_app_mobi_reader_OpfContents = _tmp0_;
#line 4710 "mobiReader.c"
}

static void
bookworm_app_mobi_reader_instance_init (BookwormAppmobiReader * self,
                                        gpointer klass)
{
#line 22 "../src/mobiReader.vala"
	self->ref_count = 1;
#line 4719 "mobiReader.c"
}

static void
bookworm_app_mobi_reader_finalize (BookwormAppmobiReader * obj)
{
	BookwormAppmobiReader * self;
#line 22 "../src/mobiReader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_MOBI_READER, BookwormAppmobiReader);
#line 22 "../src/mobiReader.vala"
	g_signal_handlers_destroy (self);
#line 4730 "mobiReader.c"
}

static GType
bookworm_app_mobi_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_mobi_reader_init, bookworm_app_value_mobi_reader_free_value, bookworm_app_value_mobi_reader_copy_value, bookworm_app_value_mobi_reader_peek_pointer, "p", bookworm_app_value_mobi_reader_collect_value, "p", bookworm_app_value_mobi_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppmobiReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_mobi_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppmobiReader), 0, (GInstanceInitFunc) bookworm_app_mobi_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_mobi_reader_type_id;
	bookworm_app_mobi_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppmobiReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_mobi_reader_type_id;
}

GType
bookworm_app_mobi_reader_get_type (void)
{
	static volatile gsize bookworm_app_mobi_reader_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_mobi_reader_type_id__once)) {
		GType bookworm_app_mobi_reader_type_id;
		bookworm_app_mobi_reader_type_id = bookworm_app_mobi_reader_get_type_once ();
		g_once_init_leave (&bookworm_app_mobi_reader_type_id__once, bookworm_app_mobi_reader_type_id);
	}
	return bookworm_app_mobi_reader_type_id__once;
}

gpointer
bookworm_app_mobi_reader_ref (gpointer instance)
{
	BookwormAppmobiReader * self;
	self = instance;
#line 22 "../src/mobiReader.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/mobiReader.vala"
	return instance;
#line 4765 "mobiReader.c"
}

void
bookworm_app_mobi_reader_unref (gpointer instance)
{
	BookwormAppmobiReader * self;
	self = instance;
#line 22 "../src/mobiReader.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/mobiReader.vala"
		BOOKWORM_APP_MOBI_READER_GET_CLASS (self)->finalize (self);
#line 22 "../src/mobiReader.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4779 "mobiReader.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

