/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// VaultAppRoleApplyConfiguration represents a declarative configuration of the VaultAppRole type for use
// with apply.
type VaultAppRoleApplyConfiguration struct {
	Path      *string                                     `json:"path,omitempty"`
	RoleId    *string                                     `json:"roleId,omitempty"`
	SecretRef *metav1.SecretKeySelectorApplyConfiguration `json:"secretRef,omitempty"`
}

// VaultAppRoleApplyConfiguration constructs a declarative configuration of the VaultAppRole type for use with
// apply.
func VaultAppRole() *VaultAppRoleApplyConfiguration {
	return &VaultAppRoleApplyConfiguration{}
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *VaultAppRoleApplyConfiguration) WithPath(value string) *VaultAppRoleApplyConfiguration {
	b.Path = &value
	return b
}

// WithRoleId sets the RoleId field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RoleId field is set to the value of the last call.
func (b *VaultAppRoleApplyConfiguration) WithRoleId(value string) *VaultAppRoleApplyConfiguration {
	b.RoleId = &value
	return b
}

// WithSecretRef sets the SecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretRef field is set to the value of the last call.
func (b *VaultAppRoleApplyConfiguration) WithSecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *VaultAppRoleApplyConfiguration {
	b.SecretRef = value
	return b
}
