/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g
 *     -                            On : 2023-09-01 16:54:52
 *     -                for the parser : CvcParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "CvcParser.h"


#include <sstream>
#include <string>
#include <vector>

#include "base/output.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"


#define REPEAT_COMMAND(k, CommandCtor)                      \
  ({                                                        \
    unsigned __k = (k);                                     \
    (__k <= 1)                                              \
      ? (Command*) new CommandCtor                          \
      : ({                                                  \
          CommandSequence* __seq = new CommandSequence();   \
          while(__k-- > 0) {                                \
            __seq->addCommand(new CommandCtor);             \
          }                                                 \
          (Command*) __seq;                                 \
        });                                                 \
  })

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which will be defined
 * by ANTLR *after* this section. (If they were functions, PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Parser*)PARSER->super)
#undef SOLVER
#define SOLVER PARSER_STATE->getSolver()
#undef MK_TERM
#define MK_TERM SOLVER->mkTerm
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

#define ENSURE_BV_SIZE(k, f)                                   \
{                                                              \
  unsigned size = f.getSort().getBVSize();        \
  if(k > size) {                                               \
    f = SOLVER->mkTerm(SOLVER->mkOp(api::BITVECTOR_ZERO_EXTEND,k - size), f); \
  } else if (k < size) {                                       \
    f = SOLVER->mkTerm(SOLVER->mkOp(api::BITVECTOR_EXTRACT, k - 1, 0), f); \
  }                                                            \
}


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pCvcParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pCvcParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pCvcParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pCvcParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   CvcParserTokenNames[204+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ABS_TOK",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ARITH_VAR_ORDER_TOK",
        (pANTLR3_UINT8) "ARRAY_TOK",
        (pANTLR3_UINT8) "ARROW_TOK",
        (pANTLR3_UINT8) "ASSERTIONS_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "ASSIGN_TOK",
        (pANTLR3_UINT8) "ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "BAR",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BITVECTOR_TOK",
        (pANTLR3_UINT8) "BOOLEAN_TOK",
        (pANTLR3_UINT8) "BVAND_TOK",
        (pANTLR3_UINT8) "BVASHR_TOK",
        (pANTLR3_UINT8) "BVCOMP_TOK",
        (pANTLR3_UINT8) "BVGE_TOK",
        (pANTLR3_UINT8) "BVGT_TOK",
        (pANTLR3_UINT8) "BVLE_TOK",
        (pANTLR3_UINT8) "BVLSHR_TOK",
        (pANTLR3_UINT8) "BVLT_TOK",
        (pANTLR3_UINT8) "BVMULT_TOK",
        (pANTLR3_UINT8) "BVNAND_TOK",
        (pANTLR3_UINT8) "BVNEG_TOK",
        (pANTLR3_UINT8) "BVNOR_TOK",
        (pANTLR3_UINT8) "BVPLUS_TOK",
        (pANTLR3_UINT8) "BVREPEAT_TOK",
        (pANTLR3_UINT8) "BVROTL_TOK",
        (pANTLR3_UINT8) "BVROTR_TOK",
        (pANTLR3_UINT8) "BVSDIV_TOK",
        (pANTLR3_UINT8) "BVSGE_TOK",
        (pANTLR3_UINT8) "BVSGT_TOK",
        (pANTLR3_UINT8) "BVSHL_TOK",
        (pANTLR3_UINT8) "BVSLE_TOK",
        (pANTLR3_UINT8) "BVSLT_TOK",
        (pANTLR3_UINT8) "BVSMOD_TOK",
        (pANTLR3_UINT8) "BVSREM_TOK",
        (pANTLR3_UINT8) "BVSUB_TOK",
        (pANTLR3_UINT8) "BVUDIV_TOK",
        (pANTLR3_UINT8) "BVUMINUS_TOK",
        (pANTLR3_UINT8) "BVUREM_TOK",
        (pANTLR3_UINT8) "BVXNOR_TOK",
        (pANTLR3_UINT8) "BVXOR_TOK",
        (pANTLR3_UINT8) "BVZEROEXTEND_TOK",
        (pANTLR3_UINT8) "CALL_TOK",
        (pANTLR3_UINT8) "CHECKSAT_TOK",
        (pANTLR3_UINT8) "CHECK_TYPE_TOK",
        (pANTLR3_UINT8) "COLON",
        (pANTLR3_UINT8) "COMMA",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONCAT_TOK",
        (pANTLR3_UINT8) "CONTEXT_TOK",
        (pANTLR3_UINT8) "CONTINUE_TOK",
        (pANTLR3_UINT8) "COUNTEREXAMPLE_TOK",
        (pANTLR3_UINT8) "COUNTERMODEL_TOK",
        (pANTLR3_UINT8) "DATATYPE_TOK",
        (pANTLR3_UINT8) "DBG_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISEQUAL_TOK",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "DOT",
        (pANTLR3_UINT8) "DOTDOT",
        (pANTLR3_UINT8) "DUMP_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_TOK",
        (pANTLR3_UINT8) "DUMP_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_SIG_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_TOK",
        (pANTLR3_UINT8) "DUMP_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "ELSEIF_TOK",
        (pANTLR3_UINT8) "ELSE_TOK",
        (pANTLR3_UINT8) "ENDIF_TOK",
        (pANTLR3_UINT8) "END_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "ESCAPE",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "EXP_TOK",
        (pANTLR3_UINT8) "FALSE_TOK",
        (pANTLR3_UINT8) "FLOOR_TOK",
        (pANTLR3_UINT8) "FMF_CARD_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "FORGET_TOK",
        (pANTLR3_UINT8) "GEQ_TOK",
        (pANTLR3_UINT8) "GET_CHILD_TOK",
        (pANTLR3_UINT8) "GET_OP_TOK",
        (pANTLR3_UINT8) "GET_TYPE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GT_TOK",
        (pANTLR3_UINT8) "HASHPAREN",
        (pANTLR3_UINT8) "HASHSQ",
        (pANTLR3_UINT8) "HELP_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "IDENTIFIER",
        (pANTLR3_UINT8) "IDEN_TOK",
        (pANTLR3_UINT8) "IFF_TOK",
        (pANTLR3_UINT8) "IF_TOK",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INTDIV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INT_TOK",
        (pANTLR3_UINT8) "IN_TOK",
        (pANTLR3_UINT8) "IS_INTEGER_TOK",
        (pANTLR3_UINT8) "JOIN_IMAGE_TOK",
        (pANTLR3_UINT8) "JOIN_TOK",
        (pANTLR3_UINT8) "LAMBDA_TOK",
        (pANTLR3_UINT8) "LBRACE",
        (pANTLR3_UINT8) "LBRACKET",
        (pANTLR3_UINT8) "LEFTSHIFT_TOK",
        (pANTLR3_UINT8) "LEQ_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN",
        (pANTLR3_UINT8) "LT_TOK",
        (pANTLR3_UINT8) "MEMBER_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "MOD_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMBER_OR_RANGEOP",
        (pANTLR3_UINT8) "OF_TOK",
        (pANTLR3_UINT8) "OPTION_TOK",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PARENHASH",
        (pANTLR3_UINT8) "PATTERN_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POPTO_SCOPE_TOK",
        (pANTLR3_UINT8) "POPTO_TOK",
        (pANTLR3_UINT8) "POP_SCOPE_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PRINT_TOK",
        (pANTLR3_UINT8) "PRINT_TYPE_TOK",
        (pANTLR3_UINT8) "PRODUCT_TOK",
        (pANTLR3_UINT8) "PUSH_SCOPE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUERY_TOK",
        (pANTLR3_UINT8) "RBRACE",
        (pANTLR3_UINT8) "RBRACKET",
        (pANTLR3_UINT8) "REAL_TOK",
        (pANTLR3_UINT8) "RECURSIVE_FUNCTION_TOK",
        (pANTLR3_UINT8) "REGEXP_COMPLEMENT_TOK",
        (pANTLR3_UINT8) "REGEXP_CONCAT_TOK",
        (pANTLR3_UINT8) "REGEXP_EMPTY_TOK",
        (pANTLR3_UINT8) "REGEXP_INTER_TOK",
        (pANTLR3_UINT8) "REGEXP_LOOP_TOK",
        (pANTLR3_UINT8) "REGEXP_OPT_TOK",
        (pANTLR3_UINT8) "REGEXP_PLUS_TOK",
        (pANTLR3_UINT8) "REGEXP_RANGE_TOK",
        (pANTLR3_UINT8) "REGEXP_SIGMA_TOK",
        (pANTLR3_UINT8) "REGEXP_STAR_TOK",
        (pANTLR3_UINT8) "REGEXP_UNION_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "RESTART_TOK",
        (pANTLR3_UINT8) "RIGHTSHIFT_TOK",
        (pANTLR3_UINT8) "RPAREN",
        (pANTLR3_UINT8) "SEMICOLON",
        (pANTLR3_UINT8) "SETS_CARD_TOK",
        (pANTLR3_UINT8) "SETS_CHOOSE_TOK",
        (pANTLR3_UINT8) "SET_TOK",
        (pANTLR3_UINT8) "SQHASH",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STRING_CHARAT_TOK",
        (pANTLR3_UINT8) "STRING_CONCAT_TOK",
        (pANTLR3_UINT8) "STRING_CONTAINS_TOK",
        (pANTLR3_UINT8) "STRING_INDEXOF_TOK",
        (pANTLR3_UINT8) "STRING_ITOS_TOK",
        (pANTLR3_UINT8) "STRING_LENGTH_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL",
        (pANTLR3_UINT8) "STRING_PREFIXOF_TOK",
        (pANTLR3_UINT8) "STRING_REPLACE_ALL_TOK",
        (pANTLR3_UINT8) "STRING_REPLACE_TOK",
        (pANTLR3_UINT8) "STRING_REV_TOK",
        (pANTLR3_UINT8) "STRING_STOI_TOK",
        (pANTLR3_UINT8) "STRING_SUBSTR_TOK",
        (pANTLR3_UINT8) "STRING_SUFFIXOF_TOK",
        (pANTLR3_UINT8) "STRING_TOK",
        (pANTLR3_UINT8) "STRING_TOLOWER_TOK",
        (pANTLR3_UINT8) "STRING_TOUPPER_TOK",
        (pANTLR3_UINT8) "STRING_TO_REGEXP_TOK",
        (pANTLR3_UINT8) "SUBSTITUTE_TOK",
        (pANTLR3_UINT8) "SUBTYPE_TOK",
        (pANTLR3_UINT8) "SX_TOK",
        (pANTLR3_UINT8) "THEN_TOK",
        (pANTLR3_UINT8) "TRACE_TOK",
        (pANTLR3_UINT8) "TRANSCLOSURE_TOK",
        (pANTLR3_UINT8) "TRANSFORM_TOK",
        (pANTLR3_UINT8) "TRANSPOSE_TOK",
        (pANTLR3_UINT8) "TRUE_TOK",
        (pANTLR3_UINT8) "TUPLE_TOK",
        (pANTLR3_UINT8) "TYPE_TOK",
        (pANTLR3_UINT8) "UNDERSCORE",
        (pANTLR3_UINT8) "UNIVSET_TOK",
        (pANTLR3_UINT8) "UNTRACE_TOK",
        (pANTLR3_UINT8) "WHERE_TOK",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "WITH_TOK",
        (pANTLR3_UINT8) "XOR_TOK"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::api::Term
	parseExpr    (pCvcParser ctx);
static 
 CVC4::Command*
	parseCommand    (pCvcParser ctx);
static 
 void
	command    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	typeOrVarLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	mainCommand    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	simpleSymbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	toplevelDeclaration    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	boundVarDecl    (pCvcParser ctx, std::vector<std::string>& ids, CVC4::api::Sort& t);
static 
 void
	boundVarDecls    (pCvcParser ctx);
static 
 void
	boundVarDeclsReturn    (pCvcParser ctx, std::vector<CVC4::api::Term>& terms, std::vector<CVC4::api::Sort>& types);
static 
 void
	boundVarDeclReturn    (pCvcParser ctx, std::vector<CVC4::api::Term>& terms, std::vector<CVC4::api::Sort>& types);
static 
 void
	declareTypes    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, const std::vector<std::string>& idList);
static 
 void
	declareVariables    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, CVC4::api::Sort& t, const std::vector<std::string>& idList, bool topLevel);
static 
 void
	identifierList    (pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	identifier    (pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	type    (pCvcParser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedType    (pCvcParser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedTypePossiblyFunctionLHS    (pCvcParser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check, bool& lhs);
static 
 void
	parameterization    (pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::api::Sort>& params);
static 
 void
	bound    (pCvcParser ctx);
static 
 void
	typeLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	formula    (pCvcParser ctx, CVC4::api::Term& f);
static 
 size_t
	morecomparisons    (pCvcParser ctx, std::vector<CVC4::api::Term>& expressions, std::vector<unsigned>& operators);
static 
 size_t
	nots    (pCvcParser ctx);
static 
 void
	prefixFormula    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	instantiationPatterns    (pCvcParser ctx, CVC4::api::Term& expr);
static 
 void
	letDecl    (pCvcParser ctx);
static 
 void
	booleanBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	comparison    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	comparisonBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	arithmeticBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	term    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	arrayStore    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	tupleStore    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	recordStore    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	uminusTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	bvBinaryOpTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	bvBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	bvNegTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	relationBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	relationBinopTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	postfixTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	relationTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	bvTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	stringTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	setsTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	simpleTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	typeAscription    (pCvcParser ctx, const CVC4::api::Term& f, CVC4::api::Sort& t);
static 
 void
	recordEntry    (pCvcParser ctx, std::string& name, CVC4::api::Term& ex);
static 
 void
	iteTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	iteElseTerm    (pCvcParser ctx, CVC4::api::Term& f);
static 
 void
	datatypeDef    (pCvcParser ctx, std::vector<CVC4::api::DatatypeDecl>& datatypes);
static 
 void
	constructorDef    (pCvcParser ctx, CVC4::api::DatatypeDecl& type);
static 
 void
	selector    (pCvcParser ctx, std::unique_ptr<CVC4::api::DatatypeConstructorDecl>* ctor);
static 
 unsigned
	numeral    (pCvcParser ctx);
static 
 CVC4::Rational
	integer    (pCvcParser ctx);
static 
 void
	str    (pCvcParser ctx, std::string& s);
static 
 ANTLR3_BOOLEAN
	synpred1_Cvc    (pCvcParser ctx);
static void	CvcParserFree(pCvcParser ctx);
static void     CvcParserReset (pCvcParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "/build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return CvcParserNewSSD(instream, NULL);
}

/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pCvcParser ctx;	    /* Context structure we will build and return   */

    ctx	= (pCvcParser) ANTLR3_CALLOC(1, sizeof(CvcParser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in CvcParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our CvcParser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->command	= command;
    ctx->typeOrVarLetDecl	= typeOrVarLetDecl;
    ctx->mainCommand	= mainCommand;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->toplevelDeclaration	= toplevelDeclaration;
    ctx->boundVarDecl	= boundVarDecl;
    ctx->boundVarDecls	= boundVarDecls;
    ctx->boundVarDeclsReturn	= boundVarDeclsReturn;
    ctx->boundVarDeclReturn	= boundVarDeclReturn;
    ctx->declareTypes	= declareTypes;
    ctx->declareVariables	= declareVariables;
    ctx->identifierList	= identifierList;
    ctx->identifier	= identifier;
    ctx->type	= type;
    ctx->restrictedType	= restrictedType;
    ctx->restrictedTypePossiblyFunctionLHS	= restrictedTypePossiblyFunctionLHS;
    ctx->parameterization	= parameterization;
    ctx->bound	= bound;
    ctx->typeLetDecl	= typeLetDecl;
    ctx->formula	= formula;
    ctx->morecomparisons	= morecomparisons;
    ctx->nots	= nots;
    ctx->prefixFormula	= prefixFormula;
    ctx->instantiationPatterns	= instantiationPatterns;
    ctx->letDecl	= letDecl;
    ctx->booleanBinop	= booleanBinop;
    ctx->comparison	= comparison;
    ctx->comparisonBinop	= comparisonBinop;
    ctx->arithmeticBinop	= arithmeticBinop;
    ctx->term	= term;
    ctx->arrayStore	= arrayStore;
    ctx->tupleStore	= tupleStore;
    ctx->recordStore	= recordStore;
    ctx->uminusTerm	= uminusTerm;
    ctx->bvBinaryOpTerm	= bvBinaryOpTerm;
    ctx->bvBinop	= bvBinop;
    ctx->bvNegTerm	= bvNegTerm;
    ctx->relationBinop	= relationBinop;
    ctx->relationBinopTerm	= relationBinopTerm;
    ctx->postfixTerm	= postfixTerm;
    ctx->relationTerm	= relationTerm;
    ctx->bvTerm	= bvTerm;
    ctx->stringTerm	= stringTerm;
    ctx->setsTerm	= setsTerm;
    ctx->simpleTerm	= simpleTerm;
    ctx->typeAscription	= typeAscription;
    ctx->recordEntry	= recordEntry;
    ctx->iteTerm	= iteTerm;
    ctx->iteElseTerm	= iteElseTerm;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->numeral	= numeral;
    ctx->integer	= integer;
    ctx->str	= str;
    ctx->synpred1_Cvc	= synpred1_Cvc;
    ctx->free			= CvcParserFree;
    ctx->reset			= CvcParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = CvcParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
CvcParserReset (pCvcParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 CvcParserFree(pCvcParser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return CvcParserTokenNames;
}



    // Idea and code guidance from Sam Harwell,
    // http://www.antlr.org/wiki/display/ANTLR3/Operator+precedence+parser

    bool isRightToLeft(int type) {
      // return true here for any operators that are right-to-left associative
      switch(type) {
      case IMPLIES_TOK: return true;
      default: return false;
      }
    }/* isRightToLeft() */

    int getOperatorPrecedence(int type) {
      switch(type) {
      case BITVECTOR_TOK: return 1;
      //case DOT:
      case LPAREN:
      case LBRACE: return 2;
      case LBRACKET: return 3;
      case ARROW_TOK: return 4;
      case IS_INTEGER_TOK: return 5;
      case BVSLT_TOK:
      case BVSLE_TOK:
      case BVSGT_TOK:
      case BVSGE_TOK: return 6;
      case BVLT_TOK:
      case BVLE_TOK:
      case BVGT_TOK:
      case BVGE_TOK: return 7;
      case LEFTSHIFT_TOK:
      case RIGHTSHIFT_TOK: return 8;
      case SX_TOK:
      case BVZEROEXTEND_TOK:
      case BVREPEAT_TOK:
      case BVROTL_TOK:
      case BVROTR_TOK: return 9;
      case BVUDIV_TOK:
      case BVSDIV_TOK:
      case BVUREM_TOK:
      case BVSREM_TOK:
      case BVSMOD_TOK:
      case BVSHL_TOK:
      case BVASHR_TOK:
      case BVLSHR_TOK: return 10;
      case BVUMINUS_TOK:
      case BVPLUS_TOK:
      case BVSUB_TOK: return 11;
      case BVNEG_TOK: return 12;
      case BVXNOR_TOK: return 13;
      case BVNOR_TOK:
      case BVCOMP_TOK: return 14;
      case BVNAND_TOK: return 15;
      case BVXOR_TOK: return 16;
      case BVAND_TOK: return 17;
      case BAR: return 18;
      case CONCAT_TOK: return 19;
    //case UMINUS_TOK: return 20;
      case WITH_TOK: return 21;
      case EXP_TOK: return 22;
      case STAR_TOK:
      case INTDIV_TOK:
      case DIV_TOK:
      case TUPLE_TOK:
      case MOD_TOK: return 23;
      case PLUS_TOK:
      case MINUS_TOK:
      case JOIN_TOK:
      case TRANSPOSE_TOK:
      case PRODUCT_TOK:
      case IDEN_TOK:
      case JOIN_IMAGE_TOK:
      case TRANSCLOSURE_TOK:
      case SETS_CHOOSE_TOK: return 24;
      case LEQ_TOK:
      case LT_TOK:
      case GEQ_TOK:
      case GT_TOK:
      case MEMBER_TOK:
      case SETS_CARD_TOK:
      case FMF_CARD_TOK: return 25;
      case EQUAL_TOK:
      case DISEQUAL_TOK: return 26;
      case NOT_TOK: return 27;
      case AND_TOK: return 28;
      case OR_TOK:
      case XOR_TOK: return 29;
      case IMPLIES_TOK: return 30;// right-to-left
      case IFF_TOK: return 31;
      case FORALL_TOK:
      case EXISTS_TOK:return 32;
      case ASSIGN_TOK:
      case IN_TOK: return 33;

      default:
        std::stringstream ss;
        ss << "internal error: no entry in precedence table for operator " << CvcParserTokenNames[type];
        throw ParserException(ss.str());
      }
    }/* getOperatorPrecedence() */

    api::Kind getOperatorKind(int type, bool& negate) {
      negate = false;

      switch(type) {
        // booleanBinop
      case IFF_TOK: return api::EQUAL;
      case IMPLIES_TOK: return api::IMPLIES;
      case OR_TOK: return api::OR;
      case XOR_TOK: return api::XOR;
      case AND_TOK: return api::AND;

      case SETS_CHOOSE_TOK: return api::CHOOSE;
      case PRODUCT_TOK: return api::PRODUCT;
      case JOIN_TOK: return api::JOIN;
      case JOIN_IMAGE_TOK: return api::JOIN_IMAGE;


        // comparisonBinop
      case EQUAL_TOK: return api::EQUAL;
      case DISEQUAL_TOK: negate = true; return api::EQUAL;
      case GT_TOK: return api::GT;
      case GEQ_TOK: return api::GEQ;
      case LT_TOK: return api::LT;
      case LEQ_TOK: return api::LEQ;
      case MEMBER_TOK: return api::MEMBER;
      case SETS_CARD_TOK: return api::CARD;
      case FMF_CARD_TOK: return api::CARDINALITY_CONSTRAINT;

        // arithmeticBinop
      case PLUS_TOK: return api::PLUS;
      case MINUS_TOK: return api::MINUS;
      case STAR_TOK: return api::MULT;
      case INTDIV_TOK: return api::INTS_DIVISION;
      case MOD_TOK: return api::INTS_MODULUS;
      case DIV_TOK: return api::DIVISION;
      case EXP_TOK: return api::POW;

        // bvBinop
      case CONCAT_TOK: return api::BITVECTOR_CONCAT;
      case BAR: return api::BITVECTOR_OR;
      case BVAND_TOK: return api::BITVECTOR_AND;

      }

      std::stringstream ss;
      ss << "internal error: no entry in operator-kind table for operator " << CvcParserTokenNames[type];
      throw ParserException(ss.str());

    }/* getOperatorKind() */

    unsigned findPivot(const std::vector<unsigned>& operators,
                       unsigned startIndex, unsigned stopIndex) {
      unsigned pivot = startIndex;
      unsigned pivotRank = getOperatorPrecedence(operators[pivot]);
      /*Debug("prec") << "initial pivot at " << pivot
                    << "(" << CvcParserTokenNames[operators[pivot]] << ") "
                    << "level " << pivotRank << std::endl;*/
      for(unsigned i = startIndex + 1; i <= stopIndex; ++i) {
        unsigned current = getOperatorPrecedence(operators[i]);
        bool rtl = isRightToLeft(operators[i]);
        if(current > pivotRank || (current == pivotRank && !rtl)) {
          /*Debug("prec") << "new pivot at " << i
                        << "(" << CvcParserTokenNames[operators[i]] << ") "
                        << "level " << current << " rtl == " << rtl << std::endl;*/
          pivot = i;
          pivotRank = current;
        }
      }
      return pivot;
    }/* findPivot() */

    CVC4::api::Term createPrecedenceTree(Parser* parser, api::Solver* solver,
                              const std::vector<CVC4::api::Term>& expressions,
                              const std::vector<unsigned>& operators,
                              unsigned startIndex, unsigned stopIndex) {
      assert(expressions.size() == operators.size() + 1);
      assert(startIndex < expressions.size());
      assert(stopIndex < expressions.size());
      assert(startIndex <= stopIndex);

      if(stopIndex == startIndex) {
        return expressions[startIndex];
      }

      unsigned pivot = findPivot(operators, startIndex, stopIndex - 1);
      //Debug("prec") << "pivot[" << startIndex << "," << stopIndex - 1 << "] at " << pivot << std::endl;
      bool negate;
      api::Kind k = getOperatorKind(operators[pivot], negate);
      CVC4::api::Term lhs = createPrecedenceTree(
          parser, solver, expressions, operators, startIndex, pivot);
      CVC4::api::Term rhs = createPrecedenceTree(
          parser, solver, expressions, operators, pivot + 1, stopIndex);

      if (lhs.getSort().isSet())
      {
        switch (k)
        {
          case api::LEQ: k = api::SUBSET; break;
          case api::MINUS: k = api::SETMINUS; break;
          case api::BITVECTOR_AND: k = api::INTERSECTION; break;
          case api::BITVECTOR_OR: k = api::UNION; break;
          default: break;
        }
      }
      else if (lhs.getSort().isString())
      {
        switch (k)
        {
          case api::MEMBER: k = api::STRING_IN_REGEXP; break;
          default: break;
        }
      }

      api::Term e = solver->mkTerm(k, lhs, rhs);
      return negate ? e.notTerm() : e;
    }/* createPrecedenceTree() recursive variant */

    api::Term createPrecedenceTree(Parser* parser, api::Solver* s,
                              const std::vector<CVC4::api::Term>& expressions,
                              const std::vector<unsigned>& operators) {
      if(Debug.isOn("prec") && operators.size() > 1) {
        for(unsigned i = 0; i < expressions.size(); ++i) {
          Debug("prec") << expressions[i];
          if(operators.size() > i) {
            Debug("prec") << ' ' << CvcParserTokenNames[operators[i]] << ' ';
          }
        }
        Debug("prec") << std::endl;
      }

      api::Term e = createPrecedenceTree(
          parser, s, expressions, operators, 0, expressions.size() - 1);
      if(Debug.isOn("prec") && operators.size() > 1) {
        language::SetLanguage::Scope ls(Debug("prec"), language::output::LANG_AST);
        Debug("prec") << "=> " << e << std::endl;
      }
      return e;
    }/* createPrecedenceTree() base variant */

    /** Add n NOTs to the front of e and return the result. */
    api::Term addNots(api::Solver* s, size_t n, api::Term e) {
      while(n-- > 0) {
        e = e.notTerm();
      }
      return e;
    }/* addNots() */



/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_parseExpr1899  */
static	ANTLR3_BITWORD FOLLOW_formula_in_parseExpr1899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_parseExpr1899	= { FOLLOW_formula_in_parseExpr1899_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr1906  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr1906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr1906	= { FOLLOW_EOF_in_parseExpr1906_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand1937  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand1937_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand1937	= { FOLLOW_command_in_parseCommand1937_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_parseCommand1944  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_parseCommand1944_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_parseCommand1944	= { FOLLOW_LPAREN_in_parseCommand1944_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_parseCommand1946  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_parseCommand1946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_parseCommand1946	= { FOLLOW_IDENTIFIER_in_parseCommand1946_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand1958  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand1958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand1958	= { FOLLOW_EOF_in_parseCommand1958_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_mainCommand_in_command1977  */
static	ANTLR3_BITWORD FOLLOW_mainCommand_in_command1977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_mainCommand_in_command1977	= { FOLLOW_mainCommand_in_command1977_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1980  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1980_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1980	= { FOLLOW_SEMICOLON_in_command1980_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1988  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1988	= { FOLLOW_SEMICOLON_in_command1988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_command1996  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_command1996_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_command1996	= { FOLLOW_LET_TOK_in_command1996_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command2006  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command2006_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command2006	= { FOLLOW_typeOrVarLetDecl_in_command2006_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_command2021  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_command2021_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_command2021	= { FOLLOW_COMMA_in_command2021_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command2023  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command2023_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command2023	= { FOLLOW_typeOrVarLetDecl_in_command2023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_command2035  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_command2035_bits[]	= { ANTLR3_UINT64_LIT(0x3F0E000000002C80), ANTLR3_UINT64_LIT(0x08004247A080FFC0), ANTLR3_UINT64_LIT(0x4000004C00477E10), ANTLR3_UINT64_LIT(0x0000000000001814) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_command2035	= { FOLLOW_IN_TOK_in_command2035_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_command2037  */
static	ANTLR3_BITWORD FOLLOW_command_in_command2037_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_command2037	= { FOLLOW_command_in_command2037_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_command2064  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_command2064_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_command2064	= { FOLLOW_IDENTIFIER_in_command2064_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command2066  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command2066_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command2066	= { FOLLOW_SEMICOLON_in_command2066_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_typeOrVarLetDecl2097  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_typeOrVarLetDecl2097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_typeOrVarLetDecl2097	= { FOLLOW_letDecl_in_typeOrVarLetDecl2097_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_typeOrVarLetDecl2101  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_typeOrVarLetDecl2101_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_typeOrVarLetDecl2101	= { FOLLOW_typeLetDecl_in_typeOrVarLetDecl2101_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_mainCommand2127  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_mainCommand2127_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_mainCommand2127	= { FOLLOW_ASSERT_TOK_in_mainCommand2127_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2129  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2129_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2129	= { FOLLOW_formula_in_mainCommand2129_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUERY_TOK_in_mainCommand2139  */
static	ANTLR3_BITWORD FOLLOW_QUERY_TOK_in_mainCommand2139_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_QUERY_TOK_in_mainCommand2139	= { FOLLOW_QUERY_TOK_in_mainCommand2139_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2141  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2141_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2141	= { FOLLOW_formula_in_mainCommand2141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECKSAT_TOK_in_mainCommand2150  */
static	ANTLR3_BITWORD FOLLOW_CHECKSAT_TOK_in_mainCommand2150_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECKSAT_TOK_in_mainCommand2150	= { FOLLOW_CHECKSAT_TOK_in_mainCommand2150_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2152  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2152	= { FOLLOW_formula_in_mainCommand2152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OPTION_TOK_in_mainCommand2172  */
static	ANTLR3_BITWORD FOLLOW_OPTION_TOK_in_mainCommand2172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_OPTION_TOK_in_mainCommand2172	= { FOLLOW_OPTION_TOK_in_mainCommand2172_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2180  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2180_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x9001030002000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2180	= { FOLLOW_str_in_mainCommand2180_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2185  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2185_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x9001030002000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2185	= { FOLLOW_IDENTIFIER_in_mainCommand2185_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_mainCommand2197  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_mainCommand2197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_mainCommand2197	= { FOLLOW_symbolicExpr_in_mainCommand2197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_mainCommand2214  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_mainCommand2214_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_mainCommand2214	= { FOLLOW_TRUE_TOK_in_mainCommand2214_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_mainCommand2224  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_mainCommand2224_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_mainCommand2224	= { FOLLOW_FALSE_TOK_in_mainCommand2224_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_mainCommand2253  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_mainCommand2253_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_mainCommand2253	= { FOLLOW_PUSH_TOK_in_mainCommand2253_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2259  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2259	= { FOLLOW_numeral_in_mainCommand2259_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_mainCommand2288  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_mainCommand2288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_mainCommand2288	= { FOLLOW_POP_TOK_in_mainCommand2288_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2294  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2294_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2294	= { FOLLOW_numeral_in_mainCommand2294_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_TOK_in_mainCommand2322  */
static	ANTLR3_BITWORD FOLLOW_POPTO_TOK_in_mainCommand2322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_TOK_in_mainCommand2322	= { FOLLOW_POPTO_TOK_in_mainCommand2322_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2326  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2326_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2326	= { FOLLOW_numeral_in_mainCommand2326_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2346  */
static	ANTLR3_BITWORD FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2346	= { FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2346_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2350  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2350_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2350	= { FOLLOW_numeral_in_mainCommand2350_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_SCOPE_TOK_in_mainCommand2363  */
static	ANTLR3_BITWORD FOLLOW_POP_SCOPE_TOK_in_mainCommand2363_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_SCOPE_TOK_in_mainCommand2363	= { FOLLOW_POP_SCOPE_TOK_in_mainCommand2363_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2367  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2367	= { FOLLOW_numeral_in_mainCommand2367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2380  */
static	ANTLR3_BITWORD FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2380_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2380	= { FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2380_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2384  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2384	= { FOLLOW_numeral_in_mainCommand2384_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2398  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2398	= { FOLLOW_RESET_TOK_in_mainCommand2398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2411  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2411	= { FOLLOW_RESET_TOK_in_mainCommand2411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERTIONS_TOK_in_mainCommand2413  */
static	ANTLR3_BITWORD FOLLOW_ASSERTIONS_TOK_in_mainCommand2413_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERTIONS_TOK_in_mainCommand2413	= { FOLLOW_ASSERTIONS_TOK_in_mainCommand2413_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATATYPE_TOK_in_mainCommand2441  */
static	ANTLR3_BITWORD FOLLOW_DATATYPE_TOK_in_mainCommand2441_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DATATYPE_TOK_in_mainCommand2441	= { FOLLOW_DATATYPE_TOK_in_mainCommand2441_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2453  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2453_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2453	= { FOLLOW_datatypeDef_in_mainCommand2453_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand2462  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand2462_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand2462	= { FOLLOW_COMMA_in_mainCommand2462_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2464  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2464_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2464	= { FOLLOW_datatypeDef_in_mainCommand2464_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_END_TOK_in_mainCommand2474  */
static	ANTLR3_BITWORD FOLLOW_END_TOK_in_mainCommand2474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_END_TOK_in_mainCommand2474	= { FOLLOW_END_TOK_in_mainCommand2474_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTEXT_TOK_in_mainCommand2487  */
static	ANTLR3_BITWORD FOLLOW_CONTEXT_TOK_in_mainCommand2487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTEXT_TOK_in_mainCommand2487	= { FOLLOW_CONTEXT_TOK_in_mainCommand2487_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2497  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2497	= { FOLLOW_str_in_mainCommand2497_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2502  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2502	= { FOLLOW_IDENTIFIER_in_mainCommand2502_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORGET_TOK_in_mainCommand2535  */
static	ANTLR3_BITWORD FOLLOW_FORGET_TOK_in_mainCommand2535_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORGET_TOK_in_mainCommand2535	= { FOLLOW_FORGET_TOK_in_mainCommand2535_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2537  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2537_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2537	= { FOLLOW_identifier_in_mainCommand2537_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_TYPE_TOK_in_mainCommand2551  */
static	ANTLR3_BITWORD FOLLOW_GET_TYPE_TOK_in_mainCommand2551_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_TYPE_TOK_in_mainCommand2551	= { FOLLOW_GET_TYPE_TOK_in_mainCommand2551_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2553  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2553_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2553	= { FOLLOW_formula_in_mainCommand2553_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_TYPE_TOK_in_mainCommand2567  */
static	ANTLR3_BITWORD FOLLOW_CHECK_TYPE_TOK_in_mainCommand2567_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_TYPE_TOK_in_mainCommand2567	= { FOLLOW_CHECK_TYPE_TOK_in_mainCommand2567_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2569  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2569_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2569	= { FOLLOW_formula_in_mainCommand2569_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2572  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2572_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2572	= { FOLLOW_COLON_in_mainCommand2572_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2574  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2574_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2574	= { FOLLOW_type_in_mainCommand2574_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_CHILD_TOK_in_mainCommand2588  */
static	ANTLR3_BITWORD FOLLOW_GET_CHILD_TOK_in_mainCommand2588_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_CHILD_TOK_in_mainCommand2588	= { FOLLOW_GET_CHILD_TOK_in_mainCommand2588_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2590  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2590_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2590	= { FOLLOW_formula_in_mainCommand2590_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2595  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2595	= { FOLLOW_numeral_in_mainCommand2595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OP_TOK_in_mainCommand2608  */
static	ANTLR3_BITWORD FOLLOW_GET_OP_TOK_in_mainCommand2608_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OP_TOK_in_mainCommand2608	= { FOLLOW_GET_OP_TOK_in_mainCommand2608_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2610  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2610_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2610	= { FOLLOW_formula_in_mainCommand2610_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_mainCommand2624  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_mainCommand2624_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_mainCommand2624	= { FOLLOW_GET_VALUE_TOK_in_mainCommand2624_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2626  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2626_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2626	= { FOLLOW_formula_in_mainCommand2626_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBSTITUTE_TOK_in_mainCommand2640  */
static	ANTLR3_BITWORD FOLLOW_SUBSTITUTE_TOK_in_mainCommand2640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBSTITUTE_TOK_in_mainCommand2640	= { FOLLOW_SUBSTITUTE_TOK_in_mainCommand2640_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2642  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2642_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2642	= { FOLLOW_identifier_in_mainCommand2642_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2645  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2645	= { FOLLOW_COLON_in_mainCommand2645_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2651  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2651_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2651	= { FOLLOW_type_in_mainCommand2651_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_mainCommand2654  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_mainCommand2654_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_mainCommand2654	= { FOLLOW_EQUAL_TOK_in_mainCommand2654_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2656  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2656_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2656	= { FOLLOW_formula_in_mainCommand2656_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_mainCommand2659  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_mainCommand2659_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_mainCommand2659	= { FOLLOW_LBRACKET_in_mainCommand2659_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2665  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2665_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2665	= { FOLLOW_identifier_in_mainCommand2665_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_mainCommand2668  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_mainCommand2668_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_mainCommand2668	= { FOLLOW_ASSIGN_TOK_in_mainCommand2668_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2670  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2670_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2670	= { FOLLOW_formula_in_mainCommand2670_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_mainCommand2673  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_mainCommand2673_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_mainCommand2673	= { FOLLOW_RBRACKET_in_mainCommand2673_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DBG_TOK_in_mainCommand2692  */
static	ANTLR3_BITWORD FOLLOW_DBG_TOK_in_mainCommand2692_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DBG_TOK_in_mainCommand2692	= { FOLLOW_DBG_TOK_in_mainCommand2692_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2702  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2702_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2702	= { FOLLOW_str_in_mainCommand2702_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2707  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2707_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2707	= { FOLLOW_IDENTIFIER_in_mainCommand2707_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRACE_TOK_in_mainCommand2740  */
static	ANTLR3_BITWORD FOLLOW_TRACE_TOK_in_mainCommand2740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TRACE_TOK_in_mainCommand2740	= { FOLLOW_TRACE_TOK_in_mainCommand2740_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2750  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2750_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2750	= { FOLLOW_str_in_mainCommand2750_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2755  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2755_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2755	= { FOLLOW_IDENTIFIER_in_mainCommand2755_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTRACE_TOK_in_mainCommand2787  */
static	ANTLR3_BITWORD FOLLOW_UNTRACE_TOK_in_mainCommand2787_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTRACE_TOK_in_mainCommand2787	= { FOLLOW_UNTRACE_TOK_in_mainCommand2787_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2797  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2797	= { FOLLOW_str_in_mainCommand2797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2802  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2802_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2802	= { FOLLOW_IDENTIFIER_in_mainCommand2802_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HELP_TOK_in_mainCommand2835  */
static	ANTLR3_BITWORD FOLLOW_HELP_TOK_in_mainCommand2835_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_HELP_TOK_in_mainCommand2835	= { FOLLOW_HELP_TOK_in_mainCommand2835_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2845  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2845_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2845	= { FOLLOW_str_in_mainCommand2845_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2850  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2850_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2850	= { FOLLOW_IDENTIFIER_in_mainCommand2850_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSFORM_TOK_in_mainCommand2891  */
static	ANTLR3_BITWORD FOLLOW_TRANSFORM_TOK_in_mainCommand2891_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSFORM_TOK_in_mainCommand2891	= { FOLLOW_TRANSFORM_TOK_in_mainCommand2891_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2893  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2893_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2893	= { FOLLOW_formula_in_mainCommand2893_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TOK_in_mainCommand2907  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TOK_in_mainCommand2907_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TOK_in_mainCommand2907	= { FOLLOW_PRINT_TOK_in_mainCommand2907_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2909  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2909	= { FOLLOW_formula_in_mainCommand2909_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TYPE_TOK_in_mainCommand2922  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TYPE_TOK_in_mainCommand2922_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TYPE_TOK_in_mainCommand2922	= { FOLLOW_PRINT_TYPE_TOK_in_mainCommand2922_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2924  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2924	= { FOLLOW_type_in_mainCommand2924_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CALL_TOK_in_mainCommand2938  */
static	ANTLR3_BITWORD FOLLOW_CALL_TOK_in_mainCommand2938_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CALL_TOK_in_mainCommand2938	= { FOLLOW_CALL_TOK_in_mainCommand2938_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2940  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2940_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2940	= { FOLLOW_identifier_in_mainCommand2940_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2943  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2943	= { FOLLOW_formula_in_mainCommand2943_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_mainCommand2957  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_mainCommand2957_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x8001030000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_mainCommand2957	= { FOLLOW_ECHO_TOK_in_mainCommand2957_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_mainCommand2965  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_mainCommand2965_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_mainCommand2965	= { FOLLOW_simpleSymbolicExpr_in_mainCommand2965_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_mainCommand2995  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_mainCommand2995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_mainCommand2995	= { FOLLOW_EXIT_TOK_in_mainCommand2995_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_mainCommand3008  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_mainCommand3008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_mainCommand3008	= { FOLLOW_INCLUDE_TOK_in_mainCommand3008_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand3018  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand3018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand3018	= { FOLLOW_str_in_mainCommand3018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand3023  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand3023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand3023	= { FOLLOW_IDENTIFIER_in_mainCommand3023_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_PROOF_TOK_in_mainCommand3056  */
static	ANTLR3_BITWORD FOLLOW_DUMP_PROOF_TOK_in_mainCommand3056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_PROOF_TOK_in_mainCommand3056	= { FOLLOW_DUMP_PROOF_TOK_in_mainCommand3056_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand3069  */
static	ANTLR3_BITWORD FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand3069_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand3069	= { FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand3069_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand3082  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand3082_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand3082	= { FOLLOW_set_in_mainCommand3082_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand3153  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand3153_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand3153	= { FOLLOW_set_in_mainCommand3153_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3178  */
static	ANTLR3_BITWORD FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3178	= { FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3178_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTERMODEL_TOK_in_mainCommand3190  */
static	ANTLR3_BITWORD FOLLOW_COUNTERMODEL_TOK_in_mainCommand3190_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTERMODEL_TOK_in_mainCommand3190	= { FOLLOW_COUNTERMODEL_TOK_in_mainCommand3190_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3203  */
static	ANTLR3_BITWORD FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3203	= { FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3203_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_mainCommand3205  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_mainCommand3205_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_mainCommand3205	= { FOLLOW_LPAREN_in_mainCommand3205_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3207  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3207_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3207	= { FOLLOW_formula_in_mainCommand3207_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3212  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3212_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3212	= { FOLLOW_COMMA_in_mainCommand3212_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3214  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3214_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3214	= { FOLLOW_formula_in_mainCommand3214_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_mainCommand3220  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_mainCommand3220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_mainCommand3220	= { FOLLOW_RPAREN_in_mainCommand3220_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTINUE_TOK_in_mainCommand3233  */
static	ANTLR3_BITWORD FOLLOW_CONTINUE_TOK_in_mainCommand3233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTINUE_TOK_in_mainCommand3233	= { FOLLOW_CONTINUE_TOK_in_mainCommand3233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESTART_TOK_in_mainCommand3245  */
static	ANTLR3_BITWORD FOLLOW_RESTART_TOK_in_mainCommand3245_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_RESTART_TOK_in_mainCommand3245	= { FOLLOW_RESTART_TOK_in_mainCommand3245_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3247  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3247	= { FOLLOW_formula_in_mainCommand3247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3256  */
static	ANTLR3_BITWORD FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3256_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3256	= { FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3256_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand3259  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand3259_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand3259	= { FOLLOW_identifier_in_mainCommand3259_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand3272  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand3272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand3272	= { FOLLOW_COLON_in_mainCommand3272_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand3274  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand3274_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000020000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand3274	= { FOLLOW_type_in_mainCommand3274_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3278  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3278	= { FOLLOW_COMMA_in_mainCommand3278_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_mainCommand3296  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_mainCommand3296_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_mainCommand3296	= { FOLLOW_EQUAL_TOK_in_mainCommand3296_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3299  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3299_bits[]	= { ANTLR3_UINT64_LIT(0x4021FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3299	= { FOLLOW_formula_in_mainCommand3299_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3313  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3313_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3313	= { FOLLOW_COMMA_in_mainCommand3313_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_toplevelDeclaration_in_mainCommand3336  */
static	ANTLR3_BITWORD FOLLOW_toplevelDeclaration_in_mainCommand3336_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_toplevelDeclaration_in_mainCommand3336	= { FOLLOW_toplevelDeclaration_in_mainCommand3336_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3356  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3356	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3356_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3368  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3368	= { FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3368_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3370  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3370_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3370	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3370_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3382  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3382	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3382_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3394  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3394_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3394	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3394_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3406  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3406	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3406_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExpr3418  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExpr3418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExpr3418	= { FOLLOW_str_in_simpleSymbolicExpr3418_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3431  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3431_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3431	= { FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3431_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr3456  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr3456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr3456	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr3456_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_symbolicExpr3463  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_symbolicExpr3463_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008000), ANTLR3_UINT64_LIT(0x9001030000000000), ANTLR3_UINT64_LIT(0x0004002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_symbolicExpr3463	= { FOLLOW_LPAREN_in_symbolicExpr3463_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr3466  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr3466_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008000), ANTLR3_UINT64_LIT(0x9001030000000000), ANTLR3_UINT64_LIT(0x0004002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr3466	= { FOLLOW_symbolicExpr_in_symbolicExpr3466_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_symbolicExpr3474  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_symbolicExpr3474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_symbolicExpr3474	= { FOLLOW_RPAREN_in_symbolicExpr3474_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_toplevelDeclaration3501  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_toplevelDeclaration3501_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_toplevelDeclaration3501	= { FOLLOW_identifierList_in_toplevelDeclaration3501_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_toplevelDeclaration3504  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_toplevelDeclaration3504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_toplevelDeclaration3504	= { FOLLOW_COLON_in_toplevelDeclaration3504_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_toplevelDeclaration3512  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_toplevelDeclaration3512_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_toplevelDeclaration3512	= { FOLLOW_declareVariables_in_toplevelDeclaration3512_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareTypes_in_toplevelDeclaration3521  */
static	ANTLR3_BITWORD FOLLOW_declareTypes_in_toplevelDeclaration3521_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareTypes_in_toplevelDeclaration3521	= { FOLLOW_declareTypes_in_toplevelDeclaration3521_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDecl3545  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDecl3545_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDecl3545	= { FOLLOW_identifierList_in_boundVarDecl3545_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDecl3548  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDecl3548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDecl3548	= { FOLLOW_COLON_in_boundVarDecl3548_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_boundVarDecl3554  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_boundVarDecl3554_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_boundVarDecl3554	= { FOLLOW_declareVariables_in_boundVarDecl3554_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3575  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3575_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3575	= { FOLLOW_boundVarDecl_in_boundVarDecls3575_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDecls3580  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDecls3580_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDecls3580	= { FOLLOW_COMMA_in_boundVarDecls3580_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3582  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3582_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3582	= { FOLLOW_boundVarDecl_in_boundVarDecls3582_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3605  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3605_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3605	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3605_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDeclsReturn3610  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDeclsReturn3610_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDeclsReturn3610	= { FOLLOW_COMMA_in_boundVarDeclsReturn3610_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3612  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3612_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3612	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3612_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDeclReturn3635  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDeclReturn3635_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDeclReturn3635	= { FOLLOW_identifierList_in_boundVarDeclReturn3635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDeclReturn3638  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDeclReturn3638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDeclReturn3638	= { FOLLOW_COLON_in_boundVarDeclReturn3638_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_boundVarDeclReturn3640  */
static	ANTLR3_BITWORD FOLLOW_type_in_boundVarDeclReturn3640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_boundVarDeclReturn3640	= { FOLLOW_type_in_boundVarDeclReturn3640_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3674  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3674_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3674	= { FOLLOW_TYPE_TOK_in_declareTypes3674_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3693  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3693_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3693	= { FOLLOW_TYPE_TOK_in_declareTypes3693_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareTypes3695  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareTypes3695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareTypes3695	= { FOLLOW_EQUAL_TOK_in_declareTypes3695_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareTypes3697  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareTypes3697_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareTypes3697	= { FOLLOW_type_in_declareTypes3697_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareVariables3731  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareVariables3731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareVariables3731	= { FOLLOW_type_in_declareVariables3731_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareVariables3736  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareVariables3736_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareVariables3736	= { FOLLOW_EQUAL_TOK_in_declareVariables3736_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_declareVariables3738  */
static	ANTLR3_BITWORD FOLLOW_formula_in_declareVariables3738_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_declareVariables3738	= { FOLLOW_formula_in_declareVariables3738_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3769  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3769_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3769	= { FOLLOW_identifier_in_identifierList3769_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_identifierList3780  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_identifierList3780_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_identifierList3780	= { FOLLOW_COMMA_in_identifierList3780_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3782  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3782_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3782	= { FOLLOW_identifier_in_identifierList3782_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_identifier3804  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_identifier3804_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_identifier3804	= { FOLLOW_IDENTIFIER_in_identifier3804_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3837  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000202) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3837	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3837_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARROW_TOK_in_type3852  */
static	ANTLR3_BITWORD FOLLOW_ARROW_TOK_in_type3852_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARROW_TOK_in_type3852	= { FOLLOW_ARROW_TOK_in_type3852_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3854  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3854	= { FOLLOW_type_in_type3854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_type3877  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_type3877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_type3877	= { FOLLOW_LET_TOK_in_type3877_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3885  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3885_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3885	= { FOLLOW_typeLetDecl_in_type3885_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_type3890  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_type3890_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_type3890	= { FOLLOW_COMMA_in_type3890_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3892  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3892_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3892	= { FOLLOW_typeLetDecl_in_type3892_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_type3898  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_type3898_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_type3898	= { FOLLOW_IN_TOK_in_type3898_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3900  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3900	= { FOLLOW_type_in_type3900_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3936  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3936_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3936	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3936_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3970  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3970_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3970	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3970_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3977  */
static	ANTLR3_BITWORD FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3977	= { FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3998  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3998	= { FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3998_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4000  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4000	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4000_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4003  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4003_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4003	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4003_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4005  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4005_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4005	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4005_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS4018  */
static	ANTLR3_BITWORD FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS4018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS4018	= { FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS4018_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4020  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4020_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4020	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4020_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4022  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4022_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4022	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4022_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS4042  */
static	ANTLR3_BITWORD FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS4042_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS4042	= { FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS4042_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4044  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4044_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4044	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4044_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4056  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4056_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4056	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4056_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4061  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4061_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4061	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4061_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4063  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4063_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4063	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4063_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4069  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4069_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4069	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4069_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4088  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4088_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8001000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4088	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4088_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4090  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4090_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4090	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4090_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS4092  */
static	ANTLR3_BITWORD FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS4092_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8001000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS4092	= { FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS4092_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4094  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4094_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4094	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4094_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4096  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4096_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4096	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4096_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4115  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000300000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4115	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4115_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4119  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4119_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4119	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4119_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4130  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4130	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4130_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4132  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4132_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4132	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4132_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4143  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4143_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4143	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4143_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4162  */
static	ANTLR3_BITWORD FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4162_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000022000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4162	= { FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4162_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4166  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4166_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4166	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4166_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4169  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4169_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4169	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4169_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4171  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4171_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4171	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4171_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4182  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4182_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4182	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4182_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4184  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4184_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4184	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4184_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4187  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4187	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4187_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4189  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4189_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4189	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4189_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4200  */
static	ANTLR3_BITWORD FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4200	= { FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4219  */
static	ANTLR3_BITWORD FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4219	= { FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4219_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4221  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4221	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4221_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4225  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4225	= { FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4225_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4227  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4227	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4246  */
static	ANTLR3_BITWORD FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4246_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4246	= { FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4246_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4261  */
static	ANTLR3_BITWORD FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4261_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4261	= { FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4261_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4269  */
static	ANTLR3_BITWORD FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4269	= { FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4277  */
static	ANTLR3_BITWORD FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4277	= { FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4292  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4292	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4292_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4294  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4294_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4294	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4294_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4305  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4305	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4305_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4307  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4307_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4307	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4307_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4315  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4315	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4315_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_parameterization4340  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_parameterization4340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_parameterization4340	= { FOLLOW_LBRACKET_in_parameterization4340_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization4342  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization4342_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization4342	= { FOLLOW_restrictedType_in_parameterization4342_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_parameterization4353  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_parameterization4353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_parameterization4353	= { FOLLOW_COMMA_in_parameterization4353_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization4355  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization4355_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization4355	= { FOLLOW_restrictedType_in_parameterization4355_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_parameterization4363  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_parameterization4363_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_parameterization4363	= { FOLLOW_RBRACKET_in_parameterization4363_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNDERSCORE_in_bound4376  */
static	ANTLR3_BITWORD FOLLOW_UNDERSCORE_in_bound4376_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNDERSCORE_in_bound4376	= { FOLLOW_UNDERSCORE_in_bound4376_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_integer_in_bound4382  */
static	ANTLR3_BITWORD FOLLOW_integer_in_bound4382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_integer_in_bound4382	= { FOLLOW_integer_in_bound4382_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_typeLetDecl4399  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_typeLetDecl4399_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_typeLetDecl4399	= { FOLLOW_identifier_in_typeLetDecl4399_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeLetDecl4403  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeLetDecl4403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeLetDecl4403	= { FOLLOW_COLON_in_typeLetDecl4403_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_typeLetDecl4405  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_typeLetDecl4405_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_typeLetDecl4405	= { FOLLOW_TYPE_TOK_in_typeLetDecl4405_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_typeLetDecl4409  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_typeLetDecl4409_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_typeLetDecl4409	= { FOLLOW_EQUAL_TOK_in_typeLetDecl4409_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_typeLetDecl4411  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_typeLetDecl4411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_typeLetDecl4411	= { FOLLOW_restrictedType_in_typeLetDecl4411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_formula4441  */
static	ANTLR3_BITWORD FOLLOW_nots_in_formula4441_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_formula4441	= { FOLLOW_nots_in_formula4441_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_formula4449  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_formula4449_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_formula4449	= { FOLLOW_prefixFormula_in_formula4449_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_formula4466  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_formula4466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x0000280000000000), ANTLR3_UINT64_LIT(0x0000000000000020), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_formula4466	= { FOLLOW_comparison_in_formula4466_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_formula4483  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_formula4483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_formula4483	= { FOLLOW_morecomparisons_in_formula4483_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_booleanBinop_in_morecomparisons4522  */
static	ANTLR3_BITWORD FOLLOW_booleanBinop_in_morecomparisons4522_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_booleanBinop_in_morecomparisons4522	= { FOLLOW_booleanBinop_in_morecomparisons4522_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_morecomparisons4533  */
static	ANTLR3_BITWORD FOLLOW_nots_in_morecomparisons4533_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_morecomparisons4533	= { FOLLOW_nots_in_morecomparisons4533_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_morecomparisons4541  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_morecomparisons4541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_morecomparisons4541	= { FOLLOW_prefixFormula_in_morecomparisons4541_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_morecomparisons4558  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_morecomparisons4558_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x0000280000000000), ANTLR3_UINT64_LIT(0x0000000000000020), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_morecomparisons4558	= { FOLLOW_comparison_in_morecomparisons4558_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_morecomparisons4575  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_morecomparisons4575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_morecomparisons4575	= { FOLLOW_morecomparisons_in_morecomparisons4575_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_nots4604  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_nots4604_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_nots4604	= { FOLLOW_NOT_TOK_in_nots4604_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_prefixFormula4636  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_prefixFormula4636_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_prefixFormula4636	= { FOLLOW_FORALL_TOK_in_prefixFormula4636_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_prefixFormula4642  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_prefixFormula4642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_prefixFormula4642	= { FOLLOW_EXISTS_TOK_in_prefixFormula4642_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4654  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4654_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4654	= { FOLLOW_LPAREN_in_prefixFormula4654_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4660  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4660_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4660	= { FOLLOW_boundVarDecl_in_prefixFormula4660_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4675  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4675	= { FOLLOW_COMMA_in_prefixFormula4675_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4677  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4677_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4677	= { FOLLOW_boundVarDecl_in_prefixFormula4677_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4695  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4695_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4695	= { FOLLOW_RPAREN_in_prefixFormula4695_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4703  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4703_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF8000C2), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4703	= { FOLLOW_COLON_in_prefixFormula4703_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_instantiationPatterns_in_prefixFormula4705  */
static	ANTLR3_BITWORD FOLLOW_instantiationPatterns_in_prefixFormula4705_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_instantiationPatterns_in_prefixFormula4705	= { FOLLOW_instantiationPatterns_in_prefixFormula4705_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4709  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4709_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4709	= { FOLLOW_formula_in_prefixFormula4709_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_prefixFormula4728  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_prefixFormula4728_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_prefixFormula4728	= { FOLLOW_LET_TOK_in_prefixFormula4728_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4736  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4736_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4736	= { FOLLOW_letDecl_in_prefixFormula4736_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4740  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4740	= { FOLLOW_COMMA_in_prefixFormula4740_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4742  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4742_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4742	= { FOLLOW_letDecl_in_prefixFormula4742_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_prefixFormula4751  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_prefixFormula4751_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_prefixFormula4751	= { FOLLOW_IN_TOK_in_prefixFormula4751_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4753  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4753_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4753	= { FOLLOW_formula_in_prefixFormula4753_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LAMBDA_TOK_in_prefixFormula4768  */
static	ANTLR3_BITWORD FOLLOW_LAMBDA_TOK_in_prefixFormula4768_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LAMBDA_TOK_in_prefixFormula4768	= { FOLLOW_LAMBDA_TOK_in_prefixFormula4768_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4772  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4772_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4772	= { FOLLOW_LPAREN_in_prefixFormula4772_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclsReturn_in_prefixFormula4778  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclsReturn_in_prefixFormula4778_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclsReturn_in_prefixFormula4778	= { FOLLOW_boundVarDeclsReturn_in_prefixFormula4778_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4785  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4785_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4785	= { FOLLOW_RPAREN_in_prefixFormula4785_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4787  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4787_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4787	= { FOLLOW_COLON_in_prefixFormula4787_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4789  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4789_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4789	= { FOLLOW_formula_in_prefixFormula4789_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PATTERN_TOK_in_instantiationPatterns4817  */
static	ANTLR3_BITWORD FOLLOW_PATTERN_TOK_in_instantiationPatterns4817_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PATTERN_TOK_in_instantiationPatterns4817	= { FOLLOW_PATTERN_TOK_in_instantiationPatterns4817_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_instantiationPatterns4819  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_instantiationPatterns4819_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_instantiationPatterns4819	= { FOLLOW_LPAREN_in_instantiationPatterns4819_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4821  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4821_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4821	= { FOLLOW_formula_in_instantiationPatterns4821_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_instantiationPatterns4827  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_instantiationPatterns4827_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_instantiationPatterns4827	= { FOLLOW_COMMA_in_instantiationPatterns4827_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4829  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4829_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4829	= { FOLLOW_formula_in_instantiationPatterns4829_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_instantiationPatterns4837  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_instantiationPatterns4837_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_instantiationPatterns4837	= { FOLLOW_RPAREN_in_instantiationPatterns4837_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_instantiationPatterns4839  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_instantiationPatterns4839_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_instantiationPatterns4839	= { FOLLOW_COLON_in_instantiationPatterns4839_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_letDecl4876  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_letDecl4876_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_letDecl4876	= { FOLLOW_identifier_in_letDecl4876_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_letDecl4879  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_letDecl4879_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_letDecl4879	= { FOLLOW_EQUAL_TOK_in_letDecl4879_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_letDecl4881  */
static	ANTLR3_BITWORD FOLLOW_formula_in_letDecl4881_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_letDecl4881	= { FOLLOW_formula_in_letDecl4881_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4950  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4950_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x6400000848100001) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4950	= { FOLLOW_term_in_comparison4950_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparisonBinop_in_comparison4961  */
static	ANTLR3_BITWORD FOLLOW_comparisonBinop_in_comparison4961_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_comparisonBinop_in_comparison4961	= { FOLLOW_comparisonBinop_in_comparison4961_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4964  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x6400000848100001) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4964	= { FOLLOW_term_in_comparison4964_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_term5119  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_term5119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x8000800001000008), ANTLR3_UINT64_LIT(0x0000080000000101), ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_term5119	= { FOLLOW_uminusTerm_in_term5119_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WITH_TOK_in_term5128  */
static	ANTLR3_BITWORD FOLLOW_WITH_TOK_in_term5128_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_WITH_TOK_in_term5128	= { FOLLOW_WITH_TOK_in_term5128_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_term5138  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_term5138_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_term5138	= { FOLLOW_arrayStore_in_term5138_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5143  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5143_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5143	= { FOLLOW_COMMA_in_term5143_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_term5145  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_term5145_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_term5145	= { FOLLOW_arrayStore_in_term5145_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5159  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5159_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5159	= { FOLLOW_DOT_in_term5159_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_term5163  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_term5163_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_term5163	= { FOLLOW_tupleStore_in_term5163_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5168  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5168_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5168	= { FOLLOW_COMMA_in_term5168_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5170  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5170	= { FOLLOW_DOT_in_term5170_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_term5172  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_term5172_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_term5172	= { FOLLOW_tupleStore_in_term5172_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_term5192  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_term5192_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_term5192	= { FOLLOW_recordStore_in_term5192_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5197  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5197	= { FOLLOW_COMMA_in_term5197_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5199  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5199_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5199	= { FOLLOW_DOT_in_term5199_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_term5201  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_term5201_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_term5201	= { FOLLOW_recordStore_in_term5201_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arithmeticBinop_in_term5227  */
static	ANTLR3_BITWORD FOLLOW_arithmeticBinop_in_term5227_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_arithmeticBinop_in_term5227	= { FOLLOW_arithmeticBinop_in_term5227_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_term5230  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_term5230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x8000800001000008), ANTLR3_UINT64_LIT(0x0000080000000101) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_term5230	= { FOLLOW_uminusTerm_in_term5230_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_arrayStore5271  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_arrayStore5271_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_arrayStore5271	= { FOLLOW_LBRACKET_in_arrayStore5271_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_arrayStore5273  */
static	ANTLR3_BITWORD FOLLOW_formula_in_arrayStore5273_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_arrayStore5273	= { FOLLOW_formula_in_arrayStore5273_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_arrayStore5276  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_arrayStore5276_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_arrayStore5276	= { FOLLOW_RBRACKET_in_arrayStore5276_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_arrayStore5292  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_arrayStore5292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_arrayStore5292	= { FOLLOW_arrayStore_in_arrayStore5292_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_arrayStore5303  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_arrayStore5303_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_arrayStore5303	= { FOLLOW_DOT_in_arrayStore5303_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_arrayStore5307  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_arrayStore5307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_arrayStore5307	= { FOLLOW_tupleStore_in_arrayStore5307_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_arrayStore5324  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_arrayStore5324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_arrayStore5324	= { FOLLOW_recordStore_in_arrayStore5324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_arrayStore5337  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_arrayStore5337_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_arrayStore5337	= { FOLLOW_ASSIGN_TOK_in_arrayStore5337_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_arrayStore5339  */
static	ANTLR3_BITWORD FOLLOW_term_in_arrayStore5339_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_arrayStore5339	= { FOLLOW_term_in_arrayStore5339_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_tupleStore5371  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_tupleStore5371_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_tupleStore5371	= { FOLLOW_numeral_in_tupleStore5371_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_tupleStore5387  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_tupleStore5387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_tupleStore5387	= { FOLLOW_arrayStore_in_tupleStore5387_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_tupleStore5398  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_tupleStore5398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_tupleStore5398	= { FOLLOW_DOT_in_tupleStore5398_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_tupleStore5402  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_tupleStore5402_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_tupleStore5402	= { FOLLOW_tupleStore_in_tupleStore5402_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_tupleStore5419  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_tupleStore5419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_tupleStore5419	= { FOLLOW_recordStore_in_tupleStore5419_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_tupleStore5432  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_tupleStore5432_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_tupleStore5432	= { FOLLOW_ASSIGN_TOK_in_tupleStore5432_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_tupleStore5434  */
static	ANTLR3_BITWORD FOLLOW_term_in_tupleStore5434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_tupleStore5434	= { FOLLOW_term_in_tupleStore5434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordStore5464  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordStore5464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordStore5464	= { FOLLOW_identifier_in_recordStore5464_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_recordStore5481  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_recordStore5481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_recordStore5481	= { FOLLOW_arrayStore_in_recordStore5481_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_recordStore5492  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_recordStore5492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_recordStore5492	= { FOLLOW_DOT_in_recordStore5492_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_recordStore5496  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_recordStore5496_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_recordStore5496	= { FOLLOW_tupleStore_in_recordStore5496_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_recordStore5513  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_recordStore5513_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_recordStore5513	= { FOLLOW_recordStore_in_recordStore5513_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordStore5526  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordStore5526_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordStore5526	= { FOLLOW_ASSIGN_TOK_in_recordStore5526_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_recordStore5528  */
static	ANTLR3_BITWORD FOLLOW_term_in_recordStore5528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_recordStore5528	= { FOLLOW_term_in_recordStore5528_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_uminusTerm5565  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_uminusTerm5565_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_uminusTerm5565	= { FOLLOW_MINUS_TOK_in_uminusTerm5565_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm5571  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm5571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm5571	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm5571_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5596  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5596_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5596	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5596_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinop_in_bvBinaryOpTerm5607  */
static	ANTLR3_BITWORD FOLLOW_bvBinop_in_bvBinaryOpTerm5607_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinop_in_bvBinaryOpTerm5607	= { FOLLOW_bvBinop_in_bvBinaryOpTerm5607_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5610  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5610_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5610	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5610_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNEG_TOK_in_bvNegTerm5673  */
static	ANTLR3_BITWORD FOLLOW_BVNEG_TOK_in_bvNegTerm5673_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNEG_TOK_in_bvNegTerm5673	= { FOLLOW_BVNEG_TOK_in_bvNegTerm5673_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvNegTerm5675  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvNegTerm5675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvNegTerm5675	= { FOLLOW_bvNegTerm_in_bvNegTerm5675_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationBinopTerm_in_bvNegTerm5688  */
static	ANTLR3_BITWORD FOLLOW_relationBinopTerm_in_bvNegTerm5688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationBinopTerm_in_bvNegTerm5688	= { FOLLOW_relationBinopTerm_in_bvNegTerm5688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_postfixTerm_in_relationBinopTerm5739  */
static	ANTLR3_BITWORD FOLLOW_postfixTerm_in_relationBinopTerm5739_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0030000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_postfixTerm_in_relationBinopTerm5739	= { FOLLOW_postfixTerm_in_relationBinopTerm5739_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationBinop_in_relationBinopTerm5750  */
static	ANTLR3_BITWORD FOLLOW_relationBinop_in_relationBinopTerm5750_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x3BFFF183FF800040), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_relationBinop_in_relationBinopTerm5750	= { FOLLOW_relationBinop_in_relationBinopTerm5750_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_postfixTerm_in_relationBinopTerm5753  */
static	ANTLR3_BITWORD FOLLOW_postfixTerm_in_relationBinopTerm5753_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0030000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_postfixTerm_in_relationBinopTerm5753	= { FOLLOW_postfixTerm_in_relationBinopTerm5753_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_postfixTerm5788  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_postfixTerm5788_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_postfixTerm5788	= { FOLLOW_relationTerm_in_postfixTerm5788_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_postfixTerm5805  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_postfixTerm5805_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_postfixTerm5805	= { FOLLOW_LBRACKET_in_postfixTerm5805_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5817  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5817_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5817	= { FOLLOW_formula_in_postfixTerm5817_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5834  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5834_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5834	= { FOLLOW_numeral_in_postfixTerm5834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_postfixTerm5836  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_postfixTerm5836_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_postfixTerm5836	= { FOLLOW_COLON_in_postfixTerm5836_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5840  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5840_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5840	= { FOLLOW_numeral_in_postfixTerm5840_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_postfixTerm5852  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_postfixTerm5852_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_postfixTerm5852	= { FOLLOW_RBRACKET_in_postfixTerm5852_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5878  */
static	ANTLR3_BITWORD FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5878_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5878	= { FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5878_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5890  */
static	ANTLR3_BITWORD FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5890_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5890	= { FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5890_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5898  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5898_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5898	= { FOLLOW_numeral_in_postfixTerm5898_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5923  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5923_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5923	= { FOLLOW_LPAREN_in_postfixTerm5923_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5933  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5933_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5933	= { FOLLOW_formula_in_postfixTerm5933_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm5946  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm5946_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm5946	= { FOLLOW_COMMA_in_postfixTerm5946_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5948  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5948_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5948	= { FOLLOW_formula_in_postfixTerm5948_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5956  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5956_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5956	= { FOLLOW_RPAREN_in_postfixTerm5956_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_postfixTerm5981  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_postfixTerm5981_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_postfixTerm5981	= { FOLLOW_DOT_in_postfixTerm5981_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_postfixTerm5991  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_postfixTerm5991_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_postfixTerm5991	= { FOLLOW_identifier_in_postfixTerm5991_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm6014  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm6014_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm6014	= { FOLLOW_numeral_in_postfixTerm6014_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FLOOR_TOK_in_postfixTerm6047  */
static	ANTLR3_BITWORD FOLLOW_FLOOR_TOK_in_postfixTerm6047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FLOOR_TOK_in_postfixTerm6047	= { FOLLOW_FLOOR_TOK_in_postfixTerm6047_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6049  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6049_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6049	= { FOLLOW_LPAREN_in_postfixTerm6049_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6051  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6051_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6051	= { FOLLOW_formula_in_postfixTerm6051_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6054  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6054_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6054	= { FOLLOW_RPAREN_in_postfixTerm6054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_INTEGER_TOK_in_postfixTerm6070  */
static	ANTLR3_BITWORD FOLLOW_IS_INTEGER_TOK_in_postfixTerm6070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_INTEGER_TOK_in_postfixTerm6070	= { FOLLOW_IS_INTEGER_TOK_in_postfixTerm6070_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6072  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6072_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6072	= { FOLLOW_LPAREN_in_postfixTerm6072_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6074  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6074_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6074	= { FOLLOW_formula_in_postfixTerm6074_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6077  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6077_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6077	= { FOLLOW_RPAREN_in_postfixTerm6077_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ABS_TOK_in_postfixTerm6093  */
static	ANTLR3_BITWORD FOLLOW_ABS_TOK_in_postfixTerm6093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ABS_TOK_in_postfixTerm6093	= { FOLLOW_ABS_TOK_in_postfixTerm6093_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6095  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6095_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6095	= { FOLLOW_LPAREN_in_postfixTerm6095_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6097  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6097	= { FOLLOW_formula_in_postfixTerm6097_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6100  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6100_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6100	= { FOLLOW_RPAREN_in_postfixTerm6100_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_postfixTerm6116  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_postfixTerm6116_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_postfixTerm6116	= { FOLLOW_DIVISIBLE_TOK_in_postfixTerm6116_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6118  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6118_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6118	= { FOLLOW_LPAREN_in_postfixTerm6118_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6120  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6120_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6120	= { FOLLOW_formula_in_postfixTerm6120_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm6123  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm6123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm6123	= { FOLLOW_COMMA_in_postfixTerm6123_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm6127  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm6127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm6127	= { FOLLOW_numeral_in_postfixTerm6127_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6129  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6129_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6129	= { FOLLOW_RPAREN_in_postfixTerm6129_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_postfixTerm6145  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_postfixTerm6145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_postfixTerm6145	= { FOLLOW_DISTINCT_TOK_in_postfixTerm6145_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6147  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6147_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6147	= { FOLLOW_LPAREN_in_postfixTerm6147_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6155  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6155_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6155	= { FOLLOW_formula_in_postfixTerm6155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm6168  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm6168_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm6168	= { FOLLOW_COMMA_in_postfixTerm6168_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6170  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6170_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6170	= { FOLLOW_formula_in_postfixTerm6170_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6178  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6178_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6178	= { FOLLOW_RPAREN_in_postfixTerm6178_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeAscription_in_postfixTerm6200  */
static	ANTLR3_BITWORD FOLLOW_typeAscription_in_postfixTerm6200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeAscription_in_postfixTerm6200	= { FOLLOW_typeAscription_in_postfixTerm6200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSPOSE_TOK_in_relationTerm6236  */
static	ANTLR3_BITWORD FOLLOW_TRANSPOSE_TOK_in_relationTerm6236_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSPOSE_TOK_in_relationTerm6236	= { FOLLOW_TRANSPOSE_TOK_in_relationTerm6236_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_relationTerm6238  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_relationTerm6238_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_relationTerm6238	= { FOLLOW_LPAREN_in_relationTerm6238_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_relationTerm6240  */
static	ANTLR3_BITWORD FOLLOW_formula_in_relationTerm6240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_relationTerm6240	= { FOLLOW_formula_in_relationTerm6240_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_relationTerm6243  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_relationTerm6243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_relationTerm6243	= { FOLLOW_RPAREN_in_relationTerm6243_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSCLOSURE_TOK_in_relationTerm6255  */
static	ANTLR3_BITWORD FOLLOW_TRANSCLOSURE_TOK_in_relationTerm6255_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSCLOSURE_TOK_in_relationTerm6255	= { FOLLOW_TRANSCLOSURE_TOK_in_relationTerm6255_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_relationTerm6257  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_relationTerm6257_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_relationTerm6257	= { FOLLOW_LPAREN_in_relationTerm6257_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_relationTerm6259  */
static	ANTLR3_BITWORD FOLLOW_formula_in_relationTerm6259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_relationTerm6259	= { FOLLOW_formula_in_relationTerm6259_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_relationTerm6262  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_relationTerm6262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_relationTerm6262	= { FOLLOW_RPAREN_in_relationTerm6262_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_TOK_in_relationTerm6274  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_TOK_in_relationTerm6274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_TOK_in_relationTerm6274	= { FOLLOW_TUPLE_TOK_in_relationTerm6274_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_relationTerm6276  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_relationTerm6276_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_relationTerm6276	= { FOLLOW_LPAREN_in_relationTerm6276_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_relationTerm6278  */
static	ANTLR3_BITWORD FOLLOW_formula_in_relationTerm6278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_relationTerm6278	= { FOLLOW_formula_in_relationTerm6278_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_relationTerm6281  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_relationTerm6281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_relationTerm6281	= { FOLLOW_RPAREN_in_relationTerm6281_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDEN_TOK_in_relationTerm6293  */
static	ANTLR3_BITWORD FOLLOW_IDEN_TOK_in_relationTerm6293_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDEN_TOK_in_relationTerm6293	= { FOLLOW_IDEN_TOK_in_relationTerm6293_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_relationTerm6295  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_relationTerm6295_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_relationTerm6295	= { FOLLOW_LPAREN_in_relationTerm6295_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_relationTerm6297  */
static	ANTLR3_BITWORD FOLLOW_formula_in_relationTerm6297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_relationTerm6297	= { FOLLOW_formula_in_relationTerm6297_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_relationTerm6300  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_relationTerm6300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_relationTerm6300	= { FOLLOW_RPAREN_in_relationTerm6300_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvTerm_in_relationTerm6312  */
static	ANTLR3_BITWORD FOLLOW_bvTerm_in_relationTerm6312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvTerm_in_relationTerm6312	= { FOLLOW_bvTerm_in_relationTerm6312_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXOR_TOK_in_bvTerm6338  */
static	ANTLR3_BITWORD FOLLOW_BVXOR_TOK_in_bvTerm6338_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXOR_TOK_in_bvTerm6338	= { FOLLOW_BVXOR_TOK_in_bvTerm6338_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6340  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6340_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6340	= { FOLLOW_LPAREN_in_bvTerm6340_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6342  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6342_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6342	= { FOLLOW_formula_in_bvTerm6342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6345  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6345_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6345	= { FOLLOW_COMMA_in_bvTerm6345_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6347  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6347	= { FOLLOW_formula_in_bvTerm6347_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6350  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6350_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6350	= { FOLLOW_RPAREN_in_bvTerm6350_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNAND_TOK_in_bvTerm6362  */
static	ANTLR3_BITWORD FOLLOW_BVNAND_TOK_in_bvTerm6362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNAND_TOK_in_bvTerm6362	= { FOLLOW_BVNAND_TOK_in_bvTerm6362_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6364  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6364_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6364	= { FOLLOW_LPAREN_in_bvTerm6364_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6366  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6366_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6366	= { FOLLOW_formula_in_bvTerm6366_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6369  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6369_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6369	= { FOLLOW_COMMA_in_bvTerm6369_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6371  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6371_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6371	= { FOLLOW_formula_in_bvTerm6371_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6374  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6374	= { FOLLOW_RPAREN_in_bvTerm6374_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNOR_TOK_in_bvTerm6386  */
static	ANTLR3_BITWORD FOLLOW_BVNOR_TOK_in_bvTerm6386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNOR_TOK_in_bvTerm6386	= { FOLLOW_BVNOR_TOK_in_bvTerm6386_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6388  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6388_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6388	= { FOLLOW_LPAREN_in_bvTerm6388_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6390  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6390_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6390	= { FOLLOW_formula_in_bvTerm6390_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6393  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6393_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6393	= { FOLLOW_COMMA_in_bvTerm6393_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6395  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6395	= { FOLLOW_formula_in_bvTerm6395_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6398  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6398	= { FOLLOW_RPAREN_in_bvTerm6398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVCOMP_TOK_in_bvTerm6410  */
static	ANTLR3_BITWORD FOLLOW_BVCOMP_TOK_in_bvTerm6410_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVCOMP_TOK_in_bvTerm6410	= { FOLLOW_BVCOMP_TOK_in_bvTerm6410_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6412  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6412_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6412	= { FOLLOW_LPAREN_in_bvTerm6412_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6414  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6414_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6414	= { FOLLOW_formula_in_bvTerm6414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6417  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6417_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6417	= { FOLLOW_COMMA_in_bvTerm6417_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6419  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6419	= { FOLLOW_formula_in_bvTerm6419_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6422  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6422	= { FOLLOW_RPAREN_in_bvTerm6422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXNOR_TOK_in_bvTerm6434  */
static	ANTLR3_BITWORD FOLLOW_BVXNOR_TOK_in_bvTerm6434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXNOR_TOK_in_bvTerm6434	= { FOLLOW_BVXNOR_TOK_in_bvTerm6434_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6436  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6436_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6436	= { FOLLOW_LPAREN_in_bvTerm6436_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6438  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6438_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6438	= { FOLLOW_formula_in_bvTerm6438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6441  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6441_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6441	= { FOLLOW_COMMA_in_bvTerm6441_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6443  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6443_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6443	= { FOLLOW_formula_in_bvTerm6443_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6446  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6446	= { FOLLOW_RPAREN_in_bvTerm6446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUMINUS_TOK_in_bvTerm6465  */
static	ANTLR3_BITWORD FOLLOW_BVUMINUS_TOK_in_bvTerm6465_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUMINUS_TOK_in_bvTerm6465	= { FOLLOW_BVUMINUS_TOK_in_bvTerm6465_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6467  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6467_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6467	= { FOLLOW_LPAREN_in_bvTerm6467_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6469  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6469_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6469	= { FOLLOW_formula_in_bvTerm6469_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6472  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6472_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6472	= { FOLLOW_RPAREN_in_bvTerm6472_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVPLUS_TOK_in_bvTerm6490  */
static	ANTLR3_BITWORD FOLLOW_BVPLUS_TOK_in_bvTerm6490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVPLUS_TOK_in_bvTerm6490	= { FOLLOW_BVPLUS_TOK_in_bvTerm6490_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6492  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6492	= { FOLLOW_LPAREN_in_bvTerm6492_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6496  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6496_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6496	= { FOLLOW_numeral_in_bvTerm6496_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6498  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6498_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6498	= { FOLLOW_COMMA_in_bvTerm6498_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6500  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6500_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6500	= { FOLLOW_formula_in_bvTerm6500_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6511  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6511_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6511	= { FOLLOW_COMMA_in_bvTerm6511_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6513  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6513_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6513	= { FOLLOW_formula_in_bvTerm6513_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6521  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6521_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6521	= { FOLLOW_RPAREN_in_bvTerm6521_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSUB_TOK_in_bvTerm6539  */
static	ANTLR3_BITWORD FOLLOW_BVSUB_TOK_in_bvTerm6539_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSUB_TOK_in_bvTerm6539	= { FOLLOW_BVSUB_TOK_in_bvTerm6539_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6541  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6541	= { FOLLOW_LPAREN_in_bvTerm6541_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6545  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6545_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6545	= { FOLLOW_numeral_in_bvTerm6545_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6547  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6547_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6547	= { FOLLOW_COMMA_in_bvTerm6547_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6549  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6549_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6549	= { FOLLOW_formula_in_bvTerm6549_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6552  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6552_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6552	= { FOLLOW_COMMA_in_bvTerm6552_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6554  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6554_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6554	= { FOLLOW_formula_in_bvTerm6554_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6557  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6557_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6557	= { FOLLOW_RPAREN_in_bvTerm6557_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVMULT_TOK_in_bvTerm6575  */
static	ANTLR3_BITWORD FOLLOW_BVMULT_TOK_in_bvTerm6575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVMULT_TOK_in_bvTerm6575	= { FOLLOW_BVMULT_TOK_in_bvTerm6575_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6577  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6577_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6577	= { FOLLOW_LPAREN_in_bvTerm6577_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6581  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6581_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6581	= { FOLLOW_numeral_in_bvTerm6581_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6583  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6583_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6583	= { FOLLOW_COMMA_in_bvTerm6583_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6585  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6585_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6585	= { FOLLOW_formula_in_bvTerm6585_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6588  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6588_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6588	= { FOLLOW_COMMA_in_bvTerm6588_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6590  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6590_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6590	= { FOLLOW_formula_in_bvTerm6590_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6593  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6593_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6593	= { FOLLOW_RPAREN_in_bvTerm6593_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUDIV_TOK_in_bvTerm6611  */
static	ANTLR3_BITWORD FOLLOW_BVUDIV_TOK_in_bvTerm6611_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUDIV_TOK_in_bvTerm6611	= { FOLLOW_BVUDIV_TOK_in_bvTerm6611_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6613  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6613_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6613	= { FOLLOW_LPAREN_in_bvTerm6613_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6615  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6615_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6615	= { FOLLOW_formula_in_bvTerm6615_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6618  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6618_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6618	= { FOLLOW_COMMA_in_bvTerm6618_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6620  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6620_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6620	= { FOLLOW_formula_in_bvTerm6620_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6623  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6623	= { FOLLOW_RPAREN_in_bvTerm6623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSDIV_TOK_in_bvTerm6641  */
static	ANTLR3_BITWORD FOLLOW_BVSDIV_TOK_in_bvTerm6641_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSDIV_TOK_in_bvTerm6641	= { FOLLOW_BVSDIV_TOK_in_bvTerm6641_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6643  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6643_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6643	= { FOLLOW_LPAREN_in_bvTerm6643_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6645  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6645_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6645	= { FOLLOW_formula_in_bvTerm6645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6648  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6648_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6648	= { FOLLOW_COMMA_in_bvTerm6648_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6650  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6650_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6650	= { FOLLOW_formula_in_bvTerm6650_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6653  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6653_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6653	= { FOLLOW_RPAREN_in_bvTerm6653_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUREM_TOK_in_bvTerm6671  */
static	ANTLR3_BITWORD FOLLOW_BVUREM_TOK_in_bvTerm6671_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUREM_TOK_in_bvTerm6671	= { FOLLOW_BVUREM_TOK_in_bvTerm6671_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6673  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6673_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6673	= { FOLLOW_LPAREN_in_bvTerm6673_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6675  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6675_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6675	= { FOLLOW_formula_in_bvTerm6675_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6678  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6678_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6678	= { FOLLOW_COMMA_in_bvTerm6678_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6680  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6680_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6680	= { FOLLOW_formula_in_bvTerm6680_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6683  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6683_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6683	= { FOLLOW_RPAREN_in_bvTerm6683_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSREM_TOK_in_bvTerm6701  */
static	ANTLR3_BITWORD FOLLOW_BVSREM_TOK_in_bvTerm6701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSREM_TOK_in_bvTerm6701	= { FOLLOW_BVSREM_TOK_in_bvTerm6701_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6703  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6703_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6703	= { FOLLOW_LPAREN_in_bvTerm6703_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6705  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6705_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6705	= { FOLLOW_formula_in_bvTerm6705_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6708  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6708_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6708	= { FOLLOW_COMMA_in_bvTerm6708_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6710  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6710_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6710	= { FOLLOW_formula_in_bvTerm6710_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6713  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6713_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6713	= { FOLLOW_RPAREN_in_bvTerm6713_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSMOD_TOK_in_bvTerm6731  */
static	ANTLR3_BITWORD FOLLOW_BVSMOD_TOK_in_bvTerm6731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSMOD_TOK_in_bvTerm6731	= { FOLLOW_BVSMOD_TOK_in_bvTerm6731_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6733  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6733_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6733	= { FOLLOW_LPAREN_in_bvTerm6733_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6735  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6735_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6735	= { FOLLOW_formula_in_bvTerm6735_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6738  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6738_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6738	= { FOLLOW_COMMA_in_bvTerm6738_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6740  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6740	= { FOLLOW_formula_in_bvTerm6740_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6743  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6743	= { FOLLOW_RPAREN_in_bvTerm6743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSHL_TOK_in_bvTerm6761  */
static	ANTLR3_BITWORD FOLLOW_BVSHL_TOK_in_bvTerm6761_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSHL_TOK_in_bvTerm6761	= { FOLLOW_BVSHL_TOK_in_bvTerm6761_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6763  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6763_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6763	= { FOLLOW_LPAREN_in_bvTerm6763_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6765  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6765_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6765	= { FOLLOW_formula_in_bvTerm6765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6768  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6768_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6768	= { FOLLOW_COMMA_in_bvTerm6768_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6770  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6770_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6770	= { FOLLOW_formula_in_bvTerm6770_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6773  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6773_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6773	= { FOLLOW_RPAREN_in_bvTerm6773_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVASHR_TOK_in_bvTerm6791  */
static	ANTLR3_BITWORD FOLLOW_BVASHR_TOK_in_bvTerm6791_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVASHR_TOK_in_bvTerm6791	= { FOLLOW_BVASHR_TOK_in_bvTerm6791_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6793  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6793_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6793	= { FOLLOW_LPAREN_in_bvTerm6793_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6795  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6795_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6795	= { FOLLOW_formula_in_bvTerm6795_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6798  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6798_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6798	= { FOLLOW_COMMA_in_bvTerm6798_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6800  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6800_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6800	= { FOLLOW_formula_in_bvTerm6800_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6803  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6803_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6803	= { FOLLOW_RPAREN_in_bvTerm6803_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLSHR_TOK_in_bvTerm6821  */
static	ANTLR3_BITWORD FOLLOW_BVLSHR_TOK_in_bvTerm6821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLSHR_TOK_in_bvTerm6821	= { FOLLOW_BVLSHR_TOK_in_bvTerm6821_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6823  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6823_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6823	= { FOLLOW_LPAREN_in_bvTerm6823_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6825  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6825_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6825	= { FOLLOW_formula_in_bvTerm6825_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6828  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6828_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6828	= { FOLLOW_COMMA_in_bvTerm6828_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6830  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6830	= { FOLLOW_formula_in_bvTerm6830_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6833  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6833_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6833	= { FOLLOW_RPAREN_in_bvTerm6833_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SX_TOK_in_bvTerm6851  */
static	ANTLR3_BITWORD FOLLOW_SX_TOK_in_bvTerm6851_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SX_TOK_in_bvTerm6851	= { FOLLOW_SX_TOK_in_bvTerm6851_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6853  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6853_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6853	= { FOLLOW_LPAREN_in_bvTerm6853_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6855  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6855_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6855	= { FOLLOW_formula_in_bvTerm6855_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6858  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6858	= { FOLLOW_COMMA_in_bvTerm6858_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6862  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6862	= { FOLLOW_numeral_in_bvTerm6862_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6864  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6864	= { FOLLOW_RPAREN_in_bvTerm6864_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6882  */
static	ANTLR3_BITWORD FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6882_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6882	= { FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6882_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6884  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6884_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6884	= { FOLLOW_LPAREN_in_bvTerm6884_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6886  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6886_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6886	= { FOLLOW_formula_in_bvTerm6886_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6889  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6889_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6889	= { FOLLOW_COMMA_in_bvTerm6889_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6893  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6893_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6893	= { FOLLOW_numeral_in_bvTerm6893_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6895  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6895_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6895	= { FOLLOW_RPAREN_in_bvTerm6895_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVREPEAT_TOK_in_bvTerm6913  */
static	ANTLR3_BITWORD FOLLOW_BVREPEAT_TOK_in_bvTerm6913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVREPEAT_TOK_in_bvTerm6913	= { FOLLOW_BVREPEAT_TOK_in_bvTerm6913_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6915  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6915_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6915	= { FOLLOW_LPAREN_in_bvTerm6915_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6917  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6917_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6917	= { FOLLOW_formula_in_bvTerm6917_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6920  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6920_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6920	= { FOLLOW_COMMA_in_bvTerm6920_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6924  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6924	= { FOLLOW_numeral_in_bvTerm6924_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6926  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6926_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6926	= { FOLLOW_RPAREN_in_bvTerm6926_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTR_TOK_in_bvTerm6944  */
static	ANTLR3_BITWORD FOLLOW_BVROTR_TOK_in_bvTerm6944_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTR_TOK_in_bvTerm6944	= { FOLLOW_BVROTR_TOK_in_bvTerm6944_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6946  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6946_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6946	= { FOLLOW_LPAREN_in_bvTerm6946_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6948  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6948_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6948	= { FOLLOW_formula_in_bvTerm6948_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6951  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6951_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6951	= { FOLLOW_COMMA_in_bvTerm6951_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6955  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6955_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6955	= { FOLLOW_numeral_in_bvTerm6955_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6957  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6957_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6957	= { FOLLOW_RPAREN_in_bvTerm6957_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTL_TOK_in_bvTerm6975  */
static	ANTLR3_BITWORD FOLLOW_BVROTL_TOK_in_bvTerm6975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTL_TOK_in_bvTerm6975	= { FOLLOW_BVROTL_TOK_in_bvTerm6975_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6977  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6977_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6977	= { FOLLOW_LPAREN_in_bvTerm6977_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6979  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6979_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6979	= { FOLLOW_formula_in_bvTerm6979_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6982  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6982	= { FOLLOW_COMMA_in_bvTerm6982_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6986  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6986_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6986	= { FOLLOW_numeral_in_bvTerm6986_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6988  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6988	= { FOLLOW_RPAREN_in_bvTerm6988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLT_TOK_in_bvTerm7007  */
static	ANTLR3_BITWORD FOLLOW_BVLT_TOK_in_bvTerm7007_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLT_TOK_in_bvTerm7007	= { FOLLOW_BVLT_TOK_in_bvTerm7007_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7009  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7009_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7009	= { FOLLOW_LPAREN_in_bvTerm7009_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7011  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7011_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7011	= { FOLLOW_formula_in_bvTerm7011_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7014  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7014_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7014	= { FOLLOW_COMMA_in_bvTerm7014_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7016  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7016_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7016	= { FOLLOW_formula_in_bvTerm7016_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7019  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7019_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7019	= { FOLLOW_RPAREN_in_bvTerm7019_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLE_TOK_in_bvTerm7031  */
static	ANTLR3_BITWORD FOLLOW_BVLE_TOK_in_bvTerm7031_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLE_TOK_in_bvTerm7031	= { FOLLOW_BVLE_TOK_in_bvTerm7031_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7033  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7033_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7033	= { FOLLOW_LPAREN_in_bvTerm7033_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7035  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7035_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7035	= { FOLLOW_formula_in_bvTerm7035_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7038  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7038_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7038	= { FOLLOW_COMMA_in_bvTerm7038_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7040  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7040	= { FOLLOW_formula_in_bvTerm7040_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7043  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7043	= { FOLLOW_RPAREN_in_bvTerm7043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGT_TOK_in_bvTerm7055  */
static	ANTLR3_BITWORD FOLLOW_BVGT_TOK_in_bvTerm7055_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGT_TOK_in_bvTerm7055	= { FOLLOW_BVGT_TOK_in_bvTerm7055_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7057  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7057_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7057	= { FOLLOW_LPAREN_in_bvTerm7057_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7059  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7059_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7059	= { FOLLOW_formula_in_bvTerm7059_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7062  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7062_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7062	= { FOLLOW_COMMA_in_bvTerm7062_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7064  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7064_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7064	= { FOLLOW_formula_in_bvTerm7064_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7067  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7067_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7067	= { FOLLOW_RPAREN_in_bvTerm7067_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGE_TOK_in_bvTerm7079  */
static	ANTLR3_BITWORD FOLLOW_BVGE_TOK_in_bvTerm7079_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGE_TOK_in_bvTerm7079	= { FOLLOW_BVGE_TOK_in_bvTerm7079_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7081  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7081_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7081	= { FOLLOW_LPAREN_in_bvTerm7081_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7083  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7083_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7083	= { FOLLOW_formula_in_bvTerm7083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7086  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7086_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7086	= { FOLLOW_COMMA_in_bvTerm7086_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7088  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7088_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7088	= { FOLLOW_formula_in_bvTerm7088_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7091  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7091_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7091	= { FOLLOW_RPAREN_in_bvTerm7091_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLT_TOK_in_bvTerm7103  */
static	ANTLR3_BITWORD FOLLOW_BVSLT_TOK_in_bvTerm7103_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLT_TOK_in_bvTerm7103	= { FOLLOW_BVSLT_TOK_in_bvTerm7103_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7105  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7105_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7105	= { FOLLOW_LPAREN_in_bvTerm7105_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7107  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7107_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7107	= { FOLLOW_formula_in_bvTerm7107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7110  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7110_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7110	= { FOLLOW_COMMA_in_bvTerm7110_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7112  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7112	= { FOLLOW_formula_in_bvTerm7112_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7115  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7115	= { FOLLOW_RPAREN_in_bvTerm7115_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLE_TOK_in_bvTerm7127  */
static	ANTLR3_BITWORD FOLLOW_BVSLE_TOK_in_bvTerm7127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLE_TOK_in_bvTerm7127	= { FOLLOW_BVSLE_TOK_in_bvTerm7127_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7129  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7129_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7129	= { FOLLOW_LPAREN_in_bvTerm7129_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7131  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7131_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7131	= { FOLLOW_formula_in_bvTerm7131_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7134  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7134_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7134	= { FOLLOW_COMMA_in_bvTerm7134_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7136  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7136_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7136	= { FOLLOW_formula_in_bvTerm7136_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7139  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7139_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7139	= { FOLLOW_RPAREN_in_bvTerm7139_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGT_TOK_in_bvTerm7151  */
static	ANTLR3_BITWORD FOLLOW_BVSGT_TOK_in_bvTerm7151_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGT_TOK_in_bvTerm7151	= { FOLLOW_BVSGT_TOK_in_bvTerm7151_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7153  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7153_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7153	= { FOLLOW_LPAREN_in_bvTerm7153_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7155  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7155_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7155	= { FOLLOW_formula_in_bvTerm7155_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7158  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7158_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7158	= { FOLLOW_COMMA_in_bvTerm7158_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7160  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7160	= { FOLLOW_formula_in_bvTerm7160_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7163  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7163	= { FOLLOW_RPAREN_in_bvTerm7163_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGE_TOK_in_bvTerm7175  */
static	ANTLR3_BITWORD FOLLOW_BVSGE_TOK_in_bvTerm7175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGE_TOK_in_bvTerm7175	= { FOLLOW_BVSGE_TOK_in_bvTerm7175_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7177  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7177_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7177	= { FOLLOW_LPAREN_in_bvTerm7177_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7179  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7179_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7179	= { FOLLOW_formula_in_bvTerm7179_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7182  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7182_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7182	= { FOLLOW_COMMA_in_bvTerm7182_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7184  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7184	= { FOLLOW_formula_in_bvTerm7184_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7187  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7187	= { FOLLOW_RPAREN_in_bvTerm7187_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stringTerm_in_bvTerm7199  */
static	ANTLR3_BITWORD FOLLOW_stringTerm_in_bvTerm7199_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stringTerm_in_bvTerm7199	= { FOLLOW_stringTerm_in_bvTerm7199_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CONCAT_TOK_in_stringTerm7225  */
static	ANTLR3_BITWORD FOLLOW_STRING_CONCAT_TOK_in_stringTerm7225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CONCAT_TOK_in_stringTerm7225	= { FOLLOW_STRING_CONCAT_TOK_in_stringTerm7225_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7227  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7227_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7227	= { FOLLOW_LPAREN_in_stringTerm7227_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7229  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7229_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7229	= { FOLLOW_formula_in_stringTerm7229_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7240  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7240_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7240	= { FOLLOW_COMMA_in_stringTerm7240_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7242  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7242_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7242	= { FOLLOW_formula_in_stringTerm7242_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7250  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7250_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7250	= { FOLLOW_RPAREN_in_stringTerm7250_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LENGTH_TOK_in_stringTerm7262  */
static	ANTLR3_BITWORD FOLLOW_STRING_LENGTH_TOK_in_stringTerm7262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LENGTH_TOK_in_stringTerm7262	= { FOLLOW_STRING_LENGTH_TOK_in_stringTerm7262_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7264  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7264_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7264	= { FOLLOW_LPAREN_in_stringTerm7264_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7266  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7266_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7266	= { FOLLOW_formula_in_stringTerm7266_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7269  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7269	= { FOLLOW_RPAREN_in_stringTerm7269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7281  */
static	ANTLR3_BITWORD FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7281	= { FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7281_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7283  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7283_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7283	= { FOLLOW_LPAREN_in_stringTerm7283_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7285  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7285_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7285	= { FOLLOW_formula_in_stringTerm7285_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7288  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7288_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7288	= { FOLLOW_COMMA_in_stringTerm7288_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7290  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7290_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7290	= { FOLLOW_formula_in_stringTerm7290_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7293  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7293_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7293	= { FOLLOW_RPAREN_in_stringTerm7293_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7305  */
static	ANTLR3_BITWORD FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7305	= { FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7305_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7307  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7307_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7307	= { FOLLOW_LPAREN_in_stringTerm7307_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7309  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7309_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7309	= { FOLLOW_formula_in_stringTerm7309_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7312  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7312_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7312	= { FOLLOW_COMMA_in_stringTerm7312_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7314  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7314_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7314	= { FOLLOW_formula_in_stringTerm7314_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7317  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7317_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7317	= { FOLLOW_COMMA_in_stringTerm7317_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7319  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7319	= { FOLLOW_formula_in_stringTerm7319_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7322  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7322	= { FOLLOW_RPAREN_in_stringTerm7322_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CHARAT_TOK_in_stringTerm7334  */
static	ANTLR3_BITWORD FOLLOW_STRING_CHARAT_TOK_in_stringTerm7334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CHARAT_TOK_in_stringTerm7334	= { FOLLOW_STRING_CHARAT_TOK_in_stringTerm7334_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7336  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7336_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7336	= { FOLLOW_LPAREN_in_stringTerm7336_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7338  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7338_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7338	= { FOLLOW_formula_in_stringTerm7338_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7341  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7341_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7341	= { FOLLOW_COMMA_in_stringTerm7341_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7343  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7343_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7343	= { FOLLOW_formula_in_stringTerm7343_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7346  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7346	= { FOLLOW_RPAREN_in_stringTerm7346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7358  */
static	ANTLR3_BITWORD FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7358	= { FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7358_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7360  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7360_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7360	= { FOLLOW_LPAREN_in_stringTerm7360_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7362  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7362_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7362	= { FOLLOW_formula_in_stringTerm7362_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7365  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7365_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7365	= { FOLLOW_COMMA_in_stringTerm7365_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7367  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7367_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7367	= { FOLLOW_formula_in_stringTerm7367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7370  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7370_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7370	= { FOLLOW_COMMA_in_stringTerm7370_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7372  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7372	= { FOLLOW_formula_in_stringTerm7372_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7375  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7375_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7375	= { FOLLOW_RPAREN_in_stringTerm7375_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_REPLACE_TOK_in_stringTerm7387  */
static	ANTLR3_BITWORD FOLLOW_STRING_REPLACE_TOK_in_stringTerm7387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_REPLACE_TOK_in_stringTerm7387	= { FOLLOW_STRING_REPLACE_TOK_in_stringTerm7387_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7389  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7389_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7389	= { FOLLOW_LPAREN_in_stringTerm7389_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7391  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7391_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7391	= { FOLLOW_formula_in_stringTerm7391_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7394  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7394_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7394	= { FOLLOW_COMMA_in_stringTerm7394_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7396  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7396_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7396	= { FOLLOW_formula_in_stringTerm7396_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7399  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7399_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7399	= { FOLLOW_COMMA_in_stringTerm7399_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7401  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7401_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7401	= { FOLLOW_formula_in_stringTerm7401_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7404  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7404_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7404	= { FOLLOW_RPAREN_in_stringTerm7404_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_REPLACE_ALL_TOK_in_stringTerm7416  */
static	ANTLR3_BITWORD FOLLOW_STRING_REPLACE_ALL_TOK_in_stringTerm7416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_REPLACE_ALL_TOK_in_stringTerm7416	= { FOLLOW_STRING_REPLACE_ALL_TOK_in_stringTerm7416_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7418  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7418_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7418	= { FOLLOW_LPAREN_in_stringTerm7418_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7420  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7420_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7420	= { FOLLOW_formula_in_stringTerm7420_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7423  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7423_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7423	= { FOLLOW_COMMA_in_stringTerm7423_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7425  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7425_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7425	= { FOLLOW_formula_in_stringTerm7425_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7428  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7428_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7428	= { FOLLOW_COMMA_in_stringTerm7428_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7430  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7430	= { FOLLOW_formula_in_stringTerm7430_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7433  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7433_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7433	= { FOLLOW_RPAREN_in_stringTerm7433_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7445  */
static	ANTLR3_BITWORD FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7445_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7445	= { FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7445_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7447  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7447_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7447	= { FOLLOW_LPAREN_in_stringTerm7447_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7449  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7449_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7449	= { FOLLOW_formula_in_stringTerm7449_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7452  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7452_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7452	= { FOLLOW_COMMA_in_stringTerm7452_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7454  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7454	= { FOLLOW_formula_in_stringTerm7454_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7457  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7457	= { FOLLOW_RPAREN_in_stringTerm7457_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7469  */
static	ANTLR3_BITWORD FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7469_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7469	= { FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7469_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7471  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7471_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7471	= { FOLLOW_LPAREN_in_stringTerm7471_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7473  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7473_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7473	= { FOLLOW_formula_in_stringTerm7473_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7476  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7476_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7476	= { FOLLOW_COMMA_in_stringTerm7476_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7478  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7478	= { FOLLOW_formula_in_stringTerm7478_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7481  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7481	= { FOLLOW_RPAREN_in_stringTerm7481_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_STOI_TOK_in_stringTerm7493  */
static	ANTLR3_BITWORD FOLLOW_STRING_STOI_TOK_in_stringTerm7493_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_STOI_TOK_in_stringTerm7493	= { FOLLOW_STRING_STOI_TOK_in_stringTerm7493_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7495  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7495_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7495	= { FOLLOW_LPAREN_in_stringTerm7495_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7497  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7497	= { FOLLOW_formula_in_stringTerm7497_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7500  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7500_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7500	= { FOLLOW_RPAREN_in_stringTerm7500_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_ITOS_TOK_in_stringTerm7512  */
static	ANTLR3_BITWORD FOLLOW_STRING_ITOS_TOK_in_stringTerm7512_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_ITOS_TOK_in_stringTerm7512	= { FOLLOW_STRING_ITOS_TOK_in_stringTerm7512_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7514  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7514_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7514	= { FOLLOW_LPAREN_in_stringTerm7514_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7516  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7516	= { FOLLOW_formula_in_stringTerm7516_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7519  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7519_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7519	= { FOLLOW_RPAREN_in_stringTerm7519_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TO_REGEXP_TOK_in_stringTerm7531  */
static	ANTLR3_BITWORD FOLLOW_STRING_TO_REGEXP_TOK_in_stringTerm7531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TO_REGEXP_TOK_in_stringTerm7531	= { FOLLOW_STRING_TO_REGEXP_TOK_in_stringTerm7531_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7533  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7533_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7533	= { FOLLOW_LPAREN_in_stringTerm7533_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7535  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7535_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7535	= { FOLLOW_formula_in_stringTerm7535_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7538  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7538	= { FOLLOW_RPAREN_in_stringTerm7538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TOLOWER_TOK_in_stringTerm7550  */
static	ANTLR3_BITWORD FOLLOW_STRING_TOLOWER_TOK_in_stringTerm7550_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TOLOWER_TOK_in_stringTerm7550	= { FOLLOW_STRING_TOLOWER_TOK_in_stringTerm7550_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7552  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7552_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7552	= { FOLLOW_LPAREN_in_stringTerm7552_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7554  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7554_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7554	= { FOLLOW_formula_in_stringTerm7554_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7557  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7557_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7557	= { FOLLOW_RPAREN_in_stringTerm7557_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TOUPPER_TOK_in_stringTerm7569  */
static	ANTLR3_BITWORD FOLLOW_STRING_TOUPPER_TOK_in_stringTerm7569_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TOUPPER_TOK_in_stringTerm7569	= { FOLLOW_STRING_TOUPPER_TOK_in_stringTerm7569_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7571  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7571_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7571	= { FOLLOW_LPAREN_in_stringTerm7571_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7573  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7573	= { FOLLOW_formula_in_stringTerm7573_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7576  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7576_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7576	= { FOLLOW_RPAREN_in_stringTerm7576_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_REV_TOK_in_stringTerm7588  */
static	ANTLR3_BITWORD FOLLOW_STRING_REV_TOK_in_stringTerm7588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_REV_TOK_in_stringTerm7588	= { FOLLOW_STRING_REV_TOK_in_stringTerm7588_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7590  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7590_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7590	= { FOLLOW_LPAREN_in_stringTerm7590_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7592  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7592	= { FOLLOW_formula_in_stringTerm7592_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7595  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7595	= { FOLLOW_RPAREN_in_stringTerm7595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_CONCAT_TOK_in_stringTerm7607  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_CONCAT_TOK_in_stringTerm7607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_CONCAT_TOK_in_stringTerm7607	= { FOLLOW_REGEXP_CONCAT_TOK_in_stringTerm7607_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7609  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7609_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7609	= { FOLLOW_LPAREN_in_stringTerm7609_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7611  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7611_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7611	= { FOLLOW_formula_in_stringTerm7611_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7622  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7622_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7622	= { FOLLOW_COMMA_in_stringTerm7622_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7624  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7624_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7624	= { FOLLOW_formula_in_stringTerm7624_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7632  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7632_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7632	= { FOLLOW_RPAREN_in_stringTerm7632_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_UNION_TOK_in_stringTerm7644  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_UNION_TOK_in_stringTerm7644_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_UNION_TOK_in_stringTerm7644	= { FOLLOW_REGEXP_UNION_TOK_in_stringTerm7644_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7646  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7646_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7646	= { FOLLOW_LPAREN_in_stringTerm7646_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7648  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7648_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7648	= { FOLLOW_formula_in_stringTerm7648_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7659  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7659_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7659	= { FOLLOW_COMMA_in_stringTerm7659_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7661  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7661_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7661	= { FOLLOW_formula_in_stringTerm7661_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7669  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7669	= { FOLLOW_RPAREN_in_stringTerm7669_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_INTER_TOK_in_stringTerm7681  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_INTER_TOK_in_stringTerm7681_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_INTER_TOK_in_stringTerm7681	= { FOLLOW_REGEXP_INTER_TOK_in_stringTerm7681_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7683  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7683_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7683	= { FOLLOW_LPAREN_in_stringTerm7683_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7685  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7685_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7685	= { FOLLOW_formula_in_stringTerm7685_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7696  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7696_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7696	= { FOLLOW_COMMA_in_stringTerm7696_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7698  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7698_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7698	= { FOLLOW_formula_in_stringTerm7698_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7706  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7706_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7706	= { FOLLOW_RPAREN_in_stringTerm7706_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_STAR_TOK_in_stringTerm7718  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_STAR_TOK_in_stringTerm7718_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_STAR_TOK_in_stringTerm7718	= { FOLLOW_REGEXP_STAR_TOK_in_stringTerm7718_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7720  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7720_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7720	= { FOLLOW_LPAREN_in_stringTerm7720_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7722  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7722_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7722	= { FOLLOW_formula_in_stringTerm7722_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7725  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7725_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7725	= { FOLLOW_RPAREN_in_stringTerm7725_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_PLUS_TOK_in_stringTerm7737  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_PLUS_TOK_in_stringTerm7737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_PLUS_TOK_in_stringTerm7737	= { FOLLOW_REGEXP_PLUS_TOK_in_stringTerm7737_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7739  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7739_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7739	= { FOLLOW_LPAREN_in_stringTerm7739_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7741  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7741_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7741	= { FOLLOW_formula_in_stringTerm7741_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7744  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7744_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7744	= { FOLLOW_RPAREN_in_stringTerm7744_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_OPT_TOK_in_stringTerm7756  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_OPT_TOK_in_stringTerm7756_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_OPT_TOK_in_stringTerm7756	= { FOLLOW_REGEXP_OPT_TOK_in_stringTerm7756_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7758  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7758_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7758	= { FOLLOW_LPAREN_in_stringTerm7758_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7760  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7760	= { FOLLOW_formula_in_stringTerm7760_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7763  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7763	= { FOLLOW_RPAREN_in_stringTerm7763_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_RANGE_TOK_in_stringTerm7775  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_RANGE_TOK_in_stringTerm7775_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_RANGE_TOK_in_stringTerm7775	= { FOLLOW_REGEXP_RANGE_TOK_in_stringTerm7775_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7777  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7777_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7777	= { FOLLOW_LPAREN_in_stringTerm7777_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7779  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7779_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7779	= { FOLLOW_formula_in_stringTerm7779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7782  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7782_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7782	= { FOLLOW_COMMA_in_stringTerm7782_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7784  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7784_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7784	= { FOLLOW_formula_in_stringTerm7784_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7787  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7787_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7787	= { FOLLOW_RPAREN_in_stringTerm7787_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_LOOP_TOK_in_stringTerm7799  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_LOOP_TOK_in_stringTerm7799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_LOOP_TOK_in_stringTerm7799	= { FOLLOW_REGEXP_LOOP_TOK_in_stringTerm7799_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7801  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7801_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7801	= { FOLLOW_LPAREN_in_stringTerm7801_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7803  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7803_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7803	= { FOLLOW_formula_in_stringTerm7803_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7806  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7806_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7806	= { FOLLOW_COMMA_in_stringTerm7806_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_stringTerm7810  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_stringTerm7810_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_stringTerm7810	= { FOLLOW_numeral_in_stringTerm7810_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7812  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7812	= { FOLLOW_COMMA_in_stringTerm7812_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_stringTerm7816  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_stringTerm7816_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_stringTerm7816	= { FOLLOW_numeral_in_stringTerm7816_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7818  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7818_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7818	= { FOLLOW_RPAREN_in_stringTerm7818_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_COMPLEMENT_TOK_in_stringTerm7830  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_COMPLEMENT_TOK_in_stringTerm7830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_COMPLEMENT_TOK_in_stringTerm7830	= { FOLLOW_REGEXP_COMPLEMENT_TOK_in_stringTerm7830_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7832  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7832_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7832	= { FOLLOW_LPAREN_in_stringTerm7832_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7834  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7834	= { FOLLOW_formula_in_stringTerm7834_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7837  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7837	= { FOLLOW_RPAREN_in_stringTerm7837_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_EMPTY_TOK_in_stringTerm7849  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_EMPTY_TOK_in_stringTerm7849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_EMPTY_TOK_in_stringTerm7849	= { FOLLOW_REGEXP_EMPTY_TOK_in_stringTerm7849_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REGEXP_SIGMA_TOK_in_stringTerm7861  */
static	ANTLR3_BITWORD FOLLOW_REGEXP_SIGMA_TOK_in_stringTerm7861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REGEXP_SIGMA_TOK_in_stringTerm7861	= { FOLLOW_REGEXP_SIGMA_TOK_in_stringTerm7861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_stringTerm7880  */
static	ANTLR3_BITWORD FOLLOW_str_in_stringTerm7880_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_stringTerm7880	= { FOLLOW_str_in_stringTerm7880_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setsTerm_in_stringTerm7894  */
static	ANTLR3_BITWORD FOLLOW_setsTerm_in_stringTerm7894_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setsTerm_in_stringTerm7894	= { FOLLOW_setsTerm_in_stringTerm7894_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SETS_CARD_TOK_in_setsTerm7920  */
static	ANTLR3_BITWORD FOLLOW_SETS_CARD_TOK_in_setsTerm7920_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SETS_CARD_TOK_in_setsTerm7920	= { FOLLOW_SETS_CARD_TOK_in_setsTerm7920_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_setsTerm7922  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_setsTerm7922_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_setsTerm7922	= { FOLLOW_LPAREN_in_setsTerm7922_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_setsTerm7924  */
static	ANTLR3_BITWORD FOLLOW_formula_in_setsTerm7924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_setsTerm7924	= { FOLLOW_formula_in_setsTerm7924_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_setsTerm7927  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_setsTerm7927_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_setsTerm7927	= { FOLLOW_RPAREN_in_setsTerm7927_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SETS_CHOOSE_TOK_in_setsTerm7939  */
static	ANTLR3_BITWORD FOLLOW_SETS_CHOOSE_TOK_in_setsTerm7939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SETS_CHOOSE_TOK_in_setsTerm7939	= { FOLLOW_SETS_CHOOSE_TOK_in_setsTerm7939_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_setsTerm7941  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_setsTerm7941_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_setsTerm7941	= { FOLLOW_LPAREN_in_setsTerm7941_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_setsTerm7943  */
static	ANTLR3_BITWORD FOLLOW_formula_in_setsTerm7943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_setsTerm7943	= { FOLLOW_formula_in_setsTerm7943_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_setsTerm7946  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_setsTerm7946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_setsTerm7946	= { FOLLOW_RPAREN_in_setsTerm7946_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_setsTerm7962  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_setsTerm7962_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_setsTerm7962	= { FOLLOW_simpleTerm_in_setsTerm7962_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteTerm_in_simpleTerm7991  */
static	ANTLR3_BITWORD FOLLOW_iteTerm_in_simpleTerm7991_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteTerm_in_simpleTerm7991	= { FOLLOW_iteTerm_in_simpleTerm7991_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm8005  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm8005_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm8005	= { FOLLOW_LPAREN_in_simpleTerm8005_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm8007  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm8007_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm8007	= { FOLLOW_formula_in_simpleTerm8007_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm8018  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm8018_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm8018	= { FOLLOW_COMMA_in_simpleTerm8018_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm8020  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm8020_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm8020	= { FOLLOW_formula_in_simpleTerm8020_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm8028  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm8028_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm8028	= { FOLLOW_RPAREN_in_simpleTerm8028_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm8047  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm8047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm8047	= { FOLLOW_LPAREN_in_simpleTerm8047_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm8049  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm8049_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm8049	= { FOLLOW_RPAREN_in_simpleTerm8049_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm8068  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm8068_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm8068	= { FOLLOW_PARENHASH_in_simpleTerm8068_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm8070  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm8070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm8070	= { FOLLOW_HASHPAREN_in_simpleTerm8070_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm8088  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm8088_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm8088	= { FOLLOW_LBRACE_in_simpleTerm8088_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm8090  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm8090_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm8090	= { FOLLOW_RBRACE_in_simpleTerm8090_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNIVSET_TOK_in_simpleTerm8102  */
static	ANTLR3_BITWORD FOLLOW_UNIVSET_TOK_in_simpleTerm8102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNIVSET_TOK_in_simpleTerm8102	= { FOLLOW_UNIVSET_TOK_in_simpleTerm8102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm8121  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm8121_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm8121	= { FOLLOW_LBRACE_in_simpleTerm8121_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm8123  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm8123_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm8123	= { FOLLOW_formula_in_simpleTerm8123_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm8134  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm8134_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm8134	= { FOLLOW_COMMA_in_simpleTerm8134_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm8136  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm8136_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm8136	= { FOLLOW_formula_in_simpleTerm8136_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm8144  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm8144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm8144	= { FOLLOW_RBRACE_in_simpleTerm8144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm8163  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm8163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm8163	= { FOLLOW_BAR_in_simpleTerm8163_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm8165  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm8165_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm8165	= { FOLLOW_BAR_in_simpleTerm8165_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm8167  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm8167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm8167	= { FOLLOW_formula_in_simpleTerm8167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm8172  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm8172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm8172	= { FOLLOW_BAR_in_simpleTerm8172_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm8174  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm8174_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm8174	= { FOLLOW_BAR_in_simpleTerm8174_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_simpleTerm8193  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_simpleTerm8193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_simpleTerm8193	= { FOLLOW_ARRAY_TOK_in_simpleTerm8193_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm8197  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm8197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm8197	= { FOLLOW_LPAREN_in_simpleTerm8197_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_simpleTerm8203  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_simpleTerm8203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_simpleTerm8203	= { FOLLOW_restrictedType_in_simpleTerm8203_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_simpleTerm8206  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_simpleTerm8206_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_simpleTerm8206	= { FOLLOW_OF_TOK_in_simpleTerm8206_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_simpleTerm8208  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_simpleTerm8208_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_simpleTerm8208	= { FOLLOW_restrictedType_in_simpleTerm8208_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm8215  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm8215_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm8215	= { FOLLOW_RPAREN_in_simpleTerm8215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_simpleTerm8217  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_simpleTerm8217_bits[]	= { ANTLR3_UINT64_LIT(0x400000000000C100), ANTLR3_UINT64_LIT(0x1081130002000000), ANTLR3_UINT64_LIT(0x0000000000000040), ANTLR3_UINT64_LIT(0x0000000000000440) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_simpleTerm8217	= { FOLLOW_COLON_in_simpleTerm8217_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_simpleTerm8219  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_simpleTerm8219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_simpleTerm8219	= { FOLLOW_simpleTerm_in_simpleTerm8219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_simpleTerm8239  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_simpleTerm8239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_simpleTerm8239	= { FOLLOW_TRUE_TOK_in_simpleTerm8239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_simpleTerm8248  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_simpleTerm8248_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_simpleTerm8248	= { FOLLOW_FALSE_TOK_in_simpleTerm8248_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleTerm8268  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleTerm8268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleTerm8268	= { FOLLOW_DECIMAL_LITERAL_in_simpleTerm8268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleTerm8276  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleTerm8276_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleTerm8276	= { FOLLOW_INTEGER_LITERAL_in_simpleTerm8276_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleTerm8290  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleTerm8290_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleTerm8290	= { FOLLOW_HEX_LITERAL_in_simpleTerm8290_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleTerm8302  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleTerm8302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleTerm8302	= { FOLLOW_BINARY_LITERAL_in_simpleTerm8302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm8320  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm8320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm8320	= { FOLLOW_PARENHASH_in_simpleTerm8320_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm8322  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm8322_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm8322	= { FOLLOW_recordEntry_in_simpleTerm8322_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm8333  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm8333_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm8333	= { FOLLOW_COMMA_in_simpleTerm8333_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm8335  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm8335_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm8335	= { FOLLOW_recordEntry_in_simpleTerm8335_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm8343  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm8343_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm8343	= { FOLLOW_HASHPAREN_in_simpleTerm8343_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_simpleTerm8362  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_simpleTerm8362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_simpleTerm8362	= { FOLLOW_identifier_in_simpleTerm8362_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription8396  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription8396_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription8396	= { FOLLOW_COLON_in_typeAscription8396_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription8398  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription8398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription8398	= { FOLLOW_COLON_in_typeAscription8398_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_typeAscription8400  */
static	ANTLR3_BITWORD FOLLOW_type_in_typeAscription8400_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_typeAscription8400	= { FOLLOW_type_in_typeAscription8400_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordEntry8417  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordEntry8417_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordEntry8417	= { FOLLOW_identifier_in_recordEntry8417_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordEntry8420  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordEntry8420_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordEntry8420	= { FOLLOW_ASSIGN_TOK_in_recordEntry8420_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_recordEntry8422  */
static	ANTLR3_BITWORD FOLLOW_formula_in_recordEntry8422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_recordEntry8422	= { FOLLOW_formula_in_recordEntry8422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IF_TOK_in_iteTerm8444  */
static	ANTLR3_BITWORD FOLLOW_IF_TOK_in_iteTerm8444_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_IF_TOK_in_iteTerm8444	= { FOLLOW_IF_TOK_in_iteTerm8444_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm8446  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm8446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm8446	= { FOLLOW_formula_in_iteTerm8446_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteTerm8455  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteTerm8455_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteTerm8455	= { FOLLOW_THEN_TOK_in_iteTerm8455_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm8457  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm8457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000030000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm8457	= { FOLLOW_formula_in_iteTerm8457_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteTerm8466  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteTerm8466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteTerm8466	= { FOLLOW_iteElseTerm_in_iteTerm8466_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENDIF_TOK_in_iteTerm8475  */
static	ANTLR3_BITWORD FOLLOW_ENDIF_TOK_in_iteTerm8475_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENDIF_TOK_in_iteTerm8475	= { FOLLOW_ENDIF_TOK_in_iteTerm8475_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSE_TOK_in_iteElseTerm8502  */
static	ANTLR3_BITWORD FOLLOW_ELSE_TOK_in_iteElseTerm8502_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSE_TOK_in_iteElseTerm8502	= { FOLLOW_ELSE_TOK_in_iteElseTerm8502_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8504  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8504	= { FOLLOW_formula_in_iteElseTerm8504_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSEIF_TOK_in_iteElseTerm8511  */
static	ANTLR3_BITWORD FOLLOW_ELSEIF_TOK_in_iteElseTerm8511_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSEIF_TOK_in_iteElseTerm8511	= { FOLLOW_ELSEIF_TOK_in_iteElseTerm8511_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8517  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8517_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8517	= { FOLLOW_formula_in_iteElseTerm8517_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteElseTerm8526  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteElseTerm8526_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x3BFFF183FF800042), ANTLR3_UINT64_LIT(0x00000000000004E9) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteElseTerm8526	= { FOLLOW_THEN_TOK_in_iteElseTerm8526_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8532  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8532_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000030000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8532	= { FOLLOW_formula_in_iteElseTerm8532_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteElseTerm8545  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteElseTerm8545_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteElseTerm8545	= { FOLLOW_iteElseTerm_in_iteElseTerm8545_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8581  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8581_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8581	= { FOLLOW_identifier_in_datatypeDef8581_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_datatypeDef8592  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_datatypeDef8592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_datatypeDef8592	= { FOLLOW_LBRACKET_in_datatypeDef8592_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8594  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8594_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8594	= { FOLLOW_identifier_in_datatypeDef8594_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_datatypeDef8607  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_datatypeDef8607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_datatypeDef8607	= { FOLLOW_COMMA_in_datatypeDef8607_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8609  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8609_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8609	= { FOLLOW_identifier_in_datatypeDef8609_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_datatypeDef8623  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_datatypeDef8623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_datatypeDef8623	= { FOLLOW_RBRACKET_in_datatypeDef8623_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_datatypeDef8642  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_datatypeDef8642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_datatypeDef8642	= { FOLLOW_EQUAL_TOK_in_datatypeDef8642_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef8644  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef8644_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef8644	= { FOLLOW_constructorDef_in_datatypeDef8644_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_datatypeDef8653  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_datatypeDef8653_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_datatypeDef8653	= { FOLLOW_BAR_in_datatypeDef8653_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef8655  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef8655_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef8655	= { FOLLOW_constructorDef_in_datatypeDef8655_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_constructorDef8686  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_constructorDef8686_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_constructorDef8686	= { FOLLOW_identifier_in_constructorDef8686_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_constructorDef8701  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_constructorDef8701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_constructorDef8701	= { FOLLOW_LPAREN_in_constructorDef8701_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef8709  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef8709_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef8709	= { FOLLOW_selector_in_constructorDef8709_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_constructorDef8720  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_constructorDef8720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_constructorDef8720	= { FOLLOW_COMMA_in_constructorDef8720_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef8722  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef8722_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef8722	= { FOLLOW_selector_in_constructorDef8722_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_constructorDef8734  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_constructorDef8734_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_constructorDef8734	= { FOLLOW_RPAREN_in_constructorDef8734_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_selector8766  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_selector8766_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_selector8766	= { FOLLOW_identifier_in_selector8766_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_selector8769  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_selector8769_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x8400060000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_selector8769	= { FOLLOW_COLON_in_selector8769_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_selector8771  */
static	ANTLR3_BITWORD FOLLOW_type_in_selector8771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_selector8771	= { FOLLOW_type_in_selector8771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_numeral8846  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_numeral8846_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_numeral8846	= { FOLLOW_INTEGER_LITERAL_in_numeral8846_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer8871  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer8871_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer8871	= { FOLLOW_INTEGER_LITERAL_in_integer8871_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_integer8883  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_integer8883_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_integer8883	= { FOLLOW_MINUS_TOK_in_integer8883_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer8885  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer8885_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer8885	= { FOLLOW_INTEGER_LITERAL_in_integer8885_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_in_str8907  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_in_str8907_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_in_str8907	= { FOLLOW_STRING_LITERAL_in_str8907_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_synpred1_Cvc2097  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_synpred1_Cvc2097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_synpred1_Cvc2097	= { FOLLOW_letDecl_in_synpred1_Cvc2097_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:618:1: parseExpr returns [CVC4::api::Term expr = CVC4::api::Term()] : ( formula[expr] | EOF );
 */
static CVC4::api::Term
parseExpr(pCvcParser ctx)
{
    CVC4::api::Term expr;


    /* Initialize rule variables
     */
    expr =  CVC4::api::Term();


    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:619:3: ( formula[expr] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case EXISTS_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case FORALL_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LAMBDA_TOK:
            case LBRACE:
            case LET_TOK:
            case LPAREN:
            case MINUS_TOK:
            case NOT_TOK:
            case PARENHASH:
            case REGEXP_COMPLEMENT_TOK:
            case REGEXP_CONCAT_TOK:
            case REGEXP_EMPTY_TOK:
            case REGEXP_INTER_TOK:
            case REGEXP_LOOP_TOK:
            case REGEXP_OPT_TOK:
            case REGEXP_PLUS_TOK:
            case REGEXP_RANGE_TOK:
            case REGEXP_SIGMA_TOK:
            case REGEXP_STAR_TOK:
            case REGEXP_UNION_TOK:
            case SETS_CARD_TOK:
            case SETS_CHOOSE_TOK:
            case STRING_CHARAT_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_ALL_TOK:
            case STRING_REPLACE_TOK:
            case STRING_REV_TOK:
            case STRING_STOI_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_TOLOWER_TOK:
            case STRING_TOUPPER_TOK:
            case STRING_TO_REGEXP_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return expr;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:619:5: formula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_formula_in_parseExpr1899);
        	        formula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:620:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr1906);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:627:1: parseCommand returns [CVC4::Command* cmd_return = NULL] : (c= command[&cmd] | LPAREN IDENTIFIER | EOF );
 */
static CVC4::Command*
parseCommand(pCvcParser ctx)
{
    CVC4::Command* cmd_return;



        std::unique_ptr<CVC4::Command> cmd;

    pANTLR3_COMMON_TOKEN    IDENTIFIER1;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    IDENTIFIER1       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:634:3: (c= command[&cmd] | LPAREN IDENTIFIER | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case CONTINUE_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case DUMP_UNSAT_CORE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case IDENTIFIER:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RECURSIVE_FUNCTION_TOK:
            case RESET_TOK:
            case RESTART_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt2=1;
            	}
                break;
            case LPAREN:
            	{
            		alt2=2;
            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return cmd_return;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:634:5: c= command[&cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand1937);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:635:5: LPAREN IDENTIFIER
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_parseCommand1944);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	        IDENTIFIER1 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_parseCommand1946);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::string s = AntlrInput::tokenText(IDENTIFIER1);
        	                if(s == "benchmark") {
        	                    PARSER_STATE->parseError(
        	                        "In CVC4 presentation language mode, but SMT-LIBv1 format "
        	                        "detected, which is not supported anymore.");
        	                  } else if(s == "set" || s == "get" || s == "declare" ||
        	                            s == "define" || s == "assert") {
        	                    PARSER_STATE->parseError(
        	                        "In CVC4 presentation language mode, but SMT-LIB format detected. "
        	                        "Use --lang smt for SMT-LIB support.");
        	                  } else {
        	                    PARSER_STATE->parseError(
        	                        "A CVC4 presentation language command cannot begin with a "
        	                        "parenthesis; expected command name.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:652:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand1958);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                        cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start command
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:659:1: command[std::unique_ptr<CVC4::Command>* cmd] : ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] ) | IDENTIFIER SEMICOLON );
 */
static void
command(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER2;

    /* Initialize rule variables
     */

    IDENTIFIER2       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:660:3: ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] ) | IDENTIFIER SEMICOLON )

            ANTLR3_UINT32 alt5;

            alt5=2;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case CONTINUE_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case DUMP_UNSAT_CORE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RECURSIVE_FUNCTION_TOK:
            case RESET_TOK:
            case RESTART_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt5=1;
            	}
                break;
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case SEMICOLON:
            			{
            				alt5=2;
            			}
            		    break;
            		case COLON:
            		case COMMA:
            			{
            				alt5=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 5;
            		    EXCEPTION->state        = 42;


            		    goto rulecommandEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt5)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:660:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] )
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:660:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] )
        	        {
        	            int alt4=3;
        	            switch ( LA(1) )
        	            {
        	            case ARITH_VAR_ORDER_TOK:
        	            case ASSERTIONS_TOK:
        	            case ASSERT_TOK:
        	            case ASSUMPTIONS_TOK:
        	            case CALL_TOK:
        	            case CHECKSAT_TOK:
        	            case CHECK_TYPE_TOK:
        	            case CONTEXT_TOK:
        	            case CONTINUE_TOK:
        	            case COUNTEREXAMPLE_TOK:
        	            case COUNTERMODEL_TOK:
        	            case DATATYPE_TOK:
        	            case DBG_TOK:
        	            case DUMP_ASSUMPTIONS_TOK:
        	            case DUMP_CLOSURE_PROOF_TOK:
        	            case DUMP_CLOSURE_TOK:
        	            case DUMP_PROOF_TOK:
        	            case DUMP_SIG_TOK:
        	            case DUMP_TCC_ASSUMPTIONS_TOK:
        	            case DUMP_TCC_PROOF_TOK:
        	            case DUMP_TCC_TOK:
        	            case DUMP_UNSAT_CORE_TOK:
        	            case ECHO_TOK:
        	            case EXIT_TOK:
        	            case FORGET_TOK:
        	            case GET_CHILD_TOK:
        	            case GET_OP_TOK:
        	            case GET_TYPE_TOK:
        	            case GET_VALUE_TOK:
        	            case HELP_TOK:
        	            case IDENTIFIER:
        	            case INCLUDE_TOK:
        	            case OPTION_TOK:
        	            case POPTO_SCOPE_TOK:
        	            case POPTO_TOK:
        	            case POP_SCOPE_TOK:
        	            case POP_TOK:
        	            case PRINT_TOK:
        	            case PRINT_TYPE_TOK:
        	            case PUSH_SCOPE_TOK:
        	            case PUSH_TOK:
        	            case QUERY_TOK:
        	            case RECURSIVE_FUNCTION_TOK:
        	            case RESET_TOK:
        	            case RESTART_TOK:
        	            case SUBSTITUTE_TOK:
        	            case TRACE_TOK:
        	            case TRANSFORM_TOK:
        	            case UNTRACE_TOK:
        	            case WHERE_TOK:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;
        	            case LET_TOK:
        	            	{
        	            		alt4=3;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:660:7: mainCommand[cmd] SEMICOLON
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_mainCommand_in_command1977);
        	        	        mainCommand(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1980);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:661:7: SEMICOLON
        	        	    {
        	        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1988);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:662:7: LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd]
        	        	    {
        	        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_command1996);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->pushScope(); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command2006);
        	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:663:40: ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt3=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt3=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt3)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:664:11: COMMA typeOrVarLetDecl[CHECK_DECLARED]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_command2021);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulecommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command2023);
        	        	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulecommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop3;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop3: ; /* Jump out to here if this rule does not match */


        	        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_command2035);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_command_in_command2037);
        	        	        command(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->popScope(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(!(*cmd)) {
        	                    cmd->reset(new EmptyCommand());
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:672:5: IDENTIFIER SEMICOLON
        	    {
        	        IDENTIFIER2 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_command2064);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command2066);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::stringstream ss;
        	                  ss << "Unrecognized command `"
        	                     << AntlrInput::tokenText(IDENTIFIER2)
        	                     << "'";
        	                  PARSER_STATE->parseError(ss.str());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end command */

/**
 * $ANTLR start typeOrVarLetDecl
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:681:1: typeOrVarLetDecl[CVC4::parser::DeclarationCheck check] options {backtrack=true; } : ( letDecl | typeLetDecl[check] );
 */
static void
typeOrVarLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:683:3: ( letDecl | typeLetDecl[check] )

            ANTLR3_UINT32 alt6;

            alt6=2;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				switch ( LA(3) )
            				{
            				case ABS_TOK:
            				case BAR:
            				case BINARY_LITERAL:
            				case BVASHR_TOK:
            				case BVCOMP_TOK:
            				case BVGE_TOK:
            				case BVGT_TOK:
            				case BVLE_TOK:
            				case BVLSHR_TOK:
            				case BVLT_TOK:
            				case BVMULT_TOK:
            				case BVNAND_TOK:
            				case BVNEG_TOK:
            				case BVNOR_TOK:
            				case BVPLUS_TOK:
            				case BVREPEAT_TOK:
            				case BVROTL_TOK:
            				case BVROTR_TOK:
            				case BVSDIV_TOK:
            				case BVSGE_TOK:
            				case BVSGT_TOK:
            				case BVSHL_TOK:
            				case BVSLE_TOK:
            				case BVSLT_TOK:
            				case BVSMOD_TOK:
            				case BVSREM_TOK:
            				case BVSUB_TOK:
            				case BVUDIV_TOK:
            				case BVUMINUS_TOK:
            				case BVUREM_TOK:
            				case BVXNOR_TOK:
            				case BVXOR_TOK:
            				case BVZEROEXTEND_TOK:
            				case DECIMAL_LITERAL:
            				case DISTINCT_TOK:
            				case DIVISIBLE_TOK:
            				case EXISTS_TOK:
            				case FALSE_TOK:
            				case FLOOR_TOK:
            				case FORALL_TOK:
            				case HEX_LITERAL:
            				case IDEN_TOK:
            				case IF_TOK:
            				case INTEGER_LITERAL:
            				case IS_INTEGER_TOK:
            				case LAMBDA_TOK:
            				case LBRACE:
            				case LET_TOK:
            				case MINUS_TOK:
            				case NOT_TOK:
            				case PARENHASH:
            				case REGEXP_COMPLEMENT_TOK:
            				case REGEXP_CONCAT_TOK:
            				case REGEXP_EMPTY_TOK:
            				case REGEXP_INTER_TOK:
            				case REGEXP_LOOP_TOK:
            				case REGEXP_OPT_TOK:
            				case REGEXP_PLUS_TOK:
            				case REGEXP_RANGE_TOK:
            				case REGEXP_SIGMA_TOK:
            				case REGEXP_STAR_TOK:
            				case REGEXP_UNION_TOK:
            				case SETS_CARD_TOK:
            				case SETS_CHOOSE_TOK:
            				case STRING_CHARAT_TOK:
            				case STRING_CONCAT_TOK:
            				case STRING_CONTAINS_TOK:
            				case STRING_INDEXOF_TOK:
            				case STRING_ITOS_TOK:
            				case STRING_LENGTH_TOK:
            				case STRING_LITERAL:
            				case STRING_PREFIXOF_TOK:
            				case STRING_REPLACE_ALL_TOK:
            				case STRING_REPLACE_TOK:
            				case STRING_REV_TOK:
            				case STRING_STOI_TOK:
            				case STRING_SUBSTR_TOK:
            				case STRING_SUFFIXOF_TOK:
            				case STRING_TOLOWER_TOK:
            				case STRING_TOUPPER_TOK:
            				case STRING_TO_REGEXP_TOK:
            				case SX_TOK:
            				case TRANSCLOSURE_TOK:
            				case TRANSPOSE_TOK:
            				case TRUE_TOK:
            				case TUPLE_TOK:
            				case UNIVSET_TOK:
            					{
            						alt6=1;
            					}
            				    break;
            				case LPAREN:
            					{
            						{
            						    int LA6_76 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 76;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case ARRAY_TOK:
            					{
            						{
            						    int LA6_81 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 81;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case IDENTIFIER:
            					{
            						{
            						    int LA6_88 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 88;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case BITVECTOR_TOK:
            				case BOOLEAN_TOK:
            				case INT_TOK:
            				case LBRACKET:
            				case REAL_TOK:
            				case SET_TOK:
            				case SQHASH:
            				case STRING_TOK:
            				case SUBTYPE_TOK:
            					{
            						alt6=2;
            					}
            				    break;

            				default:
            				    if (BACKTRACKING>0)
            				    {
            				        FAILEDFLAG = ANTLR3_TRUE;
            				        return ;
            				    }

            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 6;
            				    EXCEPTION->state        = 2;


            				    goto ruletypeOrVarLetDeclEx;

            				}

            			}
            		    break;
            		case COLON:
            			{
            				alt6=2;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 6;
            		    EXCEPTION->state        = 1;


            		    goto ruletypeOrVarLetDeclEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 6;
                EXCEPTION->state        = 0;


                goto ruletypeOrVarLetDeclEx;

            }

            switch (alt6)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:683:5: letDecl
        	    {
        	        FOLLOWPUSH(FOLLOW_letDecl_in_typeOrVarLetDecl2097);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:683:15: typeLetDecl[check]
        	    {
        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_typeOrVarLetDecl2101);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeOrVarLetDeclEx; /* Prevent compiler warnings */
    ruletypeOrVarLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeOrVarLetDecl */

/**
 * $ANTLR start mainCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:686:1: mainCommand[std::unique_ptr<CVC4::Command>* cmd] : ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | RESET_TOK ASSERTIONS_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | DUMP_UNSAT_CORE_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | CONTINUE_TOK | RESTART_TOK formula[f] | RECURSIVE_FUNCTION_TOK ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+ EQUAL_TOK ( formula[f] ( COMMA )? )+ | toplevelDeclaration[cmd] );
 */
static void
mainCommand(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER3;
    pANTLR3_COMMON_TOKEN    IDENTIFIER4;
    pANTLR3_COMMON_TOKEN    IDENTIFIER5;
    pANTLR3_COMMON_TOKEN    IDENTIFIER6;
    pANTLR3_COMMON_TOKEN    IDENTIFIER7;
    pANTLR3_COMMON_TOKEN    IDENTIFIER8;
    pANTLR3_COMMON_TOKEN    IDENTIFIER9;
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      api::Term f;
      SExpr sexpr;
      std::string id;
      api::Sort t;
      std::vector<CVC4::api::DatatypeDecl> dts;
      Debug("parser-extra") << "command: " << AntlrInput::tokenText(LT(1)) << std::endl;
      std::string s;
      api::Term func;
      std::vector<api::Term> bvs;
      std::vector<api::Term> funcs;
      std::vector<api::Term> formulas;
      std::vector<std::vector<api::Term>> formals;
      std::vector<std::string> ids;
      std::vector<CVC4::api::Sort> types;
      bool idCommaFlag = true;
      bool formCommaFlag = true;

    IDENTIFIER3       = NULL;
    IDENTIFIER4       = NULL;
    IDENTIFIER5       = NULL;
    IDENTIFIER6       = NULL;
    IDENTIFIER7       = NULL;
    IDENTIFIER8       = NULL;
    IDENTIFIER9       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:706:3: ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | RESET_TOK ASSERTIONS_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | DUMP_UNSAT_CORE_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | CONTINUE_TOK | RESTART_TOK formula[f] | RECURSIVE_FUNCTION_TOK ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+ EQUAL_TOK ( formula[f] ( COMMA )? )+ | toplevelDeclaration[cmd] )

            ANTLR3_UINT32 alt35;

            alt35=43;

            switch ( LA(1) )
            {
            case ASSERT_TOK:
            	{
            		alt35=1;
            	}
                break;
            case QUERY_TOK:
            	{
            		alt35=2;
            	}
                break;
            case CHECKSAT_TOK:
            	{
            		alt35=3;
            	}
                break;
            case OPTION_TOK:
            	{
            		alt35=4;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt35=5;
            	}
                break;
            case POP_TOK:
            	{
            		alt35=6;
            	}
                break;
            case POPTO_TOK:
            	{
            		alt35=7;
            	}
                break;
            case PUSH_SCOPE_TOK:
            	{
            		alt35=8;
            	}
                break;
            case POP_SCOPE_TOK:
            	{
            		alt35=9;
            	}
                break;
            case POPTO_SCOPE_TOK:
            	{
            		alt35=10;
            	}
                break;
            case RESET_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case ASSERTIONS_TOK:
            			{
            				alt35=12;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt35=11;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 35;
            		    EXCEPTION->state        = 11;


            		    goto rulemainCommandEx;

            		}

            	}
                break;
            case DATATYPE_TOK:
            	{
            		alt35=13;
            	}
                break;
            case CONTEXT_TOK:
            	{
            		alt35=14;
            	}
                break;
            case FORGET_TOK:
            	{
            		alt35=15;
            	}
                break;
            case GET_TYPE_TOK:
            	{
            		alt35=16;
            	}
                break;
            case CHECK_TYPE_TOK:
            	{
            		alt35=17;
            	}
                break;
            case GET_CHILD_TOK:
            	{
            		alt35=18;
            	}
                break;
            case GET_OP_TOK:
            	{
            		alt35=19;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt35=20;
            	}
                break;
            case SUBSTITUTE_TOK:
            	{
            		alt35=21;
            	}
                break;
            case DBG_TOK:
            	{
            		alt35=22;
            	}
                break;
            case TRACE_TOK:
            	{
            		alt35=23;
            	}
                break;
            case UNTRACE_TOK:
            	{
            		alt35=24;
            	}
                break;
            case HELP_TOK:
            	{
            		alt35=25;
            	}
                break;
            case TRANSFORM_TOK:
            	{
            		alt35=26;
            	}
                break;
            case PRINT_TOK:
            	{
            		alt35=27;
            	}
                break;
            case PRINT_TYPE_TOK:
            	{
            		alt35=28;
            	}
                break;
            case CALL_TOK:
            	{
            		alt35=29;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt35=30;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt35=31;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt35=32;
            	}
                break;
            case DUMP_PROOF_TOK:
            	{
            		alt35=33;
            	}
                break;
            case DUMP_UNSAT_CORE_TOK:
            	{
            		alt35=34;
            	}
                break;
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            	{
            		alt35=35;
            	}
                break;
            case ASSERTIONS_TOK:
            case ASSUMPTIONS_TOK:
            case WHERE_TOK:
            	{
            		alt35=36;
            	}
                break;
            case COUNTEREXAMPLE_TOK:
            	{
            		alt35=37;
            	}
                break;
            case COUNTERMODEL_TOK:
            	{
            		alt35=38;
            	}
                break;
            case ARITH_VAR_ORDER_TOK:
            	{
            		alt35=39;
            	}
                break;
            case CONTINUE_TOK:
            	{
            		alt35=40;
            	}
                break;
            case RESTART_TOK:
            	{
            		alt35=41;
            	}
                break;
            case RECURSIVE_FUNCTION_TOK:
            	{
            		alt35=42;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt35=43;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 35;
                EXCEPTION->state        = 0;


                goto rulemainCommandEx;

            }

            switch (alt35)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:706:5: ASSERT_TOK formula[f]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_mainCommand2127);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2129);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new AssertCommand(f.getExpr())); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:708:5: QUERY_TOK formula[f]
        	    {
        	         MATCHT(QUERY_TOK, &FOLLOW_QUERY_TOK_in_mainCommand2139);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2141);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new QueryCommand(f.getExpr())); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:709:5: CHECKSAT_TOK ( formula[f] )?
        	    {
        	         MATCHT(CHECKSAT_TOK, &FOLLOW_CHECKSAT_TOK_in_mainCommand2150);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:709:18: ( formula[f] )?
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	                case ABS_TOK:
        	                case ARRAY_TOK:
        	                case BAR:
        	                case BINARY_LITERAL:
        	                case BVASHR_TOK:
        	                case BVCOMP_TOK:
        	                case BVGE_TOK:
        	                case BVGT_TOK:
        	                case BVLE_TOK:
        	                case BVLSHR_TOK:
        	                case BVLT_TOK:
        	                case BVMULT_TOK:
        	                case BVNAND_TOK:
        	                case BVNEG_TOK:
        	                case BVNOR_TOK:
        	                case BVPLUS_TOK:
        	                case BVREPEAT_TOK:
        	                case BVROTL_TOK:
        	                case BVROTR_TOK:
        	                case BVSDIV_TOK:
        	                case BVSGE_TOK:
        	                case BVSGT_TOK:
        	                case BVSHL_TOK:
        	                case BVSLE_TOK:
        	                case BVSLT_TOK:
        	                case BVSMOD_TOK:
        	                case BVSREM_TOK:
        	                case BVSUB_TOK:
        	                case BVUDIV_TOK:
        	                case BVUMINUS_TOK:
        	                case BVUREM_TOK:
        	                case BVXNOR_TOK:
        	                case BVXOR_TOK:
        	                case BVZEROEXTEND_TOK:
        	                case DECIMAL_LITERAL:
        	                case DISTINCT_TOK:
        	                case DIVISIBLE_TOK:
        	                case EXISTS_TOK:
        	                case FALSE_TOK:
        	                case FLOOR_TOK:
        	                case FORALL_TOK:
        	                case HEX_LITERAL:
        	                case IDENTIFIER:
        	                case IDEN_TOK:
        	                case IF_TOK:
        	                case INTEGER_LITERAL:
        	                case IS_INTEGER_TOK:
        	                case LAMBDA_TOK:
        	                case LBRACE:
        	                case LET_TOK:
        	                case LPAREN:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case PARENHASH:
        	                case REGEXP_COMPLEMENT_TOK:
        	                case REGEXP_CONCAT_TOK:
        	                case REGEXP_EMPTY_TOK:
        	                case REGEXP_INTER_TOK:
        	                case REGEXP_LOOP_TOK:
        	                case REGEXP_OPT_TOK:
        	                case REGEXP_PLUS_TOK:
        	                case REGEXP_RANGE_TOK:
        	                case REGEXP_SIGMA_TOK:
        	                case REGEXP_STAR_TOK:
        	                case REGEXP_UNION_TOK:
        	                case SETS_CARD_TOK:
        	                case SETS_CHOOSE_TOK:
        	                case STRING_CHARAT_TOK:
        	                case STRING_CONCAT_TOK:
        	                case STRING_CONTAINS_TOK:
        	                case STRING_INDEXOF_TOK:
        	                case STRING_ITOS_TOK:
        	                case STRING_LENGTH_TOK:
        	                case STRING_LITERAL:
        	                case STRING_PREFIXOF_TOK:
        	                case STRING_REPLACE_ALL_TOK:
        	                case STRING_REPLACE_TOK:
        	                case STRING_REV_TOK:
        	                case STRING_STOI_TOK:
        	                case STRING_SUBSTR_TOK:
        	                case STRING_SUFFIXOF_TOK:
        	                case STRING_TOLOWER_TOK:
        	                case STRING_TOUPPER_TOK:
        	                case STRING_TO_REGEXP_TOK:
        	                case SX_TOK:
        	                case TRANSCLOSURE_TOK:
        	                case TRANSPOSE_TOK:
        	                case TRUE_TOK:
        	                case TUPLE_TOK:
        	                case UNIVSET_TOK:
        	                	{
        	                		alt7=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:709:18: formula[f]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2152);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  cmd->reset(f.isNull() ? new CheckSatCommand()
        	                                        : new CheckSatCommand(f.getExpr()));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:715:5: OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	    {
        	         MATCHT(OPTION_TOK, &FOLLOW_OPTION_TOK_in_mainCommand2172);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:716:5: ( str[s] | IDENTIFIER )
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case STRING_LITERAL:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case IDENTIFIER:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:716:7: str[s]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2180);
        	        	        str(ctx, s);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:716:16: IDENTIFIER
        	        	    {
        	        	        IDENTIFIER3 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2185);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             s = AntlrInput::tokenText(IDENTIFIER3); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:717:5: ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	        {
        	            int alt9=4;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt9=1;
        	            	}
        	                break;
        	            case TRUE_TOK:
        	            	{
        	            		alt9=2;
        	            	}
        	                break;
        	            case FALSE_TOK:
        	            	{
        	            		alt9=3;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt9=4;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 9;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt9)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:717:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_mainCommand2197);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(s == "logic") {
        	        	                      cmd->reset(new SetBenchmarkLogicCommand(sexpr.getValue()));
        	        	                    } else {
        	        	                      cmd->reset(new SetOptionCommand(s, sexpr));
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:724:7: TRUE_TOK
        	        	    {
        	        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_mainCommand2214);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("true"))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:725:7: FALSE_TOK
        	        	    {
        	        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_mainCommand2224);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("false"))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:726:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("true"))); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:730:5: PUSH_TOK (k= numeral |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_mainCommand2253);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:730:14: (k= numeral |)
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt10=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt10=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 10;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:730:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2259);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(REPEAT_COMMAND(k, PushCommand())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:731:18: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new PushCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:732:5: POP_TOK (k= numeral |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_mainCommand2288);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:732:13: (k= numeral |)
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt11=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt11=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 11;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:732:15: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2294);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(REPEAT_COMMAND(k, PopCommand())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:733:17: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new PopCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:734:5: POPTO_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_TOK, &FOLLOW_POPTO_TOK_in_mainCommand2322);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:734:16: (k= numeral )?
        	        {
        	            int alt12=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt12=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt12)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:734:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2326);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO command"); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:738:5: PUSH_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(PUSH_SCOPE_TOK, &FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2346);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:738:21: (k= numeral )?
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt13=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:738:21: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2350);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PUSH_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:740:5: POP_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POP_SCOPE_TOK, &FOLLOW_POP_SCOPE_TOK_in_mainCommand2363);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:740:20: (k= numeral )?
        	        {
        	            int alt14=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt14=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt14)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:740:20: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2367);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POP_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:742:5: POPTO_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_SCOPE_TOK, &FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2380);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:742:22: (k= numeral )?
        	        {
        	            int alt15=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt15=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt15)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:742:22: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2384);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:745:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2398);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new ResetCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 12:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:750:5: RESET_TOK ASSERTIONS_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2411);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSERTIONS_TOK, &FOLLOW_ASSERTIONS_TOK_in_mainCommand2413);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new ResetAssertionsCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:758:5: DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK
        	    {
        	         MATCHT(DATATYPE_TOK, &FOLLOW_DATATYPE_TOK_in_mainCommand2441);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* open a scope to keep the UnresolvedTypes contained */
        	                  PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2453);
        	        datatypeDef(ctx, dts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:762:5: ( COMMA datatypeDef[dts] )*

        	        for (;;)
        	        {
        	            int alt16=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt16=1;
        	            	}
        	                break;

        	            }

        	            switch (alt16)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:762:7: COMMA datatypeDef[dts]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand2462);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2464);
        	        	        datatypeDef(ctx, dts);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop16;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop16: ; /* Jump out to here if this rule does not match */


        	         MATCHT(END_TOK, &FOLLOW_END_TOK_in_mainCommand2474);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  cmd->reset(new DatatypeDeclarationCommand(
        	                      api::sortVectorToTypes(PARSER_STATE->bindMutualDatatypeTypes(dts))));
        	                
        	        }


        	    }
        	    break;
        	case 14:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:769:5: CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(CONTEXT_TOK, &FOLLOW_CONTEXT_TOK_in_mainCommand2487);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:770:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt18=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt18=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt18=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 18;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:770:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:770:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt17=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt17=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt17=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 17;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt17)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:770:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2497);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:770:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER4 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2502);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER4); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:772:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 15:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:775:5: FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE]
        	    {
        	         MATCHT(FORGET_TOK, &FOLLOW_FORGET_TOK_in_mainCommand2535);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2537);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("FORGET command"); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:778:5: GET_TYPE_TOK formula[f]
        	    {
        	         MATCHT(GET_TYPE_TOK, &FOLLOW_GET_TYPE_TOK_in_mainCommand2551);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2553);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:781:5: CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(CHECK_TYPE_TOK, &FOLLOW_CHECK_TYPE_TOK_in_mainCommand2567);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2569);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2572);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2574);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CHECK_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:784:5: GET_CHILD_TOK formula[f] k= numeral
        	    {
        	         MATCHT(GET_CHILD_TOK, &FOLLOW_GET_CHILD_TOK_in_mainCommand2588);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2590);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2595);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_CHILD command"); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:787:5: GET_OP_TOK formula[f]
        	    {
        	         MATCHT(GET_OP_TOK, &FOLLOW_GET_OP_TOK_in_mainCommand2608);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2610);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_OP command"); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:790:5: GET_VALUE_TOK formula[f]
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_mainCommand2624);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2626);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetValueCommand(f.getExpr())); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:793:5: SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET
        	    {
        	         MATCHT(SUBSTITUTE_TOK, &FOLLOW_SUBSTITUTE_TOK_in_mainCommand2640);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2642);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2645);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2651);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_mainCommand2654);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2656);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_mainCommand2659);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2665);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_mainCommand2668);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2670);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_mainCommand2673);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("SUBSTITUTE command"); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:800:5: DBG_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(DBG_TOK, &FOLLOW_DBG_TOK_in_mainCommand2692);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:801:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt20=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt20=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt20=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 20;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:801:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:801:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt19=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt19=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt19=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 19;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt19)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:801:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2702);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:801:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER5 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2707);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER5); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Debug.on(s); Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:803:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify what to debug." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 23:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:806:5: TRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(TRACE_TOK, &FOLLOW_TRACE_TOK_in_mainCommand2740);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:807:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt22=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt22=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt22=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 22;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt22)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:807:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:807:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt21=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt21=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt21=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 21;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt21)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:807:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2750);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:807:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER6 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2755);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER6); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:809:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to trace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 24:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:811:5: UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(UNTRACE_TOK, &FOLLOW_UNTRACE_TOK_in_mainCommand2787);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:812:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt24=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt24=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt24=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 24;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt24)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:812:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:812:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt23=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt23=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt23=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 23;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt23)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:812:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2797);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:812:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER7 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2802);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER7); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.off(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:814:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to untrace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 25:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:817:5: HELP_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(HELP_TOK, &FOLLOW_HELP_TOK_in_mainCommand2835);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:818:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt26=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt26=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt26=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 26;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt26)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:818:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:818:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt25=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt25=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt25=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 25;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt25)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:818:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2845);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:818:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER8 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2850);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER8); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "No help available for `" << s << "'." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:820:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please use --help at the command line for help."
        	        	                            << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 26:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:824:5: TRANSFORM_TOK formula[f]
        	    {
        	         MATCHT(TRANSFORM_TOK, &FOLLOW_TRANSFORM_TOK_in_mainCommand2891);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2893);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new SimplifyCommand(f.getExpr())); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:827:5: PRINT_TOK formula[f]
        	    {
        	         MATCHT(PRINT_TOK, &FOLLOW_PRINT_TOK_in_mainCommand2907);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2909);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT command"); 
        	        }


        	    }
        	    break;
        	case 28:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:829:5: PRINT_TYPE_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(PRINT_TYPE_TOK, &FOLLOW_PRINT_TYPE_TOK_in_mainCommand2922);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2924);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 29:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:832:5: CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f]
        	    {
        	         MATCHT(CALL_TOK, &FOLLOW_CALL_TOK_in_mainCommand2938);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2940);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2943);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CALL command"); 
        	        }


        	    }
        	    break;
        	case 30:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:835:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_mainCommand2957);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:836:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt27=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt27=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt27=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 27;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt27)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:836:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_mainCommand2965);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new EchoCommand(sexpr.getValue())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:838:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new EchoCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 31:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:841:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_mainCommand2995);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new QuitCommand()); 
        	        }


        	    }
        	    break;
        	case 32:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:844:5: INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_mainCommand3008);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:845:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt29=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt29=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt29=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 29;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt29)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:845:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:845:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt28=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt28=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt28=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 28;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt28)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:845:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand3018);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:845:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER9 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand3023);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER9); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:847:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->parseError("No filename given to INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 33:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:850:5: DUMP_PROOF_TOK
        	    {
        	         MATCHT(DUMP_PROOF_TOK, &FOLLOW_DUMP_PROOF_TOK_in_mainCommand3056);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetProofCommand()); 
        	        }


        	    }
        	    break;
        	case 34:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:853:5: DUMP_UNSAT_CORE_TOK
        	    {
        	         MATCHT(DUMP_UNSAT_CORE_TOK, &FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand3069);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetUnsatCoreCommand()); 
        	        }


        	    }
        	    break;
        	case 35:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:856:5: ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK )
        	    {
        	        if ( ((LA(1) >= DUMP_ASSUMPTIONS_TOK) && (LA(1) <= DUMP_CLOSURE_TOK)) || ((LA(1) >= DUMP_SIG_TOK) && (LA(1) <= DUMP_TCC_TOK)) )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("DUMP* command"); 
        	        }


        	    }
        	    break;
        	case 36:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:866:5: ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK )
        	    {
        	        if ( LA(1) == ASSERTIONS_TOK || LA(1) == ASSUMPTIONS_TOK || LA(1) == WHERE_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetAssertionsCommand()); 
        	        }


        	    }
        	    break;
        	case 37:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:869:5: COUNTEREXAMPLE_TOK
        	    {
        	         MATCHT(COUNTEREXAMPLE_TOK, &FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3178);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetModelCommand); 
        	        }


        	    }
        	    break;
        	case 38:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:871:5: COUNTERMODEL_TOK
        	    {
        	         MATCHT(COUNTERMODEL_TOK, &FOLLOW_COUNTERMODEL_TOK_in_mainCommand3190);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetModelCommand); 
        	        }


        	    }
        	    break;
        	case 39:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:874:5: ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN
        	    {
        	         MATCHT(ARITH_VAR_ORDER_TOK, &FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3203);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_mainCommand3205);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3207);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:874:43: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt30=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt30=1;
        	            	}
        	                break;

        	            }

        	            switch (alt30)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:874:45: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3212);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3214);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop30;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop30: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_mainCommand3220);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("ARITH_VAR_ORDER command"); 
        	        }


        	    }
        	    break;
        	case 40:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:877:5: CONTINUE_TOK
        	    {
        	         MATCHT(CONTINUE_TOK, &FOLLOW_CONTINUE_TOK_in_mainCommand3233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CONTINUE command"); 
        	        }


        	    }
        	    break;
        	case 41:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:879:5: RESTART_TOK formula[f]
        	    {
        	         MATCHT(RESTART_TOK, &FOLLOW_RESTART_TOK_in_mainCommand3245);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3247);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("RESTART command"); 
        	        }


        	    }
        	    break;
        	case 42:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:880:5: RECURSIVE_FUNCTION_TOK ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+ EQUAL_TOK ( formula[f] ( COMMA )? )+
        	    {
        	         MATCHT(RECURSIVE_FUNCTION_TOK, &FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3256);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:880:28: ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+
        	        {
        	            int cnt32=0;

        	            for (;;)
        	            {
        	                int alt32=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case IDENTIFIER:
        	        		{
        	        			alt32=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt32)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:880:29: identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )?
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_identifier_in_mainCommand3259);
        	        	            identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      if(idCommaFlag){
        	        	                        idCommaFlag=false;
        	        	                      }
        	        	                      else{
        	        	                        PARSER_STATE->parseError("Identifiers need to be comma separated");
        	        	                      }
        	        	                    
        	        	            }


        	        	             MATCHT(COLON, &FOLLOW_COLON_in_mainCommand3272);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_type_in_mainCommand3274);
        	        	            type(ctx, t, CHECK_DECLARED);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:889:34: ( COMMA )?
        	        	            {
        	        	                int alt31=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                    case COMMA:
        	        	                    	{
        	        	                    		alt31=1;
        	        	                    	}
        	        	                        break;
        	        	                }

        	        	                switch (alt31)
        	        	                {
        	        	            	case 1:
        	        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:889:35: COMMA
        	        	            	    {
        	        	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3278);
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto rulemainCommandEx;
        	        	            	        }
        	        	            	        if (HASFAILED())
        	        	            	        {
        	        	            	            return ;
        	        	            	        }


        	        	            	        if ( BACKTRACKING==0 )
        	        	            	        {

        	        	            	                  idCommaFlag=true;
        	        	            	                  
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	                }
        	        	            }

        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      func = PARSER_STATE->bindVar(id, t, ExprManager::VAR_FLAG_NONE, true);
        	        	                      ids.push_back(id);
        	        	                      types.push_back(t);
        	        	                      funcs.push_back(func);
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt32 >= 1 )
        	        		{
        	        		    goto loop32;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulemainCommandEx;
        	        	}
        	        	cnt32++;
        	            }
        	            loop32: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_mainCommand3296);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:898:15: ( formula[f] ( COMMA )? )+
        	        {
        	            int cnt34=0;

        	            for (;;)
        	            {
        	                int alt34=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case ABS_TOK:
        	        	case ARRAY_TOK:
        	        	case BAR:
        	        	case BINARY_LITERAL:
        	        	case BVASHR_TOK:
        	        	case BVCOMP_TOK:
        	        	case BVGE_TOK:
        	        	case BVGT_TOK:
        	        	case BVLE_TOK:
        	        	case BVLSHR_TOK:
        	        	case BVLT_TOK:
        	        	case BVMULT_TOK:
        	        	case BVNAND_TOK:
        	        	case BVNEG_TOK:
        	        	case BVNOR_TOK:
        	        	case BVPLUS_TOK:
        	        	case BVREPEAT_TOK:
        	        	case BVROTL_TOK:
        	        	case BVROTR_TOK:
        	        	case BVSDIV_TOK:
        	        	case BVSGE_TOK:
        	        	case BVSGT_TOK:
        	        	case BVSHL_TOK:
        	        	case BVSLE_TOK:
        	        	case BVSLT_TOK:
        	        	case BVSMOD_TOK:
        	        	case BVSREM_TOK:
        	        	case BVSUB_TOK:
        	        	case BVUDIV_TOK:
        	        	case BVUMINUS_TOK:
        	        	case BVUREM_TOK:
        	        	case BVXNOR_TOK:
        	        	case BVXOR_TOK:
        	        	case BVZEROEXTEND_TOK:
        	        	case DECIMAL_LITERAL:
        	        	case DISTINCT_TOK:
        	        	case DIVISIBLE_TOK:
        	        	case EXISTS_TOK:
        	        	case FALSE_TOK:
        	        	case FLOOR_TOK:
        	        	case FORALL_TOK:
        	        	case HEX_LITERAL:
        	        	case IDENTIFIER:
        	        	case IDEN_TOK:
        	        	case IF_TOK:
        	        	case INTEGER_LITERAL:
        	        	case IS_INTEGER_TOK:
        	        	case LAMBDA_TOK:
        	        	case LBRACE:
        	        	case LET_TOK:
        	        	case LPAREN:
        	        	case MINUS_TOK:
        	        	case NOT_TOK:
        	        	case PARENHASH:
        	        	case REGEXP_COMPLEMENT_TOK:
        	        	case REGEXP_CONCAT_TOK:
        	        	case REGEXP_EMPTY_TOK:
        	        	case REGEXP_INTER_TOK:
        	        	case REGEXP_LOOP_TOK:
        	        	case REGEXP_OPT_TOK:
        	        	case REGEXP_PLUS_TOK:
        	        	case REGEXP_RANGE_TOK:
        	        	case REGEXP_SIGMA_TOK:
        	        	case REGEXP_STAR_TOK:
        	        	case REGEXP_UNION_TOK:
        	        	case SETS_CARD_TOK:
        	        	case SETS_CHOOSE_TOK:
        	        	case STRING_CHARAT_TOK:
        	        	case STRING_CONCAT_TOK:
        	        	case STRING_CONTAINS_TOK:
        	        	case STRING_INDEXOF_TOK:
        	        	case STRING_ITOS_TOK:
        	        	case STRING_LENGTH_TOK:
        	        	case STRING_LITERAL:
        	        	case STRING_PREFIXOF_TOK:
        	        	case STRING_REPLACE_ALL_TOK:
        	        	case STRING_REPLACE_TOK:
        	        	case STRING_REV_TOK:
        	        	case STRING_STOI_TOK:
        	        	case STRING_SUBSTR_TOK:
        	        	case STRING_SUFFIXOF_TOK:
        	        	case STRING_TOLOWER_TOK:
        	        	case STRING_TOUPPER_TOK:
        	        	case STRING_TO_REGEXP_TOK:
        	        	case SX_TOK:
        	        	case TRANSCLOSURE_TOK:
        	        	case TRANSPOSE_TOK:
        	        	case TRUE_TOK:
        	        	case TUPLE_TOK:
        	        	case UNIVSET_TOK:
        	        		{
        	        			alt34=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt34)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:898:16: formula[f] ( COMMA )?
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_formula_in_mainCommand3299);
        	        	            formula(ctx, f);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      if(formCommaFlag){
        	        	                        formCommaFlag=false;
        	        	                      }
        	        	                      else{
        	        	                        PARSER_STATE->parseError("Function definitions need to be comma separated");
        	        	                      }
        	        	                    
        	        	            }


        	        	            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:907:5: ( COMMA )?
        	        	            {
        	        	                int alt33=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                    case COMMA:
        	        	                    	{
        	        	                    		alt33=1;
        	        	                    	}
        	        	                        break;
        	        	                }

        	        	                switch (alt33)
        	        	                {
        	        	            	case 1:
        	        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:907:6: COMMA
        	        	            	    {
        	        	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3313);
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto rulemainCommandEx;
        	        	            	        }
        	        	            	        if (HASFAILED())
        	        	            	        {
        	        	            	            return ;
        	        	            	        }


        	        	            	        if ( BACKTRACKING==0 )
        	        	            	        {

        	        	            	                  formCommaFlag=true;
        	        	            	                
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	                }
        	        	            }

        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      if( f.getKind()==api::LAMBDA ){
        	        	                        bvs.insert(bvs.end(), f[0].begin(), f[0].end());
        	        	                        formals.push_back(bvs);
        	        	                        bvs.clear();
        	        	                        f = f[1];
        	        	                        formulas.push_back(f);
        	        	                      }
        	        	                      else {
        	        	                        formals.push_back(bvs);
        	        	                        formulas.push_back(f);
        	        	                      }
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt34 >= 1 )
        	        		{
        	        		    goto loop34;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulemainCommandEx;
        	        	}
        	        	cnt34++;
        	            }
        	            loop34: ;	/* Jump to here if this rule does not match */
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(idCommaFlag){
        	                    PARSER_STATE->parseError("Cannot end function list with comma");
        	                  }
        	                  if(formCommaFlag){
        	                    PARSER_STATE->parseError("Cannot end function definition list with comma");
        	                  }
        	                  if(funcs.size()!=formulas.size()){
        	                    PARSER_STATE->parseError("Number of functions doesn't match number of function definitions");
        	                  }
        	                  for(unsigned int i = 0, size = funcs.size(); i < size; i++){
        	                    if(!funcs[i].getSort().isSubsortOf(types[i])){
        	                      PARSER_STATE->parseError("Type mismatch in definition");
        	                    }
        	                  }
        	                  cmd->reset(
        	                      new DefineFunctionRecCommand(SOLVER, funcs, formals, formulas, true));
        	                
        	        }


        	    }
        	    break;
        	case 43:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:941:5: toplevelDeclaration[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_toplevelDeclaration_in_mainCommand3336);
        	        toplevelDeclaration(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulemainCommandEx; /* Prevent compiler warnings */
    rulemainCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end mainCommand */

/**
 * $ANTLR start simpleSymbolicExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:944:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER );
 */
static void
simpleSymbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::string s;
      CVC4::Rational r;

    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL10;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL11;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL12;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL13;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL14;
    pANTLR3_COMMON_TOKEN    IDENTIFIER15;

    /* Initialize rule variables
     */

    INTEGER_LITERAL10       = NULL;
    INTEGER_LITERAL11       = NULL;
    DECIMAL_LITERAL12       = NULL;
    HEX_LITERAL13       = NULL;
    BINARY_LITERAL14       = NULL;
    IDENTIFIER15       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:949:3: ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER )

            ANTLR3_UINT32 alt36;

            alt36=7;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt36=1;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt36=2;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt36=3;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt36=4;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt36=5;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt36=6;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt36=7;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 36;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt36)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:949:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL10 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3356);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL10))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:951:5: MINUS_TOK INTEGER_LITERAL
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3368);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        INTEGER_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3370);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(-Integer(AntlrInput::tokenText(INTEGER_LITERAL11))); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:953:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL12 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3382);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL12)); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:955:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL13 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3394);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(HEX_LITERAL13)); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:957:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3406);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(BINARY_LITERAL14)); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:959:5: str[s]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExpr3418);
        	        str(ctx, s);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:961:5: IDENTIFIER
        	    {
        	        IDENTIFIER15 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3431);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(IDENTIFIER15)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:965:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN );
 */
static void
symbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:969:3: ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN )

            ANTLR3_UINT32 alt38;

            alt38=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case IDENTIFIER:
            case INTEGER_LITERAL:
            case MINUS_TOK:
            case STRING_LITERAL:
            	{
            		alt38=1;
            	}
                break;
            case LPAREN:
            	{
            		alt38=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 38;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt38)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:969:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr3456);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:970:5: LPAREN ( symbolicExpr[sexpr] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_symbolicExpr3463);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:970:12: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt37=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt37=1;
        	            	}
        	                break;

        	            }

        	            switch (alt37)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:970:13: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr3466);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop37;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop37: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_symbolicExpr3474);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start toplevelDeclaration
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:977:1: toplevelDeclaration[std::unique_ptr<CVC4::Command>* cmd] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) ;
 */
static void
toplevelDeclaration(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      api::Sort t;
      Debug("parser-extra") << "declaration: " << AntlrInput::tokenText(LT(1))
                            << std::endl;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:984:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:984:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_toplevelDeclaration3501);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_toplevelDeclaration3504);
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:985:5: ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
            {
                int alt39=2;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BITVECTOR_TOK:
                case BOOLEAN_TOK:
                case IDENTIFIER:
                case INT_TOK:
                case LBRACKET:
                case LET_TOK:
                case LPAREN:
                case REAL_TOK:
                case SET_TOK:
                case SQHASH:
                case STRING_TOK:
                case SUBTYPE_TOK:
                	{
                		alt39=1;
                	}
                    break;
                case TYPE_TOK:
                	{
                		alt39=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 39;
                    EXCEPTION->state        = 0;


                    goto ruletoplevelDeclarationEx;

                }

                switch (alt39)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:985:7: declareVariables[cmd,t,ids,true]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareVariables_in_toplevelDeclaration3512);
            	        declareVariables(ctx, cmd, t, ids, true);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:986:7: declareTypes[cmd,ids]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareTypes_in_toplevelDeclaration3521);
            	        declareTypes(ctx, cmd, ids);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletoplevelDeclarationEx; /* Prevent compiler warnings */
    ruletoplevelDeclarationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end toplevelDeclaration */

/**
 * $ANTLR start boundVarDecl
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:992:1: boundVarDecl[std::vector<std::string>& ids, CVC4::api::Sort& t] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false] ;
 */
static void
boundVarDecl(pCvcParser ctx, std::vector<std::string>& ids, CVC4::api::Sort& t)
{
    /* Initialize rule variables
     */


      std::unique_ptr<Command> local_cmd;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:996:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false] )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:996:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDecl3545);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDecl3548);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_declareVariables_in_boundVarDecl3554);
            declareVariables(ctx, &local_cmd, t, ids, false);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclEx; /* Prevent compiler warnings */
    ruleboundVarDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecl */

/**
 * $ANTLR start boundVarDecls
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1003:1: boundVarDecls : boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* ;
 */
static void
boundVarDecls(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      api::Sort t;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1008:3: ( boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1008:5: boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3575);
            boundVarDecl(ctx, ids, t);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1008:25: ( COMMA boundVarDecl[ids,t] )*

            for (;;)
            {
                int alt40=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt40=1;
                	}
                    break;

                }

                switch (alt40)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1008:27: COMMA boundVarDecl[ids,t]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDecls3580);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3582);
            	        boundVarDecl(ctx, ids, t);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop40;	/* break out of the loop */
            	    break;
                }
            }
            loop40: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsEx; /* Prevent compiler warnings */
    ruleboundVarDeclsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecls */

/**
 * $ANTLR start boundVarDeclsReturn
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1011:1: boundVarDeclsReturn[std::vector<CVC4::api::Term>& terms,\n std::vector<CVC4::api::Sort>& types] : boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* ;
 */
static void
boundVarDeclsReturn(pCvcParser ctx, std::vector<CVC4::api::Term>& terms, std::vector<CVC4::api::Sort>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      api::Sort t;
      terms.clear();
      types.clear();

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1019:3: ( boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1019:5: boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3605);
            boundVarDeclReturn(ctx, terms, types);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1019:37: ( COMMA boundVarDeclReturn[terms,types] )*

            for (;;)
            {
                int alt41=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt41=1;
                	}
                    break;

                }

                switch (alt41)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1019:39: COMMA boundVarDeclReturn[terms,types]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDeclsReturn3610);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3612);
            	        boundVarDeclReturn(ctx, terms, types);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop41;	/* break out of the loop */
            	    break;
                }
            }
            loop41: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclsReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclsReturn */

/**
 * $ANTLR start boundVarDeclReturn
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1022:1: boundVarDeclReturn[std::vector<CVC4::api::Term>& terms,\n std::vector<CVC4::api::Sort>& types] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ;
 */
static void
boundVarDeclReturn(pCvcParser ctx, std::vector<CVC4::api::Term>& terms, std::vector<CVC4::api::Sort>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      api::Sort t;
      // NOTE: do not clear the vectors here!

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1029:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1029:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDeclReturn3635);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDeclReturn3638);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_boundVarDeclReturn3640);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 const std::vector<api::Term>& vars = PARSER_STATE->bindBoundVars(ids, t);
                      terms.insert(terms.end(), vars.begin(), vars.end());
                      for(unsigned i = 0; i < vars.size(); ++i) {
                        types.push_back(t);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclReturn */

/**
 * $ANTLR start declareTypes
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1045:1: declareTypes[std::unique_ptr<CVC4::Command>* cmd,\n const std::vector<std::string>& idList] : ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] );
 */
static void
declareTypes(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, const std::vector<std::string>& idList)
{
    /* Initialize rule variables
     */


      api::Sort t;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1051:3: ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] )

            ANTLR3_UINT32 alt42;

            alt42=2;

            switch ( LA(1) )
            {
            case TYPE_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				alt42=2;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt42=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 42;
            		    EXCEPTION->state        = 1;


            		    goto ruledeclareTypesEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 42;
                EXCEPTION->state        = 0;


                goto ruledeclareTypesEx;

            }

            switch (alt42)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1051:5: TYPE_TOK
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3674);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::unique_ptr<DeclarationSequence> seq(new DeclarationSequence());
        	                  for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end(); ++i) {
        	                    // Don't allow a type variable to clash with a previously
        	                    // declared type variable, however a type variable and a
        	                    // non-type variable can clash unambiguously.  Break from CVC3
        	                    // behavior here.
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    api::Sort sort = PARSER_STATE->mkSort(*i);
        	                    Command* decl = new DeclareTypeCommand(*i, 0, sort.getType());
        	                    seq->addCommand(decl);
        	                  }
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1068:5: TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3693);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareTypes3695);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_declareTypes3697);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end();
        	                      ++i) {
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    PARSER_STATE->defineType(*i, t);
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledeclareTypesEx; /* Prevent compiler warnings */
    ruledeclareTypesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareTypes */

/**
 * $ANTLR start declareVariables
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1087:1: declareVariables[std::unique_ptr<CVC4::Command>* cmd, CVC4::api::Sort& t,\n const std::vector<std::string>& idList, bool topLevel] : type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? ;
 */
static void
declareVariables(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, CVC4::api::Sort& t, const std::vector<std::string>& idList, bool topLevel)
{
    /* Initialize rule variables
     */


      api::Term f;
      Debug("parser-extra") << "declType: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1094:3: ( type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1094:5: type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )?
        {
            FOLLOWPUSH(FOLLOW_type_in_declareVariables3731);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledeclareVariablesEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1094:28: ( EQUAL_TOK formula[f] )?
            {
                int alt43=2;
                switch ( LA(1) )
                {
                    case EQUAL_TOK:
                    	{
                    		alt43=1;
                    	}
                        break;
                }

                switch (alt43)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1094:30: EQUAL_TOK formula[f]
            	    {
            	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareVariables3736);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_declareVariables3738);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 std::unique_ptr<DeclarationSequence> seq;
                      if(topLevel) {
                        seq.reset(new DeclarationSequence());
                      }
                      if(f.isNull()) {
                        Debug("parser") << "working on " << idList.front() << " : " << t
                                        << std::endl;
                        // CVC language allows redeclaration of variables if types are the same
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          if(PARSER_STATE->isDeclared(*i, SYM_VARIABLE)) {
                            api::Sort oldType = PARSER_STATE->getVariable(*i).getSort();
                            Debug("parser") << "  " << *i << " was declared previously "
                                            << "with type " << oldType << std::endl;
                            if(oldType != t) {
                              std::stringstream ss;
                              ss << language::SetLanguage(language::output::LANG_CVC4)
                                 << "incompatible type for `" << *i << "':" << std::endl
                                 << "  old type: " << oldType << std::endl
                                 << "  new type: " << t << std::endl;
                              PARSER_STATE->parseError(ss.str());
                            } else {
                              Debug("parser") << "  types " << t << " and " << oldType
                                              << " are compatible" << std::endl;
                            }
                          } else {
                            Debug("parser") << "  " << *i << " not declared" << std::endl;
                            if(topLevel) {
                              api::Term func =
                                  PARSER_STATE->bindVar(*i, t, ExprManager::VAR_FLAG_GLOBAL);
                              Command* decl =
                                  new DeclareFunctionCommand(*i, func.getExpr(), t.getType());
                              seq->addCommand(decl);
                            } else {
                              PARSER_STATE->bindBoundVar(*i, t);
                            }
                          }
                        }
                      } else {
                        // f is not null-- meaning this is a definition not a declaration
                        //Check if the formula f has the correct type, declared as t.
                        if(!f.getSort().isSubsortOf(t)){
                          PARSER_STATE->parseError("Type mismatch in definition");
                        }
                        if(!topLevel) {
                          // must be top-level; doesn't make sense to write something
                          // like e.g. FORALL(x:INT = 4): [...]
                          PARSER_STATE->parseError("cannot construct a definition here; maybe you want a LET");
                        }
                        assert(!idList.empty());
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          Debug("parser") << "making " << *i << " : " << t << " = " << f << std::endl;
                          PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_VARIABLE);
                          api::Term func = PARSER_STATE->mkVar(
                              *i,
                              api::Sort(SOLVER, t.getType()),
                              ExprManager::VAR_FLAG_GLOBAL | ExprManager::VAR_FLAG_DEFINED);
                          PARSER_STATE->defineVar(*i, f);
                          Command* decl =
                              new DefineFunctionCommand(*i, func.getExpr(), f.getExpr(), true);
                          seq->addCommand(decl);
                        }
                      }
                      if(topLevel) {
                        cmd->reset(new DeclarationSequence());
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledeclareVariablesEx; /* Prevent compiler warnings */
    ruledeclareVariablesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareVariables */

/**
 * $ANTLR start identifierList
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1175:1: identifierList[std::vector<std::string>& idList,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : identifier[id,check,type] ( COMMA identifier[id,check,type] )* ;
 */
static void
identifierList(pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    /* Initialize rule variables
     */


      std::string id;
      idList.clear();

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1182:3: ( identifier[id,check,type] ( COMMA identifier[id,check,type] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1182:5: identifier[id,check,type] ( COMMA identifier[id,check,type] )*
        {
            FOLLOWPUSH(FOLLOW_identifier_in_identifierList3769);
            identifier(ctx, id, check, type);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleidentifierListEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 idList.push_back(id); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1183:5: ( COMMA identifier[id,check,type] )*

            for (;;)
            {
                int alt44=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt44=1;
                	}
                    break;

                }

                switch (alt44)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1183:7: COMMA identifier[id,check,type]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_identifierList3780);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_identifier_in_identifierList3782);
            	        identifier(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             idList.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop44;	/* break out of the loop */
            	    break;
                }
            }
            loop44: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierListEx; /* Prevent compiler warnings */
    ruleidentifierListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifierList */

/**
 * $ANTLR start identifier
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1189:1: identifier[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : IDENTIFIER ;
 */
static void
identifier(pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER16;

    /* Initialize rule variables
     */

    IDENTIFIER16       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1192:3: ( IDENTIFIER )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1192:5: IDENTIFIER
        {
            IDENTIFIER16 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_identifier3804);
            if  (HASEXCEPTION())
            {
                goto ruleidentifierEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 id = AntlrInput::tokenText(IDENTIFIER16);
                      PARSER_STATE->checkDeclaration(id, check, type); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierEx; /* Prevent compiler warnings */
    ruleidentifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifier */

/**
 * $ANTLR start type
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1209:1: type[CVC4::api::Sort& t,\n CVC4::parser::DeclarationCheck check] : ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] );
 */
static void
type(pCvcParser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      api::Sort t2;
      bool lhs;
      std::vector<api::Sort> args;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1217:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] )

            ANTLR3_UINT32 alt47;

            alt47=2;

            switch ( LA(1) )
            {
            case ARRAY_TOK:
            case BITVECTOR_TOK:
            case BOOLEAN_TOK:
            case IDENTIFIER:
            case INT_TOK:
            case LBRACKET:
            case LPAREN:
            case REAL_TOK:
            case SET_TOK:
            case SQHASH:
            case STRING_TOK:
            case SUBTYPE_TOK:
            	{
            		alt47=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt47=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 47;
                EXCEPTION->state        = 0;


                goto ruletypeEx;

            }

            switch (alt47)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1217:5: restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3837);
        	        restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) {
        	                    assert(t.isTuple());
        	                    args = t.getTupleSorts();
        	                  } else {
        	                    args.push_back(t);
        	                  }
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1225:5: ( ARROW_TOK type[t2,check] )?
        	        {
        	            int alt45=2;
        	            switch ( LA(1) )
        	            {
        	                case ARROW_TOK:
        	                	{
        	                		alt45=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt45)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1225:7: ARROW_TOK type[t2,check]
        	        	    {
        	        	         MATCHT(ARROW_TOK, &FOLLOW_ARROW_TOK_in_type3852);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_type3854);
        	        	        type(ctx, t2, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(t2.isNull()) {
        	                    if(lhs) {
        	                      PARSER_STATE->parseError("improperly-placed type list; expected `->' after to define a function; or else maybe these parentheses were meant to be square brackets, to define a tuple type?");
        	                    }
        	                  } else {
        	                    t = SOLVER->mkFunctionSort(args, t2);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1238:5: LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_type3877);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3885);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1239:24: ( COMMA typeLetDecl[check] )*

        	        for (;;)
        	        {
        	            int alt46=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt46=1;
        	            	}
        	                break;

        	            }

        	            switch (alt46)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1239:26: COMMA typeLetDecl[check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_type3890);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3892);
        	        	        typeLetDecl(ctx, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop46;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop46: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_type3898);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_type3900);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeEx; /* Prevent compiler warnings */
    ruletypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end type */

/**
 * $ANTLR start restrictedType
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1253:1: restrictedType[CVC4::api::Sort& t,\n CVC4::parser::DeclarationCheck check] : restrictedTypePossiblyFunctionLHS[t,check,lhs] ;
 */
static void
restrictedType(pCvcParser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      bool lhs;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1258:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1258:5: restrictedTypePossiblyFunctionLHS[t,check,lhs]
        {
            FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3936);
            restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerestrictedTypeEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 if(lhs) { PARSER_STATE->parseError("improperly-placed type list; maybe these parentheses were meant to be square brackets, to define a tuple type?"); } 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypeEx; /* Prevent compiler warnings */
    rulerestrictedTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedType */

/**
 * $ANTLR start restrictedTypePossiblyFunctionLHS
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1266:1: restrictedTypePossiblyFunctionLHS[CVC4::api::Sort& t,\n CVC4::parser::DeclarationCheck check,\n bool& lhs] : ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET bound DOTDOT bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN );
 */
static void
restrictedTypePossiblyFunctionLHS(pCvcParser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check, bool& lhs)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      api::Sort t2;
      api::Term f, f2;
      std::string id;
      std::vector<api::Sort> types;
      std::vector< std::pair<std::string, api::Sort> > typeIds;
      //SymbolTable* symtab;
      Parser* parser;
      lhs = false;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1280:3: ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET bound DOTDOT bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN )

            ANTLR3_UINT32 alt55;

            alt55=13;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		alt55=1;
            	}
                break;
            case ARRAY_TOK:
            	{
            		alt55=2;
            	}
                break;
            case SET_TOK:
            	{
            		alt55=3;
            	}
                break;
            case SUBTYPE_TOK:
            	{
            		alt55=4;
            	}
                break;
            case LBRACKET:
            	{
            		switch ( LA(2) )
            		{
            		case INTEGER_LITERAL:
            		case MINUS_TOK:
            		case UNDERSCORE:
            			{
            				alt55=5;
            			}
            		    break;
            		case ARRAY_TOK:
            		case BITVECTOR_TOK:
            		case BOOLEAN_TOK:
            		case IDENTIFIER:
            		case INT_TOK:
            		case LBRACKET:
            		case LET_TOK:
            		case LPAREN:
            		case RBRACKET:
            		case REAL_TOK:
            		case SET_TOK:
            		case SQHASH:
            		case STRING_TOK:
            		case SUBTYPE_TOK:
            			{
            				alt55=6;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 55;
            		    EXCEPTION->state        = 5;


            		    goto rulerestrictedTypePossiblyFunctionLHSEx;

            		}

            	}
                break;
            case SQHASH:
            	{
            		alt55=7;
            	}
                break;
            case BITVECTOR_TOK:
            	{
            		alt55=8;
            	}
                break;
            case STRING_TOK:
            	{
            		alt55=9;
            	}
                break;
            case BOOLEAN_TOK:
            	{
            		alt55=10;
            	}
                break;
            case REAL_TOK:
            	{
            		alt55=11;
            	}
                break;
            case INT_TOK:
            	{
            		alt55=12;
            	}
                break;
            case LPAREN:
            	{
            		alt55=13;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 55;
                EXCEPTION->state        = 0;


                goto rulerestrictedTypePossiblyFunctionLHSEx;

            }

            switch (alt55)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1280:5: identifier[id,check,SYM_SORT] ( parameterization[check,types] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3970);
        	        identifier(ctx, id, check, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1281:5: ( parameterization[check,types] )?
        	        {
        	            int alt48=2;
        	            switch ( LA(1) )
        	            {
        	                case LBRACKET:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case IDENTIFIER:
        	                		    	{
        	                		    		switch ( LA(3) )
        	                		    		{
        	                		    		    case COMMA:
        	                		    		    case LBRACKET:
        	                		    		    case RBRACKET:
        	                		    		    	{
        	                		    		    		alt48=1;
        	                		    		    	}
        	                		    		        break;
        	                		    		}

        	                		    	}
        	                		        break;
        	                		    case ARRAY_TOK:
        	                		    case BITVECTOR_TOK:
        	                		    case BOOLEAN_TOK:
        	                		    case INT_TOK:
        	                		    case LBRACKET:
        	                		    case LPAREN:
        	                		    case REAL_TOK:
        	                		    case SET_TOK:
        	                		    case SQHASH:
        	                		    case STRING_TOK:
        	                		    case SUBTYPE_TOK:
        	                		    	{
        	                		    		alt48=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt48)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1281:5: parameterization[check,types]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3977);
        	        	        parameterization(ctx, check, types);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(check == CHECK_DECLARED ||
        	                     PARSER_STATE->isDeclared(id, SYM_SORT)) {
        	                    Debug("parser-param") << "param: getSort " << id << " " << types.size() << " " << PARSER_STATE->getArity( id )
        	                                          << " " << PARSER_STATE->isDeclared(id, SYM_SORT) << std::endl;
        	                    if(types.size() != PARSER_STATE->getArity(id)) {
        	                      std::stringstream ss;
        	                      ss << "incorrect arity for symbol `" << id << "': expected "
        	                         << PARSER_STATE->getArity( id ) << " type arguments, got "
        	                         << types.size();
        	                      PARSER_STATE->parseError(ss.str());
        	                    }
        	                    if(types.size() > 0) {
        	                      t = PARSER_STATE->getSort(id, types);
        	                    }else{
        	                      t = PARSER_STATE->getSort(id);
        	                    }
        	                  } else {
        	                    if(types.empty()) {
        	                      t = PARSER_STATE->mkUnresolvedType(id);
        	                      Debug("parser-param") << "param: make unres type " << id << std::endl;
        	                    }else{
        	                      t = PARSER_STATE->mkUnresolvedTypeConstructor(id,types);
        	                      t = t.instantiate( types );
        	                      Debug("parser-param") << "param: make unres param type " << id << " " << types.size() << " "
        	                                            << PARSER_STATE->getArity( id ) << std::endl;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1313:5: ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check]
        	    {
        	         MATCHT(ARRAY_TOK, &FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3998);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4000);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4003);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4005);
        	        restrictedType(ctx, t2, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->mkArraySort(t, t2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1315:5: SET_TOK OF_TOK restrictedType[t,check]
        	    {
        	         MATCHT(SET_TOK, &FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS4018);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS4020);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS4022);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->mkSetSort(t); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1319:5: SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN
        	    {
        	         MATCHT(SUBTYPE_TOK, &FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS4042);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4044);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4056);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1324:16: ( COMMA formula[f2] )?
        	        {
        	            int alt49=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA:
        	                	{
        	                		alt49=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt49)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1324:18: COMMA formula[f2]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4061);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS4063);
        	        	        formula(ctx, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4069);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  PARSER_STATE->unimplementedFeature("predicate subtyping not supported in this release");
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1330:5: LBRACKET bound DOTDOT bound RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4088);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4090);
        	        bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(DOTDOT, &FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS4092);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4094);
        	        bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4096);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  PARSER_STATE->unimplementedFeature("subrange typing not supported in this release");
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1336:5: LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4115);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1336:14: ( type[t,check] ( COMMA type[t,check] )* )?
        	        {
        	            int alt51=2;
        	            switch ( LA(1) )
        	            {
        	                case ARRAY_TOK:
        	                case BITVECTOR_TOK:
        	                case BOOLEAN_TOK:
        	                case IDENTIFIER:
        	                case INT_TOK:
        	                case LBRACKET:
        	                case LET_TOK:
        	                case LPAREN:
        	                case REAL_TOK:
        	                case SET_TOK:
        	                case SQHASH:
        	                case STRING_TOK:
        	                case SUBTYPE_TOK:
        	                	{
        	                		alt51=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt51)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1336:16: type[t,check] ( COMMA type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4119);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             types.push_back(t); 
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1337:5: ( COMMA type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt50=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt50=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt50)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1337:7: COMMA type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4130);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4132);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             types.push_back(t); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop50;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop50: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4143);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(types.size() == 1 && types.front().isFunction()) {
        	                    // old style function syntax [ T -> U ]
        	                    PARSER_STATE->parseError("old-style function type syntax not supported anymore; please use the new syntax");
        	                  } else {
        	                    // tuple type [ T, U, V... ]
        	                    t = SOLVER->mkTupleSort(types);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1348:5: SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ
        	    {
        	         MATCHT(SQHASH, &FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4162);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1348:12: ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )?
        	        {
        	            int alt53=2;
        	            switch ( LA(1) )
        	            {
        	                case IDENTIFIER:
        	                	{
        	                		alt53=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt53)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1348:14: identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4166);
        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4169);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4171);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1349:5: ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt52=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt52=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt52)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1349:7: COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4182);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4184);
        	        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4187);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4189);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop52;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop52: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(HASHSQ, &FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4200);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->mkRecordSort(typeIds); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1353:5: BITVECTOR_TOK LPAREN k= numeral RPAREN
        	    {
        	         MATCHT(BITVECTOR_TOK, &FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4219);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4221);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4225);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4227);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(k == 0) {
        	                    PARSER_STATE->parseError("Illegal bitvector size: 0");
        	                  }
        	                  t = SOLVER->mkBitVectorSort(k);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1361:5: STRING_TOK
        	    {
        	         MATCHT(STRING_TOK, &FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4246);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->getStringSort(); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1364:5: BOOLEAN_TOK
        	    {
        	         MATCHT(BOOLEAN_TOK, &FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4261);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->getBooleanSort(); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1365:5: REAL_TOK
        	    {
        	         MATCHT(REAL_TOK, &FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4269);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->getRealSort(); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1366:5: INT_TOK
        	    {
        	         MATCHT(INT_TOK, &FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4277);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = SOLVER->getIntegerSort(); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1371:5: LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4292);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4294);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             types.push_back(t); 
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1372:5: ( COMMA type[t,check] )*

        	        for (;;)
        	        {
        	            int alt54=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt54=1;
        	            	}
        	                break;

        	            }

        	            switch (alt54)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1372:7: COMMA type[t,check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4305);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4307);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             lhs = true; types.push_back(t); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop54;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop54: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4315);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) { t = SOLVER->mkTupleSort(types); }
        	                  // if !lhs, t is already set up correctly, nothing to do..
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypePossiblyFunctionLHSEx; /* Prevent compiler warnings */
    rulerestrictedTypePossiblyFunctionLHSEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedTypePossiblyFunctionLHS */

/**
 * $ANTLR start parameterization
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1378:1: parameterization[CVC4::parser::DeclarationCheck check,\n std::vector<CVC4::api::Sort>& params] : LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET ;
 */
static void
parameterization(pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::api::Sort>& params)
{
    /* Initialize rule variables
     */


      api::Sort t;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1383:3: ( LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1383:5: LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_parameterization4340);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization4342);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1384:5: ( COMMA restrictedType[t,check] )*

            for (;;)
            {
                int alt56=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt56=1;
                	}
                    break;

                }

                switch (alt56)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1384:7: COMMA restrictedType[t,check]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_parameterization4353);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization4355);
            	        restrictedType(ctx, t, check);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop56;	/* break out of the loop */
            	    break;
                }
            }
            loop56: ; /* Jump out to here if this rule does not match */


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_parameterization4363);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleparameterizationEx; /* Prevent compiler warnings */
    ruleparameterizationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end parameterization */

/**
 * $ANTLR start bound
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1387:1: bound : ( UNDERSCORE | integer );
 */
static void
bound(pCvcParser ctx)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1388:3: ( UNDERSCORE | integer )

            ANTLR3_UINT32 alt57;

            alt57=2;

            switch ( LA(1) )
            {
            case UNDERSCORE:
            	{
            		alt57=1;
            	}
                break;
            case INTEGER_LITERAL:
            case MINUS_TOK:
            	{
            		alt57=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 57;
                EXCEPTION->state        = 0;


                goto ruleboundEx;

            }

            switch (alt57)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1388:5: UNDERSCORE
        	    {
        	         MATCHT(UNDERSCORE, &FOLLOW_UNDERSCORE_in_bound4376);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1389:5: integer
        	    {
        	        FOLLOWPUSH(FOLLOW_integer_in_bound4382);
        	        integer(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleboundEx; /* Prevent compiler warnings */
    ruleboundEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bound */

/**
 * $ANTLR start typeLetDecl
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1392:1: typeLetDecl[CVC4::parser::DeclarationCheck check] : identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] ;
 */
static void
typeLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      api::Sort t;
      std::string id;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1397:3: ( identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1397:5: identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_typeLetDecl4399);
            identifier(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1397:40: ( COLON TYPE_TOK )?
            {
                int alt58=2;
                switch ( LA(1) )
                {
                    case COLON:
                    	{
                    		alt58=1;
                    	}
                        break;
                }

                switch (alt58)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1397:41: COLON TYPE_TOK
            	    {
            	         MATCHT(COLON, &FOLLOW_COLON_in_typeLetDecl4403);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_typeLetDecl4405);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_typeLetDecl4409);
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_typeLetDecl4411);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->defineType(id, t); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletypeLetDeclEx; /* Prevent compiler warnings */
    ruletypeLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeLetDecl */

/**
 * $ANTLR start formula
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1408:1: formula[CVC4::api::Term& f] : n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static void
formula(pCvcParser ctx, CVC4::api::Term& f)
{
    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */


      Debug("parser-extra") << "formula: " << AntlrInput::tokenText(LT(1)) << std::endl;
      api::Term f2;
      std::vector<CVC4::api::Term> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1416:3: (n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1416:5: n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_nots_in_formula4441);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleformulaEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1417:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt60=2;
                switch ( LA(1) )
                {
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA_TOK:
                case LET_TOK:
                	{
                		alt60=1;
                	}
                    break;
                case ABS_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case REGEXP_COMPLEMENT_TOK:
                case REGEXP_CONCAT_TOK:
                case REGEXP_EMPTY_TOK:
                case REGEXP_INTER_TOK:
                case REGEXP_LOOP_TOK:
                case REGEXP_OPT_TOK:
                case REGEXP_PLUS_TOK:
                case REGEXP_RANGE_TOK:
                case REGEXP_SIGMA_TOK:
                case REGEXP_STAR_TOK:
                case REGEXP_UNION_TOK:
                case SETS_CARD_TOK:
                case SETS_CHOOSE_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_ALL_TOK:
                case STRING_REPLACE_TOK:
                case STRING_REV_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_TOLOWER_TOK:
                case STRING_TOUPPER_TOK:
                case STRING_TO_REGEXP_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt60=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 60;
                    EXCEPTION->state        = 0;


                    goto ruleformulaEx;

                }

                switch (alt60)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1417:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_formula4449);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(SOLVER, n, f); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1419:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_formula4466);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(SOLVER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1423:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt59=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case OR_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt59=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt59)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1423:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_formula4483);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleformulaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	        if ( BACKTRACKING==0 )
            	        {

            	                    f = createPrecedenceTree(PARSER_STATE, SOLVER, expressions, operators);
            	                  
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruleformulaEx; /* Prevent compiler warnings */
    ruleformulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end formula */

/**
 * $ANTLR start morecomparisons
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1430:1: morecomparisons[std::vector<CVC4::api::Term>& expressions,\n std::vector<unsigned>& operators] returns [size_t i = 0] : booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static size_t
morecomparisons(pCvcParser ctx, std::vector<CVC4::api::Term>& expressions, std::vector<unsigned>& operators)
{
    size_t i;


    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */
    i =  0;



      unsigned op;
      api::Term f;
      i= expressions.size();


    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1437:3: ( booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1437:5: booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_booleanBinop_in_morecomparisons4522);
            booleanBinop(ctx, op);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            if ( BACKTRACKING==0 )
            {
                 operators.push_back(op); 
            }


            FOLLOWPUSH(FOLLOW_nots_in_morecomparisons4533);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1439:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt62=2;
                switch ( LA(1) )
                {
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA_TOK:
                case LET_TOK:
                	{
                		alt62=1;
                	}
                    break;
                case ABS_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case REGEXP_COMPLEMENT_TOK:
                case REGEXP_CONCAT_TOK:
                case REGEXP_EMPTY_TOK:
                case REGEXP_INTER_TOK:
                case REGEXP_LOOP_TOK:
                case REGEXP_OPT_TOK:
                case REGEXP_PLUS_TOK:
                case REGEXP_RANGE_TOK:
                case REGEXP_SIGMA_TOK:
                case REGEXP_STAR_TOK:
                case REGEXP_UNION_TOK:
                case SETS_CARD_TOK:
                case SETS_CHOOSE_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_ALL_TOK:
                case STRING_REPLACE_TOK:
                case STRING_REV_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_TOLOWER_TOK:
                case STRING_TOUPPER_TOK:
                case STRING_TO_REGEXP_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt62=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return i;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 62;
                    EXCEPTION->state        = 0;


                    goto rulemorecomparisonsEx;

                }

                switch (alt62)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1439:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_morecomparisons4541);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(addNots(SOLVER, n, f)); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1441:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_morecomparisons4558);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(SOLVER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1445:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt61=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case OR_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt61=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt61)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1445:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_morecomparisons4575);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulemorecomparisonsEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return i;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulemorecomparisonsEx; /* Prevent compiler warnings */
    rulemorecomparisonsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return i;
}
/* $ANTLR end morecomparisons */

/**
 * $ANTLR start nots
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1450:1: nots returns [size_t n = 0] : ( NOT_TOK )* ;
 */
static size_t
nots(pCvcParser ctx)
{
    size_t n;


    /* Initialize rule variables
     */
    n =  0;


    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1451:3: ( ( NOT_TOK )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1451:5: ( NOT_TOK )*
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1451:5: ( NOT_TOK )*

            for (;;)
            {
                int alt63=2;
                switch ( LA(1) )
                {
                case NOT_TOK:
                	{
                		alt63=1;
                	}
                    break;

                }

                switch (alt63)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1451:7: NOT_TOK
            	    {
            	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_nots4604);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenotsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return n;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             ++n
            	            ; 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop63;	/* break out of the loop */
            	    break;
                }
            }
            loop63: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulenotsEx; /* Prevent compiler warnings */
    rulenotsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return n;
}
/* $ANTLR end nots */

/**
 * $ANTLR start prefixFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1454:1: prefixFormula[CVC4::api::Term& f] : ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA_TOK LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] );
 */
static void
prefixFormula(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      std::vector<api::Term> terms;
      std::vector<api::Sort> types;
      std::vector<api::Term> bvs;
      api::Sort t;
      api::Kind k;
      api::Term ipl;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1465:3: ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA_TOK LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] )

            ANTLR3_UINT32 alt68;

            alt68=3;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            case FORALL_TOK:
            	{
            		alt68=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt68=2;
            	}
                break;
            case LAMBDA_TOK:
            	{
            		alt68=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 68;
                EXCEPTION->state        = 0;


                goto ruleprefixFormulaEx;

            }

            switch (alt68)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1465:5: ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f]
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1465:5: ( FORALL_TOK | EXISTS_TOK )
        	        {
        	            int alt64=2;
        	            switch ( LA(1) )
        	            {
        	            case FORALL_TOK:
        	            	{
        	            		alt64=1;
        	            	}
        	                break;
        	            case EXISTS_TOK:
        	            	{
        	            		alt64=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 64;
        	                EXCEPTION->state        = 0;


        	                goto ruleprefixFormulaEx;

        	            }

        	            switch (alt64)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1465:7: FORALL_TOK
        	        	    {
        	        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_prefixFormula4636);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = api::FORALL; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1465:41: EXISTS_TOK
        	        	    {
        	        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_prefixFormula4642);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = api::EXISTS; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4654);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4660);
        	        boundVarDecl(ctx, ids, t);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	                    bvs.push_back(PARSER_STATE->bindBoundVar(*i, t));
        	                  }
        	                  ids.clear();
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1473:5: ( COMMA boundVarDecl[ids,t] )*

        	        for (;;)
        	        {
        	            int alt65=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt65=1;
        	            	}
        	                break;

        	            }

        	            switch (alt65)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1473:7: COMMA boundVarDecl[ids,t]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4675);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4677);
        	        	        boundVarDecl(ctx, ids, t);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {

        	        	                    for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	        	                      bvs.push_back(PARSER_STATE->bindBoundVar(*i, t));
        	        	                    }
        	        	                    ids.clear();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop65;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop65: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4695);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  terms.push_back( MK_TERM( api::BOUND_VAR_LIST, bvs ) ); 
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4703);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1482:11: ( instantiationPatterns[ipl] )?
        	        {
        	            int alt66=2;
        	            switch ( LA(1) )
        	            {
        	                case PATTERN_TOK:
        	                	{
        	                		alt66=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt66)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1482:11: instantiationPatterns[ipl]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_instantiationPatterns_in_prefixFormula4705);
        	        	        instantiationPatterns(ctx, ipl);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4709);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  terms.push_back(f);
        	                  if(! ipl.isNull()) {
        	                    terms.push_back(ipl);
        	                  }
        	                  f = MK_TERM(k, terms);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1494:5: LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_prefixFormula4728);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4736);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1495:13: ( COMMA letDecl )*

        	        for (;;)
        	        {
        	            int alt67=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt67=1;
        	            	}
        	                break;

        	            }

        	            switch (alt67)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1495:15: COMMA letDecl
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4740);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4742);
        	        	        letDecl(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop67;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop67: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_prefixFormula4751);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4753);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1499:5: LAMBDA_TOK LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f]
        	    {
        	         MATCHT(LAMBDA_TOK, &FOLLOW_LAMBDA_TOK_in_prefixFormula4768);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4772);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDeclsReturn_in_prefixFormula4778);
        	        boundVarDeclsReturn(ctx, terms, types);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4785);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4787);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4789);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  api::Term bvl = MK_TERM( api::BOUND_VAR_LIST, terms );
        	                  f = MK_TERM( api::LAMBDA, bvl, f );
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleprefixFormulaEx; /* Prevent compiler warnings */
    ruleprefixFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end prefixFormula */

/**
 * $ANTLR start instantiationPatterns
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1508:1: instantiationPatterns[ CVC4::api::Term& expr ] : ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ ;
 */
static void
instantiationPatterns(pCvcParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */


      std::vector<api::Term> args;
      api::Term f;
      std::vector<api::Term> patterns;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1514:3: ( ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1514:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1514:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
            {
                int cnt70=0;

                for (;;)
                {
                    int alt70=2;
            	switch ( LA(1) )
            	{
            	case PATTERN_TOK:
            		{
            			alt70=1;
            		}
            	    break;

            	}

            	switch (alt70)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1514:7: PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON
            	        {
            	             MATCHT(PATTERN_TOK, &FOLLOW_PATTERN_TOK_in_instantiationPatterns4817);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(LPAREN, &FOLLOW_LPAREN_in_instantiationPatterns4819);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4821);
            	            formula(ctx, f);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 args.push_back( f ); 
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1514:62: ( COMMA formula[f] )*

            	            for (;;)
            	            {
            	                int alt69=2;
            	                switch ( LA(1) )
            	                {
            	                case COMMA:
            	                	{
            	                		alt69=1;
            	                	}
            	                    break;

            	                }

            	                switch (alt69)
            	                {
            	            	case 1:
            	            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1514:63: COMMA formula[f]
            	            	    {
            	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_instantiationPatterns4827);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4829);
            	            	        formula(ctx, f);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        if ( BACKTRACKING==0 )
            	            	        {
            	            	             args.push_back( f ); 
            	            	        }


            	            	    }
            	            	    break;

            	            	default:
            	            	    goto loop69;	/* break out of the loop */
            	            	    break;
            	                }
            	            }
            	            loop69: ; /* Jump out to here if this rule does not match */


            	             MATCHT(RPAREN, &FOLLOW_RPAREN_in_instantiationPatterns4837);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(COLON, &FOLLOW_COLON_in_instantiationPatterns4839);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 patterns.push_back( MK_TERM( api::INST_PATTERN, args ) );
            	                        args.clear();
            	                      
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt70 >= 1 )
            		{
            		    goto loop70;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruleinstantiationPatternsEx;
            	}
            	cnt70++;
                }
                loop70: ;	/* Jump to here if this rule does not match */
            }

            if ( BACKTRACKING==0 )
            {
                 if(! patterns.empty()) {
                       expr = MK_TERM( api::INST_PATTERN_LIST, patterns );
                       }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleinstantiationPatternsEx; /* Prevent compiler warnings */
    ruleinstantiationPatternsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end instantiationPatterns */

/**
 * $ANTLR start letDecl
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1527:1: letDecl : identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] ;
 */
static void
letDecl(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      api::Term e;
      std::string name;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1532:3: ( identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1532:5: identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_letDecl4876);
            identifier(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_letDecl4879);
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_letDecl4881);
            formula(ctx, e);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {

                      Debug("parser") << language::SetLanguage(language::output::LANG_CVC4)
                                      << e.getSort() << std::endl;
                      PARSER_STATE->defineVar(name, e);
                      Debug("parser") << "LET[" << PARSER_STATE->scopeLevel() << "]: "
                                      << name << std::endl
                                      << " ==>" << " " << e << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleletDeclEx; /* Prevent compiler warnings */
    ruleletDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end letDecl */

/**
 * $ANTLR start booleanBinop
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1543:1: booleanBinop[unsigned& op] : ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK );
 */
static void
booleanBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1547:3: ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == AND_TOK || LA(1) == IFF_TOK || LA(1) == IMPLIES_TOK || LA(1) == OR_TOK || LA(1) == XOR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebooleanBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebooleanBinopEx; /* Prevent compiler warnings */
    rulebooleanBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end booleanBinop */

/**
 * $ANTLR start comparison
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1554:1: comparison[CVC4::api::Term& f] : term[f] ( comparisonBinop[op] term[f] )* ;
 */
static void
comparison(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::api::Term> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1560:3: ( term[f] ( comparisonBinop[op] term[f] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1560:5: term[f] ( comparisonBinop[op] term[f] )*
        {
            FOLLOWPUSH(FOLLOW_term_in_comparison4950);
            term(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulecomparisonEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1561:5: ( comparisonBinop[op] term[f] )*

            for (;;)
            {
                int alt71=2;
                switch ( LA(1) )
                {
                case DISEQUAL_TOK:
                case EQUAL_TOK:
                case FMF_CARD_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case LEQ_TOK:
                case LT_TOK:
                case MEMBER_TOK:
                	{
                		alt71=1;
                	}
                    break;

                }

                switch (alt71)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1561:7: comparisonBinop[op] term[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_comparisonBinop_in_comparison4961);
            	        comparisonBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_comparison4964);
            	        term(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop71;	/* break out of the loop */
            	    break;
                }
            }
            loop71: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, SOLVER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonEx; /* Prevent compiler warnings */
    rulecomparisonEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparison */

/**
 * $ANTLR start comparisonBinop
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1566:1: comparisonBinop[unsigned& op] : ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK | FMF_CARD_TOK );
 */
static void
comparisonBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1570:3: ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK | FMF_CARD_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DISEQUAL_TOK || LA(1) == EQUAL_TOK || LA(1) == FMF_CARD_TOK || LA(1) == GEQ_TOK || LA(1) == GT_TOK || LA(1) == LEQ_TOK || ((LA(1) >= LT_TOK) && (LA(1) <= MEMBER_TOK)) )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulecomparisonBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonBinopEx; /* Prevent compiler warnings */
    rulecomparisonBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparisonBinop */

/**
 * $ANTLR start arithmeticBinop
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1580:1: arithmeticBinop[unsigned& op] : ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK );
 */
static void
arithmeticBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1584:3: ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DIV_TOK || LA(1) == EXP_TOK || LA(1) == INTDIV_TOK || ((LA(1) >= MINUS_TOK) && (LA(1) <= MOD_TOK)) || LA(1) == PLUS_TOK || LA(1) == STAR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulearithmeticBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearithmeticBinopEx; /* Prevent compiler warnings */
    rulearithmeticBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arithmeticBinop */

/**
 * $ANTLR start term
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1594:1: term[CVC4::api::Term& f] : uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* ) ;
 */
static void
term(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::api::Term> expressions;
      std::vector<unsigned> operators;
      unsigned op;
      api::Sort t;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1601:3: ( uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1601:5: uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* )
        {
            FOLLOWPUSH(FOLLOW_uminusTerm_in_term5119);
            uminusTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1602:5: ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* )
            {
                int alt78=2;
                switch ( LA(1) )
                {
                case WITH_TOK:
                	{
                		alt78=1;
                	}
                    break;
                case EOF:
                case ABS_TOK:
                case AND_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case COLON:
                case COMMA:
                case DECIMAL_LITERAL:
                case DISEQUAL_TOK:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case DIV_TOK:
                case ELSEIF_TOK:
                case ELSE_TOK:
                case ENDIF_TOK:
                case EQUAL_TOK:
                case EXISTS_TOK:
                case EXP_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case FMF_CARD_TOK:
                case FORALL_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case HASHPAREN:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IFF_TOK:
                case IF_TOK:
                case IMPLIES_TOK:
                case INTDIV_TOK:
                case INTEGER_LITERAL:
                case IN_TOK:
                case IS_INTEGER_TOK:
                case LAMBDA_TOK:
                case LBRACE:
                case LBRACKET:
                case LEQ_TOK:
                case LET_TOK:
                case LPAREN:
                case LT_TOK:
                case MEMBER_TOK:
                case MINUS_TOK:
                case MOD_TOK:
                case NOT_TOK:
                case OR_TOK:
                case PARENHASH:
                case PLUS_TOK:
                case RBRACE:
                case RBRACKET:
                case REGEXP_COMPLEMENT_TOK:
                case REGEXP_CONCAT_TOK:
                case REGEXP_EMPTY_TOK:
                case REGEXP_INTER_TOK:
                case REGEXP_LOOP_TOK:
                case REGEXP_OPT_TOK:
                case REGEXP_PLUS_TOK:
                case REGEXP_RANGE_TOK:
                case REGEXP_SIGMA_TOK:
                case REGEXP_STAR_TOK:
                case REGEXP_UNION_TOK:
                case RPAREN:
                case SEMICOLON:
                case SETS_CARD_TOK:
                case SETS_CHOOSE_TOK:
                case STAR_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_ALL_TOK:
                case STRING_REPLACE_TOK:
                case STRING_REV_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_TOLOWER_TOK:
                case STRING_TOUPPER_TOK:
                case STRING_TO_REGEXP_TOK:
                case SX_TOK:
                case THEN_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                case XOR_TOK:
                	{
                		alt78=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 78;
                    EXCEPTION->state        = 0;


                    goto ruletermEx;

                }

                switch (alt78)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1602:7: WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	    {
            	         MATCHT(WITH_TOK, &FOLLOW_WITH_TOK_in_term5128);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1603:7: ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	        {
            	            int alt76=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt76=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt76=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 76;
            	                EXCEPTION->state        = 0;


            	                goto ruletermEx;

            	            }

            	            switch (alt76)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1603:9: arrayStore[f] ( COMMA arrayStore[f] )*
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_term5138);
            	        	        arrayStore(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1603:23: ( COMMA arrayStore[f] )*

            	        	        for (;;)
            	        	        {
            	        	            int alt72=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case COMMA:
            	        	            	{
            	        	            		alt72=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt72)
            	        	            {
            	        	        	case 1:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1603:25: COMMA arrayStore[f]
            	        	        	    {
            	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5143);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_term5145);
            	        	        	        arrayStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop72;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop72: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1604:9: DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5159);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1604:13: ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	        {
            	        	            int alt75=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt75=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt75=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 75;
            	        	                EXCEPTION->state        = 0;


            	        	                goto ruletermEx;

            	        	            }

            	        	            switch (alt75)
            	        	            {
            	        	        	case 1:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1604:15: tupleStore[f] ( COMMA DOT tupleStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_term5163);
            	        	        	        tupleStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1604:29: ( COMMA DOT tupleStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt73=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		alt73=1;
            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt73)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1604:31: COMMA DOT tupleStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5168);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5170);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_term5172);
            	        	        	        	        tupleStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop73;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop73: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1605:15: recordStore[f] ( COMMA DOT recordStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_term5192);
            	        	        	        recordStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1605:30: ( COMMA DOT recordStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt74=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		alt74=1;
            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt74)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1605:32: COMMA DOT recordStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5197);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5199);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_term5201);
            	        	        	        	        recordStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop74;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop74: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1606:7: ( arithmeticBinop[op] uminusTerm[f] )*
            	    {
            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(f); 
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1607:7: ( arithmeticBinop[op] uminusTerm[f] )*

            	        for (;;)
            	        {
            	            int alt77=2;
            	            switch ( LA(1) )
            	            {
            	            case MINUS_TOK:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case BVNEG_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSPOSE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSCLOSURE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TUPLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IDEN_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNAND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVCOMP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUMINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVPLUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSUB_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVMULT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSMOD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSHL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVASHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLSHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SX_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVZEROEXTEND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVREPEAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONCAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LENGTH_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONTAINS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUBSTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CHARAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_INDEXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REPLACE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REPLACE_ALL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_PREFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUFFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_STOI_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_ITOS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_TO_REGEXP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_TOLOWER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_TOUPPER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_CONCAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_UNION_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_INTER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_STAR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_PLUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_OPT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_RANGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_LOOP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_COMPLEMENT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_EMPTY_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case REGEXP_SIGMA_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case STRING_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case SETS_CARD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SETS_CHOOSE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case NOT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LPAREN:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case PARENHASH:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case HASHPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LBRACE:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case UNIVSET_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case BAR:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ARRAY_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRUE_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case FALSE_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case DECIMAL_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case INTEGER_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case HEX_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case BINARY_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case IDENTIFIER:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case FLOOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IS_INTEGER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ABS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case DIVISIBLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case DISTINCT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case MINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;

            	            		}

            	            	}
            	                break;
            	            case DIV_TOK:
            	            case EXP_TOK:
            	            case INTDIV_TOK:
            	            case MOD_TOK:
            	            case PLUS_TOK:
            	            case STAR_TOK:
            	            	{
            	            		alt77=1;
            	            	}
            	                break;

            	            }

            	            switch (alt77)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1607:9: arithmeticBinop[op] uminusTerm[f]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arithmeticBinop_in_term5227);
            	        	        arithmeticBinop(ctx, op);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_uminusTerm_in_term5230);
            	        	        uminusTerm(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             operators.push_back(op); expressions.push_back(f); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop77;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop77: ; /* Jump out to here if this rule does not match */


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = createPrecedenceTree(PARSER_STATE, SOLVER, expressions, operators); 
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start arrayStore
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1616:1: arrayStore[CVC4::api::Term& f] : LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
arrayStore(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      api::Term f2, k;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1620:3: ( LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1620:5: LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_arrayStore5271);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_arrayStore5273);
            formula(ctx, k);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_arrayStore5276);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 f2 = MK_TERM(CVC4::api::SELECT, f, k); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1622:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt81=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt81=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt81=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 81;
                    EXCEPTION->state        = 0;


                    goto rulearrayStoreEx;

                }

                switch (alt81)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1622:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1622:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt80=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt80=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt80=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 80;
            	                EXCEPTION->state        = 0;


            	                goto rulearrayStoreEx;

            	            }

            	            switch (alt80)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1622:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_arrayStore5292);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulearrayStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1623:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_arrayStore5303);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulearrayStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1623:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt79=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt79=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt79=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 79;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulearrayStoreEx;

            	        	            }

            	        	            switch (alt79)
            	        	            {
            	        	        	case 1:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1623:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_arrayStore5307);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulearrayStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1624:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_arrayStore5324);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulearrayStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1625:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_arrayStore5337);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulearrayStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_arrayStore5339);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulearrayStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_TERM(CVC4::api::STORE, f, k, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearrayStoreEx; /* Prevent compiler warnings */
    rulearrayStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arrayStore */

/**
 * $ANTLR start tupleStore
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1633:1: tupleStore[CVC4::api::Term& f] : k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
tupleStore(pCvcParser ctx, CVC4::api::Term& f)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      api::Term f2;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1637:3: (k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1637:5: k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
            FOLLOWPUSH(FOLLOW_numeral_in_tupleStore5371);
            k=numeral(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletupleStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 api::Sort t = f.getSort();
                      if(! t.isTuple()) {
                        PARSER_STATE->parseError("tuple-update applied to non-tuple");
                      }
                      size_t length = t.getTupleLength();
                      if(k >= length) {
                        std::stringstream ss;
                        ss << "tuple is of length " << length << "; cannot update index " << k;
                        PARSER_STATE->parseError(ss.str());
                      }
                      const Datatype & dt = ((DatatypeType)t.getType()).getDatatype();
                      f2 = SOLVER->mkTerm(
                          api::APPLY_SELECTOR, api::Term(SOLVER, dt[0][k].getSelector()), f);
                    
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1652:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt84=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt84=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt84=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 84;
                    EXCEPTION->state        = 0;


                    goto ruletupleStoreEx;

                }

                switch (alt84)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1652:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1652:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt83=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt83=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt83=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 83;
            	                EXCEPTION->state        = 0;


            	                goto ruletupleStoreEx;

            	            }

            	            switch (alt83)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1652:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_tupleStore5387);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletupleStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1653:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_tupleStore5398);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletupleStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1653:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt82=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt82=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt82=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 82;
            	        	                EXCEPTION->state        = 0;


            	        	                goto ruletupleStoreEx;

            	        	            }

            	        	            switch (alt82)
            	        	            {
            	        	        	case 1:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1653:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_tupleStore5402);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletupleStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1654:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_tupleStore5419);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletupleStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1655:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_tupleStore5432);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletupleStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_tupleStore5434);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletupleStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = SOLVER->mkTerm(SOLVER->mkOp(api::TUPLE_UPDATE,k), f, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletupleStoreEx; /* Prevent compiler warnings */
    ruletupleStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tupleStore */

/**
 * $ANTLR start recordStore
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1663:1: recordStore[CVC4::api::Term& f] : identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
recordStore(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      std::string id;
      api::Term f2;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1668:3: ( identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1668:5: identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
            FOLLOWPUSH(FOLLOW_identifier_in_recordStore5464);
            identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 api::Sort t = f.getSort();
                      if(! t.isRecord()) {
                        std::stringstream ss;
                        ss << "record-update applied to non-record term" << std::endl
                           << "the term: " << f << std::endl
                           << "its type: " << t;
                        PARSER_STATE->parseError(ss.str());
                      }
                      const Record& rec = ((DatatypeType)t.getType()).getRecord();
                      if(! rec.contains(id)) {
                        PARSER_STATE->parseError(std::string("no such field `") + id + "' in record");
                      }
                      const Datatype & dt = ((DatatypeType)t.getType()).getDatatype();
                      f2 = SOLVER->mkTerm(
                          api::APPLY_SELECTOR, api::Term(SOLVER, dt[0][id].getSelector()), f);
                    
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1685:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt87=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt87=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt87=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 87;
                    EXCEPTION->state        = 0;


                    goto rulerecordStoreEx;

                }

                switch (alt87)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1685:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1685:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt86=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt86=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt86=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 86;
            	                EXCEPTION->state        = 0;


            	                goto rulerecordStoreEx;

            	            }

            	            switch (alt86)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1685:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_recordStore5481);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulerecordStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1686:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_recordStore5492);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulerecordStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1686:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt85=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt85=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt85=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 85;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulerecordStoreEx;

            	        	            }

            	        	            switch (alt85)
            	        	            {
            	        	        	case 1:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1686:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_recordStore5496);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulerecordStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1687:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_recordStore5513);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulerecordStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1688:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_recordStore5526);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerecordStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_recordStore5528);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerecordStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = SOLVER->mkTerm(SOLVER->mkOp(api::RECORD_UPDATE,id), f, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerecordStoreEx; /* Prevent compiler warnings */
    rulerecordStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end recordStore */

/**
 * $ANTLR start uminusTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1693:1: uminusTerm[CVC4::api::Term& f] : ( MINUS_TOK )* bvBinaryOpTerm[f] ;
 */
static void
uminusTerm(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      unsigned minusCount = 0;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1698:3: ( ( MINUS_TOK )* bvBinaryOpTerm[f] )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1698:5: ( MINUS_TOK )* bvBinaryOpTerm[f]
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1698:5: ( MINUS_TOK )*

            for (;;)
            {
                int alt88=2;
                switch ( LA(1) )
                {
                case MINUS_TOK:
                	{
                		alt88=1;
                	}
                    break;

                }

                switch (alt88)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1698:6: MINUS_TOK
            	    {
            	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_uminusTerm5565);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleuminusTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             ++minusCount; 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop88;	/* break out of the loop */
            	    break;
                }
            }
            loop88: ; /* Jump out to here if this rule does not match */


            FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm5571);
            bvBinaryOpTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleuminusTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {

                      while (minusCount > 0)
                      {
                        --minusCount;
                        f = MK_TERM(CVC4::api::UMINUS, f);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleuminusTermEx; /* Prevent compiler warnings */
    ruleuminusTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end uminusTerm */

/**
 * $ANTLR start bvBinaryOpTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1708:1: bvBinaryOpTerm[CVC4::api::Term& f] : bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* ;
 */
static void
bvBinaryOpTerm(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::api::Term> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1714:3: ( bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1714:5: bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )*
        {
            FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5596);
            bvNegTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulebvBinaryOpTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1715:5: ( bvBinop[op] bvNegTerm[f] )*

            for (;;)
            {
                int alt89=2;
                switch ( LA(1) )
                {
                case BAR:
                	{
                		switch ( LA(2) )
                		{
                		case BAR:
                			{
                				switch ( LA(3) )
                				{
                				case BAR:
                					{
                						alt89=1;
                					}
                				    break;

                				}

                			}
                		    break;
                		case ABS_TOK:
                		case ARRAY_TOK:
                		case BINARY_LITERAL:
                		case BVASHR_TOK:
                		case BVCOMP_TOK:
                		case BVGE_TOK:
                		case BVGT_TOK:
                		case BVLE_TOK:
                		case BVLSHR_TOK:
                		case BVLT_TOK:
                		case BVMULT_TOK:
                		case BVNAND_TOK:
                		case BVNEG_TOK:
                		case BVNOR_TOK:
                		case BVPLUS_TOK:
                		case BVREPEAT_TOK:
                		case BVROTL_TOK:
                		case BVROTR_TOK:
                		case BVSDIV_TOK:
                		case BVSGE_TOK:
                		case BVSGT_TOK:
                		case BVSHL_TOK:
                		case BVSLE_TOK:
                		case BVSLT_TOK:
                		case BVSMOD_TOK:
                		case BVSREM_TOK:
                		case BVSUB_TOK:
                		case BVUDIV_TOK:
                		case BVUMINUS_TOK:
                		case BVUREM_TOK:
                		case BVXNOR_TOK:
                		case BVXOR_TOK:
                		case BVZEROEXTEND_TOK:
                		case DECIMAL_LITERAL:
                		case DISTINCT_TOK:
                		case DIVISIBLE_TOK:
                		case FALSE_TOK:
                		case FLOOR_TOK:
                		case HEX_LITERAL:
                		case IDENTIFIER:
                		case IDEN_TOK:
                		case IF_TOK:
                		case INTEGER_LITERAL:
                		case IS_INTEGER_TOK:
                		case LBRACE:
                		case LPAREN:
                		case PARENHASH:
                		case REGEXP_COMPLEMENT_TOK:
                		case REGEXP_CONCAT_TOK:
                		case REGEXP_EMPTY_TOK:
                		case REGEXP_INTER_TOK:
                		case REGEXP_LOOP_TOK:
                		case REGEXP_OPT_TOK:
                		case REGEXP_PLUS_TOK:
                		case REGEXP_RANGE_TOK:
                		case REGEXP_SIGMA_TOK:
                		case REGEXP_STAR_TOK:
                		case REGEXP_UNION_TOK:
                		case SETS_CARD_TOK:
                		case SETS_CHOOSE_TOK:
                		case STRING_CHARAT_TOK:
                		case STRING_CONCAT_TOK:
                		case STRING_CONTAINS_TOK:
                		case STRING_INDEXOF_TOK:
                		case STRING_ITOS_TOK:
                		case STRING_LENGTH_TOK:
                		case STRING_LITERAL:
                		case STRING_PREFIXOF_TOK:
                		case STRING_REPLACE_ALL_TOK:
                		case STRING_REPLACE_TOK:
                		case STRING_REV_TOK:
                		case STRING_STOI_TOK:
                		case STRING_SUBSTR_TOK:
                		case STRING_SUFFIXOF_TOK:
                		case STRING_TOLOWER_TOK:
                		case STRING_TOUPPER_TOK:
                		case STRING_TO_REGEXP_TOK:
                		case SX_TOK:
                		case TRANSCLOSURE_TOK:
                		case TRANSPOSE_TOK:
                		case TRUE_TOK:
                		case TUPLE_TOK:
                		case UNIVSET_TOK:
                			{
                				alt89=1;
                			}
                		    break;

                		}

                	}
                    break;
                case BVAND_TOK:
                case CONCAT_TOK:
                	{
                		alt89=1;
                	}
                    break;

                }

                switch (alt89)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1715:7: bvBinop[op] bvNegTerm[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_bvBinop_in_bvBinaryOpTerm5607);
            	        bvBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5610);
            	        bvNegTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop89;	/* break out of the loop */
            	    break;
                }
            }
            loop89: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, SOLVER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinaryOpTermEx; /* Prevent compiler warnings */
    rulebvBinaryOpTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinaryOpTerm */

/**
 * $ANTLR start bvBinop
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1718:1: bvBinop[unsigned& op] : ( CONCAT_TOK | BAR | BVAND_TOK );
 */
static void
bvBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1722:3: ( CONCAT_TOK | BAR | BVAND_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == BAR || LA(1) == BVAND_TOK || LA(1) == CONCAT_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebvBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinopEx; /* Prevent compiler warnings */
    rulebvBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinop */

/**
 * $ANTLR start bvNegTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1727:1: bvNegTerm[CVC4::api::Term& f] : ( BVNEG_TOK bvNegTerm[f] | relationBinopTerm[f] );
 */
static void
bvNegTerm(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1729:3: ( BVNEG_TOK bvNegTerm[f] | relationBinopTerm[f] )

            ANTLR3_UINT32 alt90;

            alt90=2;

            switch ( LA(1) )
            {
            case BVNEG_TOK:
            	{
            		alt90=1;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case REGEXP_COMPLEMENT_TOK:
            case REGEXP_CONCAT_TOK:
            case REGEXP_EMPTY_TOK:
            case REGEXP_INTER_TOK:
            case REGEXP_LOOP_TOK:
            case REGEXP_OPT_TOK:
            case REGEXP_PLUS_TOK:
            case REGEXP_RANGE_TOK:
            case REGEXP_SIGMA_TOK:
            case REGEXP_STAR_TOK:
            case REGEXP_UNION_TOK:
            case SETS_CARD_TOK:
            case SETS_CHOOSE_TOK:
            case STRING_CHARAT_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_ALL_TOK:
            case STRING_REPLACE_TOK:
            case STRING_REV_TOK:
            case STRING_STOI_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_TOLOWER_TOK:
            case STRING_TOUPPER_TOK:
            case STRING_TO_REGEXP_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt90=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 90;
                EXCEPTION->state        = 0;


                goto rulebvNegTermEx;

            }

            switch (alt90)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1729:5: BVNEG_TOK bvNegTerm[f]
        	    {
        	         MATCHT(BVNEG_TOK, &FOLLOW_BVNEG_TOK_in_bvNegTerm5673);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvNegTerm5675);
        	        bvNegTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  f = f.getSort().isSet() ? MK_TERM(CVC4::api::COMPLEMENT, f)
        	                                          : MK_TERM(CVC4::api::BITVECTOR_NOT, f);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1734:5: relationBinopTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_relationBinopTerm_in_bvNegTerm5688);
        	        relationBinopTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebvNegTermEx; /* Prevent compiler warnings */
    rulebvNegTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvNegTerm */

/**
 * $ANTLR start relationBinop
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1737:1: relationBinop[unsigned& op] : ( JOIN_TOK | PRODUCT_TOK | JOIN_IMAGE_TOK );
 */
static void
relationBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1741:3: ( JOIN_TOK | PRODUCT_TOK | JOIN_IMAGE_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:
        {
            if ( ((LA(1) >= JOIN_IMAGE_TOK) && (LA(1) <= JOIN_TOK)) || LA(1) == PRODUCT_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulerelationBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerelationBinopEx; /* Prevent compiler warnings */
    rulerelationBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end relationBinop */

/**
 * $ANTLR start relationBinopTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1746:1: relationBinopTerm[CVC4::api::Term& f] : postfixTerm[f] ( relationBinop[op] postfixTerm[f] )* ;
 */
static void
relationBinopTerm(pCvcParser ctx, CVC4::api::Term& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::api::Term> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1752:3: ( postfixTerm[f] ( relationBinop[op] postfixTerm[f] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1752:5: postfixTerm[f] ( relationBinop[op] postfixTerm[f] )*
        {
            FOLLOWPUSH(FOLLOW_postfixTerm_in_relationBinopTerm5739);
            postfixTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerelationBinopTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1753:5: ( relationBinop[op] postfixTerm[f] )*

            for (;;)
            {
                int alt91=2;
                switch ( LA(1) )
                {
                case JOIN_IMAGE_TOK:
                case JOIN_TOK:
                case PRODUCT_TOK:
                	{
                		alt91=1;
                	}
                    break;

                }

                switch (alt91)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1753:7: relationBinop[op] postfixTerm[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_relationBinop_in_relationBinopTerm5750);
            	        relationBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerelationBinopTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_postfixTerm_in_relationBinopTerm5753);
            	        postfixTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerelationBinopTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop91;	/* break out of the loop */
            	    break;
                }
            }
            loop91: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, SOLVER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerelationBinopTermEx; /* Prevent compiler warnings */
    rulerelationBinopTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end relationBinopTerm */

/**
 * $ANTLR start postfixTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1766:1: postfixTerm[CVC4::api::Term& f] : ( relationTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? ;
 */
static void
postfixTerm(pCvcParser ctx, CVC4::api::Term& f)
{
    unsigned k1;
    #undef	RETURN_TYPE_k1
    #define	RETURN_TYPE_k1 unsigned

    unsigned k2;
    #undef	RETURN_TYPE_k2
    #define	RETURN_TYPE_k2 unsigned

    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    unsigned n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n unsigned

    /* Initialize rule variables
     */


      api::Term f2;
      bool extract = false, left = false;
      std::vector<api::Term> args;
      std::string id;
      api::Sort t;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1774:3: ( ( relationTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1774:5: ( relationTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )?
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1774:5: ( relationTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN )
            {
                int alt98=6;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case FALSE_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case LBRACE:
                case LPAREN:
                case PARENHASH:
                case REGEXP_COMPLEMENT_TOK:
                case REGEXP_CONCAT_TOK:
                case REGEXP_EMPTY_TOK:
                case REGEXP_INTER_TOK:
                case REGEXP_LOOP_TOK:
                case REGEXP_OPT_TOK:
                case REGEXP_PLUS_TOK:
                case REGEXP_RANGE_TOK:
                case REGEXP_SIGMA_TOK:
                case REGEXP_STAR_TOK:
                case REGEXP_UNION_TOK:
                case SETS_CARD_TOK:
                case SETS_CHOOSE_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_ALL_TOK:
                case STRING_REPLACE_TOK:
                case STRING_REV_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_TOLOWER_TOK:
                case STRING_TOUPPER_TOK:
                case STRING_TO_REGEXP_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt98=1;
                	}
                    break;
                case FLOOR_TOK:
                	{
                		alt98=2;
                	}
                    break;
                case IS_INTEGER_TOK:
                	{
                		alt98=3;
                	}
                    break;
                case ABS_TOK:
                	{
                		alt98=4;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt98=5;
                	}
                    break;
                case DISTINCT_TOK:
                	{
                		alt98=6;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 98;
                    EXCEPTION->state        = 0;


                    goto rulepostfixTermEx;

                }

                switch (alt98)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1774:7: relationTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*
            	    {
            	        FOLLOWPUSH(FOLLOW_relationTerm_in_postfixTerm5788);
            	        relationTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/cvc/Cvc.g:1775:5: ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*

            	        for (;;)
            	        {
            	            int alt96=5;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case IDENTIFIER:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case AND_TOK:
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case COLON:
            	            				case CONCAT_TOK:
            	            				case DISEQUAL_TOK:
            	            				case DIV_TOK:
            	            				case DOT:
            	            				case EQUAL_TOK:
            	            				case EXP_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case INTDIV_TOK:
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case LBRACKET:
            	            				case LEFTSHIFT_TOK:
            	            				case LEQ_TOK:
            	            				case LPAREN:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case OR_TOK:
            	            				case PLUS_TOK:
            	            				case PRODUCT_TOK:
            	            				case RBRACKET:
            	            				case RIGHTSHIFT_TOK:
            	            				case STAR_TOK:
            	            				case WITH_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt96=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ABS_TOK:
            	            		case ARRAY_TOK:
            	            		case BAR:
            	            		case BINARY_LITERAL:
            	            		case BVASHR_TOK:
            	            		case BVCOMP_TOK:
            	            		case BVGE_TOK:
            	            		case BVGT_TOK:
            	            		case BVLE_TOK:
            	            		case BVLSHR_TOK:
            	            		case BVLT_TOK:
            	            		case BVMULT_TOK:
            	            		case BVNAND_TOK:
            	            		case BVNEG_TOK:
            	            		case BVNOR_TOK:
            	            		case BVPLUS_TOK:
            	            		case BVREPEAT_TOK:
            	            		case BVROTL_TOK:
            	            		case BVROTR_TOK:
            	            		case BVSDIV_TOK:
            	            		case BVSGE_TOK:
            	            		case BVSGT_TOK:
            	            		case BVSHL_TOK:
            	            		case BVSLE_TOK:
            	            		case BVSLT_TOK:
            	            		case BVSMOD_TOK:
            	            		case BVSREM_TOK:
            	            		case BVSUB_TOK:
            	            		case BVUDIV_TOK:
            	            		case BVUMINUS_TOK:
            	            		case BVUREM_TOK:
            	            		case BVXNOR_TOK:
            	            		case BVXOR_TOK:
            	            		case BVZEROEXTEND_TOK:
            	            		case DECIMAL_LITERAL:
            	            		case DISTINCT_TOK:
            	            		case DIVISIBLE_TOK:
            	            		case EXISTS_TOK:
            	            		case FALSE_TOK:
            	            		case FLOOR_TOK:
            	            		case FORALL_TOK:
            	            		case HEX_LITERAL:
            	            		case IDEN_TOK:
            	            		case IF_TOK:
            	            		case INTEGER_LITERAL:
            	            		case IS_INTEGER_TOK:
            	            		case LAMBDA_TOK:
            	            		case LBRACE:
            	            		case LET_TOK:
            	            		case LPAREN:
            	            		case MINUS_TOK:
            	            		case NOT_TOK:
            	            		case PARENHASH:
            	            		case REGEXP_COMPLEMENT_TOK:
            	            		case REGEXP_CONCAT_TOK:
            	            		case REGEXP_EMPTY_TOK:
            	            		case REGEXP_INTER_TOK:
            	            		case REGEXP_LOOP_TOK:
            	            		case REGEXP_OPT_TOK:
            	            		case REGEXP_PLUS_TOK:
            	            		case REGEXP_RANGE_TOK:
            	            		case REGEXP_SIGMA_TOK:
            	            		case REGEXP_STAR_TOK:
            	            		case REGEXP_UNION_TOK:
            	            		case SETS_CARD_TOK:
            	            		case SETS_CHOOSE_TOK:
            	            		case STRING_CHARAT_TOK:
            	            		case STRING_CONCAT_TOK:
            	            		case STRING_CONTAINS_TOK:
            	            		case STRING_INDEXOF_TOK:
            	            		case STRING_ITOS_TOK:
            	            		case STRING_LENGTH_TOK:
            	            		case STRING_LITERAL:
            	            		case STRING_PREFIXOF_TOK:
            	            		case STRING_REPLACE_ALL_TOK:
            	            		case STRING_REPLACE_TOK:
            	            		case STRING_REV_TOK:
            	            		case STRING_STOI_TOK:
            	            		case STRING_SUBSTR_TOK:
            	            		case STRING_SUFFIXOF_TOK:
            	            		case STRING_TOLOWER_TOK:
            	            		case STRING_TOUPPER_TOK:
            	            		case STRING_TO_REGEXP_TOK:
            	            		case SX_TOK:
            	            		case TRANSCLOSURE_TOK:
            	            		case TRANSPOSE_TOK:
            	            		case TRUE_TOK:
            	            		case TUPLE_TOK:
            	            		case UNIVSET_TOK:
            	            			{
            	            				alt96=1;
            	            			}
            	            		    break;

            	            		}

            	            	}
            	                break;
            	            case LPAREN:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case NOT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case FORALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case FORALL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case EXISTS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LET_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case IDENTIFIER:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LAMBDA_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case MINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNEG_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSPOSE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSCLOSURE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TUPLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IDEN_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNAND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVCOMP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUMINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVPLUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSUB_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVMULT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSMOD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSHL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVASHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLSHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SX_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVZEROEXTEND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVREPEAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONCAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LENGTH_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONTAINS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUBSTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CHARAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_INDEXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REPLACE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REPLACE_ALL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_PREFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUFFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_STOI_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_ITOS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_TO_REGEXP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_TOLOWER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_TOUPPER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_CONCAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_UNION_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_INTER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_STAR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_PLUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_OPT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_RANGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_LOOP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_COMPLEMENT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_EMPTY_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LBRACKET:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LEFTSHIFT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case RIGHTSHIFT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DOT:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case COLON:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case PRODUCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case WITH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIV_TOK:
            	            				case EXP_TOK:
            	            				case INTDIV_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case PLUS_TOK:
            	            				case STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISEQUAL_TOK:
            	            				case EQUAL_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case LEQ_TOK:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case AND_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case OR_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case COMMA:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case RPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case REGEXP_SIGMA_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LBRACKET:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LEFTSHIFT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case RIGHTSHIFT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DOT:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case COLON:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case PRODUCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case WITH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIV_TOK:
            	            				case EXP_TOK:
            	            				case INTDIV_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case PLUS_TOK:
            	            				case STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISEQUAL_TOK:
            	            				case EQUAL_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case LEQ_TOK:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case AND_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case OR_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case COMMA:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case RPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LITERAL:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LBRACKET:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LEFTSHIFT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case RIGHTSHIFT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DOT:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case COLON:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case PRODUCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case WITH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIV_TOK:
            	            				case EXP_TOK:
            	            				case INTDIV_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case PLUS_TOK:
            	            				case STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISEQUAL_TOK:
            	            				case EQUAL_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case LEQ_TOK:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case AND_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case OR_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case COMMA:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case RPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SETS_CARD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SETS_CHOOSE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case NOT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_UNION_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_INTER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_STAR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_PLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_OPT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_RANGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_LOOP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_COMPLEMENT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_EMPTY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case REGEXP_SIGMA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SETS_CHOOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LPAREN:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RPAREN:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_ALL_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TO_REGEXP_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOLOWER_TOK:
            	            					{
            	            						alt96=3;
            	            					}
            	            				    break;
            	            				case STRING_TOUPPER_TOK:
            	            					{
            	            						alt96=3;
            	       