/* Generated by wayland-scanner 1.24.0 */

#ifndef COM_DEEPIN_CLIENT_MANAGEMENT_SERVER_PROTOCOL_H
#define COM_DEEPIN_CLIENT_MANAGEMENT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_com_deepin_client_management The com_deepin_client_management protocol
 * @section page_ifaces_com_deepin_client_management Interfaces
 * - @subpage page_iface_com_deepin_client_management - managemant client
 * @section page_copyright_com_deepin_client_management Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct com_deepin_client_management;

#ifndef COM_DEEPIN_CLIENT_MANAGEMENT_INTERFACE
#define COM_DEEPIN_CLIENT_MANAGEMENT_INTERFACE
/**
 * @page page_iface_com_deepin_client_management com_deepin_client_management
 * @section page_iface_com_deepin_client_management_desc Description
 *
 * This interface enables clients to get properties of all windows shown on screen via the server.
 * The server registers one clientmanagement object as a global object.
 * @section page_iface_com_deepin_client_management_api API
 * See @ref iface_com_deepin_client_management.
 */
/**
 * @defgroup iface_com_deepin_client_management The com_deepin_client_management interface
 *
 * This interface enables clients to get properties of all windows shown on screen via the server.
 * The server registers one clientmanagement object as a global object.
 */
extern const struct wl_interface com_deepin_client_management_interface;
#endif

/**
 * @ingroup iface_com_deepin_client_management
 * @struct com_deepin_client_management_interface
 */
struct com_deepin_client_management_interface {
	/**
	 * request get the window state of all clients
	 *
	 * request window state of all clients, will notify by
	 * "windows_state" event.
	 */
	void (*get_window_states)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * request window id from point
	 *
	 * Request window id at the position where cursor pointed.
	 */
	void (*get_window_from_point)(struct wl_client *client,
				      struct wl_resource *resource);
	/**
	 * show split menu
	 *
	 * Show split menu.
	 * @param x botton x pos
	 * @param y botton y pos
	 * @param width botton width
	 * @param height botton height
	 * @param wid window id
	 */
	void (*show_split_menu)(struct wl_client *client,
				struct wl_resource *resource,
				int32_t x,
				int32_t y,
				int32_t width,
				int32_t height,
				uint32_t wid);
	/**
	 * hide split menu
	 *
	 * Hide split menu.
	 * @param delay whether to delay hiding
	 */
	void (*hide_split_menu)(struct wl_client *client,
				struct wl_resource *resource,
				int32_t delay);
	/**
	 * get all window id
	 *
	 * Request window id of all clients, will notify by
	 * "all_window_id" event.
	 */
	void (*get_all_window_id)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * Request state of specific window
	 *
	 * Request state of specific window.
	 * @param window_id specific window id
	 */
	void (*get_specific_window_state)(struct wl_client *client,
					  struct wl_resource *resource,
					  uint32_t window_id);
};

#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES 0
#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_FROM_POINT 1
#define COM_DEEPIN_CLIENT_MANAGEMENT_ALL_WINDOW_ID 2
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPECIFIC_WINDOW_STATE 3

/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_FROM_POINT_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_ALL_WINDOW_ID_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPECIFIC_WINDOW_STATE_SINCE_VERSION 1

/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_WINDOW_STATES_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_WINDOW_FROM_POINT_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_SHOW_SPLIT_MENU_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_HIDE_SPLIT_MENU_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_ALL_WINDOW_ID_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_SPECIFIC_WINDOW_STATE_SINCE_VERSION 1

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an window_states event to the client owning the resource.
 * @param resource_ The client's resource
 * @param states windows information
 */
static inline void
com_deepin_client_management_send_window_states(struct wl_resource *resource_, uint32_t count, struct wl_array *states)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES, count, states);
}

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an window_from_point event to the client owning the resource.
 * @param resource_ The client's resource
 * @param window_id window id
 */
static inline void
com_deepin_client_management_send_window_from_point(struct wl_resource *resource_, uint32_t window_id)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_FROM_POINT, window_id);
}

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an all_window_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id_array window id array
 */
static inline void
com_deepin_client_management_send_all_window_id(struct wl_resource *resource_, struct wl_array *id_array)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_ALL_WINDOW_ID, id_array);
}

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an specific_window_state event to the client owning the resource.
 * @param resource_ The client's resource
 * @param pid process id
 * @param window_id window id
 * @param resource_name resource name
 * @param x window position
 * @param y window position
 * @param width window size
 * @param height window size
 * @param is_minimized is minimized
 * @param is_fullscreen is fullscreen
 * @param is_active is_active
 * @param splitable splitable
 * @param uuid window uuid
 */
static inline void
com_deepin_client_management_send_specific_window_state(struct wl_resource *resource_, int32_t pid, uint32_t window_id, const char *resource_name, int32_t x, int32_t y, int32_t width, int32_t height, int32_t is_minimized, int32_t is_fullscreen, int32_t is_active, int32_t splitable, const char *uuid)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_SPECIFIC_WINDOW_STATE, pid, window_id, resource_name, x, y, width, height, is_minimized, is_fullscreen, is_active, splitable, uuid);
}

#ifdef  __cplusplus
}
#endif

#endif
